DROP TABLE IF EXISTS `admins`;

CREATE TABLE `admins` (
  `id` smallint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `SiteName_uk` varchar(40) NOT NULL COMMENT 'Імя на сайті (онлайн бронювання)',
  `SiteName_ru` varchar(40) NOT NULL,
  `profession_uk` varchar(40) NOT NULL,
  `profession_ru` varchar(40) NOT NULL COMMENT 'Професія',
  `password` char(32) NOT NULL,
  `status` enum('1','2','3','4') NOT NULL DEFAULT '4',
  `tel` varchar(12) DEFAULT NULL,
  `tel2` varchar(12) DEFAULT NULL,
  `email` varchar(35) NOT NULL,
  `accessbyip` enum('0','1') NOT NULL DEFAULT '0',
  `ip1` varchar(15) NOT NULL,
  `ip2` varchar(15) NOT NULL,
  `ip3` varchar(15) NOT NULL,
  `accessbycookie` enum('0','1') NOT NULL DEFAULT '0',
  `cookies_list` varchar(255) NOT NULL,
  `nadaeposl` enum('0','1') NOT NULL DEFAULT '1',
  `booking_online` enum('0','1') NOT NULL DEFAULT '0' COMMENT 'Чи доступно бронювання до майстра в кабінеті самообслуговування',
  `group_id` tinyint(3) unsigned DEFAULT NULL,
  `group_id2` tinyint(3) unsigned DEFAULT NULL,
  `passw_delete_shedule` varchar(32) NOT NULL,
  `passw_create_holiday` varchar(32) NOT NULL,
  `sort` smallint(5) unsigned NOT NULL DEFAULT 0,
  `comment` varchar(100) NOT NULL,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci PACK_KEYS=0;

INSERT INTO `admins` VALUES 
(1,'Андрій (програміст)','--','','','','6f8e3acbd8d63a4b36eed3c68eab4595','1','380509183599','380679183599','benzapila@gmail.com','0','','','','0','','0','0',NULL,NULL,'698d51a19d8a121ce581499d7b701668','b53b3a3d6ab90ce0268229151c9bde11',19,'','0'),
(2,'Адміністратор Даша','','','','','12dc2be147870b3cd2038ed9a4bc53e9','2','0685918989',NULL,'','0','','','','0','','0','0',0,0,'b4b147bc522828731f1a016bfa72c073','b4b147bc522828731f1a016bfa72c073',2,'','1'),
(3,'Настя','Анастасія','','','','6409fb9a315c0b0c9474b61ef94ac875','2','380936456101','380969787401','','0','','','','0','','1','1',2,4,'6512bd43d9caa6e02c990b0a82652dca','4a3e00961a08879c34f91ca0070ea2f5',1,'','0'),
(4,'Оля','','','','','539122faa10e0f124568dde8ebd34938','4','380989718428',NULL,'','0','','','','0','','1','0',0,NULL,'','',0,'','1'),
(5,'Педикюр Наталя','Наталія Бридух','','Педикюр','','a7283780c6f8c21eee60bf38220615ee','4','380966390813',NULL,'','0','','','','0','','1','1',2,NULL,'','',8,'','0'),
(6,'Наталя Перукар','Наталія Щербакова','','Перукар','','1d26b8523ff19393e44e35f6f9906cc6','4','380500000000',NULL,'','0','','','','0','','1','1',1,3,'','',9,'','0'),
(7,'Маша','Маша Смеречинська','','Перукар','','e9f8fbef35a0443d8891d7461fa84da8','4','3885871794',NULL,'','0','','','','0','','1','1',1,3,'','',10,'','0'),
(8,'Галя','Галя Петльована','','Лешмейкер','','c96c4b390212f3dd8fc82a23c55d2f66','4','380980062678',NULL,'','0','','','','0','','1','1',5,3,'','',11,'','0'),
(9,'Оля вії','','','','','9796bfbb156b618a0ca66ef8f9fe47c0','4','380976466587',NULL,'','0','','','','0','','1','0',0,NULL,'','',14,'','1'),
(10,'Аліна_','','','','','355991c40a7136c2ef469efe3729f8a0','4','380671659245',NULL,'','0','','','','0','','1','0',3,4,'','',15,'','1'),
(11,'Віка Нігті','Вікторія Мороз','','Nail майстер','','452720551387646e146735e11ad79b5f','4','380989740290',NULL,'','0','','','','0','','1','1',2,NULL,'','',2,'','0'),
(12,'Легка Наталя','Наталія Легка','','Nail майстер','','fdc98dc93cb7a1d912418c205fd7df3f','4','380686088162',NULL,'','0','','','','0','','1','1',2,NULL,'','',5,'','0'),
(13,'Діана','','','','','452720551387646e146735e11ad79b5f','4','380680499439',NULL,'','0','','','','0','','1','0',2,NULL,'','',0,'','1'),
(14,'Христя','','','','','cf4b93e1081276279cecc8a9b798c1d1','4','380683362527',NULL,'','0','','','','0','','1','0',2,NULL,'','',0,'','1'),
(15,'Віка Мейк','','','','','0ee2ba9dbe5420a4e1c821ba53f2855d','4','380976720248',NULL,'','0','','','','0','','1','0',3,4,'','',17,'','1'),
(16,'Маряна','','','','','3dc8f035ad08807205a8a1dc997cbecc','4','380972315571',NULL,'','0','','','','0','','1','0',2,NULL,'','',0,'','1'),
(17,'Люда','Люда Ганушевська','','Nail майстер','','ac0830f6ca13de811323fce1959d62b3','4','380507081538',NULL,'','0','','','','0','','1','1',2,NULL,'','',4,'','0'),
(18,'Іра Нігті','Іра Панчук','','Nail майстер','','355991c40a7136c2ef469efe3729f8a0','4','380978310227',NULL,'','0','','','','0','','1','1',2,NULL,'','',3,'','0'),
(19,'Іра Мейк','','','','','22c3e1312adb1d40b740a126ef619404','4','380980592398',NULL,'','0','','','','0','','1','0',2,3,'','',8,'','1'),
(20,'юля вії','юля','','Лешмейкер','','1ed1cec0ae3070f749a5e66da137205e','4','380686242882',NULL,'','0','','','','0','','1','0',5,NULL,'','',12,'','0'),
(21,'аліна нігті ','аліна нігті','','Nail майстер','','1b131e7024f8567924d4e08c36e0bfff','4','380673392487','3816112020','','0','','','','0','','1','0',2,NULL,'','',6,'','0'),
(22,'Христина','Христина Чернецька','','Nail майстер','','a8c00030cd189fbbe6766a48611eea76','4','380673046520',NULL,'','0','','','','0','','1','1',2,NULL,'','',7,'','0'),
(23,'Люда масаж','Люда Штокалко','','Масажист','','12dc2be147870b3cd2038ed9a4bc53e9','4','380963571891',NULL,'','0','','','','0','','1','1',NULL,NULL,'','',14,'','1'),
(24,'Миколаівна','Світлана Миколаївна','','Косметолог, бровист','','9796bfbb156b618a0ca66ef8f9fe47c0','4','380934365155',NULL,'','0','','','','0','','1','1',7,NULL,'','',13,'','0'),
(25,'іра','','','','','12dc2be147870b3cd2038ed9a4bc53e9','4',NULL,NULL,'','0','','','','0','','1','0',5,0,'','',16,'','1'),
(26,'Наталія Адміністратор','Наталія Гвоздецька','','макіяж','','1d3e01d6c73a4a804669228fc122a5cf','3','380960695271',NULL,'','0','','','','0','','1','1',4,NULL,'698d51a19d8a121ce581499d7b701668','b4b147bc522828731f1a016bfa72c073',16,'','0'),
(27,'Катя наша','','','','','8d32b0106b22c9d1dec1df1f5c0d7ed6','4','0668725233',NULL,'','0','','','','0','','1','0',0,0,'','',0,'','1'),
(28,'Коленич Наталія','','','','','71ec2890223d3a70924ee6db38ea4466','4','380681933132',NULL,'','0','','','','0','','1','0',0,0,'','',1,'','1'),
(29,'наталя коленич','','','','','455f2e502d5792765c891aa919f0562a','4',NULL,NULL,'','0','','','','0','','1','0',0,0,'','',0,'','1'),
(30,'лаба педикюр','','','','','1055fe8fd7fb2cf2ecec6ced57fd3f49','4','0673392487',NULL,'','0','','','','0','','1','0',2,0,'','',7,'','1'),
(31,'','','','','','a4a1ae8ca86e5975d055aeabdbce43ef','4',NULL,NULL,'','0','','','','0','','1','0',NULL,NULL,'','',0,'','1'),
(32,'Зоряна','Зоряна масаж','','масажист','','97dd6c69f87be25d08767f489a57d787','4','380988651455',NULL,'','0','','','','0','','1','1',NULL,NULL,'','',14,'','0'),
(33,'ілона мейк','','','','','22c3e1312adb1d40b740a126ef619404','4','380686929739',NULL,'','0','','','','0','','1','',4,NULL,'','',15,'','0'),
(34,'ПРОДАЖІ','','','','','1d3e01d6c73a4a804669228fc122a5cf','4','380960695271',NULL,'','0','','','','0','','1','0',NULL,NULL,'','',17,'','0'),
(35,'Аліна','Аліна','','','','7c085949a7a5b637aa2beb81d5046a5e','4','380957590038',NULL,'','0','','','','0','','1','0',2,NULL,'','',8,'','1'),
(36,'Майстер Аня ','','','','','d71ba32bdf41e23ee1697959256e6f61','4','380986503933',NULL,'','0','','','','0','','1','0',NULL,NULL,'','',18,'','0');

DROP TABLE IF EXISTS `comments`;

CREATE TABLE `comments` (
  `id` mediumint(6) unsigned NOT NULL AUTO_INCREMENT,
  `father_id` mediumint(6) unsigned NOT NULL DEFAULT 0,
  `ans_kom` mediumint(6) unsigned NOT NULL DEFAULT 0,
  `user_id` mediumint(6) unsigned NOT NULL DEFAULT 0,
  `user_name` varchar(25) NOT NULL,
  `site_email` varchar(30) NOT NULL,
  `text` text NOT NULL,
  `time` int(10) unsigned NOT NULL,
  `visible` enum('0','1','2') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

DROP TABLE IF EXISTS `const`;

CREATE TABLE `const` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `value` varchar(255) NOT NULL,
  `prumitka` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_2` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Константи';

INSERT INTO `const` VALUES 
(1,'log','0',''),
(2,'next_cron_job','9999999998','Час наступного виконання завдання'),
(3,'sms_balance','0','кількість грошей на рахунку'),
(4,'send_sms','1','0-в цій конфігурації не відправляються смс, 1-відправляються'),
(5,'name_db','Головна база','назва бази головна або резерва копія'),
(6,'bkp_copy_to_external_serv','1','1-з цієї бази дані копіються на servage, 0-не копіюються'),
(7,'time_last_backup_copy','2025-09-05 13:49:21','Час останнього копіювання даних на резервну базу'),
(8,'db_status','1','1-головна база, 0-резервна база (на серваже)'),
(9,'pass_cor_rec','698d51a19d8a121ce581499d7b701668','пароль який дає можливість редагувати деяким користувачам грошові рухи в базі в md5'),
(10,'central_base_patch','---','шлях до центральної бд. (http://site-name.com)'),
(11,'IPs_backup','','пусте значення, або IP-адреси вказані через кому з яким можна віддіавати бекапи'),
(12,'send_sms_setting','1','Ввімкнення вимкнення надсилання смс в меню настройк, користувачі самі можь вмикати-вимикати смс-розсилку '),
(13,'issuance_wages_pass','1','пароль на видачу ЗП'),
(14,'ViberAuthToken','4cda0378caa7dfba-501a851ce727f353-7e2f96622dc418e6','Viber authentification Token'),
(15,'ViberSendName','Like','Viber назва відправника'),
(16,'ViberWebhook','https://like-beauty.com.ua/bots/ViberBot/index.php','Viber Webhook'),
(17,'ViberBotName','like-beauty','Назва вайбер-бота'),
(18,'ViberBotStatus','true','true or false - вкл або викл. вабер-бота'),
(19,'LastMorningSendVM','2020-12-11','Дата якої останній раз спрацьовував скрипт який відправляє ранкові вайбер повідомлення'),
(20,'ViberRestMessages','962','Залишок вайбер повідомлень'),
(21,'base','1','1-база даних на хостингу(центральна), 2-база для розробки (localhost)'),
(22,'lang_synchronization','false','true - робити синхронізацію мовного пакета на ЦБД, false - не робити'),
(23,'central_base_patch2','https://swipe.like-beauty.com.ua','Шлях до Салону Swipe');

DROP TABLE IF EXISTS `courses_booking`;

CREATE TABLE `courses_booking` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `DateTime` datetime NOT NULL,
  `name` varchar(50) NOT NULL,
  `tel` varchar(25) NOT NULL,
  `instagram` varchar(50) NOT NULL COMMENT 'Акаунт в інстаграмі',
  `numberOfCourse` tinyint(3) unsigned NOT NULL COMMENT 'Номер курса',
  `processed` enum('0','1') NOT NULL DEFAULT '0' COMMENT '0-не опрацьований, 1-опрацьований',
  `sort` smallint(5) unsigned NOT NULL DEFAULT 0,
  `comment` varchar(255) NOT NULL,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=123 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Бронювання на курси';

INSERT INTO `courses_booking` VALUES 
(1,'2021-12-07 01:29:10','тест','+380050918359','Інстр-проф',1,'1',0,'','0'),
(2,'2022-04-25 09:10:15','','','',0,'0',0,'','0'),
(3,'2022-04-28 12:17:51','','','',0,'0',0,'','0'),
(4,'2022-08-18 23:05:13','','','',0,'0',0,'','0'),
(5,'2023-01-16 18:01:41','','','',0,'0',0,'','0'),
(6,'2023-08-03 00:50:51','','','',0,'0',0,'','0'),
(7,'2023-08-03 00:50:56','','','',0,'0',0,'','0'),
(8,'2023-08-03 00:50:56','','','',0,'0',0,'','0'),
(9,'2023-08-03 00:50:56','','','',0,'0',0,'','0'),
(10,'2023-08-03 00:50:56','','','',0,'0',0,'','0'),
(11,'2023-10-12 10:56:38','','','',0,'0',0,'','0'),
(12,'2023-11-27 14:29:54','','','',0,'0',0,'','0'),
(13,'2023-11-27 14:29:55','','','',0,'0',0,'','0'),
(14,'2023-11-27 14:29:57','','','',0,'0',0,'','0'),
(15,'2023-11-27 14:29:57','','','',0,'0',0,'','0'),
(16,'2023-11-27 14:30:13','','','',0,'0',0,'','0'),
(17,'2024-01-24 18:38:07','','','',0,'0',0,'','0'),
(18,'2024-01-24 18:38:07','','','',0,'0',0,'','0'),
(19,'2024-01-24 18:38:08','','','',0,'0',0,'','0'),
(20,'2024-01-24 18:38:19','','','',0,'0',0,'','0'),
(21,'2024-01-24 18:38:19','','','',0,'0',0,'','0'),
(22,'2024-03-23 05:40:44','','','',0,'0',0,'','0'),
(23,'2024-03-23 05:41:16','','','',0,'0',0,'','0'),
(24,'2024-03-23 06:13:55','','','',0,'0',0,'','0'),
(25,'2024-03-23 06:31:01','','','',0,'0',0,'','0'),
(26,'2024-07-24 01:06:28','','','',0,'0',0,'','0'),
(27,'2024-07-24 01:09:42','','','',0,'0',0,'','0'),
(28,'2024-07-25 03:37:44','','','',0,'0',0,'','0'),
(29,'2024-07-25 03:43:13','','','',0,'0',0,'','0'),
(30,'2024-08-14 09:13:33','','','',0,'0',0,'','0'),
(31,'2024-08-14 09:13:41','','','',0,'0',0,'','0'),
(32,'2024-08-14 09:23:52','','','',0,'0',0,'','0'),
(33,'2024-08-15 17:01:22','','','',0,'0',0,'','0'),
(34,'2024-10-02 03:35:52','','','',0,'0',0,'','0'),
(35,'2024-10-12 15:15:40','','','',0,'0',0,'','0'),
(36,'2024-12-07 21:05:52','','','',0,'0',0,'','0'),
(37,'2024-12-15 22:37:29','','','',0,'0',0,'','0'),
(38,'2024-12-16 00:30:11','','','',0,'0',0,'','0'),
(39,'2024-12-16 00:30:59','','','',0,'0',0,'','0'),
(40,'2025-01-24 20:29:44','','','',0,'0',0,'','0'),
(41,'2025-01-24 20:30:26','','','',0,'0',0,'','0'),
(42,'2025-01-29 16:48:32','','','',0,'0',0,'','0'),
(43,'2025-02-25 20:29:17','','','',0,'0',0,'','0'),
(44,'2025-02-26 03:25:27','','','',0,'0',0,'','0'),
(45,'2025-03-03 07:50:22','','','',0,'0',0,'','0'),
(46,'2025-03-03 08:18:30','','','',0,'0',0,'','0'),
(47,'2025-03-05 17:57:54','','','',0,'0',0,'','0'),
(48,'2025-03-11 10:31:07','','','',0,'0',0,'','0'),
(49,'2025-04-04 16:38:21','','','',0,'0',0,'','0'),
(50,'2025-04-05 02:05:57','','','',0,'0',0,'','0'),
(51,'2025-04-15 17:19:53','','','',0,'0',0,'','0'),
(52,'2025-04-16 01:31:54','','','',0,'0',0,'','0'),
(53,'2025-05-08 22:45:03','','','',0,'0',0,'','0'),
(54,'2025-05-09 02:55:29','','','',0,'0',0,'','0'),
(55,'2025-05-10 16:58:04','','','',0,'0',0,'','0'),
(56,'2025-05-15 22:32:24','','','',0,'0',0,'','0'),
(57,'2025-05-16 02:45:04','','','',0,'0',0,'','0'),
(58,'2025-05-16 21:08:46','','','',0,'0',0,'','0'),
(59,'2025-05-22 22:37:50','','','',0,'0',0,'','0'),
(60,'2025-05-26 04:44:49','','','',0,'0',0,'','0'),
(61,'2025-05-26 04:44:50','','','',0,'0',0,'','0'),
(62,'2025-05-26 04:44:51','','','',0,'0',0,'','0'),
(63,'2025-05-26 04:44:51','','','',0,'0',0,'','0'),
(64,'2025-05-29 22:41:40','','','',0,'0',0,'','0'),
(65,'2025-06-05 22:37:23','','','',0,'0',0,'','0'),
(66,'2025-06-13 00:09:36','','','',0,'0',0,'','0'),
(67,'2025-06-13 03:05:31','','','',0,'0',0,'','0'),
(68,'2025-06-14 17:03:30','','','',0,'0',0,'','0'),
(69,'2025-06-19 01:36:47','','','',0,'0',0,'','0'),
(70,'2025-06-19 22:44:54','','','',0,'0',0,'','0'),
(71,'2025-06-25 23:08:00','','','',0,'0',0,'','0'),
(72,'2025-07-02 06:02:59','','','',0,'0',0,'','0'),
(73,'2025-07-02 22:41:28','','','',0,'0',0,'','0'),
(74,'2025-07-03 15:21:17','','','',0,'0',0,'','0'),
(75,'2025-07-03 15:21:18','','','',0,'0',0,'','0'),
(76,'2025-07-06 03:00:09','','','',0,'0',0,'','0'),
(77,'2025-07-06 14:49:08','','','',0,'0',0,'','0'),
(78,'2025-07-06 14:53:38','','','',0,'0',0,'','0'),
(79,'2025-07-09 00:19:14','','','',0,'0',0,'','0'),
(80,'2025-07-13 21:53:29','','','',0,'0',0,'','0'),
(81,'2025-07-15 17:13:43','','','',0,'0',0,'','0'),
(82,'2025-07-15 23:01:42','','','',0,'0',0,'','0'),
(83,'2025-07-16 09:01:57','','','',0,'0',0,'','0'),
(84,'2025-07-17 00:52:15','','','',0,'0',0,'','0'),
(85,'2025-07-17 04:22:27','','','',0,'0',0,'','0'),
(86,'2025-07-17 18:24:37','','','',0,'0',0,'','0'),
(87,'2025-07-18 09:11:04','','','',0,'0',0,'','0'),
(88,'2025-07-19 20:45:48','','','',0,'0',0,'','0'),
(89,'2025-07-23 04:30:41','','','',0,'0',0,'','0'),
(90,'2025-07-23 12:06:12','','','',0,'0',0,'','0'),
(91,'2025-07-25 07:22:46','','','',0,'0',0,'','0'),
(92,'2025-07-29 23:02:25','','','',0,'0',0,'','0'),
(93,'2025-08-01 18:36:33','','','',0,'0',0,'','0'),
(94,'2025-08-01 18:37:31','','','',0,'0',0,'','0'),
(95,'2025-08-05 23:15:45','','','',0,'0',0,'','0'),
(96,'2025-08-09 09:41:15','','','',0,'0',0,'','0'),
(97,'2025-08-09 09:41:18','','','',0,'0',0,'','0'),
(98,'2025-08-09 09:41:21','','','',0,'0',0,'','0'),
(99,'2025-08-12 22:41:23','','','',0,'0',0,'','0'),
(100,'2025-08-13 00:30:32','','','',0,'0',0,'','0'),
(101,'2025-08-13 00:32:06','','','',0,'0',0,'','0'),
(102,'2025-08-13 00:35:01','','','',0,'0',0,'','0'),
(103,'2025-08-18 09:26:19','','','',0,'0',0,'','0'),
(104,'2025-08-18 16:11:46','','','',0,'0',0,'','0'),
(105,'2025-08-19 22:38:01','','','',0,'0',0,'','0'),
(106,'2025-08-21 02:35:13','','','',0,'0',0,'','0'),
(107,'2025-08-23 12:05:25','','','',0,'0',0,'','0'),
(108,'2025-08-23 15:42:12','','','',0,'0',0,'','0'),
(109,'2025-08-23 15:49:30','','','',0,'0',0,'','0'),
(110,'2025-08-23 15:53:32','','','',0,'0',0,'','0'),
(111,'2025-08-23 16:52:23','','','',0,'0',0,'','0'),
(112,'2025-08-26 01:45:00','','','',0,'0',0,'','0'),
(113,'2025-08-26 22:44:26','','','',0,'0',0,'','0'),
(114,'2025-08-28 21:02:28','','','',0,'0',0,'','0'),
(115,'2025-08-30 04:22:12','','','',0,'0',0,'','0'),
(116,'2025-09-02 11:07:42','','','',0,'0',0,'','0'),
(117,'2025-09-02 11:07:47','','','',0,'0',0,'','0'),
(118,'2025-09-02 11:07:51','','','',0,'0',0,'','0'),
(119,'2025-09-02 22:50:31','','','',0,'0',0,'','0'),
(120,'2025-09-03 05:27:08','','','',0,'0',0,'','0'),
(121,'2025-09-04 13:16:29','','','',0,'0',0,'','0'),
(122,'2025-09-04 14:42:21','','','',0,'0',0,'','0');

DROP TABLE IF EXISTS `groups`;

CREATE TABLE `groups` (
  `id` smallint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name_uk` varchar(15) NOT NULL,
  `name_ru` varchar(15) NOT NULL,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Назви груп в якій обєднують майстрів';

INSERT INTO `groups` VALUES 
(1,'Перукарі','','0'),
(2,'Манікюристи','','0'),
(3,'Макіяж+Зачіска','','0'),
(4,'Макіяж','','0'),
(5,'Вії','','0'),
(6,'педикюр','','0'),
(7,'Корекція та фар','','0');

DROP TABLE IF EXISTS `history`;

CREATE TABLE `history` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `type` tinyint(2) NOT NULL,
  `element_id` varchar(6) NOT NULL,
  `text` varchar(2000) NOT NULL,
  `query` text NOT NULL,
  `hero` smallint(3) DEFAULT NULL,
  `datetime` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

DROP TABLE IF EXISTS `history_types`;

CREATE TABLE `history_types` (
  `id` tinyint(2) unsigned NOT NULL AUTO_INCREMENT,
  `name_uk` varchar(30) NOT NULL,
  `name_ru` varchar(30) NOT NULL,
  `name_el` varchar(30) NOT NULL,
  `name_en` varchar(30) NOT NULL,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Назви типів подій що реєструються в історії';

DROP TABLE IF EXISTS `homepage`;

CREATE TABLE `homepage` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL COMMENT 'Назва ключа, правила імен як і в масива PHP',
  `value_uk` varchar(10000) NOT NULL,
  `value_ru` varchar(10000) NOT NULL,
  `sort` smallint(5) unsigned NOT NULL DEFAULT 0,
  `comment` varchar(255) NOT NULL,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `homepage` VALUES 
(1,'address','м. Чортків, вул. Шевченка 16а','',0,'','0'),
(2,'tel','0672929804','0672929804',0,'','0'),
(3,'tel2','0936329533','0936329533',0,'','0'),
(4,'vblink','viber://pa?chatURI=like-beauty','viber://pa?chatURI=like-beauty',0,'','0'),
(5,'instagram','https://www.instagram.com/like_beauty_studio/','https://www.instagram.com/like_beauty_studio/',0,'','0'),
(6,'facebook','https://www.facebook.com/likebeautystudio','https://www.facebook.com/likebeautystudio',0,'','0'),
(7,'tiktok','https://www.tiktok.com/@like_beautystudio','https://www.tiktok.com/@like_beautystudio',0,'','0'),
(8,'pinterest','https://www.pinterest.com/likebeautystudiochortkiv/_saved/','https://www.pinterest.com/likebeautystudiochortkiv/_saved/',0,'','0'),
(9,'aboutPhCount','8','8',0,'Кількість фото які є в фото альбомі','0');

DROP TABLE IF EXISTS `imgroups`;

CREATE TABLE `imgroups` (
  `id` smallint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name_uk` varchar(30) NOT NULL,
  `name_ru` varchar(30) NOT NULL,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Групи категорій цін';

DROP TABLE IF EXISTS `imkatalog`;

CREATE TABLE `imkatalog` (
  `id` mediumint(5) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `fathercode` mediumint(5) NOT NULL DEFAULT 0,
  `sort` smallint(5) unsigned NOT NULL DEFAULT 0,
  `name_uk` varchar(50) NOT NULL,
  `name_ru` varchar(50) NOT NULL,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

DROP TABLE IF EXISTS `imod_vumiru`;

CREATE TABLE `imod_vumiru` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name_uk` varchar(40) NOT NULL,
  `name_ru` varchar(40) NOT NULL,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_uk` (`name_uk`),
  UNIQUE KEY `name_ru` (`name_ru`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Одиниці виміру';

DROP TABLE IF EXISTS `imorderbody`;

CREATE TABLE `imorderbody` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(6) unsigned NOT NULL DEFAULT 0,
  `tovar_id` mediumint(6) unsigned NOT NULL DEFAULT 0,
  `price` decimal(6,2) NOT NULL DEFAULT 0.00,
  `kilkist` mediumint(5) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

DROP TABLE IF EXISTS `imorderhead`;

CREATE TABLE `imorderhead` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `price_group` varchar(15) NOT NULL,
  `user_id` mediumint(6) unsigned NOT NULL DEFAULT 0,
  `guest_id` varchar(6) NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `pay_method` enum('0','1','2','3') NOT NULL DEFAULT '0',
  `status` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0',
  `comment` varchar(255) NOT NULL,
  `fio` varchar(70) NOT NULL,
  `tel` bigint(12) unsigned NOT NULL,
  `dostavka_oblast` tinyint(2) unsigned NOT NULL,
  `dostavka_rajon` varchar(30) NOT NULL,
  `dostavka_city` varchar(30) NOT NULL,
  `dostavka_vylutsia` varchar(35) NOT NULL,
  `dostavka_bydunok` varchar(5) NOT NULL,
  `dostavka_kvartura` varchar(3) NOT NULL,
  `email` varchar(40) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

DROP TABLE IF EXISTS `impictures`;

CREATE TABLE `impictures` (
  `id` mediumint(6) unsigned NOT NULL AUTO_INCREMENT,
  `fathercode` mediumint(6) unsigned NOT NULL,
  `sort` tinyint(2) unsigned NOT NULL DEFAULT 0,
  `w` smallint(5) unsigned NOT NULL DEFAULT 0,
  `h` smallint(5) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

DROP TABLE IF EXISTS `imprices`;

CREATE TABLE `imprices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_group` smallint(3) unsigned NOT NULL,
  `id_product` mediumint(6) unsigned NOT NULL,
  `price` decimal(6,2) unsigned NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

DROP TABLE IF EXISTS `improducts`;

CREATE TABLE `improducts` (
  `id` mediumint(6) unsigned NOT NULL AUTO_INCREMENT,
  `fathercode` mediumint(5) NOT NULL DEFAULT 0,
  `sort` smallint(5) unsigned NOT NULL DEFAULT 0,
  `valyta` tinyint(1) NOT NULL DEFAULT 1,
  `name_uk` varchar(255) NOT NULL,
  `opus_uk` text NOT NULL,
  `name_ru` varchar(255) NOT NULL,
  `opus_ru` text NOT NULL,
  `picture` mediumint(5) NOT NULL DEFAULT 0,
  `stocks` mediumint(5) NOT NULL DEFAULT 0,
  `status_stocks` enum('0','1','2') NOT NULL DEFAULT '0',
  `new_product` enum('0','1') NOT NULL DEFAULT '0',
  `action` enum('0','1') NOT NULL DEFAULT '0',
  `recommended` enum('0','1') NOT NULL DEFAULT '0',
  `discount` tinyint(2) NOT NULL DEFAULT 0,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

DROP TABLE IF EXISTS `imspecifications`;

CREATE TABLE `imspecifications` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name_uk` varchar(30) NOT NULL,
  `name_ru` varchar(30) NOT NULL,
  `sort` mediumint(5) unsigned NOT NULL DEFAULT 0,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Список всіх характеристик ТОВАРІВ';

DROP TABLE IF EXISTS `imspecifications_values`;

CREATE TABLE `imspecifications_values` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_product` mediumint(6) unsigned NOT NULL,
  `id_specification` smallint(5) unsigned NOT NULL,
  `value` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='значення самих характеристик для конкретної одиниці товару';

DROP TABLE IF EXISTS `imsvaz_katalog_specifications`;

CREATE TABLE `imsvaz_katalog_specifications` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `katalog_id` smallint(5) unsigned NOT NULL,
  `specification_id` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Привязка характеристик до категорій';

DROP TABLE IF EXISTS `imvalytu`;

CREATE TABLE `imvalytu` (
  `id` tinyint(1) NOT NULL AUTO_INCREMENT,
  `name_uk` varchar(10) NOT NULL,
  `name_ru` varchar(10) NOT NULL,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Грошові одиниці виміру';

DROP TABLE IF EXISTS `informer`;

CREATE TABLE `informer` (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `text_uk` varchar(255) NOT NULL,
  `text_ru` varchar(255) NOT NULL,
  `text_en` varchar(255) NOT NULL,
  `time` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Інформаційні повідомлення';

DROP TABLE IF EXISTS `issuance_wages`;

CREATE TABLE `issuance_wages` (
  `id` mediumint(6) unsigned NOT NULL AUTO_INCREMENT,
  `author` smallint(5) unsigned NOT NULL,
  `date` date NOT NULL,
  `datetime_added` datetime NOT NULL,
  `master_id` smallint(5) unsigned NOT NULL,
  `value` decimal(7,2) NOT NULL,
  `comment` varchar(255) NOT NULL,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1834 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Видача ЗП працівникам';

INSERT INTO `issuance_wages` VALUES 
(1,1,'2020-03-01','2020-03-04 21:36:50',8,20.00,'','1'),
(2,2,'2020-05-01','2020-05-15 13:24:55',10,200.00,'','0'),
(3,2,'2020-05-01','2020-05-15 13:25:02',11,200.00,'','0'),
(4,2,'2020-05-01','2020-05-15 13:25:14',8,200.00,'','1'),
(5,2,'2020-05-01','2020-05-15 13:25:21',19,200.00,'','0'),
(6,2,'2020-05-01','2020-05-15 13:25:27',18,200.00,'','0'),
(7,2,'2020-05-01','2020-05-15 13:25:33',25,200.00,'','0'),
(8,2,'2020-05-01','2020-05-15 13:25:38',21,200.00,'','0'),
(9,2,'2020-05-01','2020-05-15 13:25:44',12,200.00,'','0'),
(10,2,'2020-05-01','2020-05-15 13:26:17',17,200.00,'','0'),
(11,2,'2020-05-01','2020-05-15 13:26:23',23,200.00,'','0'),
(12,2,'2020-05-01','2020-05-15 13:26:27',7,200.00,'','0'),
(13,2,'2020-05-01','2020-05-15 13:28:44',3,200.00,'','0'),
(14,2,'2020-05-01','2020-05-15 13:28:52',6,200.00,'','0'),
(15,2,'2020-05-01','2020-05-15 13:29:01',5,200.00,'','0'),
(16,2,'2020-05-01','2020-05-22 11:29:36',10,200.00,'','0'),
(17,2,'2020-05-01','2020-05-22 11:31:17',11,200.00,'','0'),
(18,2,'2020-05-01','2020-05-22 11:31:45',8,200.00,'','0'),
(19,2,'2020-05-01','2020-05-22 11:31:50',19,200.00,'','0'),
(20,2,'2020-05-01','2020-05-22 11:31:56',18,200.00,'','0'),
(21,2,'2020-05-01','2020-05-22 11:32:02',21,200.00,'','0'),
(22,2,'2020-05-01','2020-05-22 11:32:07',12,200.00,'','0'),
(23,2,'2020-05-01','2020-05-22 11:32:12',17,200.00,'','0'),
(24,2,'2020-05-01','2020-05-22 11:32:19',7,200.00,'','0'),
(25,2,'2020-05-01','2020-05-22 11:32:27',3,200.00,'','0'),
(26,2,'2020-05-01','2020-05-22 11:32:32',6,200.00,'','0'),
(27,2,'2020-05-01','2020-05-22 11:32:38',5,200.00,'','0'),
(28,2,'2020-05-01','2020-05-23 15:35:30',6,3000.00,'','0'),
(29,2,'2020-05-01','2020-05-26 10:55:39',11,390.00,'','0'),
(30,2,'2020-05-01','2020-05-27 11:41:49',18,200.00,'','0'),
(31,2,'2020-05-01','2020-05-29 16:27:14',5,100.00,'','0'),
(32,2,'2020-05-01','2020-05-30 09:56:58',8,36.00,'','0'),
(33,2,'2020-05-01','2020-05-30 13:10:55',17,1040.00,'','0'),
(34,2,'2020-05-01','2020-05-30 13:38:53',21,210.00,'','0'),
(35,2,'2020-05-01','2020-05-30 13:39:01',12,210.00,'','0'),
(36,2,'2020-05-01','2020-05-30 13:39:10',8,210.00,'','0'),
(37,2,'2020-05-01','2020-05-30 13:39:19',25,210.00,'','0'),
(38,2,'2020-05-01','2020-05-30 13:39:27',10,210.00,'','0'),
(39,2,'2020-05-01','2020-05-30 13:39:41',5,210.00,'','0'),
(40,2,'2020-05-01','2020-05-30 13:39:50',6,1040.00,'','0'),
(41,2,'2020-05-01','2020-05-30 13:40:03',18,1040.00,'','0'),
(42,2,'2020-05-01','2020-05-30 13:40:27',11,1040.00,'','0'),
(43,2,'2020-06-01','2020-06-04 14:43:27',6,750.00,'','0'),
(44,2,'2020-06-01','2020-06-05 17:39:15',11,490.00,'','0'),
(45,2,'2020-06-01','2020-06-09 13:22:20',6,240.00,'','0'),
(46,2,'2020-06-01','2020-06-11 10:28:04',11,200.00,'','0'),
(47,2,'2020-06-01','2020-06-11 10:28:25',8,200.00,'','0'),
(48,2,'2020-06-01','2020-06-11 10:28:49',25,200.00,'','0'),
(49,2,'2020-06-01','2020-06-11 10:29:13',21,200.00,'','0'),
(50,2,'2020-06-01','2020-06-11 10:29:18',12,200.00,'','0'),
(51,2,'2020-06-01','2020-06-11 10:29:24',17,200.00,'','0'),
(52,2,'2020-06-01','2020-06-11 10:29:31',7,200.00,'','0'),
(53,2,'2020-06-01','2020-06-11 10:29:41',3,200.00,'','0'),
(54,2,'2020-06-01','2020-06-11 10:29:46',6,200.00,'','0'),
(55,2,'2020-06-01','2020-06-11 10:29:52',5,200.00,'','0'),
(56,2,'2020-06-01','2020-06-11 10:32:04',19,200.00,'','0'),
(57,2,'2020-06-01','2020-06-11 10:34:43',23,200.00,'','0'),
(58,2,'2020-06-01','2020-06-13 14:26:26',11,296.00,'','0'),
(59,2,'2020-06-01','2020-06-13 14:38:08',12,163.00,'','0'),
(60,2,'2020-06-01','2020-06-16 17:29:46',5,70.00,'','0'),
(61,2,'2020-06-01','2020-06-17 10:46:50',12,154.00,'','0'),
(62,2,'2020-06-01','2020-06-18 09:12:06',7,240.00,'','0'),
(63,2,'2020-06-01','2020-06-18 13:16:41',11,200.00,'','0'),
(64,2,'2020-06-01','2020-06-18 13:16:54',8,200.00,'','0'),
(65,2,'2020-06-01','2020-06-18 13:16:58',19,200.00,'','0'),
(66,2,'2020-06-01','2020-06-18 13:17:03',18,200.00,'','0'),
(67,2,'2020-06-01','2020-06-18 13:17:09',25,200.00,'','0'),
(68,2,'2020-06-01','2020-06-18 13:17:16',21,200.00,'','0'),
(69,2,'2020-06-01','2020-06-18 13:17:24',12,200.00,'','0'),
(70,2,'2020-06-01','2020-06-18 13:17:30',7,200.00,'','0'),
(71,2,'2020-06-01','2020-06-18 13:17:35',3,200.00,'','0'),
(72,2,'2020-06-01','2020-06-18 13:17:42',6,200.00,'','0'),
(73,2,'2020-06-01','2020-06-18 13:17:48',5,200.00,'','0'),
(74,2,'2020-06-01','2020-06-18 13:18:07',23,200.00,'','0'),
(75,2,'2020-06-01','2020-06-18 17:37:34',5,54.00,'','0'),
(76,2,'2020-06-01','2020-06-18 17:38:29',21,104.00,'','0'),
(77,2,'2020-06-01','2020-06-18 17:38:36',11,104.00,'','0'),
(78,2,'2020-06-01','2020-06-20 11:36:00',18,100.00,'','0'),
(79,2,'2020-06-01','2020-06-22 13:15:07',5,248.00,'','0'),
(80,2,'2020-06-01','2020-06-24 09:43:08',12,400.00,'','0'),
(81,2,'2020-06-01','2020-06-24 18:33:55',6,2500.00,'','0'),
(82,2,'2020-06-01','2020-06-25 09:52:27',5,1000.00,'','0'),
(83,2,'2020-06-01','2020-06-25 17:10:54',12,200.00,'','0'),
(84,2,'2020-06-01','2020-06-25 18:05:19',11,500.00,'','0'),
(85,2,'2020-06-01','2020-06-26 16:32:25',18,210.00,'','0'),
(86,2,'2020-06-01','2020-06-28 15:29:33',8,200.00,'','0'),
(87,2,'2020-06-01','2020-06-29 11:42:31',11,200.00,'','0'),
(88,2,'2020-06-01','2020-06-29 11:42:36',8,200.00,'','0'),
(89,2,'2020-06-01','2020-06-29 11:42:42',19,200.00,'','0'),
(90,2,'2020-06-01','2020-06-29 11:42:47',18,200.00,'','0'),
(91,2,'2020-06-01','2020-06-29 11:42:53',25,200.00,'','0'),
(92,2,'2020-06-01','2020-06-29 11:43:03',12,200.00,'','0'),
(93,2,'2020-06-01','2020-06-29 11:43:17',17,200.00,'','0'),
(94,2,'2020-06-01','2020-06-29 11:43:25',7,200.00,'','0'),
(95,2,'2020-06-01','2020-06-29 11:43:32',3,200.00,'','0'),
(96,2,'2020-06-01','2020-06-29 11:43:40',6,200.00,'','0'),
(97,2,'2020-06-01','2020-06-29 11:43:46',5,200.00,'','0'),
(98,2,'2020-06-01','2020-06-29 16:03:49',6,600.00,'','0'),
(99,2,'2020-06-01','2020-06-30 17:27:43',6,115.00,'','0'),
(100,2,'2020-06-01','2020-06-30 17:27:54',17,115.00,'','0'),
(101,2,'2020-06-01','2020-06-30 17:28:04',18,115.00,'','0'),
(102,2,'2020-06-01','2020-06-30 17:28:24',11,115.00,'','0'),
(103,2,'2020-06-01','2020-06-30 17:29:53',18,3615.00,'','0'),
(104,2,'2020-06-01','2020-06-30 17:31:08',8,85.00,'','0'),
(105,2,'2020-06-01','2020-06-30 21:38:10',10,90.00,'','1'),
(106,2,'2020-07-01','2020-07-01 14:08:22',11,200.00,'','0'),
(107,2,'2020-07-01','2020-07-01 14:08:31',8,200.00,'','0'),
(108,2,'2020-07-01','2020-07-01 14:16:30',19,200.00,'','0'),
(109,2,'2020-07-01','2020-07-01 14:16:41',18,200.00,'','0'),
(110,2,'2020-07-01','2020-07-01 14:16:49',25,200.00,'','0'),
(111,2,'2020-07-01','2020-07-01 14:16:54',21,200.00,'','0'),
(112,2,'2020-07-01','2020-07-01 14:17:00',17,200.00,'','0'),
(113,2,'2020-07-01','2020-07-01 14:17:05',7,200.00,'','0'),
(114,2,'2020-07-01','2020-07-01 14:17:11',3,200.00,'','0'),
(115,2,'2020-07-01','2020-07-01 14:17:17',6,200.00,'','0'),
(116,2,'2020-07-01','2020-07-01 14:17:22',5,200.00,'','0'),
(117,2,'2020-07-01','2020-07-01 15:43:05',15,200.00,'','1'),
(118,2,'2020-07-01','2020-07-01 18:03:09',24,1395.00,'','0'),
(119,2,'2020-07-01','2020-07-06 12:43:36',24,350.00,'','0'),
(120,2,'2020-07-01','2020-07-07 11:14:21',11,135.00,'','0'),
(121,2,'2020-07-01','2020-07-07 11:14:34',8,135.00,'','0'),
(122,2,'2020-07-01','2020-07-07 11:14:42',19,135.00,'','0'),
(123,2,'2020-07-01','2020-07-07 11:14:49',18,135.00,'','0'),
(124,2,'2020-07-01','2020-07-07 11:14:55',25,135.00,'','0'),
(125,2,'2020-07-01','2020-07-07 11:15:20',21,135.00,'','0'),
(126,2,'2020-07-01','2020-07-07 11:15:27',17,135.00,'','0'),
(127,2,'2020-07-01','2020-07-07 11:15:34',7,135.00,'','0'),
(128,2,'2020-07-01','2020-07-07 11:16:27',24,135.00,'','1'),
(129,2,'2020-07-01','2020-07-07 11:16:36',6,135.00,'','0'),
(130,2,'2020-07-01','2020-07-07 11:16:43',5,135.00,'','0'),
(131,2,'2020-07-01','2020-07-07 11:17:42',12,135.00,'','0'),
(132,2,'2020-07-01','2020-07-07 11:18:02',23,135.00,'','0'),
(133,2,'2020-07-01','2020-07-07 11:19:14',15,135.00,'','0'),
(134,2,'2020-07-01','2020-07-09 12:15:01',19,120.00,'','0'),
(135,26,'2020-07-01','2020-07-10 16:14:12',6,60.00,'','0'),
(136,26,'2020-07-01','2020-07-11 17:19:53',18,1000.00,'','0'),
(137,26,'2020-07-01','2020-07-14 17:00:34',12,188.00,'','0'),
(138,26,'2020-07-01','2020-07-14 17:00:48',17,272.00,'','0'),
(139,26,'2020-07-01','2020-07-14 17:01:02',21,420.00,'','0'),
(140,26,'2020-07-01','2020-07-14 17:01:23',19,452.00,'','0'),
(141,26,'2020-07-01','2020-07-14 19:04:45',7,2600.00,'','0'),
(142,26,'2020-07-01','2020-07-16 16:02:59',6,245.00,'','0'),
(143,26,'2020-07-01','2020-07-16 16:20:03',12,1000.00,'','0'),
(144,26,'2020-07-01','2020-07-16 16:39:38',24,1440.00,'','0'),
(145,26,'2020-07-01','2020-07-17 17:08:25',24,350.00,'','0'),
(146,26,'2020-07-01','2020-07-18 09:24:40',24,1300.00,'','0'),
(147,26,'2020-07-01','2020-07-18 09:25:08',3,2020.00,'','0'),
(148,26,'2020-07-01','2020-07-21 10:05:31',24,600.00,'','0'),
(149,26,'2020-07-01','2020-07-21 10:05:40',24,237.00,'','0'),
(150,26,'2020-07-01','2020-07-21 10:06:44',15,285.00,'','0'),
(151,26,'2020-07-01','2020-07-21 15:31:39',15,200.00,'','1'),
(152,26,'2020-07-01','2020-07-21 15:33:24',11,200.00,'','0'),
(153,26,'2020-07-01','2020-07-21 15:33:30',8,200.00,'','0'),
(154,26,'2020-07-01','2020-07-21 15:33:37',19,200.00,'','0'),
(155,26,'2020-07-01','2020-07-21 15:33:43',18,200.00,'','0'),
(156,26,'2020-07-01','2020-07-21 15:33:49',25,200.00,'','0'),
(157,26,'2020-07-01','2020-07-21 15:33:56',21,200.00,'','0'),
(158,26,'2020-07-01','2020-07-21 15:34:02',12,200.00,'','0'),
(159,26,'2020-07-01','2020-07-21 15:34:10',17,200.00,'','0'),
(160,26,'2020-07-01','2020-07-21 15:34:22',23,200.00,'','1'),
(161,26,'2020-07-01','2020-07-21 15:40:11',7,200.00,'','0'),
(162,26,'2020-07-01','2020-07-21 15:40:13',7,200.00,'','1'),
(163,26,'2020-07-01','2020-07-21 15:45:15',23,200.00,'','1'),
(164,26,'2020-07-01','2020-07-21 15:46:05',24,200.00,'','0'),
(165,26,'2020-07-01','2020-07-21 15:46:23',3,200.00,'','1'),
(166,26,'2020-07-01','2020-07-21 15:47:39',3,1000.00,'','0'),
(167,26,'2020-07-01','2020-07-21 16:17:22',3,200.00,'','0'),
(168,26,'2020-07-01','2020-07-21 16:17:37',6,200.00,'','0'),
(169,26,'2020-07-01','2020-07-21 16:17:49',5,200.00,'','0'),
(170,26,'2020-07-01','2020-07-22 10:20:19',24,215.00,'','0'),
(171,26,'2020-07-01','2020-07-22 17:29:17',19,300.00,'','1'),
(172,26,'2020-07-01','2020-07-22 17:29:30',8,300.00,'','0'),
(173,26,'2020-07-01','2020-07-23 13:17:57',24,200.00,'','0'),
(174,26,'2020-07-01','2020-07-23 16:07:21',3,253.00,'','0'),
(175,26,'2020-07-01','2020-07-24 16:55:56',24,1125.00,'','0'),
(176,26,'2020-07-01','2020-07-25 15:00:12',6,2500.00,'','0'),
(177,26,'2020-07-01','2020-07-27 09:44:00',7,9000.00,'','0'),
(178,26,'2020-07-01','2020-07-27 10:23:17',24,250.00,'','0'),
(179,26,'2020-07-01','2020-07-27 10:23:23',24,617.00,'','0'),
(180,26,'2020-07-01','2020-07-27 14:22:24',26,1000.00,'','0'),
(181,26,'2020-07-01','2020-07-27 14:22:42',3,500.00,'','0'),
(182,26,'2020-07-01','2020-07-28 12:37:26',11,2000.00,'','0'),
(183,26,'2020-07-01','2020-07-29 09:44:38',24,317.00,'','0'),
(184,26,'2020-07-01','2020-07-29 12:52:28',24,200.00,'','0'),
(185,26,'2020-07-01','2020-07-29 15:48:32',5,190.00,'','0'),
(186,26,'2020-07-01','2020-07-30 17:42:19',11,120.00,'','0'),
(187,26,'2020-07-01','2020-07-30 17:42:35',21,120.00,'','0'),
(188,26,'2020-07-01','2020-07-30 17:42:41',12,120.00,'','0'),
(189,26,'2020-07-01','2020-07-31 09:59:05',7,253.00,'','0'),
(190,26,'2020-07-01','2020-07-31 09:59:41',3,1000.00,'','0'),
(191,26,'2020-07-01','2020-07-31 15:37:18',15,1000.00,'','0'),
(192,26,'2020-08-01','2020-08-03 09:20:59',24,1260.00,'','0'),
(193,26,'2020-08-01','2020-08-03 17:32:58',24,702.00,'','0'),
(194,26,'2020-08-01','2020-08-06 16:43:13',25,253.00,'','0'),
(195,26,'2020-08-01','2020-08-06 16:43:24',24,1660.00,'','1'),
(196,26,'2020-08-01','2020-08-06 18:32:15',24,750.00,'','1'),
(197,26,'2020-08-01','2020-08-08 10:39:24',24,2100.00,'','1'),
(198,26,'2020-08-01','2020-08-10 10:29:40',24,1215.00,'','0'),
(199,26,'2020-08-01','2020-08-10 10:29:48',24,1440.00,'','0'),
(200,26,'2020-08-01','2020-08-10 10:29:57',24,675.00,'','0'),
(201,26,'2020-08-01','2020-08-10 10:30:09',24,1890.00,'','0'),
(202,26,'2020-08-01','2020-08-10 10:31:18',24,1125.00,'','0'),
(203,26,'2020-08-01','2020-08-12 18:10:27',24,1998.00,'','0'),
(204,26,'2020-08-01','2020-08-12 18:10:36',24,1773.00,'','0'),
(205,26,'2020-08-01','2020-08-12 18:10:43',24,513.00,'','0'),
(206,26,'2020-08-01','2020-08-13 13:09:44',12,200.00,'','0'),
(207,26,'2020-08-01','2020-08-13 13:09:52',21,284.00,'','0'),
(208,26,'2020-08-01','2020-08-13 13:10:01',11,200.00,'','0'),
(209,26,'2020-08-01','2020-08-13 13:10:10',17,200.00,'','0'),
(210,26,'2020-08-01','2020-08-15 13:02:51',24,1890.00,'','0'),
(211,26,'2020-08-01','2020-08-15 13:03:00',24,1260.00,'','0'),
(212,26,'2020-08-01','2020-08-15 17:06:32',24,1170.00,'','0'),
(213,26,'2020-08-01','2020-08-17 09:16:01',21,1000.00,'','0'),
(214,26,'2020-08-01','2020-08-17 09:16:14',26,800.00,'','0'),
(215,26,'2020-08-01','2020-08-18 16:10:23',25,3367.00,'','0'),
(216,26,'2020-08-01','2020-08-20 13:54:30',15,200.00,'','0'),
(217,26,'2020-08-01','2020-08-20 13:54:38',11,200.00,'','0'),
(218,26,'2020-08-01','2020-08-20 13:54:45',8,200.00,'','0'),
(219,26,'2020-08-01','2020-08-20 13:54:56',19,200.00,'','0'),
(220,26,'2020-08-01','2020-08-20 13:55:20',18,200.00,'','0'),
(221,26,'2020-08-01','2020-08-20 13:55:31',21,200.00,'','0'),
(222,26,'2020-08-01','2020-08-20 13:55:39',12,200.00,'','0'),
(223,26,'2020-08-01','2020-08-20 14:01:43',17,200.00,'','0'),
(224,26,'2020-08-01','2020-08-20 14:40:46',24,200.00,'','1'),
(225,26,'2020-08-01','2020-08-20 14:40:56',3,200.00,'','0'),
(226,26,'2020-08-01','2020-08-20 14:41:05',26,200.00,'','0'),
(227,26,'2020-08-01','2020-08-20 14:41:17',6,200.00,'','0'),
(228,26,'2020-08-01','2020-08-20 14:41:23',5,200.00,'','0'),
(229,26,'2020-08-01','2020-08-21 09:34:58',23,200.00,'','0'),
(230,26,'2020-08-01','2020-08-21 14:37:57',6,176.00,'','0'),
(231,26,'2020-08-01','2020-08-21 17:31:42',24,450.00,'','0'),
(232,26,'2020-08-01','2020-08-21 17:31:56',24,1908.00,'','0'),
(233,26,'2020-08-01','2020-08-21 17:32:14',24,900.00,'','0'),
(234,26,'2020-08-01','2020-08-21 17:32:29',24,270.00,'','0'),
(235,26,'2020-08-01','2020-08-24 09:22:35',8,1000.00,'','0'),
(236,26,'2020-08-01','2020-08-24 09:22:52',24,1368.00,'','0'),
(237,26,'2020-08-01','2020-08-25 09:57:17',24,1440.00,'','0'),
(238,26,'2020-08-01','2020-08-28 09:48:01',24,1980.00,'','0'),
(239,26,'2020-08-01','2020-08-28 09:48:12',24,2502.00,'','0'),
(240,26,'2020-08-01','2020-08-28 09:48:23',24,1872.00,'','0'),
(241,26,'2020-08-01','2020-08-28 11:49:17',11,500.00,'','0'),
(242,26,'2020-08-01','2020-08-29 18:09:33',5,347.00,'','0'),
(243,26,'2020-08-01','2020-08-29 18:09:53',24,900.00,'','0'),
(244,26,'2020-08-01','2020-08-29 18:10:01',24,1636.00,'','0'),
(245,26,'2020-08-01','2020-08-31 10:39:28',26,1000.00,'','1'),
(246,26,'2020-08-01','2020-08-31 11:34:54',26,500.00,'','0'),
(247,26,'2020-08-01','2020-08-31 11:39:47',6,2500.00,'','0'),
(248,26,'2020-08-01','2020-08-31 14:24:41',24,675.00,'','0'),
(249,26,'2020-09-01','2020-09-02 18:07:09',24,573.00,'','0'),
(250,26,'2020-09-01','2020-09-05 15:47:38',24,40.00,'','0'),
(251,26,'2020-09-01','2020-09-05 15:47:51',24,580.00,'','0'),
(252,26,'2020-09-01','2020-09-05 15:48:05',24,47.00,'','0'),
(253,26,'2020-09-01','2020-09-05 15:48:12',24,80.00,'','0'),
(254,26,'2020-09-01','2020-09-05 15:50:31',24,50.00,'','0'),
(255,26,'2020-09-01','2020-09-05 15:50:32',24,50.00,'','1'),
(256,26,'2020-09-01','2020-09-05 15:50:40',24,2750.00,'','0'),
(257,26,'2020-09-01','2020-09-07 10:09:04',24,108.00,'','0'),
(258,26,'2020-09-01','2020-09-07 10:09:38',24,150.00,'','0'),
(259,26,'2020-09-01','2020-09-08 11:42:11',15,500.00,'','0'),
(260,26,'2020-09-01','2020-09-08 11:42:22',11,500.00,'','0'),
(261,26,'2020-09-01','2020-09-08 11:42:28',8,500.00,'','0'),
(262,26,'2020-09-01','2020-09-08 11:42:36',19,500.00,'','0'),
(263,26,'2020-09-01','2020-09-08 11:42:43',18,500.00,'','0'),
(264,26,'2020-09-01','2020-09-08 11:42:53',21,500.00,'','0'),
(265,26,'2020-09-01','2020-09-08 11:42:59',12,500.00,'','0'),
(266,26,'2020-09-01','2020-09-08 11:43:05',17,500.00,'','0'),
(267,26,'2020-09-01','2020-09-08 11:43:10',23,500.00,'','0'),
(268,26,'2020-09-01','2020-09-08 11:43:16',7,500.00,'','0'),
(269,26,'2020-09-01','2020-09-08 11:43:29',26,500.00,'','0'),
(270,26,'2020-09-01','2020-09-08 11:43:34',6,500.00,'','0'),
(271,26,'2020-09-01','2020-09-08 11:43:42',5,500.00,'','0'),
(272,26,'2020-09-01','2020-09-08 11:43:57',25,500.00,'','0'),
(273,26,'2020-09-01','2020-09-10 09:33:28',24,150.00,'','0'),
(274,26,'2020-09-01','2020-09-10 09:33:36',24,600.00,'','0'),
(275,26,'2020-09-01','2020-09-11 08:26:15',18,300.00,'','0'),
(276,26,'2020-09-01','2020-09-11 08:26:23',12,300.00,'','0'),
(277,26,'2020-09-01','2020-09-12 12:33:30',18,200.00,'','0'),
(278,26,'2020-09-01','2020-09-15 09:24:16',24,3000.00,'','0'),
(279,26,'2020-09-01','2020-09-15 09:24:25',24,185.00,'','0'),
(280,26,'2020-09-01','2020-09-15 09:24:33',24,350.00,'','0'),
(281,26,'2020-09-01','2020-09-15 14:37:42',3,1985.00,'','0'),
(282,26,'2020-09-01','2020-09-15 14:37:52',24,1293.00,'','0'),
(283,26,'2020-09-01','2020-09-16 18:08:38',24,211.00,'','0'),
(284,26,'2020-09-01','2020-09-16 18:08:52',24,945.00,'','0'),
(285,26,'2020-09-01','2020-09-17 17:16:10',24,270.00,'','0'),
(286,26,'2020-09-01','2020-09-18 13:40:05',3,5000.00,'','0'),
(287,26,'2020-09-01','2020-09-19 16:49:37',6,2500.00,'','0'),
(288,26,'2020-09-01','2020-09-22 09:55:13',8,425.00,'','0'),
(289,26,'2020-09-01','2020-09-22 15:06:36',7,3000.00,'','0'),
(290,26,'2020-09-01','2020-09-24 16:25:17',8,500.00,'','0'),
(291,26,'2020-09-01','2020-09-24 16:26:08',26,1000.00,'','0'),
(292,26,'2020-09-01','2020-09-25 09:06:40',18,240.00,'','0'),
(293,26,'2020-09-01','2020-09-25 17:44:42',6,500.00,'','0'),
(294,26,'2020-09-01','2020-09-26 09:52:43',19,300.00,'','0'),
(295,26,'2020-09-01','2020-09-26 15:19:39',11,1000.00,'','0'),
(296,26,'2020-09-01','2020-09-28 08:33:32',7,1800.00,'','0'),
(297,26,'2020-09-01','2020-09-28 13:20:19',3,5000.00,'','0'),
(298,26,'2020-09-01','2020-09-28 13:20:32',26,500.00,'','0'),
(299,26,'2020-09-01','2020-09-28 17:15:26',19,600.00,'','0'),
(300,26,'2020-09-01','2020-09-29 13:45:23',3,2800.00,'','0'),
(301,26,'2020-09-01','2020-09-29 15:09:40',7,2000.00,'','0'),
(302,26,'2020-09-01','2020-09-29 17:21:36',22,500.00,'','0'),
(303,26,'2020-09-01','2020-09-30 09:57:23',5,200.00,'','0'),
(304,26,'2020-09-01','2020-09-30 16:16:46',5,270.00,'','0'),
(305,26,'2020-09-01','2020-09-30 19:01:16',26,1790.00,'','1'),
(306,26,'2020-09-01','2020-09-30 19:02:30',3,1790.00,'','0'),
(307,26,'2020-10-01','2020-10-05 08:42:08',24,2000.00,'','0'),
(308,26,'2020-10-01','2020-10-06 09:04:42',3,1000.00,'','0'),
(309,26,'2020-10-01','2020-10-06 14:59:45',3,1000.00,'','0'),
(310,26,'2020-10-01','2020-10-08 08:41:24',24,1140.00,'','0'),
(311,26,'2020-10-01','2020-10-09 09:03:46',3,72.00,'','0'),
(312,26,'2020-10-01','2020-10-09 09:04:02',3,1479.00,'','0'),
(313,26,'2020-10-01','2020-10-10 09:58:50',6,795.00,'','0'),
(314,26,'2020-10-01','2020-10-12 10:56:54',24,2000.00,'','0'),
(315,26,'2020-10-01','2020-10-12 10:59:13',11,135.00,'','0'),
(316,26,'2020-10-01','2020-10-12 17:33:11',18,100.00,'','0'),
(317,26,'2020-10-01','2020-10-12 17:33:20',23,100.00,'','0'),
(318,26,'2020-10-01','2020-10-12 17:33:29',3,5000.00,'','0'),
(319,26,'2020-10-01','2020-10-12 17:33:39',24,500.00,'','0'),
(320,26,'2020-10-01','2020-10-12 17:33:53',21,1000.00,'','0'),
(321,26,'2020-10-01','2020-10-15 08:43:43',24,500.00,'','0'),
(322,26,'2020-10-01','2020-10-15 08:43:52',24,2000.00,'','0'),
(323,26,'2020-10-01','2020-10-15 09:29:22',6,500.00,'','0'),
(324,26,'2020-10-01','2020-10-15 12:24:41',17,84.00,'','0'),
(325,26,'2020-10-01','2020-10-15 12:24:48',21,84.00,'','0'),
(326,26,'2020-10-01','2020-10-15 12:24:59',5,84.00,'','0'),
(327,26,'2020-10-01','2020-10-15 12:25:10',11,472.00,'','0'),
(328,26,'2020-10-01','2020-10-15 14:10:51',18,1000.00,'','0'),
(329,26,'2020-10-01','2020-10-17 11:49:25',6,2000.00,'','0'),
(330,26,'2020-10-01','2020-10-19 09:47:03',24,1408.00,'','1'),
(331,26,'2020-10-01','2020-10-19 09:48:34',3,2142.00,'','1'),
(332,26,'2020-10-01','2020-10-19 12:31:44',24,1381.00,'','0'),
(333,26,'2020-10-01','2020-10-19 12:31:55',3,2115.00,'','0'),
(334,26,'2020-10-01','2020-10-20 09:41:06',3,370.00,'','0'),
(335,26,'2020-10-01','2020-10-20 09:41:16',22,740.00,'','0'),
(336,26,'2020-10-01','2020-10-21 08:57:59',24,3500.00,'','0'),
(337,26,'2020-10-01','2020-10-22 09:03:28',24,200.00,'','0'),
(338,26,'2020-10-01','2020-10-22 10:37:23',7,10000.00,'','0'),
(339,26,'2020-10-01','2020-10-22 13:38:04',24,50.00,'','0'),
(340,26,'2020-10-01','2020-10-22 13:38:10',24,133.00,'','0'),
(341,26,'2020-10-01','2020-10-23 08:55:01',24,1000.00,'','0'),
(342,26,'2020-10-01','2020-10-23 14:14:04',6,600.00,'','0'),
(343,26,'2020-10-01','2020-10-23 18:44:33',24,100.00,'','0'),
(344,26,'2020-10-01','2020-10-24 12:39:25',24,500.00,'','0'),
(345,26,'2020-10-01','2020-10-27 13:47:19',24,500.00,'','0'),
(346,26,'2020-10-01','2020-10-27 13:47:27',24,1000.00,'','0'),
(347,26,'2020-10-01','2020-10-28 08:43:21',11,6000.00,'','0'),
(348,26,'2020-10-01','2020-10-28 15:11:42',7,600.00,'','0'),
(349,26,'2020-10-01','2020-10-28 17:30:55',24,500.00,'','0'),
(350,26,'2020-10-01','2020-10-29 12:14:18',8,200.00,'','0'),
(351,26,'2020-10-01','2020-10-29 12:14:31',19,200.00,'','0'),
(352,26,'2020-10-01','2020-10-29 12:14:42',18,1000.00,'','0'),
(353,26,'2020-10-01','2020-10-29 12:14:55',18,200.00,'','0'),
(354,26,'2020-10-01','2020-10-29 12:15:14',25,200.00,'','0'),
(355,26,'2020-10-01','2020-10-29 12:15:28',21,200.00,'','0'),
(356,26,'2020-10-01','2020-10-29 12:15:39',12,200.00,'','0'),
(357,26,'2020-10-01','2020-10-29 12:15:50',17,200.00,'','0'),
(358,26,'2020-10-01','2020-10-29 12:16:08',7,200.00,'','0'),
(359,26,'2020-10-01','2020-10-29 12:16:23',24,200.00,'','0'),
(360,26,'2020-10-01','2020-10-29 12:16:24',24,200.00,'','1'),
(361,26,'2020-10-01','2020-10-29 12:16:37',3,200.00,'','0'),
(362,26,'2020-10-01','2020-10-29 12:16:47',26,200.00,'','1'),
(363,26,'2020-10-01','2020-10-29 12:16:59',6,200.00,'','0'),
(364,26,'2020-10-01','2020-10-29 12:17:16',5,200.00,'','0'),
(365,26,'2020-10-01','2020-10-29 12:17:34',22,200.00,'','0'),
(366,26,'2020-10-01','2020-10-29 14:56:09',12,200.00,'','0'),
(367,26,'2020-10-01','2020-10-30 10:18:09',3,1000.00,'','0'),
(368,26,'2020-10-01','2020-10-30 12:45:23',17,1000.00,'','0'),
(369,26,'2020-10-01','2020-10-30 14:50:26',12,375.00,'','0'),
(370,26,'2020-10-01','2020-10-30 14:50:40',25,150.00,'','0'),
(371,26,'2020-10-01','2020-10-31 10:18:05',24,500.00,'','0'),
(372,26,'2020-10-01','2020-10-31 10:39:36',24,45.00,'','0'),
(373,26,'2020-10-01','2020-10-31 15:44:18',18,500.00,'','0'),
(374,26,'2020-10-01','2020-10-31 15:44:18',18,500.00,'','1'),
(375,26,'2020-10-01','2020-10-31 17:09:18',3,4000.00,'','0'),
(376,26,'2020-11-01','2020-11-05 13:39:15',24,349.00,'','0'),
(377,26,'2020-11-01','2020-11-11 14:28:15',18,1500.00,'','0'),
(378,26,'2020-11-01','2020-11-11 14:28:59',24,550.00,'','0'),
(379,26,'2020-11-01','2020-11-11 14:30:00',15,100.00,'','0'),
(380,26,'2020-11-01','2020-11-11 14:30:07',11,100.00,'','0'),
(381,26,'2020-11-01','2020-11-11 14:30:15',8,100.00,'','0'),
(382,26,'2020-11-01','2020-11-11 14:30:23',19,100.00,'','0'),
(383,26,'2020-11-01','2020-11-11 14:30:30',18,100.00,'','0'),
(384,26,'2020-11-01','2020-11-11 14:31:31',25,100.00,'','1'),
(385,26,'2020-11-01','2020-11-11 14:31:39',21,100.00,'','0'),
(386,26,'2020-11-01','2020-11-11 14:31:48',12,100.00,'','0'),
(387,26,'2020-11-01','2020-11-11 14:31:54',17,100.00,'','0'),
(388,26,'2020-11-01','2020-11-11 14:32:02',7,100.00,'','0'),
(389,26,'2020-11-01','2020-11-11 14:32:12',6,100.00,'','0'),
(390,26,'2020-11-01','2020-11-11 14:32:19',5,100.00,'','0'),
(391,26,'2020-11-01','2020-11-11 14:32:25',22,100.00,'','0'),
(392,26,'2020-11-01','2020-11-12 12:57:57',24,84.00,'','0'),
(393,26,'2020-11-01','2020-11-12 12:58:03',24,500.00,'','0'),
(394,26,'2020-11-01','2020-11-12 12:58:13',26,1000.00,'','1'),
(395,26,'2020-11-01','2020-11-13 11:41:12',11,65.00,'','0'),
(396,26,'2020-11-01','2020-11-13 11:41:29',18,65.00,'','0'),
(397,26,'2020-11-01','2020-11-13 11:41:35',25,65.00,'','1'),
(398,26,'2020-11-01','2020-11-13 11:41:42',12,65.00,'','0'),
(399,26,'2020-11-01','2020-11-13 11:41:58',7,65.00,'','0'),
(400,26,'2020-11-01','2020-11-13 11:42:05',24,65.00,'','0'),
(401,26,'2020-11-01','2020-11-13 11:42:22',3,985.00,'','0'),
(402,26,'2020-11-01','2020-11-13 11:42:28',3,65.00,'','0'),
(403,26,'2020-11-01','2020-11-13 11:42:36',22,65.00,'','0'),
(404,26,'2020-11-01','2020-11-13 12:39:28',12,505.00,'','0'),
(405,26,'2020-11-01','2020-11-16 08:50:35',3,200.00,'','0'),
(406,26,'2020-11-01','2020-11-16 16:06:59',24,660.00,'','0'),
(407,26,'2020-11-01','2020-11-18 08:25:02',24,500.00,'','0'),
(408,26,'2020-11-01','2020-11-18 08:25:10',24,1381.00,'','0'),
(409,26,'2020-11-01','2020-11-18 08:25:45',3,2115.00,'','0'),
(410,26,'2020-11-01','2020-11-18 15:41:41',24,2000.00,'','0'),
(411,26,'2020-11-01','2020-11-20 09:17:07',5,200.00,'','0'),
(412,26,'2020-11-01','2020-11-20 17:51:23',11,500.00,'','0'),
(413,26,'2020-11-01','2020-11-20 17:51:32',24,500.00,'','0'),
(414,26,'2020-11-01','2020-11-21 09:53:18',7,1200.00,'','0'),
(415,26,'2020-11-01','2020-11-23 11:30:07',21,1000.00,'','0'),
(416,26,'2020-11-01','2020-11-23 17:17:08',24,500.00,'','0'),
(417,26,'2020-11-01','2020-11-23 17:17:23',24,5000.00,'','0'),
(418,26,'2020-11-01','2020-11-23 17:17:52',3,8500.00,'','0'),
(419,26,'2020-11-01','2020-11-24 13:33:43',3,250.00,'','0'),
(420,26,'2020-11-01','2020-11-24 13:34:28',3,150.00,'','0'),
(421,26,'2020-11-01','2020-11-24 13:34:40',6,2400.00,'','0'),
(422,26,'2020-11-01','2020-11-24 13:34:54',11,1000.00,'','0'),
(423,26,'2020-11-01','2020-11-24 16:02:03',8,300.00,'','0'),
(424,26,'2020-11-01','2020-11-25 09:34:58',7,500.00,'','0'),
(425,26,'2020-11-01','2020-11-25 17:36:09',17,1000.00,'','0'),
(426,26,'2020-11-01','2020-11-26 09:25:41',24,1000.00,'','0'),
(427,26,'2020-11-01','2020-11-26 13:30:30',19,200.00,'','0'),
(428,26,'2020-11-01','2020-11-26 14:10:33',15,500.00,'','0'),
(429,26,'2020-11-01','2020-11-26 14:10:46',24,3000.00,'','0'),
(430,26,'2020-11-01','2020-11-27 11:31:33',21,140.00,'','0'),
(431,26,'2020-11-01','2020-11-30 09:07:09',18,200.00,'','0'),
(432,26,'2020-11-01','2020-11-30 09:09:30',23,100.00,'','0'),
(433,26,'2020-11-01','2020-11-30 09:10:55',3,440.00,'','0'),
(434,26,'2020-11-01','2020-11-30 13:56:10',24,80.00,'','0'),
(435,26,'2020-11-01','2020-11-30 15:25:53',11,145.00,'','0'),
(436,26,'2020-11-01','2020-11-30 15:25:59',11,100.00,'','0'),
(437,26,'2020-12-01','2020-12-02 13:13:21',3,255.00,'','0'),
(438,26,'2020-12-01','2020-12-02 13:13:27',3,470.00,'','0'),
(439,26,'2020-12-01','2020-12-02 13:17:24',18,200.00,'','0'),
(440,26,'2020-12-01','2020-12-02 16:16:57',24,2500.00,'','0'),
(441,26,'2020-12-01','2020-12-02 16:17:07',24,1000.00,'','0'),
(442,26,'2020-12-01','2020-12-03 08:29:08',24,500.00,'','0'),
(443,26,'2020-12-01','2020-12-03 18:47:08',24,300.00,'','0'),
(444,26,'2020-12-01','2020-12-03 18:47:56',3,66.00,'','0'),
(445,26,'2020-12-01','2020-12-05 09:02:16',24,300.00,'','0'),
(446,26,'2020-12-01','2020-12-05 09:02:25',24,58.00,'','0'),
(447,26,'2020-12-01','2020-12-07 08:33:18',18,700.00,'','0'),
(448,26,'2020-12-01','2020-12-07 08:33:23',18,600.00,'','0'),
(449,26,'2020-12-01','2020-12-07 08:33:49',24,600.00,'','0'),
(450,26,'2020-12-01','2020-12-10 13:24:19',24,600.00,'','1'),
(451,26,'2020-12-01','2020-12-10 13:25:03',24,1000.00,'','0'),
(452,26,'2020-12-01','2020-12-11 14:07:45',24,24.00,'','0'),
(453,26,'2020-12-01','2020-12-11 14:07:54',24,2115.00,'','1'),
(454,26,'2020-12-01','2020-12-11 14:08:11',24,1381.00,'','0'),
(455,26,'2020-12-01','2020-12-11 14:08:21',3,2115.00,'','0'),
(456,26,'2020-12-01','2020-12-11 15:16:50',6,1300.00,'','0'),
(457,26,'2020-12-01','2020-12-12 08:30:13',7,1000.00,'','0'),
(458,26,'2020-12-01','2020-12-15 08:48:09',3,61.00,'','0'),
(459,26,'2020-12-01','2020-12-15 09:00:30',12,1000.00,'','0'),
(460,26,'2020-12-01','2020-12-15 09:00:38',7,1000.00,'','0'),
(461,26,'2020-12-01','2020-12-15 18:07:10',24,500.00,'','0'),
(462,26,'2020-12-01','2020-12-16 16:35:16',11,1100.00,'','0'),
(463,26,'2020-12-01','2020-12-17 08:41:49',3,500.00,'','0'),
(464,26,'2020-12-01','2020-12-17 10:38:28',3,260.00,'','0'),
(465,26,'2020-12-01','2020-12-18 09:23:30',25,500.00,'','0'),
(466,26,'2020-12-01','2020-12-18 09:23:48',7,2276.00,'','0'),
(467,26,'2020-12-01','2020-12-18 13:05:46',7,480.00,'','0'),
(468,26,'2020-12-01','2020-12-18 13:22:35',21,500.00,'','0'),
(469,26,'2020-12-01','2020-12-18 13:22:42',21,215.00,'','0'),
(470,26,'2020-12-01','2020-12-18 13:25:00',24,1000.00,'','0'),
(471,26,'2020-12-01','2020-12-18 15:00:52',3,1621.00,'','0'),
(472,26,'2020-12-01','2020-12-18 15:01:05',11,450.00,'','1'),
(473,26,'2020-12-01','2020-12-19 08:37:25',25,400.00,'','0'),
(474,26,'2020-12-01','2020-12-19 08:37:40',26,2000.00,'','0'),
(475,26,'2020-12-01','2020-12-19 08:38:05',8,500.00,'','0'),
(476,26,'2020-12-01','2020-12-19 08:38:52',6,1000.00,'','0'),
(477,26,'2020-12-01','2020-12-19 11:31:07',15,100.00,'','0'),
(478,26,'2020-12-01','2020-12-19 11:31:17',11,100.00,'','0'),
(479,26,'2020-12-01','2020-12-19 11:31:23',8,100.00,'','0'),
(480,26,'2020-12-01','2020-12-19 11:31:32',25,100.00,'','0'),
(481,26,'2020-12-01','2020-12-19 11:31:42',19,100.00,'','0'),
(482,26,'2020-12-01','2020-12-19 11:31:50',18,100.00,'','0'),
(483,26,'2020-12-01','2020-12-19 11:31:57',21,100.00,'','0'),
(484,26,'2020-12-01','2020-12-19 11:32:04',12,100.00,'','0'),
(485,26,'2020-12-01','2020-12-19 11:32:10',17,100.00,'','0'),
(486,26,'2020-12-01','2020-12-19 11:32:16',23,100.00,'','0'),
(487,26,'2020-12-01','2020-12-19 11:32:24',7,100.00,'','0'),
(488,26,'2020-12-01','2020-12-19 11:32:36',26,100.00,'','0'),
(489,26,'2020-12-01','2020-12-19 11:32:42',6,100.00,'','0'),
(490,26,'2020-12-01','2020-12-19 11:32:51',5,100.00,'','0'),
(491,26,'2020-12-01','2020-12-19 11:32:59',22,100.00,'','0'),
(492,26,'2020-12-01','2020-12-19 14:35:53',21,685.00,'','0'),
(493,26,'2020-12-01','2020-12-21 09:28:14',24,500.00,'','0'),
(494,26,'2020-12-01','2020-12-21 09:29:00',15,50.00,'','1'),
(495,26,'2020-12-01','2020-12-21 09:29:07',11,50.00,'','0'),
(496,26,'2020-12-01','2020-12-21 09:29:14',8,50.00,'','0'),
(497,26,'2020-12-01','2020-12-21 09:29:22',25,50.00,'','0'),
(498,26,'2020-12-01','2020-12-21 09:29:27',19,50.00,'','0'),
(499,26,'2020-12-01','2020-12-21 09:29:38',18,50.00,'','0'),
(500,26,'2020-12-01','2020-12-21 09:29:45',21,50.00,'','0');

INSERT INTO `issuance_wages` VALUES 
(501,26,'2020-12-01','2020-12-21 09:29:52',12,50.00,'','0'),
(502,26,'2020-12-01','2020-12-21 09:30:00',17,50.00,'','0'),
(503,26,'2020-12-01','2020-12-21 09:30:06',23,50.00,'','0'),
(504,26,'2020-12-01','2020-12-21 09:30:19',7,50.00,'','0'),
(505,26,'2020-12-01','2020-12-21 09:30:30',3,50.00,'','1'),
(506,26,'2020-12-01','2020-12-21 09:30:37',26,50.00,'','0'),
(507,26,'2020-12-01','2020-12-21 09:30:47',6,50.00,'','0'),
(508,26,'2020-12-01','2020-12-21 09:30:53',5,50.00,'','0'),
(509,26,'2020-12-01','2020-12-21 09:30:58',22,50.00,'','0'),
(510,26,'2020-12-01','2020-12-23 13:30:31',3,1000.00,'','1'),
(511,26,'2020-12-01','2020-12-25 09:07:40',24,5000.00,'','0'),
(512,26,'2020-12-01','2020-12-25 09:07:46',24,3000.00,'','0'),
(513,26,'2020-12-01','2020-12-25 09:07:52',24,500.00,'','0'),
(514,26,'2020-12-01','2020-12-26 10:05:20',3,255.00,'','0'),
(515,26,'2020-12-01','2020-12-26 10:05:28',15,200.00,'','0'),
(516,26,'2020-12-01','2020-12-26 10:05:35',11,200.00,'','0'),
(517,26,'2020-12-01','2020-12-26 10:05:46',8,200.00,'','0'),
(518,26,'2020-12-01','2020-12-26 10:06:55',8,200.00,'','1'),
(519,26,'2020-12-01','2020-12-26 10:07:02',25,200.00,'','0'),
(520,26,'2020-12-01','2020-12-26 10:07:10',18,200.00,'','0'),
(521,26,'2020-12-01','2020-12-26 10:07:17',21,200.00,'','0'),
(522,26,'2020-12-01','2020-12-26 10:07:47',12,200.00,'','0'),
(523,26,'2020-12-01','2020-12-26 10:07:55',17,200.00,'','0'),
(524,26,'2020-12-01','2020-12-26 10:08:02',23,200.00,'','0'),
(525,26,'2020-12-01','2020-12-26 10:08:15',7,200.00,'','0'),
(526,26,'2020-12-01','2020-12-26 10:08:23',24,200.00,'','0'),
(527,26,'2020-12-01','2020-12-26 10:08:53',3,200.00,'','0'),
(528,26,'2020-12-01','2020-12-26 10:08:59',26,200.00,'','0'),
(529,26,'2020-12-01','2020-12-26 10:09:07',6,200.00,'','0'),
(530,26,'2020-12-01','2020-12-26 10:09:13',5,200.00,'','0'),
(531,26,'2020-12-01','2020-12-26 10:09:20',22,200.00,'','0'),
(532,26,'2020-12-01','2020-12-26 16:51:08',11,490.00,'','1'),
(533,26,'2020-12-01','2020-12-26 16:51:16',8,490.00,'','1'),
(534,26,'2020-12-01','2020-12-26 16:51:26',25,490.00,'','1'),
(535,26,'2020-12-01','2020-12-26 16:51:59',18,490.00,'','1'),
(536,26,'2020-12-01','2020-12-26 16:52:09',21,490.00,'','1'),
(537,26,'2020-12-01','2020-12-26 16:52:17',12,490.00,'','1'),
(538,26,'2020-12-01','2020-12-26 16:52:24',17,490.00,'','1'),
(539,26,'2020-12-01','2020-12-26 16:52:35',7,490.00,'','1'),
(540,26,'2020-12-01','2020-12-26 16:52:46',24,2000.00,'','0'),
(541,26,'2020-12-01','2020-12-26 16:52:52',24,490.00,'','1'),
(542,26,'2020-12-01','2020-12-26 16:53:01',3,490.00,'','1'),
(543,26,'2020-12-01','2020-12-26 16:53:08',26,490.00,'','1'),
(544,26,'2020-12-01','2020-12-26 16:53:16',6,490.00,'','0'),
(545,26,'2020-12-01','2020-12-26 16:53:23',6,600.00,'','0'),
(546,26,'2020-12-01','2020-12-26 16:53:35',5,250.00,'','0'),
(547,26,'2020-12-01','2020-12-26 16:53:41',5,116.00,'','0'),
(548,26,'2020-12-01','2020-12-26 16:53:48',22,490.00,'','1'),
(549,26,'2020-12-01','2020-12-26 16:59:48',18,360.00,'','1'),
(550,26,'2020-12-01','2020-12-28 16:48:51',11,513.00,'','0'),
(551,26,'2020-12-01','2020-12-28 16:48:57',8,513.00,'','0'),
(552,26,'2020-12-01','2020-12-28 16:49:08',25,513.00,'','0'),
(553,26,'2020-12-01','2020-12-28 16:49:29',18,422.00,'','0'),
(554,26,'2020-12-01','2020-12-28 16:49:38',21,513.00,'','0'),
(555,26,'2020-12-01','2020-12-28 16:49:52',12,422.00,'','0'),
(556,26,'2020-12-01','2020-12-28 16:50:00',17,513.00,'','0'),
(557,26,'2020-12-01','2020-12-28 16:50:13',7,513.00,'','0'),
(558,26,'2020-12-01','2020-12-28 16:50:30',24,513.00,'','0'),
(559,26,'2020-12-01','2020-12-28 16:50:44',3,513.00,'','0'),
(560,26,'2020-12-01','2020-12-28 16:50:55',26,513.00,'','0'),
(561,26,'2020-12-01','2020-12-28 16:51:08',6,513.00,'','0'),
(562,26,'2020-12-01','2020-12-28 16:51:19',22,513.00,'','0'),
(563,26,'2020-12-01','2020-12-28 17:04:23',12,500.00,'','0'),
(564,26,'2020-12-01','2020-12-28 17:12:10',24,1000.00,'','0'),
(565,26,'2020-12-01','2020-12-30 08:45:00',26,500.00,'','0'),
(566,26,'2020-12-01','2020-12-30 09:17:05',3,1000.00,'','0'),
(567,26,'2020-12-01','2020-12-30 09:17:15',3,50.00,'','0'),
(568,26,'2020-12-01','2020-12-30 09:18:30',3,1000.00,'','0'),
(569,26,'2020-12-01','2020-12-30 09:20:18',24,600.00,'','1'),
(570,26,'2020-12-01','2020-12-30 09:25:00',24,59.00,'','0'),
(571,26,'2020-12-01','2020-12-30 09:25:13',24,150.00,'','0'),
(572,26,'2020-12-01','2020-12-30 09:26:59',24,100.00,'','0'),
(573,26,'2020-12-01','2020-12-30 09:30:25',24,600.00,'','0'),
(574,26,'2020-12-01','2020-12-30 09:35:16',7,4000.00,'','0'),
(575,26,'2020-12-01','2020-12-30 09:36:37',11,450.00,'','0'),
(576,26,'2020-12-01','2020-12-30 09:36:47',11,500.00,'','0'),
(577,26,'2021-01-01','2021-01-02 16:43:07',24,800.00,'','0'),
(578,26,'2021-01-01','2021-01-04 15:47:42',11,50.00,'','0'),
(579,26,'2021-01-01','2021-01-04 15:47:47',8,50.00,'','0'),
(580,26,'2021-01-01','2021-01-04 15:47:55',25,50.00,'','0'),
(581,26,'2021-01-01','2021-01-04 15:48:02',18,50.00,'','0'),
(582,26,'2021-01-01','2021-01-04 15:48:09',21,50.00,'','0'),
(583,26,'2021-01-01','2021-01-04 15:48:15',12,50.00,'','0'),
(584,26,'2021-01-01','2021-01-04 15:48:21',17,50.00,'','0'),
(585,26,'2021-01-01','2021-01-04 15:48:26',23,50.00,'','0'),
(586,26,'2021-01-01','2021-01-04 15:48:32',7,50.00,'','0'),
(587,26,'2021-01-01','2021-01-04 15:48:39',26,50.00,'','0'),
(588,26,'2021-01-01','2021-01-04 15:48:49',22,50.00,'','0'),
(589,26,'2021-01-01','2021-01-04 15:48:55',24,50.00,'','0'),
(590,26,'2021-01-01','2021-01-05 18:41:19',24,950.00,'','0'),
(591,26,'2021-01-01','2021-01-05 18:41:28',24,1930.00,'','0'),
(592,26,'2021-01-01','2021-01-11 12:17:24',11,200.00,'','0'),
(593,26,'2021-01-01','2021-01-11 12:17:31',8,200.00,'','0'),
(594,26,'2021-01-01','2021-01-11 12:17:40',18,200.00,'','0'),
(595,26,'2021-01-01','2021-01-11 12:17:46',21,200.00,'','0'),
(596,26,'2021-01-01','2021-01-11 12:17:53',12,200.00,'','0'),
(597,26,'2021-01-01','2021-01-11 12:17:59',17,200.00,'','0'),
(598,26,'2021-01-01','2021-01-11 12:18:05',7,200.00,'','0'),
(599,26,'2021-01-01','2021-01-11 12:18:14',24,200.00,'','0'),
(600,26,'2021-01-01','2021-01-11 12:18:20',3,200.00,'','0'),
(601,26,'2021-01-01','2021-01-11 12:18:29',26,200.00,'','0'),
(602,26,'2021-01-01','2021-01-11 12:18:37',6,200.00,'','0'),
(603,26,'2021-01-01','2021-01-11 12:18:44',5,200.00,'','0'),
(604,26,'2021-01-01','2021-01-11 12:18:49',22,200.00,'','0'),
(605,26,'2021-01-01','2021-01-11 12:19:39',24,150.00,'','0'),
(606,26,'2021-01-01','2021-01-20 17:40:20',18,1200.00,'','0'),
(607,26,'2021-01-01','2021-01-20 17:40:39',12,300.00,'','0'),
(608,26,'2021-01-01','2021-01-20 17:41:04',21,1000.00,'','0'),
(609,26,'2021-01-01','2021-01-20 17:41:21',7,200.00,'','0'),
(610,26,'2021-01-01','2021-01-20 17:41:49',24,100.00,'','0'),
(611,26,'2021-01-01','2021-01-20 17:41:53',24,200.00,'','0'),
(612,26,'2021-01-01','2021-01-20 17:41:59',24,2000.00,'','0'),
(613,26,'2021-01-01','2021-01-20 17:42:06',24,1561.00,'','0'),
(614,26,'2021-01-01','2021-01-20 17:42:21',3,1000.00,'','0'),
(615,26,'2021-01-01','2021-01-20 17:42:29',3,2560.00,'','0'),
(616,26,'2021-01-01','2021-01-20 17:42:45',6,500.00,'','0'),
(617,26,'2021-01-01','2021-01-22 09:23:50',7,500.00,'','0'),
(618,26,'2021-01-01','2021-01-22 09:24:02',6,500.00,'','0'),
(619,26,'2021-01-01','2021-01-25 17:33:32',12,273.00,'','0'),
(620,26,'2021-01-01','2021-01-25 17:34:02',24,158.00,'','0'),
(621,26,'2021-01-01','2021-01-25 17:34:10',24,200.00,'','0'),
(622,26,'2021-01-01','2021-01-25 17:34:31',24,500.00,'','0'),
(623,26,'2021-01-01','2021-01-25 17:34:37',24,500.00,'','0'),
(624,26,'2021-01-01','2021-01-25 17:34:43',24,1000.00,'','0'),
(625,26,'2021-01-01','2021-01-25 17:34:55',3,265.00,'','0'),
(626,26,'2021-01-01','2021-01-25 17:35:03',3,2200.00,'','0'),
(627,26,'2021-01-01','2021-01-29 17:19:21',8,500.00,'','0'),
(628,26,'2021-01-01','2021-01-29 17:42:02',17,500.00,'','0'),
(629,26,'2021-01-01','2021-01-30 14:28:31',18,250.00,'','0'),
(630,26,'2021-01-01','2021-01-30 14:34:27',6,800.00,'','0'),
(631,26,'2021-01-01','2021-01-30 14:35:02',3,6000.00,'','0'),
(632,26,'2021-01-01','2021-01-30 14:35:14',3,500.00,'','0'),
(633,26,'2021-01-01','2021-01-30 14:35:24',3,1643.00,'','0'),
(634,26,'2021-01-01','2021-01-30 14:35:31',3,5000.00,'','0'),
(635,26,'2021-01-01','2021-01-30 14:36:12',24,300.00,'','0'),
(636,26,'2021-01-01','2021-01-30 14:36:20',24,1500.00,'','0'),
(637,26,'2021-01-01','2021-01-31 12:10:44',24,1000.00,'','0'),
(638,26,'2021-01-01','2021-01-31 12:14:50',24,1200.00,'','0'),
(639,26,'2021-01-01','2021-01-31 12:25:59',3,550.00,'','0'),
(640,26,'2021-02-01','2021-02-27 09:08:13',22,50.00,'','0'),
(641,26,'2021-02-01','2021-02-27 09:08:31',22,26.00,'','0'),
(642,26,'2021-02-01','2021-02-27 09:08:46',5,50.00,'','0'),
(643,26,'2021-02-01','2021-02-27 09:08:54',5,100.00,'','0'),
(644,26,'2021-02-01','2021-02-27 09:09:03',22,80.00,'','0'),
(645,26,'2021-02-01','2021-02-27 09:09:23',5,80.00,'','0'),
(646,26,'2021-02-01','2021-02-27 09:10:05',6,50.00,'','0'),
(647,26,'2021-02-01','2021-02-27 09:10:11',6,1000.00,'','0'),
(648,26,'2021-02-01','2021-02-27 09:10:16',6,500.00,'','0'),
(649,26,'2021-02-01','2021-02-27 09:10:23',6,466.00,'','0'),
(650,26,'2021-02-01','2021-02-27 09:10:32',6,80.00,'','0'),
(651,26,'2021-02-01','2021-02-27 09:11:34',26,1000.00,'','0'),
(652,26,'2021-02-01','2021-02-27 09:11:44',26,25.00,'','0'),
(653,26,'2021-02-01','2021-02-27 09:12:38',7,50.00,'','0'),
(654,26,'2021-02-01','2021-02-27 09:12:46',7,315.00,'','0'),
(655,26,'2021-02-01','2021-02-27 09:12:51',7,56.00,'','0'),
(656,26,'2021-02-01','2021-02-27 09:13:00',7,200.00,'','0'),
(657,26,'2021-02-01','2021-02-27 09:13:07',7,1000.00,'','0'),
(658,26,'2021-02-01','2021-02-27 09:13:16',7,60.00,'','0'),
(659,26,'2021-02-01','2021-02-27 09:13:25',7,240.00,'','0'),
(660,26,'2021-02-01','2021-02-27 09:13:32',7,80.00,'','0'),
(661,26,'2021-02-01','2021-02-27 09:15:10',23,80.00,'','0'),
(662,26,'2021-02-01','2021-02-27 09:15:34',17,80.00,'','0'),
(663,26,'2021-02-01','2021-02-27 09:15:53',12,1100.00,'','0'),
(664,26,'2021-02-01','2021-02-27 09:16:01',12,25.00,'','0'),
(665,26,'2021-02-01','2021-02-27 09:16:07',12,80.00,'','0'),
(666,26,'2021-02-01','2021-02-27 09:16:40',21,2000.00,'','0'),
(667,26,'2021-02-01','2021-02-27 09:16:47',21,25.00,'','0'),
(668,26,'2021-02-01','2021-02-27 09:16:53',21,80.00,'','0'),
(669,26,'2021-02-01','2021-02-27 09:17:35',18,100.00,'','0'),
(670,26,'2021-02-01','2021-02-27 09:17:40',18,56.00,'','0'),
(671,26,'2021-02-01','2021-02-27 09:17:46',18,80.00,'','0'),
(672,26,'2021-02-01','2021-02-27 09:18:28',8,56.00,'','0'),
(673,26,'2021-02-01','2021-02-27 09:18:39',8,1000.00,'','0'),
(674,26,'2021-02-01','2021-02-27 09:18:47',8,25.00,'','0'),
(675,26,'2021-02-01','2021-02-27 09:18:54',8,80.00,'','0'),
(676,26,'2021-02-01','2021-02-27 09:19:37',11,500.00,'','0'),
(677,26,'2021-02-01','2021-02-27 09:19:43',11,56.00,'','0'),
(678,26,'2021-02-01','2021-02-27 09:19:51',11,500.00,'','0'),
(679,26,'2021-02-01','2021-02-27 09:20:10',11,25.00,'','0'),
(680,26,'2021-02-01','2021-02-27 09:20:17',11,80.00,'','0'),
(681,26,'2021-02-01','2021-02-27 09:20:45',20,50.00,'','0'),
(682,26,'2021-02-01','2021-02-27 09:20:49',20,80.00,'','0'),
(683,26,'2021-02-01','2021-02-27 09:22:10',24,1000.00,'','0'),
(684,26,'2021-02-01','2021-02-27 09:22:15',24,100.00,'','0'),
(685,26,'2021-02-01','2021-02-27 09:22:19',24,200.00,'','0'),
(686,26,'2021-02-01','2021-02-27 09:22:26',24,56.00,'','0'),
(687,26,'2021-02-01','2021-02-27 09:22:35',24,58.00,'','0'),
(688,26,'2021-02-01','2021-02-27 09:22:42',24,6000.00,'','0'),
(689,26,'2021-02-01','2021-02-27 09:22:50',24,600.00,'','0'),
(690,26,'2021-02-01','2021-02-27 09:22:57',24,1600.00,'','0'),
(691,26,'2021-02-01','2021-02-27 09:23:06',24,27.00,'','0'),
(692,26,'2021-02-01','2021-02-27 09:23:14',24,32.00,'','0'),
(693,26,'2021-02-01','2021-02-27 09:23:21',24,200.00,'','0'),
(694,26,'2021-02-01','2021-02-27 09:23:26',24,1000.00,'','0'),
(695,26,'2021-02-01','2021-02-27 09:23:32',24,84.00,'','0'),
(696,26,'2021-02-01','2021-02-27 09:23:38',24,1300.00,'','0'),
(697,26,'2021-02-01','2021-02-27 09:23:44',24,53.00,'','0'),
(698,26,'2021-02-01','2021-02-27 09:23:50',24,500.00,'','0'),
(699,26,'2021-02-01','2021-02-27 09:23:59',24,500.00,'','0'),
(700,26,'2021-02-01','2021-02-27 09:24:09',24,850.00,'','0'),
(701,26,'2021-02-01','2021-02-27 09:24:16',24,500.00,'','0'),
(702,26,'2021-02-01','2021-02-27 09:24:23',24,1500.00,'','0'),
(703,26,'2021-02-01','2021-02-27 09:24:31',24,349.00,'','0'),
(704,26,'2021-02-01','2021-02-27 09:24:41',24,1500.00,'','0'),
(705,26,'2021-02-01','2021-02-27 09:24:58',24,800.00,'','0'),
(706,26,'2021-02-01','2021-02-27 09:25:03',24,44.00,'','0'),
(707,26,'2021-02-01','2021-02-27 09:43:22',3,170.00,'','0'),
(708,26,'2021-02-01','2021-02-27 09:43:28',3,92.00,'','0'),
(709,26,'2021-02-01','2021-02-27 09:43:35',3,200.00,'','0'),
(710,26,'2021-02-01','2021-02-27 09:43:41',3,405.00,'','0'),
(711,26,'2021-02-01','2021-02-27 09:43:47',3,365.00,'','0'),
(712,26,'2021-02-01','2021-02-27 09:43:53',3,489.00,'','0'),
(713,26,'2021-02-01','2021-02-27 09:43:59',3,165.00,'','0'),
(714,26,'2021-02-01','2021-02-27 09:44:08',3,165.00,'','0'),
(715,26,'2021-02-01','2021-02-27 09:44:13',3,56.00,'','0'),
(716,26,'2021-02-01','2021-02-27 09:44:20',3,63.00,'','0'),
(717,26,'2021-02-01','2021-02-27 09:44:27',3,400.00,'','0'),
(718,26,'2021-02-01','2021-02-27 09:44:35',3,100.00,'','0'),
(719,26,'2021-02-01','2021-02-27 09:44:41',3,500.00,'','0'),
(720,26,'2021-02-01','2021-02-27 09:44:48',3,3770.00,'','0'),
(721,26,'2021-02-01','2021-02-27 09:44:55',3,1445.00,'','0'),
(722,26,'2021-02-01','2021-02-27 09:45:03',3,2570.00,'','0'),
(723,26,'2021-02-01','2021-02-27 09:45:09',3,245.00,'','0'),
(724,26,'2021-02-01','2021-02-27 09:45:15',3,800.00,'','0'),
(725,26,'2021-02-01','2021-02-27 09:45:24',3,18360.00,'','0'),
(726,26,'2021-02-01','2021-02-27 09:45:32',3,24.00,'','0'),
(727,26,'2021-02-01','2021-02-27 09:45:39',3,5000.00,'','0'),
(728,26,'2021-02-01','2021-02-27 09:46:45',3,4000.00,'','0'),
(729,26,'2021-02-01','2021-02-27 09:46:53',3,1600.00,'','0'),
(730,26,'2021-02-01','2021-02-27 09:47:01',3,7000.00,'','0'),
(731,26,'2021-02-01','2021-02-27 09:47:08',3,1021.00,'','0'),
(732,26,'2021-02-01','2021-02-27 09:47:15',3,61.00,'','0'),
(733,26,'2021-02-01','2021-02-27 09:47:22',3,4750.00,'','0'),
(734,26,'2021-02-01','2021-02-27 09:47:31',3,100.00,'','0'),
(735,26,'2021-02-01','2021-02-27 09:47:39',3,1100.00,'','0'),
(736,26,'2021-02-01','2021-02-27 09:47:46',3,1348.00,'','0'),
(737,26,'2021-02-01','2021-02-27 09:47:53',3,480.00,'','0'),
(738,26,'2021-02-01','2021-02-27 09:48:00',3,5120.00,'','0'),
(739,26,'2021-02-01','2021-02-27 11:38:33',3,80.00,'','0'),
(740,26,'2021-02-01','2021-02-27 16:56:28',11,200.00,'','0'),
(741,26,'2021-02-01','2021-02-27 17:04:01',12,350.00,'','0'),
(742,26,'2021-03-01','2021-03-17 14:34:40',22,800.00,'','0'),
(743,26,'2021-03-01','2021-03-17 14:34:52',22,200.00,'','0'),
(744,26,'2021-03-01','2021-03-17 14:35:25',6,200.00,'','0'),
(745,26,'2021-03-01','2021-03-17 14:35:38',26,50.00,'','0'),
(746,26,'2021-03-01','2021-03-17 14:35:43',26,1000.00,'','0'),
(747,26,'2021-03-01','2021-03-17 14:35:48',26,200.00,'','0'),
(748,26,'2021-03-01','2021-03-17 14:36:54',3,6635.00,'','0'),
(749,26,'2021-03-01','2021-03-17 14:37:03',3,1835.00,'','0'),
(750,26,'2021-03-01','2021-03-17 14:37:11',3,9652.00,'','0'),
(751,26,'2021-03-01','2021-03-17 14:37:18',3,250.00,'','0'),
(752,26,'2021-03-01','2021-03-17 14:37:26',3,10000.00,'','0'),
(753,26,'2021-03-01','2021-03-17 14:37:34',3,250.00,'','0'),
(754,26,'2021-03-01','2021-03-17 14:37:46',3,130.00,'','0'),
(755,26,'2021-03-01','2021-03-17 14:37:53',3,5000.00,'','1'),
(756,26,'2021-03-01','2021-03-17 14:38:01',3,4523.00,'','1'),
(757,26,'2021-03-01','2021-03-17 14:38:09',3,5000.00,'','0'),
(758,26,'2021-03-01','2021-03-17 14:38:15',3,4523.00,'','0'),
(759,26,'2021-03-01','2021-03-17 14:38:24',3,2568.00,'','0'),
(760,26,'2021-03-01','2021-03-17 14:38:31',3,2000.00,'','0'),
(761,26,'2021-03-01','2021-03-17 14:38:39',3,200.00,'','0'),
(762,26,'2021-03-01','2021-03-17 14:38:46',3,1000.00,'','0'),
(763,26,'2021-03-01','2021-03-17 14:38:57',3,150.00,'','0'),
(764,26,'2021-03-01','2021-03-17 14:39:04',3,2570.00,'','0'),
(765,26,'2021-03-01','2021-03-17 14:39:12',3,300.00,'','0'),
(766,26,'2021-03-01','2021-03-17 14:39:22',3,470.00,'','0'),
(767,26,'2021-03-01','2021-03-17 14:39:47',24,3000.00,'','0'),
(768,26,'2021-03-01','2021-03-17 14:39:51',24,200.00,'','0'),
(769,26,'2021-03-01','2021-03-17 14:39:55',24,200.00,'','0'),
(770,26,'2021-03-01','2021-03-17 14:40:00',24,56.00,'','0'),
(771,26,'2021-03-01','2021-03-17 14:40:04',24,50.00,'','0'),
(772,26,'2021-03-01','2021-03-17 14:40:15',24,4194.00,'','0'),
(773,26,'2021-03-01','2021-03-17 14:40:21',24,61.00,'','0'),
(774,26,'2021-03-01','2021-03-17 14:40:33',24,200.00,'','0'),
(775,26,'2021-03-01','2021-03-17 14:40:40',24,27.00,'','0'),
(776,26,'2021-03-01','2021-03-17 14:40:46',24,1600.00,'','0'),
(777,26,'2021-03-01','2021-03-17 14:41:13',7,50.00,'','0'),
(778,26,'2021-03-01','2021-03-17 14:41:17',7,200.00,'','0'),
(779,26,'2021-03-01','2021-03-17 14:41:46',17,500.00,'','0'),
(780,26,'2021-03-01','2021-03-17 14:41:51',17,50.00,'','0'),
(781,26,'2021-03-01','2021-03-17 14:41:55',17,200.00,'','0'),
(782,26,'2021-03-01','2021-03-17 14:42:07',12,50.00,'','0'),
(783,26,'2021-03-01','2021-03-17 14:42:11',12,200.00,'','0'),
(784,26,'2021-03-01','2021-03-17 14:42:38',21,500.00,'','0'),
(785,26,'2021-03-01','2021-03-17 14:42:47',21,1500.00,'','0'),
(786,26,'2021-03-01','2021-03-17 14:42:51',21,200.00,'','0'),
(787,26,'2021-03-01','2021-03-17 14:43:10',18,50.00,'','0'),
(788,26,'2021-03-01','2021-03-17 14:43:15',18,1000.00,'','0'),
(789,26,'2021-03-01','2021-03-17 14:43:20',18,200.00,'','0'),
(790,26,'2021-03-01','2021-03-17 14:43:23',18,200.00,'','0'),
(791,26,'2021-03-01','2021-03-17 14:43:41',8,50.00,'','0'),
(792,26,'2021-03-01','2021-03-17 14:43:52',8,200.00,'','0'),
(793,26,'2021-03-01','2021-03-17 14:44:12',11,500.00,'','0'),
(794,26,'2021-03-01','2021-03-17 14:44:17',11,1000.00,'','0'),
(795,26,'2021-03-01','2021-03-17 14:44:52',11,200.00,'','0'),
(796,26,'2021-03-01','2021-03-17 14:45:04',20,200.00,'','0'),
(797,26,'2021-03-01','2021-03-20 14:59:17',8,500.00,'','0'),
(798,26,'2021-03-01','2021-03-23 09:48:26',11,420.00,'','0'),
(799,26,'2021-03-01','2021-03-23 09:53:47',6,305.00,'','0'),
(800,26,'2021-03-01','2021-03-27 14:39:50',24,800.00,'','0'),
(801,26,'2021-03-01','2021-03-27 14:39:57',24,500.00,'','0'),
(802,26,'2021-03-01','2021-03-27 14:40:05',24,1000.00,'','0'),
(803,26,'2021-03-01','2021-03-27 14:40:12',24,1500.00,'','0'),
(804,26,'2021-03-01','2021-03-27 14:40:18',24,71.00,'','0'),
(805,26,'2021-03-01','2021-03-27 14:40:25',24,500.00,'','0'),
(806,26,'2021-03-01','2021-03-27 14:40:34',24,1350.00,'','0'),
(807,26,'2021-03-01','2021-03-27 16:00:28',12,200.00,'','0'),
(808,26,'2021-03-01','2021-03-27 17:46:04',18,200.00,'','0'),
(809,26,'2021-03-01','2021-03-27 17:46:09',18,600.00,'','0'),
(810,26,'2021-03-01','2021-03-29 09:34:16',22,200.00,'','0'),
(811,26,'2021-03-01','2021-03-29 09:34:29',5,200.00,'','0'),
(812,26,'2021-03-01','2021-03-29 09:37:04',6,500.00,'','0'),
(813,26,'2021-03-01','2021-03-29 09:37:14',6,200.00,'','0'),
(814,26,'2021-03-01','2021-03-29 09:39:57',3,200.00,'','0'),
(815,26,'2021-03-01','2021-03-29 09:40:05',3,9250.00,'','0'),
(816,26,'2021-03-01','2021-03-29 09:40:14',3,12600.00,'','0'),
(817,26,'2021-03-01','2021-03-29 09:40:23',3,1100.00,'','0'),
(818,26,'2021-03-01','2021-03-29 09:40:50',3,2000.00,'','0'),
(819,26,'2021-03-01','2021-03-29 09:41:03',3,150.00,'','0'),
(820,26,'2021-03-01','2021-03-29 09:41:11',3,188.00,'','0'),
(821,26,'2021-03-01','2021-03-29 09:41:19',3,12500.00,'','0'),
(822,26,'2021-03-01','2021-03-29 09:41:38',3,260.00,'','0'),
(823,26,'2021-03-01','2021-03-29 09:41:45',3,1000.00,'','0'),
(824,26,'2021-03-01','2021-03-29 09:41:54',3,1500.00,'','0'),
(825,26,'2021-03-01','2021-03-29 09:41:59',3,200.00,'','0'),
(826,26,'2021-03-01','2021-03-29 09:42:07',3,1400.00,'','0'),
(827,26,'2021-03-01','2021-03-29 09:42:15',3,250.00,'','0'),
(828,26,'2021-03-01','2021-03-29 09:42:24',3,400.00,'','0'),
(829,26,'2021-03-01','2021-03-29 09:43:06',24,60.00,'','0'),
(830,26,'2021-03-01','2021-03-29 09:43:21',7,500.00,'','0'),
(831,26,'2021-03-01','2021-03-29 09:43:26',7,200.00,'','0'),
(832,26,'2021-03-01','2021-03-29 09:43:35',7,480.00,'','0'),
(833,26,'2021-03-01','2021-03-29 09:43:41',7,6000.00,'','0'),
(834,26,'2021-03-01','2021-03-29 09:44:23',17,200.00,'','0'),
(835,26,'2021-03-01','2021-03-29 09:44:45',21,200.00,'','0'),
(836,26,'2021-03-01','2021-03-29 09:45:08',8,300.00,'','0'),
(837,26,'2021-03-01','2021-03-29 09:45:13',8,200.00,'','0'),
(838,26,'2021-03-01','2021-03-29 09:45:24',11,200.00,'','0'),
(839,26,'2021-03-01','2021-03-29 09:45:31',11,2500.00,'','0'),
(840,26,'2021-03-01','2021-03-29 09:45:37',20,200.00,'','0'),
(841,26,'2021-03-01','2021-03-31 10:09:50',6,300.00,'','0'),
(842,26,'2021-03-01','2021-03-31 10:51:32',18,74.00,'','0'),
(843,26,'2021-03-01','2021-03-31 11:03:32',11,500.00,'','0'),
(844,26,'2021-03-01','2021-03-31 11:11:32',3,260.00,'','1'),
(845,26,'2021-03-01','2021-03-31 11:11:49',3,280.00,'','0'),
(846,26,'2021-03-01','2021-03-31 11:13:39',3,350.00,'','0'),
(847,26,'2021-03-01','2021-03-31 11:13:59',3,260.00,'','0'),
(848,26,'2021-03-01','2021-03-31 11:14:11',3,800.00,'','0'),
(849,26,'2021-03-01','2021-03-31 11:14:39',3,3535.00,'','0'),
(850,26,'2021-03-01','2021-03-31 11:14:50',3,463.00,'','1'),
(851,26,'2021-03-01','2021-03-31 11:59:12',3,463.00,'','0'),
(852,26,'2021-03-01','2021-03-31 12:02:45',3,340.00,'','0'),
(853,26,'2021-03-01','2021-03-31 12:03:24',3,260.00,'','0'),
(854,26,'2021-03-01','2021-03-31 17:48:49',7,288.00,'','0'),
(855,26,'2021-03-01','2021-03-31 17:49:14',7,104.00,'','0'),
(856,26,'2021-04-01','2021-04-30 09:59:40',5,120.00,'','0'),
(857,26,'2021-04-01','2021-04-30 09:59:48',5,240.00,'','0'),
(858,26,'2021-04-01','2021-04-30 09:59:54',5,20.00,'','0'),
(859,26,'2021-04-01','2021-04-30 10:00:59',6,150.00,'','0'),
(860,26,'2021-04-01','2021-04-30 10:01:06',6,398.00,'','0'),
(861,26,'2021-04-01','2021-04-30 10:01:13',6,4000.00,'','0'),
(862,26,'2021-04-01','2021-04-30 10:02:15',7,320.00,'','0'),
(863,26,'2021-04-01','2021-04-30 10:02:21',7,890.00,'','0'),
(864,26,'2021-04-01','2021-04-30 10:03:04',26,4000.00,'','0'),
(865,26,'2021-04-01','2021-04-30 10:03:37',3,5000.00,'','0'),
(866,26,'2021-04-01','2021-04-30 10:03:44',3,1000.00,'','0'),
(867,26,'2021-04-01','2021-04-30 10:03:49',3,339.00,'','0'),
(868,26,'2021-04-01','2021-04-30 10:03:56',3,375.00,'','0'),
(869,26,'2021-04-01','2021-04-30 10:04:03',3,75.00,'','0'),
(870,26,'2021-04-01','2021-04-30 10:04:09',3,1300.00,'','0'),
(871,26,'2021-04-01','2021-04-30 10:04:14',3,245.00,'','0'),
(872,26,'2021-04-01','2021-04-30 10:04:21',3,200.00,'','0'),
(873,26,'2021-04-01','2021-04-30 10:04:29',3,220.00,'','0'),
(874,26,'2021-04-01','2021-04-30 10:04:37',3,1485.00,'','0'),
(875,26,'2021-04-01','2021-04-30 10:04:44',3,1000.00,'','0'),
(876,26,'2021-04-01','2021-04-30 10:04:51',3,840.00,'','0'),
(877,26,'2021-04-01','2021-04-30 10:04:57',3,100.00,'','0'),
(878,26,'2021-04-01','2021-04-30 10:05:03',3,1200.00,'','0'),
(879,26,'2021-04-01','2021-04-30 10:05:08',3,159.00,'','0'),
(880,26,'2021-04-01','2021-04-30 10:05:14',3,310.00,'','0'),
(881,26,'2021-04-01','2021-04-30 10:05:20',3,100.00,'','0'),
(882,26,'2021-04-01','2021-04-30 10:05:27',3,110.00,'','0'),
(883,26,'2021-04-01','2021-04-30 10:05:34',3,99.00,'','0'),
(884,26,'2021-04-01','2021-04-30 10:05:45',3,90.00,'','0'),
(885,26,'2021-04-01','2021-04-30 10:06:42',3,3037.00,'','0'),
(886,26,'2021-04-01','2021-04-30 10:06:50',3,2275.00,'','0'),
(887,26,'2021-04-01','2021-04-30 10:07:00',3,100.00,'','0'),
(888,26,'2021-04-01','2021-04-30 10:07:08',3,1000.00,'','0'),
(889,26,'2021-04-01','2021-04-30 10:07:16',3,10000.00,'','0'),
(890,26,'2021-04-01','2021-04-30 10:07:23',3,2570.00,'','0'),
(891,26,'2021-04-01','2021-04-30 10:07:31',3,5720.00,'','0'),
(892,26,'2021-04-01','2021-04-30 10:07:37',3,290.00,'','0'),
(893,26,'2021-04-01','2021-04-30 10:07:44',3,100.00,'','0'),
(894,26,'2021-04-01','2021-04-30 10:07:51',3,300.00,'','0'),
(895,26,'2021-04-01','2021-04-30 10:07:57',3,150.00,'','0'),
(896,26,'2021-04-01','2021-04-30 10:08:04',3,100.00,'','0'),
(897,26,'2021-04-01','2021-04-30 10:08:13',3,960.00,'','0'),
(898,26,'2021-04-01','2021-04-30 10:08:20',3,300.00,'','0'),
(899,26,'2021-04-01','2021-04-30 10:08:28',3,150.00,'','0'),
(900,26,'2021-04-01','2021-04-30 10:08:35',3,280.00,'','0'),
(901,26,'2021-04-01','2021-04-30 10:08:45',3,1013.00,'','0'),
(902,26,'2021-04-01','2021-04-30 10:08:52',3,2000.00,'','0'),
(903,26,'2021-04-01','2021-04-30 10:08:59',3,500.00,'','0'),
(904,26,'2021-04-01','2021-04-30 10:09:06',3,2956.00,'','0'),
(905,26,'2021-04-01','2021-04-30 10:09:14',3,1740.00,'','0'),
(906,26,'2021-04-01','2021-04-30 10:09:20',3,395.00,'','0'),
(907,26,'2021-04-01','2021-04-30 10:09:27',3,95.00,'','0'),
(908,26,'2021-04-01','2021-04-30 10:09:35',3,3000.00,'','0'),
(909,26,'2021-04-01','2021-04-30 10:09:43',3,2600.00,'','0'),
(910,26,'2021-04-01','2021-04-30 10:09:50',3,7500.00,'','0'),
(911,26,'2021-04-01','2021-04-30 10:09:57',3,300.00,'','0'),
(912,26,'2021-04-01','2021-04-30 10:10:03',3,1000.00,'','0'),
(913,26,'2021-04-01','2021-04-30 10:10:27',24,46.00,'','0'),
(914,26,'2021-04-01','2021-04-30 10:10:32',24,120.00,'','0'),
(915,26,'2021-04-01','2021-04-30 10:10:39',24,1140.00,'','0'),
(916,26,'2021-04-01','2021-04-30 10:10:45',24,487.00,'','0'),
(917,26,'2021-04-01','2021-04-30 10:10:52',24,300.00,'','0'),
(918,26,'2021-04-01','2021-04-30 10:10:59',24,5000.00,'','0'),
(919,26,'2021-04-01','2021-04-30 10:11:06',24,227.00,'','0'),
(920,26,'2021-04-01','2021-04-30 10:11:58',24,1000.00,'','0'),
(921,26,'2021-04-01','2021-04-30 10:12:06',24,1600.00,'','0'),
(922,26,'2021-04-01','2021-04-30 10:12:12',24,2000.00,'','0'),
(923,26,'2021-04-01','2021-04-30 10:12:17',24,25.00,'','0'),
(924,26,'2021-04-01','2021-04-30 10:12:25',24,59.00,'','0'),
(925,26,'2021-04-01','2021-04-30 10:12:33',24,27.00,'','0'),
(926,26,'2021-04-01','2021-04-30 10:12:41',24,27.00,'','0'),
(927,26,'2021-04-01','2021-04-30 10:12:47',24,25.00,'','0'),
(928,26,'2021-04-01','2021-04-30 10:12:55',24,200.00,'','0'),
(929,26,'2021-04-01','2021-04-30 10:13:01',24,250.00,'','0'),
(930,26,'2021-04-01','2021-04-30 10:13:08',24,200.00,'','0'),
(931,26,'2021-04-01','2021-04-30 10:13:13',24,27.00,'','0'),
(932,26,'2021-04-01','2021-04-30 10:13:20',24,200.00,'','0'),
(933,26,'2021-04-01','2021-04-30 10:13:28',24,3000.00,'','0'),
(934,26,'2021-04-01','2021-04-30 10:13:35',24,61.00,'','0'),
(935,26,'2021-04-01','2021-04-30 10:13:40',24,2000.00,'','0'),
(936,26,'2021-04-01','2021-04-30 10:13:48',24,54.00,'','0'),
(937,26,'2021-04-01','2021-04-30 10:13:55',24,987.00,'','0'),
(938,26,'2021-04-01','2021-04-30 10:20:54',17,54.00,'','0'),
(939,26,'2021-04-01','2021-04-30 10:45:34',12,1000.00,'','0'),
(940,26,'2021-04-01','2021-04-30 10:46:15',21,1000.00,'','0'),
(941,26,'2021-04-01','2021-04-30 10:46:34',18,28.00,'','0'),
(942,26,'2021-04-01','2021-04-30 10:46:47',18,100.00,'','0'),
(943,26,'2021-04-01','2021-04-30 10:46:52',18,1000.00,'','0'),
(944,26,'2021-04-01','2021-04-30 10:46:59',18,71.00,'','0'),
(945,26,'2021-04-01','2021-04-30 10:47:08',18,120.00,'','0'),
(946,26,'2021-04-01','2021-04-30 10:47:14',18,100.00,'','0'),
(947,26,'2021-04-01','2021-04-30 10:47:19',18,300.00,'','0'),
(948,26,'2021-04-01','2021-04-30 10:47:27',18,25.00,'','0'),
(949,26,'2021-04-01','2021-04-30 10:47:34',18,500.00,'','0'),
(950,26,'2021-04-01','2021-04-30 10:47:46',18,54.00,'','0'),
(951,26,'2021-04-01','2021-04-30 10:48:06',32,1000.00,'','0'),
(952,26,'2021-04-01','2021-04-30 10:48:13',32,175.00,'','0'),
(953,26,'2021-04-01','2021-04-30 10:48:35',8,500.00,'','0'),
(954,26,'2021-04-01','2021-04-30 10:48:43',8,1500.00,'','0'),
(955,26,'2021-04-01','2021-04-30 10:48:51',8,75.00,'','0'),
(956,26,'2021-04-01','2021-04-30 10:49:00',8,300.00,'','0'),
(957,26,'2021-04-01','2021-04-30 10:49:47',11,500.00,'','0'),
(958,26,'2021-04-01','2021-04-30 10:49:58',11,2000.00,'','0'),
(959,26,'2021-04-01','2021-04-30 10:50:07',11,310.00,'','0'),
(960,26,'2021-04-01','2021-04-30 10:50:16',11,470.00,'','0'),
(961,26,'2021-04-01','2021-04-30 10:50:41',11,500.00,'','0'),
(962,26,'2021-04-01','2021-04-30 10:50:45',11,500.00,'','0'),
(963,26,'2021-04-01','2021-04-30 10:52:04',20,180.00,'','0'),
(964,26,'2021-04-01','2021-04-30 17:35:54',24,27.00,'','0'),
(965,26,'2021-04-01','2021-04-30 17:35:59',24,25.00,'','0'),
(966,26,'2021-05-01','2021-05-31 12:12:06',22,200.00,'','0'),
(967,26,'2021-05-01','2021-05-31 12:12:10',22,200.00,'','0'),
(968,26,'2021-05-01','2021-05-31 12:16:36',5,200.00,'','0'),
(969,26,'2021-05-01','2021-05-31 12:16:46',5,25.00,'','0'),
(970,26,'2021-05-01','2021-05-31 12:16:51',5,200.00,'','0'),
(971,26,'2021-05-01','2021-05-31 12:17:40',6,1000.00,'','0'),
(972,26,'2021-05-01','2021-05-31 12:17:46',6,1134.00,'','0'),
(973,26,'2021-05-01','2021-05-31 12:17:53',6,200.00,'','0'),
(974,26,'2021-05-01','2021-05-31 12:17:56',6,200.00,'','0'),
(975,26,'2021-05-01','2021-05-31 12:18:01',6,200.00,'','0'),
(976,26,'2021-05-01','2021-05-31 12:19:26',26,3000.00,'','0'),
(977,26,'2021-05-01','2021-05-31 12:19:33',26,2000.00,'','0'),
(978,26,'2021-05-01','2021-05-31 12:19:39',26,200.00,'','0'),
(979,26,'2021-05-01','2021-05-31 12:19:42',26,200.00,'','0'),
(980,26,'2021-05-01','2021-05-31 12:20:10',26,150.00,'','0'),
(981,26,'2021-05-01','2021-05-31 12:20:24',3,100.00,'','0'),
(982,26,'2021-05-01','2021-05-31 12:20:36',3,945.00,'','0'),
(983,26,'2021-05-01','2021-05-31 12:20:43',3,300.00,'','0'),
(984,26,'2021-05-01','2021-05-31 12:20:49',3,3815.00,'','0'),
(985,26,'2021-05-01','2021-05-31 12:20:56',3,2062.00,'','0'),
(986,26,'2021-05-01','2021-05-31 12:21:03',3,5000.00,'','0'),
(987,26,'2021-05-01','2021-05-31 12:21:09',3,100.00,'','0'),
(988,26,'2021-05-01','2021-05-31 12:21:14',3,60.00,'','0'),
(989,26,'2021-05-01','2021-05-31 12:21:21',3,5000.00,'','0'),
(990,26,'2021-05-01','2021-05-31 12:21:26',3,532.00,'','0'),
(991,26,'2021-05-01','2021-05-31 12:21:32',3,2540.00,'','0'),
(992,26,'2021-05-01','2021-05-31 12:21:38',3,4000.00,'','0'),
(993,26,'2021-05-01','2021-05-31 12:21:43',3,500.00,'','0'),
(994,26,'2021-05-01','2021-05-31 12:21:50',3,480.00,'','0'),
(995,26,'2021-05-01','2021-05-31 12:21:57',3,40.00,'','0'),
(996,26,'2021-05-01','2021-05-31 12:22:04',3,4000.00,'','0'),
(997,26,'2021-05-01','2021-05-31 12:22:08',3,200.00,'','0'),
(998,26,'2021-05-01','2021-05-31 12:22:14',3,6200.00,'','0'),
(999,26,'2021-05-01','2021-05-31 12:22:19',3,100.00,'','0'),
(1000,26,'2021-05-01','2021-05-31 12:22:24',3,100.00,'','0');

INSERT INTO `issuance_wages` VALUES 
(1001,26,'2021-05-01','2021-05-31 12:22:29',3,7000.00,'','0'),
(1002,26,'2021-05-01','2021-05-31 12:22:33',3,200.00,'','0'),
(1003,26,'2021-05-01','2021-05-31 12:22:39',3,1235.00,'','0'),
(1004,26,'2021-05-01','2021-05-31 12:22:47',3,220.00,'','0'),
(1005,26,'2021-05-01','2021-05-31 12:22:55',3,1000.00,'','0'),
(1006,26,'2021-05-01','2021-05-31 12:23:02',3,150.00,'','0'),
(1007,26,'2021-05-01','2021-05-31 12:23:09',3,350.00,'','0'),
(1008,26,'2021-05-01','2021-05-31 12:23:15',3,640.00,'','0'),
(1009,26,'2021-05-01','2021-05-31 12:23:22',3,150.00,'','0'),
(1010,26,'2021-05-01','2021-05-31 12:23:29',3,3000.00,'','0'),
(1011,26,'2021-05-01','2021-05-31 12:23:35',3,400.00,'','0'),
(1012,26,'2021-05-01','2021-05-31 12:23:40',3,100.00,'','0'),
(1013,26,'2021-05-01','2021-05-31 12:23:45',3,341.00,'','0'),
(1014,26,'2021-05-01','2021-05-31 12:23:50',3,71.00,'','0'),
(1015,26,'2021-05-01','2021-05-31 12:24:00',3,1250.00,'','0'),
(1016,26,'2021-05-01','2021-05-31 12:24:06',3,30.00,'','0'),
(1017,26,'2021-05-01','2021-05-31 12:24:14',3,5000.00,'','0'),
(1018,26,'2021-05-01','2021-05-31 12:24:21',3,115.00,'','0'),
(1019,26,'2021-05-01','2021-05-31 12:24:27',3,1100.00,'','0'),
(1020,26,'2021-05-01','2021-05-31 12:24:37',3,74.00,'','0'),
(1021,26,'2021-05-01','2021-05-31 12:25:51',3,500.00,'','0'),
(1022,26,'2021-05-01','2021-05-31 12:26:00',3,170.00,'','0'),
(1023,26,'2021-05-01','2021-05-31 12:26:06',3,10000.00,'','0'),
(1024,26,'2021-05-01','2021-05-31 12:26:12',3,6820.00,'','0'),
(1025,26,'2021-05-01','2021-05-31 12:26:20',3,306.00,'','0'),
(1026,26,'2021-05-01','2021-05-31 12:26:31',3,202.00,'','0'),
(1027,26,'2021-05-01','2021-05-31 12:26:38',3,2200.00,'','0'),
(1028,26,'2021-05-01','2021-05-31 12:26:46',3,14000.00,'','0'),
(1029,26,'2021-05-01','2021-05-31 12:26:52',3,1850.00,'','0'),
(1030,26,'2021-05-01','2021-05-31 12:26:59',3,220.00,'','0'),
(1031,26,'2021-05-01','2021-05-31 12:27:04',3,280.00,'','0'),
(1032,26,'2021-05-01','2021-05-31 12:29:10',24,27.00,'','0'),
(1033,26,'2021-05-01','2021-05-31 12:29:17',24,75.00,'','0'),
(1034,26,'2021-05-01','2021-05-31 12:29:22',24,1000.00,'','0'),
(1035,26,'2021-05-01','2021-05-31 12:29:28',24,200.00,'','0'),
(1036,26,'2021-05-01','2021-05-31 12:29:33',24,1000.00,'','0'),
(1037,26,'2021-05-01','2021-05-31 12:29:39',24,17.00,'','0'),
(1038,26,'2021-05-01','2021-05-31 12:29:47',24,27.00,'','0'),
(1039,26,'2021-05-01','2021-05-31 12:29:54',24,1600.00,'','0'),
(1040,26,'2021-05-01','2021-05-31 12:29:59',24,533.00,'','0'),
(1041,26,'2021-05-01','2021-05-31 12:30:08',24,10.00,'','0'),
(1042,26,'2021-05-01','2021-05-31 12:30:22',24,200.00,'','0'),
(1043,26,'2021-05-01','2021-05-31 12:30:32',24,500.00,'','0'),
(1044,26,'2021-05-01','2021-05-31 12:30:37',24,200.00,'','0'),
(1045,26,'2021-05-01','2021-05-31 12:30:43',24,238.00,'','0'),
(1046,26,'2021-05-01','2021-05-31 12:30:49',24,850.00,'','0'),
(1047,26,'2021-05-01','2021-05-31 12:30:55',24,157.00,'','0'),
(1048,26,'2021-05-01','2021-05-31 12:31:01',24,481.00,'','0'),
(1049,26,'2021-05-01','2021-05-31 12:31:05',24,1000.00,'','0'),
(1050,26,'2021-05-01','2021-05-31 12:31:13',24,400.00,'','0'),
(1051,26,'2021-05-01','2021-05-31 12:31:21',24,120.00,'','0'),
(1052,26,'2021-05-01','2021-05-31 12:45:12',20,200.00,'','0'),
(1053,26,'2021-05-01','2021-05-31 12:45:18',20,200.00,'','0'),
(1054,26,'2021-05-01','2021-05-31 12:45:27',11,89.00,'','0'),
(1055,26,'2021-05-01','2021-05-31 12:45:31',11,200.00,'','0'),
(1056,26,'2021-05-01','2021-05-31 12:45:36',11,200.00,'','0'),
(1057,26,'2021-05-01','2021-05-31 12:45:42',11,160.00,'','0'),
(1058,26,'2021-05-01','2021-05-31 12:45:46',11,1000.00,'','0'),
(1059,26,'2021-05-01','2021-05-31 12:45:52',11,2000.00,'','0'),
(1060,26,'2021-05-01','2021-05-31 12:47:39',7,600.00,'','0'),
(1061,26,'2021-05-01','2021-05-31 12:48:10',7,800.00,'','0'),
(1062,26,'2021-05-01','2021-05-31 12:48:13',7,200.00,'','0'),
(1063,26,'2021-05-01','2021-05-31 12:48:16',7,200.00,'','0'),
(1064,26,'2021-05-01','2021-05-31 12:48:21',7,71.00,'','0'),
(1065,26,'2021-05-01','2021-05-31 12:48:26',7,500.00,'','0'),
(1066,26,'2021-05-01','2021-05-31 12:48:32',7,1014.00,'','0'),
(1067,26,'2021-05-01','2021-05-31 12:48:36',7,1000.00,'','0'),
(1068,26,'2021-05-01','2021-05-31 12:49:50',17,200.00,'','0'),
(1069,26,'2021-05-01','2021-05-31 12:49:53',17,200.00,'','0'),
(1070,26,'2021-05-01','2021-05-31 12:49:58',17,1000.00,'','0'),
(1071,26,'2021-05-01','2021-05-31 12:51:23',12,200.00,'','0'),
(1072,26,'2021-05-01','2021-05-31 12:51:27',12,200.00,'','0'),
(1073,26,'2021-05-01','2021-05-31 12:54:06',21,200.00,'','0'),
(1074,26,'2021-05-01','2021-05-31 12:54:09',21,200.00,'','0'),
(1075,26,'2021-05-01','2021-05-31 12:54:19',21,55.00,'','0'),
(1076,26,'2021-05-01','2021-05-31 12:54:35',18,89.00,'','0'),
(1077,26,'2021-05-01','2021-05-31 12:54:39',18,200.00,'','0'),
(1078,26,'2021-05-01','2021-05-31 12:54:43',18,200.00,'','0'),
(1079,26,'2021-05-01','2021-05-31 12:54:50',18,700.00,'','0'),
(1080,26,'2021-05-01','2021-05-31 12:54:57',18,77.00,'','0'),
(1081,26,'2021-05-01','2021-05-31 12:55:04',18,2000.00,'','0'),
(1082,26,'2021-05-01','2021-05-31 12:55:12',18,300.00,'','0'),
(1083,26,'2021-05-01','2021-05-31 12:55:17',18,300.00,'','0'),
(1084,26,'2021-05-01','2021-05-31 12:57:54',33,150.00,'','0'),
(1085,26,'2021-05-01','2021-05-31 12:58:17',32,200.00,'','0'),
(1086,26,'2021-05-01','2021-05-31 12:59:13',8,200.00,'','0'),
(1087,26,'2021-05-01','2021-05-31 12:59:18',8,300.00,'','0'),
(1088,26,'2021-05-01','2021-05-31 12:59:25',8,400.00,'','0'),
(1089,26,'2021-06-01','2021-06-30 10:29:09',22,200.00,'','0'),
(1090,26,'2021-06-01','2021-06-30 10:29:15',22,200.00,'','0'),
(1091,26,'2021-06-01','2021-06-30 10:29:20',22,200.00,'','0'),
(1092,26,'2021-06-01','2021-06-30 10:39:18',5,50.00,'','0'),
(1093,26,'2021-06-01','2021-06-30 10:39:28',5,200.00,'','0'),
(1094,26,'2021-06-01','2021-06-30 10:39:33',5,200.00,'','0'),
(1095,26,'2021-06-01','2021-06-30 10:40:04',5,200.00,'','0'),
(1096,26,'2021-06-01','2021-06-30 10:40:12',5,200.00,'','0'),
(1097,26,'2021-06-01','2021-06-30 10:40:20',5,160.00,'','0'),
(1098,26,'2021-06-01','2021-06-30 10:41:35',6,100.00,'','1'),
(1099,26,'2021-06-01','2021-06-30 10:41:47',6,200.00,'','0'),
(1100,26,'2021-06-01','2021-06-30 10:41:52',6,200.00,'','0'),
(1101,26,'2021-06-01','2021-06-30 10:42:03',6,200.00,'','0'),
(1102,26,'2021-06-01','2021-06-30 10:42:23',6,2500.00,'','0'),
(1103,26,'2021-06-01','2021-06-30 10:42:30',6,300.00,'','0'),
(1104,26,'2021-06-01','2021-06-30 10:42:38',6,1000.00,'','0'),
(1105,26,'2021-06-01','2021-06-30 10:42:44',6,200.00,'','0'),
(1106,26,'2021-06-01','2021-06-30 11:24:25',3,250.00,'','0'),
(1107,26,'2021-06-01','2021-06-30 11:24:38',3,280.00,'','0'),
(1108,26,'2021-06-01','2021-06-30 11:24:46',3,250.00,'','0'),
(1109,26,'2021-06-01','2021-06-30 11:24:56',3,580.00,'','0'),
(1110,26,'2021-06-01','2021-06-30 11:25:02',3,300.00,'','0'),
(1111,26,'2021-06-01','2021-06-30 11:25:09',3,695.00,'','0'),
(1112,26,'2021-06-01','2021-06-30 11:25:20',3,1000.00,'','0'),
(1113,26,'2021-06-01','2021-06-30 11:25:32',3,200.00,'','0'),
(1114,26,'2021-06-01','2021-06-30 11:25:43',3,1200.00,'','0'),
(1115,26,'2021-06-01','2021-06-30 11:25:50',3,200.00,'','0'),
(1116,26,'2021-06-01','2021-06-30 11:25:59',3,200.00,'','0'),
(1117,26,'2021-06-01','2021-06-30 11:26:06',3,1000.00,'','0'),
(1118,26,'2021-06-01','2021-06-30 11:26:12',3,1000.00,'','0'),
(1119,26,'2021-06-01','2021-06-30 11:26:19',3,100.00,'','0'),
(1120,26,'2021-06-01','2021-06-30 11:26:28',3,1914.00,'','0'),
(1121,26,'2021-06-01','2021-06-30 11:26:39',3,2540.00,'','0'),
(1122,26,'2021-06-01','2021-06-30 11:26:49',3,3000.00,'','0'),
(1123,26,'2021-06-01','2021-06-30 11:40:40',3,884.00,'','0'),
(1124,26,'2021-06-01','2021-06-30 11:40:50',3,423.00,'','0'),
(1125,26,'2021-06-01','2021-06-30 11:41:00',3,3000.00,'','0'),
(1126,26,'2021-06-01','2021-06-30 11:41:07',3,66.00,'','0'),
(1127,26,'2021-06-01','2021-06-30 11:41:18',3,10000.00,'','0'),
(1128,26,'2021-06-01','2021-06-30 11:41:27',3,150.00,'','0'),
(1129,26,'2021-06-01','2021-06-30 11:41:35',3,1000.00,'','0'),
(1130,26,'2021-06-01','2021-06-30 11:41:42',3,200.00,'','0'),
(1131,26,'2021-06-01','2021-06-30 11:41:55',24,9500.00,'','0'),
(1132,26,'2021-06-01','2021-06-30 11:43:30',24,1640.00,'','0'),
(1133,26,'2021-06-01','2021-06-30 11:43:38',24,166.00,'','0'),
(1134,26,'2021-06-01','2021-06-30 11:43:53',24,350.00,'','0'),
(1135,26,'2021-06-01','2021-06-30 11:44:00',24,28.00,'','0'),
(1136,26,'2021-06-01','2021-06-30 11:44:05',24,200.00,'','0'),
(1137,26,'2021-06-01','2021-06-30 11:44:12',24,1400.00,'','0'),
(1138,26,'2021-06-01','2021-06-30 11:44:20',24,200.00,'','0'),
(1139,26,'2021-06-01','2021-06-30 11:44:28',24,200.00,'','0'),
(1140,26,'2021-06-01','2021-06-30 11:44:37',24,1600.00,'','0'),
(1141,26,'2021-06-01','2021-06-30 11:44:48',24,579.00,'','0'),
(1142,26,'2021-06-01','2021-06-30 11:44:59',24,20.00,'','0'),
(1143,26,'2021-06-01','2021-06-30 11:54:46',24,500.00,'','0'),
(1144,26,'2021-06-01','2021-06-30 11:54:55',24,300.00,'','0'),
(1145,26,'2021-06-01','2021-06-30 11:55:04',24,329.00,'','0'),
(1146,26,'2021-06-01','2021-06-30 11:55:11',24,138.00,'','0'),
(1147,26,'2021-06-01','2021-06-30 11:55:18',24,1000.00,'','0'),
(1148,26,'2021-06-01','2021-06-30 11:55:23',24,200.00,'','0'),
(1149,26,'2021-06-01','2021-06-30 11:55:29',24,100.00,'','0'),
(1150,26,'2021-06-01','2021-06-30 11:59:37',7,200.00,'','0'),
(1151,26,'2021-06-01','2021-06-30 11:59:45',7,200.00,'','0'),
(1152,26,'2021-06-01','2021-06-30 12:07:27',7,200.00,'','0'),
(1153,26,'2021-06-01','2021-06-30 12:07:35',7,240.00,'','0'),
(1154,26,'2021-06-01','2021-06-30 12:07:44',7,1000.00,'','0'),
(1155,26,'2021-06-01','2021-06-30 12:07:52',7,5000.00,'','0'),
(1156,26,'2021-06-01','2021-06-30 12:07:59',7,395.00,'','0'),
(1157,26,'2021-06-01','2021-06-30 12:08:04',7,200.00,'','0'),
(1158,26,'2021-06-01','2021-06-30 12:08:51',17,200.00,'','0'),
(1159,26,'2021-06-01','2021-06-30 12:08:55',17,200.00,'','0'),
(1160,26,'2021-06-01','2021-06-30 12:09:03',17,480.00,'','0'),
(1161,26,'2021-06-01','2021-06-30 12:11:14',17,200.00,'','0'),
(1162,26,'2021-06-01','2021-06-30 12:19:37',12,200.00,'','0'),
(1163,26,'2021-06-01','2021-06-30 12:19:44',12,200.00,'','0'),
(1164,26,'2021-06-01','2021-06-30 12:19:50',12,200.00,'','0'),
(1165,26,'2021-06-01','2021-06-30 12:19:58',12,2000.00,'','0'),
(1166,26,'2021-06-01','2021-06-30 12:22:56',21,500.00,'','0'),
(1167,26,'2021-06-01','2021-06-30 12:23:02',21,500.00,'','0'),
(1168,26,'2021-06-01','2021-06-30 12:23:06',21,200.00,'','0'),
(1169,26,'2021-06-01','2021-06-30 12:23:11',21,200.00,'','0'),
(1170,26,'2021-06-01','2021-06-30 12:23:21',21,200.00,'','0'),
(1171,26,'2021-06-01','2021-06-30 12:23:35',21,5000.00,'','0'),
(1172,26,'2021-06-01','2021-06-30 12:23:45',21,200.00,'','0'),
(1173,26,'2021-06-01','2021-06-30 13:49:18',18,100.00,'','0'),
(1174,26,'2021-06-01','2021-06-30 13:49:24',18,1000.00,'','0'),
(1175,26,'2021-06-01','2021-06-30 13:49:30',18,143.00,'','0'),
(1176,26,'2021-06-01','2021-06-30 13:49:35',18,200.00,'','0'),
(1177,26,'2021-06-01','2021-06-30 13:49:39',18,200.00,'','0'),
(1178,26,'2021-06-01','2021-06-30 13:49:44',18,100.00,'','0'),
(1179,26,'2021-06-01','2021-06-30 13:49:53',18,500.00,'','0'),
(1180,26,'2021-06-01','2021-06-30 13:49:57',18,100.00,'','0'),
(1181,26,'2021-06-01','2021-06-30 13:50:06',18,100.00,'','0'),
(1182,26,'2021-06-01','2021-06-30 13:50:12',18,200.00,'','0'),
(1183,26,'2021-06-01','2021-06-30 13:50:19',18,2000.00,'','0'),
(1184,26,'2021-06-01','2021-06-30 13:50:25',18,500.00,'','0'),
(1185,26,'2021-06-01','2021-06-30 13:50:29',18,200.00,'','0'),
(1186,26,'2021-06-01','2021-06-30 14:06:34',33,1500.00,'','0'),
(1187,26,'2021-06-01','2021-06-30 14:06:44',33,200.00,'','0'),
(1188,26,'2021-06-01','2021-06-30 14:45:51',32,200.00,'','0'),
(1189,26,'2021-06-01','2021-06-30 14:46:00',32,3000.00,'','0'),
(1190,26,'2021-06-01','2021-06-30 14:46:05',32,200.00,'','0'),
(1191,26,'2021-06-01','2021-06-30 14:46:09',32,200.00,'','0'),
(1192,26,'2021-06-01','2021-06-30 14:46:14',32,200.00,'','0'),
(1193,26,'2021-06-01','2021-06-30 14:49:37',8,200.00,'','0'),
(1194,26,'2021-06-01','2021-06-30 14:49:45',8,200.00,'','0'),
(1195,26,'2021-06-01','2021-06-30 14:49:52',8,200.00,'','0'),
(1196,26,'2021-06-01','2021-06-30 14:59:54',8,480.00,'','0'),
(1197,26,'2021-06-01','2021-06-30 14:59:59',8,200.00,'','0'),
(1198,26,'2021-06-01','2021-06-30 15:19:17',11,200.00,'','0'),
(1199,26,'2021-06-01','2021-06-30 15:19:24',11,200.00,'','0'),
(1200,26,'2021-06-01','2021-06-30 15:20:37',11,200.00,'','0'),
(1201,26,'2021-06-01','2021-06-30 15:20:42',11,2000.00,'','0'),
(1202,26,'2021-06-01','2021-06-30 15:20:51',11,500.00,'','0'),
(1203,26,'2021-06-01','2021-06-30 16:10:56',11,160.00,'','0'),
(1204,26,'2021-06-01','2021-06-30 16:11:02',11,200.00,'','0'),
(1205,26,'2021-06-01','2021-06-30 16:12:21',20,800.00,'','0'),
(1206,26,'2021-06-01','2021-06-30 18:55:04',3,300.00,'','0'),
(1207,26,'2021-06-01','2021-06-30 18:55:20',3,150.00,'','0'),
(1208,26,'2021-06-01','2021-06-30 18:55:27',3,1000.00,'','0'),
(1209,26,'2021-06-01','2021-06-30 18:57:15',3,9439.00,'','0'),
(1210,26,'2021-06-01','2021-06-30 18:58:28',26,200.00,'','0'),
(1211,26,'2021-06-01','2021-06-30 18:58:52',26,3000.00,'','0'),
(1212,26,'2021-06-01','2021-06-30 18:59:06',26,2600.00,'','0'),
(1213,26,'2021-07-01','2021-07-30 16:53:49',22,800.00,'','0'),
(1214,26,'2021-07-01','2021-07-30 16:53:55',22,200.00,'','0'),
(1215,26,'2021-07-01','2021-07-31 09:50:08',5,800.00,'','0'),
(1216,26,'2021-07-01','2021-07-31 09:50:13',5,200.00,'','0'),
(1217,26,'2021-07-01','2021-07-31 09:50:29',6,200.00,'','0'),
(1218,26,'2021-07-01','2021-07-31 09:50:35',6,800.00,'','0'),
(1219,26,'2021-07-01','2021-07-31 09:50:42',6,1000.00,'','0'),
(1220,26,'2021-07-01','2021-07-31 09:50:47',6,2000.00,'','0'),
(1221,26,'2021-07-01','2021-07-31 09:50:52',6,200.00,'','0'),
(1222,26,'2021-07-01','2021-07-31 09:51:02',6,700.00,'','0'),
(1223,26,'2021-07-01','2021-07-31 09:51:08',6,150.00,'','0'),
(1224,26,'2021-07-01','2021-07-31 09:51:15',6,520.00,'','0'),
(1225,26,'2021-07-01','2021-07-31 09:51:22',6,300.00,'','0'),
(1226,26,'2021-07-01','2021-07-31 09:51:55',26,800.00,'','0'),
(1227,26,'2021-07-01','2021-07-31 09:51:59',26,2000.00,'','0'),
(1228,26,'2021-07-01','2021-07-31 09:52:16',3,4950.00,'','0'),
(1229,26,'2021-07-01','2021-07-31 09:52:21',3,200.00,'','0'),
(1230,26,'2021-07-01','2021-07-31 09:54:42',3,3000.00,'','0'),
(1231,26,'2021-07-01','2021-07-31 09:54:43',3,3000.00,'','1'),
(1232,26,'2021-07-01','2021-07-31 09:54:52',3,1230.00,'','0'),
(1233,26,'2021-07-01','2021-07-31 09:54:59',3,2540.00,'','0'),
(1234,26,'2021-07-01','2021-07-31 09:55:05',3,729.00,'','0'),
(1235,26,'2021-07-01','2021-07-31 09:55:19',3,294.00,'','0'),
(1236,26,'2021-07-01','2021-07-31 09:55:27',3,250.00,'','0'),
(1237,26,'2021-07-01','2021-07-31 09:55:32',3,6000.00,'','0'),
(1238,26,'2021-07-01','2021-07-31 09:55:41',3,319.00,'','0'),
(1239,26,'2021-07-01','2021-07-31 09:55:59',3,2000.00,'','0'),
(1240,26,'2021-07-01','2021-07-31 09:56:06',3,2100.00,'','0'),
(1241,26,'2021-07-01','2021-07-31 09:56:12',3,400.00,'','0'),
(1242,26,'2021-07-01','2021-07-31 09:56:22',3,2474.00,'','0'),
(1243,26,'2021-07-01','2021-07-31 09:56:28',3,1230.00,'','0'),
(1244,26,'2021-07-01','2021-07-31 09:57:28',3,1050.00,'','0'),
(1245,26,'2021-07-01','2021-07-31 09:57:35',3,200.00,'','0'),
(1246,26,'2021-07-01','2021-07-31 09:57:40',3,200.00,'','0'),
(1247,26,'2021-07-01','2021-07-31 09:57:46',3,600.00,'','0'),
(1248,26,'2021-07-01','2021-07-31 09:57:53',3,40.00,'','0'),
(1249,26,'2021-07-01','2021-07-31 09:58:02',3,1005.00,'','0'),
(1250,26,'2021-07-01','2021-07-31 09:58:10',3,250.00,'','0'),
(1251,26,'2021-07-01','2021-07-31 09:58:21',3,2500.00,'','0'),
(1252,26,'2021-07-01','2021-07-31 09:58:27',3,1030.00,'','0'),
(1253,26,'2021-07-01','2021-07-31 09:58:34',3,580.00,'','0'),
(1254,26,'2021-07-01','2021-07-31 09:58:42',3,2500.00,'','0'),
(1255,26,'2021-07-01','2021-07-31 09:58:49',3,1200.00,'','0'),
(1256,26,'2021-07-01','2021-07-31 09:58:59',3,1891.00,'','0'),
(1257,26,'2021-07-01','2021-07-31 09:59:05',3,2146.00,'','0'),
(1258,26,'2021-07-01','2021-07-31 09:59:10',3,25.00,'','0'),
(1259,26,'2021-07-01','2021-07-31 10:00:43',24,282.00,'','0'),
(1260,26,'2021-07-01','2021-07-31 10:00:49',24,600.00,'','0'),
(1261,26,'2021-07-01','2021-07-31 10:00:55',24,20.00,'','0'),
(1262,26,'2021-07-01','2021-07-31 10:00:59',24,28.00,'','0'),
(1263,26,'2021-07-01','2021-07-31 10:01:05',24,2000.00,'','0'),
(1264,26,'2021-07-01','2021-07-31 10:01:10',24,1600.00,'','0'),
(1265,26,'2021-07-01','2021-07-31 10:01:20',24,56.00,'','0'),
(1266,26,'2021-07-01','2021-07-31 10:01:41',24,1500.00,'','0'),
(1267,26,'2021-07-01','2021-07-31 10:01:51',24,200.00,'','0'),
(1268,26,'2021-07-01','2021-07-31 10:02:00',24,391.00,'','0'),
(1269,26,'2021-07-01','2021-07-31 10:02:10',24,1030.00,'','0'),
(1270,26,'2021-07-01','2021-07-31 10:02:17',24,4000.00,'','0'),
(1271,26,'2021-07-01','2021-07-31 10:02:30',24,334.00,'','0'),
(1272,26,'2021-07-01','2021-07-31 10:02:39',24,1050.00,'','0'),
(1273,26,'2021-07-01','2021-07-31 10:02:48',24,709.00,'','0'),
(1274,26,'2021-07-01','2021-07-31 10:03:00',24,529.00,'','0'),
(1275,26,'2021-07-01','2021-07-31 10:03:22',7,525.00,'','0'),
(1276,26,'2021-07-01','2021-07-31 10:03:28',7,800.00,'','0'),
(1277,26,'2021-07-01','2021-07-31 10:03:32',7,225.00,'','0'),
(1278,26,'2021-07-01','2021-07-31 10:03:37',7,225.00,'','0'),
(1279,26,'2021-07-01','2021-07-31 10:03:45',7,225.00,'','0'),
(1280,26,'2021-07-01','2021-07-31 10:03:53',7,290.00,'','0'),
(1281,26,'2021-07-01','2021-07-31 10:03:59',7,200.00,'','0'),
(1282,26,'2021-07-01','2021-07-31 10:04:10',7,225.00,'','0'),
(1283,26,'2021-07-01','2021-07-31 10:04:16',7,225.00,'','0'),
(1284,26,'2021-07-01','2021-07-31 10:04:21',7,225.00,'','0'),
(1285,26,'2021-07-01','2021-07-31 10:04:29',7,1000.00,'','0'),
(1286,26,'2021-07-01','2021-07-31 10:04:36',7,115.00,'','0'),
(1287,26,'2021-07-01','2021-07-31 10:04:42',7,72.00,'','0'),
(1288,26,'2021-07-01','2021-07-31 10:08:46',17,800.00,'','0'),
(1289,26,'2021-07-01','2021-07-31 10:08:53',17,200.00,'','0'),
(1290,26,'2021-07-01','2021-07-31 10:09:01',17,200.00,'','0'),
(1291,26,'2021-07-01','2021-07-31 10:09:07',17,3000.00,'','0'),
(1292,26,'2021-07-01','2021-07-31 10:09:32',12,800.00,'','0'),
(1293,26,'2021-07-01','2021-07-31 10:09:37',12,200.00,'','0'),
(1294,26,'2021-07-01','2021-07-31 10:09:46',12,600.00,'','0'),
(1295,26,'2021-07-01','2021-07-31 10:10:38',21,800.00,'','0'),
(1296,26,'2021-07-01','2021-07-31 10:10:42',21,200.00,'','0'),
(1297,26,'2021-07-01','2021-07-31 10:10:46',21,1000.00,'','0'),
(1298,26,'2021-07-01','2021-07-31 10:10:54',21,1000.00,'','0'),
(1299,26,'2021-07-01','2021-07-31 10:11:13',18,70.00,'','0'),
(1300,26,'2021-07-01','2021-07-31 10:11:19',18,85.00,'','0'),
(1301,26,'2021-07-01','2021-07-31 10:11:25',18,800.00,'','0'),
(1302,26,'2021-07-01','2021-07-31 10:11:31',18,50.00,'','0'),
(1303,26,'2021-07-01','2021-07-31 10:11:37',18,79.00,'','0'),
(1304,26,'2021-07-01','2021-07-31 10:11:43',18,230.00,'','0'),
(1305,26,'2021-07-01','2021-07-31 10:11:53',18,200.00,'','0'),
(1306,26,'2021-07-01','2021-07-31 10:11:58',18,1100.00,'','0'),
(1307,26,'2021-07-01','2021-07-31 10:17:09',33,800.00,'','0'),
(1308,26,'2021-07-01','2021-07-31 10:17:16',33,200.00,'','0'),
(1309,26,'2021-07-01','2021-07-31 10:17:24',33,1500.00,'','0'),
(1310,26,'2021-07-01','2021-07-31 10:17:36',32,2000.00,'','0'),
(1311,26,'2021-07-01','2021-07-31 10:17:42',32,800.00,'','0'),
(1312,26,'2021-07-01','2021-07-31 10:17:49',32,200.00,'','0'),
(1313,26,'2021-07-01','2021-07-31 10:18:14',8,800.00,'','0'),
(1314,26,'2021-07-01','2021-07-31 10:19:07',8,500.00,'','0'),
(1315,26,'2021-07-01','2021-07-31 10:19:14',8,200.00,'','0'),
(1316,26,'2021-07-01','2021-07-31 10:19:21',8,1000.00,'','0'),
(1317,26,'2021-07-01','2021-07-31 10:19:37',11,800.00,'','0'),
(1318,26,'2021-07-01','2021-07-31 10:19:42',11,395.00,'','0'),
(1319,26,'2021-07-01','2021-07-31 10:19:48',11,200.00,'','0'),
(1320,26,'2021-07-01','2021-07-31 10:19:52',11,200.00,'','0'),
(1321,26,'2021-07-01','2021-07-31 10:20:03',11,3000.00,'','0'),
(1322,26,'2021-07-01','2021-07-31 10:20:33',20,800.00,'','0'),
(1323,26,'2021-07-01','2021-07-31 10:20:36',20,200.00,'','0'),
(1324,26,'2021-08-01','2021-08-31 11:40:12',33,200.00,'','0'),
(1325,26,'2021-08-01','2021-08-31 11:43:56',22,423.00,'','0'),
(1326,26,'2021-08-01','2021-08-31 11:44:01',22,200.00,'','0'),
(1327,26,'2021-08-01','2021-08-31 11:44:14',5,50.00,'','0'),
(1328,26,'2021-08-01','2021-08-31 11:44:21',5,640.00,'','0'),
(1329,26,'2021-08-01','2021-08-31 11:44:28',5,200.00,'','0'),
(1330,26,'2021-08-01','2021-08-31 11:44:39',6,1116.00,'','0'),
(1331,26,'2021-08-01','2021-08-31 11:44:46',6,200.00,'','0'),
(1332,26,'2021-08-01','2021-08-31 11:44:53',6,1000.00,'','0'),
(1333,26,'2021-08-01','2021-08-31 11:45:01',6,700.00,'','0'),
(1334,26,'2021-08-01','2021-08-31 11:45:08',6,200.00,'','0'),
(1335,26,'2021-08-01','2021-08-31 11:46:26',6,520.00,'','0'),
(1336,26,'2021-08-01','2021-08-31 11:51:02',26,200.00,'','0'),
(1337,26,'2021-08-01','2021-08-31 11:51:14',26,1000.00,'','0'),
(1338,26,'2021-08-01','2021-08-31 11:51:26',3,1000.00,'','0'),
(1339,26,'2021-08-01','2021-08-31 11:51:32',3,947.00,'','0'),
(1340,26,'2021-08-01','2021-08-31 11:51:43',3,1162.00,'','0'),
(1341,26,'2021-08-01','2021-08-31 11:51:50',3,1000.00,'','0'),
(1342,26,'2021-08-01','2021-08-31 11:51:55',3,87.00,'','0'),
(1343,26,'2021-08-01','2021-08-31 11:52:42',3,200.00,'','0'),
(1344,26,'2021-08-01','2021-08-31 11:52:47',3,100.00,'','0'),
(1345,26,'2021-08-01','2021-08-31 11:52:54',3,600.00,'','0'),
(1346,26,'2021-08-01','2021-08-31 11:53:03',3,977.00,'','0'),
(1347,26,'2021-08-01','2021-08-31 11:53:10',3,150.00,'','0'),
(1348,26,'2021-08-01','2021-08-31 11:53:19',3,5740.00,'','0'),
(1349,26,'2021-08-01','2021-08-31 11:53:32',3,1800.00,'','0'),
(1350,26,'2021-08-01','2021-08-31 11:53:39',3,2540.00,'','0'),
(1351,26,'2021-08-01','2021-08-31 11:54:01',3,1570.00,'','0'),
(1352,26,'2021-08-01','2021-08-31 11:55:01',3,1176.00,'','0'),
(1353,26,'2021-08-01','2021-08-31 11:55:09',3,3605.00,'','0'),
(1354,26,'2021-08-01','2021-08-31 11:55:16',3,846.00,'','0'),
(1355,26,'2021-08-01','2021-08-31 11:55:21',3,896.00,'','0'),
(1356,26,'2021-08-01','2021-08-31 11:55:29',3,293.00,'','0'),
(1357,26,'2021-08-01','2021-08-31 11:55:40',3,1744.00,'','0'),
(1358,26,'2021-08-01','2021-08-31 11:55:47',3,1000.00,'','0'),
(1359,26,'2021-08-01','2021-08-31 11:55:54',3,158.00,'','0'),
(1360,26,'2021-08-01','2021-08-31 11:56:04',3,532.00,'','0'),
(1361,26,'2021-08-01','2021-08-31 11:56:11',3,200.00,'','0'),
(1362,26,'2021-08-01','2021-08-31 11:56:17',3,1000.00,'','0'),
(1363,26,'2021-08-01','2021-08-31 11:56:25',3,4000.00,'','0'),
(1364,26,'2021-08-01','2021-08-31 11:56:32',3,3000.00,'','0'),
(1365,26,'2021-08-01','2021-08-31 11:56:39',3,120.00,'','0'),
(1366,26,'2021-08-01','2021-08-31 11:58:48',24,4740.00,'','0'),
(1367,26,'2021-08-01','2021-08-31 11:58:52',24,500.00,'','0'),
(1368,26,'2021-08-01','2021-08-31 11:59:02',24,9376.00,'','0'),
(1369,26,'2021-08-01','2021-08-31 11:59:09',24,1600.00,'','0'),
(1370,26,'2021-08-01','2021-08-31 11:59:16',24,134.00,'','0'),
(1371,26,'2021-08-01','2021-08-31 11:59:25',24,796.00,'','0'),
(1372,26,'2021-08-01','2021-08-31 11:59:32',24,28.00,'','0'),
(1373,26,'2021-08-01','2021-08-31 11:59:37',24,1000.00,'','0'),
(1374,26,'2021-08-01','2021-08-31 11:59:45',24,35.00,'','0'),
(1375,26,'2021-08-01','2021-08-31 11:59:51',24,640.00,'','0'),
(1376,26,'2021-08-01','2021-08-31 11:59:57',24,30.00,'','0'),
(1377,26,'2021-08-01','2021-08-31 12:00:02',24,1000.00,'','0'),
(1378,26,'2021-08-01','2021-08-31 12:03:17',24,157.00,'','0'),
(1379,26,'2021-08-01','2021-08-31 12:03:27',24,138.00,'','0'),
(1380,26,'2021-08-01','2021-08-31 12:03:35',24,200.00,'','0'),
(1381,26,'2021-08-01','2021-08-31 12:03:45',24,1000.00,'','0'),
(1382,26,'2021-08-01','2021-08-31 12:03:52',24,28.00,'','0'),
(1383,26,'2021-08-01','2021-08-31 12:33:06',7,295.00,'','0'),
(1384,26,'2021-08-01','2021-08-31 12:33:12',7,315.00,'','0'),
(1385,26,'2021-08-01','2021-08-31 12:33:18',7,280.00,'','0'),
(1386,26,'2021-08-01','2021-08-31 12:33:31',17,423.00,'','0'),
(1387,26,'2021-08-01','2021-08-31 12:33:36',17,2000.00,'','0'),
(1388,26,'2021-08-01','2021-08-31 12:33:41',17,200.00,'','0'),
(1389,26,'2021-08-01','2021-08-31 12:34:04',12,200.00,'','0'),
(1390,26,'2021-08-01','2021-08-31 12:34:20',21,3000.00,'','0'),
(1391,26,'2021-08-01','2021-08-31 12:34:26',21,2000.00,'','0'),
(1392,26,'2021-08-01','2021-08-31 12:34:30',21,200.00,'','0'),
(1393,26,'2021-08-01','2021-08-31 12:34:38',21,300.00,'','0'),
(1394,26,'2021-08-01','2021-08-31 12:34:52',18,423.00,'','0'),
(1395,26,'2021-08-01','2021-08-31 12:35:00',18,273.00,'','0'),
(1396,26,'2021-08-01','2021-08-31 12:35:06',18,75.00,'','0'),
(1397,26,'2021-08-01','2021-08-31 12:35:15',18,1360.00,'','0'),
(1398,26,'2021-08-01','2021-08-31 12:35:20',18,990.00,'','0'),
(1399,26,'2021-08-01','2021-08-31 12:35:27',18,220.00,'','0'),
(1400,26,'2021-08-01','2021-08-31 12:35:32',18,200.00,'','0'),
(1401,26,'2021-08-01','2021-08-31 12:35:37',18,1000.00,'','0'),
(1402,26,'2021-08-01','2021-08-31 12:35:43',18,200.00,'','0'),
(1403,26,'2021-08-01','2021-08-31 12:35:51',18,30.00,'','0'),
(1404,26,'2021-08-01','2021-08-31 12:35:56',18,1000.00,'','0'),
(1405,26,'2021-08-01','2021-08-31 12:36:18',8,500.00,'','0'),
(1406,26,'2021-08-01','2021-08-31 12:36:22',8,200.00,'','0'),
(1407,26,'2021-08-01','2021-08-31 12:36:27',8,500.00,'','0'),
(1408,26,'2021-08-01','2021-08-31 12:36:40',11,340.00,'','0'),
(1409,26,'2021-08-01','2021-08-31 12:36:47',11,423.00,'','0'),
(1410,26,'2021-08-01','2021-08-31 12:36:58',11,200.00,'','0'),
(1411,26,'2021-08-01','2021-08-31 14:14:38',3,987.00,'','0'),
(1412,26,'2021-08-01','2021-08-31 18:40:54',26,4700.00,'','0'),
(1413,26,'2021-09-01','2021-09-29 11:27:32',22,340.00,'','0'),
(1414,26,'2021-09-01','2021-09-29 11:27:38',22,315.00,'','0'),
(1415,26,'2021-09-01','2021-09-29 11:27:45',22,500.00,'','0'),
(1416,26,'2021-09-01','2021-09-29 11:27:51',22,153.00,'','0'),
(1417,26,'2021-09-01','2021-09-29 11:29:43',5,500.00,'','0'),
(1418,26,'2021-09-01','2021-09-29 11:29:50',5,620.00,'','0'),
(1419,26,'2021-09-01','2021-09-29 11:29:57',5,423.00,'','0'),
(1420,26,'2021-09-01','2021-09-29 11:30:04',5,137.00,'','0'),
(1421,26,'2021-09-01','2021-09-29 11:31:36',6,149.00,'','0'),
(1422,26,'2021-09-01','2021-09-29 11:31:45',6,1100.00,'','0'),
(1423,26,'2021-09-01','2021-09-29 11:31:54',6,400.00,'','0'),
(1424,26,'2021-09-01','2021-09-29 11:32:01',6,500.00,'','0'),
(1425,26,'2021-09-01','2021-09-29 11:32:07',6,1200.00,'','0'),
(1426,26,'2021-09-01','2021-09-29 11:32:14',6,520.00,'','0'),
(1427,26,'2021-09-01','2021-09-29 11:46:20',26,1600.00,'','0'),
(1428,26,'2021-09-01','2021-09-29 11:46:29',26,1000.00,'','0'),
(1429,26,'2021-09-01','2021-09-29 11:46:37',26,3000.00,'','0'),
(1430,26,'2021-09-01','2021-09-29 11:46:58',3,234.00,'','0'),
(1431,26,'2021-09-01','2021-09-29 11:47:06',3,1027.00,'','0'),
(1432,26,'2021-09-01','2021-09-29 11:47:14',3,2400.00,'','0'),
(1433,26,'2021-09-01','2021-09-29 11:47:20',3,630.00,'','0'),
(1434,26,'2021-09-01','2021-09-29 11:47:26',3,180.00,'','0'),
(1435,26,'2021-09-01','2021-09-29 11:47:32',3,4000.00,'','0'),
(1436,26,'2021-09-01','2021-09-29 11:48:41',3,503.00,'','0'),
(1437,26,'2021-09-01','2021-09-29 11:48:46',3,440.00,'','0'),
(1438,26,'2021-09-01','2021-09-29 11:48:53',3,140.00,'','0'),
(1439,26,'2021-09-01','2021-09-29 11:48:58',3,137.00,'','0'),
(1440,26,'2021-09-01','2021-09-29 11:49:05',3,350.00,'','0'),
(1441,26,'2021-09-01','2021-09-29 11:50:51',3,4000.00,'','0'),
(1442,26,'2021-09-01','2021-09-29 11:50:59',3,2540.00,'','0'),
(1443,26,'2021-09-01','2021-09-29 11:51:47',3,10000.00,'','0'),
(1444,26,'2021-09-01','2021-09-29 11:51:53',3,50.00,'','0'),
(1445,26,'2021-09-01','2021-09-29 11:51:59',3,1500.00,'','0'),
(1446,26,'2021-09-01','2021-09-29 11:52:05',3,274.00,'','0'),
(1447,26,'2021-09-01','2021-09-29 11:52:12',3,5400.00,'','0'),
(1448,26,'2021-09-01','2021-09-29 11:52:20',3,747.00,'','0'),
(1449,26,'2021-09-01','2021-09-29 11:53:03',24,81.00,'','0'),
(1450,26,'2021-09-01','2021-09-29 11:53:09',24,363.00,'','0'),
(1451,26,'2021-09-01','2021-09-29 11:53:14',24,184.00,'','0'),
(1452,26,'2021-09-01','2021-09-29 11:53:20',24,128.00,'','0'),
(1453,26,'2021-09-01','2021-09-29 11:53:27',24,1343.00,'','0'),
(1454,26,'2021-09-01','2021-09-29 11:53:33',24,500.00,'','0'),
(1455,26,'2021-09-01','2021-09-29 11:53:39',24,500.00,'','0'),
(1456,26,'2021-09-01','2021-09-29 11:53:46',24,500.00,'','0'),
(1457,26,'2021-09-01','2021-09-29 11:53:55',24,1600.00,'','0'),
(1458,26,'2021-09-01','2021-09-29 11:54:00',24,500.00,'','0'),
(1459,26,'2021-09-01','2021-09-29 11:54:06',24,339.00,'','0'),
(1460,26,'2021-09-01','2021-09-29 11:54:11',24,171.00,'','1'),
(1461,26,'2021-09-01','2021-09-29 11:54:30',24,220.00,'','0'),
(1462,26,'2021-09-01','2021-09-29 11:54:38',24,500.00,'','0'),
(1463,26,'2021-09-01','2021-09-29 12:00:19',24,8300.00,'','0'),
(1464,26,'2021-09-01','2021-09-29 12:00:27',24,28.00,'','0'),
(1465,26,'2021-09-01','2021-09-29 12:00:34',24,7000.00,'','0'),
(1466,26,'2021-09-01','2021-09-29 12:00:41',24,61.00,'','0'),
(1467,26,'2021-09-01','2021-09-29 12:00:55',24,363.00,'','0'),
(1468,26,'2021-09-01','2021-09-29 12:01:02',24,500.00,'','0'),
(1469,26,'2021-09-01','2021-09-29 12:01:08',24,2000.00,'','0'),
(1470,26,'2021-09-01','2021-09-29 12:01:14',24,8000.00,'','0'),
(1471,26,'2021-09-01','2021-09-29 12:01:21',24,100.00,'','0'),
(1472,26,'2021-09-01','2021-09-29 12:01:28',24,30.00,'','0'),
(1473,26,'2021-09-01','2021-09-29 12:01:34',24,660.00,'','0'),
(1474,26,'2021-09-01','2021-09-29 12:01:40',24,28.00,'','0'),
(1475,26,'2021-09-01','2021-09-29 12:02:20',7,571.00,'','0'),
(1476,26,'2021-09-01','2021-09-29 12:02:26',7,500.00,'','0'),
(1477,26,'2021-09-01','2021-09-29 12:02:32',7,500.00,'','0'),
(1478,26,'2021-09-01','2021-09-29 12:02:50',17,600.00,'','0'),
(1479,26,'2021-09-01','2021-09-29 12:02:56',17,50.00,'','0'),
(1480,26,'2021-09-01','2021-09-29 12:03:01',17,665.00,'','0'),
(1481,26,'2021-09-01','2021-09-29 12:03:08',17,500.00,'','0'),
(1482,26,'2021-09-01','2021-09-29 12:03:15',17,153.00,'','0'),
(1483,26,'2021-09-01','2021-09-29 12:03:31',12,50.00,'','0'),
(1484,26,'2021-09-01','2021-09-29 12:03:37',12,423.00,'','0'),
(1485,26,'2021-09-01','2021-09-29 12:03:44',12,495.00,'','0'),
(1486,26,'2021-09-01','2021-09-29 12:03:50',12,500.00,'','0'),
(1487,26,'2021-09-01','2021-09-29 12:03:59',12,92.00,'','0'),
(1488,26,'2021-09-01','2021-09-29 12:04:05',12,550.00,'','0'),
(1489,26,'2021-09-01','2021-09-29 12:04:12',12,81.00,'','0'),
(1490,26,'2021-09-01','2021-09-29 12:04:28',21,265.00,'','0'),
(1491,26,'2021-09-01','2021-09-29 12:04:34',21,216.00,'','0'),
(1492,26,'2021-09-01','2021-09-29 12:18:00',21,1000.00,'','0'),
(1493,26,'2021-09-01','2021-09-29 12:18:09',21,50.00,'','0'),
(1494,26,'2021-09-01','2021-09-29 12:18:17',21,495.00,'','0'),
(1495,26,'2021-09-01','2021-09-29 12:18:22',21,1500.00,'','0'),
(1496,26,'2021-09-01','2021-09-29 12:18:29',21,500.00,'','0'),
(1497,26,'2021-09-01','2021-09-29 12:18:35',21,153.00,'','0'),
(1498,26,'2021-09-01','2021-09-29 12:20:43',18,315.00,'','0'),
(1499,26,'2021-09-01','2021-09-29 12:20:49',18,500.00,'','0'),
(1500,26,'2021-09-01','2021-09-29 12:20:54',18,930.00,'','0');

INSERT INTO `issuance_wages` VALUES 
(1501,26,'2021-09-01','2021-09-29 12:20:59',18,165.00,'','0'),
(1502,26,'2021-09-01','2021-09-29 12:21:05',18,306.00,'','0'),
(1503,26,'2021-09-01','2021-09-29 12:21:24',33,500.00,'','0'),
(1504,26,'2021-09-01','2021-09-29 12:21:36',32,500.00,'','0'),
(1505,26,'2021-09-01','2021-09-29 12:21:40',32,100.00,'','0'),
(1506,26,'2021-09-01','2021-09-29 12:22:00',8,75.00,'','0'),
(1507,26,'2021-09-01','2021-09-29 12:22:06',8,500.00,'','0'),
(1508,26,'2021-09-01','2021-09-29 12:22:20',11,1000.00,'','0'),
(1509,26,'2021-09-01','2021-09-29 12:22:25',11,335.00,'','0'),
(1510,26,'2021-09-01','2021-09-29 12:22:32',11,423.00,'','0'),
(1511,26,'2021-09-01','2021-09-29 12:22:37',11,665.00,'','0'),
(1512,26,'2021-09-01','2021-09-29 12:22:43',11,500.00,'','0'),
(1513,26,'2021-09-01','2021-09-29 12:22:49',11,1000.00,'','0'),
(1514,26,'2021-09-01','2021-09-29 12:22:56',11,306.00,'','0'),
(1515,26,'2021-09-01','2021-09-29 12:23:12',11,2000.00,'','0'),
(1516,26,'2021-09-01','2021-09-29 16:59:07',24,30.00,'','0'),
(1517,26,'2021-09-01','2021-09-30 14:06:07',3,1700.00,'','0'),
(1518,26,'2021-09-01','2021-09-30 14:06:43',3,171.00,'','0'),
(1519,26,'2021-09-01','2021-09-30 15:35:24',6,32.00,'','0'),
(1520,26,'2021-10-01','2021-10-29 16:58:49',22,175.00,'','0'),
(1521,26,'2021-10-01','2021-10-29 16:58:58',22,180.00,'','0'),
(1522,26,'2021-10-01','2021-10-29 16:59:12',22,200.00,'','0'),
(1523,26,'2021-10-01','2021-10-29 16:59:20',22,200.00,'','0'),
(1524,26,'2021-10-01','2021-10-29 16:59:29',22,50.00,'','0'),
(1525,26,'2021-10-01','2021-10-29 17:15:39',5,175.00,'','0'),
(1526,26,'2021-10-01','2021-10-29 17:15:53',5,180.00,'','0'),
(1527,26,'2021-10-01','2021-10-29 17:15:59',5,200.00,'','0'),
(1528,26,'2021-10-01','2021-10-29 17:16:07',5,640.00,'','0'),
(1529,26,'2021-10-01','2021-10-29 17:16:12',5,200.00,'','0'),
(1530,26,'2021-10-01','2021-10-29 17:16:35',6,175.00,'','0'),
(1531,26,'2021-10-01','2021-10-29 17:16:43',6,180.00,'','0'),
(1532,26,'2021-10-01','2021-10-29 17:17:37',6,81.00,'','0'),
(1533,26,'2021-10-01','2021-10-29 17:17:44',6,100.00,'','0'),
(1534,26,'2021-10-01','2021-10-29 17:17:59',6,1000.00,'','0'),
(1535,26,'2021-10-01','2021-10-29 17:18:06',6,3500.00,'','0'),
(1536,26,'2021-10-01','2021-10-29 17:18:11',6,200.00,'','0'),
(1537,26,'2021-10-01','2021-10-29 17:19:02',26,175.00,'','0'),
(1538,26,'2021-10-01','2021-10-29 17:19:09',26,180.00,'','0'),
(1539,26,'2021-10-01','2021-10-29 17:19:16',26,200.00,'','0'),
(1540,26,'2021-10-01','2021-10-29 17:19:22',26,3000.00,'','0'),
(1541,26,'2021-10-01','2021-10-29 17:19:29',26,3000.00,'','0'),
(1542,26,'2021-10-01','2021-10-29 17:19:41',26,1500.00,'','0'),
(1543,26,'2021-10-01','2021-10-29 17:19:47',26,200.00,'','0'),
(1544,26,'2021-10-01','2021-10-29 17:38:27',3,175.00,'','0'),
(1545,26,'2021-10-01','2021-10-29 17:38:46',3,180.00,'','0'),
(1546,26,'2021-10-01','2021-10-29 17:42:50',3,160.00,'','0'),
(1547,26,'2021-10-01','2021-10-29 17:43:01',3,2285.00,'','0'),
(1548,26,'2021-10-01','2021-10-29 17:43:10',3,108.00,'','0'),
(1549,26,'2021-10-01','2021-10-29 17:43:17',3,510.00,'','0'),
(1550,26,'2021-10-01','2021-10-29 17:43:25',3,200.00,'','0'),
(1551,26,'2021-10-01','2021-10-29 17:47:57',3,55.00,'','0'),
(1552,26,'2021-10-01','2021-10-29 17:48:07',3,71.00,'','0'),
(1553,26,'2021-10-01','2021-10-29 17:48:31',3,2650.00,'','0'),
(1554,26,'2021-10-01','2021-10-29 17:48:37',3,640.00,'','0'),
(1555,26,'2021-10-01','2021-10-29 17:48:44',3,39.00,'','0'),
(1556,26,'2021-10-01','2021-10-29 17:50:15',3,150.00,'','0'),
(1557,26,'2021-10-01','2021-10-29 17:50:21',3,458.00,'','0'),
(1558,26,'2021-10-01','2021-10-29 17:50:28',3,1510.00,'','0'),
(1559,26,'2021-10-01','2021-10-29 17:50:36',3,4250.00,'','0'),
(1560,26,'2021-10-01','2021-10-29 17:50:44',3,1270.00,'','0'),
(1561,26,'2021-10-01','2021-10-29 17:50:54',3,499.00,'','0'),
(1562,26,'2021-10-01','2021-10-29 17:52:26',3,1710.00,'','0'),
(1563,26,'2021-10-01','2021-10-29 17:52:33',3,3400.00,'','0'),
(1564,26,'2021-10-01','2021-10-29 17:52:40',3,3500.00,'','0'),
(1565,26,'2021-10-01','2021-10-29 17:52:46',3,42.00,'','0'),
(1566,26,'2021-10-01','2021-10-29 17:52:53',3,250.00,'','0'),
(1567,26,'2021-10-01','2021-10-29 17:52:59',3,7000.00,'','0'),
(1568,26,'2021-10-01','2021-10-29 17:53:06',3,500.00,'','0'),
(1569,26,'2021-10-01','2021-10-29 17:53:12',3,680.00,'','0'),
(1570,26,'2021-10-01','2021-10-29 17:53:19',3,2540.00,'','0'),
(1571,26,'2021-10-01','2021-10-29 17:53:28',3,750.00,'','0'),
(1572,26,'2021-11-01','2021-11-22 14:16:29',18,600.00,'аванс','0'),
(1573,26,'2021-11-01','2021-11-22 14:16:54',3,250.00,'масаж','0'),
(1574,26,'2021-11-01','2021-11-22 14:17:18',3,132.00,'фейсбук','0'),
(1575,26,'2021-11-01','2021-11-22 14:17:41',3,150.00,'масаж','0'),
(1576,26,'2021-11-01','2021-11-22 14:18:09',12,130.00,'на весілля макіяж 100 і резинка 30','0'),
(1577,26,'2021-11-01','2021-11-22 14:18:33',11,345.00,'олійка','0'),
(1578,26,'2021-11-01','2021-11-22 14:18:52',7,342.00,'фарба і маска','0'),
(1579,26,'2021-11-01','2021-11-22 14:19:08',3,150.00,'масаж','0'),
(1580,26,'2021-11-01','2021-11-22 14:19:32',6,400.00,'аванс','0'),
(1581,26,'2021-11-01','2021-11-22 14:38:03',32,1880.00,'за фарбування мами','0'),
(1582,26,'2021-11-01','2021-11-22 14:39:19',3,200.00,'масаж','0'),
(1583,26,'2021-11-01','2021-11-22 14:39:52',8,382.00,'шампунь','0'),
(1584,26,'2021-11-01','2021-11-22 14:40:25',6,379.00,'шампунь маска','0'),
(1585,26,'2021-11-01','2021-11-22 14:40:40',6,240.00,'тоналка','0'),
(1586,26,'2021-11-01','2021-11-22 14:40:55',3,863.00,'воскоплав','0'),
(1587,26,'2021-11-01','2021-11-22 14:41:12',11,55.00,'бокс насті','0'),
(1588,26,'2021-11-01','2021-11-22 14:41:24',8,55.00,'бокс насті','0'),
(1589,26,'2021-11-01','2021-11-22 14:41:36',32,55.00,'бокс насті','0'),
(1590,26,'2021-11-01','2021-11-22 14:41:48',33,55.00,'бокс насті','0'),
(1591,26,'2021-11-01','2021-11-22 14:42:00',18,55.00,'бокс насті','0'),
(1592,26,'2021-11-01','2021-11-22 14:42:20',12,55.00,'бокс насті','0'),
(1593,26,'2021-11-01','2021-11-22 14:42:32',17,55.00,'бокс насті','0'),
(1594,26,'2021-11-01','2021-11-22 14:42:49',7,55.00,'бокс насті','0'),
(1595,26,'2021-11-01','2021-11-22 14:43:03',26,55.00,'бокс насті','0'),
(1596,26,'2021-11-01','2021-11-22 14:43:13',6,55.00,'бокс насті','0'),
(1597,26,'2021-11-01','2021-11-22 14:43:21',5,55.00,'бокс насті','0'),
(1598,26,'2021-11-01','2021-11-22 14:43:38',22,55.00,'бокс насті','0'),
(1599,26,'2021-11-01','2021-11-22 14:44:01',21,4647.00,'зп','0'),
(1600,26,'2021-11-01','2021-11-22 14:44:22',5,60.00,'кісточка','0'),
(1601,26,'2021-11-01','2021-11-22 14:44:39',3,207.00,'кісточки','0'),
(1602,26,'2021-11-01','2021-11-22 14:44:54',11,122.00,'кісточки','0'),
(1603,26,'2021-11-01','2021-11-22 14:45:03',18,122.00,'','1'),
(1604,26,'2021-11-01','2021-11-22 14:45:22',18,122.00,'кісточки','0'),
(1605,26,'2021-11-01','2021-11-22 14:45:38',17,1000.00,'аванс','0'),
(1606,26,'2021-11-01','2021-11-22 14:46:30',6,80.00,'ампула','0'),
(1607,26,'2021-11-01','2021-11-22 14:46:44',18,1000.00,'аванс','0'),
(1608,26,'2021-11-01','2021-11-22 14:49:50',11,1800.00,'аванс','0'),
(1609,26,'2021-11-01','2021-11-22 14:50:10',6,800.00,'аванс','0'),
(1610,26,'2021-11-01','2021-11-22 14:50:36',3,200.00,'даня масаж','0'),
(1611,26,'2021-11-01','2021-11-22 14:50:57',3,100.00,'електрик свайп','0'),
(1612,26,'2021-11-01','2021-11-22 14:51:35',3,420.00,'лінза марусі моно оплата ','0'),
(1613,26,'2021-11-01','2021-11-22 14:51:52',3,200.00,'даня масаж','0'),
(1614,26,'2021-11-01','2021-11-22 14:56:44',18,960.00,'податок','0'),
(1615,26,'2021-11-01','2021-11-22 14:57:07',5,640.00,'податок','0'),
(1616,26,'2021-11-01','2021-11-22 14:57:41',3,1600.00,'адмін подат','0'),
(1617,26,'2021-11-01','2021-11-22 14:57:55',3,2540.00,'податок','0'),
(1618,26,'2021-11-01','2021-11-22 14:58:17',12,280.00,'фарбування','0'),
(1619,26,'2021-11-01','2021-11-22 14:58:36',3,200.00,'даня масаж','0'),
(1620,26,'2021-11-01','2021-11-22 14:58:58',3,3000.00,'памятник оплата з монобанк','0'),
(1621,26,'2021-11-01','2021-11-22 14:59:21',3,913.00,'комбінезон','0'),
(1622,26,'2021-11-01','2021-11-22 14:59:57',3,100.00,'мойка артьом мив машину','0'),
(1623,26,'2021-11-01','2021-11-22 15:00:53',3,142.00,'сухий шампунь батіст','0'),
(1624,26,'2021-11-01','2021-11-22 15:01:09',26,2000.00,'аванс','0'),
(1625,26,'2021-11-01','2021-11-22 15:01:28',18,84.00,'пательня з сови','0'),
(1626,26,'2021-11-01','2021-11-22 15:01:43',21,45.00,'борщ','0'),
(1627,26,'2021-11-01','2021-11-22 15:03:33',3,7850.00,'телевізор','0'),
(1628,26,'2021-11-01','2021-11-22 15:04:18',6,95.00,'кармекс','0'),
(1629,26,'2021-11-01','2021-11-22 15:15:56',6,65.00,'фарбування','0'),
(1630,26,'2021-11-01','2021-11-22 15:15:58',6,65.00,'фарбування','1'),
(1631,26,'2021-11-01','2021-11-22 15:16:22',6,90.00,'олівчик для губ','0'),
(1632,26,'2021-11-01','2021-11-23 13:36:32',26,77.00,'іда','0'),
(1633,26,'2021-11-01','2021-11-23 15:24:15',3,2250.00,'реклама шликова','0'),
(1634,26,'2021-11-01','2021-11-23 15:25:20',3,310.00,'андрій фабування стіни в коридорі замість стрілок','0'),
(1635,26,'2021-11-01','2021-11-25 08:49:35',3,470.00,'андрый робота','0'),
(1636,26,'2021-11-01','2021-11-25 08:51:52',11,2000.00,'аванс','0'),
(1637,26,'2021-11-01','2021-11-25 09:13:32',3,3579.00,'накладні свайп шварскоф','0'),
(1638,26,'2021-11-01','2021-11-25 09:13:51',3,289.00,'крем шварскоф','0'),
(1639,26,'2021-11-01','2021-11-26 11:02:54',7,365.00,'фарбування','0'),
(1640,26,'2021-11-01','2021-11-26 17:42:02',6,1600.00,'аванс','0'),
(1641,26,'2021-11-01','2021-11-26 18:24:46',7,5000.00,'аванс','0'),
(1642,26,'2021-11-01','2021-11-27 09:05:10',20,1000.00,'аванс','0'),
(1643,26,'2021-11-01','2021-11-27 09:05:53',24,477.00,'','0'),
(1644,26,'2021-11-01','2021-11-27 09:06:05',24,1116.00,'','0'),
(1645,26,'2021-11-01','2021-11-27 09:06:11',24,378.00,'','0'),
(1646,26,'2021-11-01','2021-11-27 09:06:18',24,1849.00,'','0'),
(1647,26,'2021-11-01','2021-11-27 09:06:25',24,684.00,'','0'),
(1648,26,'2021-11-01','2021-11-27 09:06:32',24,792.00,'','0'),
(1649,26,'2021-11-01','2021-11-27 09:06:39',24,2160.00,'','0'),
(1650,26,'2021-11-01','2021-11-27 09:06:50',24,1773.00,'','0'),
(1651,26,'2021-11-01','2021-11-27 09:06:56',24,666.00,'','0'),
(1652,26,'2021-11-01','2021-11-27 09:07:03',24,1332.00,'','0'),
(1653,26,'2021-11-01','2021-11-27 09:07:12',24,369.00,'','0'),
(1654,26,'2021-11-01','2021-11-27 09:07:24',24,288.00,'','0'),
(1655,26,'2021-11-01','2021-11-27 09:07:34',24,1460.00,'','0'),
(1656,26,'2021-11-01','2021-11-27 09:07:46',24,513.00,'','0'),
(1657,26,'2021-11-01','2021-11-27 09:07:55',24,792.00,'','0'),
(1658,26,'2021-11-01','2021-11-27 09:08:05',24,639.00,'','0'),
(1659,26,'2021-11-01','2021-11-27 09:08:13',24,1116.00,'','0'),
(1660,26,'2021-11-01','2021-11-27 09:08:20',24,2707.00,'','0'),
(1661,26,'2021-11-01','2021-11-27 09:08:31',24,558.00,'','0'),
(1662,26,'2021-11-01','2021-11-27 09:08:38',24,1611.00,'','0'),
(1663,26,'2021-11-01','2021-11-27 09:08:44',24,810.00,'','0'),
(1664,26,'2021-11-01','2021-11-27 09:08:50',24,936.00,'','0'),
(1665,26,'2021-11-01','2021-11-27 16:19:37',24,1044.00,'аванс','0'),
(1666,26,'2021-11-01','2021-11-27 17:19:46',18,41.00,'їда','0'),
(1667,26,'2021-11-01','2021-11-27 18:05:09',12,2000.00,'аванс','0'),
(1668,26,'2021-11-01','2021-11-29 12:05:09',8,2000.00,'брала на телефон','0'),
(1669,26,'2021-11-01','2021-11-29 12:54:04',18,1400.00,'до завтра','0'),
(1670,26,'2021-11-01','2021-11-29 13:57:14',3,600.00,'реклама шликова друге вікно','0'),
(1671,26,'2021-11-01','2021-11-29 17:11:29',24,1125.00,'аванс','0'),
(1672,26,'2021-11-01','2021-11-30 15:38:19',3,151.00,'фарбування ','0'),
(1673,26,'2021-11-01','2021-11-30 15:45:56',21,2210.00,'','0'),
(1674,26,'2021-11-01','2021-11-30 17:32:50',3,810.00,'менюхолдери','1'),
(1675,26,'2021-12-01','2021-12-03 09:32:14',24,981.00,'(02.12)','0'),
(1676,26,'2021-12-01','2021-12-03 10:26:58',3,481.00,'набір шварскоф ','0'),
(1677,26,'2021-12-01','2021-12-03 15:20:28',3,4000.00,'скидала на приват особисту','0'),
(1678,26,'2021-12-01','2021-12-03 15:51:45',18,360.00,'фарбування','0'),
(1679,26,'2021-12-01','2021-12-04 09:15:08',3,573.00,'пыдставка для прайсу свайп','0'),
(1680,26,'2021-12-01','2021-12-04 09:17:19',3,3000.00,'курси оплата ','0'),
(1681,26,'2021-12-01','2021-12-04 12:43:35',24,1251.00,'03.12','0'),
(1682,26,'2021-12-01','2021-12-04 13:35:05',18,500.00,'аванс','0'),
(1683,26,'2021-12-01','2021-12-04 15:44:41',3,4000.00,'полка на продажі','0'),
(1684,26,'2021-12-01','2021-12-04 16:36:08',24,2088.00,'04.12','0'),
(1685,26,'2021-12-01','2021-12-06 14:43:02',21,1146.00,'зп','0'),
(1686,26,'2021-12-01','2021-12-06 17:08:18',24,423.00,'06.12','0'),
(1687,26,'2021-12-01','2021-12-06 18:47:31',11,1278.00,'лазерна епіляція','0'),
(1688,26,'2021-12-01','2021-12-07 09:09:27',18,233.00,'пушер','0'),
(1689,26,'2021-12-01','2021-12-07 09:09:45',22,233.00,'пушер','0'),
(1690,26,'2021-12-01','2021-12-07 18:36:07',3,4000.00,'Скинула Віті Іванову з монобанку','0'),
(1691,26,'2021-12-01','2021-12-08 16:56:54',24,648.00,'08.12','0'),
(1692,26,'2021-12-01','2021-12-10 09:00:56',18,116.00,'їда','0'),
(1693,26,'2021-12-01','2021-12-10 09:33:46',3,190.00,'спонжик','0'),
(1694,26,'2021-12-01','2021-12-10 09:34:01',3,10.00,'прайс на свайп 1 шт ','0'),
(1695,26,'2021-12-01','2021-12-10 11:50:48',6,335.00,'','1'),
(1696,26,'2021-12-01','2021-12-10 11:51:06',6,335.00,'кондиціонер','0'),
(1697,26,'2021-12-01','2021-12-10 11:51:28',26,1000.00,'аванс','0'),
(1698,26,'2021-12-01','2021-12-10 11:51:38',26,3100.00,'аванс','0'),
(1699,26,'2021-12-01','2021-12-10 11:53:06',8,315.00,'спрей','0'),
(1700,26,'2021-12-01','2021-12-10 11:53:27',12,315.00,'спрей','0'),
(1701,26,'2021-12-01','2021-12-10 12:43:57',22,245.00,'олійка','0'),
(1702,26,'2021-12-01','2021-12-10 17:24:19',24,1332.00,'аванс','0'),
(1703,26,'2021-12-01','2021-12-11 15:49:50',24,1917.00,'аванс','0'),
(1704,26,'2021-12-01','2021-12-13 13:16:29',7,160.00,'крем кондиціонер','0'),
(1705,26,'2021-12-01','2021-12-13 13:16:53',6,160.00,'крем кондиціонер','0'),
(1706,26,'2021-12-01','2021-12-13 15:46:07',24,783.00,'13.12','0'),
(1707,26,'2021-12-01','2021-12-13 16:09:28',7,1160.00,'аванс','0'),
(1708,26,'2021-12-01','2021-12-13 16:10:40',8,160.00,'бальзам','0'),
(1709,26,'2021-12-01','2021-12-14 11:36:06',12,100.00,'мейк','0'),
(1710,26,'2021-12-01','2021-12-14 11:53:28',22,45.00,'борщ','0'),
(1711,26,'2021-12-01','2021-12-14 11:53:52',18,35.00,'їда','0'),
(1712,26,'2021-12-01','2021-12-14 12:38:18',24,279.00,'','0'),
(1713,26,'2021-12-01','2021-12-15 09:36:45',3,1799.00,'лампа свайп','0'),
(1714,26,'2021-12-01','2021-12-15 09:37:21',3,110.00,'нова пошта','1'),
(1715,26,'2021-12-01','2021-12-15 09:39:30',3,110.00,'нова пошта свайп','0'),
(1716,26,'2021-12-01','2021-12-15 09:41:23',3,3373.00,'туфлі і піжама','0'),
(1717,26,'2021-12-01','2021-12-15 10:00:14',3,1524.00,'накладна свайп вітя львів','0'),
(1718,26,'2021-12-01','2021-12-15 11:39:22',3,300.00,'свайп макет борда і сітілайт','0'),
(1719,26,'2021-12-01','2021-12-15 11:40:44',3,2180.00,' лайк пластики друк поклейка  ','0'),
(1720,26,'2021-12-01','2021-12-15 11:42:57',3,2050.00,'сітіборд свайп','0'),
(1721,26,'2021-12-01','2021-12-15 17:15:16',11,3000.00,'','0'),
(1722,26,'2021-12-01','2021-12-16 08:52:19',24,1323.00,'15я12','0'),
(1723,26,'2021-12-01','2021-12-16 12:27:11',12,700.00,'аванс','0'),
(1724,26,'2021-12-01','2021-12-16 12:36:46',3,2670.00,'податок','0'),
(1725,26,'2021-12-01','2021-12-16 12:36:58',3,1680.00,'податок','0'),
(1726,26,'2021-12-01','2021-12-16 12:42:21',3,200.00,'завдаток за платя інстаграм','0'),
(1727,26,'2021-12-01','2021-12-16 16:43:29',32,270.00,'вії','0'),
(1728,26,'2021-12-01','2021-12-16 18:08:43',24,1512.00,'16.12','0'),
(1729,26,'2021-12-01','2021-12-17 16:55:46',24,1134.00,'17.12','0'),
(1730,26,'2021-12-01','2021-12-18 08:58:11',18,1008.00,'податок','0'),
(1731,26,'2021-12-01','2021-12-18 08:58:44',5,672.00,'податок','0'),
(1732,26,'2021-12-01','2021-12-18 14:52:49',17,1000.00,'аванс','0'),
(1733,26,'2021-12-01','2021-12-18 14:53:00',3,250.00,'масаж','0'),
(1734,26,'2021-12-01','2021-12-18 15:46:36',24,1485.00,'18.12','0'),
(1735,26,'2021-12-01','2021-12-18 16:30:01',6,3500.00,'аванс','0'),
(1736,26,'2021-12-01','2021-12-20 09:54:33',3,700.00,'юля гура  бальзам','0'),
(1737,26,'2021-12-01','2021-12-20 11:19:07',11,60.00,'миколая','0'),
(1738,26,'2021-12-01','2021-12-20 11:20:02',8,60.00,'миколая','0'),
(1739,26,'2021-12-01','2021-12-20 11:20:13',32,60.00,'миколая','0'),
(1740,26,'2021-12-01','2021-12-20 11:20:23',33,60.00,'миколая','0'),
(1741,26,'2021-12-01','2021-12-20 11:22:11',18,60.00,'миколая','0'),
(1742,26,'2021-12-01','2021-12-20 11:22:24',12,60.00,'миколая','0'),
(1743,26,'2021-12-01','2021-12-20 11:22:41',17,60.00,'миколая','0'),
(1744,26,'2021-12-01','2021-12-20 11:22:55',7,60.00,'миколая','0'),
(1745,26,'2021-12-01','2021-12-20 11:23:18',26,60.00,'миколая','0'),
(1746,26,'2021-12-01','2021-12-20 11:23:29',26,500.00,'аванс','0'),
(1747,26,'2021-12-01','2021-12-20 11:23:39',6,60.00,'миколая','0'),
(1748,26,'2021-12-01','2021-12-20 11:23:47',5,60.00,'','1'),
(1749,26,'2021-12-01','2021-12-20 11:24:09',5,60.00,'миколая','0'),
(1750,26,'2021-12-01','2021-12-20 11:24:35',22,60.00,'миколая','0'),
(1751,26,'2021-12-01','2021-12-20 13:03:48',8,1000.00,'аванс','0'),
(1752,26,'2021-12-01','2021-12-20 13:34:31',3,78.00,'доставка нова пошта юлі','0'),
(1753,26,'2021-12-01','2021-12-20 13:34:46',3,873.00,'одяг платя ','0'),
(1754,26,'2021-12-01','2021-12-20 13:34:59',3,700.00,'одяг платя друге','0'),
(1755,26,'2021-12-01','2021-12-20 13:48:13',3,1680.00,'настя ірі миколая ','0'),
(1756,26,'2021-12-01','2021-12-20 17:40:16',3,1125.00,'Атб','0'),
(1757,26,'2021-12-01','2021-12-20 17:41:09',3,1840.00,'Комбінезони стожук','0'),
(1758,26,'2021-12-01','2021-12-20 18:23:19',24,2034.00,'20.12','0'),
(1759,26,'2021-12-01','2021-12-21 12:17:06',3,435.00,'крем шварскоф','0'),
(1760,26,'2021-12-01','2021-12-21 12:22:59',18,100.00,'попоаненя мобільного','1'),
(1761,26,'2021-12-01','2021-12-21 18:19:12',24,468.00,'21.12','0'),
(1762,26,'2021-12-01','2021-12-22 10:20:13',3,250.00,'масаж 21.12','0'),
(1763,26,'2021-12-01','2021-12-22 10:20:25',3,250.00,'масаж 22.12','0'),
(1764,26,'2021-12-01','2021-12-22 10:35:29',3,1000.00,'заправлялась з монобанкуу','0'),
(1765,26,'2021-12-01','2021-12-22 17:59:32',24,2142.00,'22.12','0'),
(1766,26,'2021-12-01','2021-12-22 17:59:57',26,1000.00,'аванс','0'),
(1767,26,'2021-12-01','2021-12-22 18:06:22',6,1200.00,'аванс','0'),
(1768,26,'2021-12-01','2021-12-23 09:18:39',17,145.00,'аванс','0'),
(1769,26,'2021-12-01','2021-12-23 09:19:16',7,230.00,'фарбування','0'),
(1770,26,'2021-12-01','2021-12-23 09:19:40',3,10000.00,'аванс','0'),
(1771,26,'2021-12-01','2021-12-23 09:20:12',3,15000.00,'світло аванс рес','0'),
(1772,26,'2021-12-01','2021-12-23 09:21:42',3,299.00,'книжка методичка ногті','0'),
(1773,26,'2021-12-01','2021-12-23 09:22:28',3,3862.00,'комбінезони покаліцина','0'),
(1774,26,'2021-12-01','2021-12-23 09:22:55',3,1933.00,'іграшки дані','0'),
(1775,26,'2021-12-01','2021-12-23 09:47:47',18,865.00,'фрези','0'),
(1776,26,'2021-12-01','2021-12-23 09:48:23',11,215.00,'фрези','0'),
(1777,26,'2021-12-01','2021-12-23 09:50:04',17,305.00,'фрези','0'),
(1778,26,'2021-12-01','2021-12-23 09:51:49',3,515.00,'настя фрези ','0'),
(1779,26,'2021-12-01','2021-12-23 09:52:37',5,95.00,'фрези ','0'),
(1780,26,'2021-12-01','2021-12-23 12:54:30',7,5000.00,'аванс','0'),
(1781,26,'2021-12-01','2021-12-23 15:52:20',11,1500.00,'аванс','0'),
(1782,26,'2021-12-01','2021-12-23 18:53:04',24,288.00,'23.12','0'),
(1783,26,'2021-12-01','2021-12-24 09:20:21',3,795.00,'інтернет свайп','0'),
(1784,26,'2021-12-01','2021-12-24 09:20:44',3,438.00,'смаколик','0'),
(1785,26,'2021-12-01','2021-12-24 12:06:49',3,105.00,'нова пошта за іграшки дані','0'),
(1786,26,'2021-12-01','2021-12-24 12:50:16',24,250.00,'масаж','1'),
(1787,26,'2021-12-01','2021-12-24 12:50:36',3,250.00,'масаж','0'),
(1788,26,'2021-12-01','2021-12-24 13:00:21',3,1000.00,'квіти ілоні','0'),
(1789,26,'2021-12-01','2021-12-24 13:00:48',18,500.00,'аванс','0'),
(1790,26,'2021-12-01','2021-12-25 08:33:14',24,1269.00,'25.12','0'),
(1791,26,'2021-12-01','2021-12-25 08:33:43',11,200.00,'дн ілона','0'),
(1792,26,'2021-12-01','2021-12-25 08:34:01',8,200.00,'дн ілона','0'),
(1793,26,'2021-12-01','2021-12-25 08:34:15',32,200.00,'дн ілона','0'),
(1794,26,'2021-12-01','2021-12-25 08:34:24',33,200.00,'дн ілона','1'),
(1795,26,'2021-12-01','2021-12-25 08:34:39',18,200.00,'дн ілона','0'),
(1796,26,'2021-12-01','2021-12-25 08:34:49',12,200.00,'дн ілона','0'),
(1797,26,'2021-12-01','2021-12-25 08:34:57',17,200.00,'дн ілона','0'),
(1798,26,'2021-12-01','2021-12-25 08:35:08',7,200.00,'дн ілона','0'),
(1799,26,'2021-12-01','2021-12-25 08:35:22',3,200.00,'дн ілона','0'),
(1800,26,'2021-12-01','2021-12-25 08:35:32',26,200.00,'дн ілона','0'),
(1801,26,'2021-12-01','2021-12-25 08:35:40',6,200.00,'дн ілона','0'),
(1802,26,'2021-12-01','2021-12-25 08:35:50',5,200.00,'дн ілона','0'),
(1803,26,'2021-12-01','2021-12-25 08:36:01',22,200.00,'дн ілона','0'),
(1804,26,'2021-12-01','2021-12-25 08:38:02',12,1500.00,'аванс','0'),
(1805,26,'2021-12-01','2021-12-25 12:21:29',18,200.00,'','0'),
(1806,26,'2021-12-01','2021-12-26 13:12:29',6,400.00,'аванс','0'),
(1807,26,'2021-12-01','2021-12-26 13:12:48',8,1000.00,'аванс','0'),
(1808,26,'2021-12-01','2021-12-26 13:13:05',11,600.00,'КОРПОРАТИВ','0'),
(1809,26,'2021-12-01','2021-12-26 13:13:17',8,600.00,'КОРПОРАТИВ','0'),
(1810,26,'2021-12-01','2021-12-26 13:13:29',33,600.00,'КОРПОРАТИВ','0'),
(1811,26,'2021-12-01','2021-12-26 13:13:39',18,600.00,'КОРПОРАТИВ','0'),
(1812,26,'2021-12-01','2021-12-26 13:13:49',12,600.00,'КОРПОРАТИВ','0'),
(1813,26,'2021-12-01','2021-12-26 13:14:01',17,600.00,'КОРПОРАТИВ','0'),
(1814,26,'2021-12-01','2021-12-26 13:14:13',7,600.00,'КОРПОРАТИВ','0'),
(1815,26,'2021-12-01','2021-12-26 15:01:42',3,600.00,'КОРПОРАТИВ','0'),
(1816,26,'2021-12-01','2021-12-26 15:01:56',26,600.00,'КОРПОРАТИВ','0'),
(1817,26,'2021-12-01','2021-12-26 15:02:06',6,600.00,'КОРПОРАТИВ','0'),
(1818,26,'2021-12-01','2021-12-26 15:02:17',22,600.00,'КОРПОРАТИВ','0'),
(1819,26,'2021-12-01','2021-12-26 15:27:30',3,2000.00,'сертифікат огороднічці','0'),
(1820,26,'2021-12-01','2021-12-26 15:30:19',3,1140.00,'огороднічці марі фреш сировотка тонік і пінка ','0'),
(1821,26,'2021-12-01','2021-12-27 09:00:30',3,2800.00,'іхерб','0'),
(1822,26,'2021-12-01','2021-12-27 10:00:06',3,250.00,'масаж','0'),
(1823,26,'2021-12-01','2021-12-28 08:51:38',24,3420.00,'аванс','0'),
(1824,26,'2021-12-01','2021-12-28 11:40:45',3,483.00,'свайп кава','0'),
(1825,26,'2021-12-01','2021-12-28 16:00:55',3,550.00,'сертифікат свайп софія','0'),
(1826,26,'2021-12-01','2021-12-28 16:01:12',3,1060.00,'аванс ярік на карту','0'),
(1827,26,'2021-12-01','2021-12-28 18:38:40',24,1737.00,'аванс','0'),
(1828,26,'2021-12-01','2021-12-28 18:43:30',24,144.00,'аванс','0'),
(1829,26,'2021-12-01','2021-12-29 11:05:44',8,100.00,'мейк','0'),
(1830,26,'2021-12-01','2021-12-30 15:28:03',3,5000.00,'на карточку вітя іванов ','0'),
(1831,26,'2021-12-01','2021-12-30 15:28:32',3,590.00,'миколаївній подарунок хайлат, скульпто, крем','0'),
(1832,26,'2021-12-01','2021-12-31 11:20:35',8,79.00,'','0'),
(1833,26,'2021-12-01','2021-12-31 11:24:11',18,500.00,'','0');

DROP TABLE IF EXISTS `issuance_wages_master_persent`;

CREATE TABLE `issuance_wages_master_persent` (
  `id` mediumint(6) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `master_id` smallint(5) unsigned NOT NULL,
  `persent` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `date` (`date`,`master_id`)
) ENGINE=MyISAM AUTO_INCREMENT=314 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='на кожен місяць по кожному майстру встановлюємо процент від ';

INSERT INTO `issuance_wages_master_persent` VALUES 
(2,'2020-03-01',7,50),
(3,'2020-03-01',11,40),
(4,'2020-03-01',18,40),
(5,'2020-03-01',8,40),
(6,'2020-03-01',26,50),
(7,'2020-03-01',25,40),
(8,'2020-03-01',21,40),
(9,'2020-03-01',12,40),
(10,'2020-03-01',17,40),
(11,'2020-03-01',23,50),
(12,'2020-03-01',6,50),
(13,'2020-05-01',11,40),
(14,'2020-05-01',7,50),
(15,'2020-05-01',6,50),
(16,'2020-05-01',18,40),
(17,'2020-05-01',12,40),
(18,'2020-05-01',25,40),
(19,'2020-05-01',17,40),
(20,'2020-05-01',8,40),
(21,'2020-05-01',21,40),
(22,'2020-05-01',5,50),
(23,'2020-05-01',10,50),
(24,'2020-05-01',23,50),
(25,'2020-05-01',3,45),
(26,'2020-06-01',7,50),
(27,'2020-06-01',11,40),
(28,'2020-06-01',6,50),
(29,'2020-06-01',15,45),
(30,'2020-06-01',8,40),
(31,'2020-06-01',19,40),
(32,'2020-06-01',18,40),
(33,'2020-06-01',25,40),
(34,'2020-06-01',21,50),
(35,'2020-06-01',12,40),
(36,'2020-06-01',17,40),
(37,'2020-06-01',23,50),
(38,'2020-06-01',3,50),
(39,'2020-06-01',5,50),
(40,'2020-06-01',24,90),
(41,'2020-06-01',20,90),
(42,'2020-06-01',10,50),
(43,'2020-07-01',7,50),
(44,'2020-07-01',15,45),
(45,'2020-07-01',11,45),
(46,'2020-07-01',8,40),
(47,'2020-07-01',18,40),
(48,'2020-07-01',25,40),
(49,'2020-07-01',12,40),
(50,'2020-07-01',17,40),
(51,'2020-07-01',24,90),
(52,'2020-07-01',20,90),
(53,'2020-07-01',3,50),
(54,'2020-07-01',6,50),
(55,'2020-07-01',5,50),
(56,'2020-07-01',23,50),
(57,'2020-07-01',19,0),
(58,'2020-08-01',15,45),
(59,'2020-08-01',8,40),
(60,'2020-08-01',18,45),
(61,'2020-08-01',11,45),
(62,'2020-08-01',25,40),
(63,'2020-08-01',12,40),
(64,'2020-08-01',17,45),
(65,'2020-08-01',23,50),
(66,'2020-08-01',7,50),
(67,'2020-08-01',24,10),
(68,'2020-08-01',20,0),
(69,'2020-08-01',3,50),
(70,'2020-08-01',6,50),
(71,'2020-08-01',5,50),
(72,'2020-08-01',19,40),
(73,'2020-09-01',11,45),
(74,'2020-09-01',24,90),
(75,'2020-09-01',20,90),
(76,'2020-09-01',7,50),
(77,'2020-09-01',8,40),
(78,'2020-09-01',18,45),
(79,'2020-09-01',21,0),
(80,'2020-09-01',17,40),
(81,'2020-09-01',15,45),
(82,'2020-09-01',12,40),
(83,'2020-09-01',23,50),
(84,'2020-09-01',3,50),
(85,'2020-09-01',6,50),
(86,'2020-09-01',5,50),
(87,'2020-09-01',22,40),
(88,'2020-10-01',26,45),
(89,'2020-10-01',15,45),
(90,'2020-10-01',11,45),
(91,'2020-10-01',8,40),
(92,'2020-10-01',18,45),
(93,'2020-10-01',12,40),
(94,'2020-10-01',17,40),
(95,'2020-10-01',23,50),
(96,'2020-10-01',7,50),
(97,'2020-10-01',24,90),
(98,'2020-10-01',20,90),
(99,'2020-10-01',3,50),
(100,'2020-10-01',6,50),
(101,'2020-10-01',5,50),
(102,'2020-10-01',22,40),
(103,'2020-11-01',15,45),
(104,'2020-11-01',7,50),
(105,'2020-11-01',24,90),
(106,'2020-11-01',18,40),
(107,'2020-11-01',11,40),
(108,'2020-11-01',21,0),
(109,'2020-11-01',8,40),
(110,'2020-11-01',25,90),
(111,'2020-11-01',22,40),
(112,'2020-11-01',23,50),
(113,'2020-11-01',5,50),
(114,'2020-11-01',3,50),
(115,'2020-11-01',12,40),
(116,'2020-11-01',26,45),
(117,'2020-11-01',6,50),
(118,'2020-11-01',17,40),
(119,'2020-12-01',11,45),
(120,'2020-12-01',18,45),
(121,'2020-12-01',15,45),
(122,'2020-12-01',7,50),
(123,'2020-12-01',17,40),
(124,'2020-12-01',25,10),
(125,'2020-12-01',24,90),
(126,'2020-12-01',5,50),
(127,'2020-12-01',8,40),
(128,'2020-12-01',12,40),
(129,'2020-12-01',21,40),
(130,'2020-12-01',3,50),
(131,'2020-12-01',26,45),
(132,'2020-12-01',22,40),
(133,'2020-12-01',6,50),
(134,'2021-01-01',18,45),
(135,'2021-01-01',11,40),
(136,'2021-01-01',12,40),
(137,'2021-01-01',8,40),
(138,'2021-01-01',23,50),
(139,'2021-01-01',20,40),
(140,'2021-01-01',6,50),
(141,'2021-01-01',5,50),
(142,'2021-01-01',7,50),
(143,'2021-01-01',22,40),
(144,'2021-01-01',21,40),
(145,'2021-01-01',17,40),
(146,'2021-01-01',24,90),
(147,'2021-01-01',26,45),
(148,'2021-01-01',3,50),
(149,'2021-02-01',12,40),
(150,'2021-02-01',22,40),
(151,'2021-02-01',5,50),
(152,'2021-02-01',6,50),
(153,'2021-02-01',26,45),
(154,'2021-02-01',3,50),
(155,'2021-02-01',7,50),
(156,'2021-02-01',23,50),
(157,'2021-02-01',17,40),
(158,'2021-02-01',21,0),
(159,'2021-02-01',18,40),
(160,'2021-02-01',8,40),
(161,'2021-02-01',11,45),
(162,'2021-02-01',20,40),
(163,'2021-02-01',24,90),
(164,'2021-03-01',22,40),
(165,'2021-03-01',5,50),
(166,'2021-03-01',6,50),
(167,'2021-03-01',26,45),
(168,'2021-03-01',3,50),
(169,'2021-03-01',24,90),
(170,'2021-03-01',7,50),
(171,'2021-03-01',23,50),
(172,'2021-03-01',17,40),
(173,'2021-03-01',12,40),
(174,'2021-03-01',21,40),
(175,'2021-03-01',18,45),
(176,'2021-03-01',8,40),
(177,'2021-03-01',11,45),
(178,'2021-03-01',20,40),
(179,'2021-04-01',8,40),
(180,'2021-04-01',17,45),
(181,'2021-04-01',32,50),
(182,'2021-04-01',5,50),
(183,'2021-04-01',7,50),
(184,'2021-04-01',12,40),
(185,'2021-04-01',22,40),
(186,'2021-04-01',21,40),
(187,'2021-04-01',11,45),
(188,'2021-04-01',24,90),
(189,'2021-04-01',20,40),
(190,'2021-04-01',18,45),
(191,'2021-04-01',3,50),
(192,'2021-04-01',6,50),
(193,'2021-05-01',8,40),
(194,'2021-05-01',20,40),
(195,'2021-05-01',11,45),
(196,'2021-05-01',33,45),
(197,'2021-05-01',22,40),
(198,'2021-05-01',12,40),
(199,'2021-05-01',32,50),
(200,'2021-05-01',6,50),
(201,'2021-05-01',5,50),
(202,'2021-05-01',3,50),
(203,'2021-05-01',26,45),
(204,'2021-05-01',21,0),
(205,'2021-05-01',18,45),
(206,'2021-05-01',17,40),
(207,'2021-05-01',7,50),
(208,'2021-05-01',24,90),
(209,'2021-06-01',7,50),
(210,'2021-06-01',12,45),
(211,'2021-06-01',20,40),
(212,'2021-06-01',33,45),
(213,'2021-06-01',17,40),
(214,'2021-06-01',6,50),
(215,'2021-06-01',22,40),
(216,'2021-06-01',24,90),
(217,'2021-06-01',5,50),
(218,'2021-06-01',11,45),
(219,'2021-06-01',8,45),
(220,'2021-06-01',32,50),
(221,'2021-06-01',18,45),
(222,'2021-06-01',3,50),
(223,'2021-06-01',26,45),
(224,'2021-07-01',7,50),
(225,'2021-07-01',24,90),
(226,'2021-07-01',22,40),
(227,'2021-07-01',20,40),
(228,'2021-07-01',6,50),
(229,'2021-07-01',12,45),
(230,'2021-07-01',35,40),
(231,'2021-07-01',11,45),
(232,'2021-07-01',8,0),
(233,'2021-07-01',32,50),
(234,'2021-07-01',33,45),
(235,'2021-07-01',18,45),
(236,'2021-07-01',17,45),
(237,'2021-07-01',3,50),
(238,'2021-07-01',26,45),
(239,'2021-07-01',5,50),
(240,'2021-08-01',24,90),
(241,'2021-08-01',26,45),
(242,'2021-08-01',35,40),
(243,'2021-08-01',32,50),
(244,'2021-08-01',20,40),
(245,'2021-08-01',33,45),
(246,'2021-08-01',3,50),
(247,'2021-08-01',8,45),
(248,'2021-08-01',18,45),
(249,'2021-08-01',6,50),
(250,'2021-08-01',17,45),
(251,'2021-08-01',12,45),
(252,'2021-08-01',11,45),
(253,'2021-08-01',5,50),
(254,'2021-08-01',22,40),
(255,'2021-08-01',7,50),
(256,'2021-09-01',24,90),
(257,'2021-09-01',33,45),
(258,'2021-09-01',32,50),
(259,'2021-09-01',12,45),
(260,'2021-09-01',6,50),
(261,'2021-09-01',22,40),
(262,'2021-09-01',18,40),
(263,'2021-09-01',11,45),
(264,'2021-09-01',8,0),
(265,'2021-09-01',17,45),
(266,'2021-09-01',7,50),
(267,'2021-09-01',5,50),
(268,'2021-09-01',26,45),
(269,'2021-09-01',3,50),
(270,'2021-10-01',12,40),
(271,'2021-10-01',18,45),
(272,'2021-10-01',21,40),
(273,'2021-10-01',7,50),
(274,'2021-10-01',11,45),
(275,'2021-10-01',8,45),
(276,'2021-10-01',32,50),
(277,'2021-10-01',33,45),
(278,'2021-10-01',17,40),
(279,'2021-10-01',24,10),
(280,'2021-10-01',3,50),
(281,'2021-10-01',6,50),
(282,'2021-10-01',5,50),
(283,'2021-10-01',22,40),
(284,'2021-10-01',26,45),
(285,'2021-11-01',8,45),
(286,'2021-11-01',7,50),
(287,'2021-11-01',12,40),
(288,'2021-11-01',18,45),
(289,'2021-11-01',32,50),
(290,'2021-11-01',6,50),
(291,'2021-11-01',33,45),
(292,'2021-11-01',5,50),
(293,'2021-11-01',24,90),
(294,'2021-11-01',17,40),
(295,'2021-11-01',20,0),
(296,'2021-11-01',22,40),
(297,'2021-11-01',11,45),
(298,'2021-11-01',26,45),
(299,'2021-11-01',3,50),
(300,'2021-12-01',24,90),
(301,'2021-12-01',21,40),
(302,'2021-12-01',32,50),
(303,'2021-12-01',11,45),
(304,'2021-12-01',17,45),
(305,'2021-12-01',8,45),
(306,'2021-12-01',18,45),
(307,'2021-12-01',12,45),
(308,'2021-12-01',7,50),
(309,'2021-12-01',22,40),
(310,'2021-12-01',6,50),
(311,'2021-12-01',26,45),
(312,'2021-12-01',3,50),
(313,'2021-12-01',33,45);

DROP TABLE IF EXISTS `kontragent_poslyga`;

CREATE TABLE `kontragent_poslyga` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `id_kontragent` smallint(5) unsigned NOT NULL,
  `id_poslyga` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2777 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Список послуг які привязані до певного клієнта';

INSERT INTO `kontragent_poslyga` VALUES 
(1,1,1),
(2,1,3),
(3,1,4),
(4,1,6),
(5,1,8),
(6,2,2),
(7,2,3),
(8,2,10),
(9,3,1),
(10,3,2),
(11,3,3),
(12,3,6),
(13,3,8),
(14,3,11),
(15,4,1),
(16,4,3),
(17,4,4),
(18,4,6),
(19,4,7),
(20,4,8),
(21,4,11),
(22,5,1),
(23,5,7),
(24,5,10),
(25,6,2),
(26,6,3),
(27,7,1),
(28,7,4),
(29,7,5),
(30,7,6),
(31,7,7),
(32,7,8),
(33,8,1),
(34,8,6),
(35,8,11),
(36,9,1),
(37,9,2),
(38,9,7),
(39,9,8),
(40,9,11),
(41,9,12),
(1219,10,8),
(1218,10,6),
(1217,10,3),
(1216,10,1),
(46,11,2),
(47,11,3),
(48,11,5),
(49,12,2),
(50,12,3),
(51,12,6),
(52,13,1),
(53,13,2),
(54,13,3),
(55,13,7),
(56,13,8),
(57,15,2),
(58,15,6),
(59,15,7),
(60,15,11),
(61,16,2),
(62,16,3),
(63,16,4),
(64,16,5),
(65,16,7),
(66,17,1),
(67,17,2),
(68,17,3),
(69,17,5),
(70,17,6),
(71,17,11),
(72,18,1),
(73,18,2),
(74,18,3),
(75,18,4),
(76,18,5),
(77,18,6),
(78,18,7),
(79,18,8),
(80,18,9),
(81,18,11),
(82,18,12),
(83,19,1),
(84,19,2),
(85,19,3),
(86,19,6),
(87,19,11),
(88,20,1),
(89,20,4),
(90,20,6),
(91,20,8),
(92,21,1),
(93,21,4),
(94,21,5),
(95,21,6),
(96,21,8),
(97,22,1),
(98,22,2),
(99,22,11),
(100,23,2),
(101,23,3),
(102,23,8),
(103,24,1),
(104,24,2),
(105,24,3),
(106,24,6),
(107,24,7),
(108,24,10),
(109,24,11),
(110,24,12),
(2773,25,9),
(2772,25,8),
(2771,25,6),
(2770,25,5),
(1514,26,8),
(1513,26,7),
(1512,26,5),
(119,27,1),
(120,27,3),
(121,27,4),
(122,27,6),
(123,27,7),
(124,27,12),
(125,28,1),
(126,28,2),
(127,28,3),
(128,28,6),
(129,28,8),
(130,28,11),
(131,29,1),
(132,29,5),
(133,29,11),
(134,29,12),
(135,30,2),
(136,30,3),
(137,30,7),
(138,31,1),
(139,31,2),
(140,31,3),
(141,31,5),
(142,31,7),
(143,31,8),
(144,31,9),
(145,31,11),
(146,31,12),
(147,32,1),
(148,32,2),
(149,32,3),
(150,32,6),
(151,32,8),
(1611,33,8),
(1610,33,6),
(1609,33,3),
(1608,33,2),
(1607,33,1),
(157,0,1),
(158,0,2),
(159,0,3),
(160,0,6),
(161,0,8),
(162,34,1),
(163,34,4),
(164,34,5),
(165,34,6),
(166,35,10),
(167,36,1),
(168,36,4),
(169,36,7),
(170,36,8),
(171,37,1),
(172,37,2),
(173,37,3),
(174,37,5),
(175,37,6),
(176,37,7),
(177,37,11),
(178,38,1),
(179,38,4),
(180,38,5),
(181,38,6),
(182,38,8),
(183,38,12),
(184,39,1),
(185,39,4),
(186,39,6),
(187,39,8),
(188,40,2),
(189,40,3),
(190,40,7),
(191,41,1),
(192,41,2),
(193,41,3),
(194,41,4),
(195,41,7),
(196,41,10),
(197,41,11),
(198,42,1),
(199,42,2),
(200,42,3),
(201,42,8),
(202,42,11),
(203,42,12),
(2738,43,6),
(2737,43,1),
(206,45,1),
(207,45,2),
(208,45,3),
(209,45,4),
(210,45,6),
(211,46,1),
(212,46,2),
(213,46,3),
(214,46,4),
(215,46,5),
(216,46,6),
(217,46,7),
(218,46,8),
(219,46,10),
(220,46,11),
(221,47,1),
(222,47,5),
(223,47,6),
(224,47,7),
(225,47,12),
(226,48,1),
(227,48,2),
(228,48,3),
(229,48,6),
(230,48,12),
(231,49,1),
(232,49,2),
(233,49,4),
(234,49,6),
(235,49,8),
(236,49,11),
(237,50,1),
(238,50,4),
(239,50,8),
(240,51,1),
(241,51,2),
(242,51,3),
(243,51,4),
(244,51,5),
(245,51,7),
(246,51,10),
(247,51,11),
(248,52,1),
(249,52,6),
(250,52,7),
(251,52,11),
(252,53,4),
(253,53,6),
(254,54,3),
(255,54,6),
(256,54,7),
(257,54,8),
(258,54,11),
(259,54,12),
(260,55,5),
(261,55,8),
(262,56,4),
(263,56,6),
(264,56,7),
(265,56,10),
(266,56,12),
(267,57,1),
(268,57,3),
(269,57,4),
(270,57,7),
(271,57,11),
(272,58,2),
(273,58,3),
(274,58,4),
(275,58,6),
(276,58,8),
(277,59,2),
(278,59,3),
(279,59,4),
(280,59,6),
(281,59,11),
(282,60,1),
(283,60,3),
(284,60,5),
(285,60,9),
(286,60,11),
(287,60,12),
(288,61,1),
(289,61,2),
(290,61,3),
(291,61,4),
(292,61,7),
(293,62,1),
(294,62,2),
(295,62,3),
(296,62,4),
(297,62,5),
(298,62,6),
(299,62,7),
(300,62,10),
(1152,63,10),
(1151,63,7),
(1150,63,6),
(1149,63,5),
(1148,63,3),
(1147,63,2),
(1146,63,1),
(308,64,1),
(309,64,6),
(310,65,1),
(311,65,4),
(312,65,5),
(313,65,6),
(314,65,7),
(315,65,8),
(316,65,10),
(317,66,1),
(318,66,4),
(319,66,6),
(320,66,7),
(321,66,9),
(322,66,10),
(323,66,11),
(324,67,2),
(325,67,3),
(326,67,4),
(327,67,6),
(328,67,8),
(329,67,10),
(330,67,11),
(331,68,1),
(332,68,3),
(333,68,4),
(334,68,8),
(335,68,11),
(336,69,1),
(337,69,2),
(338,69,4),
(339,69,6),
(340,69,7),
(341,69,8),
(342,69,12),
(1120,70,10),
(1119,70,6),
(1118,70,6),
(346,71,1),
(347,71,4),
(348,71,11),
(349,71,12),
(350,72,2),
(351,72,3),
(352,72,6),
(353,73,1),
(354,73,2),
(355,73,3),
(356,73,4),
(357,73,7),
(358,73,8),
(359,74,1),
(360,74,3),
(361,74,4),
(362,74,6),
(363,74,8),
(364,75,1),
(365,75,4),
(366,75,6),
(367,75,12),
(368,76,1),
(369,76,5),
(370,76,10),
(371,77,2),
(372,77,3),
(373,77,4),
(374,77,6),
(375,78,1),
(376,78,2),
(377,78,6),
(378,78,8),
(2122,79,8),
(2121,79,6),
(2120,79,4),
(382,80,1),
(383,80,6),
(384,80,7),
(385,81,1),
(386,81,2),
(387,81,5),
(388,81,8),
(389,82,1),
(390,82,3),
(391,82,6),
(392,82,8),
(393,82,11),
(394,82,12),
(395,83,1),
(396,83,2),
(397,83,3),
(398,83,4),
(399,83,5),
(400,83,6),
(401,83,9),
(402,83,12),
(403,84,1),
(404,84,5),
(405,84,7),
(406,84,11),
(407,84,12),
(408,85,1),
(409,85,2),
(410,85,3),
(411,85,6),
(412,85,8),
(413,85,11),
(414,86,1),
(415,86,2),
(416,86,3),
(417,86,4),
(418,86,5),
(419,86,6),
(420,86,7),
(421,86,8),
(422,86,10),
(423,86,11),
(424,86,12),
(425,87,2),
(426,87,3),
(427,87,4),
(428,87,6),
(429,87,10),
(430,87,11),
(431,88,1),
(432,88,2),
(433,88,3),
(434,88,5),
(435,88,7),
(436,88,8),
(437,88,10),
(438,89,1),
(439,89,2),
(440,89,3),
(441,89,6),
(442,89,7),
(443,89,10),
(444,90,1),
(445,90,2),
(446,90,5),
(447,91,1),
(448,91,2),
(449,91,3),
(450,91,4),
(451,91,6),
(452,91,12),
(453,92,1),
(454,92,2),
(455,92,3),
(456,92,7),
(457,92,11),
(458,93,1),
(459,93,2),
(460,93,3),
(461,93,4),
(462,93,6),
(463,93,8),
(464,93,11),
(465,93,12),
(466,94,2),
(467,94,3),
(468,94,4),
(469,95,1),
(470,95,2),
(471,95,3),
(472,95,4),
(473,95,6),
(474,95,7),
(475,95,8),
(476,95,10),
(477,95,11),
(478,96,1),
(479,96,2),
(480,96,3),
(481,96,4),
(482,96,7),
(483,96,9),
(484,96,10),
(485,96,12),
(486,97,1),
(487,97,2),
(488,97,3),
(489,97,6),
(490,97,7),
(491,98,2),
(492,98,3),
(493,98,4),
(494,98,6),
(495,98,7),
(496,98,8),
(497,98,9),
(498,99,4),
(499,99,7),
(500,99,8),
(501,100,1);

INSERT INTO `kontragent_poslyga` VALUES 
(502,100,2),
(503,100,3),
(504,100,4),
(505,100,6),
(506,100,7),
(507,100,8),
(508,100,11),
(509,101,2),
(510,101,3),
(511,101,6),
(512,101,8),
(513,101,11),
(514,102,1),
(515,102,2),
(516,102,3),
(517,102,6),
(518,103,3),
(519,103,6),
(520,104,2),
(521,104,3),
(522,104,5),
(523,104,6),
(524,104,7),
(525,104,8),
(526,105,1),
(527,105,4),
(528,105,5),
(529,105,6),
(541,106,12),
(540,106,11),
(539,106,7),
(538,106,3),
(537,106,2),
(536,106,1),
(542,107,1),
(543,107,5),
(544,107,7),
(545,108,1),
(546,108,2),
(547,108,3),
(548,108,11),
(549,109,1),
(550,109,4),
(551,109,7),
(552,109,12),
(553,110,1),
(554,110,2),
(555,110,3),
(556,110,6),
(557,110,7),
(558,111,1),
(559,111,6),
(560,111,8),
(561,112,1),
(562,112,4),
(563,112,6),
(564,112,7),
(565,113,1),
(566,113,2),
(567,113,3),
(568,113,11),
(569,114,1),
(570,114,2),
(571,114,3),
(572,114,8),
(1848,115,11),
(1847,115,10),
(1846,115,8),
(1845,115,7),
(1844,115,6),
(1843,115,3),
(1842,115,2),
(1841,115,1),
(581,116,1),
(582,116,3),
(583,116,5),
(584,116,6),
(585,116,10),
(586,117,2),
(587,117,4),
(588,117,8),
(589,117,12),
(590,118,1),
(591,118,2),
(592,118,7),
(593,118,8),
(594,119,1),
(595,119,2),
(596,119,5),
(597,119,7),
(598,119,8),
(599,119,12),
(600,120,2),
(601,120,3),
(602,120,6),
(603,121,1),
(604,121,2),
(605,121,3),
(606,121,4),
(607,121,6),
(608,121,8),
(609,121,11),
(610,121,12),
(1253,122,11),
(1252,122,6),
(1251,122,4),
(1250,122,3),
(1249,122,2),
(616,123,1),
(617,123,4),
(618,123,7),
(1896,124,8),
(1895,124,6),
(1894,124,2),
(622,125,1),
(623,125,2),
(624,125,3),
(625,125,5),
(626,125,6),
(627,125,7),
(628,125,9),
(629,125,10),
(630,125,12),
(631,126,1),
(632,126,5),
(633,126,6),
(634,126,7),
(635,127,4),
(636,127,5),
(637,127,6),
(638,127,8),
(639,127,9),
(640,127,11),
(641,128,1),
(642,128,3),
(643,128,6),
(644,128,11),
(645,129,1),
(646,129,4),
(647,129,8),
(648,129,11),
(649,130,4),
(650,130,5),
(651,130,6),
(652,130,10),
(653,130,11),
(654,131,1),
(655,131,2),
(656,131,3),
(657,131,6),
(2776,132,6),
(2775,132,3),
(2774,132,1),
(662,133,2),
(663,133,4),
(664,133,12),
(665,134,1),
(666,134,3),
(667,134,6),
(668,134,8),
(669,134,10),
(670,135,2),
(671,135,7),
(672,135,10),
(673,135,12),
(674,136,1),
(675,136,6),
(676,136,7),
(677,136,10),
(678,137,5),
(679,137,6),
(680,137,7),
(681,137,8),
(682,137,10),
(683,138,2),
(684,138,4),
(685,139,1),
(686,139,5),
(687,139,12),
(688,140,1),
(689,140,5),
(690,140,7),
(691,140,8),
(692,140,11),
(693,141,1),
(694,141,2),
(695,141,3),
(696,141,4),
(697,141,7),
(698,141,8),
(699,141,12),
(700,142,2),
(701,142,3),
(2769,143,11),
(2768,143,8),
(2767,143,6),
(2766,143,5),
(2765,143,3),
(2764,143,2),
(2763,143,1),
(710,144,1),
(711,144,2),
(712,144,3),
(713,144,5),
(714,144,6),
(715,144,7),
(716,144,8),
(717,144,10),
(718,144,11),
(719,144,12),
(720,145,1),
(721,145,5),
(722,146,6),
(723,146,7),
(724,146,10),
(725,146,11),
(726,147,1),
(727,147,2),
(728,147,5),
(1353,148,8),
(1352,148,6),
(1351,148,5),
(1350,148,1),
(733,149,2),
(734,149,6),
(735,150,1),
(736,150,2),
(737,150,3),
(738,150,5),
(987,202,2),
(986,202,1),
(741,152,1),
(742,152,3),
(743,152,6),
(744,152,7),
(745,153,1),
(746,153,2),
(747,153,6),
(748,153,8),
(749,154,1),
(750,154,2),
(751,154,6),
(752,154,7),
(753,154,8),
(754,155,1),
(755,155,3),
(756,155,6),
(757,155,8),
(758,155,9),
(759,156,2),
(760,156,3),
(761,156,8),
(762,156,11),
(763,157,1),
(764,157,2),
(765,157,3),
(766,158,2),
(767,158,3),
(768,159,2),
(769,159,3),
(770,159,8),
(1467,160,11),
(1466,160,6),
(1465,160,2),
(774,161,3),
(775,161,4),
(776,161,6),
(777,162,1),
(778,162,2),
(779,162,3),
(780,162,6),
(781,162,8),
(782,162,11),
(2736,163,11),
(2735,163,8),
(2734,163,6),
(2733,163,3),
(2732,163,2),
(788,164,2),
(789,164,3),
(790,165,1),
(791,165,2),
(792,165,4),
(793,165,6),
(794,165,8),
(795,166,6),
(796,166,7),
(797,166,8),
(798,166,9),
(799,167,1),
(800,167,6),
(801,167,7),
(802,167,12),
(803,168,1),
(804,168,2),
(805,168,3),
(806,168,4),
(807,168,5),
(808,168,6),
(809,168,7),
(810,168,8),
(811,168,9),
(812,168,10),
(813,169,4),
(814,169,8),
(815,170,2),
(816,170,3),
(817,170,4),
(818,170,5),
(819,170,6),
(820,170,7),
(821,171,1),
(822,171,2),
(823,171,6),
(824,172,1),
(825,172,3),
(826,172,4),
(827,172,6),
(828,172,7),
(829,172,8),
(830,172,11),
(831,172,12),
(832,173,1),
(833,173,2),
(834,173,4),
(835,173,7),
(836,174,1),
(837,174,2),
(838,174,3),
(839,174,4),
(840,174,6),
(841,174,7),
(842,174,8),
(843,174,11),
(844,174,12),
(845,175,2),
(846,175,3),
(847,175,5),
(848,175,6),
(849,176,2),
(850,176,3),
(851,176,6),
(852,176,7),
(853,177,4),
(854,178,1),
(855,178,2),
(856,178,3),
(857,178,4),
(858,178,5),
(859,178,6),
(860,178,7),
(861,178,8),
(862,178,11),
(863,178,12),
(864,179,2),
(865,179,5),
(866,180,2),
(867,180,3),
(868,180,11),
(869,181,2),
(870,181,3),
(871,182,6),
(872,182,7),
(873,182,11),
(874,182,12),
(875,183,1),
(876,183,4),
(877,183,6),
(878,183,8),
(879,184,1),
(880,184,2),
(881,184,3),
(882,184,11),
(883,185,1),
(884,185,2),
(885,185,3),
(886,185,4),
(887,185,5),
(888,185,6),
(889,185,7),
(890,185,8),
(891,185,9),
(892,185,10),
(893,185,11),
(894,185,12),
(895,186,1),
(896,186,3),
(897,186,6),
(898,186,7),
(2091,187,12),
(2090,187,10),
(2089,187,7),
(2088,187,6),
(2087,187,5),
(2086,187,3),
(2085,187,2),
(2084,187,1),
(907,188,1),
(908,188,3),
(909,188,5),
(910,188,7),
(911,188,8),
(912,189,1),
(913,189,7),
(914,189,8),
(915,189,10),
(916,189,11),
(917,190,1),
(918,190,2),
(919,190,3),
(920,190,4),
(921,190,5),
(922,190,6),
(923,190,7),
(924,190,8),
(925,190,11),
(926,190,12),
(927,191,1),
(928,191,2),
(929,191,3),
(930,191,5),
(931,191,7),
(932,191,8),
(933,191,9),
(934,191,10),
(1511,192,6),
(1510,192,3),
(1509,192,2),
(938,193,1),
(939,193,2),
(940,193,4),
(941,193,7),
(942,193,11),
(943,193,12),
(944,194,1),
(945,194,2),
(946,194,6),
(947,195,1),
(948,195,2),
(949,195,3),
(950,195,4),
(951,195,5),
(952,195,6),
(953,195,7),
(954,195,8),
(955,195,9),
(956,195,10),
(957,195,11),
(1402,196,10),
(1401,196,4),
(960,197,1),
(961,197,4),
(962,197,8),
(963,198,1),
(964,198,6),
(965,198,8),
(966,198,9),
(967,198,10),
(968,198,11),
(969,198,12),
(970,199,1),
(971,199,2),
(972,199,3),
(973,200,2),
(974,200,6),
(975,200,7),
(976,200,8),
(985,151,10),
(984,151,5),
(981,201,6),
(982,201,8),
(983,201,11),
(988,202,4),
(989,202,7),
(990,203,1),
(991,203,5),
(992,203,6),
(993,203,8),
(994,203,11),
(2706,204,11),
(2705,204,10),
(2704,204,5),
(2703,204,3),
(2702,204,1),
(1002,205,1),
(1003,205,2),
(1004,205,10),
(1005,206,2),
(1006,206,8),
(1007,206,10),
(1008,207,1),
(1009,207,2),
(1010,207,3),
(1011,207,6),
(1012,207,7),
(1013,207,8),
(1014,208,3),
(1015,209,3),
(1016,209,5),
(1017,209,8);

INSERT INTO `kontragent_poslyga` VALUES 
(1018,210,1),
(1019,210,4),
(1020,210,8),
(1021,211,4),
(1022,211,8),
(1023,212,1),
(1024,212,3),
(1025,212,5),
(1026,212,9),
(1027,212,11),
(1028,213,1),
(1029,213,5),
(1030,213,8),
(1031,213,11),
(1032,214,1),
(1033,214,2),
(1034,214,3),
(1035,214,6),
(1036,214,7),
(1420,215,12),
(1419,215,11),
(1418,215,8),
(1417,215,7),
(1416,215,6),
(1415,215,4),
(1414,215,3),
(1413,215,1),
(1045,216,1),
(1046,216,2),
(1047,216,3),
(1048,216,4),
(1049,217,1),
(1050,217,2),
(1051,217,3),
(1052,217,6),
(1053,217,7),
(1054,218,1),
(1055,218,2),
(1056,218,3),
(1057,219,1),
(1058,219,2),
(1059,219,3),
(1060,219,4),
(1061,219,5),
(1062,219,6),
(1063,219,11),
(1064,220,1),
(1065,220,2),
(1066,220,3),
(1067,220,4),
(1068,220,5),
(1069,220,6),
(1070,221,1),
(1071,221,7),
(1072,222,1),
(1073,222,2),
(1074,222,3),
(1075,222,4),
(1076,222,5),
(1077,223,1),
(1078,223,2),
(1079,223,3),
(1080,223,4),
(1081,223,5),
(1082,223,6),
(1083,223,7),
(1084,223,8),
(1085,223,9),
(1086,223,10),
(1087,223,11),
(1088,223,12),
(1089,224,1),
(1090,224,7),
(1091,224,10),
(1092,224,11),
(1093,225,1),
(1094,225,3),
(1095,225,6),
(1096,225,11),
(1097,226,1),
(1098,226,3),
(1099,226,4),
(1100,226,6),
(1101,226,8),
(1201,227,7),
(1200,227,4),
(1199,227,3),
(1105,228,1),
(1106,228,2),
(1107,228,3),
(1108,228,4),
(1109,228,5),
(1110,228,6),
(1111,229,1),
(1112,229,2),
(1113,229,3),
(1114,229,4),
(1115,229,6),
(1116,229,11),
(1117,229,12),
(1121,70,10),
(1122,70,12),
(1123,70,12),
(1124,230,2),
(1125,230,4),
(1126,230,6),
(1127,230,7),
(1128,230,10),
(1875,231,8),
(1874,231,7),
(1873,231,6),
(1872,231,3),
(1871,231,2),
(1870,231,1),
(2762,232,11),
(2761,232,6),
(2760,232,5),
(2759,232,4),
(2758,232,3),
(2757,232,2),
(1167,233,11),
(1166,233,8),
(1165,233,6),
(1164,233,4),
(1163,233,1),
(1153,234,2),
(1154,234,3),
(1155,234,4),
(1156,234,6),
(1157,234,8),
(1168,235,6),
(1169,235,7),
(1170,235,8),
(1171,236,1),
(1172,236,3),
(1173,236,6),
(1174,236,11),
(1175,237,5),
(1176,237,6),
(1177,237,8),
(1178,238,2),
(1179,238,3),
(1180,238,6),
(1181,239,1),
(1182,239,4),
(1183,239,6),
(1184,239,7),
(1185,239,8),
(1186,239,11),
(1187,239,12),
(1191,240,1),
(1192,240,2),
(1193,240,3),
(1194,240,6),
(1195,240,8),
(1202,241,1),
(1203,241,8),
(1204,241,11),
(1205,242,1),
(1206,242,3),
(1207,242,6),
(1208,242,7),
(1209,242,11),
(1210,243,1),
(1211,243,3),
(1212,243,4),
(1213,243,6),
(1214,243,7),
(1215,243,11),
(1220,244,1),
(1221,244,2),
(1222,244,3),
(1223,244,4),
(1224,244,5),
(1225,244,6),
(1226,244,7),
(1227,244,11),
(1228,244,12),
(1229,245,3),
(1230,245,4),
(1231,245,5),
(1232,245,6),
(1233,245,8),
(1234,245,9),
(1235,245,11),
(1236,0,1),
(1237,0,2),
(1238,0,3),
(1239,0,4),
(1240,0,6),
(1241,0,8),
(1242,0,11),
(1243,0,12),
(1254,246,1),
(1255,246,6),
(1256,246,11),
(1257,247,1),
(1258,247,2),
(1259,247,3),
(1260,247,7),
(1261,247,11),
(1262,248,1),
(1263,248,2),
(1264,248,3),
(1265,248,4),
(1266,248,6),
(1267,248,7),
(1268,248,8),
(1269,248,9),
(1270,248,11),
(1271,248,12),
(1272,249,1),
(1273,249,2),
(1274,249,3),
(1275,249,4),
(1276,249,6),
(1277,249,7),
(1278,249,8),
(1279,249,9),
(1280,249,10),
(1281,249,11),
(1282,249,12),
(1283,250,1),
(1284,250,5),
(1285,250,8),
(1286,250,9),
(1287,250,12),
(1288,251,1),
(1289,251,2),
(1290,251,3),
(1291,251,4),
(1292,251,5),
(1293,251,6),
(1294,251,7),
(1295,251,8),
(1296,251,12),
(1297,252,1),
(1298,252,2),
(1299,252,3),
(1300,252,6),
(1301,252,11),
(1302,0,1),
(1303,0,2),
(1304,0,3),
(1305,0,6),
(1306,0,11),
(1307,253,1),
(1308,253,3),
(1309,253,6),
(1310,253,11),
(1311,254,1),
(1312,254,2),
(1313,254,3),
(1314,254,6),
(1315,254,8),
(1316,254,11),
(1317,255,1),
(1318,0,1),
(1319,255,3),
(1320,0,3),
(1321,255,4),
(1322,0,4),
(1323,255,6),
(1324,0,6),
(1325,0,7),
(1326,255,7),
(1327,0,8),
(1328,255,8),
(1329,0,11),
(1330,255,11),
(1331,0,12),
(1332,255,12),
(1333,256,1),
(1334,256,2),
(1335,256,3),
(1336,256,6),
(1337,256,11),
(1338,257,1),
(1339,257,2),
(1340,257,3),
(1341,257,4),
(1342,257,5),
(1343,257,6),
(1344,257,7),
(1345,257,8),
(1346,257,9),
(1347,257,10),
(1348,257,11),
(1349,257,12),
(1354,0,1),
(1355,0,2),
(1356,0,3),
(1357,0,4),
(1358,0,6),
(1359,0,8),
(1360,0,11),
(1361,0,12),
(1362,0,1),
(1363,0,2),
(1364,0,3),
(1365,0,4),
(1366,0,5),
(1367,0,6),
(1368,0,7),
(1369,0,11),
(1370,0,12),
(1371,0,3),
(1372,0,6),
(1373,0,7),
(1374,0,8),
(1375,0,11),
(1376,0,12),
(1377,0,3),
(1378,0,6),
(1379,0,7),
(1380,0,8),
(1381,0,11),
(1382,0,12),
(1383,0,1),
(1384,0,2),
(1385,0,3),
(1386,0,4),
(1387,0,6),
(1388,0,7),
(1389,0,10),
(1390,0,11),
(1391,0,12),
(1396,0,2),
(1397,0,3),
(1398,0,4),
(1399,0,6),
(1400,0,11),
(1403,0,6),
(1404,0,9),
(1405,0,11),
(1406,0,12),
(1407,0,1),
(1408,0,2),
(1409,0,3),
(1410,0,4),
(1411,0,5),
(1412,0,6),
(1421,0,1),
(1422,0,2),
(1423,0,3),
(1424,0,7),
(1425,0,8),
(1426,0,10),
(1427,0,11),
(1428,0,12),
(1429,0,1),
(1430,0,4),
(1431,0,6),
(1432,0,8),
(1433,0,4),
(1434,0,6),
(1435,0,8),
(1436,0,12),
(1437,0,2),
(1438,0,3),
(1439,0,5),
(1440,0,6),
(1441,0,10),
(1442,0,1),
(1443,0,2),
(1444,0,3),
(1445,0,5),
(1446,0,6),
(1447,0,8),
(1448,0,11),
(1449,0,12),
(1450,0,1),
(1451,0,2),
(1452,0,3),
(1453,0,4),
(1454,0,8),
(1455,0,11),
(1468,0,2),
(1469,0,3),
(1470,0,6),
(1471,0,11),
(1472,0,3),
(1473,0,4),
(1474,0,6),
(1475,0,8),
(1476,0,11),
(1477,0,3),
(1478,0,4),
(1479,0,6),
(1480,0,8),
(1481,0,11),
(1482,0,1),
(1483,0,3),
(1484,0,4),
(1485,0,5),
(1486,0,6),
(1487,0,7),
(1488,0,8),
(1489,0,11),
(1490,0,1),
(1491,0,3),
(1492,0,4),
(1493,0,5),
(1494,0,6),
(1495,0,7),
(1496,0,8),
(1497,0,11),
(1498,0,2),
(1499,0,4),
(1500,0,6),
(1501,0,7),
(1502,0,11),
(1503,0,2),
(1504,0,3),
(1505,0,6),
(1506,0,7),
(1507,0,11),
(1508,0,12),
(1515,0,1),
(1516,0,2),
(1517,0,4),
(1518,0,6),
(1519,0,7),
(1520,0,8),
(1521,0,11),
(1522,0,1),
(1523,0,2),
(1524,0,3),
(1525,0,7),
(1526,0,11),
(1527,0,12),
(1528,0,1),
(1529,0,2),
(1530,0,3),
(1531,0,4),
(1532,0,6),
(1533,0,7),
(1534,0,8),
(1535,0,11),
(1536,0,1),
(1537,0,6),
(1538,0,12),
(1539,0,1),
(1540,0,2),
(1541,0,3),
(1542,0,4),
(1543,0,6),
(1544,0,11),
(1545,0,1),
(1546,0,2),
(1547,0,3),
(1548,0,5),
(1549,0,7),
(1550,0,8),
(1551,0,1),
(1552,0,2),
(1553,0,3),
(1554,0,6),
(1555,0,7),
(1556,0,8),
(1557,0,10),
(1558,0,11),
(1559,0,12),
(1560,0,1),
(1561,0,2),
(1562,0,3),
(1563,0,4),
(1564,0,6),
(1565,0,1),
(1566,0,8),
(1567,0,11),
(1568,0,1),
(1569,0,8),
(1570,0,11),
(1571,0,1),
(1572,0,8),
(1573,0,11),
(1574,0,1),
(1575,0,8),
(1576,0,11),
(1577,0,1),
(1578,0,2),
(1579,0,3),
(1580,0,4),
(1581,0,6),
(1582,0,10),
(1583,0,11),
(1584,0,1),
(1585,0,3),
(1586,0,4),
(1587,0,6),
(1588,0,7),
(1589,0,8),
(1590,0,10),
(1591,0,11),
(1592,0,2),
(1593,0,3),
(1594,0,5),
(1595,0,6),
(1596,0,11);

INSERT INTO `kontragent_poslyga` VALUES 
(1597,0,12),
(1598,0,3),
(1599,0,6),
(1600,0,1),
(1601,0,5),
(1602,0,6),
(1603,0,7),
(1604,0,8),
(1605,0,10),
(1606,0,12),
(1612,0,1),
(1613,0,2),
(1614,0,3),
(1615,0,6),
(1616,0,8),
(1617,0,1),
(1618,0,2),
(1619,0,3),
(1620,0,4),
(1621,0,5),
(1622,0,6),
(1623,0,7),
(1624,0,8),
(1625,0,11),
(1626,0,1),
(1627,0,2),
(1628,0,3),
(1629,0,4),
(1630,0,5),
(1631,0,6),
(1632,0,8),
(1633,0,9),
(1634,0,10),
(1635,0,11),
(1636,0,12),
(1637,0,2),
(1638,0,3),
(1639,0,5),
(1640,0,6),
(1641,0,1),
(1642,0,3),
(1643,0,5),
(1644,0,6),
(1645,0,7),
(1646,0,8),
(1647,0,10),
(1648,0,11),
(1649,0,12),
(1650,0,2),
(1651,0,3),
(1652,0,5),
(1653,0,6),
(1654,0,1),
(1655,0,2),
(1656,0,3),
(1657,0,4),
(1658,0,6),
(1659,0,7),
(1893,298,7),
(1892,298,6),
(1891,298,4),
(1890,298,3),
(1889,298,2),
(1888,298,1),
(1666,0,1),
(1667,0,2),
(1668,0,3),
(1669,0,6),
(1670,0,1),
(1671,0,2),
(1672,0,3),
(1673,0,6),
(1674,0,11),
(1675,0,1),
(1676,0,2),
(1677,0,3),
(1678,0,8),
(1679,0,11),
(1680,0,1),
(1681,0,2),
(1682,0,3),
(1683,0,4),
(1684,0,5),
(1685,0,6),
(1686,0,7),
(1687,0,8),
(1688,0,9),
(1689,0,10),
(1690,0,11),
(1691,0,12),
(1692,0,1),
(1693,0,3),
(1694,0,6),
(1695,0,7),
(1696,0,11),
(1697,0,3),
(1698,0,5),
(1699,0,6),
(1700,0,3),
(1701,0,5),
(1702,0,6),
(1703,0,7),
(1704,0,1),
(1705,0,2),
(1706,0,3),
(1707,0,8),
(1708,0,9),
(1709,0,11),
(1710,0,1),
(1711,0,4),
(1712,0,6),
(1713,0,7),
(1714,0,9),
(1715,0,11),
(1716,0,12),
(1717,0,1),
(1718,0,5),
(1719,0,6),
(1720,0,7),
(1721,0,8),
(1722,0,9),
(1723,0,11),
(1724,0,1),
(1725,0,2),
(1726,0,3),
(1727,0,4),
(1728,0,5),
(1729,0,6),
(1730,0,8),
(1731,0,11),
(1732,0,1),
(1733,0,2),
(1734,0,3),
(1735,0,7),
(1736,0,11),
(1737,0,12),
(1738,0,1),
(1739,0,4),
(1740,0,6),
(1741,0,7),
(1742,0,8),
(1743,0,11),
(1744,0,12),
(1745,0,1),
(1746,0,6),
(1747,0,7),
(1748,0,1),
(1749,0,2),
(1750,0,3),
(1751,0,6),
(1752,0,8),
(1753,0,1),
(1754,0,2),
(1755,0,3),
(1756,0,6),
(1757,0,8),
(1758,0,1),
(1759,0,2),
(1760,0,3),
(1761,0,6),
(1762,0,8),
(1763,0,1),
(1764,0,6),
(1765,0,8),
(1766,0,11),
(1767,0,1),
(1768,0,2),
(1769,0,3),
(1770,0,6),
(1771,0,7),
(1772,0,11),
(1773,0,12),
(1774,0,1),
(1775,0,2),
(1776,0,3),
(1777,0,6),
(1778,0,7),
(1779,0,1),
(1780,0,2),
(1781,0,3),
(1782,0,8),
(1783,0,3),
(1784,0,6),
(1785,0,9),
(1786,0,12),
(1839,0,3),
(1838,0,2),
(1789,0,1),
(1790,0,2),
(1791,0,3),
(1792,0,4),
(1793,0,5),
(1794,0,6),
(1795,0,7),
(1796,0,8),
(1797,0,9),
(1798,0,11),
(1799,0,12),
(1802,0,1),
(1803,0,2),
(1804,0,3),
(1805,0,4),
(1806,0,5),
(1807,0,6),
(1808,0,7),
(1809,0,8),
(1810,0,9),
(1811,0,10),
(1812,0,11),
(1813,0,12),
(1816,0,2),
(1817,0,3),
(1818,0,7),
(1819,0,8),
(1820,0,11),
(1823,0,1),
(1824,0,6),
(1825,0,8),
(1826,0,1),
(1827,0,2),
(1828,0,3),
(1829,0,6),
(1830,0,8),
(1833,0,4),
(1834,0,6),
(1835,0,8),
(1836,0,9),
(1837,0,11),
(1840,0,6),
(1867,0,2),
(1868,0,3),
(1869,0,6),
(1897,0,1),
(1898,0,2),
(1899,0,3),
(1900,0,4),
(1901,0,5),
(1902,0,6),
(1903,0,11),
(1904,0,2),
(1905,0,3),
(1906,0,4),
(1907,0,5),
(1908,0,6),
(1909,0,1),
(1910,0,2),
(1911,0,3),
(1912,0,4),
(1913,0,5),
(1914,0,6),
(1915,0,7),
(1916,0,8),
(1917,0,11),
(1918,0,7),
(1919,0,1),
(1920,0,2),
(1921,0,6),
(1922,0,11),
(1923,0,12),
(1924,314,1),
(1925,314,2),
(1926,314,3),
(1927,314,6),
(1928,314,11),
(1929,314,12),
(1930,0,1),
(1931,0,2),
(1932,0,3),
(1933,0,4),
(1934,0,5),
(1935,0,6),
(1936,0,7),
(1937,0,8),
(1938,0,11),
(1939,0,1),
(1940,0,2),
(1941,0,3),
(1942,0,4),
(1943,0,5),
(1944,0,6),
(1945,0,7),
(1946,0,8),
(1947,0,11),
(1948,0,1),
(1949,0,2),
(1950,0,3),
(1951,0,4),
(1952,0,6),
(1953,0,11),
(1954,0,1),
(1955,0,3),
(1956,0,4),
(1957,0,5),
(1958,0,7),
(1959,0,1),
(1960,0,2),
(1961,0,3),
(1962,0,6),
(1963,0,10),
(1964,0,11),
(1965,0,1),
(1966,0,2),
(1967,0,3),
(1968,0,4),
(1969,0,6),
(1970,0,8),
(1971,0,11),
(1972,0,6),
(1973,0,7),
(1974,0,8),
(1975,0,10),
(1976,0,11),
(1977,0,11),
(1978,0,11),
(1979,0,1),
(1980,0,2),
(1981,0,3),
(1982,0,4),
(1983,0,6),
(1984,0,10),
(1985,0,11),
(1986,0,12),
(1987,0,4),
(1988,0,5),
(1989,0,7),
(1990,0,8),
(1991,0,9),
(1992,0,10),
(1993,0,11),
(1994,0,2),
(1995,0,3),
(1996,0,4),
(1997,0,6),
(1998,0,1),
(1999,0,2),
(2000,0,3),
(2001,0,4),
(2002,0,6),
(2003,0,7),
(2004,0,8),
(2005,0,11),
(2006,0,12),
(2007,0,1),
(2008,0,3),
(2009,0,6),
(2010,0,4),
(2011,0,6),
(2012,0,8),
(2013,0,1),
(2014,0,2),
(2015,0,3),
(2016,0,6),
(2017,0,8),
(2018,0,10),
(2019,0,11),
(2020,0,1),
(2021,0,2),
(2022,0,3),
(2023,0,4),
(2024,0,6),
(2025,0,7),
(2026,0,8),
(2027,0,11),
(2028,0,3),
(2029,0,4),
(2030,0,6),
(2031,0,8),
(2032,0,11),
(2033,0,1),
(2034,0,2),
(2035,0,3),
(2036,0,8),
(2037,0,11),
(2038,0,12),
(2039,0,1),
(2040,0,2),
(2041,0,3),
(2042,0,4),
(2043,0,5),
(2044,0,6),
(2045,0,7),
(2046,0,8),
(2047,0,9),
(2048,0,10),
(2049,0,11),
(2050,0,12),
(2051,0,1),
(2052,0,3),
(2053,0,4),
(2054,0,6),
(2055,0,11),
(2056,0,1),
(2057,0,2),
(2058,0,3),
(2059,0,6),
(2060,0,11),
(2061,0,1),
(2062,0,2),
(2063,0,10),
(2064,0,11),
(2065,0,1),
(2066,0,2),
(2067,0,3),
(2068,0,4),
(2069,0,5),
(2070,0,6),
(2071,0,7),
(2072,0,8),
(2073,0,9),
(2074,0,10),
(2075,0,11),
(2076,0,12),
(2077,0,1),
(2078,0,6),
(2079,0,8),
(2080,0,1),
(2081,0,4),
(2082,0,6),
(2083,0,8),
(2092,0,1),
(2093,0,2),
(2094,0,3),
(2095,0,4),
(2096,0,5),
(2097,0,6),
(2098,0,8),
(2099,0,10),
(2100,0,11),
(2101,0,1),
(2102,0,4),
(2103,0,8),
(2104,0,1),
(2105,0,2),
(2106,0,3),
(2107,0,4),
(2108,0,5),
(2109,0,6),
(2110,0,7),
(2111,0,8),
(2112,0,9),
(2113,0,10),
(2114,0,11),
(2115,0,12),
(2116,0,2),
(2117,0,3),
(2118,0,6),
(2119,0,8),
(2123,0,1),
(2124,0,2),
(2125,0,3),
(2126,0,6),
(2127,0,8),
(2128,0,9),
(2129,0,11),
(2130,0,1),
(2131,0,2),
(2132,0,3),
(2133,0,4),
(2134,0,5),
(2135,0,6),
(2136,0,7),
(2137,0,8),
(2138,0,9),
(2139,0,11),
(2140,0,12),
(2141,0,1),
(2142,0,2),
(2143,0,3),
(2144,0,4),
(2145,0,6),
(2146,0,1),
(2147,0,4),
(2148,0,5),
(2149,0,8),
(2150,0,2),
(2151,0,3),
(2152,0,4),
(2153,0,5),
(2154,0,7),
(2155,0,8),
(2156,0,9),
(2157,0,10),
(2158,0,11),
(2159,0,12),
(2160,0,1),
(2161,0,4),
(2162,0,6),
(2163,0,8),
(2164,0,9),
(2165,0,11),
(2166,0,3),
(2167,0,6),
(2168,0,7),
(2169,0,1),
(2170,0,2),
(2171,0,6),
(2172,0,12),
(2173,0,1),
(2174,0,3),
(2175,0,11);

INSERT INTO `kontragent_poslyga` VALUES 
(2176,0,1),
(2177,0,2),
(2178,0,3),
(2179,0,6),
(2180,0,12),
(2181,0,1),
(2182,0,2),
(2183,0,3),
(2184,0,6),
(2185,0,12),
(2186,0,2),
(2187,0,3),
(2188,0,6),
(2189,0,8),
(2190,0,12),
(2191,0,5),
(2192,0,8),
(2193,0,5),
(2194,0,8),
(2195,0,5),
(2196,0,8),
(2197,0,1),
(2198,0,3),
(2199,0,8),
(2200,0,2),
(2201,0,6),
(2202,0,9),
(2203,0,12),
(2204,0,3),
(2205,0,6),
(2206,0,11),
(2207,0,3),
(2208,0,6),
(2209,0,11),
(2210,0,1),
(2211,0,3),
(2212,0,5),
(2213,0,11),
(2214,0,12),
(2215,0,1),
(2216,0,3),
(2217,0,5),
(2218,0,8),
(2219,0,9),
(2220,0,11),
(2221,0,12),
(2222,0,1),
(2223,0,2),
(2224,0,3),
(2225,0,4),
(2226,0,5),
(2227,0,6),
(2228,0,7),
(2229,0,8),
(2230,0,9),
(2231,0,10),
(2232,0,11),
(2233,0,12),
(2234,0,1),
(2235,0,2),
(2236,0,6),
(2237,0,8),
(2238,0,11),
(2239,0,1),
(2240,0,2),
(2241,0,3),
(2242,0,4),
(2243,0,6),
(2244,0,7),
(2245,0,8),
(2246,0,9),
(2247,0,10),
(2248,0,11),
(2249,0,12),
(2250,0,2),
(2251,0,3),
(2252,0,4),
(2253,0,6),
(2254,0,7),
(2255,0,8),
(2256,0,9),
(2257,0,11),
(2258,0,12),
(2259,0,1),
(2260,0,1),
(2261,0,2),
(2262,0,2),
(2263,0,3),
(2264,0,3),
(2265,0,4),
(2266,0,4),
(2267,0,5),
(2268,0,5),
(2269,0,6),
(2270,0,6),
(2271,0,8),
(2272,0,8),
(2273,0,10),
(2274,0,10),
(2275,0,11),
(2276,0,11),
(2277,0,12),
(2278,0,12),
(2279,0,1),
(2280,0,2),
(2281,0,3),
(2282,0,4),
(2283,0,6),
(2284,0,7),
(2285,0,8),
(2286,0,9),
(2287,0,10),
(2288,0,11),
(2289,0,12),
(2290,0,1),
(2291,0,2),
(2292,0,3),
(2293,0,4),
(2294,0,6),
(2295,0,7),
(2296,0,8),
(2297,0,9),
(2298,0,10),
(2299,0,11),
(2300,0,12),
(2301,0,1),
(2302,0,2),
(2303,0,3),
(2304,0,6),
(2305,0,1),
(2306,0,2),
(2307,0,3),
(2308,0,4),
(2309,0,6),
(2310,0,7),
(2311,0,9),
(2312,0,10),
(2313,0,11),
(2314,0,12),
(2315,0,2),
(2316,0,3),
(2317,0,5),
(2318,0,9),
(2319,0,11),
(2320,0,1),
(2321,0,4),
(2322,0,7),
(2323,0,11),
(2324,0,1),
(2325,0,2),
(2326,0,4),
(2327,0,1),
(2328,0,2),
(2329,0,3),
(2330,0,4),
(2331,0,5),
(2332,0,6),
(2333,0,7),
(2334,0,8),
(2335,0,9),
(2336,0,10),
(2337,0,11),
(2338,0,12),
(2339,0,1),
(2340,0,2),
(2341,0,3),
(2342,0,4),
(2343,0,6),
(2344,0,7),
(2345,0,11),
(2346,0,12),
(2347,0,1),
(2348,0,2),
(2349,0,4),
(2350,0,6),
(2351,0,7),
(2352,0,8),
(2353,0,10),
(2354,0,11),
(2355,0,2),
(2356,0,3),
(2357,0,4),
(2358,0,5),
(2359,0,6),
(2360,0,7),
(2361,0,11),
(2362,0,12),
(2363,0,2),
(2364,0,3),
(2365,0,4),
(2366,0,5),
(2367,0,6),
(2368,0,7),
(2369,0,11),
(2370,0,12),
(2371,0,1),
(2372,0,2),
(2373,0,3),
(2374,0,4),
(2375,0,6),
(2376,0,7),
(2377,0,8),
(2378,0,9),
(2379,0,11),
(2380,0,12),
(2381,0,1),
(2382,0,5),
(2383,0,7),
(2384,0,8),
(2385,0,11),
(2386,0,12),
(2387,0,1),
(2388,0,4),
(2389,0,10),
(2390,0,1),
(2391,0,2),
(2392,0,3),
(2393,0,11),
(2394,0,1),
(2395,0,2),
(2396,0,3),
(2397,0,4),
(2398,0,6),
(2399,0,7),
(2400,0,9),
(2401,0,10),
(2402,0,11),
(2403,0,12),
(2404,0,1),
(2405,0,2),
(2406,0,4),
(2407,0,1),
(2408,0,2),
(2409,0,3),
(2410,0,4),
(2411,0,6),
(2412,0,7),
(2413,0,9),
(2414,0,11),
(2415,0,12),
(2416,0,1),
(2417,0,2),
(2418,0,4),
(2419,0,8),
(2420,0,10),
(2421,0,12),
(2422,0,1),
(2423,0,7),
(2424,0,1),
(2425,0,2),
(2426,0,4),
(2427,0,6),
(2428,0,7),
(2429,0,11),
(2430,0,12),
(2431,0,1),
(2432,0,5),
(2433,0,6),
(2434,0,11),
(2435,0,12),
(2436,0,1),
(2437,0,2),
(2438,0,3),
(2439,0,4),
(2440,0,6),
(2441,0,10),
(2442,0,11),
(2443,0,12),
(2444,0,1),
(2445,0,2),
(2446,0,3),
(2447,0,4),
(2448,0,6),
(2449,0,8),
(2450,0,10),
(2451,0,11),
(2452,0,1),
(2453,0,2),
(2454,0,3),
(2455,0,4),
(2456,0,6),
(2457,0,7),
(2458,0,8),
(2459,0,11),
(2460,0,12),
(2461,0,1),
(2462,0,2),
(2463,0,3),
(2464,0,4),
(2465,0,6),
(2466,0,8),
(2467,0,9),
(2468,0,11),
(2469,0,12),
(2470,0,1),
(2471,0,2),
(2472,0,3),
(2473,0,4),
(2474,0,6),
(2475,0,9),
(2476,0,11),
(2477,0,1),
(2478,0,8),
(2479,0,11),
(2480,0,1),
(2481,0,4),
(2482,0,6),
(2483,0,1),
(2484,0,2),
(2485,0,3),
(2486,0,6),
(2487,0,7),
(2488,0,11),
(2489,0,12),
(2490,0,1),
(2491,0,2),
(2492,0,3),
(2493,0,6),
(2494,0,7),
(2495,0,8),
(2496,0,9),
(2497,0,10),
(2498,0,11),
(2499,0,12),
(2500,0,1),
(2501,0,2),
(2502,0,3),
(2503,0,4),
(2504,0,8),
(2505,0,12),
(2506,0,1),
(2507,0,4),
(2508,0,6),
(2509,0,7),
(2510,0,8),
(2511,0,11),
(2512,0,12),
(2513,0,1),
(2514,0,4),
(2515,0,6),
(2516,0,7),
(2517,0,8),
(2518,0,11),
(2519,0,12),
(2520,0,1),
(2521,0,2),
(2522,0,3),
(2523,0,6),
(2524,0,7),
(2525,0,8),
(2526,0,9),
(2527,0,10),
(2528,0,11),
(2529,0,12),
(2530,0,1),
(2531,0,2),
(2532,0,3),
(2533,0,4),
(2534,0,6),
(2535,0,7),
(2536,0,8),
(2537,0,11),
(2538,0,1),
(2539,0,2),
(2540,0,3),
(2541,0,4),
(2542,0,8),
(2543,0,11),
(2544,0,1),
(2545,0,2),
(2546,0,3),
(2547,0,4),
(2548,0,6),
(2549,0,7),
(2550,0,8),
(2551,0,9),
(2552,0,10),
(2553,0,11),
(2554,0,12),
(2555,0,1),
(2556,0,2),
(2557,0,3),
(2558,0,4),
(2559,0,8),
(2560,0,1),
(2561,0,2),
(2562,0,3),
(2563,0,4),
(2564,0,6),
(2565,0,7),
(2566,0,8),
(2567,0,9),
(2568,0,10),
(2569,0,11),
(2570,0,12),
(2571,0,1),
(2572,0,2),
(2573,0,3),
(2574,0,4),
(2575,0,6),
(2576,0,7),
(2577,0,8),
(2578,0,9),
(2579,0,10),
(2580,0,11),
(2581,0,12),
(2582,0,1),
(2583,0,2),
(2584,0,3),
(2585,0,4),
(2586,0,5),
(2587,0,6),
(2588,0,7),
(2589,0,8),
(2590,0,10),
(2591,0,11),
(2592,0,12),
(2593,0,1),
(2594,0,2),
(2595,0,3),
(2596,0,4),
(2597,0,6),
(2598,0,7),
(2599,0,8),
(2600,0,9),
(2601,0,10),
(2602,0,11),
(2603,0,12),
(2604,0,1),
(2605,0,2),
(2606,0,3),
(2607,0,4),
(2608,0,6),
(2609,0,7),
(2610,0,8),
(2611,0,9),
(2612,0,10),
(2613,0,11),
(2614,0,12),
(2615,0,1),
(2616,0,2),
(2617,0,3),
(2618,0,4),
(2619,0,6),
(2620,0,7),
(2621,0,8),
(2622,0,9),
(2623,0,10),
(2624,0,11),
(2625,0,12),
(2626,0,1),
(2627,0,2),
(2628,0,3),
(2629,0,4),
(2630,0,5),
(2631,0,6),
(2632,0,7),
(2633,0,8),
(2634,0,10),
(2635,0,11),
(2636,0,12),
(2637,0,1),
(2638,0,2),
(2639,0,3),
(2640,0,6),
(2641,0,7),
(2642,0,8),
(2643,0,11),
(2644,0,12),
(2645,0,1),
(2646,0,2),
(2647,0,4),
(2648,0,8),
(2649,0,1),
(2650,0,6),
(2651,0,2),
(2652,0,3),
(2653,0,7),
(2654,0,8),
(2655,0,1),
(2656,0,4),
(2657,0,6),
(2658,0,11),
(2659,0,1),
(2660,0,2),
(2661,0,3),
(2662,0,4),
(2663,0,5),
(2664,0,6),
(2665,0,7),
(2666,0,8),
(2667,0,9),
(2668,0,10),
(2669,0,11),
(2670,0,12),
(2671,0,1),
(2672,0,2),
(2673,0,3),
(2674,0,5),
(2675,0,6);

INSERT INTO `kontragent_poslyga` VALUES 
(2676,0,1),
(2677,0,2),
(2678,0,3),
(2679,0,4),
(2680,0,5),
(2681,0,6),
(2682,0,7),
(2683,0,8),
(2684,0,9),
(2685,0,10),
(2686,0,11),
(2687,0,12),
(2688,0,1),
(2689,0,2),
(2690,0,4),
(2691,0,6),
(2692,0,11),
(2693,0,1),
(2694,0,2),
(2695,0,3),
(2696,0,4);

DROP TABLE IF EXISTS `kontragentu`;

CREATE TABLE `kontragentu` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `karta` smallint(4) unsigned zerofill DEFAULT NULL,
  `pib` varchar(40) DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `date_start` date DEFAULT NULL,
  `ViberUserId` varchar(32) DEFAULT NULL COMMENT 'id вайбера',
  `tel` bigint(12) unsigned DEFAULT NULL,
  `tel2` bigint(12) unsigned DEFAULT NULL,
  `password` int(10) unsigned NOT NULL COMMENT 'Пароль випадкове число довжиною 10 цифр',
  `sendMessages` enum('0','1') NOT NULL DEFAULT '1' COMMENT 'Чи слати повідомлення цьому клієнту',
  `sms_key` smallint(5) unsigned DEFAULT NULL,
  `client_missing` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `comment` varchar(100) NOT NULL,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `karta` (`karta`),
  UNIQUE KEY `tel` (`tel`)
) ENGINE=MyISAM AUTO_INCREMENT=7017 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Таблиця Клієнтів';

INSERT INTO `kontragentu` VALUES 
(1,0999,'Кулій Ірина Василівна','1994-05-24',NULL,NULL,380976080415,NULL,1905559077,'1',NULL,0,'','0'),
(2,0995,'Задиляк Світлана','1980-05-29',NULL,NULL,380661868976,NULL,2119887990,'1',NULL,0,'','0'),
(3,0993,'Залевська Альона Василіна','1995-01-22',NULL,NULL,NULL,NULL,2012028170,'1',NULL,0,'','0'),
(4,0991,'Макогін Н.А.','1996-12-17',NULL,NULL,NULL,NULL,1622113923,'1',NULL,0,'','0'),
(5,0989,'Федоришин Лілія Л.','1980-04-08',NULL,NULL,NULL,NULL,1345980199,'1',NULL,0,'','0'),
(6,0987,'Москаль Марія В.','1976-07-13',NULL,NULL,NULL,NULL,1360592128,'1',NULL,0,'','0'),
(7,0985,'Мельничук Оксана ','1985-04-11',NULL,NULL,380502076621,NULL,1667620890,'1',NULL,0,'','0'),
(8,0983,'Ізвєкова Оксана В.','1989-06-21',NULL,NULL,NULL,NULL,1531097317,'1',NULL,0,'','0'),
(9,0981,'Сенів Ольга ','1994-07-19',NULL,NULL,NULL,NULL,1655285953,'1',NULL,0,'','0'),
(10,0979,'Бубель Марія ','1997-06-17',NULL,NULL,380964295858,NULL,2038657211,'1',NULL,0,'','0'),
(11,0977,'Стухляк Наталя Й.','1993-10-11',NULL,NULL,NULL,NULL,2041211024,'1',NULL,0,'','0'),
(12,0975,'Хандашко Оксана Я.','1990-11-19',NULL,NULL,NULL,NULL,1467824407,'1',NULL,0,'','0'),
(13,0971,'Бойчук Анастасія Р.','0000-00-00',NULL,NULL,NULL,NULL,1825161477,'1',NULL,0,'','0'),
(14,0969,'Гриців Степанія Т.','1963-09-20',NULL,NULL,NULL,NULL,1423128147,'1',NULL,0,'','0'),
(15,0967,'Чорнявська Олена В. ','1999-01-31',NULL,'zlPjFwWxwjbnpz+z00GyiQ==',380663394447,NULL,1506428106,'1',NULL,0,'','0'),
(16,0965,'Дергачова Зоряна В.','1977-03-05',NULL,NULL,NULL,NULL,1268472268,'1',NULL,0,'','0'),
(17,0961,'Цитульська Анастасія ','1996-12-04',NULL,NULL,380987430448,NULL,1406106813,'1',NULL,0,'','0'),
(18,0959,'Павшок Оксана О.','1994-10-23',NULL,NULL,NULL,NULL,1552037269,'1',NULL,0,'','0'),
(19,0955,'Томчук Таня ','0000-00-00',NULL,NULL,380686812248,NULL,1202465966,'1',NULL,0,'','0'),
(20,0951,'Лотоцька Марія ','1985-03-23',NULL,NULL,NULL,NULL,2092195149,'1',NULL,0,'','0'),
(21,0949,'Каспрій Анастасія ','1995-12-20',NULL,NULL,380686120387,NULL,1636046760,'1',NULL,0,'','0'),
(22,0941,'Іванова Ірина','1996-07-27',NULL,NULL,NULL,NULL,1586418385,'1',NULL,1,'','1'),
(23,0940,'Геравс Галина ','1992-07-15',NULL,NULL,380976905414,NULL,1950775044,'1',NULL,1,'','0'),
(24,0930,'Лучко Вікторія ','1989-10-06',NULL,NULL,NULL,NULL,2127869286,'1',NULL,1,'','0'),
(25,0920,'Бойчук Оксана',NULL,NULL,NULL,380682170939,NULL,1319713970,'1',NULL,0,'','0'),
(26,0910,'Білевич  Галина ','1985-05-04',NULL,NULL,380672569402,NULL,2124965394,'1',NULL,0,'','0'),
(27,0900,'Тришак Галина ','1992-09-01',NULL,NULL,NULL,NULL,1843822506,'1',NULL,0,'','0'),
(28,0887,'Кулій Іванна','1976-05-09',NULL,NULL,NULL,NULL,1926299660,'1',NULL,0,'','0'),
(29,0883,'Цикрик Марія','1994-10-19',NULL,NULL,NULL,NULL,2046867818,'1',NULL,0,'','0'),
(30,0881,'Українець Н.','1992-04-27',NULL,NULL,NULL,NULL,1742865581,'1',NULL,0,'','0'),
(31,0879,'Кравець Оксана ','0000-00-00',NULL,'k4Nrt4PdhLmDek+Xdlq1nw==',380685871710,NULL,1579821610,'1',NULL,0,'','0'),
(32,0877,'Колівошко Ольга','1979-04-21',NULL,NULL,380971832812,NULL,2068866063,'1',NULL,0,'','0'),
(33,0873,'Улична Юлія ','1991-10-24',NULL,NULL,380976569373,NULL,1236817668,'1',NULL,0,'','0'),
(34,0871,'Завгородня Наталія','1969-04-22',NULL,NULL,380676883521,NULL,1452099060,'1',NULL,0,'','0'),
(35,0869,'Петрас Уляна','1983-07-29',NULL,NULL,NULL,NULL,1695085405,'1',NULL,0,'','0'),
(36,0867,'Харук Олександра','1978-08-13',NULL,NULL,NULL,NULL,1855654546,'1',NULL,0,'','1'),
(37,0863,'Боднар Юлія ','1993-11-14',NULL,NULL,380938244859,NULL,1745350480,'1',NULL,0,'','0'),
(38,0861,'Копій Тетяна ','1989-01-31',NULL,NULL,380984215515,NULL,1853236275,'1',NULL,0,'','0'),
(39,0859,'Гевко Оксана ','1987-03-22',NULL,NULL,380976113998,NULL,1674621568,'1',NULL,0,'','0'),
(40,0857,'Чубата Леся ','0000-00-00',NULL,NULL,NULL,NULL,1432415295,'1',NULL,0,'','0'),
(41,0853,'Романів Оксана','1977-11-30',NULL,NULL,NULL,NULL,1259027930,'1',NULL,0,'','0'),
(42,0851,'Слободян Галина ','1974-11-09',NULL,NULL,380684991570,NULL,1621121960,'1',NULL,0,'','0'),
(43,0849,'Боднар Анастасія',NULL,NULL,NULL,380680927170,NULL,1289120891,'1',NULL,0,'','0'),
(44,0847,'Дубчак М.','1997-09-20',NULL,NULL,NULL,NULL,1333192456,'1',NULL,0,'','0'),
(45,0843,'Жравська Юлія','1987-11-05',NULL,NULL,NULL,NULL,1979123219,'1',NULL,0,'','0'),
(46,0841,'Гой Юлія ','1992-06-10',NULL,NULL,NULL,NULL,1551844184,'1',NULL,0,'','0'),
(47,0839,'Лукасевич Вікторія','1986-11-23',NULL,NULL,380935823987,NULL,1511955426,'1',NULL,0,'','0'),
(48,0837,'Буяр Світлана ','1982-09-26',NULL,NULL,380936418844,NULL,1200595764,'1',NULL,0,'','0'),
(49,0947,'Худзік Юлія ','2000-01-22',NULL,NULL,380977121794,NULL,1546571404,'1',NULL,0,'','0'),
(50,0835,'Купіль Вікторія','1997-01-23',NULL,NULL,NULL,NULL,1211239856,'1',NULL,0,'','0'),
(51,0831,'Коземчук Марія','1994-09-10',NULL,NULL,NULL,NULL,1674138386,'1',NULL,0,'','0'),
(52,0829,'Коробій Вікторія ','1995-10-09',NULL,NULL,380505368912,NULL,1925606399,'1',NULL,0,'','0'),
(53,0827,'Лазецька Юлія ','1995-02-15',NULL,NULL,380986155911,NULL,2134234136,'1',NULL,0,'','0'),
(54,0825,'Повшок Світлана','1991-05-08',NULL,NULL,NULL,NULL,1531984613,'1',NULL,0,'','0'),
(55,0823,'Ягода Лідія ','1981-07-17',NULL,'PkNBmZqrCf33Dmq11ev1SQ==',380975958528,NULL,1946157994,'1',12625,0,'','0'),
(56,0821,'Огороднік Ірина ','1989-03-22',NULL,'qE2f68J+N5SkP81uvrx3tA==',380992075752,NULL,2120386066,'1',27961,1,'','0'),
(57,0819,'Гоменюк Андріна','1995-12-12',NULL,NULL,NULL,NULL,1287780571,'1',NULL,2,'','0'),
(58,0817,'Біленко Маряна','1972-12-12',NULL,NULL,NULL,NULL,2115828011,'1',NULL,0,'','0'),
(59,0815,'Романчук Вікторія','2000-04-08',NULL,NULL,380970094192,NULL,1717171822,'1',NULL,0,'','0'),
(60,0811,'Чапурда Наталія ','1987-05-17',NULL,NULL,NULL,NULL,1115528576,'1',NULL,0,'','0'),
(61,0809,'Козіцька Марія ','1995-10-15',NULL,NULL,NULL,NULL,2121289867,'1',NULL,0,'','0'),
(62,0807,'Коцур Світлана','1963-06-09',NULL,NULL,380955878389,NULL,1476080616,'1',NULL,0,'','0'),
(63,0805,'Буслер Надія','1964-10-18',NULL,'SjJjbgD6ARse/dXnVXfTRQ==',380976397056,NULL,1441885538,'1',40879,1,'','0'),
(64,0803,'Дідюк Ірина ','1988-03-26',NULL,NULL,380993417699,NULL,1469154165,'1',NULL,0,'','0'),
(65,0801,'Ткачик Ольга','1975-07-05',NULL,NULL,380679896129,NULL,1396226715,'1',NULL,0,'','0'),
(66,0799,'Журба Тетяна','1982-01-03',NULL,'u/PUVn2M0NUNCTHfeTnvwg==',380966455858,NULL,1819791406,'1',NULL,1,'','0'),
(67,0797,'Бойко Уляна ','1994-05-28',NULL,NULL,NULL,NULL,1670131680,'1',NULL,0,'','0'),
(68,0795,'Потикевич Вікторія ','1997-10-24',NULL,NULL,380987700751,NULL,1260675716,'1',36189,0,'','0'),
(69,0793,'Шикульська Світлана','1981-03-17',NULL,NULL,380975087995,NULL,1160621770,'1',NULL,1,'','0'),
(70,0789,'Новак  Наталя','1988-09-11',NULL,'EYPXFXPTZMipoU+ArDsE0g==',380979467948,NULL,1519778808,'1',NULL,0,'','0'),
(71,0787,'Антонюк Вікторія','1999-02-23',NULL,NULL,380686451702,NULL,1473570778,'1',NULL,0,'','0'),
(72,0785,'Харук Ліля','1998-06-11',NULL,'6nRx1jrFLAyCv6/ThWv2Yg==',380984610997,NULL,1533978277,'1',57181,0,'','0'),
(73,0783,'Довгань Надія','1983-11-27',NULL,NULL,380678369233,NULL,1654670921,'1',NULL,0,'','0'),
(74,0781,'Куриляк Зоряна','1987-06-12',NULL,NULL,380980092098,NULL,1826811257,'1',NULL,0,'','0'),
(75,0779,'Винник Наталія ','1986-05-08',NULL,NULL,NULL,NULL,1958894455,'1',NULL,0,'','0'),
(76,0777,'Сас Надія ','1977-07-05',NULL,NULL,NULL,NULL,1651972984,'1',NULL,0,'','0'),
(77,0775,'Даньо Марія ','1995-08-25',NULL,NULL,380967922085,NULL,1437917972,'1',NULL,0,'','0'),
(78,0771,'Дубрівна Ярослава','1997-02-08',NULL,NULL,NULL,NULL,1532426952,'1',NULL,0,'','0'),
(79,0769,' Задорожня Таня','1994-09-14',NULL,'00ug9I0tRHWMX/CV2Zvo6A==',380982365130,NULL,1894312611,'1',17821,0,'','0'),
(80,0767,'Кравчук Ольга','1988-12-01',NULL,NULL,380672886119,NULL,1434464955,'1',NULL,0,'','0'),
(81,0765,'Гоменюк Ірина','1977-04-12',NULL,'4D0rkw4z5Xrngqfp+3np1A==',380972644800,NULL,2138075873,'1',NULL,1,'','0'),
(82,0763,'Луців Наталія','1991-10-11',NULL,NULL,380979015986,NULL,1917913927,'1',NULL,0,'','0'),
(83,0761,'Бегман Вероніка','1995-10-23',NULL,NULL,NULL,NULL,1940295826,'1',NULL,0,'','0'),
(84,0759,'Калакайло Анастасія','1998-04-04',NULL,NULL,380637951563,NULL,1201689955,'1',NULL,0,'','0'),
(85,0757,'Погорецька Ірина','1996-04-13',NULL,NULL,NULL,NULL,1374959599,'1',NULL,0,'','0'),
(86,0755,'Пундій Ганна','1992-12-13',NULL,NULL,NULL,NULL,1575391237,'1',NULL,1,'','0'),
(87,0751,'Дроболюк Ольга','1958-10-16',NULL,NULL,380988956460,NULL,1762507191,'1',NULL,0,'','0'),
(88,0750,'Голіната Ганна','1967-10-24',NULL,NULL,NULL,NULL,2116711169,'1',NULL,0,'','0'),
(89,0748,'Ізввикова Ірина','1989-08-16',NULL,NULL,NULL,NULL,1803071104,'1',NULL,0,'','0'),
(90,0740,'Сеник Олена','1981-12-31',NULL,'yodak0bsRVn9YTTorM/9aQ==',380502349331,NULL,1835636330,'1',61192,0,'','0'),
(91,0738,'Гамбаль Тетяна ','1983-08-02',NULL,NULL,380987098537,NULL,1592119195,'1',NULL,0,'','0'),
(92,0736,'Махмутова Лілія','1982-10-07',NULL,NULL,NULL,NULL,1616061375,'1',NULL,0,'','0'),
(93,0732,'Загайкевич Катерина','0000-00-00',NULL,NULL,380680133338,NULL,2069264805,'1',NULL,0,'','0'),
(94,0730,'Ганкевич Світлана','1965-02-05',NULL,NULL,NULL,NULL,1972104260,'1',NULL,0,'','0'),
(95,0728,'Брезіна Тетяна','1995-03-06',NULL,NULL,NULL,NULL,1205902673,'1',NULL,0,'','0'),
(96,0726,'Козак Людмила','1984-03-14',NULL,'q1S1IpnKN+2ZLG7tb2VhfQ==',380987999146,NULL,1872772578,'1',NULL,0,'','0'),
(97,0722,'Цаплан Любов','1994-03-08',NULL,NULL,NULL,NULL,1113856926,'1',NULL,0,'','0'),
(98,0720,'Парасимчук Світлана','1996-10-06',NULL,NULL,NULL,NULL,1593382131,'1',NULL,0,'','0'),
(99,0718,'Лесюк Василина','1998-01-14',NULL,NULL,380992790147,NULL,1325785089,'1',NULL,0,'','0'),
(100,0716,'Скорогабач Наталя','1991-06-02',NULL,NULL,380989379711,NULL,2068684613,'1',NULL,0,'','0'),
(101,0712,'Скобальська Христина','1996-07-12',NULL,NULL,380683365391,NULL,1340095596,'1',NULL,0,'','0'),
(102,0710,'Мельник В.','1997-02-25',NULL,NULL,NULL,NULL,1903571584,'1',NULL,0,'','0'),
(103,0708,'Стадник Таїсія','1998-10-31',NULL,NULL,NULL,NULL,1798819809,'1',NULL,0,'','0'),
(104,0706,'Самсон Лєна','1981-06-21',NULL,NULL,380975156313,NULL,2101751319,'1',41653,0,'','0'),
(105,0702,'Сулима Марія','1980-05-31',NULL,NULL,380687705684,NULL,1644601605,'1',NULL,0,'','0'),
(106,0700,'Федорчук Ольга ','0000-00-00',NULL,NULL,380961246838,NULL,1865454852,'1',NULL,0,'','0'),
(107,0698,'Ліпунова Тетяна','1988-08-12',NULL,NULL,380678762678,NULL,1245967102,'1',NULL,0,'','0'),
(108,0696,'Козак Ірина','2002-04-26',NULL,NULL,NULL,NULL,1781831281,'1',NULL,0,'','0'),
(109,0692,'Матвієвич Юлія','1990-06-20',NULL,NULL,NULL,NULL,1688967036,'1',NULL,0,'','0'),
(110,0690,'Боднарчук Ярослав','1984-07-29',NULL,NULL,NULL,NULL,1623981771,'1',NULL,0,'','0'),
(111,0688,'Семанчук Вікторія','1996-02-07',NULL,NULL,380679989757,NULL,1958524661,'1',NULL,0,'','0'),
(112,0686,'Жовковська  Тетяна','1968-08-09',NULL,NULL,380973419218,NULL,1180662606,'1',NULL,2,'','0'),
(113,0684,'Самсон Юлія ','1993-09-18',NULL,NULL,NULL,NULL,1706840106,'1',NULL,0,'','0'),
(114,0682,'Туркіць Ольга','1982-07-30',NULL,NULL,NULL,NULL,1872629287,'1',NULL,1,'','0'),
(115,0680,'Старик Ірина','0000-00-00',NULL,NULL,380991571671,NULL,1932835358,'1',NULL,0,'','0'),
(116,0678,'Григорєва Андріана ','1993-06-02',NULL,NULL,380960538225,NULL,2078335834,'1',NULL,0,'','0'),
(117,0676,'Війтюк Софія','1999-07-25',NULL,NULL,NULL,NULL,1591564878,'1',NULL,0,'','0'),
(118,0672,'Сушельницька Людмила','1980-09-20',NULL,NULL,NULL,NULL,1264181421,'1',NULL,0,'','0'),
(119,0670,'Бурка Христина','1992-10-30',NULL,NULL,380680472887,NULL,2003216925,'1',NULL,2,'','0'),
(120,0668,'Перців Ганна','1989-11-24',NULL,NULL,NULL,NULL,1737678897,'1',NULL,0,'','0'),
(121,0666,'Білецька Леся ','1999-01-15',NULL,NULL,NULL,NULL,1304454412,'1',NULL,0,'','0'),
(122,0644,'Шарган Ірина','1987-10-03',NULL,NULL,380680596727,NULL,1697910827,'1',NULL,0,'','0'),
(123,0662,'Архіпова Наталя','1964-09-16',NULL,NULL,380979107030,NULL,1196117678,'1',NULL,0,'','0'),
(124,0660,'Софія Чвіль','1998-01-04',NULL,NULL,380979721233,NULL,1231172521,'1',18092,0,'','0'),
(125,0658,'Половчук Наталя','1969-03-14',NULL,'k86bP5s8N4lcHk5S/dftrw==',380673513288,NULL,1327876400,'1',43987,0,'','0'),
(126,0656,'Казьмір Наталька (мама)','1979-05-13',NULL,NULL,380681761087,NULL,1786244628,'0',NULL,0,'','0'),
(127,0654,'Хамчук Ольга','1897-08-21',NULL,NULL,NULL,NULL,2044953603,'1',NULL,0,'','0'),
(128,0652,'Габура Зоряна','1998-11-25',NULL,NULL,380671153000,NULL,1754994138,'1',NULL,0,'','0'),
(129,0650,'Подолянська М.','1996-05-01',NULL,NULL,NULL,NULL,1838314442,'1',NULL,0,'','0'),
(130,0648,'Дідик Ліля','1988-06-27',NULL,NULL,380967864909,NULL,1420573800,'1',NULL,0,'','0'),
(131,0646,'Возьна Вікторія','1992-08-18',NULL,NULL,NULL,NULL,1748800706,'1',NULL,0,'','0'),
(132,0642,'Данилишин Галина',NULL,NULL,'Rv7i6CQi1kxYyFHEovU0Jg==',380979728611,NULL,1230021161,'1',NULL,0,'','0'),
(133,0640,'Ткачук Ірина','0000-00-00',NULL,NULL,380973402850,NULL,2117632544,'1',NULL,0,'','0'),
(134,0638,'Білевич Тетяна','1973-11-13',NULL,NULL,NULL,NULL,1747374075,'1',NULL,0,'','0'),
(135,0630,'Мурашка Ірина','1991-01-01',NULL,NULL,NULL,NULL,1966581868,'1',NULL,0,'','0'),
(136,0628,'Ковбаснюк Анастасія','1988-09-20',NULL,NULL,NULL,NULL,1832128090,'1',NULL,0,'','0'),
(137,0620,'Петрів Ірина','1991-01-10',NULL,NULL,380680245580,NULL,1956249112,'1',NULL,0,'','0'),
(138,0618,'Музика Олена','1994-12-02',NULL,NULL,NULL,NULL,2023390418,'1',NULL,0,'','0'),
(139,0610,'Захарчук Світлана','1975-05-22',NULL,'3h/sbV100UqZ13SbTLbX6w==',380661242551,NULL,1922729853,'1',NULL,0,'','0'),
(140,0608,'Найдух Христина','1998-02-10',NULL,NULL,380979866683,NULL,2077074624,'1',NULL,0,'','0'),
(141,0600,'Воротняк Уляна','1996-03-23',NULL,NULL,380683448976,NULL,1577692406,'1',NULL,0,'','0'),
(142,0598,'Іванищук Ю.','1994-03-08',NULL,NULL,NULL,NULL,1333371566,'1',NULL,0,'','0'),
(143,0590,'Бажовська Соломія',NULL,NULL,'6Dzk759OS2ruHI8Ofm6Sdw==',380986484399,NULL,1453996934,'1',50818,0,'','0'),
(144,0588,'Штиник Галина','1986-07-13',NULL,NULL,380687591048,NULL,1470305893,'1',NULL,0,'','0'),
(145,0580,'Панчук Ірина','1993-06-11',NULL,NULL,380978310227,NULL,2007152791,'',12227,0,'','0'),
(146,0578,'Полівчук Оксана','1995-07-10',NULL,NULL,380983663469,NULL,1602007827,'1',NULL,1,'','0'),
(147,0570,'Данилишин Наталя','1988-03-11',NULL,NULL,380675544069,NULL,1129886140,'1',NULL,0,'','0'),
(148,0568,'Дячик Надія','1967-04-12',NULL,NULL,380969686571,NULL,1530433395,'1',NULL,1,'','0'),
(149,0560,'Николяк Тетяна ','1978-09-14',NULL,NULL,380978933767,NULL,1527359249,'1',NULL,0,'','0'),
(150,0558,'Колівошко Наталя','1983-04-29',NULL,NULL,380964533135,NULL,1746429674,'1',NULL,0,'','0'),
(151,0550,'Петрик Галина','1965-06-23',NULL,'JvkYf6GFry6ueLAv9iJUcQ==',380678023451,NULL,1960603798,'1',NULL,0,'','0'),
(152,0548,'Сліпцова Зоряна','1999-04-29',NULL,NULL,380970584322,NULL,1811783821,'1',NULL,0,'','0'),
(153,0540,'Білевич Наталя','1944-02-20',NULL,NULL,380686242882,NULL,1649626221,'1',NULL,0,'','0'),
(154,0538,'Балінська Любов','1991-11-14',NULL,NULL,NULL,NULL,1263030910,'1',NULL,0,'','0'),
(155,0530,'Кошута Тетяна','1991-10-23',NULL,NULL,NULL,NULL,1387086201,'1',NULL,0,'','0'),
(156,0528,'Качаровська Яна ','1996-01-15',NULL,NULL,NULL,NULL,1599075284,'1',NULL,0,'','0'),
(157,0520,'Липа Марія','1967-02-20',NULL,NULL,380673516764,NULL,1366406344,'1',NULL,1,'','0'),
(158,0518,'Ванай Зоряна','1990-05-20',NULL,NULL,NULL,NULL,1763235419,'1',NULL,0,'','0'),
(159,0510,'Нагаєвська Наталія','1992-10-17',NULL,NULL,NULL,NULL,1941656940,'1',NULL,0,'','0'),
(160,0508,'Шимків Наталія','1997-12-25',NULL,NULL,380936802828,NULL,1753414052,'1',NULL,0,'','0'),
(161,0496,'Гураль Марія','0000-00-00',NULL,NULL,380963223163,NULL,1654000731,'1',NULL,0,'','0'),
(162,0486,'Олійник Інна','1993-05-18',NULL,NULL,380987032412,NULL,1621480713,'1',NULL,0,'','0'),
(163,0476,'Хмелик Аліна',NULL,NULL,NULL,380979014508,NULL,1664287729,'1',52056,0,'','0'),
(164,0466,'Якимець Христина','1991-12-31',NULL,NULL,NULL,NULL,1186615397,'1',NULL,0,'','0'),
(165,0456,'Когут Юлія','1997-05-04',NULL,NULL,380686510978,NULL,1599981016,'1',NULL,0,'','0'),
(166,0446,'Кульчицька Т.','1978-09-02',NULL,NULL,NULL,NULL,1306184039,'1',NULL,0,'','0'),
(167,0436,'Ушій Віта','1991-08-02',NULL,'BBgh6vssn4638ON6k2dd+w==',380986023603,NULL,1714423037,'1',25322,0,'','0'),
(168,0426,'Махневич Зоряна','1992-10-31',NULL,NULL,NULL,NULL,2052262526,'1',NULL,0,'','1'),
(169,0416,'Чубак Діана','1997-12-12',NULL,NULL,NULL,NULL,1709527804,'1',NULL,0,'','0'),
(170,0406,'Дідюк Анжеліна','2016-04-22',NULL,NULL,NULL,NULL,1718298468,'1',NULL,0,'','0'),
(171,0396,'Янч Соломія','1995-11-08',NULL,NULL,NULL,NULL,1895081273,'1',NULL,0,'','0'),
(172,0386,'Куриляк Христина','1992-06-13',NULL,NULL,NULL,NULL,2031031455,'1',NULL,0,'','0'),
(173,0376,'Дерій Олена','1997-01-12',NULL,NULL,NULL,NULL,1673913652,'1',NULL,0,'','0'),
(174,0366,'Рудніцька Юлія ','1996-08-05',NULL,NULL,NULL,NULL,1887997408,'1',NULL,0,'','0'),
(175,0356,'Юркевич Галина','1969-02-22',NULL,NULL,380968190020,NULL,1208014392,'1',NULL,0,'','0'),
(176,0350,'Горбаль Марія','1985-09-20',NULL,NULL,NULL,NULL,1239161006,'1',NULL,0,'','0'),
(177,0348,'Наконечна Оксана ','1986-01-29',NULL,NULL,380673855054,NULL,1834311472,'1',NULL,0,'','0'),
(178,0346,'Манорик Галина','1982-09-08',NULL,NULL,380958757600,NULL,1199629661,'1',NULL,0,'','0'),
(179,0344,'Безпалько Олена','1993-09-17',NULL,NULL,NULL,NULL,1549740492,'1',NULL,0,'','0'),
(180,0342,'Черник Галина','1999-04-09',NULL,NULL,NULL,NULL,1902077746,'1',NULL,0,'','0'),
(181,0997,'Ліщинська Галина','1974-08-13',NULL,NULL,NULL,NULL,1769843378,'1',NULL,0,'','0'),
(182,0340,'Чорній Маряна','1991-01-16',NULL,NULL,NULL,NULL,1603260082,'1',NULL,0,'','0'),
(183,0338,'Задорожна Оля','1968-02-16',NULL,NULL,380973221436,NULL,1941552739,'1',NULL,1,'','0'),
(184,0336,'Старовойт Юля','1997-02-28',NULL,NULL,NULL,NULL,1617338228,'1',NULL,0,'','0'),
(185,0334,'Похила Марія','1990-09-09',NULL,NULL,380670515711,NULL,1316905770,'1',NULL,0,'','0'),
(186,0332,'Маціборко З.','1985-05-24',NULL,NULL,NULL,NULL,1609618122,'1',NULL,0,'','0'),
(187,0330,'Огороднік Людмила','1960-02-23',NULL,'L4r49/shr5CW+dJ0iJp2gA==',380974382146,NULL,1492622460,'1',NULL,0,'','0'),
(188,0328,'Наталія Колиндяни','1981-05-07',NULL,'w2mXki9pZpU6Txi/VHhc6w==',380983519996,NULL,1455650926,'1',47879,0,'','0'),
(189,0326,'Гайова Василина','1995-01-14',NULL,NULL,NULL,NULL,2130752326,'1',NULL,0,'','0'),
(190,0324,'Гевко любомира','1991-12-10',NULL,NULL,380503773737,NULL,1357208179,'1',NULL,0,'','0'),
(191,0322,'Прейзнер Світлана ','1980-05-27',NULL,'Tn0lR6J82j+wiMVJzfPKIA==',380683551320,NULL,2091594951,'1',NULL,1,'','0'),
(192,0320,'Галінаускас Ірина ','1995-01-14',NULL,NULL,NULL,NULL,1222837007,'1',NULL,0,'','0'),
(193,0318,'Свергун Маряна','1992-02-16',NULL,NULL,380976361664,NULL,1736700790,'1',NULL,0,'','0'),
(194,0316,'Басараба Юлія','1999-05-20',NULL,NULL,NULL,NULL,1380303765,'1',NULL,0,'','0'),
(195,0314,'Лівінська Наталя','1990-09-09',NULL,NULL,NULL,NULL,1846571393,'1',NULL,0,'','0'),
(196,0312,'Задорожна Юлія','1990-04-05',NULL,NULL,380980903531,NULL,1820039662,'1',NULL,0,'','0'),
(197,0310,'Дерій Наталія','0000-00-00',NULL,NULL,NULL,NULL,1436742699,'1',NULL,0,'','0'),
(198,0308,'Оксана Григорівна','1974-12-07',NULL,NULL,380984328251,NULL,1915284760,'1',NULL,0,'','0'),
(199,0306,'Мельник Аліна ','1987-11-27',NULL,NULL,NULL,NULL,1615559826,'1',NULL,0,'','0'),
(200,0304,'Тиндик Світлана','0989-04-14',NULL,NULL,NULL,NULL,2133198714,'1',NULL,0,'','0'),
(201,0302,'Тронт Марія','1999-10-13',NULL,NULL,380961608673,NULL,1255610414,'1',NULL,0,'','0'),
(202,0300,'Марущак Христина','1994-08-21',NULL,'ha1rIRzc+zUYgeWKh6VzYw==',380678685313,NULL,1996463648,'1',55081,1,'','0'),
(203,0298,'Єрастова Юлія','1995-02-22',NULL,NULL,380667837108,NULL,1125538521,'1',NULL,0,'','0'),
(204,0296,'Боднар Наталя',NULL,NULL,NULL,380673402735,NULL,1117440918,'1',NULL,0,'','0'),
(205,0292,'Горичак Наталія','1989-11-09',NULL,NULL,NULL,NULL,1472668473,'1',NULL,0,'','0'),
(206,0290,'Кулій Надія','1971-07-27',NULL,NULL,NULL,NULL,1271869686,'1',NULL,0,'','0'),
(207,0288,'Стадніченко Маряна','1992-09-05',NULL,NULL,NULL,NULL,1582913993,'1',NULL,0,'','0'),
(208,0286,'Борисюк Ірина','1997-11-10',NULL,NULL,NULL,NULL,1750317332,'1',NULL,0,'','0'),
(209,0282,'Харченко Наталя','1996-09-14',NULL,NULL,380966968876,NULL,1226446077,'1',NULL,0,'','0'),
(210,0280,'Бабюк Тетяна','1944-12-30',NULL,NULL,NULL,NULL,2086842292,'1',NULL,0,'','0'),
(211,0278,'Курчак Яна','1991-03-18',NULL,NULL,NULL,NULL,1555416916,'1',NULL,0,'','0'),
(212,0276,'Петрило Наталя','1977-12-17',NULL,NULL,380959223304,NULL,1719308920,'1',NULL,0,'','0'),
(213,0272,'Федорчук Настя','1996-10-28',NULL,NULL,NULL,NULL,1389538389,'1',NULL,0,'','0'),
(214,0270,'Полева Надія','1993-04-14',NULL,NULL,NULL,380969543861,1141641495,'1',NULL,1,'','0'),
(215,0268,'Мендер Яна','1996-07-07',NULL,NULL,380682394757,NULL,1348418490,'1',NULL,0,'','0'),
(216,0266,'Буріняк Маргарита','2002-05-23',NULL,NULL,NULL,NULL,1385598065,'1',NULL,0,'','0'),
(217,0262,'Сулима Світлана','1982-10-14',NULL,NULL,380968981325,NULL,2016577114,'1',61653,0,'','0'),
(218,0260,'Когут Тетяна','1996-09-25',NULL,NULL,NULL,NULL,1883259784,'1',NULL,0,'','0'),
(219,0258,'Шевчик Роксолана ','1997-04-24',NULL,NULL,NULL,NULL,2036047585,'1',NULL,0,'','0'),
(220,0256,'Ландяк Ірина','1992-04-29',NULL,NULL,NULL,NULL,1493557369,'1',NULL,0,'','0'),
(221,0254,'Горох Євгенія','1994-05-16',NULL,NULL,NULL,NULL,1390992647,'1',NULL,0,'','0'),
(222,0252,'Зигмундівна','1967-08-13',NULL,'uCoYvDmSDAB5v23gHzd97w==',380983285401,NULL,2034686732,'1',NULL,0,'','0'),
(223,0046,'Ковальчук Оксана','1991-06-08',NULL,NULL,380987313551,NULL,1862601281,'1',NULL,0,'','0'),
(224,0036,'Шаровська Ірина','1979-11-18',NULL,'XI4eaKgnbSwFQBYa7GqNhg==',380974769440,NULL,1644567196,'1',57490,0,'','0'),
(225,0026,'Колодій Оксана','1997-03-30',NULL,NULL,NULL,NULL,1559395860,'1',NULL,0,'','0'),
(226,0016,'Андрухів Оксана','1991-05-20',NULL,NULL,NULL,NULL,1260273950,'1',NULL,1,'','0'),
(227,0012,'Чмола Наталя','0000-00-00',NULL,NULL,380686017463,NULL,2117900622,'1',NULL,0,'','0'),
(228,0006,'Івасів Ірина','1995-05-08',NULL,NULL,NULL,NULL,1743926606,'1',NULL,0,'','0'),
(229,0002,'Дзюба Катерина','1997-04-08',NULL,NULL,380976158748,NULL,1719787355,'1',NULL,0,'','0'),
(230,0957,'Сороківська Уляна','1964-07-26',NULL,NULL,380686987792,NULL,1211387163,'1',NULL,0,'','0'),
(231,0885,'Ковганич Ірина','1990-12-16',NULL,'QhmLCsaTPEQMDz8hzhDK2Q==',380684182991,NULL,1950991541,'1',NULL,0,'','0'),
(232,0664,'Чир Юля',NULL,NULL,NULL,380979351620,NULL,1623416161,'1',NULL,0,'','0'),
(233,0482,'Кифчук Христина Орестівна','1992-06-27',NULL,'+vi5iiCMvKK66YmEJiCtig==',380971292031,NULL,1711205591,'1',17457,0,'','0'),
(234,0022,'Колотіліна Марія','1977-06-11',NULL,NULL,380976117207,NULL,1521517926,'1',NULL,0,'','0'),
(235,0042,'Фик Оксана','1995-03-16',NULL,NULL,NULL,NULL,1725879753,'1',NULL,0,'','0'),
(236,0032,'Мерецька Надія','1971-07-13',NULL,NULL,NULL,NULL,1313323633,'1',NULL,0,'','0'),
(237,0813,'Шедіва Оксана ','1975-01-28',NULL,NULL,380965600800,NULL,1573541701,'1',NULL,0,'','0'),
(238,0833,'Богдан Людмила','1982-05-07',NULL,NULL,NULL,NULL,1180022880,'1',NULL,0,'','0'),
(239,0889,'МАксимчук Таня','1971-06-16',NULL,NULL,380960390049,NULL,1893195872,'1',NULL,0,'','0'),
(240,0953,'Червона Юлія Олегівна','1999-07-21',NULL,NULL,380979550502,NULL,2020445487,'1',NULL,0,'','0'),
(241,0943,'Легка Ольга','1998-08-08',NULL,NULL,38684202309,NULL,1514451748,'1',NULL,0,'','0'),
(242,0963,'Базюк Христина ','0000-00-00',NULL,NULL,380972305110,NULL,1405254823,'1',NULL,0,'','0'),
(243,0773,'Штойко Ірина','1991-05-09',NULL,NULL,380937573217,NULL,1248442646,'1',NULL,0,'','0'),
(244,0973,'Данильчишин Світлана','1995-03-23',NULL,NULL,380976463718,NULL,2106714404,'1',NULL,0,'','0'),
(245,0753,'Опир Ольга','1993-11-04',NULL,NULL,380680063328,NULL,1873694867,'1',NULL,0,'','0'),
(246,0945,'Гура Христина','1996-01-17',NULL,NULL,380978415511,NULL,1938822008,'1',NULL,0,'','0'),
(247,0704,'Дунець Ірина','1978-01-01',NULL,NULL,NULL,380966793866,1811495868,'1',NULL,0,'','0'),
(248,0694,'Петрас Ольга','1992-04-14',NULL,'xOY/qPDjTAr/Ke51tvInYw==',380984502250,NULL,1340647210,'1',NULL,0,'','0'),
(249,0714,'Винник Ліля','1995-10-26',NULL,NULL,380683163756,NULL,1260473670,'1',NULL,0,'','0'),
(250,0734,'Хмелик Леся Ігорівна','1983-03-03',NULL,'kUAcNoY8dOdGe1+M2egbCQ==',380679481363,NULL,1298642937,'1',18175,0,'','0'),
(251,0724,'Кобзар Валерія','1996-05-15',NULL,NULL,380966051824,NULL,1833108962,'1',NULL,0,'','0'),
(252,0294,'Граблюк Оксана','0000-00-00',NULL,NULL,380684254599,NULL,1587912290,'1',NULL,0,'','0'),
(253,0274,'Богатинська Тетяна','1995-10-12',NULL,NULL,380684248299,NULL,1925337435,'1',NULL,0,'','0'),
(254,0284,'Кай Таня','1996-03-27',NULL,NULL,380987140034,NULL,1523877081,'1',NULL,0,'','0'),
(255,0865,'Глова Юля Юріївна','0000-00-00',NULL,NULL,380684231712,NULL,1774929896,'1',NULL,0,'','0'),
(256,0264,'Лукачина Любов Ярославівна','1976-09-16',NULL,NULL,380684231713,NULL,1914865954,'1',NULL,0,'','0'),
(257,0916,'секундяк Оксана','1993-09-15','2016-09-20',NULL,380680454107,NULL,1972128894,'1',NULL,0,'','0'),
(258,0906,'Чупіль Наталя','1989-04-16',NULL,NULL,380999093960,NULL,2055367454,'1',NULL,0,'','0'),
(259,0896,'Бутриновська Оля','1994-04-20',NULL,NULL,380632259452,NULL,1296752706,'1',NULL,0,'','0'),
(260,0000,'','0000-00-00','0000-00-00',NULL,38,38,1725921279,'1',NULL,0,'','1'),
(261,0536,'Костів Оксана Ярославівна','1990-06-25',NULL,NULL,380977748748,NULL,1839168103,'1',NULL,0,'','0'),
(262,0526,'Павшок Оксана Степанівна','1993-02-14',NULL,NULL,380978303074,NULL,1891264200,'1',NULL,0,'','0'),
(263,0452,'Дмитряк Люда','1985-03-30',NULL,NULL,380959328785,NULL,1271110838,'1',NULL,0,'','0'),
(264,0606,'Король Ірина ','1987-04-05',NULL,NULL,380966455047,NULL,1346156262,'1',NULL,0,'','0'),
(265,0936,'Сорока Світлана','1985-11-10',NULL,'SY5ph7XHyPk7nfTw6vf3AA==',380966415350,NULL,2132041065,'1',17464,0,'','0'),
(266,0592,'Бойчук Оля','1994-02-27',NULL,NULL,380989551776,NULL,1461565767,'1',NULL,0,'','0'),
(267,0632,'Турчин Таня','1993-02-24',NULL,NULL,380635619263,NULL,1870494034,'1',NULL,0,'','0'),
(268,0512,'Макарчук Наталя','1979-10-06',NULL,NULL,380972264420,NULL,2004988847,'1',NULL,0,'','0'),
(269,0622,'Огороднік Таня','1983-11-04',NULL,NULL,380678111276,NULL,1259654809,'1',NULL,0,'','0'),
(270,0612,'Бодьо Людмила','1996-12-10',NULL,NULL,380686258073,NULL,1165955655,'1',NULL,0,'','0'),
(271,0516,'Бранецька Ілона','1999-09-19',NULL,NULL,380660678279,NULL,1623621082,'1',NULL,0,'','0'),
(272,0926,'Карвацька Ульяна','1995-12-14',NULL,NULL,380979883642,NULL,1658302739,'1',NULL,0,'','0'),
(273,0855,'Мацишин Тетяна','1995-08-04',NULL,NULL,380986475190,NULL,1297939938,'1',NULL,0,'','0'),
(274,0845,'Ряба Ірина','1998-06-12',NULL,NULL,380687502345,NULL,1530635193,'1',NULL,0,'','0'),
(275,0674,'Різник Ніна','0000-00-00',NULL,NULL,380686965931,NULL,2049912079,'1',NULL,0,'','0'),
(276,0914,'Ванджура Таня','1993-10-28',NULL,NULL,NULL,NULL,1762833473,'1',NULL,0,'','0'),
(277,0904,'Смеречинська Ліля ','1992-04-09',NULL,NULL,380687502323,NULL,1882472400,'1',NULL,0,'','0'),
(278,0894,'Піць Вікторія','0000-00-00',NULL,NULL,380966664871,NULL,1386599131,'1',NULL,0,'','0'),
(279,0556,'Завійська Аліна','1996-07-31',NULL,NULL,380984096186,NULL,1943352356,'1',NULL,0,'','0'),
(280,0602,'Котелевич Інна ','1972-05-01',NULL,NULL,380667837114,NULL,1582171141,'1',NULL,0,'','0'),
(281,0506,'Галянт Оксана','1992-06-24',NULL,NULL,380970642713,NULL,1670225862,'1',NULL,0,'','0'),
(282,0746,'Кінзерська Світлана ','1991-11-28',NULL,NULL,380688426252,NULL,1842883157,'1',NULL,0,'','0'),
(283,0636,'Мардаль Марія','1966-05-30',NULL,NULL,380963539803,NULL,1911393535,'1',NULL,0,'','0'),
(284,0586,'Батенчук Галина ','1972-07-06',NULL,NULL,380681604641,NULL,1503918290,'1',NULL,0,'','0'),
(285,0576,'Пшик Інна ','2001-07-12',NULL,NULL,380972908779,NULL,1116510293,'1',NULL,0,'','0'),
(286,0566,'Віцентович Аня','1993-05-23',NULL,NULL,380968210657,NULL,2102957512,'1',NULL,0,'','0'),
(287,0626,'Бабіч Тетяна','1991-03-14',NULL,NULL,380978049984,NULL,1342274817,'1',NULL,0,'','0'),
(288,0924,'Чепига Марія','1993-12-03',NULL,NULL,380686465071,NULL,1380557247,'1',NULL,0,'','0'),
(289,0546,'Кравчук Галя','1988-12-04',NULL,NULL,380976713520,NULL,1518382324,'1',NULL,0,'','0'),
(290,0616,'Пельвецька Іра','1989-10-28',NULL,NULL,380987275141,NULL,1396574690,'1',NULL,0,'','0'),
(291,0596,'Задорожна Аліна','1986-04-05',NULL,'1AFvCNmVS0Sin+BvK3SnkQ==',380936473842,NULL,1286542337,'1',NULL,0,'','0'),
(292,0402,'Козубенко Юля','1988-03-19',NULL,NULL,380971939787,NULL,1161825417,'1',NULL,0,'','0'),
(293,0938,'Заруба Ірина','1994-09-16',NULL,NULL,380680900345,NULL,1611002940,'1',NULL,0,'','0'),
(294,0442,'Слободян Уляна','1997-06-14',NULL,'oLcseTRfEexlTnReSxdWoA==',380678702707,NULL,1453038863,'1',40258,0,'','0'),
(295,0412,'Підсадна Маряна','1991-08-18',NULL,NULL,380977205420,NULL,1210557718,'1',NULL,0,'','0'),
(296,0422,'Гаворчак Лариса ','1979-01-20',NULL,NULL,380964660240,NULL,1575980467,'1',NULL,0,'','0'),
(297,0382,'Марущак Світлана','1982-03-05',NULL,NULL,380686466462,NULL,1651143786,'1',NULL,0,'','0'),
(298,3552,'Томунь Анастасія','1995-06-18',NULL,NULL,380979681257,NULL,1496066485,'1',45531,0,'','0'),
(299,0044,'Бровко Віка','1986-10-29',NULL,NULL,380976984743,NULL,2119179049,'1',NULL,0,'','0'),
(300,0494,'Ярошинська Зоряна','1984-11-21',NULL,NULL,380967824303,NULL,1763552878,'1',NULL,1,'','0'),
(301,0454,'Кирилишин Галя','1998-05-29',NULL,NULL,380978728064,NULL,2034018144,'1',NULL,0,'','0'),
(302,0464,'Деревенчук Віра','1998-07-06',NULL,NULL,380678867061,NULL,1615262298,'1',NULL,0,'','0'),
(303,0474,'Маньовська Зоряна','1991-04-11',NULL,'Bft5yho/oYLKt2Y14rzLLw==',380968566617,NULL,1730352190,'1',21148,1,'','0'),
(304,0484,'Шевчук Наталя ','1965-02-15',NULL,NULL,380977373376,NULL,2105449385,'1',NULL,0,'','0'),
(305,0434,'Бернецівка Антоніна','1982-11-08',NULL,NULL,380678044707,NULL,1198949055,'1',NULL,0,'','0'),
(306,0444,'Микиташ Іра','1997-10-27',NULL,NULL,380975410853,NULL,2012143702,'1',NULL,0,'','0'),
(307,0414,'Бадлюк Уляна','2000-08-01',NULL,NULL,380961232680,NULL,1946193418,'1',63259,1,'','0'),
(308,0404,'Бессага Христина','1986-03-09',NULL,NULL,380985571506,NULL,1690466656,'1',NULL,0,'','0'),
(309,0424,'Коник Ольга ','1990-12-06',NULL,NULL,380664162106,NULL,1525754663,'1',NULL,0,'','0'),
(310,0492,'Гевко Таня','1992-08-04',NULL,NULL,NULL,380989206755,1138482667,'1',64740,0,'','0'),
(311,0362,'Сапіщук Христина ','2005-09-18',NULL,NULL,380978674080,NULL,2031394343,'1',NULL,0,'','0'),
(312,0372,'Бугера Оксана','1996-09-02',NULL,NULL,380930587294,NULL,1596721929,'1',NULL,0,'','0'),
(313,0392,'Чорна Оксана','1992-08-29',NULL,NULL,380503773001,NULL,1729878670,'1',NULL,0,'','0'),
(314,0004,'Єременчук Вікторія','1985-05-29',NULL,NULL,380972662317,NULL,1703054878,'1',NULL,0,'','0'),
(315,0534,'Доскочинська Іра ','1992-11-08',NULL,NULL,380984709369,NULL,1819973595,'1',NULL,0,'','0'),
(316,0524,'мельничин Оля ','1992-06-02',NULL,NULL,380982401311,NULL,1890724344,'1',17733,1,'','0'),
(317,0514,'Железняк Аня','1997-12-11',NULL,NULL,380683244458,NULL,1929695015,'1',NULL,0,'','0'),
(319,0384,'Ровінська Тетяна ','1993-09-27',NULL,NULL,380967653817,NULL,1457295491,'1',NULL,0,'','0'),
(318,0504,'Чехніта НАталя','1981-07-13',NULL,NULL,380674970597,NULL,1835559494,'1',NULL,0,'','0'),
(320,0354,'Слонь Надя ','0000-00-00',NULL,NULL,380666623315,NULL,1763086066,'1',NULL,0,'','0'),
(321,0364,'Гаврелюк Марія ','1994-03-15',NULL,NULL,380986689558,NULL,1317953930,'1',NULL,0,'','0'),
(322,0498,'Погорецька Руслана','1984-12-20',NULL,NULL,380978979438,NULL,1182894812,'1',57235,0,'','0'),
(323,0458,'Логін Аліна','0000-00-00',NULL,NULL,380961895629,NULL,1981776028,'1',NULL,0,'','0'),
(324,0034,'Затварніцька Таня','1994-02-28',NULL,NULL,380987277375,NULL,1298071759,'1',NULL,0,'','0'),
(325,0024,'Павлик Марія','0000-00-00',NULL,NULL,380986682338,NULL,1700227639,'1',NULL,0,'','0'),
(326,0908,'Білик Марія','1992-08-26',NULL,NULL,380997734961,NULL,1300927667,'1',NULL,0,'','0'),
(327,0928,'Роговська Тетяна ','1971-01-28',NULL,NULL,380066273500,NULL,1540876240,'1',NULL,0,'','0'),
(328,0010,'Шевцова Інна ','1978-11-23',NULL,NULL,380678446009,NULL,1700731457,'1',NULL,0,'','0'),
(329,0050,'ПЕтрів Наталя','1992-07-12',NULL,NULL,380930192592,NULL,1629505435,'1',NULL,0,'','0'),
(330,0500,'Билиця Юліанна ','1992-05-14',NULL,NULL,380988244096,NULL,1797648438,'1',NULL,0,'','0'),
(331,0552,'Гермак Христина ','1996-04-05',NULL,NULL,380637835315,NULL,1219712916,'1',NULL,0,'','0'),
(332,0918,'Чухрій  Лідія','1997-01-30',NULL,NULL,380639295185,NULL,1192442424,'1',NULL,0,'','0'),
(333,0460,'Сусяк Тетяна ','1971-07-20',NULL,NULL,380688997205,NULL,1848374779,'1',NULL,0,'','0'),
(334,0634,'Ковтун Таня','0000-00-00',NULL,NULL,380995517792,NULL,1214526427,'1',NULL,0,'','0'),
(335,0624,'Градова Христина',NULL,NULL,NULL,380985931545,NULL,1417310834,'1',NULL,0,'','0'),
(336,0470,'Петришак Ліля','1989-03-04',NULL,'j+YtboJeEWo94e93aZemeA==',380963025860,NULL,1459808142,'1',NULL,0,'','0'),
(337,0480,'Зегарські Уляна ','1989-03-17',NULL,NULL,NULL,NULL,1407579173,'1',NULL,0,'','0'),
(338,0490,'Лекар Інна','1993-11-20',NULL,NULL,380968769535,NULL,1576046142,'1',NULL,0,'','0'),
(339,0892,'Джурило Люда','1999-08-02',NULL,NULL,380977107699,NULL,1708932320,'1',NULL,0,'','0'),
(340,0532,'Тихович Оля','1995-01-16',NULL,NULL,380983317792,NULL,1156973882,'1',NULL,0,'','0'),
(341,0522,'Южда Юля','1995-01-29',NULL,NULL,380971320720,NULL,1180763965,'1',NULL,0,'','1'),
(342,0572,'Білик Анна Василівна','1994-11-06',NULL,NULL,380966813467,NULL,1610769538,'1',NULL,0,'','0'),
(343,0562,'Харченко Галина','1978-07-06',NULL,NULL,3822196,NULL,2027164651,'1',NULL,0,'','0'),
(344,0542,'Силіцька Юля ','1991-03-23',NULL,NULL,380505652479,NULL,1891109034,'1',NULL,0,'','0'),
(345,0374,'Кериченко Наталя','1991-11-30',NULL,NULL,380686505904,NULL,1945891009,'1',NULL,0,'','0'),
(346,0614,'Серединська Ліля','1992-02-07',NULL,NULL,380685141563,NULL,1519153437,'1',NULL,0,'','0'),
(347,0604,'Когут Таня','1996-09-25',NULL,NULL,380673084741,NULL,1594235631,'1',NULL,0,'','0'),
(348,0594,'Надя Колиндяни','1983-12-11',NULL,NULL,380970324914,NULL,1884943788,'1',NULL,0,'','0'),
(349,0932,'Кунцьо Наталя ','2002-08-10',NULL,NULL,380991339893,NULL,1983404028,'1',NULL,0,'','0'),
(350,0922,'Обшерська Катерина','2007-02-02',NULL,NULL,380983544911,NULL,1508399393,'1',35225,0,'','0'),
(351,0912,'Бублієнко Люба','1968-05-05',NULL,NULL,380984707954,NULL,1209817109,'1',NULL,0,'','0'),
(352,0554,'Осьмак Оксана','1994-09-18',NULL,NULL,380959187524,NULL,1796248774,'1',NULL,0,'','0'),
(353,0574,'Смук Юля','1999-12-15',NULL,NULL,380682384483,NULL,1400323245,'1',14016,0,'','0'),
(354,0564,'Кулій Оксана','1968-05-27',NULL,NULL,380687721500,NULL,1176012475,'1',NULL,0,'','0'),
(355,0875,'Титарчук Галя','1989-03-22',NULL,NULL,380976067310,NULL,1540412041,'1',NULL,0,'','0'),
(356,0472,'Батрак Антоніна ','1956-09-29',NULL,'qkjQq+wKBodcQsm5LhdhnA==',380977717961,NULL,1666934172,'1',54087,0,'','0'),
(357,0432,'Якубік Олена','2000-06-27',NULL,NULL,380965875798,NULL,1225297753,'1',NULL,0,'','0'),
(358,0898,'Максимчук Марія ','1990-12-07',NULL,NULL,380988281075,NULL,1302754442,'1',NULL,1,'','0'),
(359,0388,'Лось Оксана ','1980-08-12',NULL,NULL,380975784766,NULL,1122971170,'1',NULL,0,'','0'),
(360,0358,'Градова Юля ','1994-03-27',NULL,NULL,380981016279,NULL,1529758535,'1',NULL,0,'','0'),
(361,0368,'Петраш Наталя ','1972-05-06',NULL,NULL,380938638969,NULL,1217715785,'1',NULL,0,'','0'),
(362,0398,'Романчук Наталія ','1991-06-11',NULL,NULL,38096640814,NULL,1516337833,'1',NULL,0,'','0'),
(363,0378,'наконечна уляна','0000-00-00',NULL,'IDLBV+dUmNlsdafhiODieA==',380682284343,NULL,2005779337,'1',NULL,0,'','0'),
(364,0030,'Чоловська Віка','1993-03-20',NULL,'THAGNysBKDxx0TgIOcV0Sg==',380987793468,NULL,1188198477,'1',34296,0,'','0'),
(365,0462,'Миньок Галина','1970-10-18',NULL,NULL,380683682201,NULL,1357846905,'1',NULL,1,'','0'),
(366,0448,'Козлова Руслана','1974-12-28',NULL,NULL,380967140957,NULL,2004382138,'1',NULL,0,'','0'),
(367,0502,'Маракіа Віка','0994-12-26',NULL,NULL,380971191076,NULL,1423939232,'1',NULL,0,'','0'),
(368,0438,'Холоднюк Іра ','1997-04-02',NULL,NULL,380993312951,NULL,1333536124,'1',NULL,0,'','1'),
(369,0468,'Олексяк Наталя ','1992-05-07',NULL,NULL,380989722890,NULL,1579859564,'1',NULL,1,'','0'),
(370,0488,'Лаванда Галя ','1989-12-13',NULL,NULL,380969098088,NULL,1599755293,'1',NULL,0,'','0'),
(371,0478,'Бойко Анжела ','1997-06-05',NULL,NULL,380971500807,NULL,1694035012,'1',NULL,0,'','0'),
(372,0544,'федорчук Ольга  Броніславівна','1975-04-10',NULL,NULL,380635995434,NULL,1222705893,'1',NULL,1,'','0'),
(373,0040,'Данилишин Світлана','1997-04-28',NULL,'w2iU0Xkp7cyORLlxlDhyhA==',380977154286,NULL,1495418891,'1',38162,1,'','0'),
(374,0394,'Сєліцька Оксана Михайлівна','1984-10-26',NULL,NULL,380666117837,NULL,1662645032,'1',NULL,0,'','0'),
(375,0440,'Бридух Наталія','1990-03-10',NULL,NULL,380966390813,NULL,1888564287,'',NULL,0,'','0'),
(376,0902,'Івановчик Віталіна','1993-07-16',NULL,NULL,380680966492,NULL,1579236067,'1',33253,0,'','0'),
(377,0020,'Матевощук Ліля ','1986-09-17',NULL,NULL,380680116070,NULL,1871035675,'1',NULL,0,'','0'),
(378,0410,'обліжок Галина Миколаіна','1978-10-29',NULL,NULL,380975658234,NULL,1598506252,'1',27729,0,'','0'),
(379,0450,'Обліжок Божена Михайлівна','2000-08-18',NULL,NULL,380962363212,NULL,1256319525,'1',34145,2,'','0'),
(380,0742,'Гермак Аліна','1994-04-03',NULL,NULL,380684235754,NULL,1624984617,'1',NULL,0,'','0'),
(381,0582,'Шеременда Лілія Теодозіівна','2001-06-15',NULL,NULL,380978235314,NULL,1814808225,'1',NULL,0,'','0'),
(382,0934,'Сорокопуд Христина ','1990-09-29',NULL,NULL,380506212916,NULL,2044832604,'1',NULL,0,'','0'),
(383,0048,'Сендзюк Леся','1996-05-28',NULL,'jWDxbtQEFmzJPtqa/NVpdw==',380968073162,NULL,1156035716,'1',39476,1,'','0'),
(384,0408,'Брегін Ольга','1986-11-06',NULL,NULL,380673508683,NULL,1490046193,'1',65135,0,'','0'),
(385,0428,'Урсул Уляна','0000-00-00',NULL,NULL,NULL,380967833740,1266513092,'1',NULL,0,'','0'),
(386,0038,'Ворона Людмила','0000-00-00',NULL,NULL,NULL,NULL,1434267092,'1',NULL,0,'','0'),
(387,0418,'Мороз Ілона','1988-09-22',NULL,NULL,380978288220,NULL,1134942061,'1',NULL,0,'','0'),
(388,0014,'Лохматова  Аня','0000-00-00',NULL,NULL,380977020722,NULL,1403386093,'1',22864,0,'','0'),
(389,0430,'Рудик Стефанія','0000-00-00',NULL,NULL,380975906200,NULL,1930153775,'1',NULL,0,'','0'),
(390,0243,'Божагора ОЛя','1966-12-25',NULL,'hGkrJDJLT34Ya6pLjcY+hA==',380991569355,NULL,2068057793,'1',NULL,0,'','0'),
(391,0206,'Підгурська Ольга ','1996-02-12',NULL,NULL,380977605516,NULL,1155512291,'1',NULL,0,'','0'),
(392,0216,'Коцюк Христина ','1998-04-21',NULL,NULL,380976767841,NULL,2097204922,'1',NULL,0,'','0'),
(393,0420,'Бамбурак Таня','1999-06-29',NULL,NULL,380678601499,NULL,1570543545,'1',NULL,0,'','0'),
(394,0390,'Волкова Тетяна','1990-12-24',NULL,NULL,380969740615,NULL,2017221813,'1',NULL,0,'','0'),
(395,0744,'Гринів Світлана','1981-09-28',NULL,NULL,380962162496,NULL,1801967669,'1',NULL,0,'','0'),
(396,0584,'Струтинська Надя','1997-11-02',NULL,NULL,380986214657,NULL,1150986414,'1',NULL,0,'','0'),
(397,0360,'Рудик Наталя','0000-00-00',NULL,NULL,380973404137,NULL,1762917167,'1',NULL,0,'','0'),
(398,0370,'Гапин Софія','2002-09-18',NULL,NULL,380675959379,NULL,1298894871,'1',NULL,0,'','0'),
(399,0078,'Ковбас ірина','1984-09-19',NULL,NULL,380506406361,NULL,1501211813,'1',NULL,0,'','0'),
(400,0098,'Нікітін Уляна','1999-05-10',NULL,NULL,380978126586,NULL,1331456969,'1',NULL,0,'','0'),
(401,0058,'Леганчук Ірина петрівна','1887-06-02',NULL,NULL,380978398533,NULL,1882737757,'1',NULL,0,'','0'),
(402,0400,'Олексишин Наталя','1979-09-06',NULL,NULL,380689602204,NULL,1506801201,'1',NULL,0,'','0'),
(403,0380,'Захарчук Наталя','2003-06-01',NULL,NULL,380507482687,NULL,1197229100,'1',43518,4,'','0'),
(404,0088,'Марія Яворська','0000-00-00',NULL,NULL,380960782589,NULL,1197669818,'1',NULL,1,'','0'),
(405,0068,'Кожушко Оксана Орестівна','1967-07-02',NULL,NULL,380982252014,NULL,1154433200,'1',NULL,0,'','0'),
(406,0018,'Машталляр Марія','0000-00-00',NULL,NULL,380686505786,NULL,1131524941,'1',NULL,0,'','0'),
(407,0138,'Корнак Марія','0000-00-00',NULL,NULL,380676099439,NULL,1145969207,'1',NULL,0,'','0'),
(408,0128,'Маліцька Каріна','2011-11-03',NULL,NULL,380977550575,NULL,1692582998,'1',NULL,0,'','0'),
(409,0118,'Голодівська Ірина','1995-01-28',NULL,NULL,380978328028,NULL,2107628913,'1',NULL,0,'','0'),
(410,0108,'Сорока Оля','1995-10-31',NULL,NULL,380988173215,NULL,1359683938,'1',NULL,0,'','0'),
(411,0148,'Градова Наталя','1998-10-18',NULL,NULL,380674001641,NULL,1814623115,'1',NULL,0,'','0'),
(412,0094,'Наталя Борик','1985-11-10',NULL,NULL,380964901909,NULL,1453059091,'1',NULL,0,'','0'),
(413,0184,'Іванка Пельвецька','2001-05-15',NULL,'b5fBUm4jf1vEre7hQ1qw3A==',380686241202,NULL,1588362002,'1',34518,0,'','0'),
(414,0008,'Гринчук Оксана Романівна','2002-02-11',NULL,NULL,380962745466,NULL,2083117822,'1',NULL,0,'','0'),
(415,0028,'Песікова Ірина','0000-00-00',NULL,'856yERAQJw/8U6SFeLHMkw==',380992901668,NULL,1689733398,'1',NULL,4,'','0'),
(416,0054,'Зубік Тетяна','0000-00-00',NULL,NULL,380985786956,NULL,1640253276,'1',NULL,0,'','0'),
(417,0084,'Бойко Тетяна','1993-02-14',NULL,'8DfikFmDLfqXKzzxXoe74A==',380666002229,NULL,1418152367,'1',NULL,1,'','0'),
(418,0064,'Катиренюк Лілія Ігорівна','1995-10-19',NULL,NULL,380955905750,NULL,1594262445,'1',NULL,0,'','0'),
(419,0104,'Романюк Марія','1996-10-15',NULL,NULL,380681582500,NULL,1543928099,'1',NULL,1,'','0'),
(420,0114,'Люба Світлана','0000-00-00',NULL,NULL,380677603491,NULL,2077392549,'1',NULL,0,'','0'),
(421,0174,'Гузік Лідія','1973-10-03',NULL,NULL,380981325932,NULL,1926055768,'1',NULL,0,'','0'),
(422,0144,'Пахолків Марія','0000-00-00',NULL,NULL,380978848011,NULL,1195583145,'1',NULL,0,'','0'),
(423,0226,'Голіната Катя Володимирівна','1885-12-14',NULL,NULL,380661089766,NULL,2033532459,'1',NULL,0,'','0'),
(424,0194,'Садовяк Наталя','1982-05-19',NULL,NULL,380673906535,NULL,1978315074,'1',NULL,0,'','0'),
(425,0164,'Чубко Юлія Іванівна','2001-03-24',NULL,NULL,380964244731,NULL,1336851177,'1',NULL,0,'','0'),
(426,0244,'Лесюк Наталія','1976-10-18',NULL,NULL,380673547853,NULL,1154721232,'1',NULL,0,'','0'),
(427,0154,'Світлана Боцян','0000-00-00',NULL,NULL,380994903960,NULL,1465284220,'1',NULL,0,'','0'),
(428,0234,'Смук Надя','0000-00-00',NULL,NULL,380969563163,NULL,1374125337,'1',NULL,0,'','0'),
(429,0224,'Коростіль Ліля','0000-00-00',NULL,NULL,380971378266,NULL,1561626013,'1',NULL,0,'','0'),
(430,0204,'станько христина','1991-09-11',NULL,NULL,380950601369,NULL,1493243887,'1',NULL,0,'','0'),
(431,0076,'Романчук наталія Вікторівна','1991-06-11',NULL,NULL,380966405804,NULL,1411420201,'1',NULL,0,'','0'),
(432,0096,' Віталіна Вікторівна','0000-00-00',NULL,'A723RvDNAM1frN6BoWHEyg==',380985570625,NULL,1591592112,'1',NULL,0,'','0'),
(433,0056,'Коник Вікторія','1990-05-01',NULL,NULL,380970510305,NULL,1750031287,'1',NULL,0,'','0'),
(434,0086,'козакевич таня','1988-08-13',NULL,NULL,380976397126,NULL,1171180140,'1',NULL,0,'','0'),
(435,0066,'Віка Стельмах','1996-01-16',NULL,NULL,380968430179,NULL,1448033224,'1',NULL,0,'','0'),
(436,0136,'Руслана Стельмах','1998-01-17',NULL,NULL,380961281891,NULL,1303815334,'1',NULL,0,'','0'),
(437,0116,'Савіцька Христина','0000-00-00',NULL,NULL,380500215735,NULL,1727643930,'1',NULL,0,'','0'),
(438,0106,'Смеречинська  Анна','0000-00-00',NULL,NULL,380676036318,NULL,1151300167,'1',NULL,0,'','0'),
(439,0176,'Бойчук Юля Андріівна','1997-07-04',NULL,NULL,380678464676,NULL,1843730274,'1',NULL,0,'','0'),
(440,NULL,'Роздрібний клієнт','0000-00-00','2017-07-31',NULL,NULL,0,1946615466,'1',NULL,0,'','0'),
(441,NULL,'Тестовий Клієнт','0000-00-00','2017-07-31',NULL,380501234567,0,1783189685,'1',NULL,0,'','0'),
(442,NULL,'Тест2','0000-00-00','2017-07-31',NULL,380509999999,0,1408815770,'1',NULL,0,'','1'),
(443,NULL,'Тест3',NULL,'2017-07-31',NULL,3805,NULL,1836551359,'1',NULL,0,'','1'),
(444,NULL,'Тестовий4',NULL,NULL,NULL,380500000908,NULL,1449957222,'1',NULL,0,'','1'),
(445,NULL,'Дембіцька Ольга',NULL,'2017-08-01',NULL,380970108311,NULL,1786051865,'1',NULL,2,'','0'),
(446,NULL,'Куцій Таня',NULL,NULL,NULL,380669487555,NULL,1515944952,'1',NULL,0,'','0'),
(447,NULL,'Мушій Оля',NULL,'2017-08-02',NULL,380989718428,NULL,1823048700,'1',NULL,0,'','0'),
(448,0657,'Харук Олександра',NULL,NULL,'q90oZnhVBb5VUpS/FQbhgQ==',380685141589,NULL,1957289480,'1',17058,0,'','0'),
(449,NULL,'Петрушенко Леся',NULL,'2017-08-02','yecli4i3V+eqHRG9f4BHqw==',380973390017,NULL,1391841598,'1',60010,0,'','0'),
(450,0583,'Бедрій Оксана',NULL,NULL,'WmFqaV/lyNTdNr0AlHJkiQ==',380683577900,NULL,1314041028,'1',49618,0,'','0'),
(451,NULL,'Богайчук Галина',NULL,'2017-08-02',NULL,380680931815,NULL,1965567068,'1',NULL,0,'','0'),
(452,NULL,'Демкович Віка',NULL,'2017-08-02',NULL,380961394262,NULL,1658759238,'1',NULL,0,'','0'),
(453,NULL,'шушара маряна',NULL,NULL,NULL,380975084674,NULL,2002364459,'1',NULL,2,'','0'),
(454,NULL,'Павлишин Наталя',NULL,NULL,NULL,380935738415,NULL,1815116712,'1',NULL,0,'','0'),
(455,0279,'Колісник Люда',NULL,NULL,NULL,380974813186,NULL,2094317620,'1',NULL,1,'','0'),
(456,0511,'Підгорецька Оля',NULL,NULL,NULL,380665119251,NULL,1771980537,'1',NULL,0,'','0'),
(457,0259,'Мороз Ліля',NULL,NULL,NULL,380993232404,NULL,1162279878,'1',NULL,0,'','0'),
(458,NULL,'',NULL,NULL,NULL,NULL,NULL,1856411422,'1',NULL,0,'','0'),
(459,0337,'Коваль Іра',NULL,NULL,NULL,380987686855,NULL,1381008488,'1',55672,0,'','0'),
(460,NULL,'Гальтюк Христина',NULL,NULL,'DnraS3mUelMdkE1wm9uWRw==',380968398760,NULL,1297852153,'1',19744,0,'','0'),
(461,NULL,'',NULL,NULL,NULL,NULL,NULL,1310136011,'1',NULL,0,'','0'),
(462,NULL,'Яблонська Наталя',NULL,NULL,NULL,380678908145,NULL,1141793953,'1',NULL,0,'','0'),
(463,NULL,'Богута Інна',NULL,NULL,NULL,380660467277,NULL,2069539418,'1',NULL,0,'','0'),
(464,NULL,'Федорейко Соломія',NULL,NULL,NULL,380509502222,NULL,2107787771,'1',NULL,0,'','1'),
(465,NULL,'Ватраль Марія',NULL,'2017-08-03',NULL,380674392831,NULL,1783119755,'1',NULL,0,'','0'),
(466,0062,'Шмиголь Ірина',NULL,NULL,'yoI1xK47jztUs0QVRvozeg==',380980143573,NULL,1686596488,'1',NULL,0,'','0'),
(467,NULL,'Чекаловська Вікторія',NULL,NULL,NULL,380666560750,NULL,1884838735,'1',NULL,0,'','0'),
(468,0349,'Прондюк Ганна',NULL,NULL,NULL,380978723612,NULL,1753715976,'1',NULL,0,'','0'),
(469,NULL,' Гильців Наталя',NULL,NULL,NULL,380686469116,NULL,1126954798,'1',NULL,0,'','0'),
(470,NULL,'Грушевська Оля',NULL,'2017-08-03',NULL,380988664929,NULL,1708326836,'1',NULL,0,'','0'),
(471,NULL,'Тимчук Оля',NULL,'2017-08-03',NULL,380971594301,NULL,1938453834,'1',NULL,0,'','0'),
(472,NULL,'Кулій Діана',NULL,'2017-08-03',NULL,380502390588,NULL,1258886770,'1',NULL,0,'','0'),
(473,NULL,'Промдюк Наталя',NULL,NULL,NULL,380982538049,NULL,1750403797,'1',NULL,0,'','0'),
(474,NULL,'Грицик Марія',NULL,'2017-08-03',NULL,380970632251,NULL,1249426792,'1',NULL,0,'','0'),
(475,NULL,'Шарун Соломія',NULL,'2017-08-03',NULL,380639296709,NULL,1530614395,'1',NULL,0,'','0'),
(476,NULL,'Гейніш Марія',NULL,'2017-08-03',NULL,380970554366,NULL,1703506022,'1',NULL,0,'','0'),
(477,NULL,'Южда Оля',NULL,NULL,'L542mC5/WJhTQowpVVOZCQ==',380966765720,NULL,1229540470,'1',50465,0,'','0'),
(478,NULL,'Грита Іра',NULL,'2017-08-03',NULL,380675306850,NULL,1734476536,'1',NULL,0,'','0'),
(479,NULL,' Скобальська Христя',NULL,NULL,NULL,NULL,NULL,1360494367,'1',NULL,0,'','1'),
(480,0935,'Глушин Іра',NULL,NULL,NULL,380675859836,NULL,1145590307,'1',NULL,0,'','0'),
(481,NULL,'Таня н',NULL,NULL,NULL,380953143904,NULL,1695230017,'1',NULL,0,'','0'),
(482,NULL,'Железняк Женя',NULL,'2017-08-03',NULL,380965710597,NULL,1874553311,'1',NULL,0,'','0'),
(483,NULL,'Гордієнко Оля',NULL,NULL,'1m84VRxHYyF7Ub2KMlAECg==',380963715310,NULL,1991949495,'1',35583,0,'','0'),
(484,NULL,'Юля',NULL,NULL,NULL,NULL,NULL,1602391302,'1',NULL,0,'','1'),
(485,NULL,'Бабик Анастасія',NULL,'2017-08-03',NULL,380936456101,NULL,1394746205,'1',NULL,0,'','0'),
(486,NULL,'Трембалюк Таня',NULL,NULL,NULL,380962546543,NULL,2081378665,'1',NULL,0,'','0'),
(487,NULL,'Козак Оля',NULL,'2017-08-03',NULL,380971040927,NULL,1160516545,'1',NULL,0,'','0'),
(488,0132,'Наталя Корнелівна',NULL,NULL,NULL,380992549767,NULL,1914133395,'1',NULL,0,'','0'),
(489,NULL,' Левицька Наталя',NULL,NULL,NULL,380955913220,NULL,1702933497,'1',NULL,0,'','0'),
(490,NULL,'Болібрус Наталя',NULL,'2017-08-04',NULL,380982737225,NULL,1855040033,'1',NULL,2,'','0'),
(491,NULL,'Федоляк Світлана',NULL,'2017-08-04',NULL,380976415750,NULL,1428998150,'1',NULL,0,'','0'),
(492,0192,'Ткачук Наталя ',NULL,NULL,NULL,380503774092,NULL,1313417352,'1',NULL,0,'','0'),
(493,NULL,'Безпалько Олена',NULL,NULL,NULL,380931325161,NULL,2096749258,'1',NULL,0,'','0'),
(494,NULL,'Івашків Оля',NULL,'2017-08-04',NULL,380975035464,NULL,1463049304,'1',NULL,0,'','0'),
(495,NULL,'Беднарська Наталя',NULL,NULL,NULL,380673657573,NULL,1176669334,'1',NULL,0,'','0'),
(496,NULL,'Усова Таня ',NULL,'2017-08-04',NULL,380953741171,NULL,1445474314,'1',NULL,0,'','0'),
(497,NULL,'Сушельницька Надя',NULL,'2017-08-04','Kry67URVlD1/oSUduMXxYg==',380936580593,NULL,1913485701,'1',NULL,0,'','0'),
(498,NULL,'Бура Аліна',NULL,'2017-08-04',NULL,380986490916,NULL,1950655092,'1',26608,5,'','0'),
(499,NULL,'грабова катя',NULL,NULL,NULL,380677433083,NULL,1770268942,'1',NULL,0,'','0'),
(500,NULL,'Мерена Зоя ',NULL,'2017-08-04',NULL,380976263720,NULL,1455206926,'1',NULL,0,'','0');

INSERT INTO `kontragentu` VALUES 
(501,NULL,'Федишин Наталя',NULL,'2017-08-04',NULL,380969575830,NULL,1823062661,'1',NULL,0,'','0'),
(502,NULL,'Палагнюк Люда',NULL,'2017-08-04',NULL,380987018673,NULL,2067124912,'1',NULL,0,'','0'),
(503,NULL,'Негайчук Іра',NULL,'2017-08-04',NULL,380967426612,NULL,1697927972,'1',NULL,0,'','0'),
(504,NULL,'Пиняк Наталя',NULL,NULL,NULL,380669240207,NULL,1843068896,'1',NULL,0,'','0'),
(505,NULL,'380987313551',NULL,'2017-08-04',NULL,NULL,NULL,1364671291,'1',NULL,0,'','0'),
(506,0293,'Половчук Оля',NULL,NULL,'gMjnkxDh63BDyHd5fHVsDw==',380681603844,NULL,1377627789,'1',53770,0,'','0'),
(507,NULL,'Майданик Віра',NULL,NULL,NULL,380984236778,NULL,1908911540,'1',48495,0,'','0'),
(508,NULL,'Іра ',NULL,'2017-08-04',NULL,380989881274,NULL,1346700010,'1',NULL,0,'','0'),
(509,NULL,'Чепига Іванна',NULL,'2017-08-04',NULL,380936418788,NULL,1768767220,'1',NULL,0,'','0'),
(510,NULL,'наконечна оля',NULL,NULL,NULL,NULL,NULL,2004726993,'1',NULL,0,'','1'),
(511,NULL,'Вакуленко Наталя',NULL,'2017-08-04',NULL,380977010771,NULL,2000769560,'1',NULL,0,'','0'),
(512,NULL,'Клебан Оксана',NULL,'2017-08-04',NULL,380665345725,NULL,1170991603,'1',NULL,0,'','0'),
(513,NULL,'Мельничук Оля',NULL,NULL,NULL,NULL,NULL,1620852562,'1',NULL,0,'','1'),
(514,NULL,'Вакулишин Оля',NULL,NULL,NULL,NULL,NULL,2007515928,'1',NULL,0,'','1'),
(515,0220,'Гальтюк Христина',NULL,NULL,NULL,NULL,380968398760,1737531499,'1',NULL,0,'','0'),
(516,NULL,'павлюк оксана',NULL,NULL,NULL,NULL,NULL,1516235088,'1',NULL,0,'','1'),
(517,NULL,'Павлюк Галина',NULL,'2017-08-04',NULL,380689559846,NULL,2071142975,'1',NULL,0,'','0'),
(518,NULL,'Кононова Таня',NULL,NULL,NULL,380989883554,NULL,1479492209,'1',NULL,0,'','0'),
(519,NULL,'Волянська Юля',NULL,NULL,NULL,380984794268,NULL,1898333311,'1',NULL,0,'','0'),
(520,NULL,'бабій наталя',NULL,'2017-08-04',NULL,380633862196,NULL,1760118238,'1',NULL,0,'','0'),
(521,NULL,'чепига оксана',NULL,NULL,NULL,NULL,NULL,1737738093,'1',NULL,0,'','1'),
(522,NULL,'Кучерява Оля',NULL,'2017-08-04',NULL,380968415205,NULL,1321715976,'1',38512,0,'','0'),
(523,NULL,'Дерманська Іра',NULL,'2017-08-04',NULL,380680931740,NULL,2114574490,'1',NULL,0,'','0'),
(524,0146,'Зозуляк Таня',NULL,'2017-08-04',NULL,383809729598,NULL,1626872702,'1',NULL,0,'','0'),
(525,0126,'Мельничук Оля',NULL,NULL,NULL,380979155006,NULL,1442337057,'1',NULL,0,'','0'),
(526,0230,'Садовяк Наталя',NULL,NULL,NULL,380356739605,NULL,1598800121,'1',NULL,0,'','1'),
(527,0186,'Яблонська Наталя',NULL,NULL,NULL,380678980145,NULL,2106353155,'1',NULL,0,'','1'),
(528,0240,'Мендик Оксана',NULL,'2017-08-07',NULL,380987141271,NULL,1455576922,'1',NULL,0,'','0'),
(529,NULL,'Костранець Юля',NULL,NULL,NULL,380638180834,NULL,1817000581,'1',NULL,0,'','0'),
(530,NULL,'Нагорна Іра',NULL,NULL,NULL,380955381194,NULL,2070443902,'1',NULL,0,'','0'),
(531,0202,'Легка Оксана',NULL,NULL,NULL,380961979216,NULL,1365444856,'1',NULL,0,'','0'),
(532,NULL,'Процків Оля',NULL,NULL,'tapcDl8zxQ01w6El9DpNnQ==',380966077459,NULL,2007629035,'1',NULL,1,'','0'),
(533,NULL,'Гуцало Галина',NULL,'2017-08-08',NULL,380982073233,NULL,1322549351,'1',NULL,0,'','0'),
(534,0072,'Попіль Іра',NULL,NULL,NULL,380980592398,NULL,1709184252,'1',25005,0,'','0'),
(535,NULL,'Худик Іра',NULL,NULL,NULL,380968529161,NULL,1902449387,'1',NULL,0,'','0'),
(536,NULL,'Бобак Наталя',NULL,NULL,NULL,380681696728,NULL,1722815691,'1',NULL,0,'','0'),
(537,NULL,'Процьків Таня',NULL,NULL,NULL,380950869989,NULL,1318050722,'1',36919,1,'','0'),
(538,NULL,'Квіцинська Оксана',NULL,'2017-08-08',NULL,380971038388,NULL,1550079772,'1',NULL,0,'','0'),
(539,NULL,'Гановська  Марія',NULL,NULL,NULL,380988194019,NULL,1743615534,'1',NULL,0,'','0'),
(540,NULL,'Кушнір Діана',NULL,'2017-08-08',NULL,380969136229,NULL,1943198318,'1',NULL,0,'','0'),
(541,NULL,'Попадюк Наталя',NULL,'2017-08-08',NULL,380971580064,NULL,2071932745,'1',NULL,0,'','0'),
(542,0667,'Ганущак Іра',NULL,NULL,'eYgkmYhzU74cg4HLZlKoyg==',380989446330,NULL,2062120702,'1',NULL,0,'','0'),
(543,0222,'Попіль Ілона',NULL,NULL,'t9BpC3b4Bkq+9hpY1jk4Ww==',380976500016,NULL,1661901297,'1',46537,1,'','0'),
(544,NULL,'Твігун Маряна',NULL,'2017-08-08',NULL,380986477881,NULL,1564322889,'1',NULL,0,'','0'),
(545,NULL,'Олексишин Ілона',NULL,'2017-08-08',NULL,380967671080,NULL,1220021701,'1',NULL,0,'','0'),
(546,NULL,'Пікота Аліна',NULL,'2017-08-08',NULL,380984631545,NULL,1634837627,'1',NULL,0,'','0'),
(547,NULL,'Слободян Юля',NULL,'2017-08-08',NULL,380985389465,NULL,1459859695,'1',NULL,0,'','0'),
(548,NULL,'Квіцінська Оля',NULL,'2017-08-08',NULL,NULL,NULL,1560509669,'1',NULL,0,'','0'),
(549,NULL,'Коверська Люда',NULL,NULL,NULL,380969875017,NULL,1633165565,'1',NULL,0,'','0'),
(550,NULL,'Слободян Уляна',NULL,'2017-08-08',NULL,380969575819,NULL,1121839146,'1',NULL,0,'','0'),
(551,NULL,'Потикевич Галина',NULL,NULL,NULL,NULL,NULL,1484058282,'1',NULL,0,'','0'),
(552,NULL,'Сиротюк Наталя',NULL,'2017-08-08',NULL,380972891613,NULL,1539812407,'1',NULL,0,'','0'),
(553,NULL,'Пецкович Настя',NULL,'2017-08-08',NULL,380671702864,NULL,1756936899,'1',NULL,0,'','0'),
(554,NULL,'Юрків Оля',NULL,'2017-08-08',NULL,380961528082,NULL,1673110989,'1',NULL,0,'','0'),
(555,NULL,'Федорейко Соломія ',NULL,'2017-08-08',NULL,380992280668,NULL,1577045130,'1',NULL,0,'','0'),
(556,NULL,'Біланик Наталя',NULL,NULL,NULL,NULL,NULL,1426192913,'1',NULL,0,'','1'),
(557,NULL,'Мардаль Наталя',NULL,'2017-08-09',NULL,380686773543,NULL,1848285573,'1',NULL,0,'','0'),
(558,0196,'Федорович Таня',NULL,'2017-08-09','oMLvqFXOQ7GZw8SmPc691Q==',380687118705,NULL,1209747431,'1',NULL,2,'','0'),
(559,NULL,'Чижишин Людмила',NULL,'2017-08-11',NULL,380991273543,NULL,1530295179,'1',NULL,1,'','0'),
(560,NULL,'Рахімзанова Настя',NULL,'2017-08-11',NULL,380688640371,NULL,1817537274,'1',NULL,0,'','0'),
(561,NULL,'Чинкалюк Олена',NULL,NULL,NULL,380667123724,NULL,1894707876,'1',NULL,0,'','0'),
(562,0515,'Середа Оля',NULL,NULL,NULL,380686296700,NULL,1179191579,'1',NULL,1,'','0'),
(563,NULL,'Ворк Маріана',NULL,'2017-08-11',NULL,380982951598,NULL,2027827622,'1',NULL,0,'','0'),
(564,NULL,'Кардинал Зоряна',NULL,'2017-08-11','zMtW4aigP3kbNMgGiD1dgA==',380984479485,NULL,1999786230,'1',NULL,0,'','0'),
(565,0617,'Кривак Оля ',NULL,NULL,NULL,380986461492,NULL,1758827359,'1',NULL,0,'','0'),
(566,NULL,'Рибак Леся',NULL,'2017-08-11',NULL,380501890683,NULL,1168076895,'1',NULL,0,'','0'),
(1319,NULL,'Яремчук Віталія',NULL,'2017-11-02',NULL,380984709053,NULL,1256688832,'1',NULL,0,'','0'),
(567,0152,'Задорожна Оксана',NULL,NULL,NULL,380978918397,NULL,1117616422,'1',NULL,0,'','0'),
(568,0166,'Барчишак Люда',NULL,NULL,NULL,380987660865,NULL,1250135110,'1',NULL,0,'','0'),
(569,NULL,'Татарчук Уляна',NULL,'2017-08-14',NULL,380989280090,NULL,1349941439,'1',NULL,0,'','0'),
(570,NULL,'Львівська Анастасія',NULL,'2017-08-14',NULL,380971787166,NULL,1681778728,'1',NULL,0,'','0'),
(571,NULL,'Львівська Вікторія',NULL,'2017-08-14',NULL,380978977349,NULL,1424209953,'1',NULL,0,'','0'),
(572,NULL,'Львівська Таня',NULL,NULL,NULL,NULL,NULL,2101852499,'1',NULL,0,'','0'),
(573,NULL,'Кісляк Таня',NULL,NULL,NULL,NULL,NULL,1119609396,'1',NULL,0,'','0'),
(574,NULL,'Стецько Оксана',NULL,'2017-08-14',NULL,380686260849,NULL,1875816507,'1',NULL,0,'','0'),
(575,NULL,'Носаль Наталя',NULL,NULL,NULL,380993109026,NULL,1801136537,'1',NULL,0,'','0'),
(576,NULL,'Кіфяк Таня',NULL,'2017-08-14',NULL,380966244460,NULL,1355808845,'1',NULL,0,'','0'),
(577,NULL,'Ступняк Марія',NULL,'2017-08-14',NULL,380684213115,NULL,1537727485,'1',NULL,0,'','0'),
(578,0156,'Кноль Христина',NULL,'2017-08-14',NULL,380969927945,NULL,1522159510,'1',NULL,0,'','0'),
(579,NULL,'Тапчак Зіна',NULL,NULL,NULL,380671401013,NULL,1410483347,'1',NULL,0,'','0'),
(580,NULL,'Мурза Наталя',NULL,'2017-08-14','/7wbWYDDpM5U1pdbjYf3QA==',380971450855,NULL,1401025255,'1',63834,0,'','0'),
(581,NULL,'Нашкольна Інна',NULL,'2017-08-14',NULL,380972650100,NULL,1785132317,'1',NULL,0,'','0'),
(582,NULL,'Ватраль Галя',NULL,'2017-08-14',NULL,380963866450,NULL,2017078519,'1',NULL,0,'','0'),
(583,NULL,'Бура Леся',NULL,'2017-08-14',NULL,380677348365,NULL,1784201646,'1',NULL,0,'','0'),
(584,NULL,'Бабяк Галя',NULL,'2017-08-14',NULL,380978678209,NULL,1618897830,'1',NULL,0,'','0'),
(585,NULL,'Каспрій Христина',NULL,'2017-08-14',NULL,380966010989,NULL,2111107750,'1',NULL,0,'','0'),
(586,NULL,'Беднарська Юля',NULL,'2017-08-14',NULL,380673165336,NULL,2047859783,'1',NULL,0,'','0'),
(587,NULL,'Сеньків Христина',NULL,'2017-08-14',NULL,380668711829,NULL,1453255122,'1',NULL,0,'','0'),
(588,NULL,'Стельмах Анастасія',NULL,'2017-08-14','EoOtUsJhk6HiLyqPYLfAxg==',380980070500,NULL,1490327192,'1',37379,0,'','0'),
(589,0689,'Захарова Таня',NULL,NULL,NULL,380977685848,NULL,1718963315,'1',NULL,0,'','0'),
(590,NULL,'Гуменюк Світлана',NULL,NULL,NULL,380970043539,NULL,1428402437,'1',NULL,0,'','0'),
(591,NULL,'Каленчук Маряна',NULL,'2017-08-14',NULL,380685975802,NULL,1494593112,'1',53526,0,'','0'),
(592,NULL,'Годна Марія',NULL,'2017-08-14',NULL,380986370042,NULL,1155774052,'1',NULL,0,'','0'),
(593,NULL,'Стрембіцька Наталя',NULL,'2017-08-14',NULL,380976503738,NULL,1268005291,'1',NULL,0,'','0'),
(594,NULL,'Буренюк Уляна',NULL,'2017-08-14',NULL,380971218501,NULL,1540849170,'1',NULL,0,'','0'),
(595,NULL,'Черемшинська Оля',NULL,'2017-08-14',NULL,380965616974,NULL,1408108122,'1',NULL,0,'','0'),
(596,NULL,'Бачик Оксана',NULL,'2017-08-14',NULL,380972360291,NULL,1443311968,'1',NULL,0,'','0'),
(597,NULL,'Гриньків Таня',NULL,'2017-08-14',NULL,380970814071,NULL,1822130406,'1',NULL,0,'','0'),
(598,0929,'Солодяк Леся',NULL,NULL,NULL,380685883572,NULL,1728025439,'1',NULL,0,'','0'),
(599,0297,'Дзюба Алла',NULL,NULL,NULL,380502545964,NULL,2092092078,'1',NULL,0,'','0'),
(600,NULL,'Стасів Ярина',NULL,'2017-08-15','VBmewDMo0cCjDUBQHoJ0Qg==',380975033735,NULL,1147697698,'1',45618,0,'','0'),
(601,NULL,'Мальована Іванна',NULL,'2017-08-15',NULL,380979747038,NULL,1643538627,'1',NULL,0,'','0'),
(602,NULL,'Копчук Оксана',NULL,'2017-08-15',NULL,380970550229,NULL,1935585446,'1',NULL,0,'','0'),
(603,NULL,'Пшик Галина',NULL,NULL,NULL,380675807096,NULL,1295879127,'1',NULL,0,'','0'),
(604,NULL,'Семчишин Наталя',NULL,'2017-08-15','/5WFowqF1pATMj2GBnaMFw==',380972323726,NULL,2064636086,'1',58054,0,'','0'),
(605,NULL,'Петрик Інна',NULL,'2017-08-15',NULL,380965240504,NULL,1768583990,'1',NULL,0,'','0'),
(606,NULL,'Поліщук Оля',NULL,'2017-08-15',NULL,380973374589,NULL,1501230931,'1',NULL,0,'','0'),
(607,NULL,'Пшеніцька Іра',NULL,'2017-08-15',NULL,380961819307,NULL,1354436953,'1',NULL,0,'','0'),
(608,NULL,'Муринюк Роксолана',NULL,NULL,NULL,380671964873,NULL,1365497954,'1',NULL,0,'','0'),
(609,0671,'Зень Леся',NULL,NULL,NULL,380969572778,NULL,1745821412,'1',NULL,0,'','0'),
(610,0052,'Шевченко Наталя ',NULL,NULL,'MOTikMjWF6fX9S6Lz9/VwA==',380671328941,380955331510,2022176277,'1',NULL,0,'','0'),
(611,NULL,'Боднар Юля',NULL,'2017-08-16',NULL,380676013932,NULL,1856125289,'1',NULL,0,'','0'),
(612,NULL,'наталя щербакова',NULL,NULL,NULL,380986438662,NULL,1356644513,'',45072,0,'','0'),
(613,NULL,'Наконечна Вікторія',NULL,NULL,NULL,380977235986,NULL,1774332484,'1',NULL,1,'','0'),
(614,NULL,'Заверуха Оксана',NULL,'2017-08-16',NULL,380971279688,NULL,1608722019,'1',NULL,0,'','0'),
(615,NULL,'Богута Настя',NULL,'2017-08-16',NULL,380952054241,NULL,1554033914,'1',NULL,0,'','0'),
(616,NULL,'Пандрак Діана',NULL,'2017-08-16',NULL,380983569517,NULL,1644395693,'1',NULL,1,'','0'),
(617,NULL,'Петльована Галя',NULL,NULL,NULL,380978427199,NULL,1652674108,'1',NULL,0,'','0'),
(618,NULL,'Таня Петльована',NULL,NULL,NULL,NULL,NULL,2032840139,'1',NULL,0,'','0'),
(619,NULL,'міх 2',NULL,NULL,NULL,NULL,NULL,1602151660,'1',NULL,0,'','0'),
(620,NULL,'міх3',NULL,NULL,NULL,NULL,NULL,1137346531,'1',NULL,0,'','0'),
(621,NULL,'міх таня',NULL,NULL,NULL,NULL,NULL,1254653121,'1',NULL,0,'','0'),
(622,NULL,'Пиняк Віра',NULL,'2017-08-16',NULL,380971572206,NULL,1763569141,'1',NULL,0,'','0'),
(623,NULL,'Шпак Марія',NULL,'2017-08-16',NULL,380962466545,NULL,1935218137,'1',NULL,0,'','0'),
(624,NULL,'Олійник Аня',NULL,'2017-08-16',NULL,380977022565,NULL,1698519773,'1',NULL,0,'','0'),
(625,NULL,'Смаглій Уляна',NULL,'2017-08-16',NULL,380972656900,NULL,1344905383,'1',NULL,0,'','0'),
(626,NULL,'Ненчин Надя',NULL,NULL,NULL,380964293062,NULL,1247394706,'1',46174,1,'','0'),
(627,NULL,'Андрійчук Галя',NULL,'2017-08-16',NULL,380967240200,NULL,1786865227,'1',NULL,0,'','0'),
(628,NULL,'Курець Світлана',NULL,'2017-08-16',NULL,380734697727,NULL,1178569439,'1',NULL,0,'','0'),
(629,NULL,'Качмар Настя',NULL,'2017-08-16',NULL,380683165332,NULL,1382191915,'1',NULL,0,'','0'),
(630,NULL,'Юля .',NULL,'2017-08-16',NULL,380662006186,NULL,1197016278,'1',NULL,0,'','0'),
(631,NULL,'Кухарчук Оля',NULL,'2017-08-16',NULL,380976604087,NULL,1208088621,'1',NULL,0,'','0'),
(632,NULL,'Лазецька Аліна',NULL,'2017-08-16',NULL,380972644805,NULL,2113450965,'1',NULL,0,'','0'),
(633,NULL,'Заверуха Люба',NULL,'2017-08-16',NULL,380982329177,NULL,1661511023,'1',NULL,0,'','0'),
(634,NULL,'Ільяшенко Таня',NULL,'2017-08-16',NULL,380986598470,NULL,2065862160,'1',NULL,0,'','0'),
(635,NULL,'Захарко Віра',NULL,'2017-08-16',NULL,380675948066,NULL,1173284995,'1',NULL,0,'','0'),
(636,NULL,'Регуш Інна',NULL,NULL,NULL,380961158977,NULL,2004141037,'1',NULL,0,'','0'),
(637,NULL,'Остапчук Марія',NULL,'2017-08-16',NULL,380661169857,NULL,2056477364,'1',NULL,0,'','0'),
(638,NULL,'Стельмах Галя',NULL,'2017-08-16',NULL,380975410654,NULL,2083704407,'1',NULL,0,'','0'),
(639,NULL,'Біла Іра',NULL,NULL,'Dk9290GbGHtS4eOG4qaM8g==',380666562362,NULL,1362627525,'1',43935,0,'','0'),
(640,0717,'Тур Ірина',NULL,NULL,'TyU4H4XvuYV4aGiKMnJUlw==',380975553750,NULL,1685149825,'1',38495,0,'','0'),
(641,NULL,'Слонь Таня',NULL,'2017-08-17',NULL,380671423368,NULL,1714967851,'1',NULL,0,'','0'),
(642,0791,'Талац Люда',NULL,NULL,NULL,380981254300,NULL,1430849701,'1',NULL,0,'','0'),
(643,NULL,'Чайка Соломія',NULL,NULL,NULL,380509157969,NULL,1539199823,'1',NULL,0,'','0'),
(644,NULL,'Чайка Ірина',NULL,'2017-08-17',NULL,380966225805,NULL,2065538621,'1',26792,0,'','0'),
(645,NULL,'Ванджура Марія',NULL,'2017-08-17',NULL,380978398367,NULL,1896342606,'1',NULL,0,'','0'),
(646,NULL,'Кошута Алла',NULL,'2017-08-17',NULL,380975258711,NULL,1587517900,'1',NULL,0,'','0'),
(647,0287,'Мандзяк Таня',NULL,NULL,NULL,380673512720,NULL,1466610654,'1',NULL,0,'','0'),
(648,NULL,'Мележик Леся',NULL,'2017-08-17','uqXYkT4Kdy67w1sCkkKv6g==',380679917585,NULL,1269505268,'1',24195,0,'','0'),
(649,NULL,'Кулик Таня',NULL,'2017-08-18',NULL,380686572336,NULL,1588861818,'1',NULL,0,'','0'),
(650,NULL,'Анонійчук Таня',NULL,'2017-08-18',NULL,380995517255,NULL,1542558330,'1',NULL,0,'','0'),
(651,NULL,'Крижанівська Оля',NULL,'2017-08-18',NULL,380979351608,NULL,1651437084,'1',NULL,0,'','0'),
(652,0212,'Бойчук Роксолана',NULL,NULL,NULL,380987944655,NULL,1486415994,'1',NULL,0,'','0'),
(653,NULL,'Іваськів Оксана',NULL,'2017-08-18','7TM5QW24GMsfDTQEaptPow==',380969588652,NULL,1540449494,'1',NULL,0,'','0'),
(654,NULL,'Квітко Олена',NULL,'2017-08-18',NULL,380939251520,NULL,1127052587,'1',NULL,0,'','0'),
(655,NULL,'Хома Марія',NULL,'2017-08-18',NULL,380986797508,NULL,1350519421,'1',NULL,0,'','0'),
(656,NULL,'Попадюк Марія',NULL,NULL,NULL,380982528756,NULL,1729182976,'1',NULL,0,'','0'),
(657,NULL,'Попадюк Ганна',NULL,NULL,NULL,NULL,NULL,2019364420,'1',NULL,0,'','0'),
(658,NULL,'Попадюк Оля',NULL,NULL,NULL,NULL,NULL,1672924862,'1',NULL,0,'','0'),
(659,NULL,'Рудько Галя',NULL,'2017-08-19',NULL,380680463269,NULL,1328296543,'1',NULL,0,'','0'),
(660,NULL,'Павловська Наталя',NULL,'2017-08-19',NULL,380677523713,NULL,1882088946,'1',NULL,0,'','0'),
(661,NULL,'Гуцал Олександра',NULL,'2017-08-19',NULL,380978924430,NULL,1144317718,'1',NULL,0,'','0'),
(662,NULL,'Голубяк Марія',NULL,'2017-08-19',NULL,380969739034,NULL,1132483508,'1',NULL,0,'','0'),
(663,NULL,'Гавриськів Іра',NULL,'2017-08-19',NULL,380960480891,NULL,1855243211,'1',NULL,0,'','0'),
(664,NULL,'Голубяк Дарина',NULL,NULL,NULL,NULL,NULL,1360716833,'1',NULL,0,'','0'),
(665,NULL,' Федів Аня',NULL,NULL,NULL,380986039226,NULL,1970625587,'1',NULL,0,'','0'),
(666,NULL,'Єлісєєва Ліля',NULL,'2017-08-19',NULL,380961611233,NULL,1187404025,'1',NULL,0,'','0'),
(667,NULL,'Стець Галина',NULL,'2017-08-19',NULL,380974921881,NULL,1128533353,'1',NULL,0,'','0'),
(668,NULL,'Барчишак Люба',NULL,'2017-08-19',NULL,380975577993,NULL,2052499310,'1',NULL,0,'','0'),
(669,NULL,'Хмелик Оксана',NULL,'2017-08-19','n76zICwr8PNob//TIdgCnw==',380679079843,NULL,2106513290,'1',NULL,0,'','0'),
(670,NULL,'Сідляк Таня',NULL,NULL,NULL,380971279657,NULL,2072453271,'1',NULL,0,'','0'),
(671,0251,'Борик Юля',NULL,NULL,NULL,380661598741,NULL,1957260847,'1',NULL,0,'','0'),
(672,NULL,'Шумельда Наталя',NULL,'2017-08-19',NULL,380986552082,NULL,2052761856,'1',NULL,1,'','0'),
(673,NULL,'Шликова Надія',NULL,'2017-08-19',NULL,380668516182,NULL,1436687161,'1',NULL,0,'','0'),
(674,NULL,'Гречана Руслана',NULL,'2017-08-19',NULL,380967918501,NULL,1934238166,'1',NULL,0,'','0'),
(675,NULL,'Король Оксана',NULL,'2017-08-19',NULL,380977685927,NULL,2067320996,'1',NULL,0,'','0'),
(676,NULL,'Слоїк Настя',NULL,NULL,NULL,NULL,NULL,1807350354,'1',NULL,0,'','0'),
(677,NULL,'Міговка Настя',NULL,NULL,'+BLWWxm0dG5AkQCN/0l9Nw==',380973381768,NULL,1112191435,'1',11955,0,'','0'),
(678,NULL,'Семчишин Наталя',NULL,'2017-08-19',NULL,380978408007,NULL,1298160202,'1',NULL,0,'','0'),
(679,NULL,'Міговка Оксана',NULL,NULL,NULL,NULL,380671227824,1781833031,'1',NULL,0,'','0'),
(680,NULL,'Кухарчук Наталя',NULL,'2017-08-19','Oo1N2VOkRTgpEk4OzrGHww==',380977208777,NULL,1152460118,'1',57296,0,'','0'),
(681,NULL,'Тимочко Аліна',NULL,'2017-08-19',NULL,380679150553,NULL,1972518862,'1',NULL,1,'','0'),
(682,NULL,'Кравець Оля',NULL,'2017-08-19',NULL,380983512848,NULL,1448194015,'1',NULL,0,'','0'),
(683,NULL,'Кравець Марія',NULL,'2017-08-19',NULL,380675802532,NULL,1592079817,'1',NULL,2,'','0'),
(684,NULL,'Гуменюк Настя',NULL,'2017-08-19',NULL,380672892803,NULL,1225344756,'1',NULL,0,'','0'),
(685,NULL,'Курець Вікторія',NULL,'2017-08-19',NULL,380734967727,NULL,1775023739,'1',NULL,0,'','0'),
(686,NULL,'Сузанська Оксана',NULL,NULL,NULL,380966232763,NULL,1860035154,'1',19623,0,'','0'),
(687,NULL,'Пацкович Даша',NULL,'2017-08-19',NULL,380961194348,NULL,1363458008,'1',NULL,0,'','0'),
(688,0122,'Косоговська Уляна',NULL,NULL,NULL,380507148194,NULL,1414165274,'1',NULL,0,'','0'),
(689,NULL,'Гулічка*',NULL,NULL,NULL,380686257498,NULL,1216998132,'1',NULL,0,'','0'),
(690,0112,'Мазурик Галина',NULL,NULL,NULL,380972289164,NULL,1644713628,'1',NULL,0,'','0'),
(691,NULL,'Бурейко Віка',NULL,'2017-08-19',NULL,380685810395,NULL,1910409512,'1',NULL,0,'','0'),
(692,NULL,'Кавчук Наталя',NULL,NULL,NULL,380988892424,NULL,1619790622,'1',NULL,0,'','0'),
(693,NULL,'Сінотрусова Світлана',NULL,'2017-08-19',NULL,380680326013,NULL,1383578101,'1',NULL,0,'','0'),
(694,NULL,'Яківчук Саша',NULL,'2017-08-19',NULL,380951557840,NULL,1519314103,'1',NULL,0,'','0'),
(695,NULL,'Наконічевська Олена',NULL,'2017-08-19',NULL,380989260908,NULL,1479063238,'1',NULL,0,'','0'),
(696,NULL,'Гальчук Світлана',NULL,NULL,NULL,380973410988,NULL,1590166102,'1',NULL,0,'','0'),
(697,NULL,'Олійник Галя',NULL,'2017-08-19',NULL,380978422992,NULL,1325792623,'1',NULL,0,'','0'),
(698,NULL,'Мендер Яна',NULL,NULL,NULL,NULL,NULL,1199907341,'1',NULL,0,'','1'),
(699,NULL,'Соковська Антоніна',NULL,'2017-08-19',NULL,380970541916,NULL,1740716028,'1',52054,1,'','0'),
(700,NULL,'Цвігун  Іра',NULL,NULL,'tbpHxl+WmauvL02Hau/fPg==',380677674709,NULL,2099110660,'1',13669,0,'','0'),
(701,NULL,'Бабійчук Наталя',NULL,NULL,NULL,NULL,NULL,1298559384,'1',NULL,0,'','0'),
(702,NULL,'Гульчак Оля',NULL,'2017-08-21',NULL,380977740754,NULL,1506502519,'1',23370,0,'','0'),
(703,NULL,'Крупка Ілона',NULL,'2017-08-21',NULL,380967116613,NULL,1534695521,'1',NULL,0,'','0'),
(704,0092,'Дехтяренко Наталя',NULL,NULL,NULL,380979095552,NULL,1739925589,'1',59985,0,'','0'),
(705,NULL,'Головата Діана',NULL,'2017-08-21',NULL,380980187389,NULL,2008482875,'1',NULL,0,'','0'),
(706,NULL,'Петрик Ірина',NULL,'2017-08-21',NULL,380978907339,NULL,1151551995,'1',NULL,0,'','0'),
(707,NULL,'Іващенко Олена',NULL,'2017-08-21',NULL,380984893539,NULL,1815566181,'1',NULL,0,'','0'),
(708,NULL,'Іващенко Марина',NULL,'2017-08-21',NULL,380984893538,NULL,1133556006,'1',NULL,0,'','0'),
(709,NULL,'Воробйова Світлана',NULL,'2017-08-22',NULL,380993752551,NULL,1975791648,'1',NULL,0,'','0'),
(710,NULL,'Вах Маряна',NULL,NULL,NULL,380680204928,NULL,2036592541,'1',NULL,0,'','0'),
(711,NULL,'Орлик Маряна',NULL,'2017-08-22',NULL,380989476716,NULL,1175055290,'1',NULL,0,'','0'),
(712,NULL,'Слухиньська Ілона',NULL,NULL,'Mn/OodCeajAQUrlIetoMUA==',380689473773,NULL,2107961293,'1',14079,0,'','0'),
(713,0705,'Шкільнюк Таня',NULL,NULL,NULL,380683334198,NULL,1639247807,'1',NULL,0,'','0'),
(714,NULL,'Клименюк Світлана',NULL,'2017-08-22',NULL,380931339088,NULL,1119442433,'1',NULL,0,'','0'),
(715,NULL,'Прокопів Надія',NULL,'2017-08-22',NULL,380689764574,NULL,1246220588,'1',NULL,0,'','0'),
(716,NULL,'Бойчук Галя',NULL,'2017-08-22','ZIpX7oQoSfxRABpdmP+fUQ==',380984569524,NULL,1239444519,'1',NULL,2,'','0'),
(717,NULL,'Орлик Христя',NULL,'2017-08-22',NULL,380663661731,NULL,1639700717,'1',NULL,0,'','0'),
(718,NULL,'Вербовецька Анджеліка',NULL,'2017-08-22',NULL,380988580485,NULL,1235405612,'1',NULL,0,'','0'),
(719,NULL,'Бакаленко Ірина',NULL,'2017-08-22',NULL,380980225792,NULL,1663793863,'1',NULL,0,'','0'),
(720,NULL,'Тимочко Марія',NULL,'2017-08-22','CtVc6Pb8urQKWHBj4uH+Hg==',380673076453,NULL,1582173178,'1',NULL,1,'','0'),
(721,0909,'Ягольницька Маряна',NULL,NULL,NULL,380969852702,NULL,1414111685,'1',NULL,0,'','0'),
(722,NULL,'Король Галя',NULL,'2017-08-22',NULL,380987707748,NULL,1869262034,'1',NULL,0,'','0'),
(723,NULL,'Мельник Наталя',NULL,'2017-08-22',NULL,380987572135,NULL,1658374709,'1',NULL,0,'','0'),
(724,NULL,'Харевич Оксана',NULL,'2017-08-22',NULL,380660799178,NULL,1907372169,'1',NULL,0,'','0'),
(725,NULL,'Волощук Ліда',NULL,'2017-08-23',NULL,380679969642,NULL,1568100601,'1',NULL,0,'','0'),
(726,NULL,'Губяк Роксолана',NULL,NULL,NULL,380680550102,NULL,1186477515,'1',NULL,0,'','0'),
(727,0655,'Ясінська Аліна',NULL,NULL,NULL,380979898074,NULL,1202427824,'1',NULL,0,'','0'),
(728,NULL,'Коцан Наталя',NULL,'2017-08-24',NULL,380973420016,NULL,1986577655,'1',NULL,0,'','0'),
(729,NULL,'Поліщук Олена',NULL,'2017-08-24',NULL,380968705742,NULL,2139695637,'1',NULL,0,'','0'),
(730,NULL,'Андрусик Оля',NULL,'2017-08-24',NULL,380968909732,NULL,1168476774,'1',NULL,0,'','0'),
(731,NULL,'Петричко Марія',NULL,'2017-08-24',NULL,380686263647,NULL,1324428192,'1',NULL,0,'','0'),
(732,NULL,'Чухрій Люба',NULL,'2017-08-24',NULL,380671328004,NULL,1749890385,'1',NULL,0,'','0'),
(733,NULL,'Скорина Іванна',NULL,NULL,NULL,380989260988,NULL,1642008152,'1',NULL,0,'','0'),
(734,NULL,'Бабин  Аня',NULL,NULL,NULL,380966674500,NULL,1769682554,'1',NULL,0,'','0'),
(735,NULL,'Бабин Аня',NULL,NULL,NULL,380989008510,NULL,2137806594,'1',NULL,0,'','0'),
(736,NULL,'Лещишин Леся',NULL,NULL,NULL,380934428145,NULL,1606702602,'1',NULL,0,'','0'),
(737,NULL,'Кульба Іра',NULL,'2017-08-24',NULL,380502298144,NULL,2035321238,'1',NULL,1,'','0'),
(738,0305,'Гусяк Наталя',NULL,NULL,NULL,380979684064,NULL,1535877963,'1',17217,2,'','0'),
(739,NULL,'Гнатишин Таня',NULL,'2017-08-25','CJECLautWBFplSgo4ywZPg==',380974541311,NULL,1207652335,'1',41584,0,'','0'),
(740,NULL,'Свергун Леся',NULL,'2017-08-25',NULL,380674959641,NULL,1836501904,'1',NULL,0,'','0'),
(741,NULL,'Ліпніцька Марія',NULL,NULL,NULL,380990229637,NULL,1687047265,'1',NULL,0,'','0'),
(742,NULL,'Дяк Оксана',NULL,'2017-08-25',NULL,380671570170,NULL,2132672189,'1',NULL,0,'','0'),
(743,NULL,'мельничук юля',NULL,'2017-08-25',NULL,380961822473,NULL,1802380941,'1',NULL,0,'','0'),
(744,NULL,'Маришева Христина',NULL,NULL,NULL,380971934311,NULL,1601932208,'1',NULL,0,'','0'),
(745,NULL,'Маришева Галина',NULL,'2017-08-25',NULL,380663790593,NULL,1481196371,'1',NULL,0,'','0'),
(746,NULL,'Гринчук Діана',NULL,'2017-08-25',NULL,380685294902,NULL,1842426831,'1',NULL,0,'','0'),
(747,NULL,'Гнатишин Галина',NULL,'2017-08-25',NULL,380966512932,NULL,1609532664,'1',NULL,0,'','0'),
(748,NULL,'Султанова Люба',NULL,'2017-08-25',NULL,380502337591,NULL,1386236287,'1',NULL,0,'','0'),
(749,NULL,'Кишкан Наталя',NULL,'2017-08-25',NULL,380971486757,NULL,2071459460,'1',NULL,0,'','0'),
(750,NULL,'Кудла Оля',NULL,'2017-08-25',NULL,380686471400,NULL,1723093755,'1',NULL,0,'','0'),
(751,0307,'Лозінська Наталя',NULL,NULL,NULL,380688583238,NULL,2142723293,'1',NULL,0,'','0'),
(752,NULL,'Батюк Ліля',NULL,'2017-08-25',NULL,380684211787,NULL,1420474409,'1',NULL,1,'','0'),
(753,NULL,'мельник юля',NULL,'2017-08-25',NULL,380988032825,NULL,1323547249,'1',NULL,0,'','0'),
(754,NULL,'Билиця Галина',NULL,'2017-08-25',NULL,380683344115,NULL,1385617687,'1',NULL,0,'','0'),
(755,NULL,'салук оксана',NULL,'2017-08-26',NULL,380966098706,NULL,1620504402,'1',NULL,0,'','0'),
(756,NULL,'Дорошенко Таня',NULL,'2017-08-26',NULL,380971483256,NULL,1615323843,'1',60176,0,'','0'),
(757,NULL,'Бойчук Марія',NULL,'2017-08-26',NULL,380989746480,NULL,1977957151,'1',NULL,0,'','0'),
(758,NULL,'Цала Настя',NULL,'2017-08-26',NULL,380965167987,NULL,2087616460,'1',NULL,0,'','0'),
(759,NULL,'скирта ліза',NULL,NULL,NULL,380979232684,NULL,1428044860,'1',NULL,1,'','0'),
(760,NULL,'Мулик Антоніна',NULL,'2017-08-26',NULL,380989898772,NULL,2087236356,'1',NULL,0,'','0'),
(761,NULL,'Цимбалюк Надя',NULL,NULL,NULL,380668006044,NULL,1902578009,'1',NULL,0,'','0'),
(762,NULL,'Цимбалюк Наталя',NULL,'2017-08-26',NULL,380950357932,NULL,1397576375,'1',NULL,0,'','0'),
(763,NULL,'Журавель Наталя',NULL,'2017-08-26',NULL,380971353603,NULL,2055636937,'1',NULL,0,'','0'),
(764,NULL,'Стадничук Наталя',NULL,NULL,NULL,380688467283,NULL,2110037392,'1',NULL,0,'','0'),
(765,NULL,'Вуйчик Світлана',NULL,'2017-08-26',NULL,380686245629,NULL,1400283064,'1',NULL,0,'','0'),
(766,0501,'Сивак Інна',NULL,NULL,'nrMNIaeMsognEiwcforZSQ==',380686245645,NULL,1503489989,'1',NULL,0,'','0'),
(767,NULL,'Бричинська Марина',NULL,'2017-08-26',NULL,380995028187,NULL,1221376115,'1',NULL,0,'','0'),
(768,NULL,'Бобола Леся',NULL,'2017-08-28',NULL,380672993894,NULL,1910141621,'1',NULL,1,'','0'),
(769,NULL,'Сушинська Надя',NULL,'2017-08-28',NULL,380979817787,NULL,1292079297,'1',NULL,0,'','0'),
(770,NULL,'Павлінська Іра',NULL,NULL,'MzQr8cbBYHL0R3EuxG6KYQ==',380986616187,NULL,1940529161,'1',41142,0,'','0'),
(771,NULL,'Гнатишин Христина',NULL,'2017-08-28','urcI7bpdx0NafbP6IbnPCQ==',380688179628,NULL,1804644501,'1',51685,0,'','0'),
(772,0523,'Поселюжна Зоряна',NULL,NULL,NULL,380977167267,NULL,1150372414,'1',NULL,0,'','0'),
(773,NULL,'Городецька Люда',NULL,'2017-08-28',NULL,380672729651,NULL,1403360027,'1',12850,0,'','0'),
(774,NULL,'Вербіцька Марта',NULL,'2017-08-28',NULL,380632213973,NULL,2122877055,'1',NULL,0,'','0'),
(775,NULL,'Опихана Анастасія',NULL,NULL,NULL,380980236184,NULL,1979236097,'1',NULL,0,'','0'),
(776,NULL,'Бойчук Уляна',NULL,'2017-08-28',NULL,380687631851,NULL,1412007347,'1',NULL,0,'','0'),
(777,NULL,'Журавська Світлана',NULL,'2017-08-28',NULL,380987473539,NULL,1587493147,'1',NULL,0,'','0'),
(778,0242,'Журавська Юля',NULL,NULL,NULL,380680204889,NULL,2010072359,'1',NULL,0,'','0'),
(779,NULL,'Задушинська Аня',NULL,'2017-08-28',NULL,380938606867,NULL,1482453474,'1',NULL,0,'','0'),
(780,NULL,'Круць Катя',NULL,'2017-08-29',NULL,380964349661,NULL,1723485156,'1',30330,0,'','0'),
(781,0923,'Музика Леся',NULL,NULL,NULL,380975449475,NULL,1850951492,'1',NULL,1,'','0'),
(782,NULL,'Бінковська Софія ',NULL,NULL,NULL,380976676031,NULL,1966675106,'1',NULL,0,'','0'),
(783,NULL,'Ямнюк Ірина',NULL,'2017-08-29',NULL,380986288584,NULL,1532079378,'1',NULL,0,'','0'),
(784,NULL,'Золота Оксана',NULL,'2017-08-29',NULL,380978808781,NULL,1111316997,'1',NULL,0,'','0'),
(785,NULL,'Бик Наталя',NULL,'2017-08-29',NULL,380970713092,NULL,1148538657,'1',NULL,0,'','0'),
(786,NULL,'Бурак Таня',NULL,'2017-08-29',NULL,380961905365,NULL,1504910546,'1',NULL,0,'','0'),
(787,NULL,'Бурак Люба',NULL,'2017-08-29',NULL,380676187348,NULL,1154848046,'1',NULL,0,'','0'),
(788,NULL,'Дерій Світлана',NULL,'2017-08-29',NULL,380676021328,NULL,1601346184,'1',NULL,0,'','0'),
(789,NULL,'Кумірова Ольга',NULL,'2017-08-29',NULL,380961005474,NULL,1437527875,'1',NULL,0,'','0'),
(790,0285,'Шостак Оксана',NULL,NULL,NULL,380973843011,NULL,1369973764,'1',NULL,0,'','0'),
(791,NULL,'Главацька Яна',NULL,'2017-08-29',NULL,380974982441,NULL,1154056108,'1',NULL,0,'','0'),
(792,NULL,'Непотас Альона',NULL,'2017-08-29',NULL,380995036981,NULL,1643124304,'1',NULL,0,'','0'),
(793,NULL,'Поповська Галя',NULL,'2017-08-29',NULL,380666462286,NULL,2047204302,'1',NULL,0,'','0'),
(794,NULL,'Гордій Христина',NULL,'2017-08-29',NULL,380974984310,NULL,1937733063,'1',NULL,0,'','0'),
(795,0317,'Свінтковська Аліна',NULL,NULL,NULL,380986490054,NULL,1748339829,'1',NULL,0,'','0'),
(796,NULL,'Гикава Марія',NULL,'2017-08-29','9zhZimzxxaYssddljXz6Cg==',380976868398,NULL,1400910866,'1',NULL,0,'','0'),
(797,NULL,'Пожернюк Ліда',NULL,'2017-08-29',NULL,380680063334,NULL,1404434692,'1',NULL,0,'','0'),
(798,NULL,'Заєць Оля',NULL,'2017-08-29',NULL,380986449565,NULL,1448653830,'1',NULL,0,'','0'),
(799,NULL,'Кальмук Альона',NULL,NULL,'j3uToE9PTPzzuwZteHbnoA==',380688525936,NULL,1625660077,'1',48517,2,'','0'),
(800,NULL,'Лесишак Юля',NULL,NULL,NULL,380936453989,NULL,1866293539,'1',NULL,0,'','0'),
(801,NULL,'Качмар Іра',NULL,'2017-08-29',NULL,380672768000,NULL,1689119151,'1',NULL,0,'','0'),
(802,NULL,'Чорнявська Тетяна',NULL,'2017-08-29','CELvsa4S1EylhVcnL56bRw==',380951325360,NULL,1612125002,'1',12743,0,'','0'),
(803,NULL,'Фартушинська Таня',NULL,'2017-08-30',NULL,380984650482,NULL,1708689297,'1',13928,0,'','0'),
(804,NULL,'Копчик Галина',NULL,'2017-08-30',NULL,380971313054,NULL,1919494375,'1',NULL,0,'','0'),
(805,NULL,'Підгірняк Олена',NULL,'2017-08-30',NULL,380672569415,NULL,1963369116,'1',NULL,0,'','0'),
(806,NULL,'Пеняк Олеся',NULL,'2017-08-30',NULL,380961718828,NULL,1809114399,'1',NULL,0,'','0'),
(807,NULL,'Ткачук Люба',NULL,NULL,NULL,380974968921,NULL,1590609299,'1',NULL,0,'','0'),
(808,NULL,'Дембіцька Марія',NULL,'2017-08-30',NULL,380680097270,NULL,1988513869,'1',NULL,0,'','0'),
(809,0246,'Коленич Наталя',NULL,'2017-08-30',NULL,380993893940,NULL,1850995426,'1',NULL,0,'','0'),
(810,NULL,'Корчинська Катя',NULL,'2017-08-30',NULL,380684248229,NULL,1732324795,'1',NULL,0,'','0'),
(811,NULL,'Безгуда Люба',NULL,'2017-08-30',NULL,380686455626,NULL,1879269374,'1',NULL,0,'','0'),
(812,0299,'Костецька Наталя',NULL,NULL,NULL,380951503027,NULL,1125667140,'1',NULL,2,'','0'),
(813,NULL,'Борейко Руслана',NULL,'2017-08-30',NULL,380677200257,NULL,1327183827,'1',NULL,0,'','0'),
(814,NULL,'Мазяр Аліна',NULL,'2017-08-30',NULL,380967937171,NULL,2111532418,'1',NULL,0,'','0'),
(815,NULL,'Жук Іра',NULL,'2017-08-30',NULL,380974858530,NULL,1167522307,'1',25575,0,'','0'),
(816,NULL,'Чепига Маша',NULL,'2017-08-30',NULL,380681508388,NULL,1746864555,'1',NULL,0,'','0'),
(817,NULL,'Осьмак Іра',NULL,'2017-08-30',NULL,380971174476,NULL,1380802384,'1',NULL,0,'','0'),
(818,NULL,'Стадничук Маряна',NULL,NULL,NULL,380963729981,NULL,1884545097,'1',NULL,0,'','0'),
(819,NULL,'Гнатківська Наталя',NULL,NULL,'8uLbvwzEWk2yDsIRo5fePw==',380977102516,380666540967,1503750240,'1',NULL,0,'','0'),
(820,0236,'Боднар Іра',NULL,'2017-08-30',NULL,380689696093,NULL,1664057362,'1',NULL,0,'','0'),
(821,NULL,'Сєдова Наталя',NULL,'2017-08-30',NULL,380661263097,NULL,1211688039,'1',NULL,0,'','0'),
(822,NULL,'Камуль Ліля',NULL,'2017-08-31',NULL,380978243665,NULL,1474149872,'1',NULL,0,'','0'),
(823,NULL,'Зазуляк Леся',NULL,'2017-08-31',NULL,380969153969,NULL,1540793905,'1',NULL,0,'','0'),
(824,NULL,'Качур Олександра',NULL,'2017-08-31',NULL,380959187366,NULL,1605261181,'1',NULL,0,'','0'),
(825,NULL,'Сверида Наталя',NULL,'2017-08-31',NULL,380678145226,NULL,1372613440,'1',NULL,0,'','0'),
(826,NULL,'Гевко Христина',NULL,NULL,NULL,380686497975,NULL,1176178000,'1',NULL,0,'','1'),
(827,NULL,'Кицканюк Світлана',NULL,'2017-08-31',NULL,380966621332,NULL,1623682279,'1',NULL,0,'','0'),
(828,0210,'Біланик Наталя',NULL,'2017-08-31',NULL,380989009800,NULL,1540124421,'1',NULL,0,'','0'),
(829,NULL,'Совяк Наталя',NULL,'2017-08-31','5id6gw1vM4h9O94TiJw49w==',380989210145,NULL,1358483696,'1',14042,0,'','0'),
(830,NULL,'Прокопів Таня',NULL,'2017-08-31',NULL,380968614711,NULL,1671182420,'1',NULL,0,'','0'),
(831,NULL,'Старик Наталя',NULL,NULL,NULL,380962300324,NULL,1693053126,'1',NULL,0,'','0'),
(832,NULL,'Батрин Валентина',NULL,NULL,NULL,380989379697,NULL,1695779663,'1',NULL,0,'','0'),
(833,NULL,'Рудик Галина',NULL,'2017-08-31',NULL,380986222027,NULL,1236681255,'1',NULL,0,'','0'),
(834,NULL,'Польова Роксолана',NULL,'2017-08-31',NULL,380680549263,NULL,1245592469,'1',NULL,0,'','0'),
(835,0162,'Кушнерюк Віра',NULL,NULL,'zzLBh78MjYzqCn/qQuKi0A==',380992746060,NULL,1849149258,'1',NULL,0,'','0'),
(836,NULL,'Чубей Таня',NULL,NULL,NULL,380961126998,NULL,1287882319,'1',NULL,0,'','0'),
(837,NULL,'Лехман Іра',NULL,'2017-08-31',NULL,380979701918,NULL,2036610872,'1',63457,0,'','0'),
(838,NULL,'Ясінчук Марія',NULL,'2017-08-31',NULL,380972139994,NULL,1837517595,'1',NULL,0,'','0'),
(839,NULL,'Онищук Ліля',NULL,'2017-08-31',NULL,380677645345,NULL,1246626857,'1',NULL,0,'','0'),
(840,NULL,'Коваль Христина',NULL,'2017-09-01',NULL,380986378847,NULL,1674681372,'1',NULL,0,'','0'),
(841,NULL,'Коваль Надя',NULL,'2017-09-01',NULL,380976398499,NULL,1792276625,'1',NULL,0,'','0'),
(842,NULL,'Андрусик Марія',NULL,NULL,NULL,NULL,NULL,1186503377,'1',NULL,0,'','0'),
(843,NULL,' Фірман Христина ',NULL,'2017-09-01',NULL,380960689803,NULL,1749492348,'1',NULL,0,'','0'),
(844,0729,'Задорожна Іванна',NULL,NULL,NULL,380971365206,NULL,1818404953,'1',NULL,0,'','0'),
(845,NULL,'Гадомська Марія',NULL,'2017-09-01',NULL,380986110574,NULL,1326472418,'1',NULL,0,'','0'),
(846,NULL,'Завійська Аліна',NULL,'2017-09-01',NULL,380686637715,NULL,1474078414,'1',NULL,0,'','0'),
(847,NULL,'Шпиньова Христина',NULL,'2017-09-01',NULL,380976486947,NULL,1344565626,'1',NULL,0,'','0'),
(848,NULL,'Цимбаліста Олена',NULL,NULL,NULL,380689580793,NULL,1205065108,'1',NULL,0,'','0'),
(849,NULL,'Дерій Наталя',NULL,NULL,NULL,380971411916,NULL,2032288013,'1',NULL,0,'','0'),
(850,NULL,'Синюк Галина',NULL,'2017-09-01',NULL,380960754647,NULL,1809649601,'1',NULL,0,'','0'),
(851,NULL,'Юрків Валентина',NULL,'2017-09-01',NULL,380979066088,NULL,1186126346,'1',NULL,0,'','0'),
(852,NULL,'Нагайовська Іванка',NULL,'2017-09-01',NULL,380660377955,NULL,1292345112,'1',NULL,0,'','0'),
(853,NULL,'Недільська Оксана',NULL,'2017-09-01',NULL,380689663588,NULL,1764302746,'1',NULL,0,'','0'),
(854,NULL,'Осьмак Таня',NULL,'2017-09-01',NULL,380680547688,NULL,1870880751,'1',12980,0,'','0'),
(855,NULL,'Павлюк Алла',NULL,NULL,NULL,380666560701,NULL,1466789725,'1',NULL,0,'','0'),
(856,NULL,'Хмелик Богдан',NULL,'2017-09-01',NULL,380679572501,NULL,1348052630,'1',NULL,0,'','0'),
(857,0893,'Калиній Софія',NULL,NULL,NULL,380989206726,NULL,2000637740,'1',NULL,0,'','0'),
(858,NULL,'Гороновська Олена',NULL,'2017-09-01',NULL,380502014414,NULL,2078465231,'1',NULL,0,'','0'),
(859,NULL,'Коверська Галина',NULL,NULL,NULL,380680325824,NULL,1832801759,'1',NULL,0,'','0'),
(860,NULL,'Гордій Марія',NULL,NULL,NULL,380684213593,NULL,1319364579,'1',NULL,0,'','0'),
(861,NULL,'Свергун Маряна',NULL,NULL,NULL,NULL,NULL,1580447819,'1',NULL,0,'','1'),
(862,NULL,'Максимишин Ірина',NULL,'2017-09-02',NULL,380681457524,NULL,2010647515,'1',NULL,0,'','0'),
(863,NULL,'Шляпінська Христина',NULL,NULL,NULL,380983424517,NULL,1875775793,'1',NULL,0,'','0'),
(864,NULL,'Гира Марія',NULL,NULL,'C9Wi+4QfnNYqbsizMdZ6DQ==',380966412116,NULL,1756421562,'1',NULL,0,'','0'),
(865,NULL,'Нагірняк Ірина',NULL,'2017-09-02',NULL,380960269899,NULL,1205531359,'1',NULL,0,'','0'),
(866,NULL,'Костик Юля',NULL,'2017-09-04',NULL,380975993474,NULL,1503020783,'1',NULL,0,'','0'),
(867,NULL,'Костик Марія',NULL,'2017-09-04',NULL,380986290361,NULL,1661095304,'1',NULL,0,'','0'),
(868,NULL,'Забіяка Марія',NULL,'2017-09-04',NULL,380679848202,NULL,2015338119,'1',NULL,0,'','0'),
(869,0082,'Письмена Наталя',NULL,NULL,NULL,380684296435,NULL,1620211862,'1',NULL,0,'','0'),
(870,NULL,'Мартинюк Марія',NULL,'2017-09-04',NULL,380977004517,NULL,2065893790,'1',NULL,0,'','0'),
(871,NULL,'Горішна Юля',NULL,'2017-09-04',NULL,380971128179,NULL,2090906580,'1',NULL,0,'','0'),
(872,NULL,'Ландяк Наталя',NULL,'2017-09-04',NULL,380975704261,NULL,1146699759,'1',NULL,0,'','0'),
(873,NULL,'Ярош Оксана',NULL,'2017-09-04',NULL,380983286218,NULL,1112079212,'1',NULL,0,'','0'),
(874,NULL,'Бойко Неля',NULL,'2017-09-04',NULL,380968284415,NULL,2085717279,'1',NULL,0,'','0'),
(875,NULL,'Єременко Таня',NULL,'2017-09-04',NULL,380967195502,NULL,1679244342,'1',NULL,0,'','0'),
(876,NULL,'Божевська Діана',NULL,NULL,NULL,380971299379,NULL,1929879051,'1',NULL,0,'','0'),
(877,NULL,'Черевата Таня',NULL,'2017-09-04',NULL,380986600037,NULL,1296983406,'1',NULL,0,'','0'),
(878,0677,'Сиротинська Інна',NULL,NULL,'FPq8yDmz+eVinqReeXrkEw==',380680463302,NULL,1208414515,'1',34768,0,'','0'),
(879,NULL,'Ланова Наталя',NULL,'2017-09-04',NULL,380988826161,NULL,1979764106,'1',NULL,0,'','0'),
(880,NULL,'Чернецька Христина',NULL,NULL,NULL,380673046520,NULL,1185968433,'',13668,0,'','0'),
(881,NULL,'Манорик Христина',NULL,NULL,NULL,380982469802,380673217928,1698010170,'1',NULL,0,'','0'),
(882,NULL,'Гевко Оля',NULL,'2017-09-04',NULL,380638284241,NULL,1875172070,'1',NULL,0,'','0'),
(883,NULL,'Луцишин Наталя',NULL,NULL,NULL,NULL,NULL,1750856982,'1',NULL,0,'','1'),
(884,NULL,'Тапчак Таня',NULL,NULL,NULL,380671400946,NULL,1555198034,'1',NULL,0,'','0'),
(885,NULL,'Гарбуз Маряна',NULL,'2017-09-05',NULL,380972578279,NULL,1472199642,'1',NULL,0,'','0'),
(886,NULL,'Габура Оксана',NULL,'2017-09-05',NULL,380674584331,NULL,1982363398,'1',NULL,0,'','0'),
(887,NULL,'Григорук Таня',NULL,'2017-09-05',NULL,380936795818,NULL,2051282889,'1',NULL,0,'','0'),
(888,NULL,'Макара Оля',NULL,'2017-09-05',NULL,380969686826,NULL,1550929406,'1',15939,0,'','0'),
(889,NULL,'Махніцька Ярина',NULL,'2017-09-05',NULL,380961091516,NULL,1183804895,'1',NULL,0,'','0'),
(890,NULL,'Молодиня Наталя',NULL,'2017-09-05',NULL,380687355708,NULL,1636859526,'1',NULL,0,'','0'),
(891,NULL,'Денькович Олена',NULL,'2017-09-05',NULL,380976854207,NULL,1902260872,'1',NULL,0,'','0'),
(892,NULL,'Денисюк Наталя',NULL,'2017-09-05',NULL,380678494004,NULL,1456684963,'1',NULL,0,'','0'),
(893,NULL,'Плюсква Оля',NULL,'2017-09-05',NULL,380680122046,NULL,1383919679,'1',NULL,0,'','0'),
(894,NULL,'Когут Наталя',NULL,'2017-09-05',NULL,380983509120,NULL,1928174353,'1',NULL,0,'','0'),
(895,NULL,'Осадчук Іванка',NULL,'2017-09-05',NULL,380674151086,NULL,1215148343,'1',NULL,0,'','0'),
(896,0182,'Берик Юля',NULL,NULL,NULL,380989417503,NULL,1311956446,'1',65093,0,'','0'),
(897,0142,'Фундитус Люда',NULL,NULL,NULL,380963869381,NULL,2131108652,'1',NULL,0,'','0'),
(898,0733,'Смітюх Зоряна',NULL,NULL,NULL,380970781207,NULL,1475296911,'1',NULL,0,'','0'),
(899,NULL,'Тавій Оксана',NULL,'2017-09-06',NULL,380968744608,NULL,1309307474,'1',NULL,0,'','0'),
(900,NULL,'Гриндула Алла',NULL,'2017-09-06',NULL,380955344464,NULL,2117899076,'1',NULL,0,'','0'),
(901,NULL,'Смук Надія',NULL,NULL,NULL,380971236884,NULL,2031825790,'1',NULL,0,'','0'),
(902,NULL,'Пожарнюк Оксана',NULL,'2017-09-06',NULL,380981015987,NULL,1759957918,'1',NULL,0,'','0'),
(903,NULL,'Мостівська Ліля',NULL,'2017-09-06',NULL,380986467422,NULL,1794162836,'1',NULL,0,'','0'),
(904,NULL,'Мазур Іванна',NULL,'2017-09-06',NULL,380963477520,NULL,1568011712,'1',NULL,0,'','0'),
(905,NULL,'Стахів Іванка',NULL,NULL,NULL,380678486975,NULL,1677583544,'1',NULL,0,'','0'),
(906,NULL,'Дячок Галина',NULL,'2017-09-06',NULL,380973420166,NULL,2014117143,'1',NULL,0,'','0'),
(907,NULL,'Морквас Маряна',NULL,'2017-09-07',NULL,380665073850,NULL,1459118272,'1',NULL,0,'','0'),
(908,NULL,'Вербіцька Ірина',NULL,'2017-09-07',NULL,380677401535,NULL,1299954447,'1',NULL,0,'','0'),
(909,NULL,'Нікішенкова Лєна',NULL,'2017-09-07',NULL,380975879844,NULL,1130064643,'1',NULL,0,'','0'),
(910,NULL,'Котик Софія',NULL,'2017-09-07',NULL,380979202173,NULL,1305396542,'1',NULL,0,'','0'),
(911,NULL,'Віка',NULL,'2017-09-07',NULL,380976030976,NULL,1432087483,'1',NULL,0,'','0'),
(912,NULL,'ГРецьків Світлана',NULL,'2017-09-07',NULL,380684245108,NULL,1931477205,'1',NULL,0,'','0'),
(913,NULL,'Осадча Марія',NULL,'2017-09-07',NULL,380976869349,NULL,1646316791,'1',NULL,1,'','0'),
(914,NULL,'Лесак Оксана',NULL,'2017-09-07',NULL,380976114579,NULL,1310004150,'1',NULL,0,'','0'),
(915,NULL,'Малаховська Наталія ',NULL,'2017-09-07',NULL,380660100565,NULL,1600362378,'1',26967,0,'','0'),
(916,NULL,'Міх Сніжана',NULL,'2017-09-07',NULL,380988629215,NULL,1553222885,'1',NULL,0,'','0'),
(917,NULL,'Міх Надія',NULL,'2017-09-07',NULL,380972316551,NULL,1201827829,'1',NULL,0,'','0'),
(918,NULL,'Васютина Настя',NULL,'2017-09-07',NULL,380952540868,NULL,1617759348,'1',NULL,0,'','0'),
(919,NULL,'Вівчарик Таня',NULL,'2017-09-07',NULL,380934761623,NULL,1726437686,'1',NULL,0,'','0'),
(920,NULL,'Шашко Світлана',NULL,'2017-09-08',NULL,380962597300,NULL,1773525892,'1',NULL,0,'','0'),
(921,0707,'Петльована Галина',NULL,NULL,NULL,380976977721,NULL,2044755959,'1',50066,0,'','0'),
(922,NULL,'Луцишин Христина',NULL,'2017-09-08',NULL,380989883549,NULL,1717375274,'1',NULL,0,'','0'),
(923,NULL,'Шафан Люба',NULL,'2017-09-08',NULL,380688426891,NULL,1663602897,'1',NULL,0,'','0'),
(924,NULL,'ШклярТаня',NULL,NULL,'tB3OGSjE2wuX+49r3Af2Sg==',380993231222,NULL,1426026418,'1',18110,0,'','0'),
(925,NULL,'Сендзюк Оксана',NULL,'2017-09-08',NULL,380679228146,NULL,1482393764,'1',NULL,0,'','0'),
(926,NULL,'Левкович Іванна',NULL,'2017-09-08',NULL,380999093961,NULL,2031296854,'1',NULL,0,'','0'),
(927,NULL,'Матвієшин Галина',NULL,'2017-09-08',NULL,380684297297,NULL,1867825538,'1',NULL,0,'','0'),
(928,NULL,'Нера Таня',NULL,'2017-09-08',NULL,380973583062,NULL,1313206570,'1',NULL,0,'','0'),
(929,0134,'Бабин Ніна',NULL,NULL,NULL,380978385530,NULL,1851804964,'1',NULL,0,'','0'),
(930,NULL,'Гевко Олена',NULL,NULL,NULL,380970935306,NULL,1384860670,'1',58404,2,'','0'),
(931,NULL,'Баковська Оксана',NULL,'2017-09-08',NULL,380675852481,NULL,1575020585,'1',NULL,0,'','0'),
(932,NULL,'Слота Оля',NULL,'2017-09-08',NULL,380978169361,NULL,2104368636,'1',NULL,0,'','0'),
(933,NULL,'Качмар Оксана',NULL,'2017-09-08',NULL,380966556000,NULL,1133046925,'1',NULL,0,'','0'),
(934,NULL,'Качмар Марія',NULL,'2017-09-08',NULL,380986661587,NULL,1853407759,'1',NULL,0,'','0'),
(935,NULL,'Марія Матієк',NULL,'2017-09-08',NULL,380961106762,NULL,1997624633,'1',NULL,0,'','0'),
(936,0521,'Брода Олександра',NULL,NULL,NULL,380960868819,NULL,1745336571,'1',59634,1,'','0'),
(937,0565,'Віра Батрин',NULL,NULL,NULL,380989810403,NULL,1620735434,'1',NULL,1,'','0'),
(938,NULL,'Вололимр',NULL,'2017-09-08',NULL,380966398490,NULL,1395527700,'1',NULL,0,'','0'),
(939,NULL,'Федорків Юля',NULL,'2017-09-08',NULL,380977112429,NULL,1638462949,'1',NULL,0,'','0'),
(940,NULL,'Черепюк Оксана',NULL,'2017-09-08',NULL,380987030719,NULL,2012998751,'1',NULL,0,'','0'),
(941,NULL,'Осипян Сніжана',NULL,'2017-09-09',NULL,380980370188,NULL,1737945095,'1',NULL,0,'','0'),
(942,NULL,'Марія Козенчук',NULL,'2017-09-09',NULL,380685120403,NULL,1935244115,'1',NULL,0,'','0'),
(943,NULL,'Рудик Саша',NULL,'2017-09-09',NULL,380976220458,NULL,1376810940,'1',NULL,0,'','0'),
(944,NULL,'Слухинська Алла',NULL,NULL,'M1OZmM6YwTzYT+Qdjl5zTw==',380985827840,NULL,1649225564,'1',30963,0,'','0'),
(945,NULL,'Білавчук Настя',NULL,NULL,NULL,380957084418,NULL,1748327051,'1',NULL,0,'','0'),
(946,NULL,'Безкоровайна Христина',NULL,NULL,NULL,380980475052,NULL,1579428033,'1',NULL,0,'','0'),
(947,NULL,'Віка Наша',NULL,NULL,NULL,NULL,NULL,1955190087,'1',NULL,0,'','0'),
(948,NULL,'Оленка Наша',NULL,NULL,NULL,3,NULL,1495332058,'1',NULL,0,'','0'),
(949,NULL,'Наталя Наша',NULL,NULL,NULL,NULL,NULL,2044144919,'1',NULL,2,'','0'),
(950,NULL,'Люда Наша',NULL,NULL,NULL,NULL,NULL,1392006230,'1',NULL,0,'','0'),
(951,NULL,'Настя Наша',NULL,NULL,NULL,NULL,NULL,1924151378,'',NULL,0,'','0'),
(952,NULL,'Миколаївна',NULL,NULL,NULL,NULL,NULL,1312052566,'1',NULL,1,'','0'),
(953,NULL,'Маша Наша',NULL,NULL,NULL,NULL,NULL,1843035960,'1',NULL,1,'','0'),
(954,NULL,'Лесик',NULL,NULL,NULL,380988775964,NULL,1524307273,'1',NULL,0,'','0'),
(955,NULL,'Делійовська Зоряна',NULL,'2017-09-11',NULL,380971348605,NULL,1926120951,'1',NULL,0,'','0'),
(956,NULL,'Пельвецька Аліна',NULL,'2017-09-11',NULL,380986157916,NULL,2140894364,'1',NULL,0,'','0'),
(957,NULL,'Кузь Юля',NULL,'2017-09-11',NULL,380685574707,NULL,1807323922,'1',NULL,0,'','0'),
(958,NULL,'Кузь Олеся',NULL,'2017-09-11',NULL,380683577961,NULL,1721333751,'1',NULL,0,'','0'),
(959,NULL,'Сулило Таня',NULL,NULL,NULL,380660488115,NULL,2104451065,'1',NULL,0,'','0'),
(960,NULL,'Стасишин Ірина',NULL,'2017-09-11',NULL,380991888404,NULL,1114029412,'1',NULL,0,'','0'),
(961,NULL,'Нагрибецька Оксана',NULL,'2017-09-11',NULL,380672513092,NULL,2074194610,'1',NULL,0,'','0'),
(962,NULL,'Бурник Таня',NULL,'2017-09-11',NULL,380989633475,NULL,1140605188,'1',NULL,0,'','0'),
(963,NULL,'Ващак Святослав',NULL,'2017-09-11',NULL,380968573583,NULL,1772895611,'1',NULL,0,'','0'),
(964,NULL,'Яринюк Таня',NULL,'2017-09-11',NULL,380685722176,NULL,1560430884,'1',NULL,0,'','0'),
(965,NULL,'Дунда Діана',NULL,NULL,NULL,380988106960,NULL,1849346247,'1',NULL,0,'','0'),
(966,NULL,'Скотніцька Марія',NULL,'2017-09-11',NULL,380669684395,NULL,1224675099,'1',NULL,0,'','0'),
(967,NULL,'Ксюха Наша',NULL,NULL,NULL,NULL,NULL,1821194771,'1',NULL,0,'','0'),
(968,NULL,'пивовар оксана',NULL,NULL,NULL,380673532990,NULL,2100532057,'1',NULL,0,'','0'),
(969,NULL,'Поповська Настя',NULL,'2017-09-11',NULL,380985704528,NULL,1718188767,'1',NULL,0,'','0'),
(970,NULL,'Голик Віка',NULL,'2017-09-11',NULL,380673502210,NULL,1468942709,'1',NULL,0,'','0'),
(971,NULL,'Яримовська Наталя',NULL,'2017-09-12','LF3YJ/5aGa7iK+F8WuE1eA==',380680117307,NULL,1314786357,'1',19179,0,'','0'),
(972,NULL,'Стримбіцька Наталя',NULL,NULL,NULL,380672995095,NULL,2028984225,'1',NULL,0,'','0'),
(973,NULL,'Конциграда Наталя',NULL,'2017-09-12',NULL,380973299364,NULL,1216528419,'1',NULL,2,'','0'),
(974,NULL,'Пахончак Оксана',NULL,'2017-09-12',NULL,380503773534,NULL,1381337855,'1',NULL,0,'','0'),
(975,NULL,'Лаба Наталя',NULL,NULL,NULL,380673392487,NULL,1855872616,'',NULL,0,'','0'),
(976,NULL,'Шкробут Оксана',NULL,'2017-09-12',NULL,380967559377,NULL,1843727416,'1',NULL,0,'','0'),
(977,0102,'Юля Южда',NULL,NULL,NULL,380974154341,NULL,1175564755,'1',52571,0,'','0'),
(978,NULL,'Топольницька Іра',NULL,NULL,NULL,NULL,380682684709,1894232717,'1',NULL,0,'','0'),
(979,NULL,'Кульгавець Таня',NULL,'2017-09-12',NULL,380680549420,NULL,1585102891,'1',NULL,0,'','0'),
(980,NULL,'Мальована Надія',NULL,NULL,NULL,380976397057,NULL,1869664292,'1',NULL,0,'','0'),
(981,NULL,'Дребіт  Іра',NULL,NULL,NULL,380987213314,NULL,1258846855,'1',NULL,0,'','0'),
(982,NULL,'Яніцька Надя',NULL,'2017-09-12',NULL,380686722589,NULL,1565228311,'1',NULL,0,'','0'),
(983,NULL,'Старик Іванна',NULL,'2017-09-12','NPub+CnSikgTivKxrRFPNw==',380958441985,NULL,1646419068,'1',NULL,0,'','0'),
(984,NULL,'Бадіна Вероніка',NULL,'2017-09-12',NULL,380957940216,NULL,1872609335,'1',NULL,0,'','0'),
(985,NULL,'Пасечко Оля',NULL,NULL,NULL,380682464586,NULL,1953311226,'1',NULL,0,'','0'),
(986,NULL,'Сало Леся',NULL,'2017-09-13',NULL,380989594603,NULL,1747931767,'1',NULL,0,'','0'),
(987,NULL,'Токарюк Стефа',NULL,'2017-09-13',NULL,380961837039,NULL,1341008815,'1',NULL,0,'','0'),
(988,NULL,'Верста Олена',NULL,'2017-09-13',NULL,380960517171,NULL,1240771057,'1',NULL,0,'','0'),
(989,NULL,'Слободян Таня',NULL,'2017-09-13',NULL,380683238812,NULL,1171809428,'1',NULL,0,'','0'),
(990,NULL,'Кулик Христина',NULL,'2017-09-13',NULL,380976074278,NULL,1220386727,'1',NULL,0,'','0'),
(991,NULL,'Діана Дубик',NULL,'2017-09-13',NULL,380967599905,NULL,1539027105,'1',NULL,0,'','0'),
(992,0695,'Марія Гатеж',NULL,NULL,NULL,380966072465,NULL,1420651741,'1',NULL,0,'','0'),
(993,NULL,'Дядів Ганна',NULL,'2017-09-13',NULL,380672721690,NULL,1243274147,'1',NULL,0,'','0'),
(994,NULL,'Карвацька Оля',NULL,'2017-09-13',NULL,380686296799,NULL,1560350115,'1',NULL,0,'','0'),
(995,NULL,'Кірківська Надя',NULL,'2017-09-13',NULL,380970163410,NULL,1974837579,'1',NULL,0,'','0'),
(996,NULL,'Гуменюк Юля',NULL,NULL,NULL,380966436199,NULL,1620053687,'1',NULL,0,'','0'),
(997,NULL,'Кузяк Юля',NULL,'2017-09-13',NULL,380980410094,NULL,1666820697,'1',NULL,0,'','0'),
(998,NULL,'Микитин Надія',NULL,NULL,NULL,380961667714,NULL,1894428516,'1',NULL,0,'','0'),
(999,NULL,'Назарак Марія',NULL,NULL,NULL,380969941823,NULL,1281173562,'1',NULL,0,'','0');

INSERT INTO `kontragentu` VALUES 
(1000,NULL,'Тезікова Леся',NULL,'2017-09-14',NULL,380686261297,NULL,2049504176,'1',NULL,0,'','0'),
(1001,NULL,'Левчук Наталя',NULL,'2017-09-14',NULL,380673517450,NULL,1294748240,'1',NULL,0,'','0'),
(1002,NULL,'Геба Юля',NULL,'2017-09-14',NULL,380979732033,NULL,1226136479,'1',NULL,0,'','0'),
(1003,0513,'Бойчук Настя',NULL,NULL,NULL,380661241852,NULL,1810902783,'1',NULL,0,'','0'),
(1004,NULL,'Бойчук Ірина',NULL,'2017-09-14',NULL,380661181381,NULL,1652360207,'1',NULL,0,'','0'),
(1005,NULL,'Шевчук Марія',NULL,NULL,NULL,380681129100,NULL,1330399031,'1',NULL,2,'','0'),
(1006,NULL,'Ракета Наталя',NULL,'2017-09-14',NULL,380682385470,NULL,1219529699,'1',NULL,0,'','0'),
(1007,NULL,'Крупка Аліна',NULL,'2017-09-14',NULL,380509182895,NULL,1306380922,'1',NULL,0,'','0'),
(1008,NULL,'Бойчук Надія',NULL,'2017-09-14',NULL,380979032195,NULL,1787323461,'1',NULL,1,'','0'),
(1009,NULL,'Гладка Наталя',NULL,NULL,NULL,380972293301,NULL,1392533459,'1',NULL,0,'','0'),
(1010,NULL,'Дмитрук Людмила',NULL,'2017-09-15','vXVFTCy2pU5J3jDCPvM/sg==',380961107454,NULL,1468074393,'1',NULL,0,'','0'),
(1011,NULL,'Наталя Зубік',NULL,'2017-09-15',NULL,380967828039,NULL,1717639682,'1',NULL,0,'','0'),
(1012,NULL,'кавчук наталя',NULL,'2017-09-15',NULL,380986475173,NULL,1282082440,'1',NULL,0,'','0'),
(1013,NULL,'Гарбуз Христина',NULL,'2017-09-15',NULL,380987701824,NULL,1621766010,'1',NULL,0,'','0'),
(1014,NULL,'Абель Наталя',NULL,'2017-09-15','oZmxcHWW99by9Wy3g5xdTg==',380967478250,NULL,1522660172,'1',64758,1,'','0'),
(1015,NULL,'Костюк Аня',NULL,'2017-09-16',NULL,380986538068,NULL,1530943407,'1',NULL,0,'','0'),
(1016,NULL,'Мединська Людмила',NULL,'2017-09-16',NULL,380964793454,NULL,1536180107,'1',NULL,0,'','0'),
(1017,NULL,'Смотрич Оксана',NULL,'2017-09-16',NULL,380978104736,NULL,1906477430,'1',NULL,0,'','0'),
(1018,0931,'Дроздова Ліля ',NULL,NULL,NULL,380675263788,NULL,2041264982,'1',NULL,0,'','0'),
(1019,NULL,'Гановська Марія',NULL,'2017-09-16',NULL,380980215634,NULL,1830669293,'1',NULL,0,'','0'),
(1020,NULL,'Чепига Ірина',NULL,NULL,NULL,380505361964,NULL,1460085241,'1',NULL,0,'','0'),
(1021,NULL,'Іванців Іра',NULL,'2017-09-16',NULL,380937262763,NULL,1446193470,'1',NULL,0,'','0'),
(1022,NULL,'Дідик  Кароліна',NULL,NULL,NULL,380962937801,NULL,1312775761,'1',12128,3,'','0'),
(1023,NULL,'Галюк Олена',NULL,NULL,NULL,380973415328,NULL,1270432052,'1',NULL,0,'','0'),
(1024,NULL,'Семенюк Ліля',NULL,'2017-09-18',NULL,380633573180,NULL,1687231176,'1',NULL,0,'','0'),
(1025,NULL,'Якубяк Оля',NULL,'2017-09-18',NULL,380991920893,NULL,1547145064,'1',NULL,0,'','0'),
(1026,0329,'Софія Нова пошта',NULL,NULL,'zpTMeLH02/em4m1n8LpImw==',380677736799,NULL,1673755559,'1',NULL,1,'','0'),
(1027,NULL,'Березовська Наталя',NULL,'2017-09-18','1jZaOx6OlW+ohyglYncr1w==',380987741969,NULL,1549491856,'1',NULL,0,'','0'),
(1028,NULL,'Кушик Ірина',NULL,'2017-09-18',NULL,380675254601,NULL,1671893990,'1',NULL,0,'','0'),
(1029,NULL,'Кульба Ліля',NULL,NULL,'S4lRCGxr5+FC0DCkS9JjHw==',380951151887,NULL,1268589875,'0',62796,1,'','0'),
(1030,NULL,'Циганкова Олена',NULL,'2017-09-18',NULL,380996757656,NULL,1530108410,'1',NULL,0,'','0'),
(1031,NULL,'Садовська Марія',NULL,'2017-09-18',NULL,380975024536,NULL,1834480508,'1',NULL,0,'','0'),
(1032,NULL,'Василишин Ганна',NULL,'2017-09-18',NULL,380982235345,NULL,2072316376,'1',NULL,0,'','0'),
(1033,NULL,'Батирова Олександра',NULL,'2017-09-19',NULL,380991337344,NULL,1992293276,'1',NULL,0,'','0'),
(1034,NULL,'Лисай Оксана',NULL,'2017-09-19',NULL,380982308947,NULL,1208033274,'1',NULL,0,'','0'),
(1035,NULL,'Лесів Христина',NULL,'2017-09-19',NULL,380991330051,NULL,2050924479,'1',NULL,0,'','0'),
(1036,0172,'Махневич Зоряна',NULL,NULL,NULL,NULL,380969855898,1992745476,'1',NULL,0,'','0'),
(1037,0737,'Наконечна Настя',NULL,NULL,NULL,380983591743,NULL,1910768197,'1',NULL,0,'','0'),
(1038,NULL,'Новак Галина',NULL,NULL,NULL,380978369185,NULL,1681589541,'1',NULL,0,'','0'),
(1039,NULL,'Дикун Христина',NULL,'2017-09-19',NULL,380986140218,NULL,1891632610,'1',NULL,0,'','0'),
(1040,NULL,'голодрига Галя',NULL,NULL,NULL,380977112452,NULL,1538921006,'1',NULL,1,'','0'),
(1041,NULL,'Венгринович Світлана',NULL,'2017-09-19',NULL,380957944852,NULL,1718872467,'1',NULL,0,'','0'),
(1042,NULL,'Свистун Христина',NULL,'2017-09-19',NULL,380689021987,NULL,1322625234,'1',NULL,0,'','0'),
(1043,NULL,'Коленич Руслан',NULL,'2017-09-19',NULL,380990096499,NULL,1653955501,'1',NULL,0,'','0'),
(1044,NULL,'Буц Оля',NULL,'2017-09-20',NULL,380969078432,NULL,1708496171,'1',56404,0,'','0'),
(1045,NULL,'Приємська Таня',NULL,'2017-09-20',NULL,380687290824,NULL,1764048505,'1',NULL,0,'','0'),
(1046,NULL,'Винничук Маряна',NULL,'2017-09-20',NULL,380984058195,NULL,1203083979,'1',NULL,0,'','0'),
(1047,NULL,'Дирій Марія',NULL,'2017-09-20','STsYP94j62Oy4m2EtkIIlA==',380971599383,NULL,1528661335,'1',41314,0,'','0'),
(1048,NULL,'Марія Нілінговська',NULL,'2017-09-20',NULL,380680463227,NULL,2063316005,'1',NULL,0,'','0'),
(1049,0647,'Парадовська Іра',NULL,NULL,'1K14pBAJ8kLIEaWh6L6Ijg==',380981295849,NULL,1202275132,'1',45049,1,'','0'),
(1050,NULL,'Байгорич Таня',NULL,'2017-09-20',NULL,380687618789,NULL,2069651675,'1',NULL,0,'','0'),
(1051,NULL,'Надія Обліжок',NULL,'2017-09-20',NULL,380964904581,NULL,1725868498,'1',NULL,0,'','0'),
(1052,NULL,'Дріблюк Олеся',NULL,'2017-09-20',NULL,380995635379,NULL,1623328505,'1',NULL,0,'','0'),
(1053,NULL,'Романюк Зіна',NULL,NULL,NULL,380684628063,NULL,1669308235,'1',NULL,0,'','0'),
(1054,0333,'Миронюк Катя',NULL,NULL,'ImsYMfUJG47Q1ikenTBhDQ==',380993317708,NULL,1193070528,'1',NULL,0,'','0'),
(1055,0295,'Карпець Маряна',NULL,NULL,NULL,380978554749,NULL,1451357737,'1',NULL,0,'','0'),
(1056,NULL,'Нес Леся',NULL,NULL,NULL,NULL,NULL,1816730924,'1',NULL,0,'','1'),
(1057,NULL,'Койдер Уляна',NULL,'2017-09-22',NULL,380978084702,NULL,1776179484,'1',NULL,0,'','0'),
(1058,NULL,'Шквара Анастасія',NULL,NULL,NULL,NULL,NULL,1744810411,'1',NULL,0,'','1'),
(1059,NULL,'Домбровська Іра',NULL,'2017-09-22',NULL,380983848895,NULL,2018317279,'1',NULL,0,'','0'),
(1060,NULL,'Сорока Діана',NULL,'2017-09-22',NULL,380675948080,NULL,1599112958,'1',NULL,0,'','0'),
(1061,NULL,'Дуда Оля',NULL,'2017-09-22',NULL,380979993402,NULL,2090721870,'1',NULL,0,'','0'),
(1062,NULL,'Цепів Вікторія',NULL,'2017-09-22',NULL,380937606094,NULL,1621390317,'1',NULL,0,'','0'),
(1063,NULL,'Вітів Надія',NULL,'2017-09-23',NULL,380973715210,NULL,1263460959,'1',NULL,0,'','0'),
(1064,NULL,'Ковпак Оксана',NULL,'2017-09-23',NULL,380976114578,NULL,1209148354,'1',NULL,0,'','0'),
(1065,NULL,'Медик Світлана',NULL,'2017-09-23',NULL,380971062834,NULL,1841537093,'1',NULL,0,'','0'),
(1066,0735,'Мороз Інна',NULL,NULL,NULL,380976857399,NULL,1452632770,'1',49179,0,'','0'),
(1067,NULL,'Марія Волоцька',NULL,'2017-09-23',NULL,380964893793,NULL,1910040725,'1',NULL,0,'','0'),
(1068,NULL,'',NULL,NULL,NULL,NULL,NULL,1719249720,'1',NULL,0,'','0'),
(1069,NULL,'Ольга Лісова',NULL,'2017-09-23',NULL,380673010839,NULL,1710664259,'1',NULL,0,'','0'),
(1070,NULL,'Король Ліля',NULL,'2017-09-23',NULL,380993451359,NULL,1729179659,'1',NULL,0,'','0'),
(1071,NULL,'Лавриновська Світлана',NULL,'2017-09-23',NULL,380989267621,NULL,1527455985,'1',NULL,0,'','0'),
(1072,NULL,'ластівка аліна',NULL,'2017-09-23',NULL,380967936459,NULL,1879404426,'1',NULL,0,'','0'),
(1073,NULL,'Бажовська Світлана',NULL,'2017-09-23',NULL,380988401406,NULL,1440309898,'1',NULL,0,'','0'),
(1074,NULL,'Присяжна Аліна',NULL,'2017-09-25',NULL,380955710724,NULL,1163061873,'1',NULL,0,'','0'),
(1075,NULL,'Ваврик Галя',NULL,'2017-09-25',NULL,380674224329,NULL,1131025276,'1',NULL,0,'','0'),
(1076,NULL,'Зарицька Віка',NULL,'2017-09-25',NULL,380971361859,NULL,1326077461,'1',NULL,0,'','0'),
(1077,NULL,'Багрій Катя',NULL,'2017-09-25',NULL,380962423019,NULL,1804944432,'1',NULL,0,'','0'),
(1078,NULL,'Патера Ліля',NULL,NULL,NULL,380961311564,NULL,1750995248,'1',NULL,0,'','0'),
(1079,NULL,'Клопотюк Наталя',NULL,'2017-09-25',NULL,380688177850,NULL,1439376599,'1',NULL,0,'','0'),
(1080,NULL,'Осадчук Інна',NULL,'2017-09-25',NULL,380689689782,NULL,1230750890,'1',NULL,0,'','0'),
(1081,0727,'Герасимович Зоряна',NULL,NULL,NULL,380688343396,NULL,1931758667,'1',NULL,0,'','0'),
(1082,NULL,'Герасимович Галина',NULL,'2017-09-25',NULL,380972879388,NULL,1345750522,'1',NULL,0,'','0'),
(1083,NULL,'Чекамова Аліна',NULL,NULL,NULL,380986607132,NULL,2093248133,'1',NULL,0,'','0'),
(1084,NULL,'Мізерота Наталя',NULL,NULL,NULL,380974122477,NULL,1533427996,'1',NULL,0,'','0'),
(1085,0232,'Бандура Леся',NULL,NULL,NULL,380674956629,NULL,1900613694,'1',NULL,1,'','0'),
(1086,NULL,'Середа Світлана',NULL,'2017-09-25',NULL,380988321424,NULL,1659713586,'1',NULL,0,'','0'),
(1087,NULL,'Шута Оля',NULL,NULL,NULL,380986705081,NULL,1624222136,'1',NULL,0,'','0'),
(1088,NULL,'Шафран Люба',NULL,'2017-09-26',NULL,380688426291,NULL,2120912803,'1',NULL,0,'','0'),
(1089,NULL,'Пелат Іра',NULL,'2017-09-26',NULL,380686299090,NULL,1537266033,'1',NULL,0,'','0'),
(1090,NULL,'Пирожик Аліна',NULL,NULL,NULL,380976393952,NULL,1617156524,'1',NULL,0,'','0'),
(1091,NULL,'Орисюк Сніжана',NULL,'2017-09-26',NULL,380976583410,NULL,1724222884,'1',NULL,0,'','0'),
(1092,NULL,'Дрогомирецька Марія',NULL,NULL,NULL,380683237848,NULL,1135182359,'1',NULL,0,'','0'),
(1093,NULL,'божаковська наталя',NULL,'2017-09-26',NULL,830931278448,NULL,1466144295,'1',NULL,0,'','0'),
(1094,NULL,'Ірина Ревуцька',NULL,'2017-09-26',NULL,380686950860,NULL,2081938054,'1',NULL,0,'','0'),
(1095,NULL,'Нагірняк Роксолана',NULL,NULL,NULL,380681129109,NULL,1495999903,'1',NULL,0,'','0'),
(1096,NULL,'Найко Аня',NULL,'2017-09-26',NULL,380676021762,NULL,1599905961,'1',NULL,0,'','0'),
(1097,NULL,'Швець Васелина',NULL,NULL,NULL,380962707202,NULL,1971041462,'1',28405,2,'','0'),
(1098,NULL,'Рибчук Маряна',NULL,'2017-09-26',NULL,380970600868,NULL,1421948549,'1',NULL,0,'','0'),
(1099,NULL,'Мелимука Ірина',NULL,'2017-09-26',NULL,380968544787,NULL,2053049531,'1',NULL,0,'','0'),
(1100,NULL,'Вовчук Марія ',NULL,'2017-09-26',NULL,380986467429,NULL,1963236803,'1',NULL,0,'','0'),
(1101,NULL,'Гавриш Таня',NULL,'2017-09-26',NULL,380980276420,NULL,2138970162,'1',NULL,0,'','0'),
(1102,0679,'Сливчук Христина',NULL,NULL,NULL,380676886206,NULL,2093320167,'1',NULL,0,'','0'),
(1103,0291,'Салаш Настя',NULL,NULL,NULL,380674196041,NULL,1402370455,'1',NULL,0,'','0'),
(1104,NULL,'Верещук Наталя',NULL,NULL,NULL,380685297208,NULL,2068626519,'1',NULL,0,'','0'),
(1105,NULL,'Мах Наталя',NULL,'2017-09-27',NULL,380963853183,NULL,1151901270,'1',NULL,0,'','0'),
(1106,NULL,'Волоська Інна',NULL,'2017-09-27',NULL,380997735618,NULL,1513182944,'1',NULL,0,'','0'),
(1107,NULL,'Гевко Марія',NULL,'2017-09-27',NULL,380978706800,NULL,1391753379,'1',NULL,0,'','0'),
(1108,NULL,'Лишак Христна',NULL,'2017-09-27',NULL,380970529619,NULL,1359652625,'1',NULL,0,'','0'),
(1109,NULL,'Смолик Марія',NULL,'2017-09-27',NULL,380954820026,NULL,2054611614,'1',NULL,0,'','0'),
(1110,NULL,'Степан Гнат',NULL,'2017-09-27',NULL,380976989966,NULL,1193246981,'1',NULL,0,'','0'),
(1111,NULL,'Гадомська Люда',NULL,'2017-09-27',NULL,380967254958,NULL,1648719352,'1',NULL,0,'','0'),
(1112,NULL,'Шмадило Оксана',NULL,'2017-09-27',NULL,380967572156,NULL,1309504945,'1',NULL,0,'','0'),
(1113,0313,'совин маряна',NULL,NULL,NULL,380680011120,NULL,1592546621,'1',NULL,0,'','0'),
(1114,NULL,'Світлана Гавриленко',NULL,'2017-09-28',NULL,380680551923,NULL,1580476132,'1',NULL,0,'','0'),
(1115,0277,'Гуменюк Марія',NULL,NULL,NULL,380969224065,NULL,1845626414,'1',NULL,0,'','0'),
(1116,NULL,'Стадник Надія',NULL,'2017-09-28',NULL,380937573220,NULL,1285422361,'1',NULL,0,'','0'),
(1117,NULL,'Чорній Люда',NULL,'2017-09-28',NULL,380979602131,NULL,1249774479,'1',NULL,0,'','0'),
(1118,NULL,'Герчак Уляна',NULL,'2017-09-28',NULL,380968664649,NULL,1791013020,'1',NULL,0,'','0'),
(1119,NULL,'Нога Кристина',NULL,NULL,NULL,380507473299,NULL,1382689996,'1',NULL,0,'','0'),
(1120,NULL,'Дорожинська Олена',NULL,'2017-09-28',NULL,380974491951,NULL,2029719010,'1',64273,0,'','0'),
(1121,NULL,'Циганкова Настя',NULL,'2017-09-28',NULL,380988646686,NULL,1502010016,'1',NULL,1,'','0'),
(1122,NULL,'Коцулин Таня',NULL,'2017-09-28',NULL,380977906215,NULL,1719926103,'1',NULL,0,'','0'),
(1123,NULL,'Ненчин Люба',NULL,'2017-09-28',NULL,380680328196,NULL,1551554100,'1',NULL,0,'','0'),
(1124,0725,'Просинюк Христя',NULL,NULL,NULL,380671185444,NULL,2028189737,'1',NULL,0,'','0'),
(1125,NULL,'Басараба Женя',NULL,'2017-09-28','hZFGfNUxaU7nDbuRaM4eNw==',380970133601,NULL,1198115492,'1',64526,0,'','0'),
(1126,NULL,'Дієва Аня',NULL,'2017-09-29',NULL,380504344778,NULL,1846346917,'1',NULL,0,'','0'),
(1127,NULL,'Котовська Ліда',NULL,'2017-09-29',NULL,380961298549,NULL,1146881853,'1',NULL,0,'','0'),
(1128,NULL,'Собків Оксана',NULL,'2017-09-29',NULL,380676088090,NULL,1643894034,'1',NULL,0,'','0'),
(1129,NULL,'Грекова Галя',NULL,NULL,NULL,380978563956,NULL,1795271340,'1',NULL,0,'','0'),
(1130,NULL,'Свергун Оленка',NULL,'2017-09-29',NULL,380977112494,NULL,2112882004,'1',NULL,0,'','0'),
(1131,NULL,'Безугла Ліля',NULL,'2017-09-29',NULL,380987032057,NULL,1578564018,'1',NULL,0,'','0'),
(1132,NULL,'Панькевич Віта',NULL,'2017-09-30',NULL,380687097549,NULL,1808419074,'1',NULL,0,'','0'),
(1133,NULL,'Кормило Оксана',NULL,'2017-09-30',NULL,380973173117,NULL,1297604967,'1',NULL,0,'','0'),
(1134,0339,'Варгатюк Іра',NULL,NULL,NULL,380686729155,NULL,1688547842,'1',NULL,0,'','0'),
(1135,NULL,'Ткачук Таня',NULL,NULL,NULL,380988266991,NULL,1122751171,'1',28296,0,'','0'),
(1136,NULL,'Скольська Оля',NULL,'2017-10-02',NULL,380951754740,NULL,1469795519,'1',NULL,0,'','0'),
(1137,NULL,'Зацерковна Люда',NULL,'2017-10-02',NULL,380971284167,NULL,1165968001,'1',NULL,0,'','0'),
(1138,NULL,'Вівчарик Світлана',NULL,'2017-10-02',NULL,380978202733,NULL,1350047364,'1',NULL,0,'','0'),
(1139,0741,'Оліярник Марія',NULL,NULL,NULL,380978169469,NULL,1868104612,'1',NULL,0,'','0'),
(1140,NULL,'Федорків Таня',NULL,'2017-10-02',NULL,380680575266,NULL,2008213124,'1',NULL,0,'','0'),
(1141,NULL,'галюк',NULL,'2017-10-02',NULL,380684216304,NULL,1595583620,'1',NULL,0,'','0'),
(1142,0601,'Головатюк Руслана',NULL,NULL,NULL,380989277750,NULL,1479353944,'1',NULL,0,'','0'),
(1143,NULL,'Харук Настя',NULL,NULL,NULL,NULL,NULL,1639513024,'1',NULL,0,'','1'),
(1144,NULL,'Музика Надія',NULL,'2017-10-02',NULL,380986446141,NULL,1621427748,'1',NULL,1,'','0'),
(1145,NULL,'Олійник Зоряна',NULL,'2017-10-02',NULL,380956411798,NULL,1786472270,'1',NULL,0,'','0'),
(1146,NULL,'Сторожук Альона',NULL,'2017-10-02',NULL,380969401293,NULL,1131611435,'1',NULL,0,'','0'),
(1147,NULL,'Коханко Катя',NULL,'2017-10-02',NULL,380963447512,NULL,2114517910,'1',NULL,0,'','0'),
(1148,NULL,'Солецька Юля',NULL,NULL,NULL,380685961682,NULL,1186602496,'1',NULL,0,'','0'),
(1149,NULL,'Шмадило Ірина',NULL,'2017-10-02',NULL,380977748742,NULL,1516879111,'1',NULL,0,'','0'),
(1150,NULL,'Сушанська Зоряна',NULL,'2017-10-02',NULL,380980835252,NULL,1784351093,'1',NULL,0,'','0'),
(1151,NULL,'Власюк Аліна',NULL,'2017-10-03',NULL,380979216526,NULL,2003489373,'1',NULL,0,'','0'),
(1152,NULL,'Пастущак Мирослава',NULL,'2017-10-03','itwds/Ev2frxcCuC8OfhWQ==',380987170580,NULL,1137528300,'1',39963,0,'','0'),
(1153,0074,'Чухрій Олеся',NULL,NULL,NULL,380684248212,NULL,1337013870,'1',NULL,0,'','0'),
(1154,NULL,'Колодніцька Марія',NULL,NULL,NULL,380686296713,NULL,1227326355,'1',NULL,0,'','0'),
(1155,NULL,'Микитин Неля',NULL,'2017-10-03',NULL,380969136373,NULL,1599130726,'1',NULL,0,'','0'),
(1156,NULL,'Пастух Соломія',NULL,'2017-10-03',NULL,380688179761,NULL,1626188588,'1',NULL,0,'','0'),
(1157,NULL,'журба наталя',NULL,'2017-10-03',NULL,380679526433,NULL,1170445243,'1',NULL,0,'','0'),
(1158,NULL,'Мединський Тарас',NULL,'2017-10-04',NULL,380976244980,NULL,1884034109,'1',NULL,0,'','0'),
(1159,NULL,'Ісак Люба',NULL,'2017-10-04',NULL,380682682465,NULL,1129361447,'1',NULL,0,'','0'),
(1160,NULL,'Пиняк Марія',NULL,'2017-10-04',NULL,380980609963,NULL,1362966184,'1',NULL,0,'','0'),
(1161,0309,'Сокальська Марія',NULL,NULL,NULL,380975432856,NULL,1226939590,'1',NULL,0,'','0'),
(1162,NULL,'Олійник Таня',NULL,'2017-10-04',NULL,380971860724,NULL,1826423812,'1',NULL,0,'','0'),
(1163,NULL,'Лєна Наша',NULL,NULL,NULL,NULL,NULL,1542867973,'1',NULL,0,'','0'),
(1164,NULL,'Калин Марина',NULL,'2017-10-04',NULL,380965854453,NULL,1725994638,'1',NULL,0,'','0'),
(1165,NULL,'Кутрик Наталя',NULL,'2017-10-04',NULL,380976729892,NULL,1963892727,'1',NULL,0,'','0'),
(1166,0335,'Равлюк Катя',NULL,NULL,NULL,380666900798,NULL,2071359414,'1',NULL,0,'','0'),
(1167,0301,'Чорпіта Ліля',NULL,NULL,NULL,380680972693,NULL,1688906445,'1',NULL,0,'','0'),
(1168,NULL,'Дроздова Надія',NULL,'2017-10-05',NULL,380986348915,NULL,1872168183,'1',NULL,0,'','0'),
(1169,NULL,'оксана романів',NULL,'2017-10-05',NULL,380986626977,NULL,1411167789,'1',NULL,3,'','0'),
(1170,NULL,'Овод Таня',NULL,NULL,NULL,380981024328,NULL,2072287774,'1',NULL,0,'','0'),
(1171,NULL,'Польова Роксолана',NULL,'2017-10-05',NULL,380962276171,NULL,2023702850,'1',NULL,0,'','0'),
(1172,NULL,'Боднарук Ігор',NULL,'2017-10-05',NULL,380986457381,NULL,1605069503,'1',NULL,0,'','0'),
(1173,NULL,'Бойко Марія',NULL,'2017-10-05',NULL,380686254905,NULL,1607834840,'1',NULL,0,'','0'),
(1174,NULL,'Ліля',NULL,'2017-10-05',NULL,NULL,NULL,1589651499,'1',NULL,0,'','0'),
(1175,NULL,'Ненчин ОЛя',NULL,'2017-10-06',NULL,380674500442,NULL,1394516215,'1',NULL,0,'','0'),
(1176,NULL,'Мамчур Христина',NULL,NULL,NULL,380969582627,NULL,1362992436,'1',NULL,0,'','0'),
(1177,NULL,'Юля Заборна',NULL,'2017-10-06',NULL,380967985233,NULL,2123542863,'1',NULL,0,'','0'),
(1178,NULL,'садовська соломія наша',NULL,NULL,NULL,4,NULL,1947925709,'1',NULL,0,'','0'),
(1179,NULL,'Соломія Наша',NULL,NULL,NULL,NULL,NULL,1711443978,'1',NULL,0,'','0'),
(1180,0188,'Мадей Ірина',NULL,'2017-10-07',NULL,380680954979,NULL,1979649820,'1',NULL,0,'','0'),
(1181,0669,'Старовойт Інна',NULL,NULL,NULL,380964054457,NULL,1763483076,'1',NULL,0,'','0'),
(1182,NULL,'Харук Оля',NULL,'2017-10-07',NULL,380986066779,NULL,1441039692,'1',NULL,0,'','0'),
(1183,NULL,'Лежичко Олена',NULL,'2017-10-09',NULL,380977569321,NULL,2014731918,'1',NULL,0,'','0'),
(1184,NULL,'Витравка Яна',NULL,'2017-10-09',NULL,380982522677,NULL,1208225427,'1',NULL,0,'','0'),
(1185,NULL,'Кайдановська Ліля',NULL,'2017-10-09','O+BN+8P/t2dwPKPSGklR7Q==',380971319656,NULL,1142495235,'1',39635,0,'','0'),
(1186,NULL,'Музика Олександра',NULL,NULL,NULL,NULL,NULL,1694281657,'1',NULL,0,'','1'),
(1187,NULL,'Строцан Іванна',NULL,'2017-10-09',NULL,380973207992,NULL,1231063403,'1',NULL,0,'','0'),
(1188,0739,'Юзків Люба',NULL,NULL,NULL,380982510079,NULL,1596184524,'1',NULL,0,'','0'),
(1189,NULL,'Довбуш Галя',NULL,'2017-10-09',NULL,380684296448,NULL,1904441952,'1',NULL,0,'','0'),
(1190,NULL,'Козлова Діана',NULL,'2017-10-09',NULL,380975282872,NULL,1458459592,'1',NULL,0,'','0'),
(1191,NULL,'Глова Люба',NULL,'2017-10-09',NULL,380951420407,NULL,1250344512,'1',NULL,0,'','0'),
(1192,NULL,'Варгатюк Світлана',NULL,'2017-10-09',NULL,380687244113,NULL,1195268645,'1',NULL,0,'','0'),
(1193,NULL,'Білінська Марія',NULL,'2017-10-10',NULL,380974131810,NULL,2091215627,'1',NULL,0,'','0'),
(1194,NULL,'Мушкалюк Діана',NULL,NULL,NULL,380991861304,NULL,1326100489,'1',NULL,0,'','0'),
(1195,NULL,'Кудрянська Таня',NULL,'2017-10-10',NULL,380669626154,NULL,1978614742,'1',NULL,0,'','0'),
(1196,NULL,'Чубарь Роксолана',NULL,NULL,NULL,380971684057,NULL,1967067990,'1',NULL,0,'','0'),
(1197,0267,'Луців Оля',NULL,NULL,NULL,380686855902,NULL,1150001087,'1',NULL,0,'','0'),
(1198,NULL,'Копчук Люда',NULL,'2017-10-11',NULL,380966848457,NULL,1606845451,'1',NULL,0,'','0'),
(1199,NULL,'Маланчук Марія',NULL,NULL,NULL,380962087899,NULL,1447987133,'1',NULL,0,'','0'),
(1200,NULL,'Чайка Іра',NULL,'2017-10-11',NULL,380974170240,NULL,1235089618,'1',NULL,0,'','0'),
(1201,NULL,'Ватраль Галя',NULL,'2017-10-11',NULL,380970040883,NULL,1367239439,'1',NULL,0,'','0'),
(1202,NULL,'ТИмофій Віта',NULL,'2017-10-11',NULL,380985782325,NULL,1890762874,'1',NULL,0,'','0'),
(1203,NULL,'Коник яна',NULL,'2017-10-11',NULL,380961949247,NULL,2050506534,'1',NULL,0,'','0'),
(1204,NULL,'Сли',NULL,'2017-10-11',NULL,NULL,NULL,1408716633,'1',NULL,0,'','0'),
(1205,NULL,'Гевко Леся',NULL,'2017-10-12',NULL,380978482650,NULL,1550507754,'1',NULL,0,'','0'),
(1206,NULL,'Мостович Христина',NULL,NULL,NULL,380984562116,NULL,1752816046,'1',NULL,0,'','0'),
(1207,0218,'Касіяник Оксана',NULL,NULL,NULL,380967526059,NULL,1793304743,'1',12987,0,'','0'),
(1208,NULL,'Бик Юля',NULL,'2017-10-12',NULL,380978399970,NULL,1709195150,'1',NULL,0,'','0'),
(1209,NULL,'Нартова Ірина',NULL,'2017-10-13',NULL,380671251012,NULL,1169292188,'1',NULL,0,'','0'),
(1210,NULL,'Воробець Надія',NULL,'2017-10-13',NULL,380680499438,NULL,1112497137,'1',NULL,0,'','0'),
(1211,NULL,'Слабіцька Олга',NULL,'2017-10-13',NULL,380936455383,NULL,1703727004,'1',NULL,0,'','0'),
(1212,NULL,'Пахольчак Оксана',NULL,'2017-10-13',NULL,380969598656,NULL,1205866974,'1',NULL,0,'','0'),
(1213,NULL,'Мартинюк Віка',NULL,'2017-10-13',NULL,380636926638,NULL,1463160972,'1',NULL,0,'','0'),
(1214,NULL,'Сампара Ніна',NULL,'2017-10-13',NULL,380972717298,NULL,1975589599,'1',NULL,0,'','0'),
(1215,NULL,'Сагайдак Іра',NULL,'2017-10-13',NULL,380985959737,NULL,1760024362,'1',NULL,0,'','0'),
(1216,NULL,'Гринчишин Аня',NULL,'2017-10-13',NULL,380968157914,NULL,1719187850,'1',NULL,0,'','0'),
(1217,0903,'Корчинська Галя',NULL,NULL,NULL,380983081822,NULL,1640457518,'1',NULL,0,'','0'),
(1218,NULL,'Петруняк Оксана',NULL,'2017-10-14',NULL,380683352637,NULL,1441737355,'1',NULL,0,'','0'),
(1219,NULL,'Кожіковська Маряна',NULL,'2017-10-14',NULL,380971484929,NULL,1214767676,'1',NULL,0,'','0'),
(1220,NULL,'Маша',NULL,'2017-10-15',NULL,NULL,NULL,2102432726,'1',NULL,0,'','0'),
(1221,NULL,'Бдзінзірович Наталя',NULL,'2017-10-16',NULL,380680117309,NULL,1125216103,'1',NULL,0,'','0'),
(1222,NULL,'Семчишин Юля',NULL,'2017-10-16',NULL,380978267342,NULL,1449779046,'1',NULL,0,'','0'),
(1223,NULL,'Шемлей Оля',NULL,'2017-10-16',NULL,380676884921,NULL,1130538283,'1',NULL,0,'','0'),
(1224,NULL,'Михайлюта наталя',NULL,'2017-10-16',NULL,380967589681,NULL,1858296197,'1',NULL,0,'','0'),
(1225,NULL,'Некифорчин Іванна',NULL,NULL,NULL,380988029556,NULL,1859781268,'1',NULL,0,'','1'),
(1226,NULL,'Качур Леся',NULL,'2017-10-17',NULL,380684213579,NULL,1289790092,'1',NULL,0,'','0'),
(1227,NULL,'Кучерська Богдана',NULL,'2017-10-17',NULL,380988327254,NULL,1671498526,'1',52121,7,'','0'),
(1228,0319,'Бігуляк Галя',NULL,NULL,NULL,380678454020,NULL,1186067319,'1',NULL,0,'','0'),
(1229,NULL,'Домбровська Наталя',NULL,'2017-10-17',NULL,380677018855,NULL,1504231506,'1',NULL,0,'','0'),
(1230,NULL,'Молодій Іра',NULL,NULL,NULL,380938415063,NULL,1993660179,'1',NULL,0,'','0'),
(1231,NULL,'Костянтинова Таня',NULL,'2017-10-17',NULL,380976487225,NULL,1935354540,'1',NULL,0,'','0'),
(1232,0271,'Мельник Лілія',NULL,NULL,NULL,380677570012,NULL,2143920635,'1',NULL,0,'','0'),
(1233,NULL,'Кожухарова Олена',NULL,'2017-10-18',NULL,380987707751,NULL,1185997382,'1',NULL,0,'','0'),
(1234,NULL,'Климів Оксанав',NULL,'2017-10-18',NULL,380977617199,NULL,1471262790,'1',NULL,0,'','0'),
(1235,0257,'Будня Зоряна',NULL,NULL,NULL,380672140213,NULL,1551850405,'1',21850,0,'','0'),
(1236,NULL,'Пашко Наталя',NULL,'2017-10-18',NULL,380966637192,NULL,1470979067,'1',NULL,0,'','0'),
(1237,NULL,'Опихана Настя',NULL,'2017-10-18','pBPdFS2NzZmU6uvCojA6Pg==',380994668113,NULL,1372857889,'1',28603,0,'','0'),
(1238,NULL,'Сенів Надія ',NULL,NULL,NULL,380967654115,NULL,1635200561,'1',NULL,0,'','0'),
(1239,NULL,'Турченяк Васелина',NULL,'2017-10-18',NULL,380986665325,NULL,1271090552,'1',NULL,0,'','0'),
(1240,NULL,'Джегус Олександра',NULL,NULL,NULL,380988860583,NULL,1618776572,'1',NULL,0,'','0'),
(1241,NULL,'Шафран Галина',NULL,'2017-10-19',NULL,380676700816,NULL,1417321856,'1',NULL,0,'','0'),
(1242,NULL,'Шевчук  Діана',NULL,NULL,NULL,380684214055,NULL,1997012899,'1',NULL,0,'','0'),
(1243,NULL,'Деркач Христина',NULL,'2017-10-19',NULL,380962195692,NULL,1869257248,'1',NULL,0,'','0'),
(1244,NULL,'Карпович Зоряна',NULL,'2017-10-19',NULL,380683323923,NULL,1492882026,'1',NULL,0,'','0'),
(1245,NULL,'Колодніцька Марія',NULL,'2017-10-19',NULL,380978685635,NULL,1335635181,'1',NULL,0,'','0'),
(1246,NULL,'Швак Олена',NULL,NULL,NULL,380993495214,NULL,1654604883,'1',NULL,0,'','0'),
(1247,NULL,'Муленко Світлана',NULL,NULL,NULL,380993072205,NULL,1665930184,'1',NULL,0,'','0'),
(1248,NULL,'Білик Оксана',NULL,'2017-10-19',NULL,380986769387,NULL,1749890494,'1',NULL,0,'','0'),
(1249,NULL,'Прохорова Анастасія',NULL,'2017-10-20',NULL,380957944909,NULL,1509838410,'1',NULL,0,'','0'),
(1250,NULL,'Новак Юля',NULL,'2017-10-20',NULL,380978550484,NULL,1394746425,'1',NULL,0,'','0'),
(1251,NULL,'Бодьо Люда',NULL,'2017-10-20',NULL,380975839804,NULL,1629751433,'1',31663,0,'','0'),
(1252,NULL,'Сідляк Надія',NULL,'2017-10-20',NULL,380689998327,NULL,1792946093,'1',NULL,0,'','0'),
(1253,NULL,'Віка Наша',NULL,'2017-10-20',NULL,5,NULL,1443728918,'1',NULL,0,'','0'),
(1254,NULL,'Андрієвська Таня',NULL,'2017-10-20',NULL,380966500663,NULL,1586889628,'1',NULL,0,'','0'),
(1255,NULL,'Копецька Таісія',NULL,NULL,NULL,380990204929,NULL,1901891183,'1',NULL,0,'','0'),
(1256,NULL,'Ястремська Тоня',NULL,'2017-10-20',NULL,380993070704,NULL,1203845052,'1',NULL,2,'','0'),
(1257,NULL,'гордій христя',NULL,'2017-10-21',NULL,380688367372,NULL,1740102166,'1',NULL,0,'','0'),
(1258,NULL,'Чорній Ліля',NULL,'2017-10-21',NULL,380984843510,NULL,1777760558,'1',NULL,1,'','0'),
(1259,NULL,'ружило галина',NULL,'2017-10-21',NULL,380989291428,NULL,1283197918,'1',NULL,0,'','0'),
(1260,NULL,'Максимишин Люба',NULL,'2017-10-21','7y921FBhgF/nnfpvZWUNGw==',380684021854,NULL,1296408605,'1',NULL,0,'','0'),
(1261,NULL,'крупська марія',NULL,'2017-10-23',NULL,380683238820,NULL,1663502506,'1',NULL,0,'','0'),
(1262,0663,'Олійник Тетяна',NULL,NULL,NULL,380686292400,NULL,2128879594,'1',NULL,0,'','0'),
(1263,NULL,'Виник Леся',NULL,'2017-10-23',NULL,380986173310,NULL,1327348303,'1',NULL,0,'','0'),
(1264,0347,'Коваль Олена',NULL,NULL,NULL,380987882817,NULL,1935975768,'1',NULL,0,'','0'),
(1265,NULL,'Гришкова Оксана',NULL,'2017-10-23',NULL,380989206655,NULL,1944355949,'1',NULL,0,'','0'),
(1266,NULL,'Гнитишин ОЛя',NULL,NULL,NULL,NULL,NULL,1830440660,'1',NULL,0,'','1'),
(1267,NULL,'Халенич Соломія',NULL,'2017-10-23',NULL,380988211234,NULL,1832158454,'1',NULL,0,'','0'),
(1268,NULL,'Сорокопут Світлана',NULL,NULL,NULL,380506276113,NULL,1128401060,'1',NULL,0,'','0'),
(1269,NULL,'Слободян Наталя',NULL,'2017-10-23',NULL,380686296701,NULL,1857097448,'1',NULL,0,'','0'),
(1270,NULL,'Братак Ірина',NULL,'2017-10-23',NULL,380973078697,NULL,2053254643,'1',NULL,0,'','0'),
(1271,NULL,'Гусак Маряна',NULL,'2017-10-23',NULL,380975495502,NULL,1126002907,'1',NULL,0,'','0'),
(1272,NULL,'Колодій Люда',NULL,'2017-10-24',NULL,380962761977,NULL,1850038158,'1',NULL,0,'','0'),
(1273,NULL,'Кучма Юля',NULL,'2017-10-24',NULL,380979193979,NULL,1617091029,'1',NULL,0,'','0'),
(1274,NULL,'солодка віка',NULL,NULL,NULL,380734835968,NULL,1729751258,'1',NULL,0,'','0'),
(1275,NULL,'Терещенко Уляна',NULL,'2017-10-24',NULL,380672010809,NULL,1486297965,'1',NULL,0,'','0'),
(1276,NULL,'Жолинська Галина',NULL,'2017-10-25',NULL,380671080746,NULL,1271813932,'1',NULL,0,'','0'),
(1277,NULL,'Коліщинська Оксана',NULL,NULL,NULL,380963722645,NULL,1620643144,'1',NULL,0,'','0'),
(1278,NULL,'Фецуляк Настя',NULL,'2017-10-25',NULL,380994559512,NULL,1219030513,'1',NULL,0,'','0'),
(1279,NULL,'Вербіцька Таня',NULL,NULL,NULL,380984652601,NULL,1237688899,'1',NULL,0,'','0'),
(1280,NULL,'Стецишин оксана',NULL,NULL,NULL,380968378999,NULL,2135529288,'1',NULL,0,'','0'),
(1281,NULL,'Гринюк Марія',NULL,'2017-10-25',NULL,380990096625,NULL,1985898985,'1',NULL,0,'','0'),
(1282,NULL,'Ружицька Наталя',NULL,'2017-10-25',NULL,380989997641,NULL,1529036793,'1',NULL,0,'','0'),
(1283,NULL,'Царук Аліна',NULL,'2017-10-26',NULL,380999315085,NULL,1302892285,'1',NULL,0,'','0'),
(1284,NULL,'Лопушняк Оля',NULL,NULL,NULL,380689334217,NULL,1673046334,'1',NULL,0,'','0'),
(1285,NULL,'колужняк Світлана',NULL,'2017-10-26',NULL,380686466476,NULL,1638989865,'1',NULL,0,'','0'),
(1286,NULL,'Босіховська Віта ',NULL,'2017-10-26',NULL,380967513728,NULL,1901194939,'1',NULL,0,'','0'),
(1287,NULL,'Наконечна Ліда',NULL,'2017-10-27',NULL,380633628598,NULL,1853637101,'1',38062,0,'','0'),
(1288,NULL,'кошанська',NULL,'2017-10-27',NULL,380962686460,NULL,1492114402,'1',NULL,0,'','0'),
(1289,NULL,'ситник',NULL,'2017-10-27',NULL,380979915606,NULL,2035584773,'1',NULL,0,'','0'),
(1290,NULL,'Рибін Наталя',NULL,'2017-10-27',NULL,380987648241,NULL,1816366959,'1',NULL,0,'','0'),
(1291,NULL,'Шустик Марія',NULL,'2017-10-27',NULL,380966456795,NULL,1591330073,'1',NULL,0,'','0'),
(1292,NULL,'Троханяк Таня',NULL,'2017-10-27',NULL,380507837743,NULL,1231670027,'1',NULL,0,'','0'),
(1293,NULL,'Танюк Христина',NULL,'2017-10-28',NULL,380960863505,NULL,1583347908,'1',NULL,0,'','0'),
(1294,NULL,'Олійник Іра',NULL,'2017-10-28',NULL,380966087837,NULL,1342698256,'1',NULL,0,'','0'),
(1295,NULL,'Золота Іра',NULL,'2017-10-30',NULL,380983425082,NULL,1194172688,'1',NULL,0,'','0'),
(1296,NULL,'Чопик Леся',NULL,'2017-10-30',NULL,380977532826,NULL,1462219138,'1',NULL,0,'','0'),
(1297,0327,'Холоднюк Іра',NULL,NULL,NULL,380983853196,NULL,2126160689,'1',NULL,0,'','0'),
(1298,NULL,'Івасів МАрія',NULL,'2017-10-30',NULL,380678964938,NULL,1385481472,'1',NULL,0,'','0'),
(1299,NULL,'Ільницька Люда',NULL,'2017-10-30',NULL,380685611588,NULL,1545576483,'1',NULL,0,'','0'),
(1300,NULL,'Боднарук Софія',NULL,'2017-10-30',NULL,380680725247,NULL,1612436694,'1',NULL,0,'','0'),
(1301,NULL,'Стьопіна Іра',NULL,'2017-10-30',NULL,380976725579,NULL,1221057422,'1',NULL,0,'','0'),
(1302,0645,'Туткалюк Юля',NULL,NULL,NULL,380974148733,NULL,1179522365,'1',NULL,0,'','0'),
(1303,NULL,'Берицька Наталя',NULL,'2017-10-31',NULL,380501555954,NULL,2040595000,'1',NULL,0,'','0'),
(1304,NULL,'Совінська Люся',NULL,'2017-10-31',NULL,380988235770,NULL,1717411710,'1',NULL,0,'','0'),
(1305,NULL,'Шиляпінська Таня',NULL,'2017-10-31',NULL,380987312537,NULL,1551695695,'1',NULL,0,'','0'),
(1306,NULL,'Запорожець Марія',NULL,'2017-10-31',NULL,380355264451,NULL,2052971067,'1',NULL,0,'','0'),
(1307,NULL,'Запорожець Юля',NULL,'2017-10-31',NULL,380963200672,NULL,1146344052,'1',NULL,0,'','0'),
(1308,0627,'Яник Марія',NULL,NULL,NULL,380982831816,NULL,2101917808,'1',NULL,0,'','0'),
(1309,NULL,'Сікорська Юля',NULL,'2017-10-31',NULL,380686023438,NULL,1730002859,'1',NULL,1,'','0'),
(1310,NULL,'Телейко Юлія',NULL,'2017-10-31',NULL,380970193358,NULL,1407718186,'1',NULL,0,'','0'),
(1311,NULL,'Креманчк Таня',NULL,NULL,NULL,380982400981,NULL,1325682294,'1',NULL,0,'','0'),
(1312,NULL,'Сосанчин Натяля',NULL,'2017-11-01',NULL,380989679814,NULL,1639411582,'1',NULL,0,'','0'),
(1313,NULL,'Чайка Христина',NULL,'2017-11-01',NULL,380931390323,NULL,1500398617,'1',NULL,0,'','0'),
(1314,NULL,'Курик Аліна',NULL,'2017-11-01',NULL,380976299332,NULL,2123498598,'1',NULL,0,'','0'),
(1315,NULL,'Король Оля',NULL,'2017-11-01',NULL,380982900493,NULL,1741403565,'1',NULL,0,'','0'),
(1316,0323,'Мороз Катя',NULL,NULL,NULL,380678325608,NULL,1747222388,'1',NULL,0,'','0'),
(1317,NULL,'Оля..',NULL,'2017-11-01',NULL,380687507184,NULL,1326663295,'1',NULL,0,'','0'),
(1318,NULL,'Фірман Марія',NULL,'2017-11-02',NULL,380976262809,NULL,1944451380,'1',NULL,0,'','0'),
(1320,NULL,'Бойко Галина',NULL,'2017-11-02',NULL,380685427892,NULL,1628830531,'1',NULL,0,'','0'),
(1321,NULL,'Гураль Наталя',NULL,'2017-11-02',NULL,380688424926,NULL,1623963545,'1',NULL,0,'','0'),
(1322,NULL,'Луцишин Оля',NULL,'2017-11-02',NULL,380989343948,NULL,1169569569,'1',NULL,0,'','0'),
(1323,NULL,'Балабух Ліля',NULL,'2017-11-02',NULL,380976543555,NULL,1611168283,'1',NULL,0,'','0'),
(1324,NULL,'Золотий Іван',NULL,'2017-11-02',NULL,380684265216,NULL,2139914530,'1',NULL,0,'','0'),
(1325,NULL,'Круць Іван',NULL,'2017-11-04',NULL,380963689512,NULL,1644021245,'1',NULL,0,'','0'),
(1326,NULL,'Дивоняк Іра',NULL,'2017-11-04',NULL,380964501143,NULL,1205631143,'1',NULL,0,'','0'),
(1327,NULL,'Микульська Галя',NULL,'2017-11-04',NULL,380988586892,NULL,1299815304,'1',NULL,0,'','0'),
(1328,NULL,'Янкевич Аліна',NULL,'2017-11-04',NULL,380968539313,NULL,1313882661,'1',NULL,0,'','0'),
(1329,NULL,'Шевчук Антоніна',NULL,'2017-11-04',NULL,380684211626,NULL,2078519293,'1',NULL,0,'','0'),
(1330,NULL,'Баніта Іванка',NULL,'2017-11-06',NULL,380987892059,NULL,1626025766,'1',NULL,0,'','0'),
(1331,NULL,'Галанюк Оксана',NULL,'2017-11-06',NULL,380965612271,NULL,1307722214,'1',NULL,0,'','0'),
(1332,NULL,'Онищенко Зоряна',NULL,NULL,NULL,380973454267,NULL,1633351968,'1',NULL,0,'','0'),
(1333,NULL,'Татарин Аня',NULL,'2017-11-06',NULL,380686896408,NULL,2098443708,'1',NULL,0,'','0'),
(1334,NULL,'Коник Христина',NULL,'2017-11-06',NULL,380661128014,NULL,1290173179,'1',31124,0,'','0'),
(1335,NULL,'Совак Тарас',NULL,'2017-11-07',NULL,380686245646,NULL,1198704497,'1',NULL,0,'','0'),
(1336,NULL,'Шумська Юля',NULL,'2017-11-07',NULL,380978713199,NULL,1986100192,'1',NULL,0,'','0'),
(1337,NULL,'Сорока Іра',NULL,'2017-11-07',NULL,380988464815,NULL,1836402106,'1',NULL,0,'','0'),
(1338,NULL,'Гой Христина',NULL,'2017-11-07','KCYUvqpwqWaPz6qRkk51+Q==',380681142686,NULL,1688724851,'1',39725,0,'','0'),
(1339,NULL,'Денис Настя',NULL,NULL,NULL,380980599912,NULL,1847220158,'1',NULL,0,'','0'),
(1340,NULL,'Струганець Богдана',NULL,'2017-11-07',NULL,380997736316,NULL,1820095353,'1',NULL,0,'','0'),
(1341,NULL,'Польська Юля',NULL,'2017-11-07',NULL,380965020779,NULL,1896038619,'1',NULL,0,'','0'),
(1342,NULL,'Нера Марія',NULL,NULL,NULL,380678976485,NULL,2123626968,'1',NULL,0,'','0'),
(1343,NULL,'Бісюк наталя',NULL,'2017-11-07',NULL,380987811588,NULL,1972378025,'1',NULL,0,'','0'),
(1344,NULL,'Солтис Оля',NULL,'2017-11-07',NULL,380673958748,NULL,1709809902,'1',NULL,0,'','0'),
(1345,NULL,'Бролецька Ганна',NULL,'2017-11-07',NULL,380680357814,NULL,1815063111,'1',NULL,0,'','0'),
(1346,NULL,'Тобуринна Таня',NULL,'2017-11-08',NULL,380689543669,NULL,1941933260,'1',NULL,0,'','0'),
(1347,NULL,'Катринюк Люба',NULL,'2017-11-08',NULL,380968300914,NULL,1288420070,'1',NULL,0,'','0'),
(1348,0659,'Шага Світлана',NULL,NULL,NULL,380958029442,NULL,1339138330,'1',NULL,0,'','0'),
(1349,NULL,'Чайка Мирослава',NULL,'2017-11-08',NULL,380980027043,NULL,1967802592,'1',NULL,0,'','0'),
(1350,NULL,'Костинюк Альона',NULL,NULL,NULL,380683272108,NULL,1873523131,'1',NULL,0,'','0'),
(1351,NULL,'Тантала юля',NULL,NULL,NULL,380983587349,NULL,1459323585,'1',NULL,0,'','0'),
(1352,NULL,'Процанін Христина',NULL,'2017-11-08',NULL,380964073876,NULL,1880447012,'1',NULL,0,'','0'),
(1353,NULL,'Вурсова  Аліна',NULL,'2017-11-09',NULL,380951212120,NULL,1845918003,'1',NULL,0,'','0'),
(1354,NULL,'Каськів Наталя',NULL,NULL,NULL,380969136623,NULL,1909498277,'1',NULL,0,'','0'),
(1355,NULL,'Маряна Наша',NULL,NULL,NULL,NULL,NULL,1198363090,'1',NULL,0,'','0'),
(1356,NULL,'Микулишин Юля',NULL,'2017-11-11',NULL,380634116280,NULL,1693739221,'1',NULL,0,'','0'),
(1357,NULL,'Іванків Іра',NULL,'2017-11-11',NULL,380978372434,NULL,2025666283,'1',NULL,0,'','0'),
(1358,NULL,'Петрончак Наталя',NULL,'2017-11-11',NULL,380992591045,NULL,2067691087,'1',NULL,0,'','0'),
(1359,NULL,'Харчій Маряна',NULL,'2017-11-11',NULL,380976865618,NULL,1935142799,'1',NULL,0,'','0'),
(1360,NULL,'Сорока Аліна',NULL,'2017-11-11',NULL,380978069871,NULL,1171213117,'1',NULL,0,'','0'),
(1361,NULL,'Гурбач Оля',NULL,NULL,NULL,380965970877,NULL,1572078004,'1',NULL,0,'','0'),
(1362,NULL,'лейбик віка',NULL,NULL,NULL,380973770774,NULL,1388468587,'1',NULL,0,'','0'),
(1363,0573,'перуняк таня',NULL,NULL,NULL,380682807225,NULL,1310904779,'1',NULL,0,'','0'),
(1364,NULL,'Чайка Ірина',NULL,'2017-11-13',NULL,380960625515,NULL,1872754869,'1',21957,0,'','0'),
(1365,NULL,'Король Наталя',NULL,'2017-11-13',NULL,380987143071,NULL,2006540408,'1',NULL,0,'','0'),
(1366,NULL,'Ониськів Оля',NULL,'2017-11-13',NULL,380971489887,NULL,1284837160,'1',NULL,0,'','0'),
(1367,NULL,'Шимко Маряна',NULL,NULL,'bOmmRM6w+Ve5NHECGB/IbA==',380673501316,NULL,1237045701,'1',36955,0,'','0'),
(1368,NULL,'Стасій Христина',NULL,'2017-11-13',NULL,380683256972,NULL,1904835311,'1',NULL,0,'','0'),
(1369,NULL,'Подорчук Іванна',NULL,'2017-11-13',NULL,380993318857,NULL,1516470657,'1',NULL,0,'','0'),
(1370,NULL,'Гашпера Галя',NULL,'2017-11-13',NULL,380985726929,NULL,1946476976,'1',NULL,0,'','0'),
(1371,NULL,'Пиртрак Оля',NULL,'2017-11-13',NULL,380684231705,NULL,2049120282,'1',NULL,0,'','0'),
(1372,NULL,'Наложенко Юля',NULL,'2017-11-13',NULL,380663002456,NULL,1328781423,'1',NULL,0,'','0'),
(1373,NULL,'Корняк Леся',NULL,'2017-11-13',NULL,380988642548,NULL,2044252342,'1',NULL,0,'','0'),
(1374,NULL,'Дрогомирецька Олеся',NULL,NULL,NULL,380962785755,NULL,1803341047,'1',NULL,0,'','0'),
(1375,NULL,'Конциграда Іра',NULL,'2017-11-13',NULL,380979467131,NULL,1186056918,'1',NULL,0,'','0'),
(1376,NULL,'Крушельницька Марія',NULL,'2017-11-14',NULL,380986358680,NULL,1828866681,'1',58442,0,'','0'),
(1377,NULL,'Король Марія',NULL,'2017-11-14',NULL,380969261094,NULL,1216289579,'1',32030,0,'','0'),
(1378,NULL,'Нажденко Оля',NULL,'2017-11-14',NULL,380951707009,NULL,1331076765,'1',NULL,0,'','0'),
(1379,NULL,'Собчук Оксана',NULL,'2017-11-15',NULL,380966885411,NULL,1977229016,'1',NULL,0,'','0'),
(1380,NULL,'Король ВІка',NULL,'2017-11-15',NULL,380683320793,NULL,1299272112,'1',NULL,0,'','0'),
(1381,NULL,'Дідюк Алла',NULL,'2017-11-15',NULL,380689041569,NULL,1450452170,'1',NULL,0,'','0'),
(1382,NULL,'Сендюк Світлана',NULL,'2017-11-15',NULL,380684214144,NULL,2047166504,'1',NULL,0,'','0'),
(1383,NULL,'Макарова Галя',NULL,NULL,NULL,380676238990,NULL,1998872589,'1',NULL,0,'','0'),
(1384,NULL,'Костецька Оксана',NULL,'2017-11-15',NULL,380961490147,NULL,1274873291,'1',NULL,0,'','0'),
(1385,NULL,'Прокопчук Христина',NULL,'2017-11-16',NULL,380977659529,NULL,1116517001,'1',NULL,0,'','0'),
(1386,NULL,'Дегман Леся',NULL,'2017-11-16',NULL,380507680474,NULL,1687400202,'1',NULL,0,'','0'),
(1387,0273,'Цванько Христина',NULL,NULL,NULL,380685972307,NULL,1564825915,'1',NULL,0,'','0'),
(1388,NULL,'Пірга Таня',NULL,'2017-11-16',NULL,380671291465,NULL,1549613314,'1',NULL,0,'','0'),
(1389,NULL,'Чижишин  Оксана',NULL,'2017-11-17',NULL,380669251507,NULL,1220839586,'1',NULL,0,'','0'),
(1390,NULL,'Юрків Марія',NULL,'2017-11-17',NULL,380971718510,NULL,1374112900,'1',NULL,0,'','0'),
(1391,NULL,'Павзюк Світлана',NULL,'2017-11-17',NULL,380991426315,NULL,1444904786,'1',NULL,0,'','0'),
(1392,NULL,'Дюк Надя',NULL,'2017-11-17',NULL,380964907254,NULL,1719193447,'1',NULL,0,'','0'),
(1393,NULL,'Польова Ірина',NULL,'2017-11-17',NULL,380981273699,NULL,2037329303,'1',NULL,0,'','0'),
(1394,NULL,'Гнойська Діана',NULL,'2017-11-17',NULL,380963730629,NULL,1984663293,'1',NULL,0,'','0'),
(1395,NULL,'Аксюк Оксана',NULL,'2017-11-18',NULL,380969171344,NULL,2115648144,'1',NULL,0,'','0'),
(1396,NULL,'григорук іра',NULL,'2017-11-18',NULL,380636014161,NULL,1638145056,'1',NULL,0,'','0'),
(1397,NULL,'коник люба',NULL,NULL,NULL,380983099468,NULL,1420177386,'1',NULL,0,'','0'),
(1398,NULL,'Струтинська Таня',NULL,'2017-11-18',NULL,380962706215,NULL,1334539404,'1',NULL,0,'','0'),
(1399,NULL,'Мардаль Леонтина',NULL,'2017-11-20',NULL,380677436109,NULL,1205581212,'1',NULL,0,'','0'),
(1400,NULL,'Хорош Віка',NULL,'2017-11-20',NULL,380680212682,NULL,1873915006,'1',NULL,0,'','0'),
(1401,NULL,'Курбатова Надя',NULL,'2017-11-20',NULL,380684296430,NULL,1395667397,'1',NULL,0,'','0'),
(1402,NULL,'Мішкевич Таня',NULL,'2017-11-20',NULL,380980221214,NULL,1850022473,'1',NULL,0,'','0'),
(1403,NULL,'Філатова Таня',NULL,'2017-11-20',NULL,380966804960,NULL,1493110131,'1',NULL,0,'','0'),
(1404,NULL,'Ставнича Віта',NULL,'2017-11-20',NULL,380983775641,NULL,1320608775,'1',NULL,0,'','0'),
(1405,NULL,'Грабовецька Марина',NULL,'2017-11-20',NULL,380979778678,NULL,1711356904,'1',NULL,0,'','0'),
(1406,NULL,'Мельничук Алла',NULL,NULL,NULL,380983401913,NULL,2032733835,'1',NULL,0,'','0'),
(1407,NULL,'Пилат Наталя',NULL,'2017-11-21',NULL,380985864082,NULL,1406517095,'1',NULL,0,'','0'),
(1408,NULL,'Бегман Таня',NULL,'2017-11-21',NULL,380507315516,NULL,1134547121,'1',NULL,0,'','0'),
(1409,NULL,'Осадчук Іра',NULL,'2017-11-21','SotzEmXWNdxznyLjKxREMQ==',380976857427,NULL,2069455289,'1',41974,0,'','0'),
(1410,NULL,'клопіт ганна',NULL,'2017-11-22',NULL,380989243302,NULL,2083941900,'1',NULL,0,'','0'),
(1411,0269,'Сливчук Віка',NULL,NULL,NULL,380985119380,NULL,1234819948,'1',NULL,0,'','0'),
(1412,NULL,'Венгринович наталя',NULL,NULL,NULL,380959290464,NULL,1390554581,'1',NULL,0,'','0'),
(1413,NULL,'Полова Надія',NULL,'2017-11-22',NULL,380969543861,NULL,1492277137,'1',NULL,0,'','0'),
(1414,NULL,'Польовнича Іра',NULL,'2017-11-22',NULL,380636910193,NULL,2011352219,'1',NULL,0,'','0'),
(1415,NULL,'Рибчак Галя',NULL,'2017-11-22',NULL,380973314417,NULL,1753474539,'1',NULL,0,'','0'),
(1416,NULL,'Чубей Каміла',NULL,'2017-11-22',NULL,380972195689,NULL,1382357497,'1',NULL,0,'','0'),
(1417,NULL,' Аліна Наша',NULL,NULL,NULL,NULL,NULL,1156847308,'1',NULL,1,'','0'),
(1418,NULL,'Галанчак Оля',NULL,NULL,NULL,380680264697,380971291951,1450058262,'1',NULL,0,'','0'),
(1419,NULL,'Градова Ліля',NULL,'2017-11-23',NULL,380931457351,NULL,1381666347,'1',NULL,0,'','0'),
(1420,NULL,'Гусак Наталя',NULL,'2017-11-23',NULL,380501446000,NULL,2114265935,'1',NULL,0,'','0'),
(1421,NULL,'Семенюк Леся',NULL,'2017-11-23',NULL,380689780491,NULL,1436824462,'1',NULL,0,'','0'),
(1422,0649,'Ландяк Наталя',NULL,NULL,NULL,380979929057,NULL,1588523228,'1',NULL,0,'','0'),
(1423,NULL,'петришин сніжана',NULL,'2017-11-23',NULL,380991132925,NULL,1423810384,'1',NULL,0,'','0'),
(1424,NULL,'Сєдова Іра',NULL,'2017-11-23',NULL,380953040134,NULL,2034590025,'1',NULL,0,'','0'),
(1425,NULL,'Ушій Маряна',NULL,'2017-11-23',NULL,380988707783,NULL,1743697502,'1',NULL,0,'','0'),
(1426,NULL,'Яцишин Ліля',NULL,'2017-11-24',NULL,380502337231,NULL,2030469286,'1',NULL,0,'','0'),
(1427,NULL,'Ревуцька Оля',NULL,'2017-11-24',NULL,380684455329,NULL,1189584397,'1',NULL,0,'','0'),
(1428,NULL,'Кузь Надія',NULL,NULL,NULL,380984562142,NULL,2046565917,'1',NULL,0,'','0'),
(1429,0643,'Гнида Люба',NULL,NULL,NULL,380977941119,NULL,1355025782,'1',NULL,0,'','0'),
(1430,NULL,'Іванюк Михайло',NULL,'2017-11-25',NULL,380680710378,NULL,1846936016,'1',NULL,0,'','0'),
(1431,NULL,'Скрипник Марія',NULL,'2017-11-25',NULL,380664828369,NULL,1961301343,'1',NULL,0,'','0'),
(1432,NULL,'Пельвецька Галина',NULL,'2017-11-25',NULL,380677037023,NULL,1252885060,'1',43165,0,'','0'),
(1433,NULL,'Фарина Іра',NULL,'2017-11-25',NULL,380684212120,NULL,2073305046,'1',NULL,0,'','0'),
(1434,NULL,'Сенів Юля',NULL,'2017-11-25',NULL,380987319447,NULL,1424293592,'1',NULL,0,'','0'),
(1435,NULL,'Благідка Уляна',NULL,NULL,NULL,380970007016,NULL,1934762978,'1',NULL,0,'','0'),
(1436,NULL,'Франяк Юліана',NULL,'2017-11-27',NULL,380681521619,NULL,1705604979,'1',NULL,0,'','0'),
(1437,NULL,'Деркач Вікторія',NULL,NULL,NULL,NULL,380978242814,1709458530,'1',NULL,0,'','0'),
(1438,NULL,'куца ірина',NULL,NULL,NULL,380969028232,NULL,1360446155,'1',51680,0,'','0'),
(1439,NULL,'Оликсишин Наталя',NULL,'2017-11-27',NULL,380989602204,NULL,2119425015,'1',NULL,0,'','0'),
(1440,NULL,'Мельник Оля',NULL,'2017-11-27',NULL,380687173420,NULL,1434612596,'1',13949,0,'','0'),
(1441,NULL,'Гевко Еріка',NULL,'2017-11-27',NULL,380660172324,NULL,1175708864,'1',NULL,0,'','0'),
(1442,NULL,'Пельвецька Ірина',NULL,'2017-11-28',NULL,380973321405,NULL,1723878188,'1',NULL,0,'','0'),
(1443,NULL,'Патуляк Маша',NULL,'2017-11-28',NULL,380957911744,NULL,1162007736,'1',NULL,0,'','0'),
(1444,NULL,'Петрик Марія',NULL,'2017-11-28',NULL,380961107604,NULL,1243911512,'1',NULL,0,'','0'),
(1445,0709,'Совяк Марія',NULL,NULL,NULL,380686779003,NULL,2122329791,'1',NULL,0,'','0'),
(1446,NULL,'Романюк ',NULL,NULL,NULL,NULL,NULL,1758521578,'1',NULL,0,'','1'),
(1447,NULL,'Наталя пуляк',NULL,'2017-11-28',NULL,380966871368,NULL,1540958079,'1',NULL,1,'','0'),
(1448,NULL,'бартух марта',NULL,'2017-11-28',NULL,380971956842,NULL,1200768908,'1',NULL,0,'','0'),
(1449,NULL,'Бойко Уляна',NULL,'2017-11-28',NULL,380682468194,NULL,1142868643,'1',NULL,0,'','0'),
(1450,NULL,'Шевченко Віка',NULL,'2017-11-28',NULL,380977289440,NULL,1130015396,'1',NULL,0,'','0'),
(1451,NULL,'Строцень Алла',NULL,'2017-11-28',NULL,380976822236,NULL,1296854971,'1',NULL,0,'','0'),
(1452,NULL,'Коваль Люба',NULL,'2017-11-28','yd40B/nKvOaIVcOCqbZ+EA==',380507276608,NULL,1111227293,'1',46005,0,'','0'),
(1453,NULL,'Котовська Надя',NULL,NULL,NULL,NULL,NULL,1811282909,'1',NULL,0,'','1'),
(1454,NULL,'ярема надя',NULL,'2017-11-29',NULL,380972132637,NULL,1870434847,'1',NULL,0,'','0'),
(1455,NULL,'Мороз Христина',NULL,'2017-11-29',NULL,380966396846,NULL,1900714386,'1',NULL,0,'','0'),
(1456,NULL,'Лесишак Юля',NULL,'2017-11-29',NULL,380731166027,NULL,1282542583,'1',NULL,0,'','0'),
(1457,NULL,'Гудима Юля',NULL,NULL,NULL,380686951024,NULL,1935041068,'1',NULL,0,'','0'),
(1458,NULL,'Федорців Віка',NULL,'2017-11-29',NULL,380977112446,NULL,2015992444,'1',NULL,0,'','0'),
(1459,NULL,'Присяжнюк Маряна',NULL,'2017-11-29',NULL,380680543950,NULL,2056858345,'1',NULL,0,'','0'),
(1460,NULL,'Андрієвська Юля',NULL,'2017-11-29',NULL,380976081110,NULL,1340526835,'1',11385,0,'','0'),
(1461,NULL,'Смівка Христина',NULL,'2017-11-29',NULL,380971353883,NULL,1301711658,'1',31200,0,'','0'),
(1462,NULL,'Федорів Христина',NULL,'2017-11-29',NULL,380684801043,NULL,1722922465,'1',NULL,0,'','0'),
(1463,0699,'Храпа Олександра',NULL,NULL,NULL,380983827537,NULL,1762603330,'1',NULL,0,'','0'),
(1464,NULL,'Чубка Галя',NULL,'2017-11-30',NULL,380988201525,NULL,1413697299,'1',NULL,0,'','0'),
(1465,NULL,'Пандрак Юля',NULL,'2017-11-30',NULL,380975410874,NULL,1462027051,'1',NULL,0,'','0'),
(1466,NULL,'Забіяка Таня',NULL,'2017-11-30',NULL,380671095144,NULL,1542741206,'1',56497,0,'','0'),
(1467,NULL,'Кравець Оля',NULL,'2017-11-30',NULL,380969793031,NULL,1635329606,'1',NULL,0,'','0'),
(1468,NULL,'Нагаєвська Таня',NULL,'2017-11-30',NULL,380983099128,NULL,1836570136,'1',NULL,0,'','0'),
(1469,NULL,'хомель марія',NULL,'2017-11-30',NULL,380964054006,NULL,1763027257,'1',NULL,0,'','0'),
(1470,NULL,'Федорович Уляна',NULL,'2017-12-01',NULL,380971629733,NULL,1193296694,'1',NULL,0,'','0'),
(1471,NULL,'Кузь Люба',NULL,NULL,NULL,380978979428,NULL,1236580441,'1',NULL,0,'','0'),
(1472,0160,'Фотчук Христина',NULL,NULL,NULL,380961919827,NULL,2049290716,'1',NULL,0,'','0'),
(1473,0723,'Вольніцька Христина',NULL,NULL,NULL,380681633128,NULL,1356008216,'1',NULL,0,'','0'),
(1474,NULL,'Талинюк Леся',NULL,'2017-12-01',NULL,380689620319,NULL,1605632096,'1',NULL,0,'','0'),
(1475,NULL,'Цемалишин Юля',NULL,'2017-12-02',NULL,380678334796,NULL,2017394019,'1',NULL,0,'','0'),
(1476,0719,'Романюк Тетяна',NULL,NULL,NULL,380985715569,NULL,1350119497,'1',NULL,0,'','0'),
(1477,NULL,'Погріщук Марія',NULL,'2017-12-04',NULL,380680411550,NULL,1394425353,'1',NULL,0,'','0'),
(1478,NULL,'Крисовська Марія',NULL,'2017-12-04',NULL,380676797241,NULL,1727963124,'1',NULL,0,'','0'),
(1479,NULL,'Шалай Катя',NULL,'2017-12-04',NULL,380685107783,NULL,1864017625,'1',NULL,0,'','0'),
(1480,NULL,'Сущинська Ліля',NULL,'2017-12-04',NULL,380669443178,NULL,1360288549,'1',20080,0,'','0'),
(1481,NULL,'Плецан Сніжана',NULL,'2017-12-04','Yq7bnEmN0yOtbaKDtesLqA==',380688632066,NULL,1459143085,'1',49278,8,'','0'),
(1482,NULL,'Суха Таня',NULL,'2017-12-04',NULL,380731256620,NULL,1216854896,'1',NULL,0,'','0'),
(1483,NULL,'Шушко Андріана',NULL,'2017-12-04',NULL,380971667732,NULL,1266794779,'1',NULL,0,'','0'),
(1484,NULL,'Крижанівська Оля',NULL,'2017-12-04',NULL,380966882752,NULL,1344032906,'1',NULL,0,'','0'),
(1485,NULL,'Заболотна Іра',NULL,'2017-12-05',NULL,380963439626,NULL,1384052648,'1',NULL,0,'','0'),
(1486,NULL,'Данчак Іванка',NULL,'2017-12-05',NULL,380506213027,NULL,1252980225,'1',NULL,0,'','0'),
(1487,NULL,'Бабіцька Інна',NULL,'2017-12-05',NULL,380980999781,NULL,1374915508,'1',NULL,0,'','0'),
(1488,NULL,'Юрків Ірина',NULL,NULL,NULL,380986329539,NULL,1213579294,'1',NULL,0,'','0'),
(1489,0697,'Марютіна Зоряна',NULL,NULL,NULL,380984038799,NULL,1654795265,'1',NULL,0,'','0'),
(1490,NULL,'Ласюк Іра',NULL,'2017-12-06',NULL,380964956066,NULL,2096571998,'1',NULL,0,'','0'),
(1491,0289,'Чернецька Діана',NULL,NULL,NULL,380988925681,NULL,1449615045,'1',NULL,0,'','0'),
(1492,NULL,'Караульна Яна',NULL,'2017-12-06',NULL,380950073916,NULL,1544418573,'1',36970,1,'','0'),
(1493,NULL,'Тимофій Таня',NULL,'2017-12-06',NULL,380980198500,NULL,1444025945,'1',NULL,0,'','0'),
(1494,NULL,'Осадчук Інна',NULL,NULL,NULL,NULL,NULL,1160095595,'1',NULL,0,'','1'),
(1495,NULL,'Сулятицька Оксана',NULL,NULL,NULL,380984582208,NULL,1267908151,'1',NULL,0,'','0'),
(1496,NULL,'Ландяк Оксана',NULL,'2017-12-07',NULL,380984893628,NULL,2104114840,'1',NULL,0,'','0'),
(1497,NULL,'Сніжок Оля',NULL,'2017-12-07',NULL,380979778890,NULL,1824203192,'1',NULL,0,'','0'),
(1498,NULL,'Баліцька Таня',NULL,'2017-12-07',NULL,380970111378,NULL,1289069678,'1',NULL,0,'','0'),
(1499,NULL,'Шафран Людмила',NULL,'2017-12-07',NULL,380956664573,NULL,1297595110,'1',NULL,0,'','0'),
(1500,NULL,' Христина наша',NULL,NULL,NULL,NULL,NULL,2094869638,'1',NULL,0,'','0');

INSERT INTO `kontragentu` VALUES 
(1501,NULL,'Глова Ірина',NULL,'2017-12-07',NULL,380683362525,NULL,1891203042,'1',NULL,0,'','0'),
(1502,NULL,'Наконечна Галина',NULL,'2017-12-07',NULL,380986486591,NULL,1986532164,'1',NULL,0,'','0'),
(1503,NULL,'Марцінів Ліза',NULL,'2017-12-07',NULL,380979215719,NULL,1542634831,'1',NULL,0,'','0'),
(1504,NULL,'Мельник Олена',NULL,'2017-12-07',NULL,380680334551,NULL,1991461094,'1',NULL,0,'','0'),
(1505,NULL,'Теслюк Юля',NULL,'2017-12-08',NULL,380680409614,NULL,1608520671,'1',NULL,0,'','0'),
(1506,NULL,'Теслюк Ліля',NULL,'2017-12-08',NULL,380687602084,NULL,1430565495,'1',NULL,0,'','0'),
(1507,NULL,'Величко Олена',NULL,'2017-12-09',NULL,380675850954,NULL,1431864884,'1',NULL,0,'','0'),
(1508,NULL,'Дідушок Іра',NULL,'2017-12-11',NULL,380961618963,NULL,1620378336,'1',NULL,0,'','0'),
(1509,NULL,'Зозуля Христина',NULL,'2017-12-11',NULL,380967519234,NULL,1393331448,'1',NULL,0,'','0'),
(1510,0275,'Покойова Ірина',NULL,NULL,NULL,380986128804,NULL,1688972499,'1',NULL,0,'','0'),
(1511,NULL,'Децюк Оксана',NULL,'2017-12-11',NULL,380971439335,NULL,1375221543,'1',NULL,0,'','0'),
(1512,NULL,'Мальована Маша',NULL,NULL,NULL,380967567311,NULL,2096851926,'1',NULL,0,'','0'),
(1513,NULL,'Міщанчук Таня',NULL,NULL,NULL,380671657043,NULL,1613466635,'1',62542,1,'','0'),
(1514,NULL,'Маретько Наталя',NULL,'2017-12-12',NULL,380507560960,NULL,1417880333,'1',NULL,0,'','0'),
(1515,NULL,'годована ольга',NULL,'2017-12-12',NULL,380964851363,NULL,1821559018,'1',NULL,0,'','0'),
(1516,NULL,'Романенко Галина',NULL,'2017-12-12',NULL,380663040841,NULL,1112003199,'1',NULL,1,'','0'),
(1517,NULL,'глова ілона',NULL,'2017-12-12',NULL,380968285410,NULL,1459606110,'1',NULL,0,'','0'),
(1518,NULL,'гапяк галя',NULL,'2017-12-12',NULL,380971333908,NULL,2125507873,'1',NULL,0,'','0'),
(1519,NULL,'Обшарська Настя',NULL,'2017-12-12',NULL,380672917350,NULL,1524856336,'1',38282,0,'','0'),
(1520,NULL,'Ухач Маряна',NULL,'2017-12-13',NULL,380978836310,NULL,1205965297,'1',NULL,0,'','0'),
(1521,NULL,'Романенко Оля',NULL,'2017-12-13',NULL,380660013743,NULL,1318169523,'1',NULL,1,'','0'),
(1522,NULL,'Коваль Анастасія',NULL,'2017-12-13',NULL,380962616802,NULL,1891441837,'1',NULL,0,'','0'),
(1523,NULL,'Пипа Оксана',NULL,'2017-12-13',NULL,380968812693,NULL,1594626928,'1',NULL,0,'','0'),
(1524,NULL,'Галат Наталя',NULL,'2017-12-13',NULL,380982512626,NULL,1215903992,'1',NULL,0,'','0'),
(1525,NULL,'Подолянська Марія',NULL,NULL,NULL,380989742802,NULL,1899360682,'1',NULL,0,'','0'),
(1526,NULL,'Марусик Валерія',NULL,'2017-12-14',NULL,380672715188,NULL,1758143128,'1',NULL,0,'','0'),
(1527,NULL,'Хмільник Альона',NULL,'2017-12-14',NULL,380972959874,NULL,1841792228,'1',NULL,0,'','0'),
(1528,NULL,'Романенко Рубіна',NULL,'2017-12-14',NULL,380501600119,NULL,1627422891,'1',NULL,0,'','0'),
(1529,NULL,'Стащак Галина',NULL,'2017-12-14',NULL,380987058748,NULL,1883662218,'1',NULL,0,'','0'),
(1530,0641,'Романюк Наталя',NULL,NULL,NULL,380980282930,NULL,2089855489,'1',NULL,1,'','0'),
(1531,NULL,'Геравс Юля',NULL,'2017-12-15',NULL,380938620390,NULL,1885036422,'1',NULL,0,'','0'),
(1532,NULL,'Головецька Марія',NULL,'2017-12-15',NULL,380985857014,NULL,2034664098,'1',NULL,0,'','0'),
(1533,NULL,'Мацевко Ірина',NULL,'2017-12-15',NULL,380972551230,NULL,1510458405,'1',NULL,0,'','0'),
(1534,NULL,'Новак Оксана',NULL,'2017-12-15','4Knyos6XZPSzDon5nJAK+w==',380671580535,NULL,2072696499,'1',NULL,0,'','0'),
(1535,NULL,'Голуб Юля ',NULL,'2017-12-15',NULL,380687134129,NULL,1438406992,'1',NULL,0,'','0'),
(1536,NULL,'Пшенишна Світлана',NULL,'2017-12-15',NULL,380674903832,NULL,1517633598,'1',NULL,0,'','0'),
(1537,NULL,'Шевчук Олесандр',NULL,'2017-12-15',NULL,380983812389,NULL,1610973488,'1',NULL,0,'','0'),
(1538,NULL,'Франків Ігор',NULL,'2017-12-16',NULL,380958586664,NULL,1749159421,'1',NULL,0,'','0'),
(1539,NULL,'Мейор Ліда',NULL,'2017-12-16',NULL,380971643030,NULL,2021750208,'1',NULL,0,'','0'),
(1540,NULL,'Карпів Катя',NULL,'2017-12-16',NULL,380688461360,NULL,1447815036,'1',NULL,0,'','0'),
(1541,0715,'Фурик Оксана',NULL,NULL,NULL,380671258112,NULL,1879164063,'1',NULL,0,'','0'),
(1542,NULL,'іскра олена',NULL,NULL,NULL,380681724713,NULL,1814937375,'1',NULL,0,'','0'),
(1543,NULL,'рогіян христина',NULL,'2017-12-16',NULL,380968989379,NULL,1181427454,'1',NULL,0,'','0'),
(1544,NULL,'Цимбалюк Марія',NULL,NULL,NULL,380686953737,NULL,1599963253,'1',NULL,0,'','0'),
(1545,NULL,'Монастирська Оксана',NULL,'2017-12-16',NULL,380969136109,NULL,1309504623,'1',NULL,0,'','0'),
(1546,NULL,'Новацька Марія',NULL,'2017-12-16',NULL,380977895241,NULL,1733501255,'1',NULL,0,'','0'),
(1547,NULL,'Ворк Наталя',NULL,'2017-12-16',NULL,380686896356,NULL,2146729831,'1',NULL,0,'','0'),
(1548,NULL,'Зігрій Таня',NULL,'2017-12-16',NULL,380960754625,NULL,1846071101,'1',NULL,0,'','0'),
(1549,NULL,'Юрків Наталя',NULL,'2017-12-16',NULL,380991137912,NULL,1885835446,'1',NULL,0,'','0'),
(1550,NULL,'Мартинюк Оля',NULL,'2017-12-16',NULL,380986640068,NULL,1982976342,'1',NULL,1,'','0'),
(1551,NULL,'Велиган Олеся',NULL,'2017-12-16',NULL,380961906658,NULL,1226763167,'1',NULL,0,'','0'),
(1552,0691,'Тичковська Таня',NULL,NULL,NULL,380968968158,NULL,1997245668,'1',NULL,0,'','0'),
(1553,NULL,'Сорокопут Оксана',NULL,'2017-12-16',NULL,380989267731,NULL,1614281576,'1',NULL,0,'','0'),
(1554,NULL,'Добровольська Ірина',NULL,'2017-12-16',NULL,389067086717,NULL,2135424257,'1',NULL,0,'','0'),
(1555,NULL,'Долик Христя',NULL,NULL,NULL,380960504637,NULL,1731505410,'1',NULL,0,'','0'),
(1556,NULL,'Золота Оля',NULL,'2017-12-16',NULL,380970534731,NULL,1233093124,'1',NULL,0,'','0'),
(1557,0743,'Половчук Катя',NULL,NULL,NULL,380985710886,NULL,1326793657,'1',NULL,0,'','0'),
(1558,NULL,'Леськів Аня',NULL,NULL,NULL,380966857939,NULL,2063867839,'1',NULL,1,'','0'),
(1559,NULL,'Спужак Таня',NULL,'2017-12-18',NULL,380971155011,NULL,1201925724,'1',NULL,0,'','0'),
(1560,NULL,'Опацька Надя',NULL,'2017-12-18',NULL,380978132395,NULL,1573039256,'1',NULL,0,'','0'),
(1561,NULL,'Бойко Наталя',NULL,NULL,NULL,380969956183,NULL,1692855342,'1',NULL,0,'','0'),
(1562,NULL,'Карпецька Таня',NULL,'2017-12-18',NULL,380500142651,NULL,1775836022,'1',NULL,0,'','0'),
(1563,NULL,'барабаш віра',NULL,'2017-12-18',NULL,380973165328,NULL,1748886013,'1',NULL,0,'','0'),
(1564,NULL,'Келець Каріна',NULL,'2017-12-18',NULL,380971053036,NULL,1584061809,'1',NULL,0,'','0'),
(1565,NULL,'Гуцул Іванка',NULL,'2017-12-18',NULL,380635466547,NULL,1169279226,'1',NULL,0,'','0'),
(1566,NULL,'Чурпіта Ліля',NULL,NULL,NULL,NULL,NULL,1405860489,'1',NULL,0,'','1'),
(1567,NULL,'КУЩАК ІВВАН',NULL,'2017-12-19',NULL,380677069266,NULL,1853289540,'1',NULL,0,'','0'),
(1568,NULL,'Прусак Іра',NULL,'2017-12-20',NULL,380989262961,NULL,2066224770,'1',NULL,0,'','0'),
(1569,NULL,'Зозуля Люда',NULL,'2017-12-20',NULL,380986793573,NULL,1519069675,'1',NULL,0,'','0'),
(1570,NULL,'Трубнівна Слава',NULL,'2017-12-20',NULL,380636943696,NULL,1403505069,'1',NULL,0,'','0'),
(1571,NULL,'Мельничук Василина',NULL,NULL,NULL,380681759263,NULL,1670127440,'1',NULL,0,'','0'),
(1572,NULL,'Пилипець Настя',NULL,'2017-12-20',NULL,380980886997,NULL,1652095174,'1',NULL,0,'','0'),
(1573,NULL,'Мишковська Світлана',NULL,'2017-12-20',NULL,380936195265,NULL,1326221187,'1',NULL,0,'','0'),
(1574,NULL,'Маланій Таня',NULL,'2017-12-20',NULL,380967550358,NULL,1823372606,'1',NULL,0,'','0'),
(1575,NULL,'Шевчук Таня',NULL,'2017-12-20',NULL,380973405783,NULL,1650165930,'1',NULL,0,'','0'),
(1576,NULL,'Левенець Люба',NULL,'2017-12-21',NULL,380986348955,NULL,1552413702,'1',NULL,0,'','0'),
(1577,NULL,'Бурак Оля',NULL,'2017-12-21',NULL,380973409271,NULL,1716123730,'1',NULL,0,'','0'),
(1578,0721,'Хреник Леся',NULL,NULL,NULL,380999775267,NULL,1845548886,'1',NULL,0,'','0'),
(1579,NULL,'Костик Інна',NULL,'2017-12-21',NULL,380938732645,NULL,1875508011,'1',NULL,0,'','0'),
(1580,NULL,'Затурська Галя',NULL,'2017-12-21',NULL,380631329300,NULL,1906586381,'1',NULL,0,'','0'),
(1581,NULL,'Кушнір Яна',NULL,'2017-12-21',NULL,380964815795,NULL,1855531587,'1',NULL,0,'','0'),
(1582,NULL,'Солоденко Таміла',NULL,'2017-12-21',NULL,380959209466,NULL,1448465712,'1',NULL,0,'','0'),
(1583,NULL,'Батрин Маряна',NULL,'2017-12-21',NULL,380680472594,NULL,2009672120,'1',NULL,0,'','0'),
(1584,NULL,'Ненчин Зеновія',NULL,NULL,NULL,380687993394,NULL,1843504893,'1',NULL,1,'','0'),
(1585,NULL,'Голодрига Тетяна',NULL,'2017-12-21',NULL,380986275061,NULL,1912091950,'1',NULL,0,'','0'),
(1586,0687,'Подольчук Тетяна',NULL,NULL,NULL,380686280053,NULL,1743523416,'1',NULL,0,'','0'),
(1587,NULL,'Новіцька Вікторія',NULL,'2017-12-21',NULL,380979038354,NULL,1620555278,'1',NULL,0,'','0'),
(1588,NULL,'Галанюк Марія',NULL,'2017-12-21',NULL,380974215292,NULL,1792651575,'1',NULL,0,'','0'),
(1589,NULL,'хомяк таня',NULL,'2017-12-22',NULL,380685868628,NULL,1150098684,'1',NULL,0,'','0'),
(1590,NULL,'Паук Зиновія',NULL,NULL,NULL,380672966926,NULL,2024531193,'1',NULL,0,'','0'),
(1591,NULL,'Зінюк Настя',NULL,'2017-12-22',NULL,380686025902,NULL,1329110801,'1',NULL,0,'','0'),
(1592,NULL,'Золота Роксолана',NULL,'2017-12-25',NULL,380983544141,NULL,1474289221,'1',NULL,0,'','0'),
(1593,0253,'Білоус Христина',NULL,NULL,NULL,380681250153,NULL,1611755783,'1',46092,0,'','0'),
(1594,NULL,'Юрків Оксана',NULL,'2017-12-26',NULL,380970353724,NULL,1219552286,'1',NULL,0,'','0'),
(1595,NULL,'Коцулин Оля',NULL,NULL,NULL,380971267485,NULL,1224239287,'1',NULL,0,'','0'),
(1596,NULL,'Тильна Надія',NULL,'2017-12-26','Q0Xe19Sxt7D8G9njqHn4DQ==',380684248217,NULL,1334746374,'1',NULL,0,'','0'),
(1597,0345,'Назарчук Ліза',NULL,NULL,NULL,380686241266,NULL,1360553525,'1',NULL,0,'','0'),
(1598,0255,'Назарчук Алла',NULL,NULL,NULL,380976822941,NULL,1408106374,'1',NULL,0,'','0'),
(1599,NULL,'Бойко Тарас',NULL,'2017-12-26',NULL,380977168068,NULL,1525849427,'1',NULL,0,'','0'),
(1600,NULL,'Слободян Іванна',NULL,'2017-12-26',NULL,380978245043,NULL,1694404874,'1',NULL,0,'','0'),
(1601,NULL,'Яцишин Ірина',NULL,'2017-12-26',NULL,380975991643,NULL,1881151000,'1',NULL,0,'','0'),
(1602,NULL,'Бабій Наталя',NULL,'2017-12-26',NULL,380985782348,NULL,1816402794,'1',NULL,0,'','0'),
(1603,NULL,'Терців Аня',NULL,'2017-12-26',NULL,380685364989,NULL,1154219384,'1',NULL,0,'','0'),
(1604,NULL,'Мельник наталя',NULL,'2017-12-26',NULL,380966583842,NULL,1391429225,'1',NULL,0,'','0'),
(1605,NULL,'Нановська Оля',NULL,'2017-12-26',NULL,380977471920,NULL,1316503239,'1',NULL,0,'','0'),
(1606,NULL,'марчак наталя',NULL,'2017-12-26',NULL,380989831019,NULL,1545895293,'1',NULL,0,'','0'),
(1607,NULL,'віка Макіяж',NULL,'2017-12-27',NULL,380688180813,NULL,1526234328,'1',NULL,0,'','0'),
(1608,NULL,'Леонова Марія',NULL,'2017-12-27',NULL,380974657574,NULL,1683458932,'1',NULL,0,'','0'),
(1609,NULL,'Вільхова Ліля',NULL,'2017-12-27',NULL,380972565048,NULL,2006303202,'1',NULL,0,'','0'),
(1610,NULL,'Стиценко Луана',NULL,'2017-12-27',NULL,380989906117,NULL,1965857762,'1',NULL,0,'','0'),
(1611,NULL,'Колос Інна',NULL,'2017-12-27',NULL,380972699812,NULL,1494587464,'1',NULL,0,'','0'),
(1612,NULL,'Вереза Артур',NULL,'2017-12-28',NULL,380979695226,NULL,1811023747,'1',NULL,0,'','0'),
(1613,NULL,'Маша Оравчевська',NULL,'2017-12-28',NULL,380684347936,NULL,1603938166,'1',39068,0,'','0'),
(1614,NULL,'Геба Оксана',NULL,'2017-12-28',NULL,380977196096,NULL,1408390883,'1',NULL,0,'','0'),
(1615,NULL,'Нагірна Інна',NULL,NULL,NULL,380978982221,NULL,2115038033,'1',NULL,0,'','0'),
(1616,NULL,'Різник Іванна',NULL,'2017-12-28',NULL,380989210187,NULL,1778082986,'1',NULL,0,'','0'),
(1617,NULL,'Хованець Люба',NULL,NULL,'hWfa1C8BWUgJ4Da5cx564g==',380970860612,NULL,1723687292,'1',NULL,0,'','0'),
(1618,NULL,'Лада Галина',NULL,'2017-12-29',NULL,380687311254,NULL,1932262000,'1',NULL,0,'','0'),
(1619,NULL,'Гудь Ірина',NULL,NULL,NULL,380687028819,NULL,1951946023,'1',NULL,0,'','0'),
(1620,NULL,'Руда Іра',NULL,'2017-12-29',NULL,380957855273,NULL,1319113200,'1',NULL,0,'','0'),
(1621,NULL,'Семенюк Ліда',NULL,'2017-12-30',NULL,380500110344,NULL,1906121898,'1',NULL,0,'','0'),
(1622,NULL,'Міц Леся',NULL,'2017-12-30',NULL,380683320326,NULL,1544429985,'1',NULL,0,'','0'),
(1623,NULL,'Цепенда Дарина',NULL,'2017-12-30',NULL,380985181260,NULL,1602207646,'1',NULL,0,'','0'),
(1624,NULL,'Рівна Марія',NULL,'2017-12-30',NULL,380689618331,NULL,1380532958,'1',NULL,0,'','0'),
(1625,NULL,'Гойда Таня',NULL,'2018-01-03',NULL,380950910929,NULL,1994770642,'1',NULL,0,'','0'),
(1626,NULL,'Гриньків Аліна',NULL,'2018-01-03',NULL,380973380507,NULL,1672264501,'1',NULL,0,'','0'),
(1627,NULL,'Гриньків Марія',NULL,'2018-01-03',NULL,380680356495,NULL,1412220694,'1',NULL,0,'','0'),
(1628,NULL,'Білас  Христина',NULL,NULL,NULL,380988238669,NULL,1194295900,'1',52902,1,'','0'),
(1629,NULL,'По',NULL,'2018-01-03',NULL,NULL,NULL,1267044269,'1',NULL,0,'','0'),
(1630,NULL,'Мазуркевич Віолета',NULL,'2018-01-03',NULL,380961159740,NULL,2110207887,'1',NULL,0,'','0'),
(1631,NULL,'Галак Марія',NULL,'2018-01-03',NULL,380971684148,NULL,1309978316,'1',NULL,0,'','0'),
(1632,NULL,'Лазука Марія',NULL,'2018-01-03',NULL,380979846387,NULL,1561815131,'1',NULL,0,'','0'),
(1633,NULL,'Бик Юля',NULL,'2018-01-03',NULL,380976268680,NULL,2137847287,'1',NULL,0,'','0'),
(1634,NULL,'Куцик Віка',NULL,'2018-01-03',NULL,380682452569,NULL,1580450796,'1',NULL,0,'','0'),
(1635,0265,'Гевко Христина',NULL,NULL,NULL,380960531303,NULL,1201693867,'1',NULL,0,'','0'),
(1636,NULL,'Золота Галина',NULL,'2018-01-03',NULL,380974562357,NULL,1838402528,'1',NULL,0,'','0'),
(1637,NULL,'Гаврилюк Юля',NULL,'2018-01-03',NULL,380688616373,NULL,2019097439,'1',NULL,0,'','0'),
(1638,NULL,'Вербіцька Таня',NULL,'2018-01-03',NULL,380681775656,NULL,1599732427,'1',NULL,0,'','0'),
(1639,NULL,'Дідик Настя',NULL,'2018-01-03',NULL,380990087486,NULL,2064651140,'1',NULL,0,'','0'),
(1640,NULL,'Голендйовська Христина',NULL,'2018-01-03',NULL,380686257343,NULL,1614939110,'1',NULL,0,'','0'),
(1641,NULL,'Гнеськів Вікторія',NULL,'2018-01-03',NULL,380971196483,NULL,1652098033,'1',NULL,0,'','0'),
(1642,NULL,'гевко марта',NULL,'2018-01-03','ew3PyBanv8N4iwhu+iZ/wg==',380976989992,NULL,1718346615,'1',55665,1,'','0'),
(1643,NULL,'Кріль Оксана',NULL,'2018-01-04',NULL,380688423646,NULL,1205859698,'1',NULL,0,'','0'),
(1644,NULL,'Лаба Галина',NULL,'2018-01-04',NULL,380671596135,NULL,1309962564,'1',NULL,0,'','0'),
(1645,NULL,'Козюк Ірина',NULL,'2018-01-04',NULL,380974781512,NULL,1518811974,'1',NULL,0,'','0'),
(1646,NULL,'Адамовська Анастасія',NULL,'2018-01-05',NULL,380680948974,NULL,1481670080,'1',NULL,0,'','0'),
(1647,NULL,'Марущак Христина',NULL,'2018-01-05',NULL,380981273820,NULL,1948944175,'1',NULL,0,'','0'),
(1648,NULL,'Маша Наша',NULL,'2018-01-05','APw/DkvwzBMlTACYVQuIqg==',6,NULL,1771239523,'1',12221,0,'','0'),
(1649,NULL,'Завгородня Таня',NULL,'2018-01-05',NULL,380951934382,NULL,1576893571,'1',NULL,0,'','0'),
(1650,NULL,'Плаксюк Люба',NULL,'2018-01-06',NULL,380672911090,NULL,1436055620,'1',NULL,1,'','0'),
(1651,NULL,'Тимус Юля',NULL,'2018-01-06',NULL,380965000266,NULL,1822929079,'1',35130,0,'','0'),
(1652,NULL,'ясінська оксана',NULL,NULL,NULL,380677817207,NULL,1585411400,'1',NULL,0,'','0'),
(1653,NULL,'Попик Неля',NULL,NULL,NULL,380688742085,NULL,1802985838,'1',NULL,0,'','0'),
(1654,NULL,'никифорчин іванна',NULL,NULL,'vcJi3Czihdkg9aGNQGCQsQ==',380973386096,NULL,1440680354,'1',36150,0,'','0'),
(1655,NULL,'Лохматова Оксана',NULL,'2018-01-09',NULL,380638265476,NULL,1718867639,'1',NULL,0,'','0'),
(1656,NULL,'Глова Христина',NULL,NULL,NULL,NULL,NULL,1167717984,'1',NULL,0,'','1'),
(1657,NULL,'шута оксана',NULL,'2018-01-10',NULL,380951330616,NULL,1277961892,'1',NULL,0,'','0'),
(1658,NULL,'Симоненко Надя',NULL,'2018-01-10',NULL,380976147456,NULL,1755320685,'1',NULL,0,'','0'),
(1659,NULL,'Пендак Валя',NULL,'2018-01-10',NULL,380678970561,NULL,1645495510,'1',31557,1,'','0'),
(1660,NULL,'Пшенишна Світлана',NULL,NULL,NULL,380686257484,NULL,1411005198,'1',NULL,0,'','0'),
(1661,NULL,'Міндна Діана',NULL,'2018-01-10',NULL,380968854230,NULL,2057950546,'1',NULL,0,'','0'),
(1662,NULL,'Грицько Діана',NULL,NULL,NULL,380973078369,NULL,1614225541,'1',NULL,0,'','0'),
(1663,NULL,'Сачева Наталя',NULL,NULL,NULL,380502336614,NULL,1278566933,'1',NULL,0,'','0'),
(1664,NULL,'Макара Маша',NULL,'2018-01-11',NULL,380973223514,NULL,1884673776,'1',NULL,0,'','0'),
(1665,NULL,'вівчар вікторія',NULL,'2018-01-11',NULL,380502282726,NULL,1459072409,'1',NULL,0,'','0'),
(1666,NULL,'Чурпіта наталя',NULL,NULL,NULL,380966827180,NULL,2009870337,'1',NULL,0,'','0'),
(1667,NULL,'Віка Каськів',NULL,'2018-01-11',NULL,380971086845,NULL,1745344901,'1',NULL,0,'','0'),
(1668,0325,'Кулій Юля',NULL,NULL,NULL,380977512487,NULL,1997046423,'1',NULL,0,'','0'),
(1669,NULL,'Шевчук Софія',NULL,'2018-01-11',NULL,380988368107,NULL,1936610706,'1',NULL,0,'','0'),
(1670,NULL,'Леонова Маряна',NULL,'2018-01-12',NULL,380682385383,NULL,1277795452,'1',NULL,0,'','0'),
(1671,NULL,'Ферейра Любов',NULL,'2018-01-12',NULL,380977820215,NULL,1929886550,'1',NULL,0,'','0'),
(1672,NULL,'Громацька Галина',NULL,'2018-01-12',NULL,380968378348,NULL,1815302300,'1',NULL,0,'','0'),
(1673,NULL,'Кепещук Леся',NULL,'2018-01-12',NULL,380935300357,NULL,1160463498,'1',NULL,0,'','0'),
(1674,NULL,'Борик Іра',NULL,'2018-01-12',NULL,380980592270,NULL,1711621863,'1',NULL,0,'','0'),
(1675,NULL,'Прокопів Зоряна',NULL,'2018-01-12',NULL,380963551845,NULL,1411636772,'1',NULL,0,'','0'),
(1676,NULL,'Яницька Христина',NULL,NULL,NULL,380977174656,NULL,1558757697,'1',NULL,0,'','0'),
(1677,NULL,'Фарбота Хрристина',NULL,'2018-01-12',NULL,380986205457,NULL,1134590168,'1',NULL,0,'','0'),
(1678,NULL,'Чвіль Надія',NULL,'2018-01-12',NULL,380972666716,NULL,2010051397,'1',NULL,0,'','0'),
(1679,NULL,'Почапінська Олеся',NULL,'2018-01-12',NULL,380980027781,NULL,1842340304,'1',NULL,0,'','0'),
(1680,NULL,'Король Наталя',NULL,'2018-01-13',NULL,380988067294,NULL,1779887431,'1',NULL,0,'','0'),
(1681,NULL,'Гриців Таня',NULL,'2018-01-13',NULL,380689625827,NULL,1592750909,'1',NULL,0,'','0'),
(1682,0543,'Крисюк Софія',NULL,NULL,NULL,380982191508,NULL,1246640951,'1',NULL,0,'','0'),
(1683,NULL,'парнега марія',NULL,'2018-01-15','r82TKEc+1q5yXBSsoamqLg==',380972315878,NULL,2112392422,'1',NULL,0,'','0'),
(1684,NULL,'Прондюк Галина',NULL,'2018-01-15',NULL,380967266119,NULL,1837264918,'1',NULL,0,'','0'),
(1685,NULL,'Кожухарова Олена',NULL,'2018-01-15',NULL,380987578407,NULL,1529382511,'1',NULL,0,'','0'),
(1686,NULL,'Глухан Христина',NULL,'2018-01-15',NULL,380961951115,NULL,1752147502,'1',NULL,0,'','0'),
(1687,NULL,'Драгомерецька Софія',NULL,'2018-01-15',NULL,380961913457,NULL,1763585331,'1',NULL,0,'','0'),
(1688,NULL,'рогіян оля',NULL,'2018-01-15',NULL,380997392993,NULL,1400641371,'1',NULL,0,'','0'),
(1689,NULL,'Пушкаренко Христина',NULL,NULL,NULL,380977020790,NULL,1982942559,'1',NULL,0,'','0'),
(1690,NULL,'Зіманська Діана',NULL,'2018-01-15',NULL,380963760629,NULL,1643841617,'1',NULL,0,'','0'),
(1691,NULL,'Рущак Таня',NULL,'2018-01-15',NULL,380683238876,NULL,1492332207,'1',NULL,0,'','0'),
(1692,NULL,'чернишова таня',NULL,NULL,NULL,380968073617,NULL,1215675033,'1',NULL,0,'','0'),
(1693,NULL,'Ткач Ірина',NULL,'2018-01-16',NULL,380979302747,NULL,1946764770,'1',NULL,0,'','0'),
(1694,NULL,'Орлик Таня',NULL,'2018-01-16',NULL,380961591052,NULL,2136528212,'1',NULL,0,'','0'),
(1695,NULL,'Катеринюк Наталя',NULL,'2018-01-16',NULL,380685142552,NULL,1388881429,'1',NULL,0,'','0'),
(1696,0315,'Домбровська Юля',NULL,NULL,NULL,380975505046,NULL,1153810618,'1',19718,0,'','0'),
(1697,NULL,'Хруставка Руслана',NULL,'2018-01-16',NULL,380969835094,NULL,1543404117,'1',NULL,0,'','0'),
(1698,NULL,'Галинчак Галя',NULL,'2018-01-17',NULL,380963450579,NULL,1297917983,'1',NULL,0,'','0'),
(1699,NULL,'Романишин Маряна',NULL,'2018-01-17',NULL,380964590338,NULL,1956984502,'1',NULL,0,'','0'),
(1700,NULL,'Феніна Надя',NULL,'2018-01-17',NULL,380969147352,NULL,1867821646,'1',NULL,0,'','0'),
(1701,NULL,'Ландяк Інна',NULL,'2018-01-17',NULL,380964002996,NULL,1605779564,'1',55118,0,'','0'),
(1702,NULL,'Гошуляк Андріана',NULL,'2018-01-17',NULL,380987989148,NULL,1840493699,'1',NULL,0,'','0'),
(1703,NULL,'Ковцун Таня',NULL,'2018-01-18',NULL,380983431246,NULL,1857201726,'1',NULL,0,'','0'),
(1704,NULL,'Навроцька Ірина',NULL,'2018-01-18',NULL,380980188260,NULL,1917154450,'1',NULL,0,'','0'),
(1705,NULL,'Столярська Віка',NULL,'2018-01-18',NULL,380677569398,NULL,1896825414,'1',NULL,0,'','0'),
(1706,NULL,'Рогатин Зоряна',NULL,'2018-01-18',NULL,380987702758,NULL,1865105808,'1',NULL,0,'','0'),
(1707,NULL,'Степанюк Ніна',NULL,'2018-01-18',NULL,380687391986,NULL,1237156203,'1',NULL,0,'','0'),
(1708,NULL,'Срібна Оля',NULL,'2018-01-20',NULL,380685370320,NULL,1374300386,'1',NULL,0,'','0'),
(1709,NULL,'Оксана Наша',NULL,NULL,NULL,NULL,NULL,1168266111,'1',NULL,0,'','0'),
(1710,NULL,'Бугель марта',NULL,'2018-01-20',NULL,380971303702,NULL,2060010858,'1',NULL,0,'','0'),
(1711,NULL,'Нога Марія',NULL,'2018-01-20',NULL,380968422617,NULL,1310920646,'1',NULL,1,'','0'),
(1712,NULL,'Мамчук Маряна',NULL,'2018-01-20',NULL,380966098194,NULL,1689990352,'1',NULL,0,'','0'),
(1713,NULL,'Дехтяренко Люда',NULL,'2018-01-20',NULL,380973409282,NULL,1128988898,'1',NULL,0,'','0'),
(1714,NULL,'Безпалько Андріана',NULL,'2018-01-20',NULL,380678955634,NULL,1972697266,'1',18198,0,'','0'),
(1715,NULL,'Баран Світлана',NULL,'2018-01-20',NULL,380631715870,NULL,1407488471,'1',NULL,0,'','0'),
(1716,NULL,'маланій наталя',NULL,'2018-01-20',NULL,380978565306,NULL,1645861736,'1',21617,1,'','0'),
(1717,NULL,'Полева Соломія ',NULL,'2018-01-22',NULL,380685973750,NULL,1743016509,'1',NULL,0,'','0'),
(1718,NULL,'Стратійчук Віка',NULL,'2018-01-22',NULL,380680861090,NULL,1688878089,'1',NULL,0,'','0'),
(1719,NULL,'Скриник Надія',NULL,'2018-01-22',NULL,380687678663,NULL,1589516854,'1',NULL,0,'','0'),
(1720,NULL,'Шевчук Іванна',NULL,'2018-01-22',NULL,380681775625,NULL,2042588588,'1',NULL,0,'','0'),
(1721,NULL,'Шевчук Марія',NULL,'2018-01-22',NULL,380963843400,NULL,1717544668,'1',NULL,0,'','0'),
(1722,NULL,'Гальтюк Ганна',NULL,'2018-01-22',NULL,380967278306,NULL,1402213988,'1',NULL,0,'','0'),
(1723,NULL,'Струтинська Віка',NULL,'2018-01-22',NULL,380960269915,NULL,1685078103,'1',NULL,0,'','0'),
(1724,NULL,'Кузьма Люба',NULL,'2018-01-22',NULL,380988358745,NULL,1642190829,'1',NULL,0,'','0'),
(1725,NULL,'Брошко Христина',NULL,'2018-01-22',NULL,380676620573,NULL,2071741673,'1',NULL,0,'','0'),
(1726,NULL,'Дворніцька Аліна',NULL,'2018-01-22',NULL,380687701003,NULL,1456776281,'1',NULL,0,'','0'),
(1727,NULL,'Василюк Христина',NULL,'2018-01-22',NULL,380960190629,NULL,1695106079,'1',NULL,0,'','0'),
(1728,NULL,'Строцан Надя',NULL,'2018-01-22',NULL,380979487728,NULL,1359578810,'1',14126,0,'','0'),
(1729,NULL,'Семирозум Оля',NULL,'2018-01-22',NULL,380992016827,NULL,1761256595,'1',NULL,0,'','0'),
(1730,NULL,'Ушій Галина',NULL,'2018-01-22',NULL,380989214185,NULL,1131385365,'1',NULL,0,'','0'),
(1731,NULL,'Стасишин Іра',NULL,'2018-01-23',NULL,380963606204,NULL,1559366073,'1',NULL,0,'','0'),
(1732,NULL,'Батамалюк Іра',NULL,'2018-01-23',NULL,380962853267,NULL,1388478264,'1',NULL,0,'','0'),
(1733,NULL,'Мацебурук Оля',NULL,'2018-01-23',NULL,380505067479,NULL,1368188183,'1',NULL,0,'','0'),
(1734,NULL,'Барчишак Діма',NULL,'2018-01-23',NULL,380970319697,NULL,1557175024,'1',38045,0,'','0'),
(1735,NULL,'Польова Роксолана',NULL,'2018-01-23',NULL,380968876171,NULL,2134144893,'1',NULL,0,'','0'),
(1736,NULL,'Слозанська Юля',NULL,'2018-01-24',NULL,380685535526,NULL,1243938610,'1',NULL,0,'','0'),
(1737,NULL,'Джулінська Наталя',NULL,'2018-01-24',NULL,380962395018,NULL,1157501686,'1',NULL,0,'','0'),
(1738,NULL,'Качмарська Ольга',NULL,'2018-01-24',NULL,380505733254,NULL,1950578565,'1',NULL,0,'','0'),
(1739,NULL,'Прокопчук Віталіна',NULL,'2018-01-24',NULL,380960786043,NULL,1524501596,'1',NULL,0,'','0'),
(1740,NULL,'Білик Маріана',NULL,NULL,NULL,380961502285,NULL,1265667647,'1',NULL,0,'','0'),
(1741,NULL,'Давидчак Наталя',NULL,'2018-01-24',NULL,380962814382,NULL,1314098061,'1',NULL,0,'','0'),
(1742,NULL,'Гладун Іра',NULL,'2018-01-25',NULL,380635466797,NULL,2035709326,'1',NULL,0,'','0'),
(1743,NULL,'Божагора Марія',NULL,'2018-01-25',NULL,380975816235,NULL,1976854421,'1',NULL,0,'','0'),
(1744,NULL,'Паладійчук Наталя',NULL,'2018-01-25',NULL,380984236483,NULL,1718579984,'1',NULL,0,'','0'),
(1745,NULL,'Ковальчук Катя',NULL,NULL,NULL,380671250295,NULL,1591385339,'1',NULL,0,'','0'),
(1746,0505,'Пандрак Іра',NULL,NULL,NULL,380982419833,NULL,2142122917,'0',NULL,0,'','0'),
(1747,NULL,'Пуляк Леся',NULL,'2018-01-26',NULL,380967870035,NULL,1796433853,'1',NULL,0,'','0'),
(1748,NULL,'Адам Оля',NULL,'2018-01-26',NULL,380678379065,NULL,1275090353,'1',NULL,0,'','0'),
(1749,NULL,'Безпалько Наталя',NULL,'2018-01-26',NULL,380971040744,NULL,1637527770,'1',NULL,0,'','0'),
(1750,NULL,'Журба Іра',NULL,'2018-01-26',NULL,380971313002,NULL,1488461857,'1',NULL,0,'','0'),
(1751,0503,'Білів Жанна',NULL,NULL,NULL,380973808286,NULL,1989283517,'1',NULL,0,'','0'),
(1752,NULL,'Гуменюк Наталя',NULL,'2018-01-26',NULL,380678898160,NULL,1750604571,'1',NULL,0,'','0'),
(1753,NULL,'Качмарська Галина',NULL,NULL,NULL,380683350576,NULL,1170179479,'1',NULL,0,'','0'),
(1754,NULL,'Дутко Соломія',NULL,'2018-01-27',NULL,380985862003,NULL,1191036402,'1',NULL,0,'','0'),
(1755,NULL,'Гринчишин Юля',NULL,'2018-01-27',NULL,380977466848,NULL,2049968780,'1',NULL,0,'','0'),
(1756,NULL,'Баран Аня',NULL,'2018-01-27',NULL,380957569213,NULL,1188195297,'1',NULL,0,'','0'),
(1757,NULL,'Ревуцька Таня',NULL,'2018-01-29',NULL,380970880145,NULL,1962759846,'1',NULL,1,'','0'),
(1758,NULL,'Ландяк Христина',NULL,'2018-01-29',NULL,380980512113,NULL,1623564562,'1',NULL,0,'','0'),
(1759,NULL,'Процків Наталя',NULL,'2018-01-29',NULL,380661147100,NULL,2096738100,'1',NULL,0,'','0'),
(1760,NULL,'куць маряна',NULL,'2018-01-29',NULL,380681604887,NULL,1856090829,'1',NULL,0,'','0'),
(1761,NULL,'Огородник Наталя',NULL,'2018-01-30',NULL,380683374260,NULL,1832304694,'1',NULL,0,'','0'),
(1762,NULL,'Деркач Люба',NULL,NULL,NULL,380939423102,NULL,1392199676,'1',NULL,0,'','1'),
(1763,0525,'Грай Марія',NULL,NULL,NULL,380688318234,NULL,1120282991,'1',NULL,0,'','0'),
(1764,NULL,'Худзік Ліда',NULL,'2018-01-30',NULL,380689418522,NULL,1627401576,'1',NULL,0,'','0'),
(1765,NULL,'Бойко Наталя',NULL,'2018-01-30',NULL,380682246727,NULL,2052729283,'1',NULL,0,'','0'),
(1766,NULL,'качмар вероніка',NULL,'2018-01-30',NULL,380966885732,NULL,1875706654,'1',NULL,0,'','0'),
(1767,NULL,'Світцова Зоряна',NULL,'2018-01-31',NULL,380983952984,NULL,1299642786,'1',NULL,0,'','0'),
(1768,NULL,'Юзвішен Леся',NULL,'2018-01-31',NULL,380668627800,NULL,1404114637,'1',NULL,0,'','0'),
(1769,NULL,'Москалик Марія',NULL,'2018-02-01',NULL,380684608766,NULL,2019851602,'1',NULL,0,'','0'),
(1770,NULL,'пігович людмила',NULL,'2018-02-01',NULL,380989009890,NULL,2131562639,'1',NULL,0,'','0'),
(1771,0168,'Хомишин Юля',NULL,NULL,NULL,380984765335,NULL,1440926282,'1',NULL,0,'','0'),
(1772,NULL,'Хомишин Наталя',NULL,'2018-02-01',NULL,380680325835,NULL,1216053631,'1',NULL,1,'','0'),
(1773,NULL,'Петрочко Оля',NULL,'2018-02-01',NULL,380684757079,NULL,1368036095,'1',NULL,0,'','0'),
(1774,NULL,'Леньків Аліна',NULL,NULL,NULL,380682469847,NULL,2047654178,'1',NULL,0,'','0'),
(1775,NULL,'Ковбель Інна',NULL,'2018-02-01',NULL,380993001379,NULL,2117424373,'1',64087,0,'','0'),
(1776,NULL,'Совяк Марія',NULL,NULL,'CKrlnj/y0vdqiPBpOyTTLw==',380967485802,NULL,1227132788,'1',NULL,1,'','0'),
(1777,NULL,'Забіяка Христя',NULL,'2018-02-01',NULL,380988434146,NULL,1384077058,'1',NULL,0,'','0'),
(1778,NULL,'Куц Олег',NULL,'2018-02-01',NULL,380992006264,NULL,1339847979,'1',NULL,0,'','0'),
(1779,0303,'Прохимчук Олександра',NULL,NULL,NULL,380678748774,NULL,1161223870,'1',NULL,2,'','0'),
(1780,0635,'Калань Марина',NULL,NULL,NULL,380977901184,NULL,1562610451,'1',NULL,0,'','0'),
(1781,NULL,'Деркач Люба',NULL,NULL,NULL,NULL,380988228350,1303717153,'1',NULL,0,'','1'),
(1782,NULL,'Шкрібляк Діана',NULL,'2018-02-02',NULL,380965640976,NULL,1337957299,'1',NULL,0,'','0'),
(1783,0895,'Білів Ангеліна',NULL,NULL,'niCkI/MGnesIoD7V7CDvXg==',380980002648,NULL,1430036114,'1',13725,1,'','0'),
(1784,NULL,'Рущак ',NULL,'2018-02-03',NULL,NULL,NULL,1226186438,'1',NULL,0,'','0'),
(1785,0911,'Халанич Соломія',NULL,NULL,NULL,380966571444,NULL,1241115068,'1',NULL,2,'','0'),
(1786,NULL,'Гнатишин Оля',NULL,'2018-02-03',NULL,380675852465,NULL,1947369409,'1',NULL,0,'','0'),
(1787,NULL,'Барчак Наталя',NULL,'2018-02-03',NULL,380974605590,NULL,1435946569,'1',NULL,0,'','0'),
(1788,NULL,'Мельник Алла',NULL,'2018-02-03',NULL,380978394343,NULL,1462681219,'1',NULL,0,'','0'),
(1789,NULL,'Фещак Інна',NULL,'2018-02-03',NULL,380989842341,NULL,1941003668,'1',NULL,0,'','0'),
(1790,NULL,'Павлик Юля',NULL,'2018-02-03',NULL,380976478152,NULL,1849142176,'1',NULL,0,'','0'),
(1791,NULL,'Кокош Настя',NULL,'2018-02-03',NULL,380969895667,NULL,1295583757,'1',NULL,0,'','0'),
(1792,NULL,'Катиренюк Галя',NULL,'2018-02-03',NULL,380675858220,NULL,1252649018,'1',NULL,0,'','0'),
(1793,NULL,'пивовар оксана',NULL,'2018-02-03',NULL,380678825378,NULL,1949712762,'1',NULL,0,'','0'),
(1794,NULL,'Костецька Світлана',NULL,'2018-02-03',NULL,380976623003,NULL,1347905592,'1',NULL,0,'','0'),
(1795,NULL,'Король Ірина',NULL,'2018-02-05',NULL,380958528423,NULL,1162536165,'1',NULL,0,'','0'),
(1796,NULL,'Лучко Любов',NULL,'2018-02-05',NULL,380672982611,NULL,2016710379,'1',NULL,0,'','0'),
(1797,NULL,'сорокіна таня',NULL,'2018-02-05',NULL,380969187102,NULL,1430942736,'1',NULL,0,'','0'),
(1798,NULL,'Загірняк Ірина',NULL,'2018-02-05',NULL,380665560283,NULL,1885485013,'1',NULL,0,'','0'),
(1799,NULL,'харук оксана',NULL,'2018-02-05',NULL,380509512244,NULL,1868718523,'1',NULL,0,'','0'),
(1800,NULL,'Грубенюк Руслана',NULL,'2018-02-05',NULL,380970272820,NULL,1330374095,'1',NULL,0,'','0'),
(1801,NULL,'Клебан Іра',NULL,NULL,'64p1K+qhrn1DONtYr99c9Q==',380677995567,NULL,1701279135,'1',29374,1,'','0'),
(1802,NULL,'павшок таня',NULL,'2018-02-05','wbBPSGgUg7GxEZ47FskVTQ==',380973370225,NULL,1933799308,'1',36450,0,'','0'),
(1803,NULL,'Марущак ілона',NULL,'2018-02-05',NULL,380991668307,NULL,1260095266,'1',NULL,0,'','0'),
(1804,NULL,'кузніцова наталя',NULL,'2018-02-05',NULL,380950981998,NULL,1194799999,'1',NULL,0,'','0'),
(1805,NULL,'сиротюк софія',NULL,'2018-02-05',NULL,380685810430,NULL,1628801709,'1',NULL,0,'','0'),
(1806,NULL,'Глова Христина',NULL,NULL,NULL,380683362527,NULL,2133648273,'1',NULL,0,'','0'),
(1807,NULL,'гундзак марія',NULL,'2018-02-06',NULL,380983240611,NULL,1820991469,'1',NULL,0,'','0'),
(1808,0331,'Холоднюк Ірина',NULL,NULL,NULL,380964378212,NULL,1111872789,'1',NULL,0,'','0'),
(1809,NULL,'Гриненко женя',NULL,'2018-02-06',NULL,380684244686,NULL,1952749895,'1',NULL,0,'','0'),
(1810,NULL,'Климів Маша',NULL,'2018-02-06',NULL,380977550373,NULL,1726350608,'1',NULL,0,'','0'),
(1811,0713,'потапенко ольга',NULL,NULL,NULL,380993195424,NULL,1236081366,'1',NULL,0,'','0'),
(1812,NULL,'Бегма Ірина',NULL,'2018-02-06',NULL,380688180838,NULL,1865285433,'1',NULL,0,'','0'),
(1813,NULL,'Кріль Марта',NULL,'2018-02-06',NULL,380989063590,NULL,1572546386,'1',NULL,0,'','0'),
(1814,NULL,'Чорній Галина ',NULL,'2018-02-07',NULL,380962274403,NULL,2010452034,'1',NULL,0,'','0'),
(1815,NULL,'Мурисова Віка',NULL,'2018-02-07',NULL,380971666852,NULL,1629336546,'1',NULL,0,'','0'),
(1816,NULL,'кучма Альона',NULL,'2018-02-08',NULL,380961842125,NULL,2068978236,'1',NULL,0,'','0'),
(1817,NULL,'олег макар',NULL,'2018-02-08',NULL,380966007276,NULL,1877301535,'1',NULL,0,'','0'),
(1818,NULL,'Чухрій світлана',NULL,'2018-02-08',NULL,380987275135,NULL,1197350964,'1',NULL,0,'','0'),
(1819,NULL,'мельничук оксана',NULL,'2018-02-08',NULL,380983355423,NULL,1435272469,'1',NULL,0,'','0'),
(1820,NULL,'сиротюк оля',NULL,'2018-02-08',NULL,380675090166,NULL,1806794011,'1',NULL,0,'','0'),
(1821,NULL,'Шептицька марія',NULL,'2018-02-08',NULL,380971681063,NULL,1158917925,'1',49578,0,'','0'),
(1822,NULL,'Богуцька Наталя',NULL,'2018-02-08',NULL,380683054507,NULL,1826108850,'1',NULL,2,'','0'),
(1823,NULL,'Світлана Павлюк',NULL,'2018-02-08',NULL,380676021147,NULL,1182753032,'1',NULL,0,'','0'),
(1824,NULL,'Домінік Тетяна ',NULL,'2018-02-09',NULL,380967247259,NULL,1530592174,'1',NULL,0,'','0'),
(1825,NULL,'червона юля',NULL,'2018-02-09',NULL,380961806256,NULL,1690721858,'1',NULL,0,'','0'),
(1826,NULL,'Манчур Ніна',NULL,'2018-02-09',NULL,380979036660,NULL,1315613907,'1',NULL,0,'','0'),
(1827,NULL,'марущак оксана',NULL,'2018-02-10',NULL,380987275354,NULL,1955572961,'1',NULL,0,'','0'),
(1828,NULL,'Гевко Таня',NULL,NULL,NULL,380989206755,NULL,1785666361,'1',NULL,0,'','1'),
(1829,NULL,'Кравченко Надія',NULL,'2018-02-10',NULL,380961886815,NULL,2110409549,'1',NULL,0,'','0'),
(1830,NULL,'Василенька Таня',NULL,'2018-02-10',NULL,380971705539,NULL,1170378426,'1',NULL,0,'','0'),
(1831,NULL,'Костюк Надя',NULL,'2018-02-10',NULL,380983499380,NULL,1718700722,'1',NULL,0,'','0'),
(1832,NULL,'Мередько Наталя',NULL,'2018-02-10',NULL,380987316908,NULL,1942328174,'1',NULL,0,'','0'),
(1833,0553,'Лемішка Альона',NULL,NULL,NULL,380675779897,NULL,1868364969,'1',19587,0,'','0'),
(1834,NULL,'Захарків Іра',NULL,'2018-02-10',NULL,380982520722,NULL,2099155167,'1',11198,0,'','0'),
(1835,NULL,'холоднюк оксана',NULL,'2018-02-12',NULL,380982538541,NULL,2088030029,'1',NULL,0,'','0'),
(1836,NULL,'Паніна Наталя',NULL,'2018-02-12',NULL,380683244374,NULL,2132520753,'1',NULL,0,'','0'),
(1837,NULL,'Греськів Марія',NULL,NULL,NULL,380631425097,NULL,1230716989,'1',NULL,0,'','0'),
(1838,NULL,'Бойчук Юля',NULL,'2018-02-12',NULL,380660234323,NULL,2125017663,'1',NULL,0,'','0'),
(1839,NULL,'рижак ольга',NULL,'2018-02-12','ueZtqkvax8ZJQA54gNZXwg==',380968520875,NULL,1551802827,'1',NULL,0,'','0'),
(1840,NULL,'Раш Оксана',NULL,NULL,NULL,NULL,380982944474,1782098212,'1',NULL,0,'','0'),
(1841,NULL,'Кобзар Наталя',NULL,'2018-02-12',NULL,380960081023,NULL,1278269060,'1',NULL,0,'','0'),
(1842,NULL,'Гнатюк Анастасія',NULL,'2018-02-13',NULL,380686261357,NULL,1778282009,'1',44074,0,'','0'),
(1843,NULL,'Драгомерецька Ірина',NULL,'2018-02-13',NULL,380683844485,NULL,2010900032,'1',NULL,0,'','0'),
(1844,NULL,'Стець Тамара',NULL,'2018-02-13',NULL,380683238879,NULL,1445963021,'1',NULL,0,'','0'),
(1845,0623,'Глек Христя',NULL,NULL,NULL,380666550123,NULL,1628136614,'1',NULL,0,'','0'),
(1846,NULL,'Романець Леся',NULL,'2018-02-14',NULL,380674790799,NULL,1116115368,'1',NULL,0,'','0'),
(1847,NULL,'Замкова Оля',NULL,'2018-02-14',NULL,380984732457,NULL,1747050724,'1',NULL,0,'','0'),
(1848,NULL,'Сокальська Олеся',NULL,NULL,NULL,380965167339,NULL,1542207478,'1',NULL,0,'','0'),
(1849,NULL,'Сименюк Зоряна',NULL,'2018-02-14',NULL,380677682096,NULL,1465068068,'1',NULL,0,'','0'),
(1850,NULL,'Свергун Ліля',NULL,'2018-02-14',NULL,380689318097,NULL,1264870272,'1',NULL,0,'','0'),
(1851,NULL,'Балатко Віка',NULL,'2018-02-15',NULL,380962613890,NULL,1293391908,'1',NULL,0,'','0'),
(1852,NULL,'Білецька Христина',NULL,'2018-02-16',NULL,380982007927,NULL,1224746769,'1',NULL,2,'','0'),
(1853,NULL,'Цурганова Валерія',NULL,'2018-02-16',NULL,380936819790,NULL,1277896068,'1',NULL,0,'','0'),
(1854,NULL,'Біла Юля',NULL,'2018-02-17',NULL,380675945036,NULL,2137745562,'1',NULL,0,'','0'),
(1855,NULL,'Бевз Оксана',NULL,'2018-02-17',NULL,380980070465,NULL,1636911138,'1',NULL,0,'','0'),
(1856,NULL,'парасюк софія',NULL,'2018-02-17',NULL,380996625992,NULL,1839585918,'1',56545,2,'','0'),
(1857,NULL,'Мельниченко Наталя',NULL,'2018-02-19',NULL,380961988641,NULL,1655098778,'1',NULL,0,'','0'),
(1858,NULL,'Чабан Іванна',NULL,NULL,NULL,380684348234,NULL,1716380124,'1',NULL,0,'','0'),
(1859,0311,'Салій Люба',NULL,NULL,NULL,380686455694,NULL,1655948163,'1',NULL,0,'','0'),
(1860,NULL,'Гнатуш Святослава',NULL,'2018-02-19',NULL,380984289308,NULL,2143079574,'1',NULL,0,'','0'),
(1861,NULL,'Криса Марія',NULL,'2018-02-19',NULL,380974741613,NULL,1539241117,'1',NULL,0,'','0'),
(1862,NULL,'Кінаш Олександра',NULL,'2018-02-19',NULL,380989254911,NULL,1295179690,'1',NULL,0,'','0'),
(1863,NULL,'Олексишин Іванна',NULL,'2018-02-20',NULL,380955464538,NULL,1267097269,'1',NULL,0,'','0'),
(1864,NULL,'Дідух Анна',NULL,NULL,NULL,380957479018,380673217898,1345444105,'1',NULL,0,'','0'),
(1865,0539,'Дідик галя',NULL,NULL,NULL,380683327089,NULL,1969042838,'1',NULL,0,'','0'),
(1866,NULL,'Воробець Тетяна',NULL,NULL,NULL,380631547007,NULL,1958950417,'1',NULL,0,'','0'),
(1867,NULL,'Коршняк Ліля',NULL,'2018-02-20',NULL,380968378366,NULL,1551828746,'1',NULL,0,'','0'),
(1868,NULL,'Погорецька Руслана',NULL,'2018-02-21',NULL,NULL,NULL,1532315413,'1',NULL,0,'','0'),
(1869,NULL,'Огородник Анна',NULL,'2018-02-21',NULL,380979209521,NULL,1707017469,'1',NULL,0,'','0'),
(1870,NULL,'Дзьоник Юля',NULL,'2018-02-21',NULL,380968456857,NULL,1401164979,'1',NULL,0,'','0'),
(1871,NULL,'Стасишин ліля',NULL,'2018-02-21',NULL,380967842619,NULL,2036759786,'1',NULL,0,'','0'),
(1872,NULL,'Штуник віка',NULL,NULL,NULL,380980996743,NULL,1593106927,'1',NULL,1,'','0'),
(1873,NULL,'сачева наталя',NULL,NULL,NULL,NULL,NULL,1399099940,'1',NULL,0,'','1'),
(1874,NULL,'Чурпіта Наталя',NULL,'2018-02-21',NULL,NULL,NULL,1621669238,'1',NULL,0,'','0'),
(1875,NULL,'Кухаришин Оля',NULL,'2018-02-22',NULL,380680264687,NULL,1251700711,'1',NULL,0,'','0'),
(1876,NULL,'Манорик Люба',NULL,'2018-02-22',NULL,380960010958,NULL,1684774157,'1',13930,0,'','0'),
(1877,NULL,'Юрків Наталя',NULL,NULL,NULL,380984650497,NULL,1755167167,'1',NULL,0,'','0'),
(1878,NULL,'Дяків Аня',NULL,'2018-02-22',NULL,380685145803,NULL,1683850219,'1',NULL,0,'','0'),
(1879,NULL,'бабій марія',NULL,NULL,NULL,380986502526,NULL,1176700128,'1',NULL,0,'','0'),
(1880,NULL,'макара олександра',NULL,'2018-02-22',NULL,380984063410,NULL,1263527538,'1',NULL,0,'','0'),
(1881,NULL,'Капецька Оксана',NULL,'2018-02-23',NULL,380669564104,NULL,1287584982,'1',NULL,0,'','0'),
(1882,NULL,'Бойко Ірина',NULL,'2018-02-23',NULL,380964387741,NULL,1919563432,'1',NULL,0,'','0'),
(1883,NULL,'Романович Ірина',NULL,'2018-02-23',NULL,380987578267,NULL,1310529361,'1',NULL,0,'','0'),
(1884,NULL,'Кутрик Таня',NULL,'2018-02-23',NULL,380984244085,NULL,1511731485,'1',NULL,0,'','0'),
(1885,NULL,'Новак Оля',NULL,'2018-02-23',NULL,380673939546,NULL,2022410632,'1',NULL,0,'','0'),
(1886,NULL,'Пецкович Дарія',NULL,'2018-02-23',NULL,380961943489,NULL,1233399621,'1',NULL,0,'','0'),
(1887,NULL,'Тарас Бала',NULL,'2018-02-24',NULL,380965119612,NULL,1381776783,'1',NULL,0,'','0'),
(1888,NULL,'Бойчук Оксана',NULL,'2018-02-24',NULL,380983379736,NULL,2008320411,'1',NULL,0,'','0'),
(1889,NULL,'Славіна Кароліна',NULL,'2018-02-26',NULL,380950540773,NULL,1848244605,'1',NULL,0,'','0'),
(1890,NULL,'Барановська Зоряна',NULL,'2018-02-27',NULL,380962319236,NULL,1947565658,'1',NULL,0,'','0'),
(1891,NULL,'Литвин Ганна',NULL,'2018-02-27',NULL,380977645560,NULL,1308716343,'1',NULL,0,'','0'),
(1892,NULL,'Попадюк Ірина',NULL,'2018-02-28',NULL,380688247974,NULL,1666880545,'1',NULL,0,'','0'),
(1893,0665,'Дуда Катя',NULL,NULL,NULL,382970541929,NULL,1278980417,'1',NULL,0,'','0'),
(1894,NULL,'Безлюк Марія',NULL,'2018-02-28',NULL,380970903859,NULL,1910238140,'1',NULL,0,'','0'),
(1895,NULL,'Вархол Надія',NULL,'2018-02-28','3BbrHpkLGDvTBZCOmsxIQQ==',380678487365,NULL,1660545501,'1',NULL,0,'','0'),
(1896,NULL,'Оробчук Галя',NULL,'2018-02-28',NULL,380685296136,NULL,1812382695,'1',55380,0,'','0'),
(1897,NULL,'Федоришин Марія',NULL,'2018-02-28',NULL,380971892697,NULL,1464946707,'1',58015,0,'','0'),
(1898,NULL,'Лучків Марія',NULL,NULL,NULL,380972780717,NULL,1450702754,'1',NULL,0,'','0'),
(1899,NULL,'Білецька Христя',NULL,'2018-02-28',NULL,380684632817,NULL,1855579655,'1',NULL,0,'','0'),
(1900,NULL,'Юріїв Наталя',NULL,'2018-03-01',NULL,380969906865,NULL,1900871735,'1',NULL,0,'','0'),
(1901,NULL,'Юріїв Марія',NULL,NULL,NULL,380988294728,NULL,1679299675,'1',NULL,0,'','0'),
(1902,NULL,'Солтис Ірина',NULL,'2018-03-02',NULL,380686257491,NULL,2130253781,'1',NULL,0,'','0'),
(1903,NULL,'Шкрибайло Марія',NULL,'2018-03-02',NULL,380989254929,NULL,2104028630,'1',NULL,0,'','0'),
(1904,NULL,'Шевченко Богданна',NULL,'2018-03-02',NULL,380501540071,NULL,1186184059,'1',NULL,0,'','0'),
(1905,NULL,'Андрющенко Наталя',NULL,'2018-03-03',NULL,380938595475,NULL,2017963018,'1',NULL,0,'','0'),
(1906,0899,'Грубенюк Віта',NULL,NULL,NULL,380976178072,NULL,1418376348,'1',33794,0,'','0'),
(1907,NULL,'Щербій Леся',NULL,NULL,NULL,380983995396,NULL,2001707829,'1',NULL,0,'','0'),
(1908,NULL,'Храпа Леся',NULL,'2018-03-03',NULL,380678680721,NULL,2039795138,'1',NULL,0,'','0'),
(1909,NULL,'Колосіцька Таня',NULL,'2018-03-05',NULL,380989961152,NULL,1611646297,'1',NULL,0,'','0'),
(1910,0283,'Дюк Іра',NULL,NULL,NULL,380961357040,NULL,1250635522,'1',NULL,0,'','0'),
(1911,NULL,'верес василина',NULL,'2018-03-05',NULL,380969686677,NULL,1610176503,'1',NULL,0,'','0'),
(1912,0263,'Стадник Аня',NULL,NULL,NULL,380688205627,NULL,1146252173,'1',NULL,0,'','0'),
(1913,NULL,'Сенів Наталя',NULL,'2018-03-06',NULL,380680776809,NULL,1387115566,'1',22957,0,'','0'),
(1914,NULL,'Корабель Юля',NULL,'2018-03-06',NULL,380681001171,NULL,1812351113,'1',NULL,2,'','0'),
(1915,NULL,'Куца Надія',NULL,'2018-03-06',NULL,380986491940,NULL,1826910420,'1',NULL,0,'','0'),
(1916,0228,'Тимофій Люда',NULL,NULL,NULL,380664687402,NULL,1403742620,'1',NULL,0,'','0'),
(1917,NULL,'Лавриновська Аня',NULL,NULL,NULL,380961622738,NULL,1231886906,'1',NULL,0,'','0'),
(1918,NULL,'Юнко Ірина',NULL,'2018-03-06',NULL,380971446191,NULL,1996374173,'1',NULL,0,'','0'),
(1919,NULL,'Кобзар Ірина',NULL,'2018-03-07',NULL,380673163128,NULL,2106097348,'1',NULL,0,'','0'),
(1920,NULL,'Сушельницька Соломія',NULL,'2018-03-07',NULL,380939449396,NULL,1626087928,'1',NULL,0,'','0'),
(1921,NULL,'Гавадюк Світлана',NULL,NULL,NULL,380633442092,NULL,1453758565,'1',NULL,0,'','1'),
(1922,NULL,'ільницька олена',NULL,'2018-03-08',NULL,380976616372,NULL,1780647404,'1',NULL,0,'','0'),
(1923,NULL,'Герчак Уляна',NULL,'2018-03-09',NULL,NULL,NULL,1516576173,'1',NULL,0,'','0'),
(1924,NULL,'Юзова Діана',NULL,'2018-03-09',NULL,380971295420,NULL,1475702240,'1',NULL,0,'','0'),
(1925,NULL,'Гоманчук Христина',NULL,'2018-03-09',NULL,380676553212,NULL,1807139134,'1',NULL,0,'','0'),
(1926,NULL,'Юзова Оксана',NULL,'2018-03-09',NULL,380987736868,NULL,2017605818,'1',NULL,0,'','0'),
(1927,0341,'Рудько Іра',NULL,NULL,NULL,380686267596,NULL,1279025828,'1',20352,0,'','0'),
(1928,NULL,'Габянь Наталя',NULL,'2018-03-10',NULL,380960552752,NULL,1655881552,'1',38473,0,'','0'),
(1929,NULL,'Козак Оля',NULL,'2018-03-12',NULL,380966765587,NULL,2047149299,'1',NULL,0,'','0'),
(1930,NULL,'Бурак Галина',NULL,'2018-03-12',NULL,380977739345,NULL,1911418848,'1',NULL,0,'','0'),
(1931,NULL,'Іванців Олена',NULL,NULL,NULL,380985393056,NULL,1283556453,'1',NULL,0,'','0'),
(1932,NULL,'Сидор Іванна',NULL,'2018-03-12',NULL,380976974683,NULL,2133370430,'1',13239,0,'','0'),
(1933,NULL,'Мерещак Зоряна',NULL,'2018-03-12',NULL,380971731510,NULL,1977257754,'1',NULL,0,'','0'),
(1934,NULL,'Крикіцька Олександра',NULL,'2018-03-12',NULL,380985822964,NULL,1608654079,'1',NULL,0,'','0'),
(1935,NULL,'Пасічник Оля',NULL,'2018-03-12',NULL,380965617250,NULL,1465748164,'1',NULL,0,'','0'),
(1936,NULL,'Гуменюк Христина',NULL,NULL,NULL,380685259044,NULL,1910763672,'1',NULL,0,'','0'),
(1937,NULL,'Федорчук Світлана',NULL,'2018-03-12',NULL,380971109835,NULL,2050433013,'1',NULL,0,'','0'),
(1938,NULL,'Тхорик Наталя',NULL,'2018-03-13',NULL,380664974520,NULL,2025647085,'1',NULL,0,'','0'),
(1939,0343,'Голдун Марія',NULL,NULL,NULL,380671639972,NULL,1448249376,'1',NULL,0,'','0'),
(1940,NULL,'Ковальчук Христина',NULL,'2018-03-13',NULL,380963108720,NULL,2105815053,'1',NULL,0,'','0'),
(1941,NULL,'Сайчук Оля',NULL,'2018-03-13',NULL,380681764654,NULL,1602248278,'1',NULL,0,'','0'),
(1942,NULL,'Москаль Марія',NULL,'2018-03-13',NULL,380687410024,NULL,1903227812,'1',NULL,1,'','0'),
(1943,NULL,'Бойко Каріна',NULL,'2018-03-13',NULL,380681835029,NULL,2137517953,'1',NULL,0,'','0'),
(1944,NULL,'Міх Сніжана',NULL,'2018-03-14',NULL,380985484755,NULL,1958739473,'1',NULL,0,'','0'),
(1945,NULL,'Куца Світлана',NULL,'2018-03-14','84J5eYkJs02mXTsNcYrk6Q==',380987250239,NULL,1393938802,'1',NULL,0,'','0'),
(1946,NULL,'Гевко Наталя',NULL,'2018-03-14',NULL,380950519939,NULL,2086796350,'1',NULL,0,'','0'),
(1947,NULL,'Гевко Любомира',NULL,NULL,NULL,NULL,NULL,1574299788,'1',NULL,1,'','1'),
(1948,NULL,'Слабка Олена',NULL,'2018-03-15',NULL,380686866558,NULL,1374545075,'1',NULL,0,'','0'),
(1949,NULL,'Іваськів Оксана',NULL,'2018-03-15',NULL,380677743370,NULL,1191603367,'1',NULL,0,'','0'),
(1950,NULL,'Галанчак Віра',NULL,'2018-03-15',NULL,380967303289,NULL,2000070241,'1',NULL,0,'','0'),
(1951,NULL,'Василевська Каріна',NULL,'2018-03-16',NULL,380977020712,NULL,1735342218,'1',23404,0,'','0'),
(1952,NULL,'Макара Надія',NULL,'2018-03-16',NULL,380980203354,NULL,1397090942,'1',NULL,0,'','0'),
(1953,NULL,'Вася Континент',NULL,'2018-03-16','9qvMyDCcxNskHWOlio8DQA==',380979347454,NULL,1983402202,'1',32286,0,'','0'),
(1954,NULL,'Гевко Марія',NULL,'2018-03-16',NULL,380986459387,NULL,1485859203,'1',NULL,0,'','0'),
(1955,NULL,'Урбан Люда',NULL,'2018-03-16',NULL,380969887933,NULL,1692623567,'1',NULL,0,'','0'),
(1956,NULL,'Кучній Таня',NULL,'2018-03-16',NULL,380685940686,NULL,1420037769,'1',NULL,0,'','0'),
(1957,NULL,'Свистун Аня',NULL,'2018-03-16',NULL,380986173204,NULL,1727233491,'1',NULL,0,'','0'),
(1958,NULL,'Стахів Світлана',NULL,'2018-03-16',NULL,380984677069,NULL,1970317157,'1',NULL,0,'','0'),
(1959,NULL,'Ладан Марія',NULL,'2018-03-17',NULL,380966943606,NULL,1870636273,'1',NULL,0,'','0'),
(1960,NULL,'Жишовська Юля',NULL,'2018-03-17',NULL,380973849543,NULL,1884509352,'1',NULL,0,'','0'),
(1961,NULL,'Крючко Наталя',NULL,'2018-03-19','OfAShdJFkRU/hI/7dgKS0Q==',380689692481,NULL,1169849448,'1',40596,1,'','0'),
(1962,0693,'Трач Вікторія',NULL,NULL,NULL,380965773172,NULL,1215374320,'1',NULL,0,'','0'),
(1963,NULL,'Дмитровка Іванна',NULL,'2018-03-19',NULL,380974215237,NULL,1244647746,'1',NULL,0,'','0'),
(1964,NULL,'Ільків Галина',NULL,'2018-03-19',NULL,380688628134,NULL,1254025761,'1',NULL,0,'','0'),
(1965,0593,'Ткач Оля',NULL,NULL,NULL,380962975954,NULL,1889179355,'1',NULL,0,'','0'),
(1966,NULL,'Корнєєва Настя',NULL,'2018-03-19',NULL,380975707729,NULL,1545253767,'1',NULL,0,'','0'),
(1967,NULL,'Томан Галина',NULL,'2018-03-20',NULL,380682469494,NULL,1473363236,'1',NULL,0,'','0'),
(1968,NULL,'Храпко Оксана',NULL,'2018-03-20',NULL,380674909237,NULL,2025166866,'1',NULL,0,'','0'),
(1969,0661,'Базюк Віка',NULL,NULL,NULL,380680453843,NULL,1891034494,'1',NULL,0,'','0'),
(1970,NULL,'Романович Катя ',NULL,'2018-03-20',NULL,380669110301,NULL,1631132265,'1',NULL,0,'','0'),
(1971,NULL,'Дрозд Марта',NULL,'2018-03-21',NULL,380989746472,NULL,1442286619,'1',NULL,0,'','0'),
(1972,0675,'Пазюк Іванна',NULL,NULL,NULL,380673466795,NULL,1444090638,'1',21540,0,'','0'),
(1973,NULL,'Ягода Сніжана',NULL,'2018-03-21',NULL,380974477406,NULL,1702621157,'1',61739,1,'','0'),
(1974,NULL,'Синчук Оксана',NULL,'2018-03-21',NULL,380988048798,NULL,1334465372,'1',NULL,0,'','0'),
(1975,0731,'Батрин Ірина',NULL,NULL,NULL,380988628910,NULL,1562700257,'1',NULL,0,'','0'),
(1976,NULL,'Вівчар ірина',NULL,'2018-03-21',NULL,380972565147,NULL,1949910752,'1',NULL,0,'','0'),
(1977,0685,'Вітів маша',NULL,NULL,NULL,380686466836,NULL,1452073534,'1',NULL,0,'','0'),
(1978,NULL,'Макарчук Олеся',NULL,'2018-03-21',NULL,380689655378,NULL,1524987120,'1',NULL,0,'','0'),
(1979,0703,'харук леся',NULL,NULL,NULL,380978361226,NULL,1588564449,'1',NULL,1,'','0'),
(1980,NULL,'Малиш таня',NULL,'2018-03-22',NULL,380684337768,NULL,1793491914,'1',NULL,0,'','0'),
(1981,NULL,'Скрипник Наталя',NULL,'2018-03-22',NULL,380957570836,NULL,2080528515,'1',NULL,0,'','0'),
(1982,0651,'Гаврасюк Руслана',NULL,NULL,NULL,380688216534,NULL,1794255641,'1',62000,0,'','0'),
(1983,NULL,'Южда Марія',NULL,'2018-03-22','uDkmkxnceXW0gzhslQK5GA==',380669239334,NULL,1743220089,'1',44511,0,'','0'),
(1984,NULL,'Шварницька Віка',NULL,'2018-03-22',NULL,380971400441,NULL,1676492533,'1',NULL,0,'','0'),
(1985,0607,'Нагірна Таня',NULL,NULL,NULL,380682464547,NULL,1578130038,'1',NULL,0,'','0'),
(1986,0681,'Вознюк Марія',NULL,NULL,NULL,380976648357,NULL,1692170063,'1',NULL,0,'','0'),
(1987,NULL,'Гарасимик Інна',NULL,'2018-03-23',NULL,380967325487,NULL,1503544529,'1',NULL,0,'','0'),
(1988,NULL,'Гаврон Наталя',NULL,'2018-03-23',NULL,380685460259,NULL,1720895278,'1',NULL,0,'','0'),
(1989,NULL,'Дутка Настя',NULL,'2018-03-23',NULL,380972097439,NULL,1158956009,'1',NULL,0,'','0'),
(1990,NULL,'Дутка Марія',NULL,'2018-03-23',NULL,380988937622,NULL,1690640850,'1',NULL,0,'','0'),
(1991,NULL,'Василишин Уляна',NULL,NULL,NULL,380685391883,NULL,1663562558,'1',NULL,0,'','0'),
(1992,NULL,'Триш Галина',NULL,'2018-03-23',NULL,380682380478,NULL,1483268773,'1',NULL,0,'','0'),
(1993,NULL,'Олійник Світлана',NULL,'2018-03-23',NULL,380680240318,NULL,1508013572,'1',NULL,0,'','0'),
(1994,NULL,'Стефінів Оксана',NULL,'2018-03-23',NULL,380976201979,NULL,1670169891,'1',NULL,0,'','0'),
(1995,NULL,'Андрусик Оксана',NULL,'2018-03-23',NULL,380500600507,NULL,1598939508,'1',NULL,0,'','0'),
(1996,NULL,'Верес Галина',NULL,'2018-03-24',NULL,380977526030,NULL,2054788137,'1',NULL,0,'','0'),
(1997,NULL,'Крупесевич юля',NULL,'2018-03-24',NULL,380680577441,NULL,1725478506,'1',NULL,0,'','0'),
(1998,0653,'Репетинська Маряна',NULL,NULL,NULL,380978507296,NULL,1394268452,'1',NULL,0,'','0'),
(1999,0711,'Кусінська Сніжана',NULL,NULL,NULL,380982679904,NULL,1844697521,'1',NULL,0,'','0'),
(2000,NULL,'Герман Інна',NULL,'2018-03-26',NULL,380679430048,NULL,1619601572,'1',NULL,0,'','0');

INSERT INTO `kontragentu` VALUES 
(2001,NULL,'Кубасова Люба',NULL,'2018-03-26',NULL,380678793245,NULL,1897951964,'1',NULL,0,'','0'),
(2002,NULL,'Сасанчин віра',NULL,NULL,NULL,380685837112,NULL,2029546487,'1',NULL,2,'','0'),
(2003,NULL,'Прокопчук Оксана',NULL,'2018-03-26',NULL,380979951307,NULL,1186185774,'1',NULL,0,'','0'),
(2004,NULL,'Загірняк Ірина',NULL,'2018-03-26',NULL,380960869899,NULL,1818330492,'1',NULL,0,'','0'),
(2005,NULL,'Гладка Іра',NULL,'2018-03-26',NULL,380964963662,NULL,1755116160,'1',NULL,0,'','0'),
(2006,NULL,'Кулій Юля',NULL,'2018-03-27',NULL,380963447426,NULL,1928795482,'1',NULL,0,'','0'),
(2007,0701,'Козак Аліна',NULL,NULL,NULL,380979768159,NULL,1509272863,'1',NULL,0,'','0'),
(2008,NULL,'Абасова Амалія',NULL,NULL,NULL,380963356495,NULL,1147129568,'1',NULL,0,'','0'),
(2009,NULL,'Попіль Анастасія',NULL,'2018-03-27',NULL,380987256562,NULL,1218078696,'1',NULL,0,'','0'),
(2010,NULL,'Горобець Марія',NULL,'2018-03-27',NULL,380987943385,NULL,1584507126,'1',NULL,0,'','0'),
(2011,NULL,'Голодрига Марія',NULL,'2018-03-27',NULL,380971096401,NULL,1452311611,'1',49605,0,'','0'),
(2012,NULL,'Гуйван Галина',NULL,'2018-03-27',NULL,380678410700,NULL,1648486799,'1',NULL,0,'','0'),
(2013,NULL,'Ковалишин Віка',NULL,NULL,'icnno11G6IKx3joJKHneow==',380688173275,NULL,1976630283,'1',56203,1,'','0'),
(2014,NULL,'Козак Альона',NULL,'2018-03-27',NULL,380953683574,NULL,1216422290,'1',NULL,0,'','0'),
(2015,NULL,'Скромна Віка',NULL,'2018-03-27',NULL,380970633379,NULL,1556956336,'1',NULL,1,'','0'),
(2016,NULL,'Битковська Оля',NULL,'2018-03-28',NULL,380968775506,NULL,2103380331,'1',NULL,0,'','0'),
(2017,NULL,'Петрущак Таня',NULL,'2018-03-28',NULL,380979790425,NULL,1330743675,'1',NULL,0,'','0'),
(2018,NULL,'Барчишак Іра',NULL,'2018-03-28',NULL,380686261246,NULL,1682450867,'1',22849,0,'','0'),
(2019,NULL,'Кіянчук Надія',NULL,'2018-03-28',NULL,380966603263,NULL,2020677954,'1',NULL,0,'','0'),
(2020,NULL,'Штокало катя',NULL,'2018-03-28',NULL,380951823409,NULL,1145841452,'1',NULL,0,'','0'),
(2021,NULL,'Рапіта Оля',NULL,'2018-03-29',NULL,380675975616,NULL,2115013826,'1',NULL,0,'','0'),
(2022,NULL,'Горбова Наталя',NULL,'2018-03-29',NULL,380964109583,NULL,1306939459,'1',NULL,0,'','0'),
(2023,0683,'Мазепа іванна',NULL,NULL,NULL,380509940959,NULL,1730592769,'1',NULL,0,'','0'),
(2024,NULL,'Дідюк Роза',NULL,'2018-03-30','W4gHne6zVF3yPd7AHF/Y/w==',380687626818,NULL,1115858614,'1',NULL,0,'','0'),
(2025,NULL,'Бідна Світлана',NULL,'2018-03-30',NULL,380986158055,NULL,1762420101,'1',NULL,0,'','0'),
(2026,NULL,'Мерена Надя',NULL,'2018-03-30',NULL,380973168308,NULL,2109229703,'1',NULL,0,'','0'),
(2027,NULL,'Пігірницька Наталя',NULL,'2018-03-30',NULL,380672105650,NULL,2108497162,'1',NULL,0,'','0'),
(2028,NULL,'Сущак Галина',NULL,'2018-03-31',NULL,380987141281,NULL,1934405174,'1',NULL,0,'','0'),
(2029,NULL,'Батрин Галина',NULL,'2018-03-31',NULL,380982903459,NULL,1483570651,'1',NULL,0,'','0'),
(2030,NULL,'Коновалова Ірина',NULL,NULL,NULL,380675803596,NULL,1518797550,'1',NULL,0,'','0'),
(2031,NULL,'Басіста Наталя',NULL,'2018-03-31',NULL,380686495926,NULL,1131792069,'1',41051,0,'','0'),
(2032,NULL,'Шупарська Вероніка',NULL,'2018-03-31',NULL,380680733028,NULL,1138270052,'1',NULL,0,'','0'),
(2033,NULL,'Маковська ольга',NULL,'2018-04-02',NULL,380963031371,NULL,1562484445,'1',NULL,0,'','0'),
(2034,NULL,'перегінець наталя',NULL,'2018-04-02',NULL,380985756617,NULL,1936368961,'1',NULL,0,'','0'),
(2035,NULL,'Черемшинська Ірина',NULL,'2018-04-02','lsXmLKLn+at4myHXc+Qm1w==',380961788411,NULL,1589910934,'1',NULL,0,'','0'),
(2036,NULL,'Пепчук таня',NULL,'2018-04-03',NULL,380983341968,NULL,1720392735,'1',NULL,0,'','0'),
(2037,NULL,'Пепчук Валерія',NULL,'2018-04-03',NULL,380970114776,NULL,1750674166,'1',NULL,0,'','0'),
(2038,NULL,'Курець Анатолій',NULL,'2018-04-03',NULL,380686267583,NULL,2107036393,'1',NULL,0,'','0'),
(2039,NULL,'Олег',NULL,'2018-04-03',NULL,380990710097,NULL,1568189481,'1',NULL,0,'','0'),
(2040,NULL,'Безкоровайна Валентина',NULL,'2018-04-03',NULL,380970527928,NULL,1406989050,'1',43119,0,'','0'),
(2041,NULL,'Побурина Ірина',NULL,'2018-04-03',NULL,380969790888,NULL,1361447970,'1',NULL,0,'','0'),
(2042,NULL,'ОпиханаНаталя',NULL,NULL,NULL,380962811774,NULL,1719965396,'1',NULL,0,'','0'),
(2043,NULL,'Блажієвська Аліна',NULL,'2018-04-03',NULL,380674371742,NULL,2040478330,'1',NULL,0,'','0'),
(2044,NULL,'Трач Роксолана',NULL,'2018-04-03',NULL,380974118256,NULL,2085261506,'1',NULL,0,'','0'),
(2045,NULL,'Шиманська Оксана',NULL,NULL,NULL,380980075756,NULL,1986395061,'1',NULL,0,'','0'),
(2046,NULL,'Мальована Іра',NULL,'2018-04-04',NULL,380968485063,NULL,1825965437,'1',NULL,0,'','0'),
(2047,0281,'Майстер Наталя',NULL,NULL,NULL,380976365929,NULL,1781884230,'1',NULL,0,'','0'),
(2048,NULL,'Тернопільська Наталя',NULL,'2018-04-04',NULL,380988173461,NULL,2032830354,'1',NULL,0,'','0'),
(2049,NULL,'Єншина Марія',NULL,'2018-04-05',NULL,380991219383,NULL,1650071271,'1',NULL,0,'','0'),
(2050,NULL,'Лучків Оля',NULL,NULL,NULL,380930469442,NULL,1769945303,'1',NULL,0,'','0'),
(2051,NULL,'Лучків Валентина',NULL,'2018-04-05',NULL,380635997517,NULL,1532907755,'1',NULL,0,'','0'),
(2052,NULL,'Лучків Оля',NULL,NULL,NULL,380956586827,NULL,1323419062,'1',NULL,0,'','0'),
(2053,NULL,'Салінкіна Маряна',NULL,'2018-04-05',NULL,380960517695,NULL,1247452720,'1',NULL,0,'','0'),
(2054,NULL,'Павлюк Галина',NULL,'2018-04-05',NULL,380688427187,NULL,2015429794,'1',NULL,0,'','0'),
(2055,NULL,'Павлюк Діана',NULL,'2018-04-05',NULL,380971777059,NULL,1786014927,'1',NULL,0,'','0'),
(2056,NULL,'Чехніта ВІка',NULL,'2018-04-05',NULL,380964179309,NULL,1150578161,'1',NULL,0,'','0'),
(2057,NULL,'Ткач Христя',NULL,'2018-04-05',NULL,380971113863,NULL,1147936762,'1',NULL,0,'','0'),
(2058,NULL,'Таран Галина',NULL,'2018-04-06',NULL,380967972119,NULL,1201556411,'1',NULL,0,'','0'),
(2059,NULL,'Тіпалова Віталіна',NULL,'2018-04-11',NULL,380990915964,NULL,2065959049,'1',47164,0,'','0'),
(2060,NULL,'Корчак Каріна',NULL,'2018-04-11',NULL,380984489327,NULL,1293675175,'1',NULL,0,'','0'),
(2061,NULL,'Оленич Таня',NULL,'2018-04-11',NULL,380977098516,NULL,1515646888,'1',NULL,0,'','0'),
(2062,NULL,'Смеречинська Надя',NULL,'2018-04-11',NULL,380986697731,NULL,1143736433,'1',NULL,0,'','0'),
(2063,0939,'Слоїк Антоніна',NULL,NULL,NULL,380979278480,NULL,1263728888,'1',NULL,0,'','0'),
(2064,0575,'Пандак Слава',NULL,NULL,NULL,380984127379,NULL,1746422458,'1',NULL,0,'','0'),
(2065,NULL,'Левчак Руслана',NULL,'2018-04-12',NULL,380685379599,NULL,1161941886,'1',NULL,0,'','0'),
(2066,NULL,'Клапцуняк Світлана',NULL,'2018-04-12',NULL,380978400300,NULL,1829020249,'1',NULL,0,'','0'),
(2067,NULL,'Ханевич Оксана',NULL,'2018-04-12',NULL,380979413920,NULL,2138347632,'1',NULL,0,'','0'),
(2068,NULL,'Мелимука Настя',NULL,NULL,NULL,380681692469,NULL,1144009260,'1',NULL,0,'','0'),
(2069,NULL,' Рибачок Настя',NULL,'2018-04-12',NULL,380976154808,NULL,1221320179,'1',NULL,0,'','0'),
(2070,NULL,'Богачук Назар',NULL,'2018-04-12',NULL,380964489559,NULL,1803080236,'1',NULL,0,'','0'),
(2071,NULL,'Грешкова Таня',NULL,'2018-04-12',NULL,380982537602,NULL,1369417063,'1',NULL,0,'','0'),
(2072,NULL,'бадлюк маша',NULL,'2018-04-13',NULL,380978395746,NULL,1449214754,'1',NULL,0,'','0'),
(2073,NULL,'Савків Марія',NULL,'2018-04-13',NULL,380961665317,NULL,1380283664,'1',NULL,0,'','0'),
(2074,0261,'Петрів Вероніка',NULL,NULL,NULL,380673907980,NULL,1576064065,'1',NULL,0,'','0'),
(2075,NULL,'Батрин Уляна',NULL,NULL,'FQEjha405KOjUwoUUysvCw==',380678489392,NULL,1484799442,'1',65174,1,'','0'),
(2076,NULL,'Батрин Олена',NULL,'2018-04-13',NULL,380983682298,NULL,1989643493,'1',NULL,0,'','0'),
(2077,NULL,'Мелимука Олеся',NULL,'2018-04-13',NULL,380672855280,NULL,1745334347,'1',NULL,0,'','0'),
(2078,NULL,'Кулик Віта',NULL,'2018-04-13',NULL,380668145315,NULL,1852166046,'1',NULL,0,'','0'),
(2079,NULL,'Братанич Юля',NULL,NULL,NULL,380678854828,NULL,1570072545,'1',NULL,0,'','0'),
(2080,NULL,'Басів Іра',NULL,'2018-04-13',NULL,380680411207,NULL,2125460533,'1',NULL,0,'','0'),
(2081,NULL,'Кшевська Галя',NULL,'2018-04-13',NULL,380960868896,NULL,1847423449,'1',NULL,0,'','0'),
(2082,NULL,'Фреляк Юля',NULL,'2018-04-13',NULL,380972336546,NULL,1221088890,'1',NULL,0,'','0'),
(2083,NULL,'Нагірна Таня',NULL,'2018-04-14',NULL,380683578004,NULL,1868880743,'1',NULL,0,'','0'),
(2084,NULL,'Толубяк Марія',NULL,'2018-04-14',NULL,380984237703,NULL,1838254148,'1',NULL,0,'','0'),
(2085,NULL,'Венгрин Юля',NULL,'2018-04-14',NULL,380969302790,NULL,1231980847,'1',NULL,0,'','0'),
(2086,NULL,'Остафій Іванна',NULL,NULL,NULL,380688451280,NULL,1334912681,'1',NULL,0,'','0'),
(2087,NULL,'Скромна Світлана',NULL,'2018-04-14',NULL,380680245527,NULL,1877304916,'1',NULL,0,'','0'),
(2088,NULL,'Бойків Ліда',NULL,'2018-04-14','QmrwsicH6W7VJ2dtn5ZEXQ==',380961180799,NULL,1783673685,'1',22855,0,'','0'),
(2089,NULL,'івашків Марія',NULL,NULL,NULL,380685459268,NULL,1156056396,'1',NULL,0,'','0'),
(2090,0545,'Середа Наталя',NULL,NULL,'NupzkSWu4064GSxBRjKdrA==',380689418904,NULL,1957017522,'1',34822,0,'','0'),
(2091,NULL,'Балацко Христина',NULL,'2018-04-16',NULL,380970534322,NULL,1707133028,'1',NULL,0,'','0'),
(2092,NULL,'Гавринюк Галина',NULL,'2018-04-16',NULL,380988453250,NULL,1249847070,'1',NULL,0,'','0'),
(2093,NULL,'Суха Ірина',NULL,'2018-04-16',NULL,380962956149,NULL,1394530818,'1',NULL,0,'','0'),
(2094,NULL,'Семенчук Вікторія',NULL,'2018-04-16',NULL,380681765682,NULL,1838982876,'1',NULL,0,'','0'),
(2095,NULL,'Березюк Таня',NULL,NULL,NULL,380979844133,NULL,1834034617,'1',NULL,0,'','0'),
(2096,NULL,'Товпига Оля',NULL,'2018-04-16',NULL,380985074886,NULL,1412507088,'1',NULL,0,'','0'),
(2097,NULL,'Оля (нова)',NULL,'2018-04-16','mlXNFg89j9mkwrXQ1AN8oA==',380978201048,NULL,2111112891,'1',36760,0,'','0'),
(2098,0591,'Полянська Іра',NULL,NULL,'HyB2hEZ9nDWVcv8XJFAbBg==',380672823626,NULL,2111600076,'1',11858,0,'','0'),
(2099,NULL,'Каськів Вікторія',NULL,'2018-04-16',NULL,380668213610,NULL,1276373197,'1',NULL,0,'','0'),
(2100,NULL,'Свідерська Марія',NULL,'2018-04-17',NULL,380986227861,NULL,1327361092,'1',NULL,0,'','0'),
(2101,NULL,'Приймак Іванка',NULL,'2018-04-17',NULL,380978512542,NULL,2126500665,'1',NULL,1,'','0'),
(2102,NULL,'Ягода Оля',NULL,'2018-04-17',NULL,380984119079,NULL,1915089755,'1',NULL,1,'','0'),
(2103,NULL,'Надвернюк Марія',NULL,NULL,NULL,380988628960,NULL,1585369722,'1',NULL,0,'','0'),
(2104,NULL,'мороз оксана',NULL,NULL,NULL,380685053379,NULL,1859140946,'1',47964,0,'','0'),
(2105,NULL,'Вівчарик Христина',NULL,'2018-04-17',NULL,380977085564,NULL,1520484959,'1',NULL,0,'','0'),
(2106,NULL,'Турчак Віта',NULL,NULL,NULL,380678954417,NULL,1843640943,'1',29983,0,'','0'),
(2107,NULL,'савків надія ',NULL,'2018-04-18',NULL,380674623815,NULL,1930358375,'1',NULL,0,'','0'),
(2108,NULL,'Лазарик Христя',NULL,'2018-04-18',NULL,380992551566,NULL,1352490634,'1',NULL,0,'','0'),
(2109,0321,'Виничук Галина',NULL,NULL,NULL,380970883906,NULL,1426052718,'1',NULL,0,'','0'),
(2110,NULL,'Гриців Світлана',NULL,'2018-04-18',NULL,380686132478,NULL,1374350910,'1',NULL,0,'','0'),
(2111,NULL,'тест',NULL,'2018-04-18',NULL,380500000000,NULL,1871064534,'1',NULL,0,'','0'),
(2112,NULL,'тест',NULL,'2018-04-18',NULL,380500000001,NULL,1978490230,'1',NULL,0,'','0'),
(2113,NULL,'микола',NULL,'2018-04-18',NULL,NULL,NULL,1820549297,'1',NULL,0,'','0'),
(2114,NULL,'Козак Оля',NULL,'2018-04-18',NULL,380972163574,NULL,1150850582,'1',NULL,0,'','0'),
(2115,NULL,'Клекоцюк Ліля',NULL,'2018-04-18',NULL,380956987123,NULL,1639019646,'1',NULL,0,'','0'),
(2116,NULL,'Штира Оксана',NULL,'2018-04-18',NULL,380682441076,NULL,1466982452,'1',50074,1,'','0'),
(2117,NULL,'Дзюба Люба',NULL,'2018-04-19',NULL,380686242977,NULL,1882512593,'1',NULL,0,'','0'),
(2118,NULL,'Саска Ірина ',NULL,'2018-04-19',NULL,380976630680,NULL,1975662004,'1',64840,1,'','0'),
(2119,NULL,'Товпига Інна',NULL,'2018-04-19',NULL,380672704303,NULL,1578170356,'1',NULL,0,'','0'),
(2120,NULL,'Палагнюк Оля',NULL,'2018-04-19',NULL,380680272717,NULL,1882736056,'1',NULL,0,'','0'),
(2121,NULL,'Кінаш Люда',NULL,NULL,NULL,380501896846,NULL,1230743238,'1',NULL,0,'','0'),
(2122,NULL,'Пельцер Таня',NULL,'2018-04-19',NULL,380673358351,NULL,2134646904,'1',NULL,0,'','0'),
(2123,NULL,'Гринчук Ольга',NULL,'2018-04-20',NULL,380971897740,NULL,1888901319,'1',NULL,0,'','0'),
(2124,NULL,'белизюк марія',NULL,'2018-04-20',NULL,380680171923,NULL,2043630879,'1',NULL,0,'','0'),
(2125,NULL,'Маклякова Діана',NULL,'2018-04-20',NULL,380976621501,NULL,1528350049,'1',NULL,0,'','0'),
(2126,NULL,'Дроздоваська Маріія',NULL,'2018-04-20',NULL,380985339191,NULL,1625734091,'1',NULL,0,'','0'),
(2127,0673,'Худобяк Юля',NULL,NULL,NULL,380677657855,NULL,1280612274,'1',NULL,0,'','0'),
(2128,NULL,'Бурак Оля',NULL,'2018-04-20',NULL,380962961326,NULL,1173166593,'1',NULL,0,'','0'),
(2129,NULL,'Семчишин Андріана',NULL,'2018-04-20',NULL,380972647227,NULL,1357974991,'1',57080,0,'','0'),
(2130,NULL,'Герасимів Уляна',NULL,'2018-04-20',NULL,380671102717,NULL,1686665281,'1',NULL,0,'','0'),
(2131,NULL,'божагора оля',NULL,NULL,NULL,380683849682,NULL,1722013553,'1',NULL,0,'','1'),
(2132,NULL,'Котовська Наталя',NULL,'2018-04-21',NULL,380680306623,NULL,1856095105,'1',NULL,0,'','0'),
(2133,NULL,'лось марія',NULL,'2018-04-21',NULL,380974759053,NULL,1204419991,'1',NULL,0,'','0'),
(2134,NULL,'стухляк наталя',NULL,'2018-04-23',NULL,380965552158,NULL,1487445008,'1',21510,0,'','0'),
(2135,NULL,'Чмола Таня',NULL,'2018-04-23',NULL,380979267449,NULL,1745317625,'1',NULL,0,'','0'),
(2136,NULL,'Бойко ЛІля',NULL,'2018-04-23',NULL,380687036439,NULL,2090656683,'1',NULL,0,'','0'),
(2137,NULL,'Мельничук Наталя',NULL,'2018-04-23','MY7v6DimP7BG5F+TTEu18A==',380959456282,NULL,1199069341,'1',NULL,0,'','0'),
(2138,NULL,'Білошицька Юля',NULL,'2018-04-23',NULL,380506485508,NULL,2143667800,'1',NULL,0,'','0'),
(2139,NULL,'Лучків Оля',NULL,'2018-04-23',NULL,380639886760,NULL,1612666787,'1',NULL,0,'','0'),
(2140,NULL,'Сулима Олена',NULL,NULL,NULL,380978126355,NULL,1453370020,'1',NULL,0,'','0'),
(2141,NULL,'Храпко Андрій',NULL,'2018-04-23',NULL,380674910025,NULL,1402892562,'1',NULL,0,'','0'),
(2142,NULL,'Юркевич Оксана',NULL,'2018-04-23',NULL,380987553931,NULL,1126550765,'1',NULL,0,'','0'),
(2143,NULL,'Гузак Марія',NULL,'2018-04-23',NULL,380687640943,NULL,2048887973,'1',NULL,0,'','0'),
(2144,NULL,'рудак тетяна',NULL,'2018-04-23',NULL,380676085076,NULL,2129967726,'1',NULL,0,'','0'),
(2145,NULL,'Пастушенко Марія',NULL,'2018-04-23','G6ne7e0PCMxRaGE97Mp6Bg==',380984825956,NULL,1115902615,'1',35197,0,'','0'),
(2146,0585,'Ярич Софія',NULL,NULL,NULL,380685574681,NULL,1386788747,'1',35062,3,'','0'),
(2147,NULL,'Обертас Олена',NULL,NULL,NULL,380506574434,NULL,1596624772,'1',NULL,0,'','0'),
(2148,NULL,'Золота Світлана',NULL,'2018-04-23',NULL,380689996748,NULL,1293788216,'1',NULL,0,'','0'),
(2149,NULL,'Голодівська Ілона',NULL,'2018-04-24',NULL,380681471445,NULL,2048989872,'1',NULL,0,'','0'),
(2150,NULL,'Вовкова Іра',NULL,'2018-04-24',NULL,380685141508,NULL,1821939456,'1',NULL,3,'','0'),
(2151,NULL,'Марчук Наталя',NULL,'2018-04-24',NULL,380987974198,NULL,2042128705,'1',NULL,0,'','0'),
(2152,NULL,'Рудик Аня',NULL,NULL,'UT7ygJZCWdwlMJaoNcaviQ==',380688572207,NULL,1297886681,'1',65021,0,'','0'),
(2153,NULL,' Гандзюк Надя',NULL,'2018-04-24',NULL,380976636262,NULL,1756490201,'1',NULL,0,'','0'),
(2154,NULL,'Біла Христина',NULL,'2018-04-25',NULL,380677454826,NULL,1934198503,'1',NULL,0,'','0'),
(2155,NULL,'Чура Світлана',NULL,'2018-04-25',NULL,380684266260,NULL,2015187452,'1',NULL,0,'','0'),
(2156,NULL,'Чура Оксана',NULL,'2018-04-25',NULL,380966956358,NULL,1995178087,'1',NULL,0,'','0'),
(2157,0915,'Ландяк Богданна',NULL,NULL,'NHBj0xAvJ8NTG4Vszm91vw==',380682831733,NULL,1839564392,'1',NULL,0,'','0'),
(2158,0933,'Мурава Люда',NULL,NULL,NULL,380968765700,NULL,1826583396,'1',NULL,0,'','0'),
(2159,NULL,'Черній Альона',NULL,'2018-04-25',NULL,380981779016,NULL,2024930025,'1',NULL,0,'','0'),
(2160,NULL,'Гавриляк Діана',NULL,'2018-04-25',NULL,380969290310,NULL,1755496135,'1',NULL,0,'','0'),
(2161,NULL,'Дерій Ірина',NULL,NULL,NULL,380977605810,NULL,1922257821,'1',NULL,0,'','0'),
(2162,NULL,'харук марія',NULL,'2018-04-26',NULL,380977581449,NULL,1604680793,'1',NULL,0,'','0'),
(2163,NULL,'Ковальчук Олександра',NULL,'2018-04-26',NULL,380687353835,NULL,1357825518,'1',NULL,0,'','0'),
(2164,NULL,'Сапіщук Уляна',NULL,'2018-04-26',NULL,380987651819,NULL,1401767286,'1',NULL,0,'','0'),
(2165,NULL,'Гавадюк Наталя',NULL,'2018-04-26',NULL,380985027073,NULL,1212473651,'1',NULL,0,'','0'),
(2166,NULL,'Сеник Світлана',NULL,'2018-04-26',NULL,380970343734,NULL,1561571398,'1',NULL,0,'','0'),
(2167,NULL,'Равлюк Галина',NULL,'2018-04-26',NULL,380971127138,NULL,1155645883,'1',NULL,0,'','0'),
(2168,NULL,'Слота Оля',NULL,NULL,NULL,380975490770,NULL,2056987109,'1',NULL,0,'','0'),
(2169,NULL,'Олійник Юля',NULL,'2018-04-26',NULL,380971136331,NULL,1769660886,'1',NULL,0,'','0'),
(2170,NULL,'Нагірна Вероніка',NULL,'2018-04-27',NULL,380680109472,NULL,1549971139,'1',NULL,0,'','0'),
(2171,NULL,'Якимець Світлана',NULL,'2018-04-27',NULL,380687895089,NULL,1117212866,'1',NULL,0,'','0'),
(2172,NULL,'Конюх Юлія',NULL,'2018-04-27',NULL,380672827354,NULL,1549867421,'1',NULL,0,'','0'),
(2173,NULL,'Петришен Таня',NULL,'2018-04-27',NULL,380982520729,NULL,2016148404,'1',NULL,0,'','0'),
(2174,NULL,'Боднар Олена',NULL,'2018-04-27',NULL,380989659372,NULL,1951106183,'1',NULL,0,'','0'),
(2175,NULL,'Зубик Христя',NULL,'2018-04-27',NULL,380971720439,NULL,1622957060,'1',NULL,0,'','0'),
(2176,NULL,'Солярська Віка',NULL,NULL,NULL,380677569198,NULL,1600304172,'1',NULL,0,'','1'),
(2177,NULL,'Гевко Оля',NULL,'2018-04-27',NULL,380976079488,NULL,1198756868,'1',NULL,0,'','0'),
(2178,NULL,'Слободян Люба',NULL,'2018-04-27',NULL,380502635404,NULL,1603166725,'1',NULL,0,'','0'),
(2179,NULL,'горачко лілія',NULL,'2018-04-28',NULL,380959482620,NULL,1421976294,'1',NULL,0,'','0'),
(2180,NULL,'Боднар таня',NULL,'2018-04-28',NULL,380999538125,NULL,2061640899,'1',NULL,0,'','0'),
(2181,NULL,'Світлана',NULL,'2018-04-28',NULL,380984237874,NULL,1864086518,'1',NULL,0,'','0'),
(2182,NULL,'Повшок Надя',NULL,'2018-04-30',NULL,380680204953,NULL,1503718745,'1',NULL,0,'','0'),
(2183,NULL,'Дерій Наталя',NULL,'2018-04-30',NULL,380684211829,NULL,1237914281,'1',NULL,0,'','0'),
(2184,NULL,'Бук Таня',NULL,'2018-04-30',NULL,380686262387,NULL,1233455947,'1',NULL,0,'','0'),
(2185,NULL,'Бук Мирослава',NULL,'2018-04-30',NULL,380976222372,NULL,1396098589,'1',NULL,0,'','0'),
(2186,NULL,'Вавришин Мирослава',NULL,'2018-04-30',NULL,380686299366,NULL,1231394006,'1',NULL,0,'','0'),
(2187,NULL,'Власюк Олеся',NULL,'2018-04-30',NULL,380986627110,NULL,2033978232,'1',NULL,0,'','0'),
(2188,NULL,'Кілівнік Таня',NULL,'2018-04-30',NULL,380961298340,NULL,1219150624,'1',44462,0,'','0'),
(2189,NULL,'Кілівнік Ірина',NULL,'2018-04-30',NULL,380671225379,NULL,1827238456,'1',23561,0,'','0'),
(2190,NULL,'Березій Іра',NULL,'2018-04-30',NULL,380976071677,NULL,1749696982,'1',NULL,0,'','0'),
(2191,NULL,'Салінкіна ОЛя',NULL,'2018-04-30',NULL,380951521728,NULL,2127721585,'1',NULL,0,'','0'),
(2192,NULL,'Сведюк Галина',NULL,'2018-04-30',NULL,380967842552,NULL,1919049771,'1',NULL,0,'','0'),
(2193,NULL,'Рибіна Наталя',NULL,'2018-04-30',NULL,380681718710,NULL,1141792125,'1',NULL,0,'','0'),
(2194,NULL,'Попадюк Марія',NULL,'2018-04-30',NULL,380963703260,NULL,2103691952,'1',NULL,0,'','0'),
(2195,NULL,'Соболевська Олена',NULL,'2018-04-30',NULL,380994026427,NULL,1922915085,'1',NULL,0,'','0'),
(2196,NULL,'Кохан Христина',NULL,'2018-04-30',NULL,380993243022,NULL,1281093824,'1',NULL,0,'','0'),
(2197,NULL,'Прокіпчук Марія',NULL,'2018-04-30',NULL,380976597573,NULL,1331708392,'1',NULL,0,'','0'),
(2198,NULL,'Шимко Діана',NULL,'2018-04-30',NULL,380687134212,NULL,1822680195,'1',NULL,0,'','0'),
(2199,NULL,'гепак христина',NULL,'2018-05-01',NULL,380689696070,NULL,2138404119,'1',NULL,0,'','0'),
(2200,NULL,'Савчук Ліля',NULL,'2018-05-01',NULL,380978482741,NULL,1716018758,'1',NULL,0,'','0'),
(2201,NULL,'Козак Таня',NULL,'2018-05-01',NULL,380979767913,NULL,1141348620,'1',NULL,0,'','0'),
(2202,NULL,'Галанюк Оля',NULL,'2018-05-01',NULL,380971270535,NULL,1388617504,'1',NULL,0,'','0'),
(2203,NULL,'Я',NULL,'2018-05-01',NULL,NULL,NULL,1738101386,'1',NULL,0,'','0'),
(2204,NULL,'Антощук Оксана',NULL,'2018-05-01',NULL,380965638833,NULL,1178631432,'1',NULL,0,'','0'),
(2205,NULL,'Пельвецька Наталя',NULL,'2018-05-02',NULL,380673374260,NULL,1759895418,'1',NULL,0,'','0'),
(2206,NULL,'Опульська Валя',NULL,'2018-05-02',NULL,380984289177,NULL,1966329364,'1',NULL,0,'','0'),
(2207,NULL,'Солодяк Таня',NULL,'2018-05-02',NULL,380992742861,NULL,1391361472,'1',NULL,0,'','0'),
(2208,NULL,'Опацька Оксана',NULL,'2018-05-02',NULL,380987654506,NULL,2048111527,'1',NULL,0,'','0'),
(2209,NULL,'Вівчар Софія',NULL,'2018-05-02',NULL,380967348142,NULL,1211925773,'1',NULL,0,'','0'),
(2210,NULL,'Хомин Любов',NULL,'2018-05-02',NULL,380689517020,NULL,1114422236,'1',NULL,0,'','0'),
(2211,NULL,'Вівчар Надія',NULL,'2018-05-02',NULL,380976840507,NULL,1221918527,'1',NULL,0,'','0'),
(2212,NULL,'Фотчук Світлана',NULL,'2018-05-02',NULL,380980689403,NULL,1309083847,'1',NULL,0,'','0'),
(2213,NULL,'Богуцька Таня',NULL,'2018-05-02',NULL,380987318366,NULL,1767678456,'1',NULL,0,'','0'),
(2214,NULL,'Бабій Настя',NULL,'2018-05-02',NULL,380970883389,NULL,1374856500,'1',NULL,0,'','0'),
(2215,NULL,'Наконечна Маряна',NULL,'2018-05-02',NULL,380985393430,NULL,1481421837,'1',NULL,0,'','0'),
(2216,NULL,'Бабій Маряна',NULL,'2018-05-03',NULL,380993785455,NULL,1975963289,'1',NULL,0,'','0'),
(2217,NULL,'Опацька Оля',NULL,'2018-05-03',NULL,380980561791,NULL,2096877815,'1',NULL,0,'','0'),
(2218,NULL,'Золота Вікторія',NULL,'2018-05-03',NULL,380969302793,NULL,1819851036,'1',NULL,0,'','0'),
(2219,NULL,'Вівчарик Ірина',NULL,'2018-05-03',NULL,380959248997,NULL,1475957027,'1',NULL,0,'','0'),
(2220,NULL,'Кравець Зіновія',NULL,'2018-05-03',NULL,380961353076,NULL,2056188964,'1',NULL,0,'','0'),
(2221,NULL,'ющак оксана',NULL,'2018-05-03',NULL,380687633443,NULL,1607581494,'1',NULL,0,'','0'),
(2222,NULL,'Юрків Наталя',NULL,NULL,NULL,380964022787,NULL,1487398877,'1',NULL,0,'','0'),
(2223,NULL,'валя мілевська',NULL,'2018-05-03',NULL,380674271129,NULL,1458540281,'1',NULL,0,'','0'),
(2224,NULL,'Шклярська Світлана',NULL,'2018-05-04',NULL,380994804882,NULL,1607313193,'1',NULL,0,'','0'),
(2225,NULL,'Петухова Іванна',NULL,'2018-05-04',NULL,380981317140,NULL,1398708124,'1',NULL,0,'','0'),
(2226,NULL,'Соколовськка Оля',NULL,'2018-05-04',NULL,380684294604,NULL,1636115327,'1',NULL,0,'','0'),
(2227,NULL,'Скопик Галина',NULL,'2018-05-04',NULL,380686394850,NULL,1711027054,'1',NULL,3,'','0'),
(2228,NULL,'Король Маряна',NULL,'2018-05-04',NULL,380684297274,NULL,1583397792,'1',NULL,0,'','0'),
(2229,NULL,'Берик Олена',NULL,'2018-05-04',NULL,380678428323,NULL,1206807442,'1',NULL,0,'','0'),
(2230,NULL,'степанець адріана',NULL,'2018-05-04',NULL,380964119731,NULL,1745668564,'1',NULL,0,'','0'),
(2231,NULL,'Лілович Оля',NULL,'2018-05-04',NULL,380685124539,NULL,1997602993,'1',NULL,0,'','0'),
(2232,NULL,'Шімка свєта',NULL,'2018-05-04',NULL,380964370505,NULL,1899922056,'1',NULL,0,'','0'),
(2233,NULL,'ЯКУБІВ ЛЕСЯ',NULL,'2018-05-05',NULL,790998818839,NULL,1216289554,'1',NULL,0,'','0'),
(2234,NULL,'Ковальчук Оксана',NULL,'2018-05-05',NULL,380992591592,NULL,1295617590,'1',NULL,0,'','0'),
(2235,NULL,'дідик маряна',NULL,'2018-05-05',NULL,380680796395,NULL,1985967372,'1',NULL,0,'','0'),
(2236,NULL,'шваг наталя',NULL,'2018-05-05',NULL,380999192239,NULL,1558532429,'1',NULL,0,'','0'),
(2237,NULL,'борейко юлія',NULL,'2018-05-05',NULL,380967383038,NULL,1318749601,'1',NULL,0,'','0'),
(2238,NULL,'Вівчар Ірина',NULL,NULL,'/4trtaalX1bpk3XV7mSY8Q==',380979732374,NULL,1583077531,'1',54079,0,'','0'),
(2239,NULL,'Ксьонжик Тетяна',NULL,NULL,NULL,380684234193,NULL,1354816289,'1',NULL,1,'','0'),
(2240,NULL,'Пастущак Інна',NULL,'2018-05-05',NULL,380972716121,NULL,1197512274,'1',NULL,0,'','0'),
(2241,0531,'Окіпна Софія',NULL,NULL,NULL,380668277499,NULL,1593162481,'1',NULL,0,'','0'),
(2242,NULL,'Москалик Сніжана',NULL,NULL,NULL,380965009488,NULL,2034674413,'1',NULL,0,'','0'),
(2243,NULL,'Москалик ОЛя',NULL,'2018-05-07',NULL,380971486439,NULL,1242288023,'1',NULL,0,'','0'),
(2244,NULL,'Бойко Марія',NULL,NULL,NULL,380976072062,NULL,1493971810,'1',NULL,0,'','0'),
(2245,NULL,'Сасанчин Віка',NULL,'2018-05-07',NULL,380973669129,NULL,1634696467,'1',NULL,0,'','0'),
(2246,NULL,'Кусарська Богдана',NULL,'2018-05-07',NULL,380678798011,NULL,1406071521,'1',NULL,1,'','0'),
(2247,NULL,'Шмадило Галя',NULL,'2018-05-07',NULL,380636418221,NULL,1211227900,'1',NULL,0,'','0'),
(2248,NULL,'Біленко Аліна',NULL,'2018-05-07',NULL,380931002213,NULL,1472204821,'1',NULL,0,'','0'),
(2249,NULL,'Стрембіцька Христина',NULL,NULL,'jsHLWGmSNVDqByG0X65CYg==',380981029665,NULL,1160270249,'1',NULL,0,'','0'),
(2250,NULL,'Коваль Наталя',NULL,NULL,NULL,380685960086,NULL,2139299452,'1',NULL,0,'','0'),
(2251,NULL,'Вархол Вероніка',NULL,'2018-05-08',NULL,380672911069,NULL,2012331355,'1',NULL,0,'','0'),
(2252,NULL,'Чорненька Іванка',NULL,'2018-05-08',NULL,380988663891,NULL,2038636820,'1',NULL,0,'','0'),
(2253,NULL,'Воробей Ганна',NULL,'2018-05-08',NULL,380672911337,NULL,1959315365,'1',NULL,0,'','0'),
(2254,NULL,'Драпак Світлана',NULL,'2018-05-09',NULL,380976100382,NULL,2059942972,'1',NULL,0,'','0'),
(2255,NULL,'Фесюк Іра',NULL,'2018-05-09',NULL,380974144021,NULL,1501319707,'1',NULL,0,'','0'),
(2256,NULL,'МАйданик Аня',NULL,'2018-05-09',NULL,380986625975,NULL,1484853230,'1',NULL,0,'','0'),
(2257,0913,'Рудик Уляна',NULL,NULL,NULL,380679052982,NULL,1511020565,'1',NULL,0,'','0'),
(2258,NULL,'Спасюк Діана',NULL,'2018-05-09',NULL,380972613779,NULL,1553495561,'1',NULL,0,'','0'),
(2259,NULL,'Смеречинський Володя',NULL,'2018-05-09',NULL,380981011632,NULL,1512635549,'1',NULL,0,'','0'),
(2260,NULL,'Білінська Оксана',NULL,NULL,NULL,380661050362,NULL,1814611080,'1',NULL,0,'','0'),
(2261,NULL,'Вислоцька Іра ',NULL,NULL,'hIGANFM6W5DQ43cbzSBJ5Q==',380968531054,NULL,1126261245,'1',NULL,2,'','0'),
(2262,NULL,'Волощук Настя',NULL,'2018-05-11',NULL,380975954552,NULL,1818394423,'1',NULL,0,'','0'),
(2263,0557,'Предко Марія',NULL,NULL,NULL,380681776386,NULL,1322068456,'1',NULL,0,'','0'),
(2264,NULL,'Жукова Анна',NULL,'2018-05-11',NULL,380976435944,NULL,1293584755,'1',61228,0,'','0'),
(2265,NULL,'Бобик Надія',NULL,'2018-05-11',NULL,380686244693,NULL,1448572834,'1',NULL,0,'','0'),
(2266,NULL,'Мацків Марія',NULL,'2018-05-11',NULL,380984090598,NULL,1226622441,'1',NULL,0,'','0'),
(2267,NULL,'Барилюк Оля',NULL,'2018-05-11',NULL,380966636158,NULL,1311251004,'1',NULL,1,'','0'),
(2268,NULL,'Качановський Віталік ',NULL,'2018-05-11',NULL,380961877881,NULL,1394064234,'1',NULL,1,'','0'),
(2269,NULL,'Присяжнюк Оксана',NULL,'2018-05-11',NULL,380974089460,NULL,1278289835,'1',NULL,0,'','0'),
(2270,NULL,'лучків світлана',NULL,'2018-05-12',NULL,380972885282,NULL,1342356973,'1',NULL,0,'','0'),
(2271,NULL,'Гаркач Міша',NULL,'2018-05-12',NULL,380966822696,NULL,2114126426,'1',NULL,0,'','0'),
(2272,NULL,'Маркіна Таня',NULL,'2018-05-12',NULL,380991128295,NULL,1162200469,'1',NULL,0,'','0'),
(2273,NULL,'Карамишева Оля',NULL,NULL,NULL,380971319372,NULL,1203296235,'1',NULL,0,'','0'),
(2274,NULL,'Українець Леся',NULL,'2018-05-12',NULL,380979993058,NULL,1174305928,'1',NULL,0,'','0'),
(2275,NULL,'Гапійчук Оксана',NULL,NULL,NULL,380971438220,NULL,1495069958,'1',NULL,0,'','0'),
(2276,NULL,'Штангрет Люда',NULL,'2018-05-14',NULL,380673484906,NULL,1520211733,'1',NULL,0,'','0'),
(2277,NULL,'Кушнір Діана',NULL,'2018-05-14',NULL,380983175830,NULL,2018000840,'1',NULL,0,'','0'),
(2278,NULL,'Мацишин Христина',NULL,'2018-05-14',NULL,380984755261,NULL,2112291762,'1',NULL,0,'','0'),
(2279,0533,'Мірус Юля',NULL,NULL,NULL,380668066292,NULL,1817595124,'1',NULL,0,'','0'),
(2280,NULL,'Кобалька Юля',NULL,'2018-05-14',NULL,380631599273,NULL,1454785012,'1',NULL,0,'','0'),
(2281,NULL,'Маркитан Віка',NULL,'2018-05-14',NULL,380682717052,NULL,1970471814,'1',NULL,0,'','0'),
(2282,NULL,'мар яна наша',NULL,'2018-05-14',NULL,7,NULL,1271085431,'1',NULL,1,'','0'),
(2283,NULL,'Стахів Ірина',NULL,'2018-05-15',NULL,380672663501,NULL,1156709854,'1',NULL,0,'','0'),
(2284,NULL,'погосян христина',NULL,'2018-05-15',NULL,380982396690,NULL,2119675624,'1',31388,0,'','0'),
(2285,NULL,'Війтишин Зоряна',NULL,'2018-05-15',NULL,380979275116,NULL,2040472212,'1',NULL,0,'','0'),
(2286,NULL,'Біла Уляна',NULL,'2018-05-15',NULL,380675970523,NULL,1780069620,'1',NULL,0,'','0'),
(2287,NULL,'Іздебська Васелина',NULL,'2018-05-15',NULL,380960042981,NULL,1477027683,'1',NULL,0,'','0'),
(2288,NULL,'Полева Люда',NULL,'2018-05-15',NULL,380961370242,NULL,1668956724,'1',NULL,0,'','0'),
(2289,NULL,'Амборська Іванка',NULL,'2018-05-15',NULL,380984729566,NULL,1835152664,'1',NULL,0,'','0'),
(2290,NULL,'Мельниченко Віта',NULL,'2018-05-15',NULL,380960064684,NULL,1502555803,'1',NULL,0,'','0'),
(2291,NULL,'коробій марія',NULL,'2018-05-16',NULL,380988961086,NULL,2070427925,'1',NULL,0,'','0'),
(2292,NULL,'Боднар Надія',NULL,'2018-05-16',NULL,380999538025,NULL,1484387913,'1',NULL,0,'','0'),
(2293,NULL,'Мостович Іванна',NULL,NULL,NULL,380681774886,NULL,1987605085,'1',37012,2,'','0'),
(2294,NULL,'Процьків Руслан',NULL,NULL,NULL,380673252819,NULL,1890437442,'1',NULL,0,'','0'),
(2295,NULL,'Кобзар Ання',NULL,'2018-05-17',NULL,380972427428,NULL,1939720708,'1',NULL,0,'','0'),
(2296,NULL,'Кульба Оксана',NULL,'2018-05-17',NULL,380964903585,NULL,1245197961,'1',NULL,0,'','0'),
(2297,NULL,'Пирик Таня',NULL,'2018-05-17',NULL,380678672515,NULL,1418884937,'1',NULL,0,'','0'),
(2298,NULL,'Фаїзова Ірина ',NULL,'2018-05-17',NULL,380669185420,NULL,1134895309,'1',NULL,0,'','0'),
(2299,NULL,'Семенів Анна',NULL,'2018-05-18',NULL,380971759877,NULL,1490501658,'1',NULL,0,'','0'),
(2300,NULL,'Храпко Люба',NULL,'2018-05-18',NULL,380961349553,NULL,1914557007,'1',NULL,0,'','0'),
(2301,NULL,'Храпко Віка',NULL,'2018-05-18',NULL,380965270592,NULL,1249401972,'1',NULL,0,'','0'),
(2302,NULL,'Мерлавська таня',NULL,'2018-05-18',NULL,380961635984,NULL,2002990485,'1',NULL,0,'','0'),
(2303,NULL,'Кушнір Юля',NULL,'2018-05-18',NULL,380979095558,NULL,1282671925,'1',NULL,0,'','0'),
(2304,NULL,'Штуник Оксана',NULL,'2018-05-18',NULL,380681636169,NULL,1879341469,'1',NULL,0,'','0'),
(2305,NULL,'Корбак Юля',NULL,'2018-05-18',NULL,380977389720,NULL,1476791264,'1',NULL,0,'','0'),
(2306,NULL,'Дідюк Оксана',NULL,'2018-05-18',NULL,380964812848,NULL,1705040959,'1',NULL,0,'','0'),
(2307,NULL,'Шершун Уляна',NULL,'2018-05-19',NULL,380971281985,NULL,1559589044,'1',NULL,0,'','0'),
(2308,NULL,'Беднарська Оля',NULL,'2018-05-19',NULL,380968752396,NULL,1905415125,'1',NULL,0,'','0'),
(2309,NULL,'Павліка Ганна',NULL,'2018-05-19',NULL,380976780374,NULL,1806650457,'1',NULL,0,'','0'),
(2310,NULL,'Скрипникова каріна',NULL,'2018-05-19',NULL,380988323403,NULL,1555592721,'1',NULL,0,'','0'),
(2311,NULL,'Басараба Галя',NULL,'2018-05-19',NULL,380977760310,NULL,1800600485,'1',NULL,0,'','0'),
(2312,NULL,'ковалик оксана',NULL,'2018-05-19',NULL,380986472389,NULL,1351867413,'1',NULL,0,'','0'),
(2313,NULL,'кунець христина',NULL,'2018-05-19',NULL,380961788406,NULL,1461149101,'1',NULL,0,'','0'),
(2314,NULL,'Нагаєвська Світлана',NULL,'2018-05-21',NULL,380665124367,NULL,1967206485,'1',NULL,0,'','0'),
(2315,NULL,'Герасимик Наталя',NULL,'2018-05-21',NULL,380688180778,NULL,1272985013,'1',NULL,0,'','0'),
(2316,NULL,'Ільків Олена',NULL,'2018-05-21',NULL,380977203151,NULL,1296283485,'1',NULL,0,'','0'),
(2317,NULL,'Недільська Ірина',NULL,'2018-05-21',NULL,380968520735,NULL,1834153081,'1',NULL,0,'','0'),
(2318,NULL,'Бабин іван',NULL,'2018-05-21',NULL,380976648268,NULL,1983690281,'1',NULL,0,'','0'),
(2319,NULL,'Карабан ольга',NULL,'2018-05-21',NULL,380680575269,NULL,1256963131,'1',NULL,0,'','0'),
(2320,NULL,'Гургач ірина',NULL,'2018-05-21',NULL,380974117423,NULL,1131480006,'1',NULL,0,'','0'),
(2321,NULL,'Савіцька Таня',NULL,'2018-05-21',NULL,380685189969,NULL,1275059733,'1',NULL,0,'','0'),
(2322,NULL,'Павлик Галина',NULL,'2018-05-21',NULL,380685448489,NULL,1505956429,'1',NULL,0,'','0'),
(2323,NULL,'Павлик Галина',NULL,'2018-05-21',NULL,380680548489,NULL,1963342697,'1',30177,0,'','0'),
(2324,NULL,'Худа уляна',NULL,'2018-05-21',NULL,380937971235,NULL,1938477576,'1',NULL,0,'','0'),
(2325,NULL,'Грицик тетяна',NULL,'2018-05-21',NULL,380987802305,NULL,1289117304,'1',NULL,0,'','0'),
(2326,NULL,'Кубішин Оля',NULL,'2018-05-22',NULL,380978463242,NULL,1579718807,'1',NULL,0,'','0'),
(2327,0563,'Думак Таня',NULL,NULL,NULL,380995631654,NULL,1135008472,'1',NULL,0,'','0'),
(2328,NULL,'Баріда Ліліана',NULL,'2018-05-22',NULL,380976347984,NULL,1177167065,'1',NULL,0,'','0'),
(2329,NULL,'Задорожна Уляна',NULL,'2018-05-22',NULL,380983046465,NULL,1873983086,'1',NULL,0,'','0'),
(2330,NULL,'Данилевич Маша',NULL,'2018-05-22',NULL,380970860789,NULL,1192381919,'1',NULL,0,'','0'),
(2331,NULL,'Батицька Олександра',NULL,'2018-05-22',NULL,380682464625,NULL,1288140788,'1',NULL,0,'','0'),
(2332,NULL,'Король Іра',NULL,'2018-05-22',NULL,380682047425,NULL,1355000223,'1',NULL,0,'','0'),
(2333,NULL,'Ляхович Світлана',NULL,'2018-05-22',NULL,380971196482,NULL,1510093170,'1',NULL,0,'','0'),
(2334,NULL,'Турчиняк Юля',NULL,'2018-05-22',NULL,380971528551,NULL,2027854742,'1',30710,0,'','0'),
(2335,NULL,'Іванченко Діана',NULL,'2018-05-22',NULL,380968314448,NULL,1390421346,'1',NULL,0,'','0'),
(2336,NULL,'Галак Галя',NULL,'2018-05-22',NULL,380966929989,NULL,1759471158,'1',NULL,0,'','0'),
(2337,NULL,'Войтко Оксана',NULL,'2018-05-22',NULL,380971863893,NULL,1291554874,'1',NULL,0,'','0'),
(2338,NULL,'Кащинець Оля',NULL,'2018-05-22',NULL,380989829398,NULL,1730627114,'1',NULL,0,'','0'),
(2339,NULL,'Басюк Марія',NULL,'2018-05-22',NULL,380985439505,NULL,1299475228,'1',NULL,0,'','0'),
(2340,NULL,'Скотніцька Марія',NULL,'2018-05-22',NULL,380961656533,NULL,1484151532,'1',NULL,0,'','0'),
(2341,NULL,'Ковалів Юля',NULL,'2018-05-22',NULL,380966664881,NULL,1277764009,'1',NULL,0,'','0'),
(2342,NULL,'Іляшенко Оля',NULL,'2018-05-23',NULL,380972384838,NULL,1941631220,'1',NULL,0,'','0'),
(2343,NULL,'Костишак  Настя',NULL,NULL,NULL,380680548125,NULL,1785571647,'1',NULL,0,'','0'),
(2344,NULL,'Ревега Наталя',NULL,'2018-05-23','Z+J/qXp1VsobuZQKq2BCKg==',380977098326,NULL,1855006517,'1',34203,0,'','0'),
(2345,NULL,'Погосян Надя',NULL,'2018-05-23',NULL,380989291492,NULL,1352715735,'1',NULL,0,'','0'),
(2346,NULL,'Гойда Таня',NULL,NULL,NULL,380961864425,NULL,1925951522,'1',NULL,0,'','0'),
(2347,NULL,'Денчук Зоряна',NULL,'2018-05-23',NULL,380666117820,NULL,1842606804,'1',NULL,0,'','0'),
(2348,NULL,'Вівчарик Таня',NULL,'2018-05-23',NULL,380686254927,NULL,1951874562,'1',NULL,0,'','0'),
(2349,NULL,'Глова Любов',NULL,'2018-05-23',NULL,380505749642,NULL,1444401039,'1',NULL,0,'','0'),
(2350,NULL,'Лаптош Ніна',NULL,'2018-05-23',NULL,380680077689,NULL,1857705113,'1',NULL,0,'','0'),
(2351,NULL,'Москалик Оля',NULL,NULL,NULL,380976915956,NULL,2006552123,'1',NULL,0,'','0'),
(2352,NULL,'Дашкевич Віка',NULL,'2018-05-24','rMEjijOZln5hZzgWNBYM5w==',380960752904,NULL,2034432258,'1',12491,0,'','0'),
(2353,NULL,'Бойчук Іванна',NULL,NULL,NULL,380681519377,NULL,1725987146,'1',28870,0,'','0'),
(2354,NULL,'Стеліга Іванна',NULL,'2018-05-24',NULL,380975986220,NULL,1627076098,'1',NULL,0,'','0'),
(2355,NULL,'Хорощак Софія',NULL,'2018-05-24',NULL,380668173840,NULL,1276788855,'1',NULL,0,'','0'),
(2356,NULL,'Тимчаль інна',NULL,'2018-05-24',NULL,380972779429,NULL,1394212991,'1',11111,0,'','0'),
(2357,NULL,'Шульга аліна',NULL,'2018-05-24',NULL,380960269510,NULL,1282417311,'1',NULL,0,'','0'),
(2358,0925,'Глова Оля',NULL,NULL,NULL,380974344983,NULL,1245594150,'1',NULL,0,'','0'),
(2359,NULL,'Панькевич Юля',NULL,'2018-05-24',NULL,380687263526,NULL,1892299441,'1',NULL,0,'','0'),
(2360,NULL,'Дорожик Руслана',NULL,'2018-05-24',NULL,380974248580,NULL,1407558253,'1',NULL,0,'','0'),
(2361,NULL,'Беренда Олександра',NULL,'2018-05-24',NULL,380969605935,NULL,1126631621,'1',NULL,0,'','0'),
(2362,NULL,'Казюк Маряна',NULL,NULL,NULL,380965626936,NULL,2038005565,'1',NULL,0,'','0'),
(2363,NULL,'Наконечна Оксана',NULL,'2018-05-25',NULL,380680313934,NULL,1621068728,'1',NULL,0,'','0'),
(2364,NULL,'Крупка Аліна',NULL,'2018-05-25',NULL,380963801032,NULL,1433872943,'1',NULL,0,'','0'),
(2365,NULL,'Старовойт Інна',NULL,NULL,NULL,380978600057,NULL,2060603876,'1',NULL,0,'','0'),
(2366,NULL,'Григорків Анна',NULL,'2018-05-25',NULL,380974130732,NULL,1852153299,'1',NULL,0,'','0'),
(2367,NULL,'Білінська Оксана',NULL,'2018-05-25',NULL,380979182881,NULL,1180697274,'1',NULL,0,'','0'),
(2368,NULL,'Стеценко Луана',NULL,'2018-05-25',NULL,380684689520,NULL,1704731569,'1',NULL,0,'','0'),
(2369,NULL,'Мацієвська Віра',NULL,'2018-05-25',NULL,380679795670,NULL,1669679293,'1',21967,0,'','0'),
(2370,NULL,'крупа наталія',NULL,'2018-05-26',NULL,380976205403,380976205403,1573325753,'1',NULL,0,'','0'),
(2371,NULL,'Силець Іра',NULL,'2018-05-26',NULL,380987270925,NULL,1670666858,'1',NULL,0,'','0'),
(2372,NULL,'Русин Софія',NULL,'2018-05-26',NULL,380660377618,NULL,1752706877,'1',NULL,0,'','0'),
(2373,NULL,'Демкович Аліна',NULL,'2018-05-26',NULL,380506493404,NULL,1593489977,'1',NULL,0,'','0'),
(2374,NULL,'Вігрос Роксолана',NULL,'2018-05-26',NULL,380974527266,NULL,1207809006,'1',NULL,0,'','0'),
(2375,NULL,'Цепенда Христина',NULL,NULL,NULL,380975825086,NULL,1626934050,'1',NULL,0,'','0'),
(2376,NULL,'Дерманська Таня',NULL,'2018-05-28',NULL,380973541643,NULL,1595716873,'1',NULL,0,'','0'),
(2377,NULL,'Король Аня',NULL,'2018-05-29',NULL,380988123584,NULL,1702548907,'1',NULL,0,'','0'),
(2378,NULL,'Пепчук Галина',NULL,'2018-05-29',NULL,380986480868,NULL,1329854712,'1',NULL,0,'','0'),
(2379,NULL,'Чорній Іра',NULL,'2018-05-29',NULL,380971579359,NULL,1789813373,'1',NULL,0,'','0'),
(2380,NULL,'Гаврелишин оля ',NULL,'2018-05-29',NULL,380989209263,NULL,1909576154,'1',NULL,0,'','0'),
(2381,NULL,'Стельмащук Олександра',NULL,'2018-05-29',NULL,380664498921,NULL,1112240548,'1',NULL,0,'','0'),
(2382,NULL,'Томчишин Оксана',NULL,'2018-05-29',NULL,380938638970,NULL,1840785125,'1',NULL,0,'','0'),
(2383,NULL,'Поплавська Надія',NULL,'2018-05-29',NULL,380960058181,NULL,1505176615,'1',NULL,0,'','0'),
(2384,NULL,'Давибіда Іра',NULL,NULL,NULL,380680304227,NULL,1254872042,'1',NULL,0,'','0'),
(2385,NULL,'Драганчук Таісія',NULL,'2018-05-29',NULL,380979924564,NULL,1953516318,'1',NULL,0,'','0'),
(2386,NULL,'Ізлікова Оксана',NULL,'2018-05-30',NULL,380970133577,NULL,1362265503,'1',NULL,0,'','0'),
(2387,NULL,'Давибіда Таня',NULL,NULL,NULL,380969311172,NULL,1523605417,'1',38969,0,'','0'),
(2388,NULL,'семенюк ліда',NULL,'2018-05-30',NULL,380674959578,NULL,2099357944,'1',NULL,0,'','0'),
(2389,NULL,'Левицька Марія',NULL,'2018-05-30',NULL,380983055626,NULL,1704520274,'1',NULL,0,'','0'),
(2390,NULL,'Дембіцька Наталя',NULL,'2018-05-30',NULL,380961432846,NULL,1811524919,'1',NULL,0,'','0'),
(2391,NULL,'КУцик Марія',NULL,'2018-05-30',NULL,380970534728,NULL,1342739941,'1',NULL,0,'','0'),
(2392,NULL,'Ричко Олена',NULL,NULL,NULL,380938203564,NULL,1192634294,'1',NULL,0,'','0'),
(2393,NULL,'Дядик Люся',NULL,'2018-05-31',NULL,380988666055,NULL,1381626064,'1',NULL,0,'','0'),
(2394,NULL,'Слободян Діана',NULL,NULL,NULL,380688460601,NULL,2081938832,'1',63050,0,'','0'),
(2395,NULL,'Кізекова Ліля',NULL,'2018-05-31',NULL,380678768136,NULL,1826414341,'1',NULL,0,'','0'),
(2396,NULL,'гринчук сергій',NULL,'2018-05-31',NULL,380963479144,NULL,2073814274,'1',NULL,0,'','0'),
(2397,NULL,'Тосмакова Оксана',NULL,'2018-05-31',NULL,380960613769,NULL,2141147995,'1',NULL,0,'','0'),
(2398,NULL,'Лучка Діана',NULL,'2018-05-31',NULL,380971864415,NULL,1848988564,'1',NULL,0,'','0'),
(2399,NULL,'Нісевич Олеся',NULL,'2018-05-31',NULL,380959479917,NULL,1622077537,'1',NULL,1,'','0'),
(2400,0891,'Пелікан Галина',NULL,NULL,NULL,380983117605,NULL,1689003586,'1',NULL,0,'','0'),
(2401,NULL,'Клебан Христина',NULL,'2018-05-31',NULL,380995593340,NULL,2048695018,'1',NULL,0,'','0'),
(2402,NULL,'Неля наша',NULL,NULL,NULL,380971107909,NULL,1214828778,'1',48220,0,'','0'),
(2403,NULL,'Мацишин Оксана',NULL,'2018-05-31','wMJv5fL7Y6SNUsoGnRE8gw==',380684166398,NULL,1154959302,'1',29342,0,'','0'),
(2404,NULL,'самолюк маряна',NULL,'2018-06-01',NULL,380961917185,NULL,1678415666,'1',NULL,0,'','0'),
(2405,NULL,'Козарій Таня',NULL,'2018-06-01',NULL,380983556612,NULL,1989480294,'1',NULL,0,'','0'),
(2406,NULL,'Боросюк Христина',NULL,'2018-06-01',NULL,380683365005,NULL,2117636938,'1',NULL,0,'','0'),
(2407,NULL,'Бандера Іра',NULL,NULL,NULL,380680962735,NULL,1361805816,'1',NULL,0,'','0'),
(2408,NULL,'Войцишин Роксолана',NULL,'2018-06-01',NULL,380678485641,NULL,1901021554,'1',NULL,1,'','0'),
(2409,NULL,'Антків Наталя',NULL,'2018-06-01','h2lXh/gTXbXMXOzBr8fJlw==',380966549228,NULL,1349937027,'1',NULL,0,'','0'),
(2410,NULL,'Рогатинська Іра',NULL,'2018-06-01',NULL,380969570884,NULL,1913966728,'1',NULL,0,'','0'),
(2411,NULL,'Гуцал Наталя',NULL,'2018-06-01','HQwcLLWuvhMkh7QtFK+QpA==',380971594796,NULL,1717034108,'1',41812,0,'','0'),
(2412,NULL,'Мовчан анна',NULL,'2018-06-01',NULL,380687624148,NULL,1656318005,'1',NULL,0,'','0'),
(2413,NULL,'Фалічина Надя',NULL,'2018-06-02',NULL,380993315222,NULL,1696847865,'1',NULL,0,'','0'),
(2414,NULL,'оріх марія',NULL,NULL,NULL,380668051690,NULL,1730458975,'1',NULL,0,'','0'),
(2415,NULL,'Басівська Наталія',NULL,'2018-06-04',NULL,380931506964,NULL,1406651772,'1',NULL,0,'','0'),
(2416,NULL,'Чайка Христина',NULL,'2018-06-04',NULL,380635751747,NULL,2033765082,'1',NULL,0,'','0'),
(2417,NULL,'Ковальчук Ірина',NULL,'2018-06-04',NULL,380981756973,NULL,2071839482,'1',NULL,0,'','0'),
(2418,NULL,'Ревуцька Таня',NULL,NULL,NULL,380684292021,NULL,1284709388,'1',NULL,0,'','0'),
(2419,NULL,'Канон Світлана',NULL,'2018-06-04',NULL,380969846763,NULL,1855019779,'1',NULL,0,'','0'),
(2420,NULL,'Кулій Іра',NULL,NULL,NULL,NULL,NULL,1800567850,'1',NULL,0,'','1'),
(2421,NULL,'Івасенко настя',NULL,'2018-06-04',NULL,380997116546,NULL,1576896040,'1',25467,1,'','0'),
(2422,NULL,'Бучак наталя',NULL,'2018-06-04',NULL,380684808606,NULL,1625365775,'1',NULL,0,'','0'),
(2423,NULL,'Зелінська Марія',NULL,'2018-06-04',NULL,380970885265,NULL,1340926840,'1',NULL,1,'','0'),
(2424,NULL,'Семчишин Галина',NULL,'2018-06-04',NULL,380975472584,NULL,1307800434,'1',NULL,0,'','0'),
(2425,NULL,'Звараш Оксана',NULL,'2018-06-05',NULL,380687031611,NULL,1658847871,'1',NULL,0,'','0'),
(2426,NULL,'Буренюк Марія',NULL,NULL,NULL,380970567908,NULL,2014372929,'1',NULL,0,'','0'),
(2427,NULL,'Голодрига Ліля',NULL,'2018-06-05',NULL,380969366725,NULL,1756597320,'1',NULL,0,'','0'),
(2428,NULL,'Доскочинська Олесандра',NULL,'2018-06-05',NULL,380683257557,NULL,1244315146,'1',NULL,0,'','0'),
(2429,NULL,'Маліцька Христина',NULL,'2018-06-05',NULL,380989883512,NULL,1871420136,'1',NULL,0,'','0'),
(2430,NULL,'Худик Маряна',NULL,'2018-06-05',NULL,380971290972,NULL,1451229306,'1',NULL,0,'','0'),
(2431,NULL,'Остапенко Яна',NULL,'2018-06-05',NULL,380963790710,NULL,1278696621,'1',NULL,0,'','0'),
(2432,NULL,'Шепета Наталя',NULL,'2018-06-06',NULL,380982521585,NULL,1367393765,'1',NULL,0,'','0'),
(2433,NULL,'Мищирякова Оксана',NULL,'2018-06-06',NULL,380985318681,NULL,1336575193,'1',NULL,0,'','0'),
(2434,NULL,'Магдяк Юля',NULL,'2018-06-06',NULL,380964408739,NULL,1583324510,'1',NULL,0,'','0'),
(2435,NULL,'Скучипець Віка',NULL,'2018-06-06',NULL,380966799043,NULL,1269675246,'1',NULL,0,'','0'),
(2436,NULL,'Швак Оксана',NULL,'2018-06-06',NULL,380983523398,NULL,1288534012,'1',NULL,0,'','0'),
(2437,NULL,'Прокопюк Віка',NULL,'2018-06-06',NULL,380961159823,NULL,1347369516,'1',NULL,0,'','0'),
(2438,NULL,'Микита маряна',NULL,'2018-06-06',NULL,380689585806,NULL,1425951481,'1',NULL,0,'','0'),
(2439,NULL,'Баран Аліна',NULL,'2018-06-06',NULL,380686764599,NULL,1657377967,'1',NULL,0,'','0'),
(2440,NULL,'Спренткович Юля',NULL,'2018-06-06',NULL,380978949358,NULL,1861835698,'1',NULL,0,'','0'),
(2441,NULL,'Кай катя',NULL,'2018-06-06',NULL,380507257741,NULL,1636406757,'1',NULL,0,'','0'),
(2442,NULL,'Тесля Галя',NULL,NULL,NULL,NULL,NULL,1818391996,'1',NULL,0,'','1'),
(2443,NULL,'Сухацька Таня',NULL,NULL,NULL,380991648397,NULL,1443289541,'1',NULL,0,'','0'),
(2444,NULL,'Согацька Таня',NULL,NULL,NULL,380952287721,NULL,2117577677,'1',NULL,0,'','0'),
(2445,NULL,'Чепига Христина',NULL,'2018-06-06',NULL,380685145363,NULL,1288171092,'1',NULL,0,'','0'),
(2446,NULL,'Побуринна Тетяна',NULL,'2018-06-06','WHT8r9LkkvpcKREgSdgqMA==',380977664527,NULL,2133499985,'1',NULL,0,'','0'),
(2447,NULL,'Іконяк Вікторія',NULL,'2018-06-07',NULL,380975985964,NULL,1133794144,'1',NULL,0,'','0'),
(2448,NULL,'Сампара Ніна',NULL,NULL,NULL,380972727298,NULL,1888447519,'1',NULL,0,'','1'),
(2449,NULL,'Ковальчук Іванна',NULL,'2018-06-07',NULL,380685122766,NULL,1359504350,'1',NULL,0,'','0'),
(2450,NULL,'Гуменюк Христина',NULL,'2018-06-07',NULL,380685121001,NULL,1152543238,'1',NULL,0,'','0'),
(2451,NULL,'Бронь',NULL,NULL,NULL,NULL,NULL,1517925939,'1',NULL,0,'','0'),
(2452,NULL,'маряна наша',NULL,'2018-06-08',NULL,NULL,NULL,1484780497,'1',NULL,0,'','0'),
(2453,NULL,'маряна наша',NULL,'2018-06-08',NULL,NULL,NULL,1883078114,'1',NULL,0,'','0'),
(2454,NULL,'Непотас Альона',NULL,NULL,NULL,380677974851,NULL,1662672494,'1',NULL,0,'','0'),
(2455,NULL,'Ванджура Ліля',NULL,'2018-06-08',NULL,380688179667,NULL,2041522698,'1',NULL,0,'','0'),
(2456,NULL,'Горба Наталя',NULL,'2018-06-08',NULL,380683626822,NULL,1736271376,'1',NULL,0,'','0'),
(2457,NULL,'Павліка Оксана',NULL,'2018-06-08',NULL,380970162650,NULL,1586015309,'1',NULL,0,'','0'),
(2458,NULL,'Соботяк Настя',NULL,'2018-06-08',NULL,380990548630,NULL,1693988044,'1',NULL,0,'','0'),
(2459,NULL,'Кулій Катя',NULL,NULL,NULL,380971489902,NULL,1912356316,'1',NULL,0,'','0'),
(2460,NULL,'Вавілова Оля',NULL,NULL,NULL,380978167553,NULL,1222206678,'1',NULL,0,'','0'),
(2461,NULL,'Стефанюк Віка',NULL,'2018-06-08',NULL,380964369075,NULL,2120943230,'1',NULL,0,'','0'),
(2462,NULL,'Курило Таня',NULL,'2018-06-09',NULL,380968410416,NULL,1127287637,'1',NULL,0,'','0'),
(2463,NULL,'лотоцька аделя',NULL,NULL,NULL,380967174914,NULL,1938721146,'1',NULL,0,'','0'),
(2464,NULL,'польник іванна',NULL,'2018-06-09',NULL,380965612637,NULL,1486403465,'1',NULL,0,'','0'),
(2465,NULL,'Рибак Іра',NULL,'2018-06-09',NULL,380967661934,NULL,1432894466,'1',NULL,0,'','0'),
(2466,NULL,'Дзіковська Світлана',NULL,NULL,NULL,380961103225,NULL,1195845434,'1',50411,0,'','0'),
(2467,NULL,'Федор',NULL,'2018-06-11',NULL,NULL,NULL,1449694852,'1',NULL,0,'','0'),
(2468,NULL,'Василів Оля',NULL,'2018-06-11',NULL,380507255345,NULL,2077704618,'1',NULL,0,'','0'),
(2469,NULL,'Дудар Маряна',NULL,'2018-06-11',NULL,380960751322,NULL,1196438284,'1',NULL,0,'','0'),
(2470,NULL,'Ратушняк Марина',NULL,'2018-06-11',NULL,380973085946,NULL,1703217739,'1',NULL,0,'','0'),
(2471,NULL,'Когут Юля',NULL,'2018-06-11',NULL,380985924996,NULL,1581149893,'1',NULL,0,'','0'),
(2472,NULL,'Зеленська Віка',NULL,NULL,NULL,380973773412,NULL,1537533512,'1',NULL,0,'','0'),
(2473,NULL,'Плішка Марія',NULL,'2018-06-11',NULL,380971354310,NULL,1916375224,'1',NULL,0,'','0'),
(2474,NULL,'Стадник Олена',NULL,'2018-06-11',NULL,380986004700,NULL,1930789896,'1',NULL,0,'','0'),
(2475,NULL,'Цилінська Ліля',NULL,'2018-06-11',NULL,380937290380,NULL,2006691808,'1',NULL,0,'','0'),
(2476,NULL,'Яровець Марія',NULL,'2018-06-11',NULL,380967385195,NULL,1900930559,'1',NULL,0,'','0'),
(2477,NULL,'Прохорова оксана',NULL,'2018-06-11',NULL,380673660754,NULL,2053607338,'1',NULL,0,'','0'),
(2478,NULL,'Шарун Юля',NULL,'2018-06-11',NULL,380982688665,NULL,2133487098,'1',NULL,0,'','0'),
(2479,NULL,'Мардаль Оля',NULL,'2018-06-11',NULL,380683283743,NULL,1524288690,'1',NULL,0,'','0'),
(2480,NULL,'Вислоцька Галина',NULL,'2018-06-11',NULL,380679259594,NULL,2082648743,'1',NULL,1,'','0'),
(2481,NULL,'Клим Софія',NULL,NULL,NULL,380956847293,NULL,2122174851,'1',56318,0,'','0'),
(2482,NULL,'Процанін Наталя',NULL,'2018-06-11',NULL,380680570600,NULL,1652155028,'1',NULL,0,'','0'),
(2483,NULL,'Золотоцька Ангеліна',NULL,'2018-06-12',NULL,380688483053,NULL,1208049567,'1',NULL,0,'','0'),
(2484,NULL,'Ониськів Маряна',NULL,'2018-06-12',NULL,380971363397,NULL,1237671755,'1',NULL,1,'','0'),
(2485,NULL,'Безпалко Іра',NULL,'2018-06-12',NULL,380966765666,NULL,1228797704,'1',NULL,0,'','0'),
(2486,NULL,'Мельник Марія',NULL,'2018-06-12',NULL,380688598513,NULL,1342159470,'1',NULL,0,'','0'),
(2487,NULL,'Шишкина Віка',NULL,'2018-06-12',NULL,380506117130,NULL,1748067107,'1',NULL,0,'','0'),
(2488,NULL,'Сорочук Наталя',NULL,'2018-06-12',NULL,380680549240,NULL,1533911616,'1',NULL,0,'','0'),
(2489,NULL,'Цекарняк Алла',NULL,'2018-06-12',NULL,380669835847,NULL,1416322418,'1',NULL,0,'','0'),
(2490,NULL,'Гурбач таня',NULL,'2018-06-12',NULL,380636304500,NULL,1179143492,'1',NULL,0,'','0'),
(2491,NULL,'Мостович Віталіна',NULL,'2018-06-12',NULL,380989429742,NULL,1964254100,'1',NULL,0,'','0'),
(2492,NULL,'Федорович Наталя',NULL,'2018-06-13',NULL,380965165810,NULL,1120330435,'1',NULL,0,'','0'),
(2493,NULL,'Кай Зоряна',NULL,'2018-06-13',NULL,380965638455,NULL,1674838954,'1',NULL,0,'','0'),
(2494,NULL,'Герчак Люда',NULL,'2018-06-13',NULL,380688248002,NULL,1844978441,'1',NULL,0,'','0'),
(2495,NULL,'ялинчук юля',NULL,'2018-06-13',NULL,380970553892,NULL,2067763224,'1',NULL,0,'','0'),
(2496,NULL,'Клим інна',NULL,NULL,NULL,380680171914,NULL,1785898159,'1',NULL,0,'','0'),
(2497,NULL,'Івановчик Ліда',NULL,'2018-06-13',NULL,380968379051,NULL,1980242457,'1',NULL,0,'','0'),
(2498,NULL,'Федорів Наталя',NULL,'2018-06-13',NULL,380684744542,NULL,1914480544,'1',NULL,0,'','0'),
(2499,NULL,'Мушій Оля',NULL,'2018-06-13','znuNRJM7wwvWMo1CdfjEyg==',380683365386,NULL,1544612047,'1',56584,0,'','0'),
(2539,NULL,'Маліновська Оксана',NULL,'2018-06-20',NULL,380967494822,NULL,1686040544,'1',NULL,0,'','0');

INSERT INTO `kontragentu` VALUES 
(2500,NULL,'Швець Таня',NULL,'2018-06-13',NULL,380680409666,NULL,1463541548,'1',NULL,0,'','0'),
(2501,NULL,'гейна софія',NULL,'2018-06-13',NULL,380983285302,NULL,2044615448,'1',NULL,0,'','0'),
(2502,NULL,'парнега зоряна',NULL,'2018-06-13',NULL,380983989391,NULL,1661230767,'1',NULL,0,'','0'),
(2503,NULL,'осиф наталя',NULL,'2018-06-13','dyJlN4jdzw/3xkxKHV/5Rw==',380957741979,NULL,1615941395,'1',NULL,0,'','0'),
(2504,NULL,'Стецько Віра',NULL,'2018-06-13',NULL,380686254955,NULL,1578245185,'1',NULL,0,'','0'),
(2505,0613,'гринів оля',NULL,NULL,NULL,380989053408,NULL,1276269817,'1',NULL,0,'','0'),
(2506,NULL,'Бартишко Таня',NULL,'2018-06-14',NULL,380978329366,NULL,1966444914,'1',NULL,0,'','0'),
(2507,NULL,'Вівсяник Люба',NULL,'2018-06-14',NULL,380661489426,NULL,1993492537,'1',NULL,0,'','0'),
(2508,NULL,'Попик віталій',NULL,'2018-06-14',NULL,380972570190,NULL,1847124780,'1',NULL,0,'','0'),
(2509,NULL,'Ільків Іванна',NULL,'2018-06-14',NULL,380987578528,NULL,1698250523,'1',NULL,0,'','0'),
(2510,NULL,'Говіка Свєта',NULL,'2018-06-14',NULL,380969900013,NULL,1517995619,'1',NULL,0,'','0'),
(2511,NULL,'Романейко Діана',NULL,'2018-06-14',NULL,380663532518,NULL,1352455408,'1',NULL,0,'','0'),
(2512,NULL,'андронік оля',NULL,'2018-06-15',NULL,380682315068,NULL,1715486880,'1',NULL,0,'','0'),
(2513,NULL,'шпак наталя',NULL,'2018-06-15',NULL,380985141734,NULL,1372225184,'1',NULL,0,'','0'),
(2514,NULL,'хрик марія',NULL,'2018-06-15',NULL,380971678771,NULL,2045891206,'1',NULL,0,'','0'),
(2515,NULL,'Рябчук ліля',NULL,'2018-06-15',NULL,380684182975,NULL,1692157253,'1',NULL,0,'','0'),
(2516,NULL,'Мотузишин наталя',NULL,'2018-06-15',NULL,380964755098,NULL,2050773731,'1',NULL,0,'','0'),
(2517,NULL,'Гульчак світлана',NULL,'2018-06-15',NULL,380667793342,NULL,1852871892,'1',NULL,0,'','0'),
(2518,NULL,'Вензовська Наталя',NULL,NULL,NULL,380971002113,NULL,1130491178,'1',39479,0,'','0'),
(2519,NULL,'Ратушняк Михайло',NULL,'2018-06-15',NULL,380967665461,NULL,1152493478,'1',NULL,0,'','0'),
(2520,NULL,'Сивак Тарас',NULL,NULL,NULL,380677588398,NULL,1414872018,'1',NULL,0,'','0'),
(2521,NULL,'Таня Жовтюк',NULL,'2018-06-15',NULL,380976785153,NULL,1164049947,'1',NULL,0,'','0'),
(2522,0611,'Шуфлін христина',NULL,NULL,NULL,380955699370,NULL,1186034016,'1',NULL,0,'','0'),
(2523,NULL,'Огородник Віра',NULL,'2018-06-18',NULL,380685592610,NULL,1225129033,'1',NULL,0,'','0'),
(2524,NULL,'Ониськів Оля',NULL,'2018-06-18','JSp5DKweugeX0RUXFEOMKA==',380985207521,NULL,1616337943,'1',14794,5,'','0'),
(2525,NULL,'Полянська Маряна',NULL,'2018-06-18',NULL,380968765580,NULL,2108005387,'1',NULL,0,'','0'),
(2526,NULL,'Зазуляк Христина',NULL,'2018-06-18',NULL,380965774359,NULL,1340436471,'1',20570,0,'','0'),
(2527,NULL,'Заболотна Оля',NULL,NULL,'LGQPN26+jYEN3GD0FwkyAw==',380682895006,NULL,1554599699,'1',45632,0,'','0'),
(2528,NULL,'Мельничук Хрестина',NULL,'2018-06-18','fQW2oeZSzos4hjcLQqmA9w==',380671547137,NULL,1182662175,'1',NULL,0,'','0'),
(2529,NULL,'Соробей Маряна',NULL,'2018-06-18',NULL,380968376486,NULL,1460430052,'1',NULL,0,'','0'),
(2530,NULL,'Репета Інна',NULL,'2018-06-18',NULL,380636878535,NULL,1661006711,'1',NULL,0,'','0'),
(2531,NULL,'Левченко таня',NULL,'2018-06-18',NULL,380989477728,NULL,1717204251,'1',NULL,0,'','0'),
(2532,NULL,'Купецька Тая',NULL,NULL,NULL,380990292179,NULL,1152076928,'1',NULL,2,'','0'),
(2533,NULL,'Блаженко Оля',NULL,'2018-06-19',NULL,380967471464,NULL,1692353597,'1',NULL,0,'','0'),
(2534,NULL,'Сули',NULL,'2018-06-19',NULL,NULL,NULL,1889829778,'1',NULL,0,'','0'),
(2535,NULL,'Міліневич Оля',NULL,'2018-06-19',NULL,380689574338,NULL,1623239333,'1',NULL,0,'','0'),
(2536,NULL,'Матвієшин Ірина',NULL,'2018-06-19',NULL,380983859857,NULL,1529219501,'1',NULL,0,'','0'),
(2537,NULL,'Нетребяк Валентина',NULL,NULL,NULL,380955845111,NULL,1710391838,'1',NULL,0,'','0'),
(2538,0551,'пилипів христя',NULL,NULL,NULL,380961315440,NULL,1321482570,'1',NULL,0,'','0'),
(2540,NULL,'Сорока Інна',NULL,'2018-06-20',NULL,380968520650,NULL,1293423169,'1',NULL,0,'','0'),
(2541,NULL,'висоцька соломія',NULL,NULL,NULL,380972600946,NULL,1475172350,'1',NULL,0,'','0'),
(2542,NULL,'Стадничук Маряна',NULL,'2018-06-20',NULL,380985208837,NULL,1404874834,'1',NULL,0,'','0'),
(2543,NULL,'Ковалишин Таня',NULL,'2018-06-20',NULL,380683320379,NULL,1182408266,'1',NULL,0,'','0'),
(2544,NULL,'Галамбець Софія',NULL,NULL,'Sn/GZFVdTrGGEPQcAjA50Q==',380982627857,NULL,1289468366,'1',42052,0,'','0'),
(2545,NULL,'Пелеш Кароліна',NULL,'2018-06-21',NULL,380961027686,NULL,1372308713,'1',NULL,0,'','0'),
(2546,NULL,'Михальчук Світлана',NULL,'2018-06-21',NULL,380978764780,NULL,1494736981,'1',NULL,0,'','0'),
(2547,NULL,'Юрків Ліля',NULL,'2018-06-21',NULL,380975929574,NULL,1978090493,'1',NULL,0,'','0'),
(2548,NULL,'Ягнич Галина',NULL,'2018-06-21',NULL,380971959022,NULL,1215131604,'1',NULL,0,'','0'),
(2549,NULL,'Вівчар Світлана',NULL,'2018-06-21',NULL,380686263624,NULL,1606351630,'1',NULL,0,'','0'),
(2550,NULL,'Мишкун Віта',NULL,NULL,NULL,380500261512,NULL,1683823694,'1',NULL,0,'','0'),
(2551,NULL,'Дідик Настя',NULL,'2018-06-21',NULL,380980274962,NULL,1477228636,'1',NULL,0,'','0'),
(2552,NULL,'Клівнік Галя',NULL,'2018-06-21',NULL,380969810749,NULL,1524406561,'1',NULL,0,'','0'),
(2553,NULL,'Лецан Інна',NULL,NULL,NULL,380683381002,NULL,1913262650,'1',NULL,0,'','0'),
(2554,0633,'Колісник Інна',NULL,NULL,NULL,380979338093,NULL,1270350693,'1',NULL,0,'','0'),
(2555,NULL,'Бала Оксана',NULL,'2018-06-22',NULL,380503773238,NULL,1838953043,'1',NULL,0,'','0'),
(2556,NULL,'Мелимука Ірина',NULL,'2018-06-22',NULL,380683424907,NULL,1417782320,'1',NULL,0,'','0'),
(2557,NULL,'Шпак Оля',NULL,'2018-06-22',NULL,380986403487,NULL,1820691055,'1',NULL,0,'','0'),
(2558,NULL,'Гевко Оксана',NULL,NULL,NULL,NULL,NULL,1141368868,'1',NULL,0,'','1'),
(2559,NULL,'Кузяк Оля',NULL,'2018-06-23',NULL,380978328217,NULL,1233364448,'1',NULL,0,'','0'),
(2560,NULL,'Мохонько Ольга',NULL,'2018-06-23',NULL,380987782563,NULL,1501395856,'1',NULL,0,'','0'),
(2561,NULL,'Криніцька Христина',NULL,'2018-06-23',NULL,380976851263,NULL,1554832188,'1',NULL,0,'','0'),
(2562,NULL,'гардамала  світлана',NULL,NULL,NULL,380972304837,NULL,1946952642,'1',NULL,1,'','0'),
(2563,NULL,'Черниш Юля',NULL,'2018-06-25',NULL,380679740628,NULL,1371762174,'1',NULL,0,'','0'),
(2564,NULL,'Підкова Наталя',NULL,'2018-06-25',NULL,380979251143,NULL,1634568001,'1',NULL,0,'','0'),
(2565,NULL,'Орлик Наталя',NULL,'2018-06-25','2Gwnm3lKJCt8yG5qFH4/Bw==',380990536240,NULL,1640245747,'1',50189,0,'','0'),
(2566,NULL,'Левин Іванна',NULL,NULL,NULL,380976549644,NULL,1937706759,'1',NULL,0,'','0'),
(2567,NULL,'Золота Романія',NULL,'2018-06-25',NULL,380988905146,NULL,1825614370,'1',NULL,0,'','0'),
(2568,NULL,'Золота Аня',NULL,'2018-06-25',NULL,380979423129,NULL,1340163009,'1',NULL,0,'','0'),
(2569,NULL,'Слонь Соломія',NULL,'2018-06-25',NULL,380968246459,NULL,1514269726,'1',NULL,0,'','0'),
(2570,NULL,'Батрин Надя',NULL,'2018-06-25',NULL,380976263610,NULL,1950747504,'1',NULL,0,'','0'),
(2571,NULL,'Мирончук Марія',NULL,'2018-06-25',NULL,380502005834,NULL,1221435253,'1',NULL,0,'','0'),
(2572,NULL,'Рудик Яна',NULL,'2018-06-25',NULL,380976258400,NULL,1270523021,'1',NULL,0,'','0'),
(2573,NULL,'галя рубін',NULL,'2018-06-25',NULL,380680407647,NULL,1684724515,'1',NULL,0,'','0'),
(2574,NULL,'Бегма Катя',NULL,'2018-06-25',NULL,380967525570,NULL,1997836165,'1',NULL,0,'','0'),
(2575,NULL,'маряна наша',NULL,'2018-06-26',NULL,NULL,NULL,1885271456,'1',NULL,0,'','0'),
(2576,NULL,'Ванджура Маряна',NULL,'2018-06-26',NULL,380983568978,NULL,1374635539,'1',NULL,0,'','0'),
(2577,NULL,'Стадник Аня',NULL,'2018-06-26',NULL,380663962773,NULL,1534391923,'1',NULL,0,'','0'),
(2578,NULL,'Ковальчук Оксана',NULL,'2018-06-26',NULL,380688764534,NULL,1425444362,'1',NULL,0,'','0'),
(2579,NULL,'Артюніна Олена',NULL,'2018-06-26',NULL,380938861400,NULL,1640061142,'1',NULL,0,'','0'),
(2580,NULL,'Куцій Оля',NULL,'2018-06-26',NULL,380681610999,NULL,1950765232,'1',NULL,0,'','0'),
(2581,NULL,'Шептицька Таня',NULL,'2018-06-26',NULL,380976230381,NULL,1918450922,'1',NULL,0,'','0'),
(2582,NULL,'Дмитрик Леся',NULL,'2018-06-26',NULL,380968117012,NULL,1436085624,'1',NULL,0,'','0'),
(2583,NULL,'Вавришин Таня',NULL,'2018-06-26',NULL,380979117123,NULL,1974350632,'1',NULL,0,'','0'),
(2584,NULL,'Молодій Іра',NULL,'2018-06-26',NULL,380509861164,NULL,1942051316,'1',NULL,0,'','0'),
(2585,NULL,'Бойко Наталя',NULL,'2018-06-27',NULL,380667737884,NULL,2046204569,'1',NULL,0,'','0'),
(2586,NULL,'Наконечна Надія',NULL,'2018-06-27',NULL,380967443967,NULL,1676660276,'1',NULL,0,'','0'),
(2587,NULL,'Дяків Таня',NULL,'2018-06-27',NULL,380669403372,NULL,1879722756,'1',NULL,0,'','0'),
(2588,NULL,'Давидюк Леся',NULL,'2018-06-27',NULL,380962296868,NULL,1662291770,'1',NULL,0,'','0'),
(2589,NULL,'Батрикуш Віка',NULL,'2018-06-27',NULL,380983580264,NULL,1443493482,'1',NULL,0,'','0'),
(2590,NULL,'Вовчук Віка',NULL,'2018-06-28',NULL,380984306572,NULL,1323970103,'1',NULL,0,'','0'),
(2591,NULL,'Манастирчук Валентина',NULL,NULL,NULL,380987195767,NULL,2095467290,'1',NULL,0,'','0'),
(2592,NULL,'Липак Оля',NULL,'2018-06-28',NULL,380987950967,NULL,1849881573,'1',NULL,0,'','0'),
(2593,NULL,'Замойська Оксана',NULL,'2018-06-28',NULL,380637301540,NULL,1722470723,'1',NULL,0,'','0'),
(2594,NULL,'божагора оля',NULL,NULL,NULL,NULL,NULL,1622899494,'1',NULL,0,'','1'),
(2595,NULL,'Аня Дубневич',NULL,'2018-06-28',NULL,380673922752,NULL,1628573760,'1',NULL,0,'','0'),
(2596,NULL,'Аня Дубневич',NULL,'2018-06-28',NULL,NULL,NULL,1839890744,'1',NULL,0,'','0'),
(2597,NULL,'Остапчук Євгенія',NULL,'2018-06-29',NULL,380975420222,NULL,1126892393,'1',NULL,0,'','0'),
(2598,NULL,'іРА хОТІНСЬКА',NULL,'2018-06-29',NULL,380972383194,NULL,1721447498,'1',NULL,0,'','0'),
(2599,NULL,'Гуцул Оксана',NULL,'2018-06-29',NULL,380672991995,NULL,2061683420,'1',NULL,0,'','0'),
(2600,NULL,'Мерлавська Аня',NULL,'2018-06-29','7+0Aoa3sdCUiJvFX38TGZQ==',380972781618,NULL,2036992617,'1',18415,0,'','0'),
(2601,NULL,'Власюк Світлана',NULL,'2018-06-30',NULL,380674961552,NULL,1406052993,'1',NULL,0,'','0'),
(2602,NULL,'Лунишин Оксана',NULL,'2018-06-30',NULL,380682372002,NULL,1970924905,'1',NULL,0,'','0'),
(2603,NULL,'Глова Ірина',NULL,NULL,NULL,380982188657,NULL,1483616398,'1',NULL,0,'','0'),
(2604,NULL,'більович галина',NULL,'2018-06-30',NULL,380969588132,NULL,1819698466,'1',NULL,0,'','0'),
(2605,0603,'Гладка Олександра',NULL,NULL,NULL,380987652422,NULL,1531108081,'1',46338,1,'','0'),
(2606,NULL,'Урбанська Таня',NULL,'2018-07-02',NULL,380681759264,NULL,1544517207,'1',NULL,0,'','0'),
(2607,NULL,'Стасишин Інна',NULL,'2018-07-02',NULL,380961357986,NULL,1935413105,'1',NULL,0,'','0'),
(2608,NULL,'Церковна Марія',NULL,'2018-07-02',NULL,380982534370,NULL,1985876552,'1',NULL,0,'','0'),
(2609,NULL,'Мацишин Іванна',NULL,'2018-07-02',NULL,380978332112,NULL,1769799211,'1',NULL,1,'','0'),
(2610,NULL,'Фрич Ольга',NULL,'2018-07-02',NULL,380689049545,NULL,1231849132,'1',61273,3,'','0'),
(2611,NULL,'Сорока Оксана',NULL,'2018-07-02',NULL,380679522538,NULL,1568001110,'1',NULL,0,'','0'),
(2612,NULL,'Пісяк Світлана',NULL,'2018-07-02',NULL,380978563907,NULL,1283058546,'1',36298,0,'','0'),
(2613,NULL,'Охман Таня',NULL,'2018-07-02',NULL,380960085245,NULL,1695399818,'1',NULL,0,'','0'),
(2614,NULL,'Курка Наталя',NULL,'2018-07-02',NULL,380930575258,NULL,1372716378,'1',NULL,0,'','0'),
(2615,NULL,'ДанильчукЮля',NULL,'2018-07-02',NULL,380684756812,NULL,1210868588,'1',NULL,0,'','0'),
(2616,NULL,'Іонуца Ірина',NULL,'2018-07-02',NULL,380502933424,NULL,1791921474,'1',NULL,0,'','0'),
(2617,NULL,'Геба Оксана',NULL,'2018-07-03',NULL,380975436444,NULL,1521764848,'1',NULL,0,'','0'),
(2618,NULL,'Ландяк христина',NULL,'2018-07-03',NULL,380689678538,NULL,1370557666,'1',14014,0,'','0'),
(2619,NULL,'свистун маряна',NULL,NULL,NULL,380961863775,NULL,1316699634,'1',63395,0,'','0'),
(2620,NULL,'Мостович Марія',NULL,'2018-07-03',NULL,380961351086,NULL,2101578149,'1',NULL,0,'','0'),
(2621,NULL,'Багрій Наталя',NULL,'2018-07-03',NULL,380977085638,NULL,1523442655,'1',NULL,0,'','0'),
(2622,NULL,'Данилюк Таня',NULL,'2018-07-03',NULL,380685090234,NULL,1356869578,'1',NULL,0,'','0'),
(2623,NULL,'Стасюк Оксана',NULL,'2018-07-03',NULL,380686120908,NULL,1544210127,'1',NULL,0,'','0'),
(2624,NULL,'Бачинська Таня',NULL,'2018-07-04',NULL,380984709097,NULL,1846625590,'1',NULL,0,'','0'),
(2625,NULL,'Замлинська Іванна',NULL,'2018-07-04',NULL,380989336132,NULL,1612030937,'1',NULL,0,'','0'),
(2626,NULL,'Гринчак Таня',NULL,'2018-07-04',NULL,380989735865,NULL,1751604791,'1',NULL,0,'','0'),
(2627,NULL,'Ільчук Таня',NULL,NULL,NULL,380967257645,NULL,1193910842,'1',NULL,0,'','0'),
(2628,NULL,'Федин Люда',NULL,'2018-07-05',NULL,380973886268,NULL,1195015887,'1',NULL,0,'','0'),
(2629,NULL,'Горба Галя',NULL,'2018-07-05',NULL,380968775659,NULL,1985003148,'1',NULL,0,'','0'),
(2630,NULL,'Бик Лідія',NULL,'2018-07-05',NULL,380972564917,NULL,1985297619,'1',NULL,0,'','0'),
(2631,NULL,'Білик Оксана ІРИ КЛІЄНТКА',NULL,NULL,NULL,380987292605,NULL,1657134953,'1',20155,0,'','0'),
(2632,NULL,'Андрусевич Світлана',NULL,'2018-07-05',NULL,380682885262,NULL,1194981207,'1',NULL,0,'','0'),
(2633,NULL,'Кавюк Галя',NULL,'2018-07-05',NULL,380984038217,NULL,1436579860,'1',NULL,0,'','0'),
(2634,NULL,'Окіпний Саша',NULL,'2018-07-05',NULL,380955643792,NULL,2083820709,'1',NULL,0,'','0'),
(2635,NULL,'христина Пендиківська',NULL,'2018-07-05',NULL,380966909454,NULL,1314670408,'1',NULL,0,'','0'),
(2636,NULL,'Бик Яна',NULL,'2018-07-05',NULL,380972564861,NULL,2002930270,'1',NULL,0,'','0'),
(2637,NULL,'Чикалюк Галина',NULL,'2018-07-05',NULL,380966107038,NULL,1638522299,'1',NULL,0,'','0'),
(2638,NULL,'Лазорик Оля',NULL,'2018-07-06',NULL,380971321805,NULL,1831920576,'1',NULL,0,'','0'),
(2639,NULL,'Войцішевська Надя',NULL,'2018-07-06',NULL,380683239249,NULL,1790630735,'1',NULL,0,'','0'),
(2640,NULL,'Візнюк Леся',NULL,'2018-07-09',NULL,380986358638,NULL,2081993608,'1',NULL,0,'','0'),
(2641,NULL,'Потапова Ліда',NULL,NULL,NULL,380981171550,NULL,1335445159,'1',NULL,0,'','0'),
(2642,NULL,'Добрій Галина',NULL,'2018-07-09',NULL,380978949272,NULL,2063501299,'1',NULL,0,'','0'),
(2643,NULL,'Дубчак Світлана',NULL,'2018-07-09',NULL,380684638948,NULL,1160134513,'1',NULL,0,'','0'),
(2644,NULL,'Андрійчук Таня',NULL,'2018-07-09',NULL,380987711528,NULL,1456181756,'1',NULL,0,'','0'),
(2645,NULL,'Ткач Світлана',NULL,'2018-07-09',NULL,380684213599,NULL,1602367182,'1',NULL,0,'','0'),
(2646,NULL,'балаш таня',NULL,'2018-07-09',NULL,380979023812,NULL,1274546911,'1',NULL,0,'','0'),
(2647,NULL,'Байрак Юля',NULL,'2018-07-09',NULL,380976703468,NULL,1630302013,'1',NULL,0,'','0'),
(2648,NULL,'Макара Маша',NULL,'2018-07-09',NULL,380965476496,NULL,1144060502,'1',NULL,0,'','0'),
(2649,0198,'Пирогова Марія',NULL,NULL,NULL,380681931837,NULL,1695023311,'1',NULL,1,'','0'),
(2650,NULL,'Буриш Марія',NULL,'2018-07-09',NULL,380963393815,NULL,1643353813,'1',NULL,0,'','0'),
(2651,0901,'Голубяк Юля',NULL,NULL,NULL,380979196232,NULL,1661124076,'1',NULL,0,'','0'),
(2652,0921,'Набок Олеся',NULL,NULL,NULL,380971826793,NULL,1640969153,'1',NULL,0,'','0'),
(2653,NULL,'Леньків Валя',NULL,'2018-07-10',NULL,380984774553,NULL,1993881535,'1',NULL,0,'','0'),
(2654,NULL,'мальована Віка',NULL,'2018-07-10','WNpvELFTZf2gmvjtGmZqww==',380981252053,NULL,1954872073,'1',NULL,0,'','0'),
(2655,NULL,'Смалюх Таня ',NULL,NULL,NULL,380685024710,NULL,2093461341,'1',19499,0,'','0'),
(2656,NULL,'Плюта Люда',NULL,'2018-07-10',NULL,380685781884,NULL,1334236029,'1',23340,2,'','0'),
(2657,NULL,'Ільчишин Марія',NULL,'2018-07-10',NULL,380951369849,NULL,1752466266,'1',NULL,0,'','0'),
(2658,NULL,'Шалай Іванна',NULL,'2018-07-11',NULL,380967397012,NULL,1955843718,'1',NULL,0,'','0'),
(2659,NULL,'Типа Галина',NULL,'2018-07-11',NULL,380970377573,NULL,2125687075,'1',NULL,0,'','0'),
(2660,NULL,'Чернявська Іра',NULL,NULL,'G4TnMJ+AmQnXtqDudAnm9g==',380986359763,NULL,1240033705,'1',35363,0,'','0'),
(2661,NULL,'Дашкевич Наталя',NULL,'2018-07-13',NULL,380979980402,NULL,2053045172,'1',NULL,0,'','0'),
(2662,NULL,'Дереворіз Ліля',NULL,'2018-07-13',NULL,380982671392,NULL,1574136842,'1',NULL,0,'','0'),
(2663,NULL,'Коник Іра',NULL,'2018-07-13',NULL,380988004010,NULL,1727487328,'1',NULL,0,'','0'),
(2664,0905,'Рівняк Ірина',NULL,NULL,NULL,380982051190,NULL,1943247179,'1',NULL,0,'','0'),
(2665,NULL,'Замойська Галина',NULL,'2018-07-14',NULL,380950776206,NULL,2117576404,'1',NULL,0,'','0'),
(2666,NULL,'Балитюк Оля',NULL,'2018-07-14',NULL,380997368158,NULL,1291335536,'1',NULL,0,'','0'),
(2667,NULL,'Марущак Анастасія',NULL,'2018-07-14',NULL,380990368107,NULL,1387449143,'1',NULL,0,'','0'),
(2668,NULL,'Оніщук Ірина',NULL,'2018-07-14',NULL,380958869529,NULL,1733612917,'1',NULL,0,'','0'),
(2669,NULL,'Гонц Марія',NULL,'2018-07-14',NULL,380961951577,NULL,2050785919,'1',NULL,0,'','0'),
(2670,NULL,'Прокопик Наталя',NULL,'2018-07-16',NULL,380685871708,NULL,1449998072,'1',NULL,0,'','0'),
(2671,NULL,'Сорока Оля',NULL,'2018-07-16',NULL,380986070471,NULL,1616343558,'1',NULL,0,'','0'),
(2672,NULL,'Сава Наталія',NULL,'2018-07-16',NULL,380962056058,NULL,1140939440,'1',NULL,0,'','0'),
(2673,NULL,'Ябчанка Марія',NULL,'2018-07-16',NULL,380963418008,NULL,1699681680,'1',NULL,0,'','0'),
(2674,NULL,'Федорович Уляна',NULL,'2018-07-16',NULL,380678320224,NULL,1635692631,'1',NULL,0,'','0'),
(2675,NULL,'Гукалюк Люба',NULL,'2018-07-16','4cyaeYTbFyPbN5CESzMj/g==',380680272735,NULL,2035323031,'1',NULL,2,'','0'),
(2676,NULL,'Кузій Зоряна',NULL,'2018-07-16',NULL,380686497577,NULL,1669786926,'1',NULL,2,'','0'),
(2677,NULL,'Халак Марія',NULL,'2018-07-16',NULL,380673999226,NULL,1611703918,'1',NULL,0,'','0'),
(2678,NULL,'Градова Христина',NULL,'2018-07-16',NULL,380980027938,NULL,1734146147,'1',37827,0,'','0'),
(2679,NULL,'Ляхоцька Іванка',NULL,'2018-07-16',NULL,380989733597,NULL,1950279059,'1',NULL,0,'','0'),
(2680,NULL,'Кухта Світлана',NULL,'2018-07-17',NULL,380934388216,NULL,2111071689,'1',NULL,0,'','0'),
(2681,NULL,'Конопельник Катя',NULL,'2018-07-17',NULL,380978227646,NULL,1994841622,'1',NULL,0,'','0'),
(2682,NULL,'Трач Ліда',NULL,'2018-07-17',NULL,380982901163,NULL,1653698785,'1',NULL,0,'','0'),
(2683,NULL,'Іванків Олена',NULL,'2018-07-17',NULL,380967665263,NULL,1423755951,'1',NULL,0,'','0'),
(2684,NULL,'Манзій Іра',NULL,'2018-07-17',NULL,380678617395,NULL,1895770054,'1',NULL,0,'','0'),
(2685,NULL,'Штокалко Люда',NULL,NULL,NULL,380970510461,NULL,1845141191,'1',43681,0,'','0'),
(2686,NULL,'Курчак Марія',NULL,'2018-07-17',NULL,380684639404,NULL,1507272458,'1',NULL,0,'','0'),
(2687,NULL,'Храплива Настя',NULL,'2018-07-18',NULL,380978501541,NULL,1553655121,'1',NULL,0,'','0'),
(2688,NULL,'Стрільчук Зоряна',NULL,NULL,NULL,380976002296,NULL,1435693677,'1',NULL,0,'','0'),
(2689,NULL,'Чорняк Юля ',NULL,'2018-07-18',NULL,380988039020,NULL,1834478320,'1',NULL,0,'','0'),
(2690,NULL,'Гончарук Маряна',NULL,'2018-07-18',NULL,380686814453,NULL,1562834772,'1',NULL,0,'','0'),
(2691,NULL,'Макар Маряна',NULL,'2018-07-18',NULL,380964016342,NULL,1759319403,'1',NULL,0,'','0'),
(2692,NULL,'Салій Ольга',NULL,'2018-07-19',NULL,380965241026,NULL,1426435250,'1',NULL,0,'','0'),
(2693,NULL,'Крупа Оля',NULL,NULL,NULL,380977007887,NULL,1354028113,'1',NULL,0,'','0'),
(2694,NULL,'Мулик Діана',NULL,'2018-07-19',NULL,380984288771,NULL,1152703176,'1',NULL,0,'','0'),
(2695,NULL,'Дацків Олеся',NULL,NULL,NULL,380678570328,NULL,1335147703,'1',NULL,0,'','0'),
(2696,NULL,'Нетреба Галина',NULL,'2018-07-19',NULL,380666673537,NULL,1519526420,'1',NULL,0,'','0'),
(2697,NULL,'Мулик Маряна',NULL,NULL,NULL,380673908014,NULL,2069633484,'1',NULL,0,'','0'),
(2698,NULL,'Шип Наталя',NULL,'2018-07-19',NULL,380984772440,NULL,1145869892,'1',NULL,0,'','0'),
(2699,NULL,'Ковалюк Юля',NULL,'2018-07-19',NULL,380989904570,NULL,1440628471,'1',NULL,0,'','0'),
(2700,NULL,'Деренюк Олександра',NULL,NULL,NULL,380983075938,NULL,1923011416,'1',NULL,0,'','0'),
(2701,NULL,'Бурник Таня',NULL,'2018-07-20',NULL,380981325256,NULL,1342710947,'1',NULL,0,'','0'),
(2702,NULL,'Середа Оксана',NULL,'2018-07-20',NULL,380689699496,NULL,1877297676,'1',NULL,0,'','0'),
(2703,NULL,'пастух іра',NULL,'2018-07-21',NULL,380986598913,NULL,1180276438,'1',NULL,0,'','0'),
(2704,NULL,'Ганушевська Настя',NULL,'2018-07-21',NULL,380951059686,NULL,1404035513,'1',NULL,1,'','0'),
(2705,NULL,'Вісловокова Наталя',NULL,'2018-07-21',NULL,380961663895,NULL,1360599969,'1',NULL,0,'','0'),
(2706,NULL,'Штиник Маря',NULL,'2018-07-21',NULL,380977028876,NULL,1909770558,'1',NULL,0,'','0'),
(2707,NULL,'Втрикуш віка',NULL,NULL,NULL,380973450936,NULL,1957009522,'1',NULL,0,'','0'),
(2708,NULL,'Дубчак Маряна',NULL,'2018-07-23',NULL,380683239369,NULL,2025924053,'1',NULL,0,'','0'),
(2709,NULL,'Совчук Іра',NULL,'2018-07-23',NULL,380960315467,NULL,1518340448,'1',NULL,0,'','0'),
(2710,NULL,'Храпа Олександра',NULL,NULL,NULL,380978600876,NULL,1757145509,'1',NULL,0,'','0'),
(2711,NULL,'Ратушняк Світлана',NULL,'2018-07-23',NULL,380673513287,NULL,1137490007,'1',NULL,0,'','0'),
(2712,NULL,'польна юля',NULL,'2018-07-23',NULL,380984488166,NULL,1650110282,'1',NULL,0,'','0'),
(2713,NULL,'Блюй Христия',NULL,'2018-07-23',NULL,380969764557,NULL,2098622670,'1',NULL,0,'','0'),
(2714,NULL,'Волоська Марія',NULL,'2018-07-23',NULL,380969259862,NULL,2032113711,'1',NULL,0,'','0'),
(2715,NULL,'Шумак Таня',NULL,'2018-07-23',NULL,380637597168,NULL,2100991826,'1',NULL,0,'','0'),
(2716,NULL,'Джумага Наталя ',NULL,'2018-07-23',NULL,380685145816,NULL,1359447824,'1',NULL,0,'','0'),
(2717,NULL,'Просимяк Лєна',NULL,'2018-07-23',NULL,380975252530,NULL,1715093875,'1',NULL,0,'','0'),
(2718,NULL,'Волощук Люда',NULL,'2018-07-24',NULL,380684780182,NULL,2040550580,'1',NULL,0,'','0'),
(2719,NULL,'Крочак наталя',NULL,'2018-07-24',NULL,380674752723,NULL,1325845609,'1',NULL,0,'','0'),
(2720,NULL,'Лиха Надія',NULL,NULL,NULL,380982515638,NULL,1333482388,'1',NULL,1,'','0'),
(2721,NULL,'Деренюк Наталя',NULL,'2018-07-24',NULL,380988723059,NULL,1226490846,'1',NULL,0,'','0'),
(2722,NULL,'Бариська Христя',NULL,'2018-07-24',NULL,380966037609,NULL,1853252959,'1',NULL,1,'','0'),
(2723,NULL,'Гикавчук Маряна',NULL,'2018-07-24',NULL,380686469153,NULL,1798389220,'1',NULL,0,'','0'),
(2724,NULL,'Левчук Ілона',NULL,'2018-07-24',NULL,380976650446,NULL,1385077198,'1',NULL,0,'','0'),
(2725,NULL,'Пустельник Аня',NULL,'2018-07-25',NULL,380969686794,NULL,1945235739,'1',NULL,0,'','0'),
(2726,NULL,'Москалюк Алла',NULL,'2018-07-25',NULL,380962287672,NULL,1503215982,'1',NULL,0,'','0'),
(2727,NULL,'Кучерук Олена',NULL,'2018-07-25',NULL,380950908505,NULL,2100558158,'1',16916,0,'','0'),
(2728,NULL,'Краснянська Алла',NULL,'2018-07-25',NULL,380677395779,NULL,1522772422,'1',NULL,0,'','0'),
(2729,NULL,'Явна марія',NULL,'2018-07-25',NULL,380988073942,NULL,1723315216,'1',NULL,0,'','0'),
(2730,NULL,'Катя наша ',NULL,NULL,NULL,NULL,NULL,1729014686,'1',NULL,0,'','0'),
(2731,NULL,'Романів Оксана',NULL,'2018-07-25',NULL,380992698743,NULL,1126522599,'1',NULL,0,'','0'),
(2732,NULL,'Крижанівська Олеся',NULL,'2018-07-25',NULL,380979310004,NULL,1680630887,'1',NULL,0,'','0'),
(2733,NULL,'інгібаєва люда',NULL,'2018-07-26',NULL,380963163150,NULL,1835672258,'1',NULL,0,'','0'),
(2734,NULL,'Лемішка Оля',NULL,'2018-07-26',NULL,380992901618,NULL,1412160681,'1',NULL,0,'','0'),
(2735,NULL,'Остапенко Оля',NULL,'2018-07-26',NULL,380677543970,NULL,1646043871,'1',NULL,0,'','0'),
(2736,NULL,'Махно Оля',NULL,'2018-07-26',NULL,380679573328,NULL,1331196780,'1',NULL,0,'','0'),
(2737,NULL,'Кремарчук Іра',NULL,'2018-07-26',NULL,380987624781,NULL,1307341234,'1',NULL,0,'','0'),
(2738,NULL,'Стесишни Андріана',NULL,'2018-07-27',NULL,380978091989,NULL,2044431916,'1',NULL,0,'','0'),
(2739,NULL,'Балинюк настя',NULL,'2018-07-27',NULL,380677675829,NULL,1694511224,'1',NULL,0,'','0'),
(2740,NULL,'Гаврилюк Віра',NULL,'2018-07-27',NULL,380980954231,NULL,2114893394,'1',NULL,0,'','0'),
(2741,NULL,'Пилип Таня',NULL,NULL,NULL,380979664134,NULL,1777199774,'1',NULL,0,'','0'),
(2742,NULL,'Клим  Світлана',NULL,NULL,NULL,380972397818,NULL,1121819471,'1',NULL,0,'','0'),
(2743,NULL,'Тимчук Марія',NULL,NULL,NULL,380732002750,NULL,1603872844,'1',NULL,0,'','0'),
(2744,NULL,' 	Білоус Христина',NULL,NULL,NULL,380684487472,380681250153,1946893949,'1',NULL,0,'','0'),
(2745,NULL,'Нагайовська Іванка',NULL,'2018-07-28','No1xrZpfWCK24j+iAagwxw==',380975121229,NULL,1268311445,'1',25093,0,'','0'),
(2746,NULL,'Дмитрук Олена',NULL,'2018-07-28',NULL,380969133981,NULL,1978254098,'1',NULL,0,'','0'),
(2747,NULL,'Повородник Галина',NULL,'2018-07-28',NULL,380989221367,NULL,1417775159,'1',NULL,0,'','0'),
(2748,NULL,'Цимбала Наталя',NULL,'2018-07-28',NULL,380966550991,NULL,1789439155,'1',NULL,0,'','0'),
(2749,NULL,'Налізьона Таня',NULL,'2018-07-30',NULL,380979789162,NULL,1997122940,'1',NULL,0,'','0'),
(2750,NULL,'Хрик Марія',NULL,'2018-07-30',NULL,380971668779,NULL,1927385115,'1',NULL,0,'','0'),
(2751,NULL,'Висоцький Максим',NULL,'2018-07-30',NULL,380672106969,NULL,1130429153,'1',NULL,0,'','0'),
(2752,NULL,'Фундитус Олеся',NULL,'2018-07-30',NULL,380957907407,NULL,1292651432,'1',NULL,0,'','0'),
(2753,NULL,'Прокоп Любов',NULL,'2018-07-30',NULL,380672854587,NULL,2010285459,'1',NULL,0,'','0'),
(2754,NULL,'ВОВГАТИНСЬКА ТЕТЯНА',NULL,'2018-07-30',NULL,380979289031,NULL,1683194919,'1',NULL,0,'','0'),
(2755,NULL,'Юрчишин Оксана',NULL,'2018-07-31',NULL,380686955909,NULL,1323184534,'1',NULL,0,'','0'),
(2756,NULL,'Смоляк Марта',NULL,NULL,NULL,380979943220,NULL,1331101531,'1',NULL,0,'','0'),
(2757,NULL,'Домнюк Таня',NULL,'2018-07-31',NULL,380950128651,NULL,1490240619,'1',NULL,0,'','0'),
(2758,NULL,'Макарик Таня',NULL,'2018-07-31',NULL,380961903857,NULL,2096987405,'1',NULL,0,'','0'),
(2759,NULL,'Регейло Віка',NULL,'2018-07-31',NULL,380685535528,NULL,2140109468,'1',NULL,0,'','0'),
(2760,NULL,'Кишкан Надія',NULL,'2018-07-31',NULL,380689192457,NULL,1644941924,'1',NULL,0,'','0'),
(2761,NULL,'Доскоч Іра',NULL,'2018-07-31',NULL,380989367222,NULL,1565130555,'1',NULL,0,'','0'),
(2762,NULL,'Смаль Марія',NULL,'2018-07-31',NULL,380677082491,NULL,1852328513,'1',NULL,0,'','0'),
(2763,NULL,'Дмитрик Віка',NULL,'2018-08-01',NULL,380978002162,NULL,1434202635,'1',NULL,0,'','0'),
(2764,NULL,'Перожик Віра',NULL,'2018-08-01',NULL,380977028708,NULL,1398066748,'1',NULL,0,'','0'),
(2765,NULL,'Колісник Катя',NULL,'2018-08-01',NULL,380955063752,NULL,1643314798,'1',NULL,0,'','0'),
(2766,NULL,'Вовк Світлана',NULL,'2018-08-01',NULL,380988044799,NULL,1332972928,'1',NULL,0,'','0'),
(2767,NULL,'Дисько Галина',NULL,'2018-08-01',NULL,380966590670,NULL,1309033467,'1',NULL,1,'','0'),
(2768,NULL,'Бринарська Ілона',NULL,'2018-08-01',NULL,380978158906,NULL,1961034968,'1',NULL,0,'','0'),
(2769,NULL,'Сенів Оля',NULL,'2018-08-02',NULL,380687269570,NULL,1461471136,'1',NULL,0,'','0'),
(2770,NULL,'Бойко Наталя',NULL,'2018-08-02',NULL,380989746288,NULL,1683428138,'1',NULL,0,'','0'),
(2771,NULL,'Козак Мирослава',NULL,'2018-08-02',NULL,380675919149,NULL,1287418504,'1',NULL,0,'','0'),
(2772,NULL,'Губіцька Яна',NULL,'2018-08-02',NULL,380986530829,NULL,1175900280,'1',NULL,0,'','0'),
(2773,NULL,'Дідюк Світлана',NULL,'2018-08-03',NULL,380967594135,NULL,1291843267,'1',NULL,1,'','0'),
(2774,NULL,'Кучман Таня',NULL,'2018-08-03',NULL,380963539749,NULL,1379633290,'1',NULL,0,'','0'),
(2775,NULL,'Кубінська Галина',NULL,'2018-08-03',NULL,380983327101,NULL,2018835582,'1',NULL,0,'','0'),
(2776,NULL,'Крива Марина',NULL,'2018-08-03',NULL,380501948916,NULL,1934550412,'1',NULL,0,'','0'),
(2777,NULL,'Шаровська Васелина',NULL,'2018-08-03',NULL,380688405688,NULL,1527352063,'1',NULL,0,'','0'),
(2778,NULL,'Ціховляз маряна',NULL,'2018-08-04',NULL,380678961175,NULL,1449495042,'1',NULL,0,'','0'),
(2779,NULL,'Бригідир ОЛя',NULL,'2018-08-04',NULL,380679603055,NULL,1468050699,'1',NULL,0,'','0'),
(2780,NULL,'Вовк Галина',NULL,'2018-08-04',NULL,380936556100,NULL,1518800621,'1',NULL,0,'','0'),
(2781,NULL,'Федорків Наталя',NULL,'2018-08-04',NULL,380976725283,NULL,1227343358,'1',NULL,0,'','0'),
(2782,NULL,'Пиріжок Надя',NULL,'2018-08-04',NULL,380989457638,NULL,1470335661,'1',NULL,0,'','0'),
(2783,NULL,'Шептицька Наталя',NULL,'2018-08-04',NULL,380988867060,NULL,1195921581,'1',NULL,0,'','0'),
(2784,NULL,'Плішка Таня',NULL,'2018-08-05',NULL,380989741686,NULL,1972183479,'1',NULL,0,'','0'),
(2785,NULL,'Свідзінський Сергій',NULL,'2018-08-06',NULL,380988139928,NULL,1709238057,'1',NULL,0,'','0'),
(2786,NULL,'Стесюк Марія',NULL,'2018-08-06',NULL,380977311619,NULL,2115445435,'1',NULL,1,'','0'),
(2787,NULL,'стахів маряна',NULL,'2018-08-06',NULL,380979500809,NULL,1188408382,'1',NULL,0,'','0'),
(2788,NULL,'Горішко Таня',NULL,'2018-08-06',NULL,380633832859,NULL,1666107763,'1',NULL,0,'','0'),
(2789,NULL,'Орлик Софія',NULL,'2018-08-06',NULL,380689281794,NULL,1819666449,'1',NULL,0,'','0'),
(2790,NULL,'Крамарчук Ірина',NULL,NULL,NULL,380682072838,NULL,1151207656,'1',NULL,0,'','0'),
(2791,NULL,'Воробець Надія',NULL,'2018-08-07',NULL,380976377969,NULL,1977367891,'1',38106,0,'','0'),
(2792,NULL,'Мельник Марія',NULL,'2018-08-07',NULL,380976913216,NULL,1294986463,'1',NULL,0,'','0'),
(2793,NULL,'Бандрійчак Світлана',NULL,'2018-08-07',NULL,380684440534,NULL,1478894817,'1',NULL,0,'','0'),
(2794,NULL,'Григораш Софія',NULL,'2018-08-07',NULL,380686654474,NULL,1759382000,'1',NULL,0,'','0'),
(2795,NULL,'Головецька Віталія',NULL,'2018-08-07',NULL,380982901414,NULL,1664053433,'1',NULL,0,'','0'),
(2796,NULL,'Богоєва Настя',NULL,'2018-08-07',NULL,380977220328,NULL,2021355221,'1',NULL,0,'','0'),
(2797,NULL,'Ковальчук Олеся',NULL,'2018-08-08',NULL,380976727862,NULL,1873879473,'1',NULL,0,'','0'),
(2798,NULL,'Себастянова Таня',NULL,NULL,NULL,380935481048,NULL,1154071370,'1',NULL,0,'','0'),
(2799,NULL,'Костельна Люба ',NULL,'2018-08-08','TlzXfRpGeoyCXmMwe7o1Ug==',380969004800,NULL,1640017243,'1',NULL,1,'','0'),
(2800,NULL,'хомяк галя',NULL,'2018-08-09',NULL,380671097542,NULL,1518182208,'1',NULL,0,'','0'),
(2801,NULL,'Войтович Віка',NULL,'2018-08-09',NULL,380633345455,NULL,1772777755,'1',NULL,0,'','0'),
(2802,NULL,'Хлопчишин Таня',NULL,'2018-08-09',NULL,380968796519,NULL,1474697289,'1',NULL,0,'','0'),
(2803,NULL,'Медведіва Марія',NULL,'2018-08-09',NULL,380989966195,NULL,1805233427,'1',NULL,0,'','0'),
(2804,NULL,'Данчук Настя',NULL,'2018-08-09',NULL,380961566266,NULL,1613905452,'1',NULL,0,'','0'),
(2805,NULL,'Захарків Оля',NULL,'2018-08-09',NULL,380950350106,NULL,1240741114,'1',NULL,0,'','0'),
(2806,NULL,'Клапата Таня',NULL,'2018-08-09',NULL,380969506460,NULL,1647188248,'1',NULL,0,'','0'),
(2807,NULL,'алексевич наталя',NULL,NULL,NULL,380683352620,NULL,1485330854,'1',NULL,0,'','0'),
(2808,NULL,'Гулевич Іра',NULL,NULL,NULL,380967487433,NULL,1727184976,'1',NULL,0,'','0'),
(2809,NULL,'Джижора Таня',NULL,'2018-08-09',NULL,380677879602,NULL,1600576734,'1',NULL,0,'','0'),
(2810,NULL,'Шевчук Галя',NULL,'2018-08-10',NULL,380954426294,NULL,1278355989,'1',NULL,0,'','0'),
(2811,NULL,'Клименко Галина',NULL,'2018-08-10',NULL,380672709233,NULL,1447156598,'1',NULL,0,'','0'),
(2812,NULL,'Брунарська Іра',NULL,'2018-08-10',NULL,380685875719,NULL,1142747340,'1',NULL,0,'','0'),
(2813,NULL,'Галанюк Іванна',NULL,'2018-08-10',NULL,380985864078,NULL,1830877869,'1',NULL,0,'','0'),
(2814,NULL,'Юнко Олеся',NULL,'2018-08-11',NULL,380971695489,NULL,1645890979,'1',NULL,0,'','0'),
(2815,NULL,'Веселовська Діана',NULL,NULL,NULL,380970554024,NULL,1348848514,'1',NULL,0,'','0'),
(2816,NULL,'Данилюк Оля',NULL,'2018-08-11',NULL,380680463914,NULL,1690072708,'1',NULL,0,'','0'),
(2817,NULL,'Батрин Аліна',NULL,NULL,NULL,380671659245,NULL,2085405920,'1',NULL,0,'','0'),
(2818,NULL,'Віталік Пеньковський',NULL,'2018-08-12',NULL,380674905307,NULL,1213641613,'1',NULL,0,'','0'),
(2819,NULL,'Сендзюк Юля',NULL,'2018-08-13',NULL,380972216779,NULL,1823576539,'1',NULL,0,'','0'),
(2820,NULL,'Гуртик Іванна',NULL,'2018-08-13',NULL,380982963200,NULL,1291384434,'1',NULL,0,'','0'),
(2821,NULL,'Табачак Соломія',NULL,NULL,NULL,380684213573,NULL,1250582884,'1',NULL,0,'','0'),
(2822,NULL,'Букалюк Таня',NULL,'2018-08-13',NULL,380680884414,NULL,1126122602,'1',NULL,0,'','0'),
(2823,NULL,'багрій наталя',NULL,'2018-08-13',NULL,NULL,NULL,1888334339,'1',NULL,0,'','0'),
(2824,NULL,'сапіщук марія',NULL,'2018-08-13',NULL,380961784088,NULL,1577976225,'1',NULL,0,'','0'),
(2825,NULL,'Гарчак Віка',NULL,'2018-08-13',NULL,380684781505,NULL,1773473577,'1',NULL,0,'','0'),
(2826,NULL,'Задорожна Наталя',NULL,'2018-08-14',NULL,380959489913,NULL,1478863270,'1',NULL,0,'','0'),
(2827,NULL,'Василевська Люба',NULL,'2018-08-14',NULL,380961876277,NULL,1782534466,'1',NULL,0,'','0'),
(2828,NULL,'Кучерук Люба',NULL,'2018-08-14',NULL,380980612706,NULL,1701286208,'1',NULL,0,'','0'),
(2829,NULL,'Мендик Алла',NULL,'2018-08-14',NULL,380962445197,NULL,1939709219,'1',NULL,0,'','0'),
(2830,NULL,'Федорець уляна',NULL,'2018-08-14',NULL,380976125860,NULL,1365561342,'1',NULL,0,'','0'),
(2831,NULL,'Смеречинська Зоряна',NULL,'2018-08-14',NULL,380987330513,NULL,1136755889,'1',NULL,0,'','0'),
(2832,NULL,'Черепюк Юля',NULL,'2018-08-15',NULL,380993230401,NULL,1835877396,'1',NULL,0,'','0'),
(2833,NULL,'Миколенко Люда',NULL,'2018-08-15',NULL,380937624790,NULL,1487829037,'1',NULL,0,'','0'),
(2834,NULL,'король іра',NULL,'2018-08-15',NULL,380977822775,NULL,1555707851,'1',NULL,0,'','0'),
(2835,NULL,'Стефаняк Марія',NULL,'2018-08-15',NULL,380673691389,NULL,2123510893,'1',NULL,0,'','0'),
(2836,NULL,'Тимус Оксана',NULL,'2018-08-16',NULL,380671328663,NULL,1831832746,'1',NULL,0,'','0'),
(2837,NULL,'Бойчук Галина',NULL,'2018-08-16',NULL,380975199316,NULL,1289060928,'1',NULL,0,'','0'),
(2838,NULL,'Пеликан Таня',NULL,'2018-08-16',NULL,380978671770,NULL,1977138364,'1',NULL,0,'','0'),
(2839,NULL,'Іваник Наталя',NULL,'2018-08-16',NULL,380963875830,NULL,1610467838,'1',NULL,0,'','0'),
(2840,NULL,'Максимчук Зоряна',NULL,'2018-08-16',NULL,380684212992,NULL,1903493455,'1',NULL,0,'','0'),
(2841,NULL,'Мостович Христина',NULL,'2018-08-16',NULL,380682464578,NULL,1762132039,'1',NULL,0,'','0'),
(2842,NULL,'Галінауська Ірина',NULL,'2018-08-16',NULL,380989799802,NULL,1299279218,'1',NULL,0,'','0'),
(2843,0535,'Дражньовська іванка',NULL,NULL,'sc6AsSZE/eHOJU6WCCPrOw==',380963007701,NULL,1671124551,'1',NULL,0,'','0'),
(2844,NULL,'Мартинюк Таня',NULL,'2018-08-17',NULL,380506950823,NULL,1849373029,'1',NULL,0,'','0'),
(2845,NULL,'Ляхович Марія',NULL,'2018-08-17',NULL,380961585748,NULL,1348587540,'1',NULL,0,'','0'),
(2846,NULL,'Осадчук Наталя',NULL,NULL,NULL,380974038869,NULL,2107732903,'1',NULL,1,'','0'),
(2847,NULL,'війтишин галина',NULL,'2018-08-18',NULL,380989256408,NULL,1547090414,'1',NULL,0,'','0'),
(2848,NULL,'Мосанюк тетяна',NULL,'2018-08-18',NULL,380973389922,NULL,1276039675,'1',NULL,0,'','0'),
(2849,NULL,'Сокальська Олеся',NULL,NULL,NULL,380984686405,NULL,1890905858,'1',NULL,0,'','0'),
(2850,NULL,'Сапіщук Світлана ',NULL,'2018-08-20',NULL,380671265199,NULL,1601162101,'1',NULL,0,'','0'),
(2851,NULL,'Бодьо марта',NULL,'2018-08-20',NULL,380971594157,NULL,1721053300,'1',NULL,0,'','0'),
(2852,NULL,'воробець діана',NULL,NULL,NULL,380680499439,NULL,1685559733,'1',42726,0,'','0'),
(2853,NULL,'Шептицька Анна',NULL,'2018-08-20',NULL,380964778205,NULL,1530042614,'1',NULL,0,'','0'),
(2854,NULL,'лахман яна',NULL,'2018-08-20',NULL,380983231980,NULL,1309611153,'1',NULL,0,'','0'),
(2855,NULL,'Новіков мирослава',NULL,'2018-08-20',NULL,380959328874,NULL,1239284901,'1',NULL,0,'','0'),
(2856,NULL,'Ковач Ангеліна',NULL,'2018-08-20',NULL,380934873198,NULL,1782748562,'1',NULL,0,'','0'),
(2857,NULL,'Кенес Андріана',NULL,'2018-08-21',NULL,380680306639,NULL,1713027180,'1',NULL,0,'','0'),
(2858,NULL,'ющак віка',NULL,'2018-08-21',NULL,380970532580,NULL,1770559997,'1',NULL,0,'','0'),
(2859,NULL,'христина марущак',NULL,'2018-08-21',NULL,380685251096,NULL,1529475161,'1',NULL,0,'','0'),
(2860,NULL,'Божегора олеся',NULL,'2018-08-22',NULL,380666544726,NULL,1907017825,'1',NULL,0,'','0'),
(2861,NULL,'Бабійчук Лілія',NULL,'2018-08-22',NULL,380980529323,NULL,2067921803,'1',NULL,0,'','0'),
(2862,NULL,'Слюсарчук Олександра ',NULL,'2018-08-22',NULL,380961447973,NULL,1472851147,'1',NULL,0,'','0'),
(2863,NULL,'Солодка Ліля',NULL,'2018-08-22',NULL,380508533203,NULL,1864901624,'1',NULL,0,'','0'),
(2864,NULL,'Полева Христина',NULL,'2018-08-22',NULL,380680349342,NULL,1186841756,'1',NULL,0,'','0'),
(2865,NULL,'Чабан Наталя',NULL,'2018-08-22',NULL,380992547976,NULL,1209244430,'1',NULL,0,'','0'),
(2866,NULL,'Адам люда',NULL,'2018-08-22',NULL,380973448961,NULL,1927964510,'1',NULL,0,'','0'),
(2867,NULL,'Полива марія',NULL,'2018-08-22',NULL,380964149271,NULL,1439230087,'1',NULL,0,'','0'),
(2868,NULL,'Голембйовська світлана',NULL,NULL,NULL,380962287372,NULL,1558981020,'1',NULL,0,'','0'),
(2869,NULL,'Соробей Леся',NULL,'2018-08-22',NULL,380680111606,NULL,1728984730,'1',NULL,0,'','0'),
(2870,NULL,'Свистун Інна',NULL,'2018-08-22',NULL,380962486775,NULL,1636546427,'1',NULL,0,'','0'),
(2871,NULL,'Попиль Марія',NULL,'2018-08-23',NULL,380684296482,NULL,1627146384,'1',NULL,0,'','0'),
(2872,NULL,'Бойчук Роксолана',NULL,NULL,NULL,NULL,NULL,1528349758,'1',NULL,0,'','1'),
(2873,NULL,'Бойчук Роксолана',NULL,NULL,NULL,NULL,NULL,1499898279,'1',NULL,0,'','1'),
(2874,NULL,'Кукула Леся',NULL,'2018-08-23',NULL,380978115693,NULL,1769834281,'1',NULL,0,'','0'),
(2875,NULL,'Клопіт Світлана',NULL,'2018-08-23',NULL,380961782194,NULL,1690608968,'1',NULL,0,'','0'),
(2876,NULL,'Нагірна Оля',NULL,'2018-08-23',NULL,380978716452,NULL,1651269403,'1',NULL,0,'','0'),
(2877,NULL,'Федишин Іванна',NULL,'2018-08-23',NULL,380988251181,NULL,1508557766,'1',NULL,0,'','0'),
(2878,NULL,'Вовк Юлія',NULL,'2018-08-24',NULL,380983227724,NULL,1962324474,'1',NULL,0,'','0'),
(2879,NULL,'Дерій Оля',NULL,'2018-08-24',NULL,380982903211,NULL,1604025513,'1',NULL,0,'','0'),
(2880,NULL,'Легка Аліна',NULL,'2018-08-24',NULL,380688633763,NULL,1831494361,'1',NULL,0,'','0'),
(2881,NULL,'Орлик Софія',NULL,'2018-08-24',NULL,NULL,NULL,2062887061,'1',NULL,0,'','0'),
(2882,NULL,'Орлик Софія',NULL,'2018-08-24',NULL,NULL,NULL,1519976154,'1',NULL,0,'','0'),
(2883,NULL,'Орлик Софія',NULL,'2018-08-24',NULL,NULL,NULL,1435088155,'1',NULL,0,'','0'),
(2884,NULL,'Орлик Софія',NULL,'2018-08-24',NULL,NULL,NULL,1571901098,'1',NULL,0,'','0'),
(2885,NULL,'Орлик Софія',NULL,'2018-08-24',NULL,NULL,NULL,1713023705,'1',NULL,0,'','0'),
(2886,NULL,'Орлик Софія',NULL,'2018-08-24',NULL,NULL,NULL,2112237324,'1',NULL,0,'','0'),
(2887,NULL,'Орлик Софія',NULL,'2018-08-24',NULL,NULL,NULL,1985558165,'1',NULL,0,'','0'),
(2888,NULL,'Орлик Софія',NULL,'2018-08-24',NULL,NULL,NULL,1405070420,'1',NULL,0,'','0'),
(2889,NULL,'Лесняк Юля',NULL,'2018-08-25',NULL,380683356157,NULL,1877050404,'1',NULL,0,'','0'),
(2890,NULL,'Курій Люда',NULL,'2018-08-25',NULL,380995610031,NULL,1132233088,'1',NULL,0,'','0'),
(2891,NULL,'Томашевська Наталя',NULL,'2018-08-25',NULL,380966938386,NULL,2047630747,'1',NULL,0,'','0'),
(2892,NULL,'Соробей діана',NULL,'2018-08-25',NULL,380986349105,NULL,1698908495,'1',NULL,0,'','0'),
(2893,NULL,'Стасишини Інна',NULL,'2018-08-25',NULL,380977825243,NULL,2027262713,'1',NULL,0,'','0'),
(2894,NULL,'Снігур Іра',NULL,'2018-08-25',NULL,380975838580,NULL,1494909099,'1',NULL,0,'','0'),
(2895,NULL,'Василевська Діана',NULL,NULL,NULL,380982329865,NULL,1955015323,'1',NULL,0,'','0'),
(2896,NULL,'ковальчук галя',NULL,'2018-08-25',NULL,380992570763,NULL,1517600260,'1',NULL,0,'','0'),
(2897,NULL,'крупська христина',NULL,'2018-08-25',NULL,380684297314,NULL,1379721476,'1',NULL,0,'','0'),
(2898,NULL,'Кирковська юля',NULL,'2018-08-27',NULL,380661637107,NULL,1374732597,'1',NULL,0,'','0'),
(2899,NULL,'Семенюк Наталя',NULL,'2018-08-27',NULL,380977481397,NULL,1135892720,'1',NULL,0,'','0'),
(2900,NULL,'Дрицько Діана',NULL,'2018-08-27',NULL,NULL,NULL,1294961213,'1',NULL,0,'','0'),
(2901,NULL,'Дорожинська Христина',NULL,'2018-08-27',NULL,380971680879,NULL,1813528127,'1',NULL,0,'','0'),
(2902,NULL,'Андрієвська Таня',NULL,'2018-08-27',NULL,NULL,NULL,1567794178,'1',NULL,0,'','0'),
(2903,NULL,'Андрієвська Таня',NULL,'2018-08-27',NULL,NULL,NULL,2032062584,'1',NULL,0,'','0'),
(2904,NULL,'Багрій Надія',NULL,'2018-08-27',NULL,380976587551,NULL,1969394076,'1',59629,0,'','0'),
(2905,NULL,'Рокуш Оля',NULL,NULL,NULL,380684247900,NULL,1969194159,'1',NULL,0,'','0'),
(2906,NULL,'Гапяк Олександра',NULL,'2018-08-28',NULL,380969091539,NULL,1871894867,'1',NULL,0,'','0'),
(2907,NULL,'Петрочко Маряна',NULL,'2018-08-28',NULL,380988194141,NULL,1744682946,'1',NULL,0,'','0'),
(2908,NULL,'Іванин Діана',NULL,'2018-08-29',NULL,380960150102,NULL,1152351400,'1',NULL,0,'','0'),
(2909,NULL,'Гребенчук Таня',NULL,'2018-08-29',NULL,380972561793,NULL,1888915520,'1',NULL,0,'','0'),
(2910,NULL,'Павельчук Люба',NULL,'2018-08-29',NULL,380966265430,NULL,1399760443,'1',NULL,0,'','0'),
(2911,NULL,'Нога Оксана',NULL,'2018-08-29',NULL,380980756402,NULL,1773252157,'1',NULL,0,'','0'),
(2912,NULL,'Гавадюк Світлана',NULL,NULL,NULL,380679015507,NULL,1434428794,'1',NULL,0,'','0'),
(2913,NULL,'Доскочинська Марія',NULL,'2018-08-29',NULL,380978340664,NULL,1400774927,'1',NULL,0,'','0'),
(2914,NULL,'Доскочинська Марія',NULL,'2018-08-29',NULL,380683365030,NULL,2073008308,'1',12583,0,'','0'),
(2915,NULL,'Нера Оля',NULL,'2018-08-29',NULL,380978971861,NULL,1137501342,'1',NULL,0,'','0'),
(2916,NULL,'Духніцька Маряна',NULL,'2018-08-29',NULL,380958466659,NULL,2032110349,'1',NULL,0,'','0'),
(2917,NULL,'Василюк Оксана',NULL,'2018-08-29',NULL,380973938678,NULL,1425577007,'1',NULL,0,'','0'),
(2918,NULL,'Попитак Оксана',NULL,NULL,'U3N4FiFgPKula1TlMDTm0g==',380689618076,NULL,1410940235,'1',62094,2,'','0'),
(2919,NULL,'Золотоцька Ангеліна',NULL,'2018-08-30',NULL,380961094334,NULL,1806855258,'1',NULL,0,'','0'),
(2920,NULL,'Шульська Таня',NULL,'2018-08-30',NULL,380682706420,NULL,1917481174,'1',NULL,0,'','0'),
(2921,NULL,'Любачевська Алла',NULL,NULL,NULL,380680409662,NULL,1172622547,'1',NULL,0,'','0'),
(2922,NULL,'Танасій таня',NULL,'2018-08-30',NULL,380966674553,NULL,1302201815,'1',NULL,0,'','0'),
(2923,NULL,'Гранатова Кароліна',NULL,NULL,NULL,380684231602,NULL,1448068312,'1',NULL,0,'','0'),
(2924,NULL,'кернега аліна',NULL,'2018-08-30',NULL,380666966119,NULL,2093011270,'1',NULL,0,'','0'),
(2925,NULL,'карамишаева Ольга',NULL,'2018-08-30',NULL,380984480203,NULL,2117496862,'1',NULL,0,'','0'),
(2926,NULL,'Миськів Леся',NULL,NULL,NULL,NULL,380969962927,1470013462,'1',NULL,0,'','0'),
(2927,NULL,'Бунікевич Іра',NULL,NULL,'XXSn/oBM9qan8Afs1HztLA==',380950141893,NULL,2134387220,'1',55904,0,'','0'),
(2928,NULL,'Криницька оксана',NULL,'2018-09-01',NULL,380983345440,NULL,1701422800,'1',NULL,0,'','0'),
(2929,NULL,'Дроздяк Марія',NULL,'2018-09-03',NULL,380978844268,NULL,1184932288,'1',NULL,0,'','0'),
(2930,NULL,'Музика Ліля',NULL,'2018-09-03',NULL,380980002157,NULL,1851615235,'1',NULL,0,'','0'),
(2931,NULL,'Яремчук Оля',NULL,'2018-09-03','VyyYsb6ytTek5eXNo/Pq4w==',380964511567,NULL,1973133166,'1',NULL,0,'','0'),
(2932,NULL,'Шуфліта Леся',NULL,'2018-09-03',NULL,380671291251,NULL,2096872562,'1',NULL,0,'','0'),
(2933,NULL,'Грабова Оксана',NULL,'2018-09-03',NULL,380677433085,NULL,2075252682,'1',NULL,0,'','0'),
(2934,NULL,'Маціборко Іванна',NULL,'2018-09-05',NULL,380672833919,NULL,1345741484,'1',NULL,0,'','0'),
(2935,NULL,'Грабець Олена',NULL,'2018-09-05',NULL,380983229721,NULL,1706458464,'1',NULL,0,'','0'),
(2936,NULL,'Жураківська Іванна',NULL,'2018-09-05',NULL,380687911465,NULL,1575802783,'1',NULL,0,'','0'),
(2937,NULL,'седляш вікторія',NULL,'2018-09-05',NULL,380688467280,NULL,1262821958,'1',NULL,0,'','0'),
(2938,NULL,'Гураль Віка',NULL,'2018-09-05',NULL,380984711941,NULL,1411418244,'1',60224,0,'','0'),
(2939,NULL,'Гира Наталя',NULL,'2018-09-05',NULL,380673966461,NULL,2029823158,'1',NULL,0,'','0'),
(2940,NULL,'Лукянська Оксана',NULL,'2018-09-05',NULL,380974582741,NULL,1700933049,'1',NULL,0,'','0'),
(2941,NULL,'Антонюк Юля',NULL,'2018-09-05',NULL,380973113758,NULL,1410537296,'1',NULL,0,'','0'),
(2942,NULL,'Починок Таня',NULL,'2018-09-06',NULL,380973655438,NULL,1742133198,'1',NULL,0,'','0'),
(2943,NULL,'Турчак Віта',NULL,'2018-09-06',NULL,380997416888,NULL,1970972884,'1',NULL,0,'','0'),
(2944,NULL,'Жураська Іванна',NULL,'2018-09-06',NULL,380982924246,NULL,1881355294,'1',NULL,0,'','0'),
(2945,NULL,'Табачак Микола',NULL,'2018-09-06',NULL,380962762131,NULL,2026440754,'1',NULL,0,'','0'),
(2946,NULL,'Грубенюк Таня',NULL,'2018-09-06',NULL,380683578073,NULL,1310996046,'1',NULL,0,'','0'),
(2947,NULL,'Лучко Люба',NULL,'2018-09-06',NULL,380683224420,NULL,1313315436,'1',NULL,0,'','0'),
(2948,NULL,'добощук марія',NULL,'2018-09-07',NULL,380976202392,NULL,1734182606,'1',NULL,1,'','0'),
(2949,NULL,'Шепцова Інна',NULL,'2018-09-07',NULL,380972802141,NULL,2064440731,'1',NULL,0,'','0'),
(2950,NULL,'Коваль Люда',NULL,NULL,NULL,380980184519,NULL,2046839226,'1',NULL,0,'','0'),
(2951,NULL,'Скопик Наталя',NULL,'2018-09-07',NULL,380686017446,NULL,1178322059,'1',NULL,0,'','0'),
(2952,NULL,'Вітів Галина',NULL,'2018-09-07',NULL,380689342958,NULL,1458782144,'1',NULL,0,'','0'),
(2953,NULL,'лапінська іванка',NULL,'2018-09-07',NULL,380988623403,NULL,1447848603,'1',NULL,0,'','0'),
(2954,NULL,'Золота наталя',NULL,'2018-09-08',NULL,380987367561,NULL,1112289433,'1',NULL,0,'','0'),
(2955,NULL,'заплацінська таня',NULL,'2018-09-08',NULL,380684236409,NULL,1881315152,'1',NULL,0,'','0'),
(2956,NULL,'Козак Ліда',NULL,'2018-09-08',NULL,380509748529,NULL,1120528962,'1',NULL,0,'','0'),
(2957,NULL,'Тихоліз Андріана',NULL,'2018-09-08',NULL,380680447768,NULL,1946637403,'1',NULL,0,'','0'),
(2958,NULL,'Суха Оксана',NULL,'2018-09-08',NULL,380975494933,NULL,1773252961,'1',49679,0,'','0'),
(2959,NULL,'Федорків ІВанна',NULL,'2018-09-10',NULL,380685121094,NULL,1796871644,'1',NULL,0,'','0'),
(2960,NULL,'марчук наталя',NULL,'2018-09-10',NULL,380989922759,NULL,2106060542,'1',NULL,0,'','0'),
(2961,NULL,'Сорокопуд марія',NULL,'2018-09-10',NULL,380988120081,NULL,1744054228,'1',NULL,0,'','0'),
(2962,NULL,'Антків Віра',NULL,NULL,NULL,380676926340,NULL,1140603824,'1',NULL,0,'','0'),
(2963,NULL,'Чайка Соломія',NULL,'2018-09-10',NULL,380986502168,NULL,1194294225,'1',NULL,0,'','0'),
(2964,NULL,'Ковальчик Галина',NULL,'2018-09-11',NULL,380973895197,NULL,1433791743,'1',NULL,0,'','0'),
(2965,NULL,'Федорків Таня',NULL,'2018-09-11',NULL,380993466434,NULL,1554948551,'1',NULL,0,'','0'),
(2966,NULL,'Сокальська Андріана',NULL,'2018-09-12',NULL,380675885384,NULL,2064710035,'1',NULL,0,'','0'),
(2967,NULL,'катинська любов',NULL,'2018-09-12',NULL,380970753414,NULL,2013986686,'1',NULL,0,'','0'),
(2968,NULL,'Зигрій Ольга',NULL,'2018-09-12',NULL,380974329705,NULL,1888461453,'1',NULL,0,'','0'),
(2969,NULL,'Зигрій ',NULL,'2018-09-12',NULL,NULL,NULL,1810200647,'1',NULL,0,'','0'),
(2970,NULL,'Кінаш Таня',NULL,NULL,'Im8KCz0/zDwV2vvMVMJLDA==',380974704351,NULL,1869993792,'1',37768,1,'','0'),
(2971,NULL,'Довгань Володимир',NULL,'2018-09-13',NULL,380969591778,NULL,1803797944,'1',NULL,0,'','0'),
(3600,0248,'Михайлюк Оксана',NULL,NULL,NULL,380979363652,NULL,1828855744,'1',NULL,0,'','0'),
(2972,NULL,'Фірман Юля',NULL,'2018-09-13',NULL,380973125768,NULL,1219717539,'1',NULL,0,'','0'),
(2973,NULL,'Крамар Наталя',NULL,'2018-09-13',NULL,380977142801,NULL,1517581031,'1',NULL,0,'','0'),
(2974,NULL,'Стадник віка',NULL,'2018-09-14',NULL,380980913854,NULL,1422591678,'1',NULL,1,'','0'),
(2975,NULL,'Микитин Надія',NULL,'2018-09-14',NULL,380977714903,NULL,1298983382,'1',NULL,0,'','0'),
(2976,NULL,'Василик Леся',NULL,'2018-09-14',NULL,380970553962,NULL,1387936119,'1',NULL,0,'','0'),
(2977,NULL,'попова галина',NULL,'2018-09-14',NULL,380673518428,NULL,1116343841,'1',NULL,0,'','0'),
(2978,NULL,'Погорецька Галина',NULL,'2018-09-15',NULL,380960270019,NULL,1278121268,'1',NULL,0,'','0'),
(2979,NULL,'Курій Олег',NULL,'2018-09-15',NULL,380979809284,NULL,1438723375,'1',NULL,0,'','0'),
(2980,NULL,'Касіян зоряна',NULL,'2018-09-17',NULL,380980612958,NULL,1891505624,'1',NULL,0,'','0'),
(2981,NULL,'Бідяк віка',NULL,'2018-09-17',NULL,380970632305,NULL,1798191513,'1',NULL,0,'','0'),
(2982,NULL,'Ляхоцька Віра',NULL,'2018-09-17',NULL,380984138328,NULL,1953428080,'1',NULL,0,'','0'),
(2983,NULL,'Звір Оксана',NULL,NULL,NULL,380970207726,NULL,1984093333,'1',NULL,1,'','0'),
(2984,NULL,'Світлана Королик',NULL,'2018-09-17',NULL,380977073689,NULL,1399430913,'1',NULL,0,'','0'),
(2985,NULL,'Коростіль христя',NULL,'2018-09-17',NULL,380989446211,NULL,1436162838,'1',NULL,0,'','0'),
(2986,NULL,'Бєга світлана',NULL,NULL,NULL,380986635197,NULL,1260752891,'1',NULL,0,'','0'),
(2987,NULL,'Содляк Олеся',NULL,'2018-09-17',NULL,380974159572,NULL,2135589961,'1',NULL,0,'','0'),
(2988,NULL,'Лівіцька аліна',NULL,'2018-09-17',NULL,380675944976,NULL,1152984048,'1',NULL,0,'','0'),
(2989,NULL,'Щесиніна Діана',NULL,'2018-09-17',NULL,380983806673,NULL,1152672799,'1',NULL,0,'','0'),
(2990,NULL,'Маковійчук Оля',NULL,'2018-09-18',NULL,380688461325,NULL,1361081472,'1',NULL,0,'','0'),
(2991,NULL,'Маковійчук Христя',NULL,'2018-09-18',NULL,380977798946,NULL,1385865161,'1',NULL,0,'','0'),
(2992,NULL,'Підручна Таня',NULL,'2018-09-18',NULL,380967557579,NULL,1884744687,'1',NULL,0,'','0'),
(2993,NULL,'Федорів Оля',NULL,'2018-09-18',NULL,380974535378,NULL,1367010331,'1',NULL,0,'','0'),
(2994,NULL,'Скора Іванна',NULL,NULL,NULL,380967624895,NULL,1186711042,'1',NULL,0,'','0'),
(2995,NULL,'Гульчак Світлана',NULL,'2018-09-18','UbKnpmiG4bA3cvUbeD0vvQ==',380974212158,NULL,2135895961,'1',NULL,1,'','0'),
(2996,NULL,'Пушкаренко Юля',NULL,'2018-09-18',NULL,380974688911,NULL,1427299321,'1',23358,1,'','0'),
(2997,NULL,'Сінченко Таня',NULL,'2018-09-18',NULL,380673657480,NULL,1685530347,'1',NULL,0,'','0'),
(2998,NULL,'Лазарчук надя',NULL,'2018-09-20',NULL,380502098850,NULL,1202984861,'1',NULL,0,'','0'),
(2999,NULL,'Колодніцька Марія',NULL,'2018-09-20',NULL,380681377389,NULL,1128436500,'1',NULL,0,'','0');

INSERT INTO `kontragentu` VALUES 
(3000,NULL,'Васильчук Юля',NULL,'2018-09-20',NULL,380686460288,NULL,2051388117,'1',NULL,0,'','0'),
(3001,NULL,'Кінах Марія',NULL,'2018-09-20',NULL,380987821439,NULL,2141611207,'1',NULL,0,'','0'),
(3002,NULL,'Мерлавська Оксана',NULL,'2018-09-20',NULL,380971316224,NULL,1278877519,'1',NULL,0,'','0'),
(3003,NULL,'Довгань микола',NULL,'2018-09-21',NULL,380682443920,NULL,1936920693,'1',NULL,0,'','0'),
(3004,NULL,'Гарасимик Юля',NULL,'2018-09-21',NULL,380974464795,NULL,1562554436,'1',NULL,0,'','0'),
(3005,NULL,'Герасимів Наталя',NULL,'2018-09-22',NULL,380679920284,NULL,1148895351,'1',NULL,0,'','0'),
(3006,NULL,'Штуник Софія',NULL,'2018-09-24',NULL,380682095206,NULL,1563881677,'1',NULL,0,'','0'),
(3007,NULL,'Захарків Світлана',NULL,'2018-09-24','qHYx/JTcxopgybXBOwgYqg==',380980611180,NULL,1856229635,'1',NULL,0,'','0'),
(3008,NULL,'Синюк Юля',NULL,'2018-09-24',NULL,380977259371,NULL,1162882608,'1',NULL,0,'','0'),
(3009,NULL,'Махніцька Зоряна',NULL,'2018-09-24',NULL,380989466138,NULL,1773574294,'1',NULL,0,'','0'),
(3010,NULL,'Чугаєвська Галина',NULL,'2018-09-25',NULL,380962723349,NULL,1350756246,'1',NULL,0,'','0'),
(3011,NULL,'Стріла Наталя',NULL,'2018-09-25',NULL,380968826252,NULL,1875011018,'1',NULL,0,'','0'),
(3012,NULL,'Свистун Алла',NULL,'2018-09-25',NULL,380688598509,NULL,1647758357,'1',NULL,0,'','0'),
(3013,NULL,'Криворучко Юля',NULL,'2018-09-25',NULL,380986475605,NULL,1619779912,'1',NULL,0,'','0'),
(3014,NULL,'Тилькавашвілі Манана',NULL,'2018-09-25',NULL,380676272841,NULL,1173849652,'1',NULL,0,'','0'),
(3015,NULL,'Ващишин Оксана',NULL,'2018-09-25',NULL,380680549191,NULL,1435381632,'1',NULL,0,'','0'),
(3016,NULL,'Рогатинська Таня',NULL,'2018-09-26',NULL,380988650607,NULL,2133353567,'1',NULL,0,'','0'),
(3017,NULL,'Кривецька Маряна',NULL,'2018-09-26',NULL,380966221106,NULL,1981097799,'1',NULL,0,'','0'),
(3018,NULL,'Шафирович Марія',NULL,'2018-09-26',NULL,380680212834,NULL,1904106197,'1',NULL,0,'','0'),
(3019,NULL,'Грубенк Христя',NULL,'2018-09-26',NULL,380958759920,NULL,1506380962,'1',NULL,0,'','0'),
(3020,NULL,'Незивець Таня',NULL,'2018-09-26',NULL,380978185420,NULL,1734495419,'1',NULL,0,'','0'),
(3021,NULL,'Григорій Марія',NULL,'2018-09-27',NULL,380964903975,NULL,1771718133,'1',NULL,0,'','0'),
(3022,NULL,'подолянська марія',NULL,'2018-09-27',NULL,380989740802,NULL,2073536382,'1',NULL,0,'','0'),
(3023,NULL,'Пижик Уляна',NULL,'2018-09-27',NULL,380970792066,NULL,1216550485,'1',NULL,0,'','0'),
(3024,NULL,'Денега Христина',NULL,'2018-09-27',NULL,380688391406,NULL,1916442343,'1',NULL,0,'','0'),
(3025,NULL,'Романюк Зіна',NULL,NULL,NULL,380682263702,NULL,1978330879,'1',NULL,0,'','0'),
(3026,NULL,'Харюк галина',NULL,'2018-09-28',NULL,380671101216,NULL,1453601569,'1',NULL,0,'','0'),
(3027,NULL,'Петришин Ліля',NULL,'2018-09-28',NULL,380509440623,NULL,1213899319,'1',NULL,0,'','0'),
(3028,NULL,'Гевко Христина',NULL,'2018-09-29',NULL,380960534006,NULL,1436581658,'1',NULL,0,'','0'),
(3029,NULL,'Джуглей наталя',NULL,'2018-09-29',NULL,380978975561,NULL,2133258044,'1',NULL,0,'','0'),
(3030,NULL,'Савіцка Руслана',NULL,'2018-09-29',NULL,380986391163,NULL,1590292838,'1',NULL,0,'','0'),
(3031,NULL,'Винничин Леся',NULL,'2018-09-29',NULL,380665778542,NULL,1408646551,'1',NULL,0,'','0'),
(3032,NULL,'Паладійчук Олександра',NULL,'2018-09-29',NULL,380683665718,NULL,1479755506,'1',NULL,0,'','0'),
(3033,NULL,'Цепенда Марія',NULL,'2018-10-01',NULL,380675015197,NULL,2041806467,'1',NULL,0,'','0'),
(3034,0599,'Рогатин ангеліна',NULL,NULL,NULL,380678804325,NULL,1885542710,'1',NULL,0,'','0'),
(3035,NULL,'Зімбіцька Маряна',NULL,'2018-10-01',NULL,380980561779,NULL,1835797271,'1',NULL,0,'','0'),
(3036,NULL,'Боцян Таня',NULL,'2018-10-01',NULL,380683410052,NULL,2107351720,'1',61109,0,'','0'),
(3037,NULL,'Луньова таня',NULL,'2018-10-01',NULL,380674306896,NULL,1720393257,'1',NULL,0,'','0'),
(3038,NULL,'Дідик Анастасія',NULL,NULL,NULL,380995090190,NULL,1129838500,'1',NULL,0,'','0'),
(3039,NULL,'Старик Галя',NULL,NULL,NULL,380683264565,NULL,1532750272,'1',NULL,0,'','0'),
(3040,NULL,'галя петльована',NULL,NULL,NULL,380980062678,NULL,1855808601,'',54088,0,'','0'),
(3041,NULL,'Сідляк Оксана',NULL,'2018-10-02',NULL,380989951181,NULL,1900718386,'1',NULL,0,'','0'),
(3042,NULL,'Назар Галина',NULL,'2018-10-03',NULL,380967449203,NULL,1317991267,'1',NULL,0,'','0'),
(3043,NULL,'Макіяк Надія',NULL,'2018-10-03','CtJp8Nwr00mL80mNv3mL6w==',380986484746,NULL,1990746411,'1',NULL,0,'','0'),
(3044,NULL,'Мельник Оля ',NULL,NULL,NULL,380967246247,NULL,1656694506,'1',NULL,0,'','0'),
(3045,NULL,'Польник Наталя',NULL,'2018-10-03',NULL,380986811351,NULL,1684976193,'1',NULL,0,'','0'),
(3046,NULL,'Гриців Олена',NULL,'2018-10-04',NULL,380971483260,NULL,1445200326,'1',NULL,0,'','0'),
(3047,NULL,'Маковишин Юля',NULL,'2018-10-04',NULL,380660925733,NULL,1474755438,'1',NULL,0,'','0'),
(3048,NULL,'Загорняк Таня',NULL,'2018-10-05',NULL,380959348948,NULL,1216608664,'1',NULL,0,'','0'),
(3049,NULL,'Попіль Світлана',NULL,'2018-10-05',NULL,380977618868,NULL,2043168527,'1',NULL,0,'','0'),
(3050,NULL,'даньо оксана',NULL,'2018-10-05',NULL,380975837376,NULL,1233429225,'1',NULL,0,'','0'),
(3051,NULL,'дуриш таня',NULL,'2018-10-05',NULL,380978120964,NULL,2090192281,'1',NULL,0,'','0'),
(3052,NULL,'Чорненька настя',NULL,'2018-10-05',NULL,380665337217,NULL,1375606291,'1',NULL,0,'','0'),
(3053,NULL,'Яремова олеся',NULL,'2018-10-05',NULL,380978651235,NULL,1552321171,'1',NULL,0,'','0'),
(3054,NULL,'орлова ліля ',NULL,'2018-10-05',NULL,380689353391,NULL,1874461499,'1',NULL,2,'','0'),
(3055,NULL,'Чикаловська Надя',NULL,'2018-10-05',NULL,380988057622,NULL,1702862673,'1',NULL,0,'','0'),
(3056,NULL,'Золота Наталя',NULL,'2018-10-05',NULL,380686190515,NULL,1994986953,'1',NULL,0,'','0'),
(3057,NULL,'стукало оксана',NULL,'2018-10-06',NULL,380979340788,NULL,1496818032,'1',NULL,0,'','0'),
(3058,NULL,'Бойчук Таня',NULL,'2018-10-06',NULL,380688386952,NULL,1593111179,'1',NULL,0,'','0'),
(3059,NULL,'Лоїк Андріана',NULL,'2018-10-06',NULL,380507315331,NULL,1133027391,'1',NULL,0,'','0'),
(3060,NULL,'Фундитус Зоряна',NULL,NULL,NULL,380673516820,NULL,1132667669,'1',NULL,1,'','0'),
(3061,NULL,'Гончарук Настя',NULL,'2018-10-08',NULL,380733077612,NULL,1198347012,'1',NULL,0,'','0'),
(3062,NULL,'Тивоняк Маряна',NULL,'2018-10-08',NULL,380984502189,NULL,1527375041,'1',NULL,0,'','0'),
(3063,NULL,'Опацька Оксана',NULL,'2018-10-08',NULL,380675959385,NULL,1973114975,'1',NULL,0,'','0'),
(3064,NULL,'Дерій Саша',NULL,'2018-10-08',NULL,380730834075,NULL,1452759452,'1',NULL,0,'','0'),
(3065,NULL,'Мандзяк Володимир',NULL,'2018-10-08',NULL,380977003288,NULL,1911064079,'1',NULL,0,'','0'),
(3066,NULL,'Паньків Настя',NULL,'2018-10-08',NULL,380976114569,NULL,1866368230,'1',NULL,0,'','0'),
(3067,NULL,'Галюк Оля',NULL,'2018-10-09',NULL,380964211832,NULL,1998826279,'1',NULL,0,'','0'),
(3068,NULL,'Сторожук Оксана',NULL,'2018-10-09',NULL,380977008958,NULL,2013245197,'1',NULL,0,'','0'),
(3069,NULL,'Куніцька Юля',NULL,'2018-10-09',NULL,380974280693,NULL,1716158136,'1',NULL,0,'','0'),
(3070,NULL,'Селядницька Оксана',NULL,'2018-10-10',NULL,380675172547,NULL,1632371280,'1',NULL,0,'','0'),
(3071,NULL,'Новицька Марія',NULL,'2018-10-10',NULL,380971041582,NULL,1610156231,'1',NULL,0,'','0'),
(3072,NULL,'Підперигора Наталя',NULL,'2018-10-10',NULL,380686469162,NULL,1914282992,'1',NULL,0,'','0'),
(3073,NULL,'Лукяніхіна Оксана',NULL,'2018-10-10',NULL,380973150449,NULL,1141691777,'1',NULL,0,'','0'),
(3074,NULL,'Дмитрик Люда',NULL,'2018-10-10',NULL,380987275268,NULL,1945298228,'1',NULL,0,'','0'),
(3075,NULL,'Ландяк Оля',NULL,'2018-10-10',NULL,380977865043,NULL,1579319396,'1',NULL,0,'','0'),
(3076,NULL,'Хирівська Діана',NULL,'2018-10-10',NULL,380681419069,NULL,1420154237,'1',NULL,0,'','0'),
(3077,NULL,'Вівчарик Христя',NULL,'2018-10-11',NULL,380962289482,NULL,1322700729,'1',NULL,0,'','0'),
(3078,NULL,'Оганян Руслан',NULL,'2018-10-11',NULL,380631075124,NULL,1762035247,'1',NULL,0,'','0'),
(3079,NULL,'Боднар Стефанія',NULL,'2018-10-11',NULL,380956317899,NULL,2095289527,'1',NULL,0,'','0'),
(3080,NULL,'Ганін наталя',NULL,'2018-10-11',NULL,380979643177,NULL,1446454330,'1',NULL,0,'','0'),
(3081,NULL,'Павлінська Люда',NULL,'2018-10-11',NULL,380680326048,NULL,1801723668,'1',NULL,0,'','0'),
(3082,NULL,'Балабух Марія',NULL,'2018-10-12',NULL,380979924984,NULL,1322184648,'1',NULL,0,'','0'),
(3083,NULL,'Сібрак Уляна',NULL,'2018-10-12',NULL,380987417378,NULL,1805647596,'1',NULL,0,'','0'),
(3084,0250,'Навізівська Наталя',NULL,NULL,NULL,380972780318,NULL,1707750094,'1',NULL,0,'','0'),
(3085,NULL,'Паславська Оля',NULL,'2018-10-12',NULL,380972194425,NULL,1691057388,'1',NULL,0,'','0'),
(3086,NULL,'Сліпенька Люда',NULL,'2018-10-13',NULL,380661487593,NULL,1777782152,'1',NULL,0,'','0'),
(3087,NULL,'Табалін Марія',NULL,'2018-10-13',NULL,380975012479,NULL,1968850242,'1',NULL,0,'','0'),
(3088,NULL,'Тракало Христина',NULL,'2018-10-13',NULL,380971039476,NULL,1217083405,'1',45255,0,'','0'),
(3089,NULL,'Куца Наталя',NULL,'2018-10-15',NULL,380986674761,NULL,1517511231,'1',NULL,0,'','0'),
(3090,NULL,'Кравець Васелина',NULL,'2018-10-15',NULL,380961488459,NULL,1376582686,'1',NULL,0,'','0'),
(3091,NULL,'дідюк марія',NULL,'2018-10-15',NULL,380979436832,NULL,1596291869,'1',NULL,0,'','0'),
(3092,NULL,'Мендзер Таня',NULL,'2018-10-16',NULL,380665912520,NULL,2047004278,'1',NULL,0,'','0'),
(3093,NULL,'Дикун Ірина',NULL,'2018-10-16',NULL,380984861085,NULL,1894294609,'1',NULL,1,'','0'),
(3094,NULL,'Алєксєєва Віка',NULL,'2018-10-16',NULL,380992017016,NULL,1882513130,'1',NULL,0,'','0'),
(3095,NULL,'Сушельницька Оксана',NULL,'2018-10-16',NULL,380962660447,NULL,1117900419,'1',NULL,0,'','0'),
(3096,NULL,'Дишкант Настя',NULL,'2018-10-16',NULL,380963178767,NULL,2045486266,'1',NULL,0,'','0'),
(3097,NULL,'Боднарчук Оля',NULL,'2018-10-16',NULL,380964727064,NULL,1196603367,'1',NULL,0,'','0'),
(3098,NULL,'Мудра Ірина',NULL,'2018-10-16',NULL,380675859136,NULL,1572960020,'1',NULL,0,'','0'),
(3099,NULL,'Кушнір Марія',NULL,'2018-10-16',NULL,380687602101,NULL,1232588045,'1',NULL,0,'','0'),
(3100,NULL,'Гевко Оксана',NULL,'2018-10-16',NULL,380965006691,NULL,1944270892,'1',NULL,0,'','0'),
(3101,NULL,'Шевчук Галя',NULL,'2018-10-17',NULL,380976570211,NULL,2062718248,'1',NULL,0,'','0'),
(3102,NULL,'Цигумбаєва Зоряна',NULL,'2018-10-17',NULL,380977798839,NULL,2020528091,'1',NULL,0,'','0'),
(3103,NULL,'Гніданик Леся',NULL,NULL,NULL,380686497537,NULL,1487150055,'1',53282,0,'','0'),
(3104,NULL,'Дериш Іра',NULL,'2018-10-17',NULL,380985708567,NULL,1885361317,'1',NULL,0,'','0'),
(3105,NULL,'Ільїн Світлана',NULL,'2018-10-17',NULL,380980611164,NULL,1588682319,'1',NULL,0,'','0'),
(3106,NULL,'Сидорчук віка',NULL,'2018-10-17',NULL,380681611211,NULL,2002873497,'1',NULL,0,'','0'),
(3107,NULL,'Дмитрик людмила',NULL,'2018-10-18',NULL,380665753741,NULL,1170143542,'1',NULL,0,'','0'),
(3108,NULL,'Невасюк Ольга',NULL,'2018-10-19',NULL,380986514852,NULL,2083572136,'1',NULL,0,'','0'),
(3109,NULL,'Орлик таня',NULL,NULL,NULL,380971486825,NULL,1947723188,'1',NULL,0,'','0'),
(3110,0745,'Смоляк Наталя',NULL,NULL,NULL,380632969029,NULL,1709429008,'1',NULL,0,'','0'),
(3111,NULL,'Яцевич Галина',NULL,'2018-10-20',NULL,380969099589,NULL,1631723148,'1',NULL,0,'','0'),
(3112,NULL,'Величко Маша',NULL,'2018-10-22',NULL,380971532783,NULL,2032155352,'1',NULL,1,'','0'),
(3113,NULL,'Рудянин Оксана',NULL,'2018-10-22',NULL,380982230214,NULL,1728694041,'1',NULL,0,'','0'),
(3114,NULL,'Притула Іра',NULL,'2018-10-23',NULL,380674988298,NULL,1668313567,'1',NULL,0,'','0'),
(3115,NULL,'Козак Наталя',NULL,'2018-10-23',NULL,380680970392,NULL,1204990546,'1',60830,0,'','0'),
(3116,NULL,'Перців Оксана',NULL,'2018-10-23',NULL,380686260870,NULL,2070132442,'1',14344,0,'','0'),
(3117,NULL,'Шепета Таня',NULL,'2018-10-23',NULL,380980170087,NULL,1357522495,'1',NULL,0,'','0'),
(3118,NULL,'Винничин Леся',NULL,'2018-10-23',NULL,380666594859,NULL,2112569892,'1',NULL,0,'','0'),
(3119,NULL,'Бегман Леся',NULL,NULL,NULL,380987368284,NULL,1364621805,'1',NULL,0,'','0'),
(3120,NULL,'Саврук Іра',NULL,'2018-10-24',NULL,380980221129,NULL,1562481839,'1',NULL,0,'','0'),
(3121,NULL,'Гулька Таня',NULL,'2018-10-24',NULL,380968520954,NULL,1878285566,'1',NULL,0,'','0'),
(3122,NULL,'Фучкевич Світлана',NULL,NULL,NULL,380687661895,NULL,1524528530,'1',59012,0,'','0'),
(3123,NULL,'Оліярник Лариса',NULL,'2018-10-24',NULL,380972894533,NULL,1514635740,'1',NULL,0,'','0'),
(3124,NULL,'Бойчук Іра',NULL,'2018-10-25',NULL,380970376587,NULL,1951694009,'1',NULL,0,'','0'),
(3125,NULL,'Петришин Зоряна',NULL,'2018-10-25',NULL,380689386561,NULL,1494381001,'1',NULL,0,'','0'),
(3126,NULL,'Іваськів Софія',NULL,'2018-10-25',NULL,380971705437,NULL,1399246024,'1',NULL,0,'','0'),
(3127,NULL,'Гуменюк Юля',NULL,'2018-10-25',NULL,380964968727,NULL,1631258973,'1',NULL,0,'','0'),
(3128,NULL,'Чухрій Світлана',NULL,'2018-10-25','O2mM7OwXtvBugtQd6ojpiQ==',380639839175,NULL,1360815472,'1',NULL,0,'','0'),
(3129,NULL,'Касіян Таня',NULL,'2018-10-25',NULL,380980611837,NULL,1668376331,'1',NULL,0,'','0'),
(3130,NULL,'Поліщук Наталя',NULL,'2018-10-25',NULL,380987849433,NULL,1186633301,'1',NULL,0,'','0'),
(3131,NULL,'Хомут Оля',NULL,'2018-10-26',NULL,380672503567,NULL,1851465305,'1',NULL,0,'','0'),
(3132,NULL,'Шульська Діана',NULL,'2018-10-26',NULL,380966163543,NULL,1993239707,'1',NULL,0,'','0'),
(3133,NULL,'Божаковська таня',NULL,'2018-10-26',NULL,380931278448,NULL,1177206283,'1',NULL,0,'','0'),
(3134,NULL,'Присяжна Сніжана',NULL,'2018-10-27',NULL,380986502129,NULL,1898073839,'1',NULL,0,'','0'),
(3135,NULL,'Якубовська Наталя',NULL,'2018-10-27',NULL,380969953384,NULL,1457329165,'1',NULL,0,'','0'),
(3136,NULL,'Фесюк Ірина',NULL,'2018-10-28',NULL,380684167816,NULL,1517182998,'1',NULL,0,'','0'),
(3137,NULL,'Роздобудько Валерія',NULL,'2018-10-29',NULL,380953116359,NULL,2119374324,'1',NULL,0,'','0'),
(3138,NULL,'Погорецька Олена',NULL,'2018-10-29',NULL,380674061104,NULL,1432984181,'1',NULL,0,'','0'),
(3139,NULL,'Шуфрін Христина',NULL,'2018-10-29',NULL,380995279522,NULL,2110564232,'1',NULL,0,'','0'),
(3140,NULL,'Коник  Оля',NULL,NULL,NULL,380687006344,NULL,1396981998,'1',NULL,0,'','0'),
(3141,NULL,'Електрик',NULL,'2018-10-30',NULL,380503774149,NULL,1807819525,'1',NULL,0,'','0'),
(3142,NULL,'Король Наталя',NULL,'2018-10-30',NULL,380984490182,NULL,1434213300,'1',NULL,0,'','0'),
(3143,NULL,'Катинська Галя',NULL,'2018-10-30',NULL,380967172076,NULL,1474333403,'1',NULL,0,'','0'),
(3144,NULL,'Миронюк Андріана',NULL,'2018-10-31',NULL,380960696400,NULL,1585900083,'1',NULL,0,'','0'),
(3145,NULL,'Гевко Таня',NULL,NULL,NULL,380961928360,NULL,1365554536,'1',NULL,1,'','0'),
(3146,NULL,'Турчак Свєта',NULL,'2018-11-01',NULL,380684235386,NULL,1859257388,'1',NULL,0,'','0'),
(3147,NULL,'Прохоров Сергій',NULL,'2018-11-01',NULL,380984124896,NULL,1880444948,'1',NULL,0,'','0'),
(3148,NULL,'Мороз Оксана',NULL,'2018-11-02',NULL,380962605727,NULL,1422675534,'1',NULL,0,'','0'),
(3149,NULL,'Дмитровська Оля',NULL,'2018-11-02',NULL,380963921339,NULL,1259106969,'1',39404,0,'','0'),
(3150,NULL,'Гуцул Оксана',NULL,'2018-11-02',NULL,380680326047,NULL,1448372729,'1',NULL,0,'','0'),
(3151,NULL,'Олійник Галя',NULL,'2018-11-02',NULL,380677001423,NULL,1774604899,'1',NULL,0,'','0'),
(3152,NULL,'Костишак Сніжана',NULL,'2018-11-02',NULL,380681773748,NULL,1868495170,'1',NULL,0,'','0'),
(3153,NULL,'Сергієва Ірина',NULL,'2018-11-03',NULL,380500248084,NULL,1481503889,'1',NULL,2,'','0'),
(3154,NULL,'Семчишин Оля',NULL,'2018-11-03',NULL,380686395716,NULL,1394502033,'1',NULL,1,'','0'),
(3155,NULL,'Мимохід Зоряна',NULL,NULL,NULL,380969855898,NULL,2023503530,'1',NULL,0,'','0'),
(3156,NULL,'Завислюк Наталя',NULL,'2018-11-03',NULL,380971827754,NULL,1185175422,'1',NULL,0,'','0'),
(3157,NULL,'Кубова Вікторія',NULL,'2018-11-05',NULL,380985396933,NULL,1746135620,'1',NULL,0,'','0'),
(3158,NULL,'Підручна Олена',NULL,'2018-11-05',NULL,380967961015,NULL,1120366345,'1',NULL,0,'','0'),
(3159,NULL,'Баран Оля',NULL,NULL,'K4IfNQu+mCyUqg2/ZTYHEQ==',380982234456,NULL,1982387905,'1',57530,0,'','0'),
(3160,NULL,'Чайківська Даша',NULL,'2018-11-05',NULL,380973812781,NULL,1582067978,'1',NULL,1,'','0'),
(3161,NULL,'Довжик Наталя',NULL,'2018-11-05',NULL,380669863019,NULL,1811917311,'1',NULL,0,'','0'),
(3162,NULL,'Сапіщук Наталя',NULL,'2018-11-05',NULL,380988968331,NULL,2122809413,'1',NULL,1,'','0'),
(3163,NULL,'Полига Христина',NULL,'2018-11-05',NULL,380990324754,NULL,1989150689,'1',NULL,0,'','0'),
(3164,NULL,'Наконечна Таня',NULL,'2018-11-06',NULL,380979193995,NULL,1901576406,'1',NULL,0,'','0'),
(3165,NULL,'Батицька Оксана',NULL,'2018-11-06',NULL,380681611004,NULL,1762869653,'1',NULL,0,'','0'),
(3166,NULL,'Сідова Іра',NULL,'2018-11-06',NULL,380966301363,NULL,1888873998,'1',NULL,1,'','0'),
(3167,NULL,'Куник Оля',NULL,'2018-11-06',NULL,380668472087,NULL,1375417662,'1',NULL,0,'','0'),
(3168,NULL,'Дубчак Марія',NULL,'2018-11-06',NULL,380680204962,NULL,1724838157,'1',NULL,0,'','0'),
(3169,NULL,'Бобак Наталя',NULL,'2018-11-06',NULL,380687883643,NULL,1946829004,'1',NULL,0,'','0'),
(3170,NULL,'Реш Оксана',NULL,'2018-11-07',NULL,380982944474,NULL,1640508258,'1',NULL,0,'','0'),
(3171,NULL,'Сиротюк Маша',NULL,'2018-11-07',NULL,380975514195,NULL,2031177509,'1',NULL,0,'','0'),
(3172,NULL,'матвієва ольга',NULL,'2018-11-07',NULL,380982660387,NULL,2117879813,'1',NULL,0,'','0'),
(3173,NULL,'Березюк Таня',NULL,'2018-11-07',NULL,380972072152,NULL,2125403687,'1',NULL,0,'','0'),
(3174,NULL,'Крушельницька Андріана',NULL,'2018-11-07','tI0+MHXu3+ivAFjQKkCHsg==',380680967281,NULL,1426640244,'1',16986,1,'','0'),
(3175,NULL,'Стасюк Наталя',NULL,NULL,NULL,380680931187,NULL,1931338065,'1',26541,0,'','0'),
(3176,NULL,'куртяк марія',NULL,'2018-11-09',NULL,380966391417,NULL,1992149868,'1',NULL,0,'','0'),
(3177,NULL,'Силецька Марта',NULL,'2018-11-09',NULL,380984651861,NULL,1478768984,'1',NULL,0,'','0'),
(3178,NULL,'Пламадян Уляна',NULL,'2018-11-09',NULL,380970449206,NULL,1192931169,'1',NULL,0,'','0'),
(3179,NULL,'Осадца Рада',NULL,'2018-11-09',NULL,380985185881,NULL,2073642300,'1',NULL,0,'','0'),
(3180,NULL,'мостова леся',NULL,'2018-11-09',NULL,380974521295,NULL,1901176794,'1',NULL,0,'','0'),
(3181,NULL,'Тракало Оксана',NULL,'2018-11-10',NULL,380980221572,NULL,1695662398,'1',NULL,0,'','0'),
(3182,NULL,'Білецька Христя(тренер)',NULL,NULL,NULL,380689572392,NULL,1993071390,'1',NULL,0,'','0'),
(3183,NULL,'Пенькевич Аня',NULL,'2018-11-12',NULL,380686783205,NULL,1572756497,'1',NULL,0,'','0'),
(3184,NULL,'Слободян Люба',NULL,'2018-11-12',NULL,380970532704,NULL,1258114937,'1',NULL,0,'','0'),
(3185,NULL,'Надвернюк Марія',NULL,NULL,NULL,380669983257,NULL,1424216553,'1',NULL,0,'','1'),
(3186,NULL,'Мацьків Наталя',NULL,'2018-11-12',NULL,380984490598,NULL,1704852686,'1',NULL,0,'','0'),
(3187,NULL,'Ільїн Ксенія',NULL,NULL,NULL,380675859893,NULL,2071833017,'1',14545,0,'','0'),
(3269,NULL,'Нога Вікторія',NULL,NULL,NULL,380681697929,NULL,1497112616,'1',NULL,0,'','0'),
(3188,NULL,'Школова Яна',NULL,'2018-11-14',NULL,380979002706,NULL,1658755629,'1',NULL,0,'','0'),
(3189,NULL,'Козій Оля',NULL,NULL,NULL,380967567889,NULL,1735222304,'1',NULL,0,'','0'),
(3190,NULL,'Івашків Ольга',NULL,'2018-11-14',NULL,380971071713,NULL,2077663160,'1',NULL,0,'','0'),
(3191,NULL,'Давидовська Таня',NULL,NULL,'DswOcf6leicVISinjFzXCw==',380973320345,NULL,1166335467,'1',44983,0,'','0'),
(3192,NULL,'Токальська Інна',NULL,'2018-11-14',NULL,380960784152,NULL,1873456394,'1',NULL,0,'','0'),
(3193,NULL,'мартинюк наталя',NULL,'2018-11-15',NULL,380962456978,NULL,1476863329,'1',NULL,0,'','0'),
(3194,NULL,'Репіна Оля',NULL,'2018-11-15',NULL,380959186465,NULL,2089579262,'1',NULL,0,'','0'),
(3195,NULL,'Цеган Ірина',NULL,'2018-11-15',NULL,380952419791,NULL,1392100247,'1',NULL,0,'','0'),
(3196,NULL,'мединська олена',NULL,'2018-11-16',NULL,380687023775,NULL,1156618766,'1',NULL,0,'','0'),
(3197,NULL,'Солтис Люба',NULL,'2018-11-16',NULL,380988067416,NULL,1449794604,'1',NULL,0,'','0'),
(3198,NULL,'Гой Таня',NULL,'2018-11-16',NULL,380969553634,NULL,1363402995,'1',NULL,0,'','0'),
(3199,NULL,'гикава надія',NULL,'2018-11-17',NULL,380979067578,NULL,1843689666,'1',NULL,0,'','0'),
(3200,NULL,'Холоднюк Вероніка',NULL,'2018-11-17',NULL,380980334312,NULL,1525512136,'1',NULL,0,'','0'),
(3201,NULL,'Карпець Іра',NULL,'2018-11-17',NULL,380965405246,NULL,2009452996,'1',NULL,0,'','0'),
(3202,NULL,'чорнявська віка',NULL,NULL,NULL,380987077624,NULL,2137334637,'1',13659,0,'','0'),
(3203,NULL,'КаЧур Валентина',NULL,'2018-11-19',NULL,380971079347,NULL,1412501952,'1',NULL,0,'','0'),
(3204,NULL,'Липова Христина',NULL,'2018-11-19',NULL,380970040433,NULL,2027919019,'1',20677,0,'','0'),
(3205,NULL,'Покойова Маряна',NULL,'2018-11-19',NULL,380961190611,NULL,1261670948,'1',NULL,0,'','0'),
(3206,NULL,'Задерейко Надя',NULL,'2018-11-19',NULL,380675907889,NULL,1181307676,'1',37507,0,'','0'),
(3207,NULL,'яримовська Надія',NULL,NULL,NULL,380971596660,NULL,1723518765,'1',NULL,0,'','0'),
(3208,NULL,'Кукула Каріна',NULL,'2018-11-19',NULL,380973370252,NULL,2041341887,'1',NULL,0,'','0'),
(3209,NULL,'Семенюк Тая',NULL,'2018-11-19',NULL,380972620465,NULL,1689224743,'1',NULL,0,'','0'),
(3210,NULL,'Ріщук Світлана',NULL,'2018-11-19',NULL,380976124179,NULL,1345239197,'1',NULL,0,'','0'),
(3211,NULL,'коваль любов',NULL,'2018-11-20',NULL,380978261057,NULL,1758527723,'1',NULL,0,'','0'),
(3212,NULL,'Склярчук Оля',NULL,'2018-11-20',NULL,380984892597,NULL,1231088428,'1',NULL,0,'','0'),
(3213,NULL,'гоюк оля',NULL,'2018-11-20',NULL,380672809225,NULL,2073153839,'1',NULL,0,'','0'),
(3214,NULL,'журба роксолана',NULL,NULL,NULL,380977497407,NULL,1805799262,'1',NULL,0,'','0'),
(3215,NULL,'Стрембіцька Христина',NULL,'2018-11-21',NULL,380961757071,NULL,1204437566,'1',NULL,0,'','0'),
(3216,NULL,'Гасяк Маряна',NULL,'2018-11-21',NULL,380686475429,NULL,1752403794,'1',41970,0,'','0'),
(3217,NULL,'Гончарик Світлана',NULL,'2018-11-22',NULL,380977685482,NULL,1689722136,'1',NULL,0,'','0'),
(3218,NULL,'Садиков Ярік',NULL,'2018-11-22',NULL,380675852524,NULL,1477322580,'1',NULL,0,'','0'),
(3219,NULL,'Лушній Інна',NULL,'2018-11-22',NULL,380965433993,NULL,1934007160,'1',NULL,0,'','0'),
(3220,NULL,'Малиновська Наталя',NULL,'2018-11-22',NULL,380681003159,NULL,1957094067,'1',NULL,0,'','0'),
(3221,NULL,'Головецька Віта',NULL,'2018-11-22',NULL,380969295055,NULL,1762699668,'1',52858,0,'','0'),
(3222,0555,'Масляк Наталя',NULL,NULL,NULL,380980135104,NULL,1384255351,'1',NULL,0,'','0'),
(3223,NULL,'Гоба Наталя',NULL,'2018-11-23',NULL,380677870290,NULL,1519163128,'1',NULL,0,'','0'),
(3224,NULL,'Дерій Світлана',NULL,'2018-11-23',NULL,380676021302,NULL,1229743916,'1',NULL,0,'','0'),
(3225,NULL,'Януш Анна',NULL,'2018-11-23',NULL,380969397152,NULL,1931906618,'1',NULL,0,'','0'),
(3226,NULL,'Щерба Ірина',NULL,'2018-11-24',NULL,380960867151,NULL,1169032322,'1',NULL,0,'','0'),
(3227,NULL,'Кондратюк Аня',NULL,'2018-11-24',NULL,380688723614,NULL,1564418244,'1',NULL,1,'','0'),
(3228,NULL,'Турчак Марія',NULL,'2018-11-24',NULL,380969643312,NULL,1276564307,'1',NULL,0,'','0'),
(3229,NULL,'бондя маша',NULL,'2018-11-24',NULL,380978624834,NULL,1781936392,'1',NULL,0,'','0'),
(3230,NULL,'Кириченко Алла',NULL,'2018-11-26',NULL,380680966462,NULL,2062503879,'1',NULL,1,'','0'),
(3231,0547,'Семенюк Ліда',NULL,NULL,NULL,380986527263,NULL,1230374670,'1',NULL,0,'','0'),
(3232,NULL,'Деркач Галя',NULL,'2018-11-27',NULL,380961591297,NULL,2052581987,'1',NULL,0,'','0'),
(3233,NULL,'Боднар Віка',NULL,'2018-11-27',NULL,380685729294,NULL,1922737217,'1',NULL,0,'','0'),
(3234,NULL,'Сакалюк Романія',NULL,'2018-11-28',NULL,380971119296,NULL,1547570712,'1',NULL,0,'','0'),
(3235,NULL,'Сакалюк Галина',NULL,'2018-11-28',NULL,380686530241,NULL,1643581597,'1',NULL,0,'','0'),
(3236,NULL,'Сакалюк Таня',NULL,'2018-11-28',NULL,380971718453,NULL,1543245156,'1',NULL,0,'','0'),
(3237,NULL,'Майданова Таня',NULL,'2018-11-28',NULL,380970260958,NULL,1492807943,'1',NULL,0,'','0'),
(3238,NULL,'Герасим Наталя',NULL,NULL,NULL,380967661843,NULL,1256723407,'1',NULL,0,'','0'),
(3239,0637,'Пунак Василина',NULL,NULL,NULL,380971461191,NULL,1481478714,'1',NULL,1,'','0'),
(3240,NULL,'Мандзяк Марина',NULL,'2018-11-28',NULL,380689902623,NULL,1167085524,'1',NULL,0,'','0'),
(3241,NULL,'Кожухарова юлія',NULL,'2018-11-29',NULL,380980731383,NULL,1287054852,'1',NULL,1,'','0'),
(3242,NULL,'Стодола Оксана',NULL,'2018-11-29',NULL,380982055228,NULL,1420813041,'1',NULL,2,'','0'),
(3243,NULL,'Клімов Оксана',NULL,'2018-11-29',NULL,380971042934,NULL,1121734990,'1',NULL,0,'','0'),
(3244,NULL,'Ванжура Маряна',NULL,NULL,NULL,380979993692,NULL,1596316073,'1',NULL,1,'','0'),
(3245,NULL,'Панасів Таня',NULL,'2018-11-30',NULL,380965674553,NULL,1676257702,'1',NULL,0,'','0'),
(3246,NULL,'Ципенда Софія',NULL,'2018-12-01',NULL,380678464755,NULL,2018482954,'1',NULL,0,'','0'),
(3247,NULL,'Вільград Таня',NULL,'2018-12-01',NULL,380966822805,NULL,1698793795,'1',31393,0,'','0'),
(3248,NULL,'Бойко Любов',NULL,'2018-12-01',NULL,380976085742,NULL,1148269396,'1',NULL,0,'','0'),
(3249,NULL,'Рудик Яна',NULL,'2018-12-01',NULL,380965021060,NULL,1993473158,'1',NULL,1,'','0'),
(3250,NULL,'Барабаш Світлана',NULL,'2018-12-03',NULL,380985586400,NULL,2059868205,'1',44442,0,'','0'),
(3251,NULL,'Остапенко Яна',NULL,'2018-12-04',NULL,380686650318,NULL,2089090455,'1',NULL,0,'','0'),
(3252,NULL,'Воробець Ганна',NULL,'2018-12-04',NULL,380667647346,NULL,1393128935,'1',62531,0,'','0'),
(3253,NULL,'Коваль Оксана',NULL,'2018-12-04',NULL,380970554051,NULL,1412764182,'1',NULL,0,'','0'),
(3254,NULL,'Гира Марія',NULL,'2018-12-04',NULL,380681047866,NULL,1751170938,'1',NULL,0,'','0'),
(3255,NULL,'Попіль Наталя',NULL,'2018-12-04',NULL,380961107254,NULL,1263760798,'1',NULL,1,'','0'),
(3256,NULL,'Коленич Наталя',NULL,'2018-12-04',NULL,380681933132,NULL,1663983758,'1',NULL,0,'','0'),
(3257,NULL,'Ємчук Христина',NULL,'2018-12-04',NULL,380969090614,NULL,1944381289,'1',NULL,0,'','0'),
(3258,NULL,'Волощук Вікторія',NULL,NULL,NULL,380962025665,NULL,1868489440,'1',NULL,0,'','0'),
(3259,NULL,'Семирозум таня',NULL,'2018-12-05',NULL,380684241634,NULL,1908708297,'1',NULL,0,'','0'),
(3260,NULL,'Чмола Галина',NULL,'2018-12-05',NULL,380979267022,NULL,1812812521,'1',NULL,0,'','0'),
(3261,NULL,'Гузік Уляна',NULL,'2018-12-05',NULL,380661386012,NULL,1115509475,'1',NULL,0,'','0'),
(3262,NULL,'Забіяка Ліза',NULL,'2018-12-06',NULL,380963113213,NULL,2080007451,'1',NULL,0,'','0'),
(3263,NULL,'Макара Парасковія',NULL,'2018-12-06',NULL,380983230764,NULL,1947356184,'1',NULL,0,'','0'),
(3264,NULL,'Німець Наталя',NULL,'2018-12-06',NULL,380673505600,NULL,1390721370,'1',NULL,0,'','0'),
(3265,NULL,'Остяновська Ірина',NULL,'2018-12-06',NULL,380964315916,NULL,1751961758,'1',NULL,1,'','0'),
(3266,NULL,'Боднар Оксана',NULL,'2018-12-06',NULL,380975957511,NULL,1217484305,'1',NULL,0,'','0'),
(3267,NULL,'гриців христина',NULL,'2018-12-07',NULL,380688482669,NULL,1413415291,'1',NULL,0,'','0'),
(3268,NULL,'Куць Аня',NULL,'2018-12-07',NULL,380673505823,NULL,1601935379,'1',NULL,0,'','0'),
(3270,NULL,'Мартинюк Ілона',NULL,'2018-12-07',NULL,380675996090,NULL,1379198993,'1',NULL,0,'','0'),
(3271,NULL,'Киричок Наталя',NULL,'2018-12-07',NULL,380683289593,NULL,1871871696,'1',NULL,0,'','0'),
(3272,NULL,'Жевецька Діана',NULL,'2018-12-08',NULL,380962285778,NULL,2146100181,'1',NULL,0,'','0'),
(3273,NULL,'Колісник Інна',NULL,'2018-12-08','MVeRRIx/3Sm2j4UqA9zqQQ==',380685141588,NULL,1760761865,'1',53657,0,'','0'),
(3274,NULL,'Попельницька Ірина',NULL,NULL,NULL,380682684709,NULL,1304038486,'1',NULL,1,'','0'),
(3275,NULL,'Чорній Наталя',NULL,'2018-12-10',NULL,380664578285,NULL,1889872241,'1',31671,0,'','0'),
(3276,NULL,'Гунько Валерія',NULL,'2018-12-10',NULL,380961527973,NULL,1785753296,'1',NULL,0,'','0'),
(3277,NULL,'Дубек Марія',NULL,NULL,NULL,380982229783,NULL,2035361210,'1',NULL,0,'','0'),
(3278,NULL,'Петрик Зоряна',NULL,'2018-12-11',NULL,380682464527,NULL,1219601416,'1',NULL,0,'','0'),
(3279,NULL,'Дзюревич Оксана',NULL,'2018-12-11',NULL,380685874881,NULL,1262926880,'1',NULL,0,'','0'),
(3280,NULL,'Нога Галина',NULL,'2018-12-12',NULL,380675868797,NULL,1309195580,'1',NULL,0,'','0'),
(3281,NULL,'Мармуш ольга',NULL,'2018-12-12',NULL,380965339742,NULL,1942869402,'1',NULL,0,'','0'),
(3282,NULL,'Пушкар Наталя',NULL,'2018-12-12',NULL,380680267265,NULL,2091316286,'1',NULL,0,'','0'),
(3283,NULL,'демків Богдана',NULL,NULL,NULL,380970126673,NULL,1518467799,'1',NULL,0,'','0'),
(3284,NULL,'Нога Наталя',NULL,'2018-12-13',NULL,380978126226,NULL,1473119159,'1',NULL,0,'','0'),
(3285,NULL,'Миколишин юля',NULL,NULL,NULL,380955825245,NULL,1887207296,'1',NULL,0,'','0'),
(3286,NULL,'Кухта Віта',NULL,'2018-12-13',NULL,380986305051,NULL,1280613303,'1',NULL,0,'','0'),
(3287,NULL,'Міщанчук Уляна',NULL,'2018-12-14',NULL,380971318470,NULL,1476749677,'1',NULL,0,'','0'),
(3288,NULL,'Наконечна Марія',NULL,'2018-12-14',NULL,380675507945,NULL,2131615286,'1',NULL,0,'','0'),
(3289,NULL,'Савчук Артем',NULL,NULL,NULL,380992229315,NULL,1463608227,'1',NULL,0,'','0'),
(3290,NULL,'Джага Світлана',NULL,'2018-12-17',NULL,380976415677,NULL,1145543924,'1',NULL,0,'','0'),
(3291,NULL,'Кілініцька Наталя',NULL,'2018-12-20',NULL,380689450967,NULL,1559401896,'1',NULL,0,'','0'),
(3292,NULL,'Кушнір Людмила',NULL,'2018-12-21',NULL,380688696349,NULL,2098323137,'1',NULL,0,'','0'),
(3293,NULL,'Кулій Христина',NULL,'2018-12-21',NULL,380980278290,NULL,1411346288,'1',NULL,0,'','0'),
(3294,NULL,'Мазур Віра',NULL,'2018-12-21',NULL,380672619602,NULL,1662959833,'1',NULL,0,'','0'),
(3295,NULL,'Качмар Наталя',NULL,'2018-12-21',NULL,380997973733,NULL,1520146582,'1',NULL,1,'','0'),
(3296,NULL,'Ленчинська Леся',NULL,'2018-12-22',NULL,380683384972,NULL,1852738718,'1',NULL,0,'','0'),
(3297,NULL,'Палца роксолана',NULL,'2018-12-22',NULL,380987922326,NULL,1888084031,'1',NULL,0,'','0'),
(3298,NULL,'Каченовська Наталя',NULL,'2018-12-25',NULL,380987704618,NULL,1683232488,'1',NULL,0,'','0'),
(3299,NULL,'Марчук Наталя',NULL,'2018-12-26',NULL,380962726183,NULL,1244708630,'1',NULL,0,'','0'),
(3300,NULL,'Жовтюк Оксана',NULL,'2018-12-26',NULL,380661385932,NULL,2124709292,'1',NULL,0,'','0'),
(3301,NULL,'Ковальська Марія',NULL,'2018-12-26',NULL,380681505271,NULL,1244631047,'1',NULL,0,'','0'),
(3302,NULL,'Мельник Марія',NULL,'2018-12-26',NULL,380686712279,NULL,1776589460,'1',NULL,0,'','0'),
(3303,NULL,'Юрків Наталя',NULL,'2018-12-26',NULL,380985077043,NULL,1844281692,'1',NULL,0,'','0'),
(3304,NULL,'Рудей Сніжана',NULL,'2018-12-26',NULL,380993821812,NULL,1125158376,'1',NULL,0,'','0'),
(3305,NULL,'Коверська Юля',NULL,'2018-12-27',NULL,380961528018,NULL,2027306492,'1',NULL,0,'','0'),
(3306,NULL,'Поляновська Ольга',NULL,'2018-12-27',NULL,380970040977,NULL,2091348348,'1',NULL,0,'','0'),
(3307,NULL,'Онищук Таня',NULL,'2018-12-28',NULL,380509291696,NULL,1432858974,'1',NULL,0,'','0'),
(3308,0178,'Репета Маряна',NULL,NULL,NULL,380987275345,NULL,1711425119,'1',NULL,0,'','0'),
(3309,NULL,'Левин Галина',NULL,'2018-12-29',NULL,380982255820,NULL,1114765013,'1',NULL,0,'','0'),
(3310,NULL,'Бурак Анжела',NULL,'2018-12-31',NULL,380970541080,NULL,1401300821,'1',NULL,0,'','0'),
(3311,NULL,'Галушка христя',NULL,'2019-01-03','jFy8eMYsbmTg7tTEdcLiTA==',380687033121,NULL,1360890538,'1',49966,0,'','0'),
(3312,NULL,'Процишин Ігор',NULL,'2019-01-03',NULL,380980569140,NULL,1954120901,'1',NULL,0,'','0'),
(3313,NULL,'Волощук ПЕтро',NULL,'2019-01-03',NULL,380983847741,NULL,2096488439,'1',NULL,0,'','0'),
(3314,NULL,'Суховолець Надія',NULL,NULL,NULL,380674785477,NULL,1716271624,'1',NULL,0,'','0'),
(3315,NULL,'Хандажко Оксана',NULL,'2019-01-04',NULL,380967812326,NULL,1536173891,'1',NULL,0,'','0'),
(3316,NULL,'Децько Петро',NULL,'2019-01-04',NULL,380677052555,NULL,1822194176,'1',NULL,0,'','0'),
(3317,NULL,'Лисак Анна',NULL,'2019-01-04',NULL,380967221132,NULL,1772415108,'1',NULL,0,'','0'),
(3318,NULL,'Сиско Юля',NULL,'2019-01-04',NULL,380976853590,NULL,1750415499,'1',NULL,0,'','0'),
(3319,NULL,'Бадлюк Софія',NULL,'2019-01-04',NULL,380687602930,NULL,1466357640,'1',NULL,0,'','0'),
(3320,NULL,'Гануля Надя',NULL,'2019-01-04',NULL,380960987995,NULL,1829867944,'1',NULL,0,'','0'),
(3321,NULL,'Чонка Марія',NULL,'2019-01-04',NULL,380687318609,NULL,1995010018,'1',NULL,0,'','0'),
(3322,NULL,'Петрів Таня',NULL,'2019-01-04',NULL,380979906846,NULL,1551892983,'1',59160,0,'','0'),
(3323,NULL,'Базюк Настя',NULL,'2019-01-05',NULL,380506950990,NULL,1368557609,'1',NULL,0,'','0'),
(3324,NULL,'камінська олена',NULL,'2019-01-10',NULL,380682279820,NULL,1661860291,'1',NULL,0,'','0'),
(3325,NULL,'шуфлін христина',NULL,NULL,NULL,NULL,NULL,1411388410,'1',NULL,0,'','1'),
(3326,NULL,'бойко олександра',NULL,'2019-01-10',NULL,380966372274,NULL,1450686692,'1',33068,0,'','0'),
(3327,NULL,'балабан оля',NULL,'2019-01-10',NULL,380679599026,NULL,1463265974,'1',NULL,0,'','0'),
(3328,NULL,'лукініхіна христя',NULL,'2019-01-10',NULL,380985546778,NULL,1546009946,'1',NULL,0,'','0'),
(3329,NULL,'кузь марина',NULL,'2019-01-10',NULL,380968236735,NULL,1324904533,'1',NULL,0,'','0'),
(3330,NULL,'Федорович Галина',NULL,'2019-01-11',NULL,380683374923,NULL,1733689106,'1',NULL,0,'','0'),
(3331,NULL,'Мартинюк Оля',NULL,'2019-01-11',NULL,380982784205,NULL,1554168980,'1',NULL,1,'','0'),
(3332,NULL,'Бабюк Христина',NULL,'2019-01-11',NULL,380682904147,NULL,1146089330,'1',NULL,0,'','0'),
(3333,NULL,'Білянська Софія',NULL,'2019-01-11',NULL,380990446115,NULL,1903811982,'1',38132,0,'','0'),
(3334,NULL,'Пятничук Ірина',NULL,'2019-01-12',NULL,380964539738,NULL,1140199088,'1',NULL,2,'','0'),
(3335,NULL,'Шестопалько Галина',NULL,'2019-01-12',NULL,380969404060,NULL,1213720312,'1',NULL,0,'','0'),
(3336,NULL,'миловука марія',NULL,'2019-01-12',NULL,380971208381,NULL,1747825664,'1',NULL,0,'','0'),
(3337,NULL,'Білик Оля',NULL,'2019-01-12',NULL,380989454028,NULL,2094547366,'1',NULL,0,'','0'),
(3338,NULL,'Савчук Аліна',NULL,'2019-01-14',NULL,380678366499,NULL,1778743010,'1',NULL,0,'','0'),
(3339,NULL,'Свинарчук Марія',NULL,'2019-01-14',NULL,380683724189,NULL,1343737989,'1',NULL,0,'','0'),
(3340,NULL,'Білонога Іра',NULL,'2019-01-15','qaKYFu4p+cOKX+tYZfH/LA==',380687039217,NULL,1561530716,'1',43984,0,'','0'),
(3341,NULL,'Гановська Оля',NULL,'2019-01-15',NULL,380978515975,NULL,1331925255,'1',NULL,0,'','0'),
(3342,NULL,'Боднар Васелина',NULL,'2019-01-15',NULL,380973004438,NULL,1294291040,'1',NULL,0,'','0'),
(3343,NULL,'Гуляк Марія',NULL,'2019-01-15',NULL,380963205644,NULL,1365892868,'1',NULL,0,'','0'),
(3344,NULL,'Ковальська Ліля',NULL,'2019-01-15',NULL,380660563353,NULL,1197846598,'1',NULL,0,'','0'),
(3345,NULL,'Павшок Настя',NULL,'2019-01-15',NULL,380961702464,NULL,2068479601,'1',NULL,0,'','0'),
(3346,NULL,'Бодяк Олег',NULL,NULL,NULL,380673273075,NULL,2056214536,'1',NULL,0,'','0'),
(3347,NULL,'Бідочка Богдана',NULL,NULL,NULL,380971705195,NULL,1651471397,'1',NULL,0,'','0'),
(3348,NULL,'Голіней Наталя',NULL,'2019-01-16',NULL,380984226941,NULL,1629779398,'1',NULL,0,'','0'),
(3349,NULL,'Станько Ірина',NULL,'2019-01-16',NULL,380970558740,NULL,2110196293,'1',NULL,0,'','0'),
(3350,NULL,'Бень Зоряна',NULL,'2019-01-16',NULL,380688295391,NULL,1410263309,'1',NULL,0,'','0'),
(3351,NULL,'Середницька Ірина',NULL,'2019-01-16',NULL,380684630359,NULL,1242693706,'1',NULL,0,'','0'),
(3352,NULL,'Левенець Христина',NULL,'2019-01-17',NULL,380976241865,NULL,1241283333,'1',NULL,0,'','0'),
(3353,NULL,'Марущак Ліля',NULL,'2019-01-17',NULL,380988185795,NULL,1174526527,'1',NULL,0,'','0'),
(3354,NULL,'Деременда Руслана',NULL,'2019-01-17',NULL,380682047310,NULL,1505017798,'1',NULL,0,'','0'),
(3355,NULL,'Дрозд Галина',NULL,'2019-01-17',NULL,380969857262,NULL,1752971213,'1',NULL,1,'','0'),
(3356,NULL,'Сідей Марія',NULL,'2019-01-18',NULL,380675260448,NULL,1385535949,'1',NULL,1,'','0'),
(3357,NULL,'Ланова Валентина',NULL,'2019-01-18',NULL,380634981196,NULL,1681299261,'1',NULL,0,'','0'),
(3358,NULL,'Малиновська Оксана',NULL,'2019-01-18',NULL,380969578460,NULL,1735422030,'1',NULL,0,'','0'),
(3359,NULL,'Малиновська Уляна',NULL,'2019-01-18',NULL,380986382159,NULL,1212125311,'1',NULL,0,'','0'),
(3360,NULL,'Кипибіда Оля',NULL,'2019-01-18',NULL,380967839727,NULL,1391773646,'1',NULL,0,'','0'),
(3361,NULL,'Малиновська Віка',NULL,'2019-01-18',NULL,380971570465,NULL,1949275928,'1',NULL,0,'','0'),
(3362,NULL,'Прокопик Оксана',NULL,'2019-01-21',NULL,380689381525,NULL,1617387901,'1',NULL,0,'','0'),
(3363,NULL,'Дюк Марія',NULL,'2019-01-21',NULL,380685145984,NULL,1132235766,'1',16735,0,'','0'),
(3364,NULL,'марчин надія',NULL,'2019-01-21',NULL,380662140887,NULL,1915807864,'1',NULL,0,'','0'),
(3365,NULL,'Яцула Маряна',NULL,'2019-01-21',NULL,380985668384,NULL,1914656116,'1',NULL,0,'','0'),
(3366,NULL,'Дмитрів Ангеліна',NULL,'2019-01-21',NULL,380980197782,NULL,1649428051,'1',NULL,0,'','0'),
(3367,NULL,'Живецька Зоряна',NULL,'2019-01-21',NULL,380681373450,NULL,1442812659,'1',NULL,0,'','0'),
(3368,NULL,'Куля Вікторія',NULL,'2019-01-22',NULL,380684498253,NULL,1756332475,'1',NULL,0,'','0'),
(3369,NULL,'Криса Уляна',NULL,'2019-01-22',NULL,380936353445,NULL,1486515797,'1',NULL,0,'','0'),
(3370,NULL,'Щипчик Юрій',NULL,'2019-01-23',NULL,380687212847,NULL,1220950487,'1',NULL,0,'','0'),
(3371,NULL,'Бабій Васелина',NULL,'2019-01-23',NULL,380966649318,NULL,1277912647,'1',NULL,0,'','0'),
(3372,NULL,'Демянчук Віка',NULL,'2019-01-23',NULL,380987261136,NULL,1647249164,'1',NULL,0,'','0'),
(3373,NULL,'Винник Леся',NULL,'2019-01-23',NULL,380669432802,NULL,1129254086,'1',NULL,0,'','0'),
(3374,NULL,'Коків Марія',NULL,NULL,NULL,380981286340,NULL,1912759797,'1',NULL,0,'','0'),
(3375,NULL,'Гриців Аліна',NULL,'2019-01-23',NULL,380685535965,NULL,1382693422,'1',NULL,0,'','0'),
(3376,NULL,'Ковтун Світлана',NULL,'2019-01-23',NULL,380680328210,NULL,1321339230,'1',NULL,0,'','0'),
(3377,NULL,'Бабуняк Оксана',NULL,NULL,NULL,380688831980,NULL,1182830537,'1',NULL,0,'','0'),
(3378,NULL,'Каськів Інна',NULL,'2019-01-24',NULL,380682234428,NULL,1894890880,'1',NULL,0,'','0'),
(3379,NULL,'Конопельська Оля',NULL,'2019-01-25','GkVXJQnaTV76MDwbP+u7EA==',380960394360,NULL,2033787724,'1',32961,0,'','0'),
(3380,NULL,'Туркіць Христина',NULL,'2019-01-25',NULL,380971489951,NULL,1142749854,'1',NULL,0,'','0'),
(3381,NULL,'Богачик Оля',NULL,'2019-01-26',NULL,380973402838,NULL,1932099463,'1',NULL,0,'','0'),
(3382,NULL,'Гаєвська Тамара',NULL,'2019-01-26',NULL,380977109854,NULL,1281137130,'1',NULL,0,'','0'),
(3383,NULL,'Ляхович Христина',NULL,NULL,NULL,380977561831,NULL,1652923467,'1',NULL,1,'','0'),
(3384,NULL,'павлин марія',NULL,'2019-01-28',NULL,380994611223,NULL,1141380797,'1',NULL,0,'','0'),
(3385,NULL,'Баринюк Маріана',NULL,NULL,NULL,380977021174,NULL,1975264553,'1',NULL,0,'','0'),
(3386,NULL,'Гольба Уляна',NULL,'2019-01-28',NULL,380964999074,NULL,1334741651,'1',NULL,0,'','0'),
(3387,NULL,'Гольба Олеся',NULL,NULL,NULL,380686499313,NULL,2118852332,'1',NULL,0,'','0'),
(3388,NULL,'Тимків іванка',NULL,'2019-01-28',NULL,380975455852,NULL,1132987295,'1',NULL,0,'','0'),
(3389,NULL,'Дідух Васелина',NULL,'2019-01-28',NULL,380681522603,NULL,1129631540,'1',NULL,0,'','0'),
(3390,NULL,'Палагнюк Юля',NULL,'2019-01-28',NULL,380988916487,NULL,1766270064,'1',NULL,0,'','0'),
(3391,NULL,'Андрущенко Наталя',NULL,'2019-01-28',NULL,380976288023,NULL,1860646021,'1',NULL,0,'','0'),
(3392,NULL,'присяжнюк наталя',NULL,NULL,NULL,380685934099,NULL,1411905820,'1',NULL,1,'','0'),
(3393,NULL,'Романишин Богдан',NULL,NULL,NULL,380733151184,NULL,1486651405,'1',NULL,0,'','0'),
(3394,NULL,'Крижанівська Ольга',NULL,'2019-01-29',NULL,380981259879,NULL,1950480909,'1',NULL,1,'','0'),
(3395,NULL,'Сололка Христина',NULL,'2019-01-29',NULL,380500650491,NULL,1874229112,'1',NULL,0,'','0'),
(3396,NULL,'Мительська Леся',NULL,'2019-01-29',NULL,380973558374,NULL,1668337581,'1',NULL,0,'','0'),
(3397,NULL,'Козак Олена',NULL,NULL,NULL,NULL,380953683574,1441346467,'1',NULL,0,'','0'),
(3398,NULL,'Нагаєвська Тетяна',NULL,'2019-01-30',NULL,380979185080,NULL,1749508791,'1',NULL,0,'','0'),
(3399,NULL,'Бодяк Володимир',NULL,'2019-01-30',NULL,380976412893,NULL,1742763529,'1',NULL,0,'','0'),
(3400,NULL,'Бегма Івана',NULL,'2019-01-30',NULL,380987780827,NULL,2090257058,'1',NULL,0,'','0'),
(3401,NULL,'Бала Христя',NULL,'2019-01-30',NULL,380952062486,NULL,1721756309,'1',NULL,0,'','0'),
(3402,NULL,'Гуменюк Ірина',NULL,'2019-01-31',NULL,380969533499,NULL,1631197864,'1',NULL,0,'','0'),
(3403,NULL,'Кулій Наталя',NULL,'2019-01-31',NULL,380971139759,NULL,1909453106,'1',NULL,0,'','0'),
(3404,NULL,'Куля Ольга',NULL,'2019-01-31',NULL,380971352313,NULL,1873341483,'1',NULL,0,'','0'),
(3405,NULL,'Гошуляк Марія',NULL,'2019-01-31',NULL,380970376601,NULL,2072376965,'1',NULL,0,'','0'),
(3406,NULL,'Мирончук Марія',NULL,'2019-01-31',NULL,380950909190,NULL,1305313351,'1',NULL,0,'','0'),
(3407,NULL,'Подола Катя',NULL,'2019-01-31',NULL,380678341162,NULL,1659717375,'1',NULL,0,'','0'),
(3408,NULL,'Зайкова Вікторія',NULL,'2019-01-31',NULL,380979954577,NULL,1322514933,'1',NULL,0,'','0'),
(3409,NULL,'Бардецька Христина',NULL,'2019-01-31',NULL,380676751047,NULL,1130963422,'1',NULL,0,'','0'),
(3410,NULL,'Опацька Анастасія',NULL,'2019-01-31',NULL,380958200765,NULL,1464693688,'1',NULL,0,'','0'),
(3411,NULL,'Геравс Юля',NULL,'2019-02-01',NULL,380955809382,NULL,1889204827,'1',NULL,0,'','0'),
(3412,NULL,'Сидоренко Вікторія',NULL,'2019-02-01',NULL,380996827354,NULL,1371162898,'1',NULL,0,'','0'),
(3413,NULL,'Гнатишин Ірина',NULL,'2019-02-01',NULL,380634648990,NULL,1284878553,'1',NULL,0,'','0'),
(3414,NULL,'Кравченко Аліна',NULL,'2019-02-01',NULL,380985075214,NULL,2135079700,'1',NULL,0,'','0'),
(3415,NULL,'Парацій Вікторія',NULL,'2019-02-02',NULL,380960332603,NULL,1500121377,'1',NULL,2,'','0'),
(3416,NULL,'Дубчак МАрійка',NULL,'2019-02-02',NULL,380976824825,NULL,1230727730,'1',NULL,0,'','0'),
(3417,NULL,'Лацко Анна',NULL,'2019-02-04',NULL,380678727239,NULL,1577914973,'1',NULL,0,'','0'),
(3418,NULL,'Радневич Іванна',NULL,'2019-02-04',NULL,380672038272,NULL,1584125716,'1',NULL,0,'','0'),
(3419,NULL,'Боднар Віка',NULL,'2019-02-04',NULL,380983544598,NULL,1226006693,'1',NULL,0,'','0'),
(3420,NULL,'Чомко Оксана',NULL,'2019-02-04',NULL,380978397683,NULL,1421435642,'1',NULL,0,'','0'),
(3421,NULL,'Міщанчук Віра',NULL,NULL,NULL,380979015304,NULL,2058794644,'1',NULL,0,'','0'),
(3422,NULL,'Винничик настя',NULL,'2019-02-04',NULL,380636816447,NULL,1199951502,'1',50307,0,'','0'),
(3423,NULL,'Грабчак Наталя',NULL,NULL,NULL,380964968819,NULL,1371030066,'1',NULL,0,'','0'),
(3424,NULL,'Тарасенко Марія',NULL,'2019-02-06',NULL,380987025891,NULL,1867763181,'1',NULL,0,'','0'),
(3425,NULL,'Федорків Зоряна',NULL,'2019-02-06',NULL,380966749693,NULL,1721531605,'1',NULL,0,'','0'),
(3426,NULL,'Ступка Маряна',NULL,'2019-02-06',NULL,380672469043,NULL,1324049753,'1',NULL,0,'','0'),
(3427,NULL,'Пухта Тамара',NULL,'2019-02-06',NULL,380685538300,NULL,1494268133,'1',NULL,0,'','0'),
(3428,NULL,'Білик Надя',NULL,'2019-02-06',NULL,380677814394,NULL,1927894313,'1',NULL,0,'','0'),
(3429,NULL,'Брода Катя',NULL,'2019-02-06',NULL,380674240881,NULL,1904469530,'1',NULL,0,'','0'),
(3430,NULL,'Кара Каріна',NULL,'2019-02-06',NULL,380675269373,NULL,2027655669,'1',15305,0,'','0'),
(3431,NULL,'Гузік Юля',NULL,'2019-02-07',NULL,380685296228,NULL,1776090154,'1',NULL,0,'','0'),
(3432,NULL,'Кучарська таня',NULL,'2019-02-07',NULL,380507137599,NULL,2084148003,'1',NULL,0,'','0'),
(3433,NULL,'Іваськів Роза',NULL,'2019-02-07',NULL,380969802302,NULL,1724903332,'1',NULL,1,'','0'),
(3434,NULL,'Бабин Надя',NULL,'2019-02-07',NULL,380978457363,NULL,1220897288,'1',12862,0,'','0'),
(3435,NULL,'Маціборко Софія',NULL,NULL,NULL,380964782696,NULL,1313432495,'1',12056,0,'','0'),
(3436,NULL,'Міхалків Світлана',NULL,'2019-02-08',NULL,380980047215,NULL,1689737926,'1',NULL,0,'','0'),
(3437,NULL,'Лаврик Зоряна',NULL,'2019-02-08',NULL,380979679117,NULL,1349628604,'1',NULL,0,'','0'),
(3438,NULL,'Вітів Надія',NULL,'2019-02-08',NULL,380678771931,NULL,1836064895,'1',NULL,0,'','0'),
(3439,NULL,'НЕра Юля',NULL,'2019-02-08',NULL,380962764864,NULL,1295162806,'1',NULL,0,'','0'),
(3440,NULL,'Паладійчук Василь',NULL,'2019-02-08',NULL,380979833623,NULL,1789261035,'1',NULL,0,'','0'),
(3441,NULL,'Збриська Маряна',NULL,'2019-02-09',NULL,380966375400,NULL,1988774670,'1',NULL,0,'','0'),
(3442,NULL,'Максім Юля',NULL,'2019-02-09',NULL,380966778782,NULL,1537226699,'1',NULL,0,'','0'),
(3443,NULL,'Нагуляк Андріана',NULL,'2019-02-09',NULL,380966887162,NULL,1215751225,'1',NULL,0,'','0'),
(3444,NULL,'Прийдун Алла',NULL,'2019-02-09',NULL,380971366519,NULL,1413747306,'1',NULL,0,'','0'),
(3445,NULL,'Лучка Зоряна',NULL,'2019-02-11',NULL,380672992025,NULL,1709284969,'1',NULL,0,'','0'),
(3446,NULL,'Барицька яна',NULL,'2019-02-11',NULL,380976898198,NULL,1893104047,'1',NULL,0,'','0'),
(3447,NULL,'Біяк Катерина',NULL,'2019-02-11',NULL,380676021670,NULL,2010191098,'1',NULL,0,'','0'),
(3448,NULL,'Гураш Павліна',NULL,'2019-02-11',NULL,380685145989,NULL,1536572580,'1',NULL,0,'','0'),
(3449,NULL,'Гуйван Зоряна',NULL,'2019-02-11',NULL,380689352715,NULL,2025989499,'1',NULL,0,'','0'),
(3450,NULL,'Паламар Ліля',NULL,'2019-02-11',NULL,380968718869,NULL,1307464043,'1',18530,0,'','0'),
(3451,NULL,'Майданик Оксана',NULL,'2019-02-12',NULL,380684241630,NULL,1717980828,'1',NULL,0,'','0'),
(3452,NULL,'Карачинська Олена',NULL,'2019-02-12',NULL,380686242831,NULL,1934134089,'1',NULL,0,'','0'),
(3453,NULL,'василик оля',NULL,'2019-02-12',NULL,380973560241,NULL,1843492213,'1',NULL,0,'','0'),
(3454,NULL,'Скабр Діана',NULL,'2019-02-12',NULL,380982691849,NULL,1598352573,'1',NULL,0,'','0'),
(3455,NULL,'Дармограй Христя',NULL,'2019-02-12',NULL,380686812975,NULL,1735754605,'1',NULL,0,'','0'),
(3456,NULL,'Джуравець Наталя',NULL,'2019-02-12',NULL,380667207523,NULL,1820939248,'1',NULL,0,'','0'),
(3457,NULL,'Юрків Оля',NULL,'2019-02-12',NULL,380980362016,NULL,1756741601,'1',NULL,0,'','0'),
(3458,NULL,'Лучка Зоряна',NULL,'2019-02-13',NULL,380973309630,NULL,1562880884,'1',NULL,1,'','0'),
(3459,NULL,'Тимофій Христина',NULL,'2019-02-13',NULL,380507077503,NULL,1194433473,'1',NULL,1,'','0'),
(3460,NULL,'Чайківська Маряна',NULL,'2019-02-13',NULL,380969421833,NULL,1443281993,'1',NULL,1,'','0'),
(3461,NULL,'Гриців Саша',NULL,'2019-02-13',NULL,380978832208,NULL,1402651886,'1',NULL,0,'','0'),
(3462,NULL,'Петрів Ліда',NULL,'2019-02-13',NULL,380961153129,NULL,1255719642,'1',NULL,0,'','0'),
(3463,NULL,'Коваль настя',NULL,NULL,NULL,380976788175,NULL,1150091640,'1',NULL,0,'','0'),
(3464,NULL,'Сенько Надія',NULL,'2019-02-16',NULL,380688831798,NULL,1799974409,'1',NULL,0,'','0'),
(3465,NULL,'Хортик Софія',NULL,'2019-02-16',NULL,380682387017,NULL,1202408882,'1',NULL,0,'','0'),
(3466,NULL,'Синишин Наталя',NULL,'2019-02-18',NULL,380986095730,NULL,1708528520,'1',NULL,1,'','0'),
(3467,NULL,'Топольніцька Роксолана',NULL,'2019-02-18',NULL,380677052440,NULL,1745606300,'1',NULL,0,'','0'),
(3468,NULL,'Сусь галина',NULL,NULL,NULL,380680797773,NULL,1520188631,'1',NULL,0,'','0'),
(3469,NULL,'Вовк Маряна',NULL,'2019-02-18',NULL,380675263545,NULL,1630708009,'1',NULL,0,'','0'),
(3470,NULL,'Піскляк Ліда',NULL,'2019-02-18',NULL,380961635106,NULL,1354963519,'1',NULL,0,'','0'),
(3471,NULL,'Ясінська Марія',NULL,'2019-02-18',NULL,380988211997,NULL,1353327892,'1',NULL,0,'','0'),
(3472,NULL,'Бартко Світлана',NULL,'2019-02-18',NULL,380987713506,NULL,1153072649,'1',NULL,0,'','0'),
(3473,NULL,'Стецька Оксана',NULL,NULL,NULL,380978398803,NULL,2039826658,'1',NULL,0,'','0'),
(3474,NULL,'Щипчик Наталя',NULL,'2019-02-19',NULL,380678360717,NULL,2100822023,'1',NULL,0,'','0'),
(3475,NULL,'Бабій Катя',NULL,'2019-02-19',NULL,380683283590,NULL,1226749127,'1',NULL,0,'','0'),
(3476,NULL,'Галт Оля',NULL,NULL,NULL,380677531799,NULL,1647026698,'1',NULL,0,'','0'),
(3477,NULL,'Христина Гевко',NULL,'2019-02-19',NULL,380977132164,NULL,1125190804,'1',NULL,0,'','0'),
(3478,NULL,'Зубик Оля',NULL,'2019-02-19',NULL,380683362502,NULL,1563834105,'1',NULL,0,'','0'),
(3479,NULL,'Смоляк Світлана',NULL,'2019-02-20',NULL,380987043084,NULL,1482756237,'1',NULL,0,'','0'),
(3480,NULL,'Кучерська Віта',NULL,'2019-02-20',NULL,380966330666,NULL,1535630756,'1',NULL,0,'','0'),
(3481,NULL,'Лопушанська Юліана',NULL,'2019-02-20',NULL,380983338256,NULL,1213942987,'1',NULL,0,'','0'),
(3482,NULL,'Бенькевич Вікторія',NULL,'2019-02-20',NULL,380971730481,NULL,2120850713,'1',NULL,0,'','0'),
(3483,NULL,'Тришак Галя',NULL,NULL,NULL,NULL,NULL,1980362032,'1',NULL,0,'','0'),
(3484,NULL,'Суха софія',NULL,'2019-02-20',NULL,380964793466,NULL,1665538051,'1',NULL,0,'','0'),
(3485,NULL,'Топольніцька Марія',NULL,'2019-02-20',NULL,380970465836,NULL,1138710639,'1',NULL,0,'','0'),
(3486,NULL,'Кравченко Станіслав',NULL,'2019-02-21',NULL,380679674765,NULL,1639744094,'1',NULL,0,'','0'),
(3487,NULL,'Кравченко оля',NULL,'2019-02-21',NULL,380674657030,NULL,1816589300,'1',NULL,0,'','0'),
(3488,NULL,'Гуменюк Ангеліна',NULL,'2019-02-21',NULL,380680965260,NULL,1648677124,'1',55296,0,'','0'),
(3489,NULL,'Стадник Марія',NULL,'2019-02-21',NULL,380937573221,NULL,1621222208,'1',NULL,0,'','0'),
(3490,NULL,'Стадник Надя',NULL,'2019-02-21',NULL,380974144024,NULL,1565483351,'1',NULL,0,'','0'),
(3491,NULL,'Пастушенко Віка',NULL,'2019-02-21',NULL,380985786988,NULL,1711870799,'1',45802,0,'','0'),
(3492,NULL,'Вівчарик Марія',NULL,'2019-02-22',NULL,380987365465,NULL,2058701776,'1',NULL,0,'','0'),
(3493,NULL,'Йосипів Маряна',NULL,'2019-02-22',NULL,380987227538,NULL,2125222672,'1',NULL,0,'','0'),
(3494,NULL,'Плюсква Ірина',NULL,'2019-02-22',NULL,380505126238,NULL,2031998622,'1',NULL,0,'','0'),
(3495,NULL,'Буринюк  Ірина',NULL,'2019-02-22',NULL,380686483395,NULL,1857322932,'1',NULL,0,'','0'),
(3496,NULL,'Попіль Софія',NULL,'2019-02-22',NULL,380981782990,NULL,1436114003,'1',NULL,0,'','0'),
(3497,NULL,'Стратій Оксана',NULL,'2019-02-22',NULL,380509272762,NULL,1698501888,'1',44177,0,'','0'),
(3498,NULL,'Вусата Христина',NULL,'2019-02-22',NULL,380979117867,NULL,2024899602,'1',NULL,0,'','0'),
(3499,NULL,'Палац Андріана',NULL,'2019-02-22',NULL,380971364380,NULL,1796990499,'1',NULL,0,'','0');

INSERT INTO `kontragentu` VALUES 
(3500,NULL,'Ненчин Марія',NULL,'2019-02-23',NULL,380973310023,NULL,1665828875,'1',19929,0,'','0'),
(3501,NULL,'Романишин Уляна',NULL,'2019-02-23',NULL,380965778609,NULL,1842255193,'1',NULL,0,'','0'),
(3502,NULL,'Ковалишин Андріана',NULL,'2019-02-25',NULL,380971357206,NULL,1999382717,'1',NULL,0,'','0'),
(3503,NULL,'Храпа Олександра',NULL,'2019-02-25',NULL,380988904305,NULL,1542647555,'1',NULL,1,'','0'),
(3504,NULL,'Дереворіз Світлана',NULL,'2019-02-25',NULL,380966011942,NULL,1301068156,'1',63361,0,'','0'),
(3505,NULL,'Минда Інна',NULL,'2019-02-25',NULL,380973938349,NULL,1632946959,'1',NULL,0,'','0'),
(3506,NULL,'Мартинюк Юля',NULL,'2019-02-25',NULL,380971708588,NULL,2101998702,'1',NULL,0,'','0'),
(3507,NULL,'Дунчак Наталя',NULL,'2019-02-25',NULL,380987370988,NULL,1144328014,'1',NULL,0,'','0'),
(3508,NULL,'василишин ліля',NULL,'2019-02-26',NULL,380673507509,NULL,1397773763,'1',NULL,0,'','0'),
(3509,NULL,'Свак Валерія',NULL,'2019-02-26',NULL,380667870221,NULL,1294009969,'1',NULL,0,'','0'),
(3510,NULL,'Лісова Вікторія',NULL,'2019-02-27',NULL,380974145239,NULL,1390938810,'1',NULL,0,'','0'),
(3511,NULL,'Домінік Таня',NULL,'2019-02-27','IETFUUS9n05cfNvKcp3X+g==',380684211333,NULL,2045138431,'1',NULL,0,'','0'),
(3512,NULL,'Слоїк Таня',NULL,'2019-02-27',NULL,380975360996,NULL,1293198066,'1',NULL,0,'','0'),
(3513,NULL,'Чихарівська Наталя',NULL,'2019-02-27',NULL,380974037962,NULL,1703015020,'1',NULL,0,'','0'),
(3514,NULL,'Радіо Світлана',NULL,'2019-02-28',NULL,380968531585,NULL,1209845910,'1',NULL,0,'','0'),
(3515,NULL,'Ференс Люба',NULL,'2019-02-28',NULL,380960966551,NULL,1328192685,'1',NULL,0,'','0'),
(3516,NULL,'Майдан Наталя',NULL,'2019-02-28',NULL,380631371164,NULL,2147375264,'1',NULL,0,'','0'),
(3517,NULL,'Мисевич Олександра',NULL,'2019-02-28',NULL,380639643267,NULL,2019789262,'1',NULL,2,'','0'),
(3518,NULL,'Кишкан Світлана',NULL,'2019-02-28',NULL,380987640346,NULL,2101116929,'1',NULL,0,'','0'),
(3519,NULL,'Герчак Люда',NULL,'2019-03-01',NULL,380666743481,NULL,1902014355,'1',NULL,0,'','0'),
(3520,NULL,'Москаль Олена',NULL,'2019-03-01',NULL,380977618728,NULL,1993372390,'1',NULL,0,'','0'),
(3521,NULL,'Герцун Аліна',NULL,'2019-03-01',NULL,380678928656,NULL,1183783040,'1',NULL,0,'','0'),
(3522,NULL,'штиник марія',NULL,'2019-03-01',NULL,380969520366,NULL,1606170652,'1',NULL,0,'','0'),
(3523,NULL,'Попович Юля',NULL,'2019-03-01',NULL,380935772154,NULL,1447811484,'1',NULL,0,'','0'),
(3524,NULL,'Омелько Олександра',NULL,'2019-03-02',NULL,380685144204,NULL,1115434717,'1',NULL,0,'','0'),
(3525,NULL,'Шевчук Христя',NULL,'2019-03-02',NULL,380680248130,NULL,1244805088,'1',NULL,0,'','0'),
(3526,NULL,'Славська Вікторія',NULL,'2019-03-02',NULL,380967547272,NULL,1315785802,'1',NULL,0,'','0'),
(3527,NULL,'Кирилюк люда',NULL,'2019-03-02',NULL,380673506457,NULL,1782368986,'1',NULL,0,'','0'),
(3528,NULL,'Лозінська Галина',NULL,'2019-03-04',NULL,380684241660,NULL,1618069045,'1',NULL,0,'','0'),
(3529,NULL,'Явна Христина',NULL,'2019-03-04',NULL,380986090860,NULL,1470385988,'1',NULL,0,'','0'),
(3530,NULL,'Саран Марія',NULL,'2019-03-04',NULL,380986626929,NULL,1543859890,'1',NULL,0,'','0'),
(3531,NULL,'Кузій Світлана',NULL,'2019-03-04',NULL,380673050480,NULL,1421386489,'1',NULL,0,'','0'),
(3532,NULL,'Клапоущак Оля',NULL,'2019-03-04',NULL,380971417897,NULL,1528496005,'1',38302,0,'','0'),
(3533,NULL,'Харплива Ірина',NULL,'2019-03-04',NULL,380660169923,NULL,1573986348,'1',NULL,0,'','0'),
(3534,NULL,'Нашкольна Іра',NULL,'2019-03-04',NULL,380676703610,NULL,1940689270,'1',27665,0,'','0'),
(3535,NULL,'Добущук Марія',NULL,'2019-03-05',NULL,380976200239,NULL,1713134883,'1',NULL,0,'','0'),
(3536,NULL,'Петраш Юля',NULL,NULL,NULL,380966884787,NULL,1115964608,'1',NULL,0,'','0'),
(3537,NULL,'Бойчук Ліля',NULL,'2019-03-05',NULL,380969855056,NULL,1535020845,'1',NULL,0,'','0'),
(3538,NULL,'Чикалюк Христина',NULL,'2019-03-05',NULL,380683462973,NULL,1275563621,'1',NULL,0,'','0'),
(3539,NULL,'моспан валєра',NULL,'2019-03-06',NULL,380981756363,NULL,1835692862,'1',NULL,0,'','0'),
(3540,NULL,'Вакалюк Оксана',NULL,NULL,NULL,380672603012,NULL,1292271989,'1',NULL,0,'','0'),
(3541,NULL,'Островерха Олександра',NULL,'2019-03-06',NULL,380679196312,NULL,1981831373,'1',NULL,0,'','0'),
(3542,NULL,'Караульна Каріна',NULL,'2019-03-06',NULL,380660488096,NULL,1923812623,'1',26385,0,'','0'),
(3543,0158,'Шлапак Іра',NULL,NULL,NULL,380962706413,NULL,1179503286,'1',NULL,0,'','0'),
(3544,NULL,'Хомяк Інна',NULL,'2019-03-07',NULL,380681759267,NULL,1188883557,'1',NULL,0,'','0'),
(3545,NULL,'дика наталя',NULL,'2019-03-07',NULL,380973837395,NULL,2087725872,'1',NULL,0,'','0'),
(3546,NULL,' 	Мельник наталя',NULL,'2019-03-07',NULL,380671327883,NULL,1811324200,'1',NULL,0,'','0'),
(3547,NULL,'Чепіга Оксана',NULL,'2019-03-07',NULL,380673542657,NULL,1805299495,'1',NULL,0,'','0'),
(3548,NULL,'Мандзяк Діана',NULL,NULL,NULL,380972553045,NULL,1347120145,'1',NULL,0,'','0'),
(3549,NULL,'хованець галя',NULL,'2019-03-08',NULL,380964638001,NULL,1342560194,'1',NULL,0,'','0'),
(3550,NULL,'Тинкальк Євгенія',NULL,'2019-03-09',NULL,380986027808,NULL,1559081643,'1',NULL,0,'','0'),
(3551,NULL,'Шпортак Таня',NULL,'2019-03-11',NULL,380931378527,NULL,2002989730,'1',NULL,0,'','0'),
(3552,NULL,'Вівчар Марта',NULL,'2019-03-11',NULL,380988580825,NULL,1116034087,'1',NULL,0,'','0'),
(3553,NULL,'Галущак Люда',NULL,'2019-03-11',NULL,380979214373,NULL,1500843233,'1',NULL,0,'','0'),
(3554,NULL,'Поліщук Діана',NULL,'2019-03-11',NULL,380967075159,NULL,1806001430,'1',NULL,0,'','0'),
(3555,NULL,'Самгайська Майя',NULL,NULL,NULL,380674512139,NULL,1366451520,'1',NULL,0,'','0'),
(3556,NULL,'Ясінський Микола',NULL,'2019-03-11',NULL,380506030826,NULL,1747424009,'1',NULL,0,'','0'),
(3557,NULL,'Чухрій Галина',NULL,'2019-03-12',NULL,380505344232,NULL,1604359888,'1',NULL,0,'','0'),
(3558,NULL,'Чухрій Олеся',NULL,NULL,NULL,380985453506,NULL,1174860543,'1',NULL,0,'','0'),
(3559,NULL,'Гриньків Люба',NULL,'2019-03-12',NULL,380688232586,NULL,2144699053,'1',NULL,2,'','0'),
(3560,NULL,'Білінська Галина',NULL,'2019-03-12',NULL,380973340856,NULL,1227553602,'1',NULL,0,'','0'),
(3561,NULL,'Яцук Леся',NULL,NULL,NULL,380986467632,NULL,2046217588,'1',NULL,0,'','0'),
(3562,NULL,'Николюк Олег',NULL,'2019-03-13',NULL,380689339642,NULL,2141858614,'1',NULL,0,'','0'),
(3563,NULL,'Баюк лєна',NULL,'2019-03-13',NULL,380685308969,NULL,1177487509,'1',NULL,0,'','0'),
(3564,NULL,'Янч Вероніка',NULL,'2019-03-14','LtMqLA0WPnjHS7Cnmz4TBg==',380687884151,NULL,1492509760,'1',21013,0,'','0'),
(3565,NULL,'Цапяк Марія',NULL,'2019-03-14',NULL,380969860659,NULL,1928267544,'1',NULL,1,'','0'),
(3566,NULL,'Шпортак Оксана',NULL,'2019-03-14',NULL,380976190978,NULL,1950092484,'1',NULL,0,'','0'),
(3567,NULL,'Байталюк Галина',NULL,'2019-03-14',NULL,380966572717,NULL,1603474233,'1',NULL,0,'','0'),
(3568,NULL,'Олійник Оля',NULL,'2019-03-14',NULL,380961267876,NULL,1175877530,'1',NULL,0,'','0'),
(3569,NULL,'Козіковська Маряна',NULL,'2019-03-14',NULL,380971494929,NULL,1843223320,'1',NULL,0,'','0'),
(3570,NULL,'Вербіцька Ілона',NULL,NULL,NULL,380686929739,NULL,1253810764,'',NULL,0,'','0'),
(3571,NULL,'Палагнюк Ірина',NULL,'2019-03-15',NULL,380680272711,NULL,2136026510,'1',NULL,0,'','0'),
(3572,NULL,'Пожарнюк Христина',NULL,'2019-03-15',NULL,380966396153,NULL,1954172231,'1',NULL,0,'','0'),
(3573,NULL,'Добрянська Любов',NULL,'2019-03-15',NULL,380962797623,NULL,1200354670,'1',54411,0,'','0'),
(3574,NULL,'наталя адмін',NULL,NULL,'eU1eEoNtdWKlRTbkkC7zIA==',380960695271,NULL,1128340594,'',64080,0,'','0'),
(3575,NULL,'Якибчук Леся',NULL,'2019-03-15',NULL,380689123915,NULL,1438228485,'1',NULL,0,'','0'),
(3576,NULL,'Гулей Марія',NULL,'2019-03-15',NULL,380987552097,NULL,2044507128,'1',NULL,1,'','0'),
(3577,NULL,'Голуб Світлана',NULL,'2019-03-16',NULL,380974959068,NULL,1114968120,'1',NULL,0,'','0'),
(3578,NULL,'Звірик Мирослава',NULL,'2019-03-16',NULL,380964654681,NULL,1420766609,'1',NULL,0,'','0'),
(3579,NULL,' Ткач Марія',NULL,'2019-03-16',NULL,380688696332,NULL,2016878749,'1',NULL,0,'','0'),
(3580,NULL,'Пастухевич Катя',NULL,'2019-03-18',NULL,380686482536,NULL,1798046348,'1',NULL,0,'','0'),
(3581,NULL,'Біла Наталя',NULL,'2019-03-18',NULL,380668306605,NULL,1145593043,'1',NULL,0,'','0'),
(3582,NULL,'Яківців Оля',NULL,'2019-03-18',NULL,380689696018,NULL,1992561115,'1',NULL,0,'','0'),
(3583,NULL,'Сидор Надя',NULL,'2019-03-18',NULL,380683273411,NULL,1829804678,'1',NULL,0,'','0'),
(3584,NULL,'Петрашик Маряна',NULL,NULL,NULL,380979702127,NULL,1463483094,'1',NULL,0,'','0'),
(3585,NULL,'Климчук Аліна',NULL,'2019-03-18',NULL,380971463484,NULL,1183816290,'1',NULL,0,'','0'),
(3586,NULL,'Канінець Христина',NULL,'2019-03-18',NULL,380961383349,NULL,1354017397,'1',NULL,0,'','0'),
(3587,NULL,'Голуб Ганна',NULL,'2019-03-18',NULL,380967709611,NULL,2035758749,'1',NULL,0,'','0'),
(3588,NULL,'Яківчук Маряна',NULL,'2019-03-18',NULL,380983285385,NULL,1458284278,'1',NULL,0,'','0'),
(3589,NULL,'Галушка Світлана',NULL,'2019-03-19',NULL,380671742373,NULL,1629654154,'1',NULL,0,'','0'),
(3590,NULL,'Борис Ілона',NULL,'2019-03-19',NULL,380969890500,NULL,1339050335,'1',NULL,0,'','0'),
(3591,NULL,'Марчиха Світлана',NULL,'2019-03-19',NULL,380679834718,NULL,1917775006,'1',NULL,0,'','0'),
(3592,NULL,'Андраш Таня',NULL,'2019-03-19',NULL,380687934819,NULL,1732206097,'1',NULL,0,'','0'),
(3593,NULL,'Павлюк Світлана',NULL,'2019-03-20',NULL,380984945726,NULL,1217563108,'1',NULL,0,'','0'),
(3594,NULL,'Галущак Марія',NULL,'2019-03-20',NULL,380969686675,NULL,1403342176,'1',NULL,0,'','0'),
(3595,NULL,'Камінська Олена',NULL,'2019-03-20',NULL,380666743893,NULL,1467014151,'1',NULL,0,'','0'),
(3596,NULL,'Горбова Руслана',NULL,'2019-03-20',NULL,380961267911,NULL,1139696295,'1',NULL,0,'','0'),
(3597,NULL,'Петрів Оля',NULL,'2019-03-20',NULL,380682855254,NULL,1128521438,'1',NULL,0,'','0'),
(3598,NULL,'Шимко Діана',NULL,'2019-03-21',NULL,380685127289,NULL,1409851931,'1',NULL,0,'','0'),
(3599,NULL,'Герба Маряна',NULL,'2019-03-21',NULL,380677095467,NULL,1723007148,'1',NULL,0,'','0'),
(3601,NULL,'Кардинал Оксана',NULL,'2019-03-21',NULL,380979040725,NULL,1135561113,'1',NULL,0,'','0'),
(3602,NULL,'Сапіщук Настя',NULL,'2019-03-21',NULL,380973385956,NULL,1905674676,'1',NULL,0,'','0'),
(3603,NULL,'Ваврушко настя',NULL,NULL,NULL,380668645188,NULL,2139631871,'1',NULL,0,'','0'),
(3604,NULL,'боднарук наталя',NULL,'2019-03-21',NULL,380986513332,NULL,1630233373,'1',NULL,0,'','0'),
(3605,NULL,'Кузьо Христина',NULL,'2019-03-22','xOfIeIKQML9UwldcPfofJw==',380991336704,NULL,1732430536,'1',64997,0,'','0'),
(3606,NULL,'Місько Христина',NULL,NULL,NULL,380984650386,NULL,1796645632,'1',NULL,0,'','0'),
(3607,NULL,'Кравець Анжела',NULL,'2019-03-22',NULL,380984589255,NULL,1664550797,'1',63042,0,'','0'),
(3608,NULL,'Байрак Олена',NULL,'2019-03-22',NULL,380984005237,NULL,1469584920,'1',NULL,0,'','0'),
(3609,NULL,'мазяр оксана',NULL,'2019-03-23',NULL,380678467516,NULL,1454940726,'1',NULL,0,'','0'),
(3610,NULL,'Яремчук Віта',NULL,'2019-03-23',NULL,380967039063,NULL,1381076488,'1',NULL,0,'','0'),
(3611,NULL,'Бедрик катя',NULL,'2019-03-23','spixMRLTcwG2UNMQcZsxrg==',380987258277,NULL,1958057550,'1',45374,2,'','0'),
(3612,NULL,'Шмегельська Анастасія',NULL,'2019-03-23',NULL,380971945408,NULL,1849787049,'1',NULL,0,'','0'),
(3613,NULL,'Нога Руслана',NULL,'2019-03-25',NULL,380966749616,NULL,1773460160,'1',NULL,0,'','0'),
(3614,NULL,'Куць ганна',NULL,'2019-03-25',NULL,380673505583,NULL,1773821446,'1',NULL,0,'','0'),
(3615,NULL,'Хованець Христина',NULL,'2019-03-25',NULL,380971137971,NULL,2095583914,'1',NULL,0,'','0'),
(3616,NULL,'Курилюк Світлана',NULL,'2019-03-25',NULL,380966083632,NULL,1815865257,'1',NULL,0,'','0'),
(3617,NULL,'Данедасюк Христина',NULL,'2019-03-25',NULL,380966420126,NULL,1402654421,'1',NULL,0,'','0'),
(3618,NULL,'Совяк Галина',NULL,'2019-03-26',NULL,380978538407,NULL,1563998827,'1',NULL,0,'','0'),
(3619,NULL,'Смеречинська Васелина',NULL,'2019-03-26',NULL,380972570673,NULL,1367983838,'1',NULL,0,'','0'),
(3620,NULL,'Совяк Оля',NULL,'2019-03-26','LihOQBBr5A8f7awBleRMLg==',380976591548,NULL,1825525225,'1',41957,1,'','0'),
(3621,NULL,'Гранківська Ганна',NULL,'2019-03-26',NULL,380680264654,NULL,1543448425,'1',NULL,0,'','0'),
(3622,NULL,'Фик Оксана',NULL,'2019-03-26',NULL,380680688377,NULL,1634482681,'1',NULL,0,'','0'),
(3623,NULL,'Грицинюк Оксана',NULL,'2019-03-27',NULL,380969317575,NULL,1972203101,'1',NULL,0,'','0'),
(3624,NULL,'Бойчук Наталя',NULL,'2019-03-27',NULL,380665448583,NULL,1948779051,'1',NULL,0,'','0'),
(3625,NULL,'Джулінська Христина',NULL,'2019-03-27',NULL,380967567557,NULL,1889162109,'1',NULL,0,'','0'),
(3626,NULL,'Пожернюк Оксана',NULL,'2019-03-27',NULL,380960392794,NULL,1963103342,'1',NULL,0,'','0'),
(3627,NULL,'Гбур Оля',NULL,'2019-03-28','39QA/S8+zyovYHyCu565lw==',380674092853,NULL,1283733927,'1',NULL,1,'','0'),
(3628,NULL,'Куляк сніжана',NULL,NULL,NULL,380971352206,NULL,1830051177,'1',NULL,0,'','0'),
(3629,NULL,'Квітчук Леся',NULL,'2019-03-29',NULL,380660458848,NULL,1580499321,'1',NULL,0,'','0'),
(3630,NULL,'короп анастасія',NULL,'2019-03-29',NULL,380930734371,NULL,1483032356,'1',NULL,0,'','0'),
(3631,NULL,'Нагуляк Олеся',NULL,'2019-03-29',NULL,380672908089,NULL,2038884117,'1',NULL,0,'','0'),
(3632,NULL,'журба оксана',NULL,'2019-03-29',NULL,380688177891,NULL,1808344909,'1',NULL,0,'','0'),
(3633,NULL,'Чвиль Марія',NULL,'2019-03-29',NULL,380988067439,NULL,2013838439,'1',60831,0,'','0'),
(3634,NULL,'Грещук Іра',NULL,'2019-03-29',NULL,380966653442,NULL,2128913575,'1',NULL,0,'','0'),
(3635,NULL,'Литвин Ліна',NULL,'2019-03-29',NULL,380971004509,NULL,1420132235,'1',NULL,0,'','0'),
(3636,NULL,'Лозінська Марія',NULL,'2019-03-29',NULL,380971705076,NULL,1826626799,'1',NULL,1,'','0'),
(3637,NULL,'Смірнова Наталя',NULL,'2019-03-29',NULL,380974130844,NULL,1422502239,'1',NULL,0,'','0'),
(3638,NULL,'Дерій Віка',NULL,'2019-03-30',NULL,380983544050,NULL,1544064876,'1',NULL,0,'','0'),
(3639,NULL,'Бандрівчак Марія',NULL,'2019-03-30',NULL,380682806412,NULL,1219811547,'1',NULL,0,'','0'),
(3640,NULL,'Штуник Андріана',NULL,'2019-03-30',NULL,380971465628,NULL,1720872731,'1',NULL,0,'','0'),
(3641,NULL,'Неделяєва Олександра',NULL,'2019-04-01',NULL,380987170470,NULL,1585732876,'1',NULL,0,'','0'),
(3642,NULL,'Палиць Іра',NULL,'2019-04-01',NULL,380986413916,NULL,1385186207,'1',NULL,0,'','0'),
(3643,NULL,'Юнко Віка',NULL,'2019-04-01',NULL,380978260872,NULL,1205744140,'1',NULL,0,'','0'),
(3644,NULL,'Олійник Зоряна',NULL,'2019-04-01',NULL,380635361232,NULL,1266101497,'1',NULL,0,'','0'),
(3645,NULL,'Нагірна іра',NULL,'2019-04-01',NULL,380673506574,NULL,1576868818,'1',NULL,0,'','0'),
(3646,NULL,'Матійчук Галина',NULL,'2019-04-02',NULL,380671331878,NULL,1259794929,'1',NULL,0,'','0'),
(3647,NULL,'Семен Марія',NULL,'2019-04-02',NULL,380962753929,NULL,1717744761,'1',NULL,1,'','0'),
(3648,NULL,'Кравченко марія',NULL,'2019-04-02',NULL,380686638278,NULL,2141418719,'1',NULL,0,'','0'),
(3649,NULL,'Кутень Наталя',NULL,'2019-04-02',NULL,380667022866,NULL,1112249549,'1',NULL,0,'','0'),
(3650,NULL,'Чухрій Галя',NULL,'2019-04-03',NULL,380684079001,NULL,1714357263,'1',NULL,0,'','0'),
(3651,NULL,'Волошин Альона',NULL,'2019-04-03',NULL,380973788180,NULL,1544659685,'1',NULL,0,'','0'),
(3652,NULL,'Лукіянець Оксана',NULL,'2019-04-03',NULL,380971320645,NULL,1581619368,'1',NULL,0,'','0'),
(3653,NULL,'Шпортак Діана',NULL,'2019-04-03',NULL,380687768104,NULL,1411052284,'1',NULL,0,'','0'),
(3654,NULL,'Харевич Лариса',NULL,'2019-04-03',NULL,380970343775,NULL,1589110145,'1',NULL,1,'','0'),
(3655,NULL,'Басіста Надя',NULL,'2019-04-03',NULL,380980360429,NULL,1908324272,'1',NULL,0,'','0'),
(3656,NULL,'Свистун марія',NULL,'2019-04-03',NULL,380666111715,NULL,1885629282,'1',NULL,0,'','0'),
(3657,NULL,'Кумигіна Аліна',NULL,'2019-04-04',NULL,380688997119,NULL,1979004427,'1',NULL,0,'','0'),
(3658,NULL,'Комарчук Оксана',NULL,'2019-04-04',NULL,380962243742,NULL,1408171876,'1',NULL,0,'','0'),
(3659,NULL,'Ляхоцька Оля',NULL,'2019-04-04',NULL,380971540307,NULL,1906519019,'1',NULL,0,'','0'),
(3660,NULL,'Чернецька Віка',NULL,'2019-04-05',NULL,380966209642,NULL,1375145389,'1',NULL,0,'','0'),
(3661,NULL,'Казакова Маша',NULL,'2019-04-05',NULL,380680243491,NULL,1504513127,'1',63806,0,'','0'),
(3662,NULL,'Палиця Любов',NULL,'2019-04-05',NULL,380688318229,NULL,2137971085,'1',NULL,0,'','0'),
(3663,NULL,'Бобик таня',NULL,'2019-04-05',NULL,380674583895,NULL,2006794449,'1',NULL,0,'','0'),
(3664,NULL,'Вавілова Олена',NULL,'2019-04-05',NULL,380683875935,NULL,1780427280,'1',NULL,0,'','0'),
(3665,NULL,'Жмуд Іванна',NULL,'2019-04-06',NULL,380988142327,NULL,1663667373,'1',NULL,0,'','0'),
(3666,NULL,'Стець Таня',NULL,'2019-04-06',NULL,380965892594,NULL,1212129141,'1',50806,0,'','0'),
(3667,NULL,'Дачишин Ілона',NULL,'2019-04-06',NULL,380973488474,NULL,1748669913,'1',NULL,0,'','0'),
(3668,NULL,'Мазурик Юля',NULL,'2019-04-08',NULL,380689900324,NULL,1817739553,'1',NULL,0,'','0'),
(3669,NULL,'Мороз Оксана',NULL,'2019-04-08',NULL,380971870953,NULL,1812549320,'1',NULL,0,'','0'),
(3670,NULL,'Добощук Олеся',NULL,'2019-04-08',NULL,380681611029,NULL,1280533663,'1',NULL,0,'','0'),
(3671,NULL,'Скрипник оксана',NULL,'2019-04-08',NULL,380960753216,NULL,1374708926,'1',NULL,1,'','0'),
(3672,NULL,'Івануць Оля',NULL,'2019-04-08',NULL,380977126288,NULL,1140123424,'1',NULL,0,'','0'),
(3673,NULL,'Скорець Інна',NULL,NULL,NULL,380978026912,NULL,1119569366,'1',NULL,0,'','0'),
(3674,NULL,'Хомко Зоряна',NULL,'2019-04-09',NULL,380681515341,NULL,2109617844,'1',NULL,0,'','0'),
(3675,NULL,'Думна Оля',NULL,'2019-04-09',NULL,380686276823,NULL,1617948372,'1',NULL,0,'','0'),
(3676,NULL,'Лунів Оксана',NULL,'2019-04-09',NULL,380969570921,NULL,1661725435,'1',NULL,0,'','0'),
(3677,NULL,'Голод Наталя',NULL,'2019-04-09',NULL,380687708405,NULL,2145193347,'1',NULL,0,'','0'),
(3678,NULL,'Даник Оля',NULL,'2019-04-09',NULL,380680463262,NULL,1173165874,'1',NULL,0,'','0'),
(3679,NULL,'Трущ Любов',NULL,'2019-04-09',NULL,380677918573,NULL,1253783044,'1',NULL,0,'','0'),
(3680,NULL,'Прухніцька Діана',NULL,'2019-04-09',NULL,380970526837,NULL,1452801307,'1',NULL,0,'','0'),
(3681,NULL,'рудик таня',NULL,'2019-04-09',NULL,380971757823,NULL,1303646104,'1',NULL,1,'','0'),
(3682,NULL,'Міщанчук Надія',NULL,'2019-04-10',NULL,380988232446,NULL,1951868714,'1',NULL,0,'','0'),
(3683,NULL,'міщанчук оля',NULL,'2019-04-10',NULL,380988728766,NULL,2058255691,'1',NULL,0,'','0'),
(3684,NULL,'Міщанчук Оксана',NULL,'2019-04-10',NULL,380974285728,NULL,1490721403,'1',NULL,0,'','0'),
(3685,NULL,'Василенко іванна',NULL,'2019-04-10','USFO7Ql88q5WUlVGqug5hg==',380972051324,NULL,1299184744,'1',37587,1,'','0'),
(3686,NULL,'Білявська юля',NULL,'2019-04-10',NULL,380686649808,NULL,1365951704,'1',NULL,1,'','0'),
(3687,NULL,'Андрущак Аня',NULL,'2019-04-10',NULL,380963624911,NULL,1152092236,'1',NULL,0,'','0'),
(3688,NULL,'Попіль Аня',NULL,'2019-04-11',NULL,380977550377,NULL,1659667376,'1',NULL,0,'','0'),
(3689,NULL,'Чикалюк Світлана',NULL,'2019-04-11',NULL,380683352681,NULL,1568664663,'1',NULL,0,'','0'),
(3690,NULL,'ткаченко олеся',NULL,'2019-04-11',NULL,380960786038,NULL,1403110506,'1',NULL,0,'','0'),
(3691,NULL,'Величко Лєна',NULL,'2019-04-11',NULL,380506114005,NULL,1910869722,'1',NULL,0,'','0'),
(3692,NULL,'Юрків Оксана',NULL,'2019-04-11',NULL,380984679034,NULL,1892180811,'1',NULL,0,'','0'),
(3693,NULL,'Грушка діана',NULL,'2019-04-11',NULL,380978428488,NULL,2042325026,'1',NULL,0,'','0'),
(3694,NULL,'Юрків Уляна',NULL,'2019-04-11',NULL,380974435970,NULL,1611469490,'1',NULL,0,'','0'),
(3695,NULL,'Фучило галя',NULL,'2019-04-11',NULL,380986165738,NULL,1858740396,'1',NULL,0,'','0'),
(3696,NULL,'яценко алла',NULL,'2019-04-12',NULL,380992027247,NULL,1555490444,'1',NULL,0,'','0'),
(3697,NULL,'Кутир ліля',NULL,'2019-04-12',NULL,380971314550,NULL,1368031741,'1',NULL,0,'','0'),
(3698,NULL,'Сименко Ліля',NULL,NULL,NULL,380987657145,NULL,1717713243,'1',NULL,0,'','0'),
(3699,NULL,'Сименко Надя',NULL,NULL,NULL,NULL,NULL,1873724893,'1',NULL,0,'','1'),
(3700,NULL,'слободян таня',NULL,'2019-04-12',NULL,380971128903,380971128903,1150436825,'1',NULL,0,'','0'),
(3701,NULL,'Данилевич Олена',NULL,'2019-04-12',NULL,380968375713,NULL,1532731633,'1',NULL,0,'','0'),
(3702,NULL,'Тарашів Софія',NULL,'2019-04-12',NULL,380999662599,NULL,1908888013,'1',NULL,0,'','0'),
(3703,NULL,'черевик ірина',NULL,'2019-04-14',NULL,380979728670,NULL,1340085397,'1',NULL,0,'','0'),
(3704,NULL,'Вонсович Маряна',NULL,'2019-04-15',NULL,380986193255,NULL,2096538165,'1',NULL,0,'','0'),
(3705,NULL,'Тухлінович Оля',NULL,'2019-04-15',NULL,380970890302,NULL,1529432568,'1',NULL,0,'','0'),
(3706,NULL,'Майданик Марія',NULL,'2019-04-15',NULL,380685067969,NULL,1215856382,'1',NULL,0,'','0'),
(3707,NULL,'Колодій Олена',NULL,'2019-04-15',NULL,380986316111,NULL,1481860773,'1',NULL,0,'','0'),
(3708,NULL,'Бандура Ірина',NULL,'2019-04-15',NULL,380983042232,NULL,1469690662,'1',NULL,0,'','0'),
(3709,NULL,'Слободян Іванна',NULL,NULL,NULL,380979985061,NULL,1967616416,'1',NULL,0,'','0'),
(3710,NULL,'Лазарчук Надя',NULL,'2019-04-15',NULL,380978721482,NULL,1826353062,'1',NULL,0,'','0'),
(3711,NULL,'Гошко Юля',NULL,'2019-04-17',NULL,380686057627,NULL,1881620552,'1',NULL,0,'','0'),
(3712,NULL,'Хомишин оля',NULL,'2019-04-17',NULL,380688060108,NULL,1255955829,'1',NULL,0,'','0'),
(3713,NULL,'Бойко Світлана',NULL,'2019-04-17',NULL,380686952048,NULL,1506441032,'1',NULL,0,'','0'),
(3714,NULL,'Топоровська сніжана',NULL,'2019-04-18',NULL,380984622034,NULL,1780542349,'1',NULL,0,'','0'),
(3715,NULL,'Саніцька Світлана',NULL,'2019-04-18',NULL,380984229469,NULL,1566995350,'1',NULL,0,'','0'),
(3716,NULL,'Вівчарик Ірина',NULL,'2019-04-19',NULL,380960504060,NULL,1487914186,'1',NULL,0,'','0'),
(3717,NULL,'Дюк Діана',NULL,'2019-04-19',NULL,380987256328,NULL,1435767571,'1',NULL,0,'','0'),
(3718,NULL,'Цурганова Віка',NULL,'2019-04-19',NULL,380675975596,NULL,1406500479,'1',NULL,0,'','0'),
(3719,NULL,'Гуляк Наталя',NULL,'2019-04-19',NULL,380960274492,NULL,1249149986,'1',NULL,0,'','0'),
(3720,NULL,'Садонів Марія',NULL,'2019-04-19',NULL,380968952573,NULL,1584153711,'1',NULL,0,'','0'),
(3721,NULL,'Яремків Наталя',NULL,NULL,NULL,380671517607,NULL,1452586210,'1',24582,0,'','0'),
(3722,NULL,'остафій марія',NULL,'2019-04-22',NULL,380666400395,NULL,1338633056,'1',NULL,0,'','0'),
(3723,NULL,'воробець надя',NULL,NULL,NULL,380977740786,NULL,1150587822,'1',NULL,0,'','0'),
(3724,NULL,'чулей наталя',NULL,'2019-04-22',NULL,380966644712,NULL,1293276545,'1',NULL,0,'','0'),
(3725,NULL,'Біла Оксана',NULL,'2019-04-22',NULL,380979041793,NULL,1365577225,'1',NULL,0,'','0'),
(3726,NULL,'Федорків Світлана',NULL,'2019-04-23',NULL,380975991253,NULL,1355804754,'1',NULL,0,'','0'),
(3727,NULL,'Андрійчук Аліна',NULL,'2019-04-23',NULL,380973471565,NULL,1459386771,'1',NULL,1,'','0'),
(3728,NULL,'Коханицький микола',NULL,'2019-04-23',NULL,380684100802,NULL,1992845209,'1',NULL,0,'','0'),
(3729,NULL,'Греськів Христина',NULL,'2019-04-24',NULL,380978695432,NULL,2123755148,'1',NULL,0,'','0'),
(3730,NULL,'Літовченко Марія',NULL,'2019-04-24',NULL,380966878336,NULL,2027653558,'1',NULL,0,'','0'),
(3731,NULL,'Кравченко Даша',NULL,'2019-04-25',NULL,380990899251,NULL,1718536480,'1',NULL,0,'','0'),
(3732,NULL,'Ониськів Іван',NULL,'2019-04-27',NULL,380984622112,NULL,1242318576,'1',NULL,0,'','0'),
(3733,NULL,'Гадзиський Саша',NULL,'2019-04-27',NULL,380688343154,NULL,1708358176,'1',NULL,0,'','0'),
(3734,NULL,'Безпалько Христина',NULL,'2019-04-27',NULL,380672936670,NULL,1146210530,'1',NULL,0,'','0'),
(3735,NULL,'соковська оля',NULL,'2019-05-01',NULL,380967293805,NULL,2117079022,'1',45181,1,'','0'),
(3736,NULL,'Дожук Таня',NULL,'2019-05-01',NULL,380955363475,NULL,1702913098,'1',NULL,0,'','0'),
(3737,NULL,'Гриньків Марія',NULL,'2019-05-01',NULL,380980027948,NULL,1693598758,'1',NULL,0,'','0'),
(3738,NULL,'козак івана',NULL,'2019-05-01',NULL,380683010811,NULL,1461133982,'1',NULL,0,'','0'),
(3739,NULL,'Гоцко інна',NULL,'2019-05-01',NULL,380939715255,NULL,1709441767,'1',NULL,0,'','0'),
(3740,NULL,'Лисай Ірина',NULL,'2019-05-01',NULL,380682888127,NULL,1193913088,'1',NULL,0,'','0'),
(3741,NULL,'Бодз Таня',NULL,'2019-05-02',NULL,380673451541,NULL,1174522687,'1',NULL,0,'','0'),
(3742,NULL,'Гевко Оля',NULL,'2019-05-02',NULL,NULL,NULL,1741701327,'1',NULL,0,'','0'),
(3743,NULL,'Калинюк Роксолана',NULL,'2019-05-02','lXQMU1eh1ajujr/lwl7/VQ==',380980862787,NULL,1808635265,'1',60507,0,'','0'),
(3744,NULL,'Захарчишин Марія',NULL,NULL,NULL,380507186620,NULL,1136308250,'1',NULL,0,'','0'),
(3745,NULL,'Ігнацевич Уляна',NULL,NULL,NULL,380679915520,NULL,1201164922,'1',NULL,0,'','0'),
(3746,NULL,'давидовська юлія',NULL,'2019-05-04',NULL,380983022345,NULL,2027844440,'1',NULL,0,'','0'),
(3747,NULL,'Хомяк Галина',NULL,'2019-05-06',NULL,380970377580,NULL,1918758717,'1',NULL,0,'','0'),
(3748,NULL,'Кушнір Сніжана',NULL,'2019-05-06',NULL,380985302361,NULL,1611495120,'1',NULL,0,'','0'),
(3749,NULL,'Процишин Оля',NULL,'2019-05-06',NULL,380979247885,NULL,1372152514,'1',NULL,0,'','0'),
(3750,NULL,'Опихана Христина',NULL,'2019-05-06',NULL,380684219191,NULL,1186021071,'1',16497,0,'','0'),
(3751,NULL,'Смівка Людмила',NULL,'2019-05-06',NULL,380965061910,NULL,1627243394,'1',NULL,0,'','0'),
(3752,NULL,'іванська оксана',NULL,'2019-05-06',NULL,380681249693,NULL,1983172175,'1',NULL,0,'','0'),
(3753,NULL,'Волоська Ганна',NULL,'2019-05-06',NULL,380975757352,NULL,1548263042,'1',NULL,0,'','0'),
(3754,NULL,'Бартків Марія',NULL,'2019-05-06',NULL,380989940613,NULL,1402608591,'1',15575,0,'','0'),
(3755,NULL,'Мельник Олександра',NULL,'2019-05-06',NULL,380989738704,NULL,1716097814,'1',NULL,0,'','0'),
(3756,NULL,'Мишковська Маряна',NULL,'2019-05-06',NULL,380956380153,NULL,1446070672,'1',NULL,0,'','0'),
(3757,NULL,'починок оксана',NULL,'2019-05-06',NULL,380684507797,NULL,1790313838,'1',NULL,0,'','0'),
(3758,NULL,'Галик Марія',NULL,'2019-05-06',NULL,380689764571,NULL,1911603988,'1',NULL,0,'','0'),
(3759,NULL,'кондраєва галя',NULL,'2019-05-06',NULL,380969942133,NULL,1972228832,'1',55107,0,'','0'),
(3760,NULL,'лазюк таня',NULL,'2019-05-06',NULL,380687675827,NULL,2114883580,'1',NULL,0,'','0'),
(3761,NULL,'Матвіїв Вікторія',NULL,'2019-05-06',NULL,380989641780,NULL,1965352240,'1',NULL,0,'','0'),
(3762,NULL,'Висовська Оксана',NULL,'2019-05-07',NULL,380987038454,NULL,1476723509,'1',NULL,0,'','0'),
(3763,NULL,'Симчак Віка',NULL,NULL,NULL,380985814638,NULL,1469572274,'1',NULL,0,'','0'),
(3764,NULL,'Стахів Юля',NULL,'2019-05-08',NULL,380960959284,NULL,1262533866,'1',NULL,0,'','0'),
(3765,NULL,'Лебідь Леся',NULL,'2019-05-08',NULL,380979032761,NULL,2011675892,'1',NULL,0,'','0'),
(3766,NULL,'Слободян юля',NULL,NULL,NULL,380978685926,NULL,1879933313,'1',12848,0,'','0'),
(3767,NULL,'Матійчик Люба',NULL,'2019-05-08',NULL,380980862246,NULL,2132237381,'1',NULL,0,'','0'),
(3768,NULL,'Миронів Іванка',NULL,'2019-05-08',NULL,380686801256,NULL,1768273960,'1',NULL,0,'','0'),
(3769,NULL,'Чикалюк Оксана',NULL,'2019-05-08',NULL,380501047457,NULL,1259513654,'1',NULL,0,'','0'),
(3770,NULL,'Денис Вікторія',NULL,'2019-05-09',NULL,380983775542,NULL,1405075811,'1',NULL,1,'','0'),
(3771,NULL,'Пісяк Світлана',NULL,'2019-05-09',NULL,380965736701,NULL,1564566982,'1',NULL,0,'','0'),
(3772,NULL,'марена надя',NULL,'2019-05-09',NULL,380963373407,NULL,1227343357,'1',NULL,0,'','0'),
(3773,NULL,'Крива Наталя',NULL,'2019-05-09',NULL,380683365356,NULL,1712781154,'1',NULL,0,'','0'),
(3774,NULL,'Стецько Люда',NULL,'2019-05-09',NULL,380973186948,NULL,1247487242,'1',NULL,0,'','0'),
(3775,NULL,'Шастків Таня',NULL,'2019-05-09',NULL,380961782628,NULL,1185173155,'1',NULL,1,'','0'),
(3776,NULL,'Малимука Юля',NULL,'2019-05-09',NULL,380961436953,NULL,1653499386,'1',NULL,0,'','0'),
(3777,NULL,'Тимчій Настя',NULL,NULL,NULL,380967584567,NULL,1283634237,'1',22843,0,'','0'),
(3778,NULL,'Герчак Галина',NULL,'2019-05-10',NULL,380686469190,NULL,1260688745,'1',NULL,0,'','0'),
(3779,NULL,'Зміяк Марія',NULL,NULL,NULL,380968677664,NULL,1705199122,'1',50452,0,'','0'),
(3780,NULL,'Сенюк Дмитро',NULL,'2019-05-10',NULL,380502019224,NULL,1774050835,'1',NULL,0,'','0'),
(3781,NULL,'Іванців Настя',NULL,'2019-05-13',NULL,380669603539,NULL,1532962799,'1',NULL,1,'','0'),
(3782,NULL,'Гонта Христина',NULL,'2019-05-13',NULL,380961401903,NULL,1450264143,'1',NULL,0,'','0'),
(3783,NULL,'Витрикуш Віка',NULL,'2019-05-13',NULL,380979465757,NULL,1252999510,'1',NULL,2,'','0'),
(3784,NULL,'Обліжок Світлана',NULL,'2019-05-13',NULL,380683184187,NULL,2017269409,'1',NULL,0,'','0'),
(3785,NULL,'пара',NULL,'2019-05-13',NULL,NULL,NULL,1487082689,'1',NULL,0,'','0'),
(3786,NULL,'павлик настя',NULL,'2019-05-13',NULL,380989553844,NULL,2092055105,'1',NULL,0,'','0'),
(3787,NULL,'Гевко Таня',NULL,'2019-05-13',NULL,380982624281,NULL,2139885426,'1',NULL,0,'','0'),
(3788,NULL,'Сенишина Наталя',NULL,'2019-05-13',NULL,380687619981,NULL,1279429080,'1',NULL,0,'','0'),
(3789,NULL,'Петльована Таня',NULL,'2019-05-13',NULL,380988353405,NULL,1671141790,'1',NULL,1,'','0'),
(3790,NULL,'Ястремська Оксана',NULL,'2019-05-13',NULL,380688442606,NULL,1604354513,'1',NULL,0,'','0'),
(3791,NULL,'Куца Оля',NULL,'2019-05-13',NULL,380970376609,NULL,1674245825,'1',NULL,0,'','0'),
(3792,NULL,'Гладій Іра',NULL,NULL,NULL,380977010673,NULL,1788893090,'1',NULL,0,'','0'),
(3793,NULL,'Зявін Галина',NULL,'2019-05-13',NULL,380989149839,NULL,1247906441,'1',NULL,0,'','0'),
(3794,NULL,'Карпець Олена',NULL,'2019-05-13',NULL,380677454754,NULL,1404694512,'1',NULL,0,'','0'),
(3795,NULL,'Семенюк Віка',NULL,'2019-05-14','n1OeeZkVdxM1qOc2YKiWlw==',380982400374,NULL,1343936472,'1',43161,0,'','0'),
(3796,NULL,'Пупеза Наталя',NULL,'2019-05-14',NULL,380687756522,NULL,1703894759,'1',NULL,0,'','0'),
(3797,NULL,'Бебко Роксолана',NULL,'2019-05-14',NULL,380965618213,NULL,1116479785,'1',NULL,0,'','0'),
(3798,NULL,'Пазюк Діана',NULL,'2019-05-14',NULL,380979302637,NULL,1783916169,'1',NULL,0,'','0'),
(3799,NULL,'Винник Олеся',NULL,'2019-05-14',NULL,380677760731,NULL,1970064172,'1',NULL,0,'','0'),
(3800,NULL,'весновська наталя',NULL,'2019-05-14',NULL,380965741583,NULL,1638322228,'1',NULL,0,'','0'),
(3801,NULL,'Томенко Юля',NULL,NULL,NULL,380966184994,NULL,1319287027,'1',NULL,0,'','0'),
(3802,NULL,'Процюк Вероніка',NULL,'2019-05-15',NULL,380985541822,NULL,1338536405,'1',NULL,0,'','0'),
(3803,NULL,'Кіянчук Оля',NULL,'2019-05-15',NULL,380967520630,NULL,1373584466,'1',NULL,1,'','0'),
(3804,NULL,'Голод Таня',NULL,'2019-05-15',NULL,380969852758,NULL,1459697091,'1',NULL,0,'','0'),
(3805,NULL,'нера орися',NULL,'2019-05-16',NULL,380969455750,NULL,1151412130,'1',NULL,0,'','0'),
(3806,0919,'Ориняк Ілона',NULL,NULL,NULL,380681163744,NULL,1789093768,'1',NULL,0,'','0'),
(3807,NULL,'Цвєткова Оксана',NULL,'2019-05-16',NULL,380959304354,NULL,1566262249,'1',NULL,0,'','0'),
(3808,NULL,'циплінська аріна',NULL,'2019-05-16',NULL,380979059938,NULL,1171707431,'1',NULL,0,'','0'),
(3809,NULL,'Смирнова Ірина',NULL,'2019-05-16',NULL,380983117844,NULL,1798328969,'1',NULL,1,'','0'),
(3810,NULL,'Міхна Оля',NULL,'2019-05-17',NULL,380678506249,NULL,1213242168,'1',14699,0,'','0'),
(3811,NULL,'дунчак оля',NULL,NULL,NULL,380962484856,NULL,1521598698,'1',NULL,0,'','0'),
(3812,NULL,'Салійчук Іванна',NULL,'2019-05-17',NULL,380960372080,NULL,1872653440,'1',NULL,0,'','0'),
(3813,NULL,'Швед Катя',NULL,'2019-05-18',NULL,380686254961,NULL,1662744265,'1',NULL,0,'','0'),
(3814,NULL,'Паньків Оксана',NULL,'2019-05-18',NULL,380686497575,NULL,1618060670,'1',NULL,0,'','0'),
(3815,NULL,'Суровяк Марія',NULL,'2019-05-20',NULL,380979178330,NULL,1572814832,'1',NULL,0,'','0'),
(3816,NULL,'Бубель Діана',NULL,'2019-05-20',NULL,380988059910,NULL,1780016497,'1',NULL,0,'','0'),
(3817,NULL,'Мороз вікторія',NULL,NULL,NULL,380989740290,NULL,1260378778,'',NULL,0,'','0'),
(3818,NULL,'Товпига оксана',NULL,'2019-05-20',NULL,380985484719,NULL,1826044059,'1',NULL,0,'','0'),
(3819,NULL,'Паньків наталя',NULL,'2019-05-20',NULL,380986157894,NULL,1911641508,'1',NULL,1,'','0'),
(3820,NULL,'Бідна Настя',NULL,'2019-05-20',NULL,380981248846,NULL,1970275249,'1',56894,0,'','0'),
(3821,NULL,'Росляк таня',NULL,'2019-05-20',NULL,380965993359,NULL,1119047303,'1',NULL,0,'','0'),
(3822,NULL,'Кравченко Оксана',NULL,'2019-05-20',NULL,380964079762,NULL,1830483746,'1',NULL,0,'','0'),
(3823,NULL,'Семчишина Андрій',NULL,'2019-05-21',NULL,380686395615,NULL,1124022923,'1',NULL,0,'','0'),
(3824,NULL,'Шумада Маряна',NULL,NULL,NULL,380964328287,NULL,1212435612,'1',NULL,0,'','0'),
(3825,NULL,'Колівожко Наталя',NULL,'2019-05-21',NULL,380968769499,NULL,1870521460,'1',NULL,0,'','0'),
(3826,NULL,'Вигінна Наталя',NULL,'2019-05-21',NULL,380979664354,NULL,2093964648,'1',NULL,0,'','0'),
(3827,NULL,'Деревенчук маша',NULL,'2019-05-21',NULL,380985651695,NULL,1950780019,'1',NULL,0,'','0'),
(3828,NULL,'Михайлюк світлана',NULL,'2019-05-21',NULL,380961551945,NULL,1633019505,'1',NULL,0,'','0'),
(3829,NULL,'Шимальська галина',NULL,'2019-05-22',NULL,380634083950,NULL,1650860821,'1',NULL,5,'','0'),
(3830,NULL,'Андрусик Анна',NULL,'2019-05-22',NULL,380987757516,NULL,1955703878,'1',NULL,1,'','0'),
(3831,NULL,'Дудяк таня',NULL,'2019-05-22',NULL,380952077687,NULL,2086927103,'1',NULL,0,'','0'),
(3832,NULL,'Бабій Ірина',NULL,'2019-05-22',NULL,380686540519,NULL,1880453239,'1',37696,0,'','0'),
(3833,NULL,'Король Богдана',NULL,'2019-05-22',NULL,380970526621,NULL,1388700095,'1',NULL,0,'','0'),
(3834,NULL,'Наумович Славік',NULL,'2019-05-23',NULL,380968014660,NULL,2124380668,'1',NULL,0,'','0'),
(3835,NULL,'Кухаришин Ніна',NULL,'2019-05-23',NULL,380681662581,NULL,1618859301,'1',NULL,5,'','0'),
(3836,NULL,'Дякун Анна',NULL,NULL,NULL,380977828852,NULL,1981888286,'1',NULL,0,'','0'),
(3837,NULL,'Гановська Настя',NULL,NULL,NULL,380683647445,NULL,2012809426,'1',NULL,0,'','0'),
(3838,NULL,'Вольніцька Надя',NULL,'2019-05-23',NULL,380673252621,NULL,1305363798,'1',NULL,0,'','0'),
(3839,NULL,'іра наша',NULL,NULL,NULL,NULL,NULL,1892738895,'1',NULL,0,'','0'),
(3840,NULL,'Олексів Галина',NULL,'2019-05-23',NULL,380502229059,NULL,1876504100,'1',NULL,0,'','0'),
(3841,NULL,'Коробій Леся',NULL,'2019-05-23',NULL,380975828462,NULL,1772525553,'1',NULL,0,'','0'),
(3842,NULL,'Данилишин Галя',NULL,'2019-05-23',NULL,380966909566,NULL,1342587345,'1',52823,0,'','0'),
(3843,NULL,'Черкас Іра',NULL,'2019-05-24',NULL,380982948183,NULL,1345555997,'1',NULL,0,'','0'),
(3844,NULL,'Смаглій Таня',NULL,'2019-05-24',NULL,380975474172,NULL,1974185984,'1',NULL,0,'','0'),
(3845,NULL,'Славіна Олена',NULL,'2019-05-24',NULL,380685874859,NULL,2003143308,'1',NULL,0,'','0'),
(3846,NULL,'МАРКАНИЧ Наталя',NULL,'2019-05-25',NULL,380986788402,NULL,1423795208,'1',NULL,0,'','0'),
(3847,NULL,'Солоденко Христина',NULL,'2019-05-25',NULL,380989244204,NULL,1511267310,'1',NULL,0,'','0'),
(3848,NULL,'Ярошук Галина',NULL,'2019-05-25',NULL,380680137059,NULL,2130741418,'1',NULL,0,'','0'),
(3849,0238,'Сапяк маряна',NULL,NULL,NULL,380969715387,NULL,2071740470,'1',NULL,0,'','0'),
(3850,NULL,'Томунь Галина',NULL,'2019-05-27',NULL,380988194005,NULL,1699813559,'1',NULL,0,'','0'),
(3851,NULL,'Войтюк Діана',NULL,'2019-05-27',NULL,380976252820,NULL,1982765311,'1',NULL,0,'','0'),
(3852,NULL,'Киналь Наталя',NULL,'2019-05-27',NULL,380978376274,NULL,1757923181,'1',NULL,0,'','0'),
(3853,NULL,'Когут Юля',NULL,'2019-05-27',NULL,380685992151,NULL,1703651399,'1',42442,5,'','0'),
(3854,NULL,'Оробчук Наталя',NULL,'2019-05-27',NULL,380687126078,NULL,1889881224,'1',NULL,0,'','0'),
(3855,NULL,'Оробчук Надя',NULL,'2019-05-27',NULL,380688344358,NULL,1540565462,'1',NULL,0,'','0'),
(3856,NULL,'Грицак Уляна',NULL,'2019-05-27',NULL,380968878325,NULL,1518793647,'1',NULL,0,'','0'),
(3857,NULL,'Кармазин Таня',NULL,'2019-05-27',NULL,380983857442,NULL,1397727821,'1',NULL,0,'','0'),
(3858,NULL,'Швайчук Оксана',NULL,'2019-05-27',NULL,380963849527,NULL,1414512988,'1',NULL,0,'','0'),
(3859,NULL,'Тришак Іра',NULL,'2019-05-27',NULL,380984790932,NULL,1953742847,'1',NULL,0,'','0'),
(3860,NULL,'Кенцік Лєна',NULL,'2019-05-27',NULL,380501895388,NULL,2091994735,'1',NULL,0,'','0'),
(3861,NULL,'Корпович Світлана',NULL,'2019-05-27',NULL,380955878285,NULL,1800203803,'1',NULL,0,'','0'),
(3862,NULL,'Білич Діана',NULL,'2019-05-28',NULL,380679352478,NULL,1701219149,'1',NULL,0,'','0'),
(3863,NULL,'Бегман Таня',NULL,'2019-05-28',NULL,380684316670,NULL,1916677995,'1',NULL,0,'','0'),
(3864,NULL,'Халанич Ліля',NULL,'2019-05-28',NULL,380688623886,NULL,1950346522,'1',NULL,0,'','0'),
(3865,NULL,'Діана наша',NULL,NULL,NULL,NULL,NULL,2087957489,'1',NULL,0,'','0'),
(3866,NULL,'Галя наша',NULL,NULL,NULL,NULL,NULL,2072533995,'1',NULL,1,'','0'),
(3867,NULL,'Москалик Сніжана',NULL,'2019-05-28',NULL,380685009488,NULL,1578833011,'1',29094,0,'','0'),
(3868,NULL,'Абрамець Андріана',NULL,'2019-05-28',NULL,380682371426,NULL,1571700470,'1',NULL,0,'','0'),
(3869,NULL,'Угрин Оля',NULL,'2019-05-28',NULL,380682469583,NULL,1750680972,'1',NULL,0,'','0'),
(3870,NULL,'Федорів Наталя',NULL,'2019-05-28',NULL,380973389927,NULL,1981072860,'1',NULL,0,'','0'),
(3871,NULL,'Крупська Таня',NULL,'2019-05-28',NULL,380979676571,NULL,1307385558,'1',NULL,0,'','0'),
(3872,NULL,'Монастирська Марія',NULL,'2019-05-29',NULL,380686953996,NULL,1932449725,'1',NULL,0,'','0'),
(3873,NULL,'Марчук Наталя',NULL,'2019-05-29',NULL,380684319484,NULL,1513773337,'1',NULL,0,'','0'),
(3874,NULL,'Беднарська Настя',NULL,'2019-05-29',NULL,380972306564,NULL,1504068355,'1',NULL,0,'','0'),
(3875,NULL,'Тимчук юля',NULL,'2019-05-29',NULL,380967661145,NULL,1645050930,'1',NULL,0,'','0'),
(3876,NULL,'Ровінська Таня',NULL,'2019-05-30',NULL,380982952035,NULL,1848821736,'1',NULL,1,'','0'),
(3877,NULL,'Семенчук Роксолана',NULL,'2019-05-31',NULL,380665001179,NULL,1140764010,'1',NULL,0,'','0'),
(3878,NULL,'Ворона Марія',NULL,'2019-05-31',NULL,380969886384,NULL,1222626479,'1',NULL,0,'','0'),
(3879,NULL,'Димкович Катя',NULL,'2019-05-31',NULL,380968588579,NULL,1131969466,'1',NULL,0,'','0'),
(3880,NULL,'дзюба марія',NULL,'2019-05-31',NULL,380930983468,NULL,1679182796,'1',NULL,0,'','0'),
(3881,NULL,'скренткович юля',NULL,'2019-06-01',NULL,380675885704,NULL,1976460120,'1',NULL,0,'','0'),
(3882,NULL,'Молнар Анжеліка',NULL,'2019-06-01',NULL,380961504676,NULL,2040523619,'1',NULL,0,'','0'),
(3883,NULL,'Атаманчук Настя',NULL,'2019-06-03',NULL,380686332677,NULL,1196426160,'1',13485,0,'','0'),
(3884,NULL,'Хрик Таня',NULL,'2019-06-03',NULL,380960270059,NULL,1216954784,'1',NULL,0,'','0'),
(3885,NULL,'Балацко Оля',NULL,'2019-06-03',NULL,380980186042,NULL,2001317115,'1',NULL,0,'','0'),
(3886,NULL,'воробець юля',NULL,'2019-06-03',NULL,380987025921,NULL,1686912809,'1',NULL,0,'','0'),
(3887,NULL,'Рибак Віка',NULL,'2019-06-03',NULL,380675917252,NULL,1642090838,'1',NULL,0,'','0'),
(3888,NULL,'Славута Олеся',NULL,'2019-06-04',NULL,380686985751,NULL,1743869300,'1',NULL,0,'','0'),
(3889,NULL,'Бегман Олександра',NULL,'2019-06-04',NULL,380688448104,NULL,1668923911,'1',NULL,0,'','0'),
(3890,NULL,'Стрижак Оля',NULL,'2019-06-04',NULL,380983988504,NULL,1572381024,'1',NULL,0,'','0'),
(3891,NULL,'Онухевич Олександра',NULL,'2019-06-04',NULL,380686514275,NULL,1647546884,'1',NULL,0,'','0'),
(3892,NULL,'Городівська Іра',NULL,'2019-06-04',NULL,380502997419,NULL,1365568451,'1',NULL,0,'','0'),
(3893,NULL,'Слободян Світлана',NULL,'2019-06-04',NULL,380989009997,NULL,1559725416,'1',NULL,0,'','0'),
(3894,NULL,'Куцак Віка',NULL,'2019-06-04',NULL,380983752827,NULL,1308592677,'1',NULL,0,'','0'),
(3895,NULL,'Салій Наталя ',NULL,'2019-06-04',NULL,380984628149,NULL,1256817000,'1',NULL,0,'','0'),
(3896,NULL,'Заяць Роксолана',NULL,'2019-06-05',NULL,380980221721,NULL,1570560917,'1',NULL,0,'','0'),
(3897,NULL,'Гриненко Руслана',NULL,'2019-06-05',NULL,380985600309,NULL,1753167838,'1',NULL,0,'','0'),
(3898,NULL,'Плішка Іра',NULL,'2019-06-05','sOOBgKS0KwITSEDbtaOqRw==',380987999622,NULL,1455044936,'1',NULL,1,'','0'),
(3899,NULL,'Сливчук Марія',NULL,'2019-06-05',NULL,380971106597,NULL,1424783175,'1',NULL,0,'','0'),
(3900,NULL,'Нагорська Оксана',NULL,'2019-06-05',NULL,380969629847,NULL,1859870433,'1',NULL,2,'','0'),
(3901,NULL,'Панчишин Діана',NULL,'2019-06-05',NULL,380972746441,NULL,1369408999,'1',NULL,0,'','0'),
(3902,NULL,'Ганакова Кароліна',NULL,'2019-06-05',NULL,380985076952,NULL,1540294785,'1',NULL,2,'','0'),
(3903,NULL,'Фучила Віталіна',NULL,'2019-06-05',NULL,380976119006,NULL,2015503450,'1',NULL,0,'','0'),
(3904,NULL,'Яцун оксана',NULL,NULL,NULL,380665023116,NULL,1447297881,'1',NULL,0,'','0'),
(3905,NULL,'Деревляк Наталя',NULL,'2019-06-07',NULL,380961952312,NULL,1478148890,'1',NULL,0,'','0'),
(3906,NULL,'Яковець Юля',NULL,'2019-06-07',NULL,380682813170,NULL,1855392881,'1',NULL,0,'','0'),
(3907,NULL,'Гулей Марія',NULL,'2019-06-07',NULL,380966514655,NULL,1899365707,'1',NULL,0,'','0'),
(3908,NULL,'Винничук Іра',NULL,'2019-06-07',NULL,380501621844,NULL,1861218147,'1',NULL,0,'','0'),
(3909,NULL,'обліжок Світлана',NULL,NULL,NULL,380683184177,NULL,1155797334,'1',NULL,0,'','0'),
(3910,NULL,'Терендій Оксана',NULL,'2019-06-08',NULL,380673990275,NULL,1568742252,'1',NULL,0,'','0'),
(3911,NULL,'Бобіна Ліля',NULL,'2019-06-08',NULL,380675885707,NULL,1776380630,'1',NULL,0,'','0'),
(3912,NULL,'мельничук марія',NULL,'2019-06-08',NULL,380989235077,NULL,1159789888,'1',NULL,0,'','0'),
(3913,NULL,'козак іванна',NULL,'2019-06-10',NULL,380962713890,NULL,1184936021,'1',NULL,1,'','0'),
(3914,NULL,'бичковська марія',NULL,'2019-06-10',NULL,380967179134,NULL,1306497053,'1',NULL,0,'','0'),
(3915,NULL,'війтишин галина',NULL,'2019-06-10',NULL,380969222479,NULL,1820366812,'1',NULL,0,'','0'),
(3916,NULL,'новак жанна',NULL,'2019-06-10',NULL,380984038483,NULL,1323478590,'1',NULL,0,'','0'),
(3917,NULL,'Михайловська Юля',NULL,'2019-06-10',NULL,380934738431,NULL,1825181985,'1',NULL,0,'','0'),
(3918,NULL,'Гудь Аліна',NULL,'2019-06-11',NULL,380971512926,NULL,1164970120,'1',NULL,0,'','0'),
(3919,NULL,'Гудь Анна',NULL,'2019-06-11',NULL,380677834178,NULL,2038876266,'1',NULL,0,'','0'),
(3920,NULL,'Гудь Марія',NULL,'2019-06-11',NULL,380990186240,NULL,1146600138,'1',NULL,0,'','0'),
(3921,NULL,'Гудь Христина',NULL,'2019-06-11',NULL,380983542962,NULL,1563587263,'1',NULL,0,'','0'),
(3922,NULL,'Балацко Оля',NULL,'2019-06-11',NULL,380689719781,NULL,1776572275,'1',NULL,0,'','0'),
(3923,NULL,'Ляхович наталя',NULL,'2019-06-11',NULL,380965517583,NULL,1864357470,'1',NULL,0,'','0'),
(3924,NULL,'Рожок Іра',NULL,NULL,NULL,NULL,NULL,1603934471,'1',NULL,0,'','0'),
(3925,NULL,'Олексів Людмила',NULL,'2019-06-11',NULL,380970884844,NULL,1630436586,'1',NULL,0,'','0'),
(3926,NULL,'Поживотенко Віка',NULL,'2019-06-11',NULL,380671292412,NULL,1468086796,'1',NULL,0,'','0'),
(3927,NULL,'Зазуляк Настя',NULL,'2019-06-11',NULL,380979119772,NULL,1942360767,'1',NULL,0,'','0'),
(3928,NULL,'Хвастовська Таня',NULL,'2019-06-11',NULL,380680838478,NULL,1585096183,'1',NULL,0,'','0'),
(3929,NULL,'Карач Наталя',NULL,'2019-06-11',NULL,380983925121,NULL,1565279146,'1',NULL,0,'','0'),
(3930,NULL,'Шкабар Надія',NULL,'2019-06-11',NULL,380667211385,NULL,1594469721,'1',NULL,0,'','0'),
(3931,NULL,'галянт галина',NULL,'2019-06-11',NULL,380679480655,NULL,2138223037,'1',NULL,0,'','0'),
(3932,NULL,'Вівчар Марія',NULL,'2019-06-11',NULL,380970892987,NULL,1722701673,'1',NULL,0,'','0'),
(3933,NULL,'плішка настя',NULL,'2019-06-12',NULL,380966909472,NULL,1510925827,'1',NULL,0,'','0'),
(3934,NULL,'Кінасевич Надя',NULL,'2019-06-12',NULL,380968163783,NULL,1985172007,'1',NULL,0,'','0'),
(3935,NULL,'Будзишин Таня',NULL,'2019-06-12',NULL,380985658255,NULL,1133393593,'1',NULL,0,'','0'),
(3936,NULL,'Чурик Леся',NULL,'2019-06-13',NULL,380680476108,NULL,2012181307,'1',NULL,1,'','0'),
(3937,NULL,'Кучик Марія',NULL,NULL,NULL,380984562124,NULL,1955720218,'1',NULL,0,'','0'),
(3938,NULL,'КУчик Оксана',NULL,'2019-06-13',NULL,380977892123,NULL,1642120189,'1',NULL,0,'','0'),
(3939,NULL,'Пасічник Христина ',NULL,'2019-06-13',NULL,380972917562,NULL,1510604541,'1',NULL,1,'','0'),
(3940,NULL,'Пилипюк Оксана',NULL,'2019-06-13',NULL,380977009067,NULL,1196054449,'1',NULL,0,'','0'),
(3941,NULL,'Бобіна Уляна',NULL,'2019-06-13',NULL,380966707401,NULL,1124361272,'1',NULL,0,'','0'),
(3942,NULL,'Стельмащук Діана',NULL,'2019-06-13',NULL,380989922122,NULL,1511717369,'1',NULL,0,'','0'),
(3943,NULL,'Духніч христина',NULL,'2019-06-13',NULL,380989235079,NULL,1329745408,'1',NULL,0,'','0'),
(3944,NULL,'Недільська Надя',NULL,'2019-06-13',NULL,380684741696,NULL,2059042741,'1',NULL,0,'','0'),
(3945,NULL,'Слонь Наталя',NULL,'2019-06-14',NULL,380682464591,NULL,1182177336,'1',NULL,0,'','0'),
(3946,NULL,'брода ніна',NULL,'2019-06-14',NULL,380685127857,NULL,1475337927,'1',NULL,0,'','0'),
(3947,NULL,'король зоряна',NULL,'2019-06-14',NULL,380972051103,NULL,1123962940,'1',NULL,0,'','0'),
(3948,NULL,'Мазепа Марія',NULL,'2019-06-15',NULL,380969617055,NULL,1316630659,'1',NULL,0,'','0'),
(3949,NULL,'Дробот галя',NULL,'2019-06-15',NULL,380966002684,NULL,1672659462,'1',NULL,0,'','0'),
(3950,NULL,'Родзоній Оля',NULL,'2019-06-17',NULL,380687602110,NULL,1592965807,'1',NULL,0,'','0'),
(3951,NULL,'Геба Оксана',NULL,'2019-06-17',NULL,NULL,NULL,1430920316,'1',NULL,0,'','0'),
(3952,NULL,'Слота Ніна',NULL,'2019-06-18',NULL,380969689544,NULL,1847755770,'1',NULL,0,'','0'),
(3953,NULL,'гошко віка',NULL,'2019-06-18',NULL,380981181566,NULL,1788453333,'1',NULL,0,'','0'),
(3954,NULL,'костишин юля',NULL,'2019-06-18',NULL,380992625839,NULL,1583344574,'1',12402,0,'','0'),
(3955,NULL,'Пеньковська Галина',NULL,'2019-06-18',NULL,380506968547,NULL,1572697467,'1',NULL,0,'','0'),
(3956,NULL,'Берчак Світлана',NULL,'2019-06-18',NULL,380977002573,NULL,1402672707,'1',NULL,0,'','0'),
(3957,NULL,'Гонта Оля',NULL,'2019-06-18',NULL,380671667583,NULL,1127037156,'1',NULL,0,'','0'),
(3958,NULL,'Перожик Оксана',NULL,'2019-06-19',NULL,380676985308,NULL,1726614556,'1',NULL,0,'','0'),
(3959,NULL,'Ганатова Кароліна',NULL,'2019-06-19',NULL,380688176296,NULL,1504584579,'1',NULL,0,'','0'),
(3960,NULL,'Нога Інна',NULL,NULL,NULL,380672005398,NULL,1238282797,'1',NULL,0,'','0'),
(3961,NULL,'якубишин ліза',NULL,NULL,NULL,380984790798,NULL,2096277093,'1',NULL,0,'','0'),
(3962,NULL,'макра іванна',NULL,'2019-06-19',NULL,380977236033,NULL,1803042678,'1',NULL,0,'','0'),
(3963,NULL,'Навроцька аня',NULL,'2019-06-19',NULL,380977526041,NULL,1366857450,'1',NULL,0,'','0'),
(3964,NULL,'боднар алла',NULL,'2019-06-19',NULL,380684864302,NULL,1306645302,'1',NULL,0,'','0'),
(3965,NULL,'Бревус Христина ',NULL,'2019-06-20',NULL,380975509994,NULL,2030155546,'1',NULL,0,'','0'),
(3966,NULL,'пахолок оксана',NULL,'2019-06-20',NULL,380507003815,NULL,1921342397,'1',NULL,0,'','0'),
(3967,NULL,'Паламар Олеся',NULL,'2019-06-20',NULL,380972203494,NULL,1795840644,'1',NULL,0,'','0'),
(3968,NULL,'Дериш Галина',NULL,'2019-06-21',NULL,380989860716,NULL,1461980484,'1',NULL,0,'','0'),
(3969,NULL,'афоненко христина',NULL,'2019-06-21',NULL,380967649224,NULL,2023687032,'1',44197,1,'','0'),
(3970,NULL,'Дорош Юля',NULL,'2019-06-21',NULL,380661205431,NULL,1465457853,'1',NULL,0,'','0'),
(3971,NULL,'Мацишин руслана',NULL,'2019-06-22','sr74lMVw4NbEPeh4EG2FTA==',380971827658,NULL,1431685523,'1',42877,0,'','0'),
(3972,NULL,'Гуня олена',NULL,'2019-06-22',NULL,380968088461,NULL,2077392206,'1',NULL,0,'','0'),
(3973,NULL,'Павловська Наталя',NULL,'2019-06-22',NULL,380501451997,NULL,1231897602,'1',NULL,0,'','0'),
(3974,NULL,'бегман таня',NULL,'2019-06-24',NULL,380960605268,NULL,2145282232,'1',NULL,0,'','0'),
(3975,NULL,'смеречинська маряна',NULL,'2019-06-24',NULL,380984652604,NULL,1513900080,'1',NULL,0,'','0'),
(3976,NULL,'бойчук зоряна',NULL,'2019-06-24',NULL,380959483505,NULL,1869276861,'1',NULL,0,'','0'),
(3977,NULL,'крипишин інна',NULL,NULL,NULL,380978727178,NULL,1856836031,'1',NULL,0,'','0'),
(3978,NULL,'дмитраш вікторія',NULL,'2019-06-24',NULL,380986605661,NULL,1376699376,'1',NULL,0,'','0'),
(3979,NULL,'Шендрик Олена',NULL,'2019-06-24',NULL,380676798785,NULL,1342495624,'1',NULL,0,'','0'),
(3980,NULL,'Буденкевич Таня',NULL,NULL,NULL,380503770174,NULL,2037208277,'1',NULL,0,'','0'),
(3981,NULL,'Любая Наталя',NULL,'2019-06-25',NULL,380931433041,NULL,1813268525,'1',NULL,0,'','0'),
(3982,NULL,'Ландяк Христина',NULL,NULL,NULL,380688455160,NULL,1705695487,'1',NULL,3,'','0'),
(3983,NULL,'ковальчук софія',NULL,'2019-06-25',NULL,380508684938,NULL,1561079197,'1',62268,0,'','0'),
(3984,NULL,'Синюк юля',NULL,'2019-06-25',NULL,380979464696,NULL,1936308405,'1',64220,0,'','0'),
(3985,NULL,'Кушнір Галина',NULL,'2019-06-26',NULL,380967918612,NULL,1513860280,'1',NULL,0,'','0'),
(3986,NULL,'Кралько Оля',NULL,'2019-06-26',NULL,380978936362,NULL,1993975746,'1',NULL,0,'','0'),
(3987,NULL,'Білецька Леся',NULL,'2019-06-26',NULL,380957433127,NULL,1313633660,'1',NULL,0,'','0'),
(3988,NULL,'Міщанчук Христина',NULL,'2019-06-27',NULL,380684853989,NULL,1909560807,'1',NULL,0,'','0'),
(3989,NULL,'Грипа Оксана',NULL,'2019-06-27',NULL,380675889174,NULL,1813785571,'1',NULL,0,'','0'),
(3990,NULL,'Гнатюк Оксана',NULL,'2019-06-27','smBxdsNC6xqHGXTBZSHESQ==',380680472880,NULL,1882826390,'1',14157,0,'','0'),
(3991,NULL,'присяжнюк оксана',NULL,'2019-06-28',NULL,380681642873,NULL,1189012101,'1',NULL,0,'','0'),
(3992,NULL,'Підкова Наталя',NULL,'2019-06-28',NULL,380981054184,NULL,1281935595,'1',NULL,0,'','0'),
(3993,NULL,'Гонта Оля',NULL,'2019-06-28',NULL,380980591359,NULL,1622844526,'1',NULL,0,'','0'),
(3994,NULL,'Матвійчук Надія',NULL,'2019-06-28',NULL,380965058084,NULL,1134781242,'1',NULL,0,'','0'),
(3995,NULL,'Гриців оля',NULL,'2019-06-28',NULL,380686724007,NULL,1860121515,'1',NULL,0,'','0'),
(3996,NULL,'Дрогомирецька Олеся',NULL,'2019-06-28',NULL,380978337068,NULL,2145266149,'1',NULL,0,'','0'),
(3997,NULL,'Чукань Лєна',NULL,'2019-06-28',NULL,380961922523,NULL,1978487152,'1',NULL,1,'','0'),
(3998,NULL,'штогрин іра',NULL,'2019-06-29',NULL,380978082237,NULL,1778643688,'1',NULL,0,'','0'),
(3999,NULL,'Ставнича Уляна',NULL,'2019-06-29',NULL,380989282476,NULL,1385865286,'1',NULL,0,'','0'),
(4000,NULL,'Кушнірик олександра',NULL,'2019-06-29',NULL,380966009301,NULL,1117730184,'1',NULL,0,'','0');

INSERT INTO `kontragentu` VALUES 
(4001,NULL,'пастяк люба',NULL,'2019-06-29',NULL,380680472920,NULL,1811591717,'1',NULL,0,'','0'),
(4002,NULL,'Губік Таня',NULL,'2019-06-29',NULL,380672886329,NULL,2042803345,'1',NULL,0,'','0'),
(4003,NULL,'Шевчук настя',NULL,'2019-06-29',NULL,380967303542,NULL,1570396560,'1',20555,0,'','0'),
(4004,NULL,'Павлюк Олеся',NULL,'2019-06-29',NULL,380980842181,NULL,1259582015,'1',NULL,0,'','0'),
(4005,NULL,'краєвська зоряна',NULL,'2019-06-29',NULL,380979911413,NULL,1330935527,'1',42355,0,'','0'),
(4006,NULL,'денис марія',NULL,'2019-06-29',NULL,380967028839,NULL,1320514881,'1',NULL,0,'','0'),
(4007,NULL,'Приймак Марія',NULL,NULL,NULL,380688422688,NULL,1910631529,'1',NULL,0,'','0'),
(4008,NULL,'Дацишин Оля',NULL,'2019-07-01',NULL,380680204941,NULL,1952498392,'1',NULL,0,'','0'),
(4009,NULL,'сташинська наталія',NULL,NULL,NULL,380937113691,NULL,1883187680,'1',NULL,0,'','0'),
(4010,NULL,'Гриців Сирафима',NULL,'2019-07-01',NULL,380971288187,NULL,1143558709,'1',NULL,0,'','0'),
(4011,NULL,'Куніцина Анна',NULL,'2019-07-01',NULL,380671657867,NULL,1918293618,'1',NULL,0,'','0'),
(4012,NULL,'Греськів Олена',NULL,'2019-07-01',NULL,380960740065,NULL,1848366144,'1',NULL,0,'','0'),
(4013,NULL,'Шкварла Оля',NULL,'2019-07-01',NULL,380689869176,NULL,1444654203,'1',NULL,0,'','0'),
(4014,NULL,'Лазарчук Галя',NULL,'2019-07-01',NULL,380673010354,NULL,1627280662,'1',NULL,0,'','0'),
(4015,NULL,'Наталя наша',NULL,'2019-07-01',NULL,NULL,NULL,1308252356,'1',NULL,0,'','0'),
(4016,NULL,'Косінська Леся',NULL,'2019-07-02',NULL,380967665120,NULL,1288161270,'1',NULL,0,'','0'),
(4017,NULL,'Філь Наталя',NULL,NULL,NULL,380972288864,NULL,2002884281,'1',NULL,0,'','0'),
(4018,NULL,'Мельник Наталя',NULL,'2019-07-02',NULL,380971106577,NULL,1560437630,'1',NULL,0,'','0'),
(4019,NULL,'данильчук христина',NULL,'2019-07-02',NULL,380986295795,NULL,1866715715,'1',NULL,0,'','0'),
(4020,NULL,'Шевчук соломія',NULL,'2019-07-03',NULL,380981877364,NULL,1461357659,'1',NULL,0,'','0'),
(4021,NULL,'Мазуркевич Христина',NULL,'2019-07-03',NULL,380979225437,NULL,1919073262,'1',NULL,0,'','0'),
(4022,NULL,'Ковальчук Анна',NULL,'2019-07-03',NULL,380962846468,NULL,1787882391,'1',NULL,0,'','0'),
(4023,NULL,'Кісіль Наталя',NULL,'2019-07-03',NULL,380990655113,NULL,1560470176,'1',NULL,0,'','0'),
(4024,NULL,'пелипів олена',NULL,'2019-07-04',NULL,380988120700,NULL,2030056219,'1',NULL,0,'','0'),
(4025,NULL,'Мельник Юля',NULL,'2019-07-04',NULL,380971123704,NULL,1922393840,'1',NULL,0,'','0'),
(4026,NULL,'коніва софія',NULL,'2019-07-04',NULL,380961813104,NULL,1342678191,'1',NULL,0,'','0'),
(4027,NULL,'Попович Оля',NULL,'2019-07-04',NULL,380977714218,NULL,1335033182,'1',NULL,0,'','0'),
(4028,NULL,'Мельник Інна',NULL,'2019-07-04',NULL,380979992047,NULL,1704425770,'1',NULL,11,'','0'),
(4029,NULL,'стельмащук соломія',NULL,'2019-07-05','aowH0uvtRajjjRMmUQz/zg==',380507736450,NULL,1351426612,'1',NULL,0,'','0'),
(4030,NULL,'Поліщук оля',NULL,'2019-07-05',NULL,380976648345,NULL,1521303813,'1',NULL,0,'','0'),
(4031,NULL,'Дражньовська діана',NULL,'2019-07-05',NULL,380973404021,NULL,1121716823,'1',NULL,0,'','0'),
(4032,NULL,'Балацко Уляна',NULL,'2019-07-05',NULL,380960522832,NULL,1124755079,'1',NULL,0,'','0'),
(4033,NULL,'Басараб Олена ',NULL,'2019-07-06',NULL,380977133943,NULL,1567078474,'1',NULL,0,'','0'),
(4034,NULL,'Білецький Славік',NULL,'2019-07-06',NULL,380980188259,NULL,1590783333,'1',50503,0,'','0'),
(4035,NULL,'Підсадна Аріна',NULL,'2019-07-06',NULL,380963998485,NULL,1843874963,'1',NULL,0,'','0'),
(4036,NULL,'Приймак Наталя',NULL,'2019-07-06',NULL,380981171466,NULL,1639539098,'1',41140,0,'','0'),
(4037,NULL,'Заболотна Світлана',NULL,NULL,NULL,380960106157,NULL,1224943348,'1',NULL,0,'','0'),
(4038,NULL,'Батрин Наталя',NULL,'2019-07-08',NULL,380967483538,NULL,1301587908,'1',NULL,0,'','0'),
(4039,NULL,'Білик Антоніна',NULL,'2019-07-09',NULL,380671322636,NULL,1215395298,'1',NULL,0,'','0'),
(4040,NULL,'Хомищин Маряна',NULL,'2019-07-09',NULL,380980038336,NULL,1158026288,'1',NULL,0,'','0'),
(4041,NULL,'Круцяк Андріана',NULL,'2019-07-09',NULL,380930584972,NULL,2076967141,'1',NULL,0,'','0'),
(4042,NULL,'Деренюк Маряна',NULL,'2019-07-09',NULL,380685963446,NULL,2112910572,'1',NULL,1,'','0'),
(4043,NULL,'Кульгавець Марія',NULL,'2019-07-09',NULL,380964982858,NULL,1213737556,'1',NULL,0,'','0'),
(4044,NULL,'Туриш Тетяна',NULL,'2019-07-10',NULL,380685142534,NULL,1551083845,'1',NULL,1,'','0'),
(4045,NULL,'Руда Катя',NULL,'2019-07-11',NULL,380969422646,NULL,1998055665,'1',NULL,0,'','0'),
(4046,NULL,'Грушицька Ліля',NULL,NULL,NULL,380964195523,NULL,1878560892,'1',NULL,0,'','0'),
(4047,NULL,'Кожушко Оксана',NULL,'2019-07-13',NULL,380689473831,NULL,1677149014,'1',NULL,0,'','0'),
(4048,NULL,'Павлюк таня',NULL,'2019-07-13',NULL,380969646146,NULL,1862674859,'1',NULL,0,'','0'),
(4049,NULL,'Павлюк Настя',NULL,NULL,NULL,380675070475,380689125345,1639891041,'1',NULL,0,'','1'),
(4050,NULL,'Добровицька Наталя',NULL,'2019-07-13',NULL,380966737716,NULL,1410839982,'1',NULL,0,'','0'),
(4051,NULL,'Нзяк Маша',NULL,'2019-07-14',NULL,380978971900,NULL,1391334716,'1',NULL,0,'','0'),
(4052,NULL,'Чабайовська Олександра',NULL,'2019-07-15',NULL,380686497956,NULL,1640759441,'1',NULL,0,'','0'),
(4053,NULL,'Сахненко Лена',NULL,'2019-07-15',NULL,380982653507,NULL,1140144759,'1',NULL,0,'','0'),
(4054,NULL,'Мороз Наталя',NULL,'2019-07-15',NULL,380971431343,NULL,1933183886,'1',NULL,0,'','0'),
(4055,NULL,'Варко таня',NULL,'2019-07-15',NULL,380682047433,NULL,2002475284,'1',61096,0,'','0'),
(4056,NULL,'Заводович Оля',NULL,'2019-07-15','ZAykV7AB6rkIpJeLuW/e3w==',380985376127,NULL,1920766947,'1',65168,0,'','0'),
(4057,NULL,'Перун Таня',NULL,'2019-07-16',NULL,380987655388,NULL,1347531264,'1',NULL,0,'','0'),
(4058,NULL,'Стефанець Катя',NULL,'2019-07-16',NULL,380983826844,NULL,1447592929,'1',NULL,0,'','0'),
(4059,NULL,'Бойко Марія',NULL,'2019-07-16',NULL,380966612752,NULL,1461147315,'1',NULL,0,'','0'),
(4060,NULL,'Литвин Олена',NULL,'2019-07-16','CkCozrSTdOFnI+k9F5tVXg==',380969852723,NULL,1524665726,'1',NULL,1,'','0'),
(4061,NULL,'шимків анна',NULL,'2019-07-17',NULL,380971299120,NULL,1349109146,'1',NULL,0,'','0'),
(4062,NULL,'Побурина Марія',NULL,'2019-07-17',NULL,380664519990,NULL,1889683595,'1',NULL,0,'','0'),
(4063,NULL,'Гнівко Наталя',NULL,'2019-07-17',NULL,380978902560,NULL,1200071451,'1',NULL,0,'','0'),
(4064,NULL,'Морозова Вікторія',NULL,'2019-07-17',NULL,380959290155,NULL,1803199196,'1',NULL,0,'','0'),
(4065,NULL,'Зінюк Роксолана',NULL,'2019-07-18',NULL,380687072245,NULL,1851116665,'1',NULL,0,'','0'),
(4066,NULL,'Ратушняк Віра',NULL,'2019-07-19',NULL,380967663728,NULL,2046918632,'1',NULL,0,'','0'),
(4067,NULL,'Нога Ілона',NULL,'2019-07-19',NULL,380664540247,NULL,1810273742,'1',NULL,0,'','0'),
(4068,NULL,'Забіяка ЛІза',NULL,'2019-07-19',NULL,380671094060,NULL,1897250365,'1',NULL,1,'','0'),
(4069,NULL,'Мартінів Єлезавета',NULL,'2019-07-19',NULL,380688863039,NULL,1144600221,'1',NULL,0,'','0'),
(4070,NULL,'Вівчарик Марія',NULL,'2019-07-19',NULL,380976568734,NULL,1896485615,'1',NULL,0,'','0'),
(4071,NULL,'Грицина Іванна',NULL,'2019-07-21',NULL,380689638349,NULL,2127699040,'1',NULL,0,'','0'),
(4072,NULL,'Оробко Ксенія',NULL,'2019-07-22',NULL,380970935167,NULL,2082943058,'1',NULL,0,'','0'),
(4073,NULL,'Білецька Таня',NULL,'2019-07-22',NULL,380962100945,NULL,1507172179,'1',19674,0,'','0'),
(4074,NULL,'Коржевська Наталя',NULL,'2019-07-22',NULL,380678317794,NULL,1797504288,'1',NULL,0,'','0'),
(4075,NULL,'Павлюк Олена',NULL,'2019-07-22',NULL,380978344332,NULL,1113918353,'1',NULL,0,'','0'),
(4076,NULL,'Сухолотюк Ліля',NULL,'2019-07-22',NULL,380983523617,NULL,1735778310,'1',NULL,0,'','0'),
(4077,NULL,'КУшик Іра',NULL,'2019-07-22',NULL,380987850693,NULL,1449445518,'1',NULL,0,'','0'),
(4078,NULL,'Борис Таня',NULL,'2019-07-23','fdaBZZtkFirby0sJ4RH44Q==',380966863685,NULL,1904081337,'1',22066,0,'','0'),
(4079,NULL,'Мотрук Надя',NULL,'2019-07-23',NULL,380967550552,NULL,1517437481,'1',NULL,0,'','0'),
(4080,NULL,'Огородник Маша',NULL,'2019-07-23',NULL,380995517671,NULL,2096090315,'1',NULL,0,'','0'),
(4081,NULL,'Козловська Віолета',NULL,'2019-07-23',NULL,380965069227,NULL,1548100572,'1',NULL,0,'','0'),
(4082,NULL,'Марущак Христина',NULL,'2019-07-23',NULL,380995200691,NULL,1741092441,'1',NULL,0,'','0'),
(4083,NULL,'Задорожна оксана',NULL,'2019-07-23',NULL,380673936265,NULL,1437057372,'1',NULL,0,'','0'),
(4084,NULL,'Михальчук Валерія',NULL,'2019-07-24',NULL,380666460453,NULL,1502472656,'1',NULL,0,'','0'),
(4085,NULL,'Стадник Анна',NULL,'2019-07-24',NULL,380683357571,NULL,1635754269,'1',NULL,0,'','0'),
(4086,NULL,'Федчишин Ольга',NULL,'2019-07-24',NULL,380684487536,NULL,1179676360,'1',NULL,0,'','0'),
(4087,NULL,'Похолків Руслана',NULL,'2019-07-24',NULL,380967471047,NULL,1985008396,'1',NULL,0,'','0'),
(4088,NULL,'бердецька вікторія',NULL,NULL,NULL,380680240479,NULL,1772234598,'1',NULL,0,'','0'),
(4089,NULL,'марусич таня',NULL,'2019-07-24',NULL,380971488330,NULL,1982745484,'1',NULL,0,'','0'),
(4090,NULL,'Орлик Ірина',NULL,'2019-07-25',NULL,380677925875,NULL,1671563410,'1',NULL,0,'','0'),
(4091,NULL,'Темчій  Хритстина',NULL,NULL,NULL,380680876265,NULL,1870946133,'1',NULL,0,'','0'),
(4092,NULL,'Пастущак Наталя',NULL,'2019-07-25',NULL,380675789492,NULL,1769373399,'1',NULL,0,'','0'),
(4093,NULL,'Турчак іванна',NULL,'2019-07-25',NULL,380682129941,NULL,1357078306,'1',NULL,0,'','0'),
(4094,NULL,'Кінаш Люда',NULL,'2019-07-25',NULL,380686929612,NULL,1453217154,'1',NULL,0,'','0'),
(4095,NULL,'Гук Оксана',NULL,'2019-07-25',NULL,380968390911,NULL,1746881424,'1',NULL,0,'','0'),
(4096,NULL,'Воробець Інна',NULL,'2019-07-26',NULL,380688696270,NULL,1865379772,'1',NULL,0,'','0'),
(4097,NULL,'Катеринюк Юля',NULL,'2019-07-26',NULL,380972050828,NULL,1253434877,'1',NULL,0,'','0'),
(4098,NULL,'Ляхоцька Алла',NULL,'2019-07-26',NULL,380685871700,NULL,1476864563,'1',NULL,0,'','0'),
(4099,NULL,'Сідор Оля',NULL,'2019-07-27',NULL,380980336867,NULL,1438323622,'1',NULL,0,'','0'),
(4100,NULL,'Горяча Уляна',NULL,'2019-07-27',NULL,380964127484,NULL,2129535457,'1',NULL,0,'','0'),
(4101,NULL,'Олещук Квіта',NULL,'2019-07-27',NULL,380968141554,NULL,2069779809,'1',NULL,1,'','0'),
(4102,NULL,'марчин яна',NULL,'2019-07-27',NULL,380985722895,NULL,1187086569,'1',NULL,0,'','0'),
(4103,NULL,'Зеленяк Оксана',NULL,'2019-07-29',NULL,380968983495,NULL,2073008215,'1',NULL,0,'','0'),
(4104,NULL,'Бажанська Віка',NULL,'2019-07-29',NULL,380688631626,NULL,1783944263,'1',NULL,0,'','0'),
(4105,NULL,'Музичка Андрій',NULL,'2019-07-30',NULL,380976892765,NULL,2095149722,'1',NULL,0,'','0'),
(4106,NULL,'Магировська Наталя',NULL,'2019-07-30',NULL,380964255902,NULL,1319871867,'1',30038,0,'','0'),
(4107,NULL,'Гнатюк Аліна',NULL,'2019-07-31',NULL,380961985210,NULL,1335614802,'1',NULL,0,'','0'),
(4108,NULL,'Скрипка Марія',NULL,'2019-07-31',NULL,380960407727,NULL,1177166736,'1',NULL,0,'','0'),
(4109,NULL,'Руда галя ',NULL,'2019-07-31',NULL,380979684058,NULL,1323563080,'1',NULL,0,'','0'),
(4110,NULL,'Яремків Леся',NULL,'2019-07-31',NULL,380936353732,NULL,1154569847,'1',NULL,0,'','0'),
(4111,NULL,'Микитин Соломія',NULL,'2019-07-31',NULL,380672812149,NULL,1216787170,'1',64881,0,'','0'),
(4112,NULL,'Собчишин Світлана',NULL,'2019-08-01',NULL,380986304392,NULL,1883037973,'1',NULL,0,'','0'),
(4113,NULL,'Данюк Наталя',NULL,'2019-08-01',NULL,380680093533,NULL,1219147142,'1',NULL,0,'','0'),
(4114,NULL,'Кучерява Христина',NULL,'2019-08-01',NULL,380951364049,NULL,2113104647,'1',NULL,0,'','0'),
(4115,NULL,'Кузільна Юля',NULL,NULL,NULL,380632890612,NULL,1667135363,'1',NULL,0,'','0'),
(4116,NULL,'Овод Христина',NULL,'2019-08-02',NULL,380678680802,NULL,2115048110,'1',NULL,0,'','0'),
(4117,NULL,'Нагірна Марія',NULL,'2019-08-03',NULL,380681272463,NULL,1334199210,'1',NULL,0,'','0'),
(4118,NULL,'Струтинська Наталя',NULL,'2019-08-03',NULL,380680245540,NULL,1150521771,'1',NULL,0,'','0'),
(4119,NULL,'Галанчук Олена',NULL,'2019-08-03','v92k/mpUVyZ80d05Pay1gw==',380687351439,NULL,1517751020,'1',NULL,0,'','0'),
(4120,NULL,'Безушко Оксана',NULL,'2019-08-03',NULL,380973845418,NULL,2005024247,'1',NULL,0,'','0'),
(4121,NULL,'Рогатин Світлана',NULL,'2019-08-03',NULL,380983465330,NULL,1436239896,'1',NULL,0,'','0'),
(4122,NULL,'Мацишин Оксана',NULL,'2019-08-05',NULL,380960002843,NULL,1198145821,'1',NULL,0,'','0'),
(4123,NULL,'Савіцька Сніжана',NULL,'2019-08-05',NULL,380630794959,NULL,2022122950,'1',NULL,0,'','0'),
(4124,NULL,'Мельничук Таня',NULL,'2019-08-05',NULL,380975546344,NULL,1564682865,'1',NULL,0,'','0'),
(4125,NULL,'Івасів Уляна',NULL,'2019-08-05',NULL,380673855068,NULL,1761462175,'1',NULL,0,'','0'),
(4126,NULL,'Осиф Таня',NULL,'2019-08-05',NULL,380957339316,NULL,1558603727,'1',NULL,0,'','0'),
(4127,NULL,'Пилипів маряна',NULL,'2019-08-05',NULL,380687031638,NULL,1296188444,'1',NULL,0,'','0'),
(4128,NULL,'Галабура Ірина',NULL,'2019-08-05','IJp1LyPSyhF08GXleGpx4Q==',380665316796,NULL,1807944956,'1',47764,0,'','0'),
(4129,NULL,'Чайковська Олена',NULL,'2019-08-06',NULL,380680847058,NULL,1175334816,'1',NULL,0,'','0'),
(4130,NULL,'Чайковська Анжела',NULL,'2019-08-06',NULL,380672753130,NULL,1592603536,'1',NULL,0,'','0'),
(4131,NULL,'Фургала Ірина',NULL,'2019-08-06',NULL,380965030554,NULL,1912140587,'1',NULL,0,'','0'),
(4132,NULL,'Бойчук Оля',NULL,'2019-08-06',NULL,380677015731,NULL,1899786395,'1',NULL,0,'','0'),
(4133,NULL,'Янч Альбіна',NULL,'2019-08-06',NULL,380968830492,NULL,1652541501,'1',NULL,1,'','0'),
(4134,NULL,'Осадчук Таня',NULL,'2019-08-06',NULL,380962753964,NULL,2119613594,'1',NULL,0,'','0'),
(4135,NULL,'Чернецька Любов',NULL,NULL,NULL,380682610979,NULL,1239121677,'1',NULL,0,'','0'),
(4136,NULL,'Моткалюк Таня',NULL,'2019-08-07',NULL,380971057318,NULL,1858580785,'1',47438,0,'','0'),
(4137,NULL,'Рихлівська Іра',NULL,'2019-08-07',NULL,380963629018,NULL,1654563177,'1',NULL,0,'','0'),
(4138,NULL,'Мушинська Марія',NULL,'2019-08-07',NULL,380977899791,NULL,1861686592,'1',NULL,0,'','0'),
(4139,NULL,'Андрусишин Наталя',NULL,'2019-08-07',NULL,380673252744,NULL,1595166140,'1',NULL,0,'','0'),
(4140,NULL,'Гасяк Галина',NULL,NULL,NULL,380686475428,NULL,1643190046,'1',NULL,0,'','0'),
(4141,NULL,'Наконечна Уляна',NULL,'2019-08-08',NULL,380688470296,NULL,1999119703,'1',NULL,0,'','0'),
(4142,NULL,'Когут Марія ',NULL,'2019-08-08',NULL,380989123391,NULL,1939193204,'1',NULL,0,'','0'),
(4143,NULL,'блага наталя',NULL,'2019-08-08',NULL,380502976178,NULL,1497192393,'1',NULL,0,'','0'),
(4144,NULL,'Бігуляк Наталя',NULL,'2019-08-09',NULL,380681764247,NULL,1593247712,'1',NULL,0,'','0'),
(4145,NULL,'Опацька Юля',NULL,'2019-08-09',NULL,380966008104,NULL,2073471108,'1',NULL,0,'','0'),
(4146,NULL,'Кобильняк Аліна',NULL,'2019-08-09',NULL,380984868152,NULL,1421495989,'1',38596,0,'','0'),
(4147,NULL,'Вейко Світлана',NULL,'2019-08-09',NULL,380680472907,NULL,1969857977,'1',NULL,2,'','0'),
(4148,NULL,'Голодрига Аліна',NULL,'2019-08-09',NULL,380989613396,NULL,1520852122,'1',63414,0,'','0'),
(4149,NULL,'Суховій Маряна',NULL,'2019-08-10',NULL,380960605249,NULL,1592537733,'1',NULL,2,'','0'),
(4150,NULL,'Тимчасюк  Іванна',NULL,NULL,NULL,380971085409,NULL,1835545077,'1',39705,2,'','0'),
(4151,NULL,'Сікора Уляна',NULL,'2019-08-11',NULL,380684348253,NULL,2081083502,'1',NULL,0,'','0'),
(4152,NULL,'Прокопів Наталя',NULL,'2019-08-12',NULL,380984056929,NULL,2033349654,'1',NULL,0,'','0'),
(4153,NULL,'Загарська Галина',NULL,'2019-08-12',NULL,380982533601,NULL,1307828623,'1',NULL,0,'','0'),
(4154,NULL,'Мендик Оля',NULL,'2019-08-13',NULL,380991687644,NULL,1463393679,'1',NULL,0,'','0'),
(4155,NULL,'Панченко Оксана',NULL,'2019-08-13',NULL,380663265448,NULL,1461284381,'1',NULL,1,'','0'),
(4156,NULL,'Бажер Христина',NULL,'2019-08-13',NULL,380685523114,NULL,2132405193,'1',NULL,0,'','0'),
(4157,NULL,'Прондюк Лєна',NULL,'2019-08-13',NULL,380979721429,NULL,1827741864,'1',NULL,0,'','0'),
(4158,NULL,'Горбач Оля',NULL,'2019-08-13',NULL,380954817209,NULL,1566651636,'1',NULL,0,'','0'),
(4159,NULL,'Шекульська Оля',NULL,'2019-08-14',NULL,380988813019,NULL,1835541795,'1',NULL,0,'','0'),
(4160,NULL,'Іонуца Світлана',NULL,'2019-08-14',NULL,380688381200,NULL,1828595828,'1',NULL,0,'','0'),
(4161,NULL,'Максимишин Надя',NULL,'2019-08-14',NULL,380985344045,NULL,1609859101,'1',NULL,0,'','0'),
(4162,NULL,'Прохорова Настя',NULL,'2019-08-14',NULL,380954885698,NULL,1326504436,'1',NULL,0,'','0'),
(4163,NULL,'Цепла Наталя',NULL,'2019-08-15',NULL,380970571921,NULL,1273030505,'1',NULL,1,'','0'),
(4164,NULL,'іскра діана',NULL,'2019-08-15',NULL,380682682452,NULL,1979157378,'1',NULL,0,'','0'),
(4165,NULL,'Ковальчук Люда',NULL,'2019-08-15',NULL,380971725169,NULL,1528524107,'1',NULL,0,'','0'),
(4166,NULL,'Урбан Наталя',NULL,'2019-08-16',NULL,380973415381,NULL,1547178165,'1',NULL,0,'','0'),
(4167,NULL,'Слонь Таня',NULL,'2019-08-16',NULL,380963912009,NULL,1675771447,'1',NULL,0,'','0'),
(4168,NULL,'Савельєва Таня',NULL,NULL,NULL,380666410754,NULL,1441271982,'1',NULL,0,'','0'),
(4169,NULL,'Пазин Іванна',NULL,'2019-08-16',NULL,380681154558,NULL,1187937135,'1',NULL,0,'','0'),
(4170,NULL,'Капунова Леся',NULL,'2019-08-16',NULL,380678764412,NULL,1405124017,'1',NULL,0,'','0'),
(4171,NULL,'Кравець Люба',NULL,'2019-08-17',NULL,380506712915,NULL,1686846746,'1',NULL,0,'','0'),
(4172,NULL,'Працьовита Маряна',NULL,'2019-08-17',NULL,380970019893,NULL,1640527943,'1',NULL,0,'','0'),
(4173,NULL,'Ткачук Катя',NULL,'2019-08-17',NULL,380682834421,NULL,1733526584,'1',NULL,0,'','0'),
(4174,NULL,'Біла Христина',NULL,'2019-08-17',NULL,380989053421,NULL,1952729582,'1',NULL,0,'','0'),
(4175,NULL,'Котик Юля',NULL,'2019-08-19',NULL,380939435422,NULL,1577096197,'1',NULL,0,'','0'),
(4176,NULL,'сендзюк наталя',NULL,'2019-08-19','Pfar7DdEq8GVWVwm6MrWUA==',380966376816,NULL,1383302926,'1',NULL,1,'','0'),
(4177,NULL,'Дерій Вікторія',NULL,'2019-08-20',NULL,380986746349,NULL,1119183946,'1',NULL,1,'','0'),
(4178,NULL,'Слободян Наталя',NULL,'2019-08-20','NGPVQByrjjJv3h6RG1MYcw==',380681377405,NULL,1833657754,'1',NULL,0,'','0'),
(4179,NULL,'Капаць Галина',NULL,'2019-08-20',NULL,380971156034,NULL,2027418165,'1',NULL,0,'','0'),
(4180,NULL,'Барицька Ліда',NULL,'2019-08-20',NULL,380968752095,NULL,1910977331,'1',NULL,0,'','0'),
(4181,NULL,'Михайлюк Наталя',NULL,'2019-08-20',NULL,380686051944,NULL,1316778710,'1',NULL,0,'','0'),
(4182,NULL,'уситинова ірина',NULL,'2019-08-20',NULL,380987278086,NULL,1165038884,'1',NULL,0,'','0'),
(4183,NULL,'Гайдук Наталя',NULL,'2019-08-21','/yvvOauE0jxk2LeNNS3wqw==',380685297793,NULL,1512912653,'1',55690,0,'','0'),
(4184,NULL,'Стешин Андріана',NULL,'2019-08-21',NULL,380971809910,NULL,1692827977,'1',39501,0,'','0'),
(4185,NULL,'Вівчарик Христина',NULL,'2019-08-21',NULL,380675859276,NULL,1596955607,'1',NULL,0,'','0'),
(4186,NULL,'Лищишин Оксана',NULL,'2019-08-21',NULL,380686649692,NULL,2053147236,'1',NULL,0,'','0'),
(4187,NULL,'Вусата Наталя',NULL,'2019-08-21',NULL,380980617875,NULL,2031637972,'1',NULL,0,'','0'),
(4188,NULL,'Куфель Софія',NULL,'2019-08-21',NULL,380935983611,NULL,1479581403,'1',NULL,0,'','0'),
(4189,NULL,'Рибчак Надія',NULL,'2019-08-21',NULL,380986513347,NULL,2030641026,'1',NULL,0,'','0'),
(4190,NULL,'Юрків Ярослава',NULL,'2019-08-21',NULL,380669493732,NULL,2029404964,'1',NULL,0,'','0'),
(4191,NULL,'Батрак Альона',NULL,'2019-08-22',NULL,380994473554,NULL,1650650640,'1',NULL,0,'','0'),
(4192,NULL,'Оробчук Ганна',NULL,'2019-08-22',NULL,380683070412,NULL,2137652314,'1',NULL,0,'','0'),
(4193,NULL,'Новакова Любов',NULL,'2019-08-22',NULL,380665611672,NULL,1757577448,'1',NULL,1,'','0'),
(4194,NULL,'Коланич Наталя',NULL,'2019-08-22',NULL,380509718753,NULL,1388267477,'1',NULL,0,'','0'),
(4195,NULL,'Склярська Таня',NULL,'2019-08-22',NULL,380966085192,NULL,1907346926,'1',NULL,0,'','0'),
(4196,NULL,'Білінська Наталя',NULL,'2019-08-23',NULL,380967585611,NULL,2056152405,'1',NULL,0,'','0'),
(4197,NULL,'Трач Уляна',NULL,'2019-08-23',NULL,380686460277,NULL,1528982139,'1',NULL,0,'','0'),
(4198,NULL,'Войтович Оля',NULL,'2019-08-23',NULL,380665649732,NULL,1854416989,'1',NULL,0,'','0'),
(4199,NULL,'Івасюк Маірія',NULL,'2019-08-26','hSKH2NHWSYvZSkXDNct93Q==',380975380125,NULL,1894228255,'1',26004,0,'','0'),
(4200,NULL,'Вербіцька Галина',NULL,'2019-08-26','o3k733esCULykaNBteKFcw==',380969937963,NULL,1687727509,'1',21092,0,'','0'),
(4201,NULL,'Шестерина Іра',NULL,'2019-08-26',NULL,380988942814,NULL,1141430941,'1',NULL,0,'','0'),
(4202,NULL,'Мисюра Таня',NULL,'2019-08-26',NULL,380671678320,NULL,1198153770,'1',NULL,0,'','0'),
(4203,NULL,'Дядів Світлана',NULL,'2019-08-26',NULL,380982900542,NULL,1783447223,'1',NULL,0,'','0'),
(4204,NULL,'Огородник Віра',NULL,'2019-08-27',NULL,380978814389,NULL,2089719230,'1',NULL,0,'','0'),
(4205,NULL,'Опихана Галина',NULL,'2019-08-27',NULL,380979201249,NULL,2084616055,'1',NULL,0,'','0'),
(4206,NULL,'Сесак Маряна',NULL,'2019-08-27',NULL,380683459680,NULL,1708504427,'1',NULL,0,'','0'),
(4207,NULL,'Лешун Віка',NULL,'2019-08-27',NULL,380971474056,NULL,1143051879,'1',NULL,0,'','0'),
(4208,NULL,'Гоцай Наталя',NULL,'2019-08-27',NULL,380632616719,NULL,1299523452,'1',NULL,0,'','0'),
(4209,NULL,'Татарин Аня',NULL,'2019-08-27',NULL,380984946757,NULL,1706985417,'1',NULL,0,'','0'),
(4210,NULL,'Ковальчук Таня',NULL,'2019-08-27',NULL,380666559108,NULL,1826607001,'1',NULL,1,'','0'),
(4211,NULL,'Домик Оксана',NULL,'2019-08-28',NULL,380972292101,NULL,1808495631,'1',NULL,0,'','0'),
(4212,NULL,'Мазур ВІка',NULL,'2019-08-29',NULL,380963440602,NULL,1768566416,'1',NULL,1,'','0'),
(4213,NULL,'Бичко Наталя',NULL,'2019-08-29',NULL,380674954618,NULL,1693810601,'1',54715,0,'','0'),
(4214,NULL,'Стасишин Ірина',NULL,'2019-08-29',NULL,380681604086,NULL,1655960686,'1',NULL,0,'','0'),
(4215,NULL,'Гут Наталя',NULL,'2019-08-30',NULL,380680171915,NULL,2019234130,'1',NULL,0,'','0'),
(4216,NULL,'мацишин Соломія ',NULL,'2019-08-30',NULL,380977941234,NULL,1744166616,'1',NULL,0,'','0'),
(4217,NULL,'Патроняк Марія',NULL,'2019-08-31',NULL,380967213534,NULL,1272175996,'1',NULL,0,'','0'),
(4218,NULL,'Стецюк Марія',NULL,'2019-08-31',NULL,380683083736,NULL,1321275996,'1',NULL,0,'','0'),
(4219,NULL,'Ткачук Таня',NULL,'2019-09-02',NULL,380968509584,NULL,2046235528,'1',NULL,0,'','0'),
(4220,NULL,'Запотічна Марія',NULL,'2019-09-02',NULL,380997471524,NULL,1617732899,'1',NULL,0,'','0'),
(4221,NULL,'мотрук наталя',NULL,'2019-09-02',NULL,380984772483,NULL,1243034244,'1',NULL,0,'','0'),
(4222,NULL,'хлібович ярина',NULL,'2019-09-02',NULL,380731193913,NULL,1863129326,'1',NULL,0,'','0'),
(4223,NULL,'Осадца Галина',NULL,'2019-09-02',NULL,380978754236,NULL,1116315024,'1',NULL,0,'','0'),
(4224,NULL,'Туранська Марія',NULL,'2019-09-03',NULL,380964815845,NULL,2073269805,'1',NULL,0,'','0'),
(4225,NULL,'Рогатинська Таня',NULL,'2019-09-03',NULL,380669651745,NULL,1658694173,'1',NULL,0,'','0'),
(4226,NULL,'Сеньків Олена',NULL,'2019-09-03',NULL,380680373568,NULL,1443606075,'1',NULL,0,'','0'),
(4227,NULL,'Лисейко Люба',NULL,'2019-09-03',NULL,380509162315,NULL,1404585148,'1',NULL,0,'','0'),
(4228,NULL,'Попадюк Віка',NULL,'2019-09-03','V64dwc82o1OeWzpilCkg+g==',380977009096,NULL,1473834769,'1',13640,0,'','0'),
(4229,NULL,'Паньків Оля',NULL,'2019-09-03',NULL,380684211848,NULL,2042914854,'1',NULL,0,'','0'),
(4230,NULL,'Мелимука Іра',NULL,'2019-09-03',NULL,380977914452,NULL,1363306948,'1',NULL,0,'','0'),
(4231,NULL,'Герчак Влада',NULL,'2019-09-03',NULL,380687911445,NULL,1989371505,'1',NULL,0,'','0'),
(4232,NULL,'Галанюк Іванна',NULL,'2019-09-03',NULL,380680886174,NULL,1139960643,'1',NULL,0,'','0'),
(4233,NULL,'Підсадна Леся',NULL,'2019-09-03',NULL,380989412252,NULL,1662538245,'1',NULL,0,'','0'),
(4234,NULL,'Греськів Христя',NULL,'2019-09-04',NULL,380994241042,NULL,1411494667,'1',NULL,0,'','0'),
(4235,NULL,'Андрієвська Уляна',NULL,'2019-09-04',NULL,380973501377,NULL,1260037146,'1',NULL,0,'','0'),
(4236,NULL,'Когут Сніжана',NULL,'2019-09-04',NULL,380979247956,NULL,1337271023,'1',19475,0,'','0'),
(4237,NULL,'Когут Марія',NULL,'2019-09-05',NULL,380969938651,NULL,1159026747,'1',NULL,0,'','0'),
(4238,NULL,'Сулима Христина',NULL,'2019-09-05',NULL,380681759261,NULL,1191401280,'1',31363,0,'','0'),
(4239,NULL,'Крушельник Богдана',NULL,'2019-09-05',NULL,380971503160,NULL,1840740141,'1',NULL,0,'','0'),
(4240,NULL,'Денис Настя',NULL,'2019-09-05',NULL,380994248200,NULL,2016404462,'1',NULL,0,'','0'),
(4241,NULL,'Котик Юля',NULL,'2019-09-05',NULL,380678467749,NULL,2072753130,'1',NULL,0,'','0'),
(4242,NULL,'Дутчак Світлана',NULL,'2019-09-05',NULL,380969035094,NULL,2020159710,'1',NULL,0,'','0'),
(4243,NULL,'Надя',NULL,'2019-09-05',NULL,380974831141,NULL,1167564342,'1',NULL,0,'','0'),
(4244,NULL,'лохматов сергій',NULL,'2019-09-06',NULL,380970645269,NULL,1982093748,'1',NULL,0,'','0'),
(4245,NULL,'Лесик Любов',NULL,'2019-09-06',NULL,380969792959,NULL,1474735229,'1',NULL,0,'','0'),
(4246,NULL,'Данилишин Наталя',NULL,'2019-09-06',NULL,380967258017,NULL,1468069281,'1',NULL,0,'','0'),
(4247,NULL,'савків андріана',NULL,'2019-09-06',NULL,380968685707,NULL,2063519783,'1',NULL,0,'','0'),
(4248,NULL,'Дутка Галина',NULL,'2019-09-06',NULL,380958292560,NULL,1726849092,'1',NULL,0,'','0'),
(4249,NULL,'Бережак Марія',NULL,'2019-09-07',NULL,380668371043,NULL,2066714353,'1',NULL,0,'','0'),
(4250,NULL,'Шимків Олеся',NULL,'2019-09-07',NULL,380950812905,NULL,1882365170,'1',NULL,0,'','0'),
(4251,NULL,'Полівчук Іра',NULL,'2019-09-09',NULL,380686242930,NULL,1625355324,'1',NULL,0,'','0'),
(4252,NULL,'Лисак Марія',NULL,'2019-09-09',NULL,380675730199,NULL,1766682005,'1',NULL,0,'','0'),
(4253,NULL,'Романюк Таня',NULL,'2019-09-09',NULL,380977803296,NULL,1963066052,'1',NULL,0,'','0'),
(4254,NULL,'Кирилюк Таня',NULL,'2019-09-09',NULL,380985210442,NULL,2144104335,'1',38079,0,'','0'),
(4255,NULL,'Варганич Яна',NULL,'2019-09-09',NULL,380981095238,NULL,1974224445,'1',NULL,0,'','0'),
(4256,NULL,'Витвицька Таня',NULL,NULL,NULL,380963467875,NULL,1497077461,'1',NULL,0,'','0'),
(4257,NULL,'Бриндиш Іванка',NULL,'2019-09-09',NULL,380970967150,NULL,2072570007,'1',NULL,1,'','0'),
(4258,NULL,'Холявка Таня',NULL,'2019-09-10',NULL,380953876455,NULL,1199975185,'1',NULL,0,'','0'),
(4259,NULL,'Мелимука Олеся',NULL,'2019-09-10',NULL,380682524693,NULL,1656921408,'1',NULL,0,'','0'),
(4260,NULL,'Присяжна Аліна',NULL,'2019-09-10',NULL,380985276862,NULL,1882411546,'1',NULL,0,'','0'),
(4261,NULL,'Пахолків Вікторія',NULL,'2019-09-12',NULL,380979956168,NULL,1845913703,'1',NULL,0,'','0'),
(4262,NULL,'Лелик Оксана',NULL,NULL,NULL,380686413616,NULL,1227169185,'1',NULL,0,'','0'),
(4263,NULL,'швед ніна',NULL,'2019-09-12',NULL,380969784112,NULL,1932627475,'1',NULL,0,'','0'),
(4264,NULL,'Безпалько Соломія',NULL,'2019-09-12',NULL,380688598459,NULL,2087998055,'1',NULL,0,'','0'),
(4265,NULL,'Стешин Марія',NULL,NULL,NULL,380969278828,NULL,2101872356,'1',NULL,0,'','0'),
(4266,NULL,'Данилюк Ліля',NULL,'2019-09-13',NULL,380688427295,NULL,1890076436,'1',NULL,1,'','0'),
(4267,NULL,'Саврас Оля',NULL,'2019-09-13',NULL,380982405728,NULL,1607485121,'1',NULL,0,'','0'),
(4268,NULL,'Мендик Христина',NULL,'2019-09-13',NULL,380502947646,NULL,1983814050,'1',NULL,0,'','0'),
(4269,NULL,'Кобилюх Христина',NULL,NULL,NULL,380988167663,NULL,2122458779,'1',NULL,0,'','0'),
(4270,NULL,'Полівчук Оксана',NULL,'2019-09-13',NULL,380665171747,NULL,1775304647,'1',NULL,0,'','0'),
(4271,NULL,'Галяс Леся',NULL,'2019-09-13',NULL,380660463818,NULL,1378626963,'1',NULL,0,'','0'),
(4272,NULL,'Войцеховська Ірина',NULL,'2019-09-13',NULL,380981242755,NULL,1488312109,'1',NULL,0,'','0'),
(4273,NULL,'Прокіпчук Віталія ',NULL,'2019-09-15',NULL,380964514643,NULL,1938186342,'1',NULL,0,'','0'),
(4274,NULL,'Приймак Наталя',NULL,'2019-09-16',NULL,380685515699,NULL,1184833651,'1',NULL,0,'','0'),
(4275,NULL,'Владика Оксана',NULL,'2019-09-16',NULL,380989877365,NULL,1635883201,'1',NULL,0,'','0'),
(4276,NULL,'Подолянська марія',NULL,'2019-09-16',NULL,380685416640,NULL,1226895109,'1',NULL,0,'','0'),
(4277,NULL,'Предик Юля',NULL,'2019-09-16',NULL,380974249761,NULL,2071173516,'1',NULL,0,'','0'),
(4278,NULL,'Павлюк Настя',NULL,'2019-09-16',NULL,380974578310,NULL,1717736980,'1',NULL,0,'','0'),
(4279,NULL,'Малічовська Оля',NULL,'2019-09-17',NULL,380970892967,NULL,1477625792,'1',NULL,0,'','0'),
(4280,NULL,'Несвадьба Ліля',NULL,'2019-09-17',NULL,380973657716,NULL,1803428930,'1',NULL,0,'','0'),
(4281,NULL,'Лучка Ліля',NULL,'2019-09-17',NULL,380995620996,NULL,1651729381,'1',NULL,0,'','0'),
(4282,NULL,'Кобеля Оксана',NULL,'2019-09-17','fqqozAqB6Zwq11xQJGWOew==',380975474294,NULL,1473099010,'1',NULL,1,'','0'),
(4283,NULL,'Лесюк Іра',NULL,'2019-09-17',NULL,380671904542,NULL,2081333320,'1',NULL,0,'','0'),
(4284,NULL,'Юзишен Галина',NULL,'2019-09-17',NULL,380969170880,NULL,1143054074,'1',NULL,0,'','0'),
(4285,NULL,'Гупайло Петро',NULL,'2019-09-18',NULL,380680951569,NULL,1938501461,'1',NULL,0,'','0'),
(4286,NULL,'Дячок Таня',NULL,'2019-09-18',NULL,380676969070,NULL,1965500606,'1',NULL,1,'','0'),
(4287,NULL,'Зінюк Каріна',NULL,'2019-09-18',NULL,380677549002,NULL,1994803006,'1',NULL,0,'','0'),
(4288,NULL,'Караїм Уляна',NULL,NULL,'cVQdD82NvNZd0XMLWmO8lA==',380681660010,NULL,1461843380,'1',17321,2,'','0'),
(4289,NULL,'Пятківська Надія',NULL,'2019-09-18',NULL,380685736551,NULL,1726427815,'1',NULL,0,'','0'),
(4290,NULL,'Гладюк Таня',NULL,'2019-09-18',NULL,380681760482,NULL,2088205286,'1',NULL,0,'','0'),
(4291,NULL,'Кучера Оля',NULL,'2019-09-18',NULL,380993460851,NULL,1818333308,'1',NULL,0,'','0'),
(4292,NULL,'Шевчук Марія',NULL,'2019-09-19',NULL,380979038353,NULL,1451685322,'1',NULL,0,'','0'),
(4293,NULL,'Ільків Олена',NULL,'2019-09-19',NULL,380978203151,NULL,1651036701,'1',NULL,0,'','0'),
(4294,NULL,'Павлюк Галина',NULL,'2019-09-19',NULL,380988394998,NULL,2017728534,'1',NULL,0,'','0'),
(4295,NULL,'Різник Катя',NULL,'2019-09-19',NULL,380969795006,NULL,1515847352,'1',NULL,0,'','0'),
(4296,NULL,'Миськів наталя',NULL,'2019-09-19',NULL,380961100689,NULL,1399356469,'1',NULL,0,'','0'),
(4297,NULL,'Корольчук Настя',NULL,'2019-09-19',NULL,380970521825,NULL,2037708153,'1',NULL,0,'','0'),
(4298,NULL,'Сульжук Настя',NULL,'2019-09-19',NULL,380960268073,NULL,2114909788,'1',NULL,0,'','0'),
(4299,NULL,'штогрин марія',NULL,'2019-09-20',NULL,380961343326,NULL,1854893286,'1',NULL,0,'','0'),
(4300,NULL,'Сень Юля',NULL,'2019-09-20',NULL,380680109350,NULL,1633136557,'1',NULL,0,'','0'),
(4301,NULL,'Кондак Христина',NULL,'2019-09-20',NULL,380972818232,NULL,1334585778,'1',NULL,0,'','0'),
(4302,NULL,'Дідик Руслана',NULL,'2019-09-20',NULL,380979853637,NULL,1374431705,'1',NULL,0,'','0'),
(4303,NULL,'Лапчук Зоряна',NULL,'2019-09-20',NULL,380678793318,NULL,1553632793,'1',NULL,0,'','0'),
(4304,NULL,'Варчак Надя',NULL,'2019-09-20',NULL,380966436294,NULL,2101781879,'1',NULL,0,'','0'),
(4305,NULL,'Лиса Зоряна',NULL,'2019-09-20',NULL,380678428256,NULL,1857958337,'1',NULL,0,'','0'),
(4306,NULL,'скрипник марія',NULL,'2019-09-21',NULL,380963079791,NULL,1365711787,'1',NULL,0,'','0'),
(4307,NULL,'Ганакова Валентина',NULL,'2019-09-21',NULL,380684381329,NULL,1563037332,'1',NULL,0,'','0'),
(4308,NULL,'Лопушняк Оксана',NULL,'2019-09-22',NULL,380689814092,NULL,1969596672,'1',NULL,0,'','0'),
(4309,NULL,'Гнатюк Юля',NULL,'2019-09-22',NULL,380981712919,NULL,1758281240,'1',NULL,0,'','0'),
(4310,NULL,'Король Наталя',NULL,'2019-09-23',NULL,380685871691,NULL,1390859033,'1',NULL,0,'','0'),
(4311,NULL,'дубина Олеся',NULL,NULL,'SrvQfMCLsSf4PtQ0DjFx9Q==',380681054752,NULL,1147448566,'1',17173,0,'','0'),
(4312,NULL,'Литінська Галина',NULL,'2019-09-23',NULL,380976105546,NULL,1379089842,'1',NULL,0,'','0'),
(4313,NULL,'Білецька Юля',NULL,'2019-09-23',NULL,380989752129,NULL,1479284527,'1',NULL,0,'','0'),
(4314,NULL,'Сметанюк Віка',NULL,'2019-09-23',NULL,380672725307,NULL,1629365470,'1',NULL,0,'','0'),
(4315,NULL,'Коршняк Галина',NULL,'2019-09-23',NULL,380973500604,NULL,2096592072,'1',NULL,0,'','0'),
(4316,NULL,'Бедьо Вікторія',NULL,'2019-09-24',NULL,380986475162,NULL,1284661669,'1',NULL,0,'','0'),
(4317,NULL,'іваськів олена',NULL,'2019-09-24','sz9gGpGujO7OyZ92Oqhn8g==',380980185514,NULL,1599375478,'1',39512,0,'','0'),
(4318,NULL,'Сенків Марія',NULL,NULL,NULL,380983560408,NULL,1791449299,'1',43220,0,'','0'),
(4319,NULL,'Вербіцька Наталя',NULL,'2019-09-24',NULL,380682384547,NULL,1552210754,'1',NULL,0,'','0'),
(4320,NULL,'Ласківська Василина',NULL,'2019-09-25',NULL,380984794143,NULL,1232037493,'1',NULL,0,'','0'),
(4321,NULL,'Остапович Надія',NULL,'2019-09-25',NULL,380973035035,NULL,1512389207,'1',NULL,0,'','0'),
(4322,NULL,'Мельничук Валентина',NULL,NULL,NULL,380961596308,NULL,1479887105,'1',47232,0,'','0'),
(4323,NULL,'Бондар Христина',NULL,'2019-09-25',NULL,380682888088,NULL,1676980111,'1',NULL,0,'','0'),
(4324,NULL,'Голод Ялта',NULL,'2019-09-25',NULL,380972618715,NULL,1851907769,'1',48993,0,'','0'),
(4325,NULL,'Семчишин Віталіна',NULL,'2019-09-25',NULL,380685860910,NULL,1822525570,'1',NULL,0,'','0'),
(4326,NULL,'Кузяк Оля',NULL,'2019-09-26',NULL,380971312958,NULL,1451133431,'1',NULL,1,'','0'),
(4327,NULL,'Німець Галя',NULL,'2019-09-26',NULL,380663533903,NULL,1254049650,'1',NULL,1,'','0'),
(4328,NULL,'Шпортак Уляна',NULL,'2019-09-26',NULL,380971170400,NULL,1963800986,'1',NULL,0,'','0'),
(4329,NULL,'Трифой Уляна',NULL,'2019-09-26',NULL,380680940450,NULL,2012442862,'1',NULL,0,'','0'),
(4330,NULL,'Томак Марія',NULL,'2019-09-27',NULL,380676392035,NULL,1922375125,'1',NULL,0,'','0'),
(4331,NULL,'Костюк Юля',NULL,'2019-09-27',NULL,380981185885,NULL,1594799494,'1',NULL,1,'','0'),
(4332,NULL,'Пивовар оля',NULL,'2019-09-27',NULL,380977291515,NULL,1927692857,'1',NULL,0,'','0'),
(4333,NULL,'Хамчук наталя',NULL,'2019-09-27',NULL,380950253561,NULL,2143398878,'1',NULL,0,'','0'),
(4334,NULL,'Карпович Юля',NULL,'2019-09-27',NULL,380639295166,NULL,1620622519,'1',NULL,0,'','0'),
(4335,NULL,'Шарам марія',NULL,'2019-09-28',NULL,380985779134,NULL,1345460288,'1',NULL,0,'','0'),
(4336,NULL,'Ганіщук Михайло ',NULL,'2019-09-28',NULL,380966671761,NULL,1416945759,'1',41334,0,'','0'),
(4337,NULL,'Заводовська Алла',NULL,'2019-09-28',NULL,380676392047,NULL,1745001294,'1',NULL,0,'','0'),
(4338,NULL,'Дражньовська діана',NULL,'2019-09-30',NULL,380983107519,NULL,1123871655,'1',NULL,0,'','0'),
(4339,NULL,'Халявська Марія',NULL,'2019-09-30',NULL,380960270018,NULL,1253260130,'1',NULL,1,'','0'),
(4340,NULL,'Хорощак Софія ',NULL,NULL,NULL,380951046123,NULL,1499361621,'1',17043,0,'','0'),
(4341,NULL,'Голуб Юля ',NULL,'2019-09-30',NULL,380979258386,NULL,1938782208,'1',NULL,0,'','0'),
(4342,NULL,'Федик Люба',NULL,'2019-10-01',NULL,380987943352,NULL,1177135767,'1',NULL,0,'','0'),
(4343,NULL,'Федик Ілона',NULL,'2019-10-02',NULL,380978559137,NULL,1304501125,'1',NULL,0,'','0'),
(4344,NULL,'наталя наша',NULL,NULL,NULL,0,NULL,1750010182,'1',NULL,0,'','1'),
(4345,NULL,'Сидор Галина',NULL,'2019-10-03',NULL,380972051264,NULL,1925694128,'1',NULL,0,'','0'),
(4346,NULL,'Бегман ',NULL,'2019-10-03',NULL,NULL,NULL,2106704729,'1',NULL,0,'','0'),
(4347,NULL,'Дивоняк Марія',NULL,'2019-10-03',NULL,380971368221,NULL,1946693476,'1',22849,0,'','0'),
(4348,NULL,'Ружанська Христина',NULL,NULL,NULL,380985435979,NULL,1664236025,'1',NULL,0,'','0'),
(4349,NULL,'Сович Іра',NULL,'2019-10-03',NULL,380978650946,NULL,2129407410,'1',NULL,1,'','0'),
(4350,NULL,'Рудяк Христина ',NULL,'2019-10-03',NULL,380969952847,NULL,1193722151,'1',NULL,0,'','0'),
(4351,NULL,'Калугіна Олена',NULL,'2019-10-04',NULL,380988620735,NULL,1663941129,'1',NULL,0,'','0'),
(4352,NULL,'Різник Леся',NULL,'2019-10-04',NULL,380682234421,NULL,1943070735,'1',NULL,0,'','0'),
(4353,NULL,'Сюзанна',NULL,'2019-10-04',NULL,380679292068,NULL,1361370298,'1',NULL,0,'','0'),
(4354,NULL,'Дмитришин Оля',NULL,'2019-10-04',NULL,380987492800,NULL,2105855135,'1',NULL,0,'','0'),
(4355,NULL,'личман надія',NULL,'2019-10-04',NULL,380503221649,NULL,1390732215,'1',NULL,0,'','0'),
(4356,NULL,'Слободян Таня',NULL,'2019-10-05',NULL,380965339254,NULL,1948700033,'1',NULL,0,'','0'),
(4357,NULL,'Товпига Любов ',NULL,'2019-10-06',NULL,380681128390,NULL,1360714627,'1',NULL,0,'','0'),
(4358,NULL,'Суща Соломія ',NULL,'2019-10-06',NULL,380960062870,NULL,1618209516,'1',NULL,0,'','0'),
(4359,NULL,'Нагурська Маряна',NULL,'2019-10-07',NULL,380979093086,NULL,1398878514,'1',NULL,0,'','0'),
(4360,NULL,'Золота  Марія',NULL,'2019-10-07',NULL,380680151836,NULL,2134367268,'1',NULL,0,'','0'),
(4361,NULL,'Навроцька Лейла',NULL,'2019-10-07',NULL,380977121785,NULL,1980849202,'1',NULL,0,'','0'),
(4362,NULL,'Овод Наталя',NULL,'2019-10-07',NULL,380679831126,NULL,1270588629,'1',NULL,0,'','0'),
(4363,NULL,'Горяча Оксана',NULL,'2019-10-07',NULL,380680117238,NULL,1345910612,'1',NULL,0,'','0'),
(4364,NULL,'Гуцул Іванка',NULL,'2019-10-07',NULL,380965262388,NULL,2046165652,'1',NULL,0,'','0'),
(4365,NULL,'Гаврон Оксана',NULL,'2019-10-07',NULL,380671078116,NULL,1261922711,'1',NULL,0,'','0'),
(4366,NULL,'Шевчук Наталя',NULL,'2019-10-08',NULL,380976263819,NULL,2014714517,'1',NULL,0,'','0'),
(4367,NULL,'Томашевська марія',NULL,'2019-10-08',NULL,380982419883,NULL,1420130643,'1',NULL,0,'','0'),
(4368,NULL,'павшок світлана',NULL,'2019-10-08',NULL,380962571606,NULL,1376677142,'1',NULL,0,'','0'),
(4369,NULL,'Коновалова Лена',NULL,NULL,NULL,380675467326,NULL,1118069428,'1',NULL,0,'','0'),
(4370,NULL,'Слонь Христина',NULL,'2019-10-08',NULL,380968114849,NULL,1823992528,'1',NULL,1,'','0'),
(4371,NULL,'Пуляк Христина',NULL,'2019-10-08',NULL,380976045169,NULL,1129531676,'1',NULL,0,'','0'),
(4372,NULL,'Павліка віка',NULL,NULL,NULL,380980294863,NULL,1625286250,'1',NULL,1,'','0'),
(4373,NULL,'Біла Оля',NULL,'2019-10-08',NULL,380673921507,NULL,1881181160,'1',NULL,0,'','0'),
(4374,NULL,'Гумерова Ельвіра',NULL,'2019-10-09',NULL,380980523952,NULL,1804713203,'1',NULL,0,'','0'),
(4375,NULL,'Баран Аліна',NULL,'2019-10-09',NULL,380962319008,NULL,1997343434,'1',62149,0,'','0'),
(4376,NULL,'Гриців Наталя',NULL,'2019-10-09',NULL,380984158568,NULL,2105623690,'1',NULL,0,'','0'),
(4377,NULL,'Підкович Христина ',NULL,'2019-10-10',NULL,380689355060,NULL,2123241181,'1',NULL,0,'','0'),
(4378,NULL,'Багрий Надя',NULL,'2019-10-10',NULL,380982384781,NULL,2129657869,'1',NULL,0,'','0'),
(4379,NULL,'Банчишин Зоряна',NULL,'2019-10-10',NULL,380686497988,NULL,1566245613,'1',NULL,0,'','0'),
(4380,NULL,'Архіпович Іванна ',NULL,'2019-10-10',NULL,380689814505,NULL,1818723022,'1',NULL,0,'','0'),
(4381,NULL,'Семковська Марія ',NULL,'2019-10-10',NULL,380971225061,NULL,1450695144,'1',NULL,0,'','0'),
(4382,NULL,'Луків Іванна',NULL,'2019-10-11',NULL,380676714233,NULL,1492067788,'1',NULL,0,'','0'),
(4383,NULL,'Надвернюк Христина',NULL,'2019-10-11','QTW2UmNAZfpUd3td4KORcw==',380972314702,NULL,1857210764,'1',NULL,0,'','0'),
(4384,NULL,'Трач Марія',NULL,'2019-10-11',NULL,380989606550,NULL,1972538859,'1',NULL,0,'','0'),
(4385,NULL,'Матвієшин Олеся',NULL,'2019-10-11',NULL,380987490249,NULL,1483720326,'1',NULL,0,'','0'),
(4386,NULL,'Годована Оля',NULL,'2019-10-12',NULL,380978032485,NULL,1734194827,'1',NULL,1,'','0'),
(4387,NULL,'Шмігулець Ірина',NULL,'2019-10-12',NULL,380966905021,NULL,1476160012,'1',NULL,0,'','0'),
(4388,NULL,'Станько Галина',NULL,'2019-10-13',NULL,380974153789,NULL,1456749496,'1',NULL,0,'','0'),
(4389,NULL,'Кватирук Ання',NULL,'2019-10-14',NULL,380983076429,NULL,1654611997,'1',NULL,0,'','0'),
(4390,NULL,'Огородник Маргарита',NULL,'2019-10-14',NULL,380965475928,NULL,1867376734,'1',NULL,0,'','0'),
(4391,NULL,'Савчук Роман',NULL,NULL,NULL,380969435786,NULL,2125412061,'1',NULL,0,'','0'),
(4392,NULL,'Богачик Оля',NULL,'2019-10-15',NULL,380970554260,NULL,1156873154,'1',NULL,0,'','0'),
(4393,NULL,'Солтисяк Марія',NULL,'2019-10-15',NULL,380986168246,NULL,1211523591,'1',NULL,0,'','0'),
(4394,NULL,'Чубата  Оля',NULL,'2019-10-15',NULL,380680587880,NULL,1160820047,'1',NULL,0,'','0'),
(4395,NULL,'Богоніс Оксана',NULL,'2019-10-16',NULL,380966929957,NULL,1943196060,'1',NULL,0,'','0'),
(4396,NULL,'Ільчук Наталя',NULL,'2019-10-16',NULL,380680946627,NULL,1757911779,'1',NULL,0,'','0'),
(4397,NULL,'Хельмут Інна',NULL,'2019-10-16',NULL,380980130128,NULL,1408369130,'1',42664,0,'','0'),
(4398,NULL,'Матвіїшин Іра',NULL,'2019-10-16',NULL,380680567220,NULL,1504372672,'1',NULL,0,'','0'),
(4399,NULL,'Білик Марія ',NULL,'2019-10-16',NULL,380985265030,NULL,1712430867,'1',NULL,0,'','0'),
(4400,NULL,'Ярема Зоряна',NULL,'2019-10-17',NULL,380985452912,NULL,2077975693,'1',NULL,2,'','0'),
(4401,NULL,'Пожарнюк Наталя',NULL,'2019-10-17',NULL,380957680971,NULL,1861280985,'1',NULL,0,'','0'),
(4402,NULL,'Заболотна Світлана',NULL,'2019-10-18',NULL,380932531501,NULL,1718007252,'1',NULL,0,'','0'),
(4403,NULL,'Блаженко Юля',NULL,'2019-10-18',NULL,380987319813,NULL,2088874310,'1',21692,0,'','0'),
(4404,NULL,'Мазуренко Іра',NULL,'2019-10-18',NULL,380676736667,NULL,1486563862,'1',NULL,2,'','0'),
(4405,NULL,'Карпович Оля',NULL,'2019-10-19',NULL,380989449122,NULL,1528846429,'1',NULL,0,'','0'),
(4406,NULL,'Скарлош Юля',NULL,'2019-10-19',NULL,380967881046,NULL,1208607875,'1',NULL,0,'','0'),
(4407,NULL,'Кирилів Оксана',NULL,'2019-10-21',NULL,380986475304,NULL,1692828524,'1',48492,0,'','0'),
(4408,NULL,'Бойчук Зоряна',NULL,'2019-10-21',NULL,380986566551,NULL,1243029947,'1',NULL,0,'','0'),
(4409,NULL,'Гіріч Юля',NULL,'2019-10-21',NULL,380993250507,NULL,1444841101,'1',NULL,0,'','0'),
(4410,NULL,'Нога Ларіса',NULL,NULL,NULL,380971247290,NULL,1629009746,'1',NULL,0,'','0'),
(4411,NULL,'Окіпна Зоряна',NULL,'2019-10-21','I7SJsYD+7hDb5nva3eyF9Q==',380500153733,NULL,1641728744,'1',NULL,1,'','0'),
(4412,NULL,'олеся король',NULL,'2019-10-21',NULL,380675907895,NULL,1681957930,'1',NULL,0,'','0'),
(4413,NULL,'Федорик Марія',NULL,'2019-10-22',NULL,380977126229,NULL,1477546055,'1',NULL,0,'','0'),
(4414,NULL,'Мальків Таня',NULL,'2019-10-22',NULL,380971313866,NULL,1291940381,'1',NULL,0,'','0'),
(4415,NULL,'Анастасія',NULL,'2019-10-22',NULL,380986000755,NULL,1548968747,'1',NULL,0,'','0'),
(4416,NULL,'Ружило Марія',NULL,NULL,NULL,380978890744,NULL,1846891683,'1',NULL,0,'','0'),
(4417,NULL,'Вишневська Іра',NULL,'2019-10-22',NULL,380684277876,NULL,1593958079,'1',NULL,0,'','0'),
(4418,NULL,'Панькевич Надя ',NULL,'2019-10-22',NULL,380982983143,NULL,1216544153,'1',NULL,0,'','0'),
(4419,NULL,'Воціховська Іра',NULL,'2019-10-23',NULL,380667905098,NULL,1378746037,'1',NULL,0,'','0'),
(4420,NULL,'Щегельська Марія',NULL,'2019-10-23',NULL,380501907487,NULL,1203612993,'1',NULL,0,'','0'),
(4421,NULL,'Маціборко Зоряна',NULL,'2019-10-23',NULL,380974416007,NULL,1435366472,'1',32074,1,'','0'),
(4422,NULL,'Ковпак Юля',NULL,NULL,NULL,380682384481,NULL,2082874857,'1',NULL,0,'','0'),
(4423,NULL,'Федорчук Соломія',NULL,'2019-10-24',NULL,380964212430,NULL,1643555462,'1',12724,0,'','0'),
(4424,NULL,'Окіпна Наталя',NULL,'2019-10-25',NULL,380683844427,NULL,1936420815,'1',NULL,0,'','0'),
(4425,NULL,'Війтишин оля',NULL,'2019-10-25',NULL,380966478104,NULL,1371356918,'1',25490,0,'','0'),
(4426,NULL,'Василишин настя',NULL,'2019-10-25',NULL,380688213592,NULL,1980379957,'1',NULL,0,'','0'),
(4427,NULL,'Строцень Олександра',NULL,'2019-10-26','etP50JCcvrolWtus39jW0g==',380966500511,NULL,1772045474,'1',63389,0,'','0'),
(4428,NULL,'Ватраль Іра',NULL,'2019-10-26',NULL,380968520166,NULL,2029200244,'1',NULL,0,'','0'),
(4429,NULL,'Сокальська Юлія',NULL,'2019-10-26',NULL,380686722048,NULL,1166614204,'1',NULL,0,'','0'),
(4430,NULL,'Федорців Наталя',NULL,'2019-10-26',NULL,380682466521,NULL,2064374004,'1',NULL,0,'','0'),
(4431,NULL,'Бородій Леся',NULL,'2019-10-26',NULL,380982838101,NULL,1409422930,'1',NULL,1,'','0'),
(4432,NULL,'Деренівська Аліна ',NULL,'2019-10-26',NULL,380669300216,NULL,1825506812,'1',NULL,0,'','0'),
(4433,NULL,'Федорів Володимир',NULL,'2019-10-29',NULL,380674557684,NULL,2055216301,'1',NULL,0,'','0'),
(4434,NULL,'Колодій Оля',NULL,'2019-10-29',NULL,380686712509,NULL,1112746246,'1',NULL,2,'','0'),
(4435,NULL,'Кузик Оксана',NULL,'2019-10-29',NULL,380962420723,NULL,1662108044,'1',NULL,0,'','0'),
(4436,NULL,'Безпалько Марія',NULL,'2019-10-29',NULL,380971176432,NULL,1909275901,'1',NULL,0,'','0'),
(4437,NULL,'Чорна Настя',NULL,'2019-10-29',NULL,380680512405,NULL,1147682508,'1',26816,0,'','0'),
(4438,NULL,'Савка Таня',NULL,'2019-10-30',NULL,380689812097,NULL,1720768471,'1',NULL,0,'','0'),
(4439,NULL,'Батрин Марія',NULL,'2019-10-30',NULL,380974158373,NULL,1877948625,'1',NULL,0,'','0'),
(4440,NULL,'Горобець Леся',NULL,'2019-10-30',NULL,380974092192,NULL,1687144777,'1',NULL,0,'','0'),
(4441,NULL,'Козій марія',NULL,'2019-10-31',NULL,380679842751,NULL,1890489575,'1',NULL,0,'','0'),
(4442,NULL,'Чорній Іра',NULL,'2019-10-31','jV6A3dPW5bcnmYgyk1iCGg==',380986322941,NULL,1400893088,'1',56156,0,'','0'),
(4443,NULL,'Вережак Марія',NULL,'2019-10-31',NULL,380964706922,NULL,1615584632,'1',NULL,2,'','0'),
(4444,NULL,'Сагайдак Наталя',NULL,'2019-10-31',NULL,380987968935,NULL,1779288679,'1',NULL,0,'','0'),
(4445,NULL,'Марусяк Іванна',NULL,'2019-10-31',NULL,380680541364,NULL,1746107792,'1',NULL,0,'','0'),
(4446,NULL,'Деревянчук Христина',NULL,'2019-10-31',NULL,380685836326,NULL,2057942730,'1',NULL,1,'','0'),
(4447,NULL,'Стрілецька Діана',NULL,'2019-10-31',NULL,380686413115,NULL,1547564760,'1',NULL,1,'','0'),
(4448,NULL,'Малічевська Мар’яна ',NULL,'2019-10-31',NULL,380960401972,NULL,1654721634,'1',NULL,0,'','0'),
(4449,NULL,'Дідух Іванка',NULL,'2019-10-31',NULL,380502019931,NULL,1228708483,'1',NULL,0,'','0'),
(4450,NULL,'Дутка Марія',NULL,'2019-11-01',NULL,380984758141,NULL,1254229760,'1',NULL,0,'','0'),
(4451,NULL,'Конет Таня',NULL,'2019-11-01',NULL,380995404638,NULL,1855341979,'1',NULL,0,'','0'),
(4452,NULL,'Гевко Алла',NULL,'2019-11-02','vaUmCMwHZSKbdvRQ58i28g==',380987400199,NULL,1116710032,'1',NULL,0,'','0'),
(4453,NULL,'Крамарчук Андріана',NULL,'2019-11-04',NULL,380978425876,NULL,1572515441,'1',18849,0,'','0'),
(4454,NULL,'Міхна Софія',NULL,'2019-11-04',NULL,380973375145,NULL,1309863343,'1',NULL,0,'','0'),
(4455,NULL,'Білик Роксолана ',NULL,'2019-11-04',NULL,380682466762,NULL,1378246522,'1',NULL,0,'','0'),
(4456,NULL,'іра наша',NULL,'2019-11-05',NULL,NULL,NULL,1803406231,'1',NULL,0,'','0'),
(4457,NULL,'Гондз Христина ',NULL,'2019-11-05',NULL,380995134150,NULL,1646470661,'1',NULL,1,'','0'),
(4458,NULL,'Романюк Юля',NULL,'2019-11-05',NULL,380989964476,NULL,1338604521,'1',NULL,0,'','0'),
(4459,NULL,'Дуда Марія ',NULL,'2019-11-06',NULL,380931369727,NULL,1403297534,'1',NULL,0,'','0'),
(4460,NULL,'Гайдук Оля',NULL,'2019-11-07',NULL,380966848082,NULL,1132902696,'1',NULL,0,'','0'),
(4461,NULL,'герилюк Аліна',NULL,NULL,'92GkOIvy6pcDW+Y9mh3ftQ==',380677073779,NULL,1573454122,'1',61688,0,'','0'),
(4462,NULL,'Стефанів Таня',NULL,'2019-11-07',NULL,380685508217,NULL,1835483496,'1',NULL,0,'','0'),
(4463,NULL,'Коцур Таня',NULL,'2019-11-08',NULL,380988651386,NULL,2046930453,'1',NULL,0,'','0'),
(4464,NULL,'Клевчук Юлія',NULL,'2019-11-09',NULL,380681132705,NULL,1345980597,'1',NULL,0,'','0'),
(4465,NULL,'Нізьо Ангеліна',NULL,'2019-11-10',NULL,380961862877,NULL,2074045115,'1',NULL,0,'','0'),
(4466,NULL,'Снігур Любов ',NULL,'2019-11-11',NULL,380961308904,NULL,2020457843,'1',NULL,0,'','0'),
(4467,NULL,'Казюк Надя',NULL,'2019-11-11',NULL,380977098571,NULL,1409221539,'1',NULL,0,'','0'),
(4468,NULL,'Яковлюк Марія',NULL,'2019-11-11',NULL,380954440726,NULL,1950153664,'1',NULL,0,'','0'),
(4469,NULL,'Марчук Наталя',NULL,'2019-11-12',NULL,380964210860,NULL,1570209432,'1',NULL,0,'','0'),
(4470,NULL,'Єленчук Наталя',NULL,'2019-11-13',NULL,380680463242,NULL,1993009045,'1',NULL,0,'','0'),
(4471,NULL,'Бачинська Марія',NULL,'2019-11-13',NULL,380972937265,NULL,1890181322,'1',NULL,0,'','0'),
(4472,NULL,'Бойко Зінаїда',NULL,'2019-11-13',NULL,380672616208,NULL,1457360754,'1',NULL,0,'','0'),
(4473,NULL,'Подолянська Галина',NULL,NULL,NULL,380960506206,NULL,1859370051,'1',NULL,0,'','0'),
(4474,NULL,'Шикоряк Анна',NULL,'2019-11-13',NULL,380971340325,NULL,2021771119,'1',NULL,0,'','0'),
(4475,NULL,'Світановська марія',NULL,NULL,NULL,380689471898,NULL,1563486801,'1',NULL,0,'','0'),
(4476,NULL,'гевко марія',NULL,'2019-11-14',NULL,380684260887,NULL,1520399128,'1',NULL,0,'','0'),
(4477,NULL,'Мацієвська Юля',NULL,NULL,'6Cg5peXuFGG76Cf625GFRQ==',380967711015,380997502742,1436571956,'1',NULL,0,'','0'),
(4478,NULL,'Гаврилюк Таня',NULL,'2019-11-15',NULL,380971519324,NULL,1870088108,'1',NULL,0,'','0'),
(4479,NULL,'Семенчук Уляна',NULL,'2019-11-15',NULL,380685367325,NULL,1501719156,'1',NULL,0,'','0'),
(4480,NULL,'Винничин христя',NULL,NULL,NULL,380636577154,NULL,1994902054,'1',45595,0,'','0'),
(4481,NULL,'Олещук Павліна',NULL,'2019-11-15',NULL,380501504612,NULL,1356034686,'1',44962,0,'','0'),
(4482,NULL,'коцюба ольга',NULL,'2019-11-15',NULL,380957203944,NULL,1411365575,'1',NULL,0,'','0'),
(4483,NULL,'Бартків Уляна',NULL,'2019-11-15','Jwli1bUfS5IfS4YCGFA/2g==',380987224504,NULL,2090835856,'1',24201,1,'','0'),
(4484,NULL,'Припка леся',NULL,'2019-11-16',NULL,380680208031,NULL,1653629783,'1',NULL,1,'','0'),
(4485,NULL,'Середа діана',NULL,'2019-11-16',NULL,380686708376,NULL,1496245812,'1',NULL,0,'','0'),
(4486,NULL,'Середа наталя',NULL,'2019-11-16',NULL,380961314578,NULL,1905553005,'1',NULL,0,'','0'),
(4487,NULL,'Безпалько оксана',NULL,'2019-11-16','QiX2GiDy0P4fDfO9hA21dw==',380984298290,NULL,1426117330,'1',41307,0,'','0'),
(4488,NULL,'Коваль Аня',NULL,'2019-11-17',NULL,380982159707,NULL,1231233841,'1',NULL,0,'','0'),
(4489,NULL,'Миронюк Олеся',NULL,'2019-11-17',NULL,380688461355,NULL,1489572225,'1',NULL,0,'','0'),
(4490,NULL,'Гудь Аліна ',NULL,'2019-11-17',NULL,380982190677,NULL,2112917801,'1',NULL,0,'','0'),
(4491,NULL,'Провальна Наталя',NULL,'2019-11-18',NULL,380963982338,NULL,1343375035,'1',NULL,0,'','0'),
(4492,NULL,'Мачужак Дана',NULL,'2019-11-18',NULL,380969816109,NULL,1457813015,'1',NULL,0,'','0'),
(4493,NULL,'Савчук світлана',NULL,'2019-11-19',NULL,380967468039,NULL,1173878613,'1',NULL,0,'','0'),
(4494,NULL,'Мала Юля',NULL,'2019-11-19',NULL,380982290904,NULL,2109576436,'1',NULL,0,'','0'),
(4495,NULL,'Пастушак Наталя',NULL,'2019-11-20',NULL,380989877296,NULL,1618515117,'1',NULL,0,'','0'),
(4496,NULL,'Война Галина',NULL,'2019-11-20',NULL,380686242920,NULL,1386017902,'1',NULL,0,'','0'),
(4497,NULL,'Юхим Юля',NULL,'2019-11-20','rK2aYCTE4HQvU/7H/YPPiQ==',380971355122,NULL,1269449373,'1',48253,2,'','0'),
(4498,NULL,'Бендзар Оля ',NULL,'2019-11-21',NULL,380963449859,NULL,1451166615,'1',NULL,0,'','0'),
(4499,NULL,'Воробець Руслана',NULL,'2019-11-21',NULL,380977112609,NULL,1605500696,'1',NULL,0,'','0'),
(4500,NULL,'Фрікас Маряна ',NULL,'2019-11-22',NULL,380677181561,NULL,1950590244,'1',NULL,1,'','0');

INSERT INTO `kontragentu` VALUES 
(4501,NULL,'Тимофій маряна',NULL,'2019-11-22',NULL,380678680648,NULL,1269319372,'1',35307,2,'','0'),
(4502,NULL,'Степанчук Наталя',NULL,NULL,NULL,380965552853,NULL,1784460052,'1',NULL,0,'','0'),
(4503,NULL,'Пархоменко Даша',NULL,NULL,NULL,380685918989,NULL,1607223746,'1',NULL,0,'','0'),
(4504,NULL,'Борсукова Вікторія',NULL,'2019-11-23',NULL,380639482561,NULL,1307463075,'1',NULL,0,'','0'),
(4505,NULL,'Скора Іванна',NULL,'2019-11-24',NULL,380984233611,NULL,1817255855,'1',NULL,0,'','0'),
(4506,NULL,'Сапіщук Іванна',NULL,'2019-11-24',NULL,380986177970,NULL,1189754471,'1',59101,0,'','0'),
(4507,NULL,'Лукинів Уляна',NULL,'2019-11-25',NULL,380968341638,NULL,1648132778,'1',NULL,0,'','0'),
(4508,NULL,'Гаєвська тома',NULL,'2019-11-25',NULL,380689697800,NULL,1657973151,'1',NULL,4,'','0'),
(4509,NULL,'Стахів Аліна',NULL,'2019-11-25',NULL,380680575256,NULL,1829624773,'1',NULL,0,'','0'),
(4510,NULL,'Ратушняк Наталя',NULL,'2019-11-25',NULL,380963278125,NULL,1309398258,'1',NULL,0,'','0'),
(4511,NULL,'Гуць Інна',NULL,'2019-11-26',NULL,380973715151,NULL,1638908399,'1',NULL,0,'','0'),
(4512,NULL,'Перців Сергій',NULL,'2019-11-26',NULL,380989235358,NULL,2124948835,'1',14350,0,'','0'),
(4513,NULL,'Зміяк Марія ',NULL,NULL,NULL,380982191308,NULL,1345943128,'1',NULL,1,'','1'),
(4514,NULL,'Слободян Іванна',NULL,'2019-11-26',NULL,380976682882,NULL,1638699989,'1',NULL,0,'','0'),
(4515,NULL,'Грицьо Марія',NULL,'2019-11-26',NULL,380971956440,NULL,1902492053,'1',NULL,0,'','0'),
(4516,NULL,'Дутчак Іра',NULL,'2019-11-26',NULL,380977381117,NULL,1487819459,'1',NULL,0,'','0'),
(4517,NULL,'Слободян Валентина',NULL,'2019-11-26',NULL,380678550856,NULL,1873510294,'1',NULL,0,'','0'),
(4518,NULL,'крошкіна іра',NULL,'2019-11-26',NULL,380985717298,NULL,2061973122,'1',NULL,0,'','0'),
(4519,NULL,'Нагирняк Таня',NULL,'2019-11-26',NULL,380954943604,NULL,1933580635,'1',NULL,0,'','0'),
(4520,NULL,'Коржак Каріна',NULL,'2019-11-26',NULL,380971698968,NULL,1956526122,'1',NULL,0,'','0'),
(4521,NULL,'Перута Валентина',NULL,'2019-11-26',NULL,380984044217,NULL,1172601362,'1',NULL,0,'','0'),
(4522,NULL,'Фундитус Настя',NULL,'2019-11-27',NULL,380506728837,NULL,1529631469,'1',NULL,0,'','0'),
(4523,NULL,'Гургач Галина',NULL,'2019-11-27',NULL,380967397471,NULL,2060246583,'1',NULL,0,'','0'),
(4524,NULL,'Рогатинська Люда',NULL,'2019-11-27',NULL,380986012880,NULL,1503044495,'1',NULL,0,'','0'),
(4525,NULL,'Король Ліля',NULL,'2019-11-27',NULL,380960537165,NULL,1371213016,'1',43761,0,'','0'),
(4526,NULL,'Павлина Марія',NULL,'2019-11-27',NULL,380666743900,NULL,1178870667,'1',NULL,0,'','0'),
(4527,NULL,'Онищук Діана',NULL,'2019-11-27',NULL,380961464892,NULL,1982350268,'1',NULL,2,'','0'),
(4528,NULL,'Король Вікторія',NULL,'2019-11-27',NULL,380956926380,NULL,1916395650,'1',NULL,0,'','0'),
(4529,NULL,'Король Ліля',NULL,'2019-11-27',NULL,380505740924,NULL,1309672895,'1',NULL,0,'','0'),
(4530,NULL,'Король Анастасія',NULL,'2019-11-27',NULL,380953981267,NULL,2088127792,'1',NULL,0,'','0'),
(4531,NULL,'Негрей Діана',NULL,'2019-11-28',NULL,380976804356,NULL,1458258625,'1',NULL,0,'','0'),
(4532,NULL,'Оводяк Христина',NULL,'2019-11-28',NULL,380675012514,NULL,1755896419,'1',NULL,0,'','0'),
(4533,NULL,'Чесель Марія',NULL,'2019-11-29',NULL,380967658526,NULL,1220496703,'1',NULL,0,'','0'),
(4534,NULL,'Антошків Христина',NULL,'2019-11-29',NULL,380983761461,NULL,1337865766,'1',NULL,0,'','0'),
(4535,NULL,'Совяк Оксана',NULL,'2019-11-30',NULL,380963576935,NULL,1155629303,'1',NULL,0,'','0'),
(4536,NULL,'Політаєва Таня',NULL,'2019-11-30',NULL,380688630633,NULL,1317244547,'1',NULL,0,'','0'),
(4537,NULL,'Бариська Христина',NULL,'2019-12-02',NULL,380966642103,NULL,1512739796,'1',61985,0,'','0'),
(4538,NULL,'Стефанюк Віка ',NULL,'2019-12-02',NULL,380984158472,NULL,1967213618,'1',NULL,0,'','0'),
(4539,NULL,'Риндич Настя ',NULL,'2019-12-02',NULL,380668955940,NULL,1573065334,'1',NULL,0,'','0'),
(4540,NULL,'Овод Христина',NULL,'2019-12-03',NULL,380976819621,NULL,1727968084,'1',NULL,0,'','0'),
(4541,NULL,'ониськів Віка',NULL,'2019-12-03',NULL,380682785356,NULL,1384558713,'1',NULL,0,'','0'),
(4542,NULL,'Ковцун Каріна ',NULL,'2019-12-03',NULL,380966701680,NULL,1753909334,'1',NULL,0,'','0'),
(4543,NULL,'Василюк Христина',NULL,'2019-12-04',NULL,380686565943,NULL,1738670022,'1',NULL,0,'','0'),
(4544,NULL,'Василюк Уляна',NULL,'2019-12-04',NULL,380686299030,NULL,1314143847,'1',NULL,0,'','0'),
(4545,NULL,'Захарчук таня',NULL,'2019-12-04',NULL,380982901258,NULL,2051958992,'1',NULL,1,'','0'),
(4546,NULL,'Коля',NULL,'2019-12-04',NULL,380978251064,NULL,1831902261,'1',NULL,0,'','0'),
(4547,NULL,'горбач юля',NULL,'2019-12-04',NULL,380686627829,NULL,1658830090,'1',NULL,0,'','0'),
(4548,NULL,'Федів надя',NULL,'2019-12-04',NULL,380686636101,NULL,1875464592,'1',NULL,0,'','0'),
(4549,NULL,'Гладій Олександра',NULL,'2019-12-04',NULL,380962757336,NULL,2124098282,'1',NULL,0,'','0'),
(4550,NULL,'Глинянська Наталя',NULL,'2019-12-05',NULL,380963447504,NULL,1311655089,'1',NULL,1,'','0'),
(4551,NULL,'Мамалига Іра',NULL,'2019-12-05',NULL,380688341652,NULL,1755816653,'1',NULL,0,'','0'),
(4552,NULL,'Грицько Олеся',NULL,'2019-12-05',NULL,380982175184,NULL,1894821569,'1',NULL,0,'','0'),
(4553,NULL,'тимофтей оксана',NULL,'2019-12-05',NULL,380684210321,NULL,1573464197,'1',NULL,0,'','0'),
(4554,NULL,'Голоднюк Марія',NULL,'2019-12-06',NULL,380978515237,NULL,1284054217,'1',NULL,0,'','0'),
(4555,NULL,'галич альона',NULL,'2019-12-06',NULL,380981155216,NULL,1214018788,'1',NULL,0,'','0'),
(4556,NULL,'Каськів Таня',NULL,'2019-12-06','j+9x2WlDz32cEdbquiQIgA==',380680171901,NULL,2074476659,'1',NULL,0,'','0'),
(4557,NULL,'чубка Галина',NULL,'2019-12-06',NULL,380988764090,NULL,1658963418,'1',NULL,0,'','0'),
(4558,NULL,'Паперняк Софія',NULL,'2019-12-07',NULL,380669932668,NULL,1514330413,'1',NULL,0,'','0'),
(4559,NULL,'Пласконь Леся',NULL,'2019-12-07',NULL,380686633803,NULL,1386614604,'1',NULL,0,'','0'),
(4560,NULL,'Покощан Христина',NULL,'2019-12-07',NULL,380977020650,NULL,1227743013,'1',NULL,0,'','0'),
(4561,NULL,'Васильковска Оля',NULL,'2019-12-07',NULL,380967842610,NULL,1225475953,'1',NULL,0,'','0'),
(4562,NULL,'Гула Вікторія',NULL,'2019-12-08',NULL,380991572372,NULL,1489445852,'1',NULL,0,'','0'),
(4563,NULL,'Макарова Аліна',NULL,'2019-12-08',NULL,380964319384,NULL,1170232283,'1',NULL,0,'','0'),
(4564,NULL,'Ластівка Галя',NULL,'2019-12-09',NULL,380687066766,NULL,1718477218,'1',NULL,0,'','0'),
(4565,NULL,'Наконечна Наталя',NULL,'2019-12-09',NULL,380686497561,NULL,2057805916,'1',NULL,0,'','0'),
(4566,NULL,'Наконечна Діана',NULL,'2019-12-09',NULL,380971629613,NULL,2097931996,'1',NULL,0,'','0'),
(4567,NULL,'Карпінська Таня',NULL,NULL,NULL,380979483112,NULL,1885005750,'1',NULL,0,'','0'),
(4568,NULL,'Федосюк Катерина',NULL,'2019-12-09',NULL,380688678870,NULL,1632164206,'1',NULL,0,'','0'),
(4569,NULL,'Грабець Інна',NULL,'2019-12-10',NULL,380986600379,NULL,1218058102,'1',NULL,0,'','0'),
(4570,NULL,'Кульчицька Люба',NULL,'2019-12-10','1Q3dFUigsPkYBLhFwMWBTA==',380988067317,NULL,2054995655,'1',31886,0,'','0'),
(4571,NULL,'Польова Люба',NULL,'2019-12-10',NULL,380978666455,NULL,1974763418,'1',NULL,0,'','0'),
(4572,NULL,'Криськів Оксана',NULL,'2019-12-10',NULL,380987902624,NULL,1680847642,'1',NULL,0,'','0'),
(4573,NULL,'Романович Марія',NULL,'2019-12-11',NULL,380680575282,NULL,1417995736,'1',NULL,0,'','0'),
(4574,NULL,'Іваноньків неля',NULL,'2019-12-11',NULL,380963192954,NULL,1725084481,'1',NULL,0,'','0'),
(4575,NULL,'Гошуляк Людмила',NULL,'2019-12-11',NULL,380960407784,NULL,1155655594,'1',NULL,0,'','0'),
(4576,NULL,'Шаровська Саша',NULL,'2019-12-11',NULL,380678467056,NULL,1388275041,'1',40665,0,'','0'),
(4577,NULL,'Гуска Аліна',NULL,'2019-12-11',NULL,380979124844,NULL,1818240113,'1',NULL,0,'','0'),
(4578,NULL,'Марчишин Галина',NULL,NULL,NULL,380963104160,NULL,1171609500,'1',NULL,0,'','0'),
(4579,NULL,'Войтенко Оксана',NULL,'2019-12-11',NULL,380984236782,NULL,1592379108,'1',NULL,0,'','0'),
(4580,NULL,'Каськів Надя',NULL,'2019-12-12',NULL,380979247994,NULL,1281177417,'1',NULL,0,'','0'),
(4581,NULL,'Гевко Ігор',NULL,'2019-12-12',NULL,380990503670,NULL,2035850554,'1',NULL,0,'','0'),
(4582,NULL,'Сорока Оксана',NULL,'2019-12-12',NULL,380666553416,NULL,1181325314,'1',NULL,0,'','0'),
(4583,NULL,'Семчишин Наталя',NULL,NULL,'HUg94QfM0KayfDykL6jAzw==',380978323327,NULL,1853238834,'1',NULL,0,'','0'),
(4584,NULL,'Ружицька Оксана',NULL,'2019-12-13',NULL,380976828568,NULL,2052052262,'1',NULL,0,'','0'),
(4585,NULL,'Зелінська Надія',NULL,'2019-12-13',NULL,380687068115,NULL,1744015342,'1',NULL,0,'','0'),
(4586,NULL,'Гнатишин Юля',NULL,'2019-12-13',NULL,380688107742,NULL,1507062924,'1',NULL,0,'','0'),
(4587,NULL,'Черкасова Мар’яна ',NULL,'2019-12-13',NULL,380684491768,NULL,1475874270,'1',NULL,2,'','0'),
(4588,NULL,'Білик Надія',NULL,'2019-12-14',NULL,380674008658,NULL,1958520040,'1',NULL,0,'','0'),
(4589,NULL,'Пуляк Наталя',NULL,'2019-12-14',NULL,380680460845,NULL,1331074266,'1',NULL,0,'','0'),
(4590,NULL,'Кулій Юлія',NULL,NULL,NULL,380960025153,NULL,1392855561,'1',NULL,0,'','0'),
(4591,NULL,'Патуляк Оксана',NULL,'2019-12-14',NULL,380964243691,NULL,2075035027,'1',NULL,0,'','0'),
(4592,NULL,'Богуш аліна',NULL,'2019-12-16',NULL,380962432487,NULL,1714968531,'1',NULL,0,'','0'),
(4593,NULL,'Лапчук Зоряна',NULL,'2019-12-16',NULL,380971038226,NULL,2063204072,'1',NULL,0,'','0'),
(4594,NULL,'паньків Оля',NULL,NULL,NULL,380963122787,NULL,1586393985,'1',NULL,0,'','0'),
(4595,NULL,'Золота Таня ',NULL,'2019-12-16',NULL,380988465560,NULL,1150115542,'1',NULL,0,'','0'),
(4596,NULL,'Перців Ганна',NULL,'2019-12-16',NULL,380971718352,NULL,1361165420,'1',NULL,1,'','0'),
(4597,NULL,'Савченко Емілія',NULL,'2019-12-16',NULL,380681253118,NULL,1978900540,'1',NULL,2,'','0'),
(4598,65535,'Рихлівська Ангеліна',NULL,NULL,NULL,380984227973,NULL,2101679802,'1',NULL,0,'','0'),
(4599,NULL,'Кулій таня',NULL,'2019-12-17',NULL,380961282445,NULL,1509615932,'1',NULL,0,'','0'),
(4600,NULL,'Плескач Ірина',NULL,NULL,NULL,380976973972,NULL,1356444600,'1',NULL,0,'','0'),
(4601,NULL,'Понюк Ангеліна',NULL,'2019-12-17',NULL,380671306544,NULL,1577107704,'1',63143,0,'','0'),
(4602,NULL,'Бала Юлія',NULL,'2019-12-17',NULL,380976999873,NULL,1465276275,'1',NULL,0,'','0'),
(4603,NULL,'Беренда Надія',NULL,'2019-12-18',NULL,380678465038,NULL,1323671106,'1',NULL,0,'','0'),
(4604,NULL,'Консограда Аня',NULL,'2019-12-18',NULL,380686116540,NULL,1136840178,'1',NULL,0,'','0'),
(4605,NULL,'Міляр Юля',NULL,'2019-12-18',NULL,380976073347,NULL,2061882848,'1',NULL,0,'','0'),
(4606,NULL,'Львівська Наталя',NULL,'2019-12-18',NULL,380672835675,NULL,1746641577,'1',NULL,0,'','0'),
(4607,NULL,'Вербіцька Рома',NULL,'2019-12-18',NULL,380958215412,NULL,1857196800,'1',NULL,0,'','0'),
(4608,NULL,'Тихановська Ольга',NULL,'2019-12-18',NULL,380678488486,NULL,1475502106,'1',NULL,0,'','0'),
(4609,NULL,'Нагорська Аліна',NULL,'2019-12-18',NULL,380974944341,NULL,1570002349,'1',NULL,0,'','0'),
(4610,NULL,'Островська Олеся',NULL,NULL,NULL,380685540005,NULL,1811109297,'1',30344,0,'','0'),
(4611,NULL,'Рекрут Ірина',NULL,'2019-12-19',NULL,380683787536,NULL,1917325446,'1',NULL,0,'','0'),
(4612,NULL,'Гула Люда',NULL,'2019-12-19',NULL,380990201906,NULL,2041429891,'1',NULL,0,'','0'),
(4613,NULL,'Коршняк Тетяна',NULL,'2019-12-20',NULL,380684241646,NULL,1378166344,'1',NULL,1,'','0'),
(4614,NULL,'Скотніцька Христина',NULL,'2019-12-20','8/kU/wOXa7M1pZK4wftn0Q==',380979500486,NULL,1275605806,'1',NULL,0,'','0'),
(4615,NULL,'Єринюк Олеся',NULL,NULL,NULL,380675467369,NULL,1802136209,'1',NULL,0,'','0'),
(4616,NULL,'Танчик Діма',NULL,'2019-12-20',NULL,380977326268,NULL,1179259913,'1',NULL,0,'','0'),
(4617,NULL,'Дякун Леся',NULL,'2019-12-20',NULL,380972280507,NULL,1499554349,'1',NULL,0,'','0'),
(4618,NULL,'Тарабалка Наталія',NULL,'2019-12-20',NULL,380970534358,NULL,1640678471,'1',NULL,0,'','0'),
(4619,NULL,'Юрків Наталя',NULL,NULL,NULL,380977350078,NULL,1888037850,'1',NULL,0,'','0'),
(4620,NULL,'Сеник Віра',NULL,'2019-12-21',NULL,380984237641,NULL,1763472229,'1',19173,0,'','0'),
(4621,NULL,'цепенда Лозовська',NULL,NULL,NULL,380969591455,NULL,1249325431,'1',NULL,0,'','0'),
(4622,NULL,'Головата Наталя',NULL,'2019-12-21',NULL,380960505122,NULL,1203573055,'1',NULL,0,'','0'),
(4623,NULL,'Лазорук Софія',NULL,'2019-12-21',NULL,380974122785,NULL,1813236032,'1',NULL,0,'','0'),
(4624,NULL,'Буденькевич Віталіна',NULL,'2019-12-21',NULL,380677874270,NULL,1342987860,'1',NULL,1,'','0'),
(4625,NULL,'Косінська Оксана',NULL,'2019-12-21',NULL,380980603181,NULL,1435250906,'1',NULL,0,'','0'),
(4626,NULL,'Фецуляк Маша ',NULL,'2019-12-22',NULL,380685874876,NULL,1490926189,'1',NULL,0,'','0'),
(4627,NULL,'Соловйова Тетяна',NULL,'2019-12-23',NULL,380682420573,NULL,1414128301,'1',NULL,1,'','0'),
(4628,NULL,'Грохольська Надія',NULL,'2019-12-23',NULL,380988983458,NULL,1188592241,'1',NULL,0,'','0'),
(4629,NULL,'Холоднюк Ірина',NULL,'2019-12-23',NULL,380665036794,NULL,1181202891,'1',NULL,0,'','0'),
(4630,NULL,'Філінчук Наталя',NULL,NULL,NULL,380976882281,NULL,1443379497,'1',NULL,0,'','0'),
(4631,NULL,'Ванцяк Аліна',NULL,'2019-12-24',NULL,380683116136,NULL,1655037290,'1',60514,0,'','0'),
(4632,NULL,'Анастасія Зеленюк',NULL,'2019-12-24',NULL,380971200561,NULL,1557281978,'1',NULL,0,'','0'),
(4633,NULL,'Заболотна Ольга',NULL,'2019-12-24',NULL,380988460428,NULL,1202320256,'1',NULL,0,'','0'),
(4634,NULL,'Балик Роксолана',NULL,'2019-12-24',NULL,380096950015,NULL,1229207938,'1',NULL,0,'','0'),
(4635,NULL,'Микуляк Аліна',NULL,NULL,NULL,380680116067,NULL,1180523168,'1',NULL,0,'','0'),
(4636,NULL,'Гоголь Наталія',NULL,'2019-12-26',NULL,380964262048,NULL,1509741207,'1',NULL,0,'','0'),
(4637,NULL,'Сергеева Олександра',NULL,NULL,NULL,380963014774,NULL,1582514409,'1',NULL,0,'','0'),
(4638,NULL,'Семків Наталя',NULL,'2019-12-27',NULL,380097807461,NULL,1349746524,'1',NULL,0,'','0'),
(4639,NULL,'Семків Наталя',NULL,'2019-12-27',NULL,380978074619,NULL,2100272547,'1',NULL,0,'','0'),
(4640,NULL,'Золотоцька Діана',NULL,'2019-12-27',NULL,380978492387,NULL,1703717558,'1',29779,0,'','0'),
(4641,NULL,'Катернюк Оля',NULL,NULL,NULL,380993018241,NULL,1439982621,'1',NULL,0,'','0'),
(4642,NULL,'Завгородня Наталя',NULL,NULL,NULL,380991924988,NULL,1587635758,'1',NULL,0,'','0'),
(4643,NULL,'Дутчак Наталя',NULL,'2019-12-28',NULL,380979465755,NULL,1268040501,'1',NULL,0,'','0'),
(4644,NULL,'Мудрик Євгенія',NULL,'2019-12-28',NULL,380672564364,NULL,1507248626,'1',NULL,0,'','0'),
(4645,NULL,'Повшок Марія',NULL,'2019-12-28',NULL,380974115301,NULL,2082683898,'1',NULL,0,'','0'),
(4646,NULL,'Лящук Людмила ',NULL,'2019-12-31',NULL,380960500437,NULL,1810551908,'1',NULL,0,'','0'),
(4647,NULL,'Івануць Олександра',NULL,'2020-01-02',NULL,380978452398,NULL,1408334817,'1',NULL,0,'','0'),
(4648,NULL,'Козак Віта',NULL,'2020-01-02','KaZyM1EtxQ/LKWO5xt9CvQ==',380675907835,NULL,1202655660,'1',NULL,0,'','0'),
(4649,NULL,'Гуць Інна',NULL,'2020-01-04',NULL,380988904304,NULL,1299697767,'1',NULL,0,'','0'),
(4650,NULL,'Нефьодова Анна',NULL,'2020-01-04',NULL,380985230245,NULL,1348052841,'1',NULL,0,'','0'),
(4651,NULL,'Мальована Галина',NULL,'2020-01-04',NULL,380957093257,NULL,1477267768,'1',NULL,0,'','0'),
(4652,NULL,'Склярук Оля',NULL,'2020-01-04',NULL,380986567227,NULL,1804361770,'1',NULL,0,'','0'),
(4653,NULL,'Хрущ Зеновія',NULL,'2020-01-04',NULL,380973971256,NULL,1191527942,'1',NULL,0,'','0'),
(4654,NULL,'Винничук Наталя',NULL,'2020-01-04',NULL,380970764789,NULL,1417752871,'1',49165,1,'','0'),
(4655,NULL,'Дякун Леся',NULL,'2020-01-04',NULL,380683042662,NULL,2143078195,'1',NULL,0,'','0'),
(4656,NULL,'Асанова Іра',NULL,'2020-01-09',NULL,380970490860,NULL,1524067586,'1',NULL,0,'','0'),
(4657,NULL,'Скрипник Анжела',NULL,'2020-01-10',NULL,380686497589,NULL,1177215233,'1',NULL,0,'','0'),
(4658,NULL,'Ворох Віта',NULL,'2020-01-10',NULL,380989741547,NULL,1660562344,'1',NULL,1,'','0'),
(4659,NULL,'Сорока Таня',NULL,'2020-01-11',NULL,380976486988,NULL,1631983668,'1',NULL,0,'','0'),
(4660,NULL,'Мальована Катерина',NULL,NULL,NULL,380968972519,NULL,1792159991,'1',11851,0,'','0'),
(4661,NULL,'Циплінська Христина',NULL,'2020-01-12',NULL,380974564253,NULL,2063162793,'1',NULL,0,'','0'),
(4662,NULL,'Склярук Анастасія',NULL,'2020-01-12',NULL,380989081017,NULL,1189400341,'1',NULL,0,'','0'),
(4663,NULL,'Танасів Вікторія',NULL,'2020-01-12',NULL,380970040689,NULL,1983641952,'1',NULL,0,'','0'),
(4664,NULL,'Гошуляк Людмила',NULL,'2020-01-13',NULL,380962784201,NULL,1735829010,'1',NULL,0,'','0'),
(4665,NULL,'Галиш Олена',NULL,'2020-01-13',NULL,380660272645,NULL,1482171412,'1',NULL,0,'','0'),
(4666,NULL,'Струтинська Віта',NULL,NULL,NULL,380974477623,NULL,2040920941,'1',NULL,0,'','0'),
(4667,NULL,'Романець Марія',NULL,'2020-01-15',NULL,380985353359,NULL,1773570167,'1',NULL,0,'','0'),
(4668,NULL,'Зелінська Надія',NULL,'2020-01-15',NULL,380680880242,NULL,1729108742,'1',NULL,0,'','0'),
(4669,NULL,'Міляр Анна',NULL,'2020-01-16',NULL,380989033983,NULL,2015059141,'1',NULL,0,'','0'),
(4670,NULL,'Хлопецька Оксана',NULL,'2020-01-16',NULL,380978505094,NULL,1793360057,'1',NULL,0,'','0'),
(4671,NULL,'Боднар Галина',NULL,'2020-01-16',NULL,380975985643,NULL,1369670174,'1',NULL,0,'','0'),
(4672,NULL,'Харук Іра',NULL,'2020-01-16',NULL,380680496947,NULL,1297582415,'1',NULL,0,'','0'),
(4673,NULL,'Гуцайлюк Настя',NULL,'2020-01-16',NULL,380959428680,NULL,1212375931,'1',NULL,0,'','0'),
(4674,NULL,'Грушицька Надія',NULL,'2020-01-16',NULL,380686336509,NULL,1121993347,'1',NULL,0,'','0'),
(4675,NULL,'Мельничук Людмила',NULL,'2020-01-17',NULL,380977224164,NULL,1305101625,'1',NULL,0,'','0'),
(4676,NULL,'Шмадило Інна',NULL,'2020-01-17',NULL,380979721425,NULL,1171156382,'1',NULL,0,'','0'),
(4677,NULL,'Павліка Таня',NULL,'2020-01-17',NULL,380679207408,NULL,1419020858,'1',NULL,0,'','0'),
(4678,NULL,'Дмитровська Оксана',NULL,'2020-01-17',NULL,380095392981,NULL,2017237170,'1',NULL,0,'','0'),
(4679,NULL,'Бурчак Оля',NULL,'2020-01-18',NULL,380686696928,NULL,2141664330,'1',NULL,0,'','0'),
(4680,NULL,'Смигора Оксана',NULL,'2020-01-18',NULL,380687061427,NULL,1808756920,'1',NULL,0,'','0'),
(4681,NULL,'Олійник Валентина',NULL,'2020-01-18',NULL,380680801792,NULL,1559621249,'1',NULL,0,'','0'),
(4682,NULL,'Білик Леся',NULL,'2020-01-18',NULL,380971052998,NULL,2131681738,'1',NULL,0,'','0'),
(4683,NULL,'Гречин Христина',NULL,'2020-01-20',NULL,380986654273,NULL,1340481362,'1',NULL,0,'','0'),
(4684,NULL,'Годецька Наталя',NULL,NULL,NULL,380988860553,NULL,1236559044,'1',NULL,1,'','0'),
(4685,NULL,'Липова Олена',NULL,'2020-01-20',NULL,380684533925,NULL,1311803171,'1',NULL,0,'','0'),
(4686,NULL,'Глущак Марія',NULL,'2020-01-20',NULL,380672683865,NULL,1524875227,'1',NULL,0,'','0'),
(4687,NULL,'Івасюк Юлія',NULL,'2020-01-20',NULL,380989964361,NULL,2003711185,'1',42983,0,'','0'),
(4688,NULL,'Грошко Ірина',NULL,'2020-01-21',NULL,380689362652,NULL,2037099973,'1',NULL,0,'','0'),
(4689,NULL,'Хабенюк Стефанія',NULL,'2020-01-22',NULL,380685271500,NULL,1255427038,'1',NULL,0,'','0'),
(4690,NULL,'Сторожук Вікторія',NULL,'2020-01-22',NULL,380638340204,NULL,2003263196,'1',NULL,0,'','0'),
(4691,NULL,'Салук Мар’яна',NULL,'2020-01-22',NULL,380681520300,NULL,1173246482,'1',NULL,0,'','0'),
(4692,NULL,'Дурда Христина',NULL,'2020-01-23',NULL,380976410165,NULL,1297468585,'1',NULL,0,'','0'),
(4693,NULL,'Ковпак Світлана',NULL,NULL,NULL,380964523745,NULL,1557114742,'1',NULL,0,'','0'),
(4694,NULL,'Йордадчук Галина',NULL,'2020-01-23',NULL,380966765504,NULL,1497741930,'1',NULL,0,'','0'),
(4695,NULL,'Манчаковська Марія',NULL,'2020-01-23',NULL,380970678364,NULL,1707466792,'1',NULL,0,'','0'),
(4696,NULL,'Солонинка Ольга ',NULL,'2020-01-23',NULL,380966878788,NULL,1923895938,'1',NULL,0,'','0'),
(4697,NULL,'Антоніна Дрепак',NULL,'2020-01-24',NULL,380960331883,NULL,1520509451,'1',NULL,0,'','0'),
(4698,NULL,'Корзинка Марія',NULL,'2020-01-24',NULL,380961669210,NULL,2041817420,'1',NULL,0,'','0'),
(4699,NULL,'Дмитровська Оксана',NULL,'2020-01-24',NULL,380953929817,NULL,1313846697,'1',NULL,0,'','0'),
(4700,NULL,'Рішитко Юлія',NULL,'2020-01-24',NULL,380984758101,NULL,1214249146,'1',NULL,0,'','0'),
(4701,NULL,'Дзюба Марія',NULL,'2020-01-25',NULL,380663532906,NULL,1512721257,'1',NULL,0,'','0'),
(4702,NULL,'Довбуш іван',NULL,'2020-01-25',NULL,380961892058,NULL,1725364866,'1',NULL,1,'','0'),
(4703,NULL,'Юля наша адмін',NULL,NULL,NULL,NULL,NULL,1267435645,'1',NULL,1,'','0'),
(4704,NULL,'Ревуцька Юлія',NULL,'2020-01-26',NULL,380971515237,NULL,2016705644,'1',NULL,0,'','0'),
(4705,NULL,'Галад Ірина',NULL,NULL,NULL,380686654982,NULL,2059553788,'1',35799,0,'','0'),
(4706,NULL,'Плюсква Оля',NULL,'2020-01-27',NULL,380958588041,NULL,1228861005,'1',NULL,0,'','0'),
(4707,NULL,'Браман Анжеліка',NULL,'2020-01-27',NULL,380984682066,NULL,1753823094,'1',12644,0,'','0'),
(4708,NULL,'Білобрам Каріна',NULL,'2020-01-27',NULL,380977035456,NULL,2133785579,'1',47829,0,'','0'),
(4709,NULL,'Гаця Олександра',NULL,'2020-01-27',NULL,380988013885,NULL,1627326552,'1',NULL,0,'','0'),
(4710,NULL,'Цукало',NULL,'2020-01-27',NULL,380660464974,NULL,1192016290,'1',NULL,0,'','0'),
(4711,NULL,'Золота Ірина',NULL,'2020-01-27',NULL,380976648248,NULL,1976004710,'1',NULL,0,'','0'),
(4712,NULL,'Польова Діана',NULL,NULL,NULL,380981325637,NULL,1722682220,'1',NULL,0,'','0'),
(4713,NULL,'Батира Наталя',NULL,'2020-01-28',NULL,380991924921,NULL,1311303578,'1',NULL,0,'','0'),
(4714,NULL,'Кшос Олена',NULL,'2020-01-28',NULL,380964904133,NULL,1417128257,'1',NULL,2,'','0'),
(4715,NULL,'Юзвенко Маряна',NULL,'2020-01-28',NULL,380682480940,NULL,1468190524,'1',NULL,0,'','0'),
(4716,NULL,'Марущак Христина',NULL,'2020-01-28',NULL,380991925119,NULL,1279019196,'1',NULL,0,'','0'),
(4717,NULL,'Опихана Надію',NULL,NULL,NULL,380972256360,NULL,2060301980,'1',NULL,0,'','0'),
(4718,NULL,'Возна Наталія',NULL,'2020-01-28',NULL,380966435990,NULL,1183006565,'1',NULL,0,'','0'),
(4719,NULL,'Веречак Наталя',NULL,'2020-01-28',NULL,380966404507,NULL,1363018655,'1',NULL,0,'','0'),
(4720,NULL,'Аліна',NULL,'2020-01-28',NULL,380978530533,NULL,1281143075,'1',NULL,0,'','0'),
(4721,NULL,'Скворцова Людмила',NULL,NULL,NULL,380507032922,NULL,1593881618,'1',NULL,0,'','0'),
(4722,NULL,'Бандура Оксана',NULL,'2020-01-29',NULL,380992154390,NULL,1890373292,'1',NULL,0,'','0'),
(4723,NULL,'Ісаюк Марія',NULL,'2020-01-29',NULL,380971769707,NULL,1642598135,'1',NULL,0,'','0'),
(4724,NULL,'Тмчак Ліля',NULL,'2020-01-29',NULL,380731118971,NULL,1208746755,'1',NULL,0,'','0'),
(4725,NULL,'Криса Оксана',NULL,'2020-01-29',NULL,380955673978,NULL,1556014223,'1',NULL,0,'','0'),
(4726,NULL,'Харевич Марія',NULL,'2020-01-30',NULL,380507122838,NULL,1349737363,'1',NULL,0,'','0'),
(4727,NULL,'Ліля',NULL,'2020-01-30',NULL,380965970342,NULL,1802072004,'1',NULL,0,'','0'),
(4728,NULL,'Новар Марія',NULL,'2020-01-30',NULL,380968509964,NULL,2022119289,'1',NULL,1,'','0'),
(4729,NULL,'Пелешок Оксана',NULL,'2020-01-30',NULL,380689227705,NULL,1319124712,'1',NULL,0,'','0'),
(4730,NULL,'Конрад Оксана',NULL,'2020-01-30',NULL,380982903923,NULL,1901044122,'1',NULL,0,'','0'),
(4731,NULL,'Конопліцька Ліля',NULL,'2020-01-31',NULL,380977941162,NULL,1581706537,'1',NULL,0,'','0'),
(4732,NULL,'Рудка Наталя',NULL,'2020-01-31',NULL,380989440391,NULL,1857559908,'1',NULL,0,'','0'),
(4733,NULL,'Іра Смоляк',NULL,NULL,NULL,380688347673,NULL,1631902533,'1',NULL,0,'','0'),
(4734,NULL,'Жук Оля',NULL,'2020-01-31',NULL,380987109042,NULL,1678989603,'1',NULL,0,'','0'),
(4735,NULL,'Березовська Вікторія',NULL,'2020-02-01',NULL,380686023396,NULL,1864746710,'1',NULL,0,'','0'),
(4736,NULL,'Янік Зоряна',NULL,NULL,NULL,380681330867,NULL,1999022906,'1',NULL,0,'','0'),
(4737,NULL,'Огороднік Діма',NULL,'2020-02-01',NULL,380987898804,NULL,1995407486,'1',NULL,0,'','0'),
(4738,NULL,'Торончук Інна',NULL,'2020-02-01',NULL,380636878754,NULL,1848846382,'1',NULL,0,'','0'),
(4739,NULL,'Ганіщук Світлана ',NULL,'2020-02-02',NULL,380980046712,NULL,1172203731,'1',NULL,0,'','0'),
(4740,NULL,'Греськів Олена',NULL,'2020-02-02',NULL,380664681102,NULL,1696469522,'1',NULL,1,'','0'),
(4741,NULL,'Вівчарик Інна',NULL,'2020-02-02',NULL,380689339375,NULL,1831442953,'1',NULL,0,'','0'),
(4742,NULL,'Годецька Оксана',NULL,'2020-02-03',NULL,380976325502,NULL,2116096224,'1',NULL,0,'','0'),
(4743,NULL,'Кузьменко Маша',NULL,'2020-02-03',NULL,380632455488,NULL,1958697596,'1',NULL,0,'','0'),
(4744,NULL,'манорик наталя',NULL,'2020-02-04',NULL,380969844826,NULL,2036861503,'1',NULL,0,'','0'),
(4745,NULL,'Барода Наталя',NULL,'2020-02-04',NULL,380976496278,NULL,1845311548,'1',NULL,0,'','0'),
(4746,NULL,'Ульянів',NULL,'2020-02-04',NULL,380689913038,NULL,1221176543,'1',NULL,0,'','0'),
(4747,NULL,'Ференцюк Надія',NULL,'2020-02-04',NULL,380967521120,NULL,1465504918,'1',NULL,0,'','0'),
(4748,NULL,'Попіль Ліля',NULL,'2020-02-04',NULL,380682420576,NULL,1428851463,'1',NULL,0,'','0'),
(4749,NULL,'Філіпович Маша',NULL,'2020-02-05',NULL,380678908362,NULL,1322780348,'1',NULL,0,'','0'),
(4750,NULL,'Руль Оксана',NULL,'2020-02-05',NULL,380685296700,NULL,1990892954,'1',NULL,0,'','0'),
(4751,NULL,'марія олексіівна',NULL,'2020-02-06',NULL,380675919355,NULL,1763107150,'1',NULL,0,'','0'),
(4752,NULL,'Гуліната Лідія',NULL,'2020-02-06',NULL,380680372401,NULL,1878088701,'1',NULL,0,'','0'),
(4753,NULL,'Новікова Надя',NULL,'2020-02-06',NULL,380967516031,NULL,1183265593,'1',NULL,0,'','0'),
(4754,NULL,'Чубата Анжела',NULL,NULL,NULL,380986580109,NULL,1304614851,'1',NULL,0,'','0'),
(4755,NULL,'Тимчак Ліля',NULL,'2020-02-06',NULL,380982730907,NULL,1643718730,'1',33829,0,'','0'),
(4756,NULL,'Горбунова Юля',NULL,'2020-02-07',NULL,380980632124,NULL,1218186999,'1',NULL,0,'','0'),
(4757,NULL,'Гордейчук Марія',NULL,'2020-02-07',NULL,380684507743,NULL,1868949473,'1',NULL,0,'','0'),
(4758,NULL,'Школьницька Вікторія',NULL,'2020-02-07',NULL,380675931251,NULL,2007671266,'1',NULL,1,'','0'),
(4759,NULL,'Солдатова Віка',NULL,'2020-02-07',NULL,380661740671,NULL,1712857361,'1',NULL,0,'','0'),
(4760,NULL,'Яремків Марина',NULL,'2020-02-07',NULL,380968009975,NULL,1166354197,'1',NULL,0,'','0'),
(4761,NULL,'Проданий Юлія',NULL,'2020-02-10',NULL,380978395823,NULL,1771709097,'1',NULL,0,'','0'),
(4762,NULL,'гедзик анжеліка',NULL,'2020-02-10',NULL,380507346122,NULL,1400820741,'1',NULL,0,'','0'),
(4763,NULL,'Скалій Юля ',NULL,'2020-02-10',NULL,380977906361,NULL,1950169188,'1',NULL,0,'','0'),
(4764,NULL,'Баліцька Галя',NULL,'2020-02-10',NULL,380959186851,NULL,1766160891,'1',NULL,0,'','0'),
(4765,NULL,'Винничук Світлана',NULL,NULL,NULL,380973812793,NULL,2060753039,'1',NULL,0,'','0'),
(4766,NULL,'Грабовецька Марина',NULL,'2020-02-10',NULL,380983036770,NULL,1714789803,'1',NULL,0,'','0'),
(4767,NULL,'Шевчук Христина',NULL,'2020-02-10',NULL,380980027567,NULL,1233467364,'1',NULL,0,'','0'),
(4768,NULL,'Хистина Домінік-Білоус',NULL,'2020-02-10',NULL,380977740850,NULL,1368755186,'1',NULL,0,'','0'),
(4769,NULL,'Кузьма Галина',NULL,'2020-02-11',NULL,380989243405,NULL,1717596140,'1',NULL,0,'','0'),
(4770,NULL,'Наталя Біланик',NULL,'2020-02-11',NULL,380681623567,NULL,1462903882,'1',NULL,0,'','0'),
(4771,NULL,'Корпан Христина',NULL,'2020-02-11',NULL,380684628195,NULL,1203643087,'1',NULL,0,'','0'),
(4772,NULL,'наконечний віталій',NULL,'2020-02-11',NULL,380971314019,NULL,1539073207,'1',NULL,0,'','0'),
(4773,NULL,'Дмитровська Аліна',NULL,'2020-02-11',NULL,380684407418,NULL,1283764524,'1',34841,0,'','0'),
(4774,NULL,'Рева Христина',NULL,'2020-02-11',NULL,380981253558,NULL,1827083192,'1',NULL,1,'','0'),
(4775,NULL,'Піхуник Вікторія',NULL,'2020-02-12','iodbPMGMcjS7PGNC4N7FBg==',380969035509,NULL,1253247632,'1',NULL,1,'','0'),
(4776,NULL,'Балюк Олена',NULL,'2020-02-12',NULL,380977738908,NULL,2056645554,'1',NULL,0,'','0'),
(4777,NULL,'Романюк Марія',NULL,'2020-02-12',NULL,380988364090,NULL,1907927947,'1',46730,1,'','0'),
(4778,NULL,'машталір леся',NULL,'2020-02-12',NULL,380689413961,NULL,1535576901,'1',NULL,0,'','0'),
(4779,NULL,'Кінах Марія',NULL,'2020-02-12',NULL,380977732864,NULL,1513186158,'1',NULL,0,'','0'),
(4780,NULL,'Василів Віра',NULL,'2020-02-13',NULL,380977302724,NULL,1489764196,'1',NULL,0,'','0'),
(4781,NULL,'Перців Іра',NULL,'2020-02-13',NULL,380684694933,NULL,1389590584,'1',NULL,0,'','0'),
(4782,NULL,'Перців Ірина',NULL,'2020-02-13',NULL,380984897929,NULL,1867627627,'1',NULL,0,'','0'),
(4783,NULL,'Тацій Марія',NULL,'2020-02-13',NULL,380989762151,NULL,1282022517,'1',NULL,1,'','0'),
(4784,NULL,'Вітів Люба',NULL,'2020-02-13',NULL,380685871705,NULL,1756169332,'1',NULL,0,'','0'),
(4785,NULL,'Катеринюк аня',NULL,'2020-02-13',NULL,380936514742,NULL,1811782925,'1',NULL,0,'','0'),
(4786,NULL,'Катеринюк таня',NULL,'2020-02-13',NULL,380968671334,NULL,1653075415,'1',NULL,0,'','0'),
(4787,NULL,'Краснянська Юлія',NULL,'2020-02-14',NULL,380680864243,NULL,1627640818,'1',NULL,1,'','0'),
(4788,NULL,'Шевців Оля',NULL,'2020-02-14',NULL,380685644253,NULL,1226786774,'1',NULL,0,'','0'),
(4789,NULL,'Вітів Галина',NULL,'2020-02-14',NULL,380966775752,NULL,1180228664,'1',NULL,0,'','0'),
(4790,NULL,'Нижник Анна',NULL,'2020-02-14',NULL,380686125865,NULL,1358126211,'1',NULL,0,'','0'),
(4791,NULL,'Мацьків Марія',NULL,'2020-02-14',NULL,380979081357,NULL,1538301614,'1',NULL,0,'','0'),
(4792,NULL,'Друк Марія',NULL,'2020-02-14',NULL,380986391724,NULL,1617881732,'1',NULL,1,'','0'),
(4793,NULL,'Струтинська Галина',NULL,NULL,'nAe0qRaTqKKf5AEIw5rtPA==',380966502850,NULL,1566750859,'1',NULL,0,'','0'),
(4794,NULL,'Касюк Христина',NULL,'2020-02-14',NULL,380960605215,NULL,1891522910,'1',NULL,0,'','0'),
(4795,NULL,'Конрад Христина',NULL,'2020-02-15',NULL,380971176223,NULL,1507319139,'1',NULL,0,'','0'),
(4796,NULL,'Штуник Софія',NULL,'2020-02-16',NULL,380975499088,NULL,1510719023,'1',NULL,0,'','0'),
(4797,NULL,'Дмитровська Олена',NULL,'2020-02-17',NULL,380677525872,NULL,1572547218,'1',NULL,0,'','0'),
(4798,NULL,'Карвацька Христина',NULL,'2020-02-17',NULL,380686954305,NULL,1307175755,'1',NULL,0,'','0'),
(4799,NULL,'Супчак Інна',NULL,'2020-02-17',NULL,380980423480,NULL,1326602178,'1',NULL,0,'','0'),
(4800,NULL,'Андріїшин Ірина',NULL,NULL,NULL,380974101611,NULL,2119790320,'1',NULL,0,'','0'),
(4801,NULL,'Ковбуз Ольга',NULL,'2020-02-17',NULL,380684960773,NULL,1260133191,'1',NULL,1,'','0'),
(4802,NULL,'Мельничук Вікторія',NULL,'2020-02-17',NULL,380955222969,NULL,1372536480,'1',NULL,0,'','0'),
(4803,NULL,'Міщанчук Наталя',NULL,'2020-02-17',NULL,380989243233,NULL,1397781442,'1',NULL,0,'','0'),
(4804,NULL,'Драган Ліля',NULL,'2020-02-17',NULL,380680875925,NULL,1590421371,'1',NULL,0,'','0'),
(4805,NULL,'Терещенко Тетяна',NULL,'2020-02-17',NULL,380689419867,NULL,1958873396,'1',NULL,0,'','0'),
(4806,NULL,'Перців Маряна',NULL,NULL,NULL,380688426881,NULL,1351499603,'1',NULL,0,'','0'),
(4807,NULL,'Гащишин Марія',NULL,'2020-02-18',NULL,380678483793,NULL,1211333285,'1',NULL,0,'','0'),
(4808,NULL,'Урбан Настя',NULL,'2020-02-18',NULL,380983934662,NULL,1877516185,'1',NULL,0,'','0'),
(4809,NULL,'Костяновська Іра',NULL,'2020-02-18',NULL,380974814633,NULL,1564165066,'1',NULL,0,'','0'),
(4810,NULL,'Якубів Віра',NULL,'2020-02-18',NULL,380971040647,NULL,1561096951,'1',NULL,0,'','0'),
(4811,NULL,'Фортейн Світлана',NULL,'2020-02-18',NULL,380985486414,NULL,1949838733,'1',NULL,0,'','0'),
(4812,NULL,'Созанська Наталя',NULL,'2020-02-18',NULL,380966379193,NULL,1393801127,'1',NULL,0,'','0'),
(4813,NULL,'Дячук Люда',NULL,'2020-02-18',NULL,380970753078,NULL,1613898414,'1',NULL,0,'','0'),
(4814,NULL,'Гайдукевич Наталя',NULL,'2020-02-18',NULL,380971071655,NULL,1243516159,'1',NULL,0,'','0'),
(4815,NULL,'Нера Юля ',NULL,NULL,NULL,380689695095,NULL,1970413508,'1',NULL,0,'','0'),
(4816,NULL,'Мариняк Оксана',NULL,'2020-02-19',NULL,380970559709,NULL,2143567832,'1',NULL,0,'','0'),
(4817,NULL,'Вовчук Олена',NULL,'2020-02-19',NULL,380985723961,NULL,1638852564,'1',NULL,0,'','0'),
(4818,NULL,'Савіцька Діана',NULL,'2020-02-19',NULL,380974172736,NULL,1443854183,'1',NULL,0,'','0'),
(4819,NULL,'Гшщук Надія',NULL,'2020-02-20',NULL,380632950942,NULL,1561451414,'1',NULL,1,'','0'),
(4820,NULL,'Гурлик Таня',NULL,'2020-02-20',NULL,380688966428,NULL,1197836649,'1',NULL,0,'','0'),
(4821,NULL,'Юркович Леся',NULL,'2020-02-20',NULL,380978909440,NULL,1575902515,'1',NULL,0,'','0'),
(4822,NULL,'Нагірна Тетяна',NULL,'2020-02-20',NULL,380976713508,NULL,1374815671,'1',NULL,0,'','0'),
(4823,NULL,'Макух Марія',NULL,'2020-02-20',NULL,380686178651,NULL,1383288924,'1',NULL,0,'','0'),
(4824,NULL,'Макух Людмила',NULL,'2020-02-20','MXOdPdC3sjvmSnG2APf49w==',380687882611,NULL,1236274638,'1',NULL,0,'','0'),
(4825,NULL,'Гйдук Людмила',NULL,'2020-02-20',NULL,380980022539,NULL,1968384452,'1',NULL,0,'','0'),
(4826,NULL,'Бартків Оксана',NULL,'2020-02-20',NULL,380988188038,NULL,1507073956,'1',NULL,0,'','0'),
(4827,NULL,'Семенчук Тетяна',NULL,'2020-02-21',NULL,380977291062,NULL,2120608696,'1',NULL,0,'','0'),
(4828,NULL,'Гриців Аліна',NULL,'2020-02-21',NULL,380963679364,NULL,1793555287,'1',39616,0,'','0'),
(4829,NULL,'Стельмащук Романа',NULL,'2020-02-21',NULL,380979179633,NULL,1312607612,'1',NULL,0,'','0'),
(4830,NULL,'Сеник Юля',NULL,'2020-02-21',NULL,380995235233,NULL,1158552201,'1',NULL,0,'','0'),
(4831,NULL,'Гуцал Вікторія',NULL,'2020-02-22',NULL,380986676689,NULL,1742852043,'1',NULL,0,'','0'),
(4832,NULL,'',NULL,NULL,NULL,NULL,NULL,1280353472,'1',NULL,0,'','0'),
(4833,NULL,'Сутигіна Оксана',NULL,'2020-02-22',NULL,380987795949,NULL,1870403030,'1',NULL,0,'','0'),
(4834,NULL,'Іра Трембовельська',NULL,'2020-02-22',NULL,380963866917,NULL,1810596909,'1',NULL,0,'','0'),
(4835,NULL,'Кобильняк Марія',NULL,'2020-02-23',NULL,380979721885,NULL,1124811308,'1',NULL,0,'','0'),
(4836,NULL,'Заболотна ольга ',NULL,'2020-02-24',NULL,380978558894,NULL,1440841439,'1',NULL,0,'','0'),
(4837,NULL,'Галат Іванна',NULL,'2020-02-24',NULL,380966435841,NULL,1773291612,'1',NULL,0,'','0'),
(4838,NULL,'Чикирило Ірина',NULL,'2020-02-24',NULL,380974285667,NULL,1425298202,'1',NULL,0,'','0'),
(4839,NULL,'Бадло Оксана',NULL,'2020-02-24',NULL,380685837123,NULL,1187503324,'1',NULL,0,'','0'),
(4840,NULL,'Ленівська Катя',NULL,'2020-02-25',NULL,380672935731,NULL,1777918269,'1',NULL,0,'','0'),
(4841,NULL,'Андріішин Софія',NULL,'2020-02-25',NULL,380688740039,NULL,1514924820,'1',NULL,1,'','0'),
(4842,NULL,'Петльована Анастасія',NULL,'2020-02-25',NULL,380976626439,NULL,1379402645,'1',NULL,0,'','0'),
(4843,NULL,'Тимофтей Надія',NULL,'2020-02-26',NULL,380971422294,NULL,1890587702,'1',NULL,0,'','0'),
(4844,NULL,'Андрухів Ірина',NULL,'2020-02-26',NULL,380960726511,NULL,1378768004,'1',NULL,0,'','0'),
(4845,NULL,'Маньовська Тетяна',NULL,'2020-02-26',NULL,380967797322,NULL,1898313293,'1',NULL,0,'','0'),
(4846,NULL,'Макара Уляна',NULL,'2020-02-26',NULL,380970288032,NULL,1386529026,'1',60270,0,'','0'),
(4847,NULL,'Макара Настя',NULL,'2020-02-26',NULL,380965451481,NULL,1633307131,'1',44490,0,'','0'),
(4848,NULL,'Бояц Галина',NULL,'2020-02-26',NULL,380970140996,NULL,1873262736,'1',NULL,0,'','0'),
(4849,NULL,'Бойчук Галина',NULL,'2020-02-26',NULL,380950548743,NULL,1176910169,'1',NULL,0,'','0'),
(4850,NULL,'Дмитраш Оля',NULL,'2020-02-27',NULL,380685794945,NULL,1230159795,'1',NULL,0,'','0'),
(4851,NULL,'Вільгард Настя ',NULL,NULL,'KY5umFyRsJhHcSqtz7vOlA==',380985326029,NULL,1911437223,'1',14929,1,'','0'),
(4852,NULL,'Парадюк Уляна ',NULL,'2020-02-27',NULL,380689674306,NULL,1664288124,'1',NULL,0,'','0'),
(4853,NULL,'Левкович Уляна ',NULL,'2020-02-27',NULL,380671791580,NULL,2109116429,'1',NULL,0,'','0'),
(4854,NULL,'Шастків Діана',NULL,'2020-02-27',NULL,380678470837,NULL,1961886915,'1',NULL,0,'','0'),
(4855,NULL,'Мостович Оксана',NULL,'2020-02-28',NULL,380680463312,NULL,1633215183,'1',NULL,0,'','0'),
(4856,NULL,'Вензель Наталя',NULL,'2020-02-28',NULL,380966749545,NULL,2111753310,'1',NULL,0,'','0'),
(4857,NULL,'Мороз Наталя',NULL,'2020-02-28',NULL,380988461149,NULL,1783313301,'1',27414,3,'','0'),
(4858,NULL,'Арефте Тетяна',NULL,NULL,NULL,380967263465,NULL,1799505559,'1',NULL,0,'','0'),
(4859,NULL,'Бажанська Тетяна',NULL,'2020-02-28',NULL,380661980316,NULL,1904873110,'1',NULL,0,'','0'),
(4860,NULL,'Жовтюк Тетяна',NULL,'2020-02-28',NULL,380962422609,NULL,1166867280,'1',12499,0,'','0'),
(4861,NULL,'Харук Анастасія',NULL,NULL,'sC6dF9WI9oTAVRftIP5qfw==',380672998170,NULL,2040490408,'1',19839,0,'','0'),
(4862,NULL,'Ісаюк Марія',NULL,'2020-02-28',NULL,380680882447,NULL,1728411745,'1',NULL,0,'','0'),
(4863,NULL,'Мороз Марія ',NULL,'2020-02-28',NULL,380961786226,NULL,1205430490,'1',NULL,0,'','0'),
(4864,NULL,'Шевчик Роксолана',NULL,'2020-02-29',NULL,380683257597,NULL,1393025681,'1',NULL,0,'','0'),
(4865,NULL,'Голодівська Леся',NULL,'2020-02-29',NULL,380988032628,NULL,2023739890,'1',49900,0,'','0'),
(4866,NULL,'Оріховська Таня',NULL,'2020-03-02',NULL,380682466858,NULL,1284054803,'1',NULL,0,'','0'),
(4867,NULL,'Клюкевич Діана',NULL,'2020-03-02',NULL,380679840763,NULL,1527702290,'1',NULL,0,'','0'),
(4868,NULL,'Гнитка Діана',NULL,'2020-03-02',NULL,380987678117,NULL,1797891851,'1',NULL,0,'','0'),
(4869,NULL,'Наконечна Тетяна',NULL,'2020-03-02',NULL,380979738019,NULL,1426425876,'1',NULL,0,'','0'),
(4870,NULL,'Матюшин Марія',NULL,'2020-03-03',NULL,380972844070,NULL,1299450215,'1',NULL,0,'','0'),
(4871,NULL,'Подолянська Надія ',NULL,'2020-03-03',NULL,380972288667,NULL,1137055884,'1',NULL,0,'','0'),
(4872,NULL,'Одавчук Оксана',NULL,'2020-03-03',NULL,380995605223,NULL,1703162648,'1',NULL,0,'','0'),
(4873,NULL,'Чикамова Аліна',NULL,'2020-03-03',NULL,380963360884,NULL,1359334213,'1',NULL,0,'','0'),
(4874,NULL,'Вітів Світлана',NULL,'2020-03-04',NULL,380985254251,NULL,1403365951,'1',NULL,0,'','0'),
(4875,NULL,'Гонта Ярослава',NULL,'2020-03-04',NULL,380978084798,NULL,1694745623,'1',NULL,0,'','0'),
(4876,NULL,'Крушевська Володимира ',NULL,'2020-03-04',NULL,380987433091,NULL,1409438113,'1',NULL,0,'','0'),
(4877,NULL,'Ангельська Галина',NULL,'2020-03-04',NULL,380970639354,NULL,1559184324,'1',NULL,0,'','0'),
(4878,NULL,'Валечна Марія',NULL,'2020-03-04',NULL,380686296708,NULL,1945208976,'1',NULL,1,'','0'),
(4879,NULL,'Черниш Маряна ',NULL,'2020-03-04',NULL,380963437974,NULL,1784722518,'1',NULL,0,'','0'),
(4880,NULL,'Балакунець Юля ',NULL,'2020-03-04',NULL,380983588151,NULL,1655211312,'1',NULL,0,'','0'),
(4881,NULL,'Бугера Сніжана',NULL,'2020-03-05',NULL,380989967328,NULL,1676284955,'1',NULL,0,'','0'),
(4882,NULL,'Косаригіна Тетяна',NULL,'2020-03-06',NULL,380968765532,NULL,1268782929,'1',NULL,1,'','0'),
(4883,NULL,'Чихарівська Зоряна',NULL,'2020-03-06',NULL,380507087210,NULL,1467855395,'1',NULL,0,'','0'),
(4884,NULL,'Беренда Марія',NULL,'2020-03-06','aVYbWAvrq1E0gLymcYlG3Q==',380973838130,NULL,2125956385,'1',NULL,0,'','0'),
(4885,NULL,'Широкова Олена',NULL,'2020-03-06',NULL,380676392281,NULL,1421143204,'1',NULL,0,'','0'),
(4886,NULL,'Ілюк Оксана',NULL,'2020-03-06',NULL,380681620927,NULL,1339065792,'1',NULL,1,'','0'),
(4887,NULL,'Дашевська Наталя',NULL,'2020-03-06',NULL,380964098530,NULL,1142854279,'1',NULL,0,'','0'),
(4888,NULL,'Сорокопуць Світлана',NULL,'2020-03-06',NULL,380988038048,NULL,1675102240,'1',NULL,0,'','0'),
(4889,NULL,'Бортняк Марія',NULL,'2020-03-06',NULL,380961969622,NULL,1221857918,'1',NULL,0,'','0'),
(4890,NULL,'СЕейфуллаєва Катерина',NULL,'2020-03-07',NULL,380680962728,NULL,1368324505,'1',NULL,0,'','0'),
(4891,NULL,'Коваленко Іванна',NULL,'2020-03-07',NULL,380961354467,NULL,1213739831,'1',NULL,1,'','0'),
(4892,NULL,'Ніберкан Марія',NULL,'2020-03-07',NULL,380678641980,NULL,1739548955,'1',NULL,0,'','0'),
(4893,NULL,'Ангельский Олег',NULL,'2020-03-07',NULL,380962985773,NULL,1310974933,'1',NULL,0,'','0'),
(4894,NULL,'Перепелиця Андрій',NULL,'2020-03-07',NULL,380509183599,NULL,1772532660,'1',60383,1,'','0'),
(4895,NULL,'Феник Вікторія',NULL,'2020-03-09',NULL,380687637665,NULL,1241351747,'1',NULL,0,'','0'),
(4896,NULL,'Дюк Надія',NULL,'2020-03-09',NULL,380967612792,NULL,1392360472,'1',NULL,0,'','0'),
(4897,NULL,'попович вікторія',NULL,'2020-03-09',NULL,380961185133,NULL,1181224272,'1',NULL,0,'','0'),
(4898,NULL,'Бойко Лєна ',NULL,'2020-03-10',NULL,380961958492,NULL,1503762977,'1',NULL,0,'','0'),
(4899,NULL,'Мороз Лариса ',NULL,'2020-03-10',NULL,380973402759,NULL,1685349358,'1',NULL,0,'','0'),
(4900,NULL,'Шевчик Світлана',NULL,'2020-03-10',NULL,380689027146,NULL,1666743781,'1',NULL,0,'','0'),
(4901,NULL,'Бариська Настя',NULL,'2020-03-11',NULL,380689322923,NULL,1910075665,'1',NULL,0,'','0'),
(4902,NULL,'Ключник Ірина',NULL,'2020-03-11',NULL,380683238033,NULL,1243663221,'1',NULL,0,'','0'),
(4903,NULL,'Патуляк Олексій',NULL,'2020-03-11',NULL,380672678820,NULL,1299578757,'1',NULL,0,'','0'),
(4904,NULL,'Горбач Ірина',NULL,'2020-03-11',NULL,380977925835,NULL,1788130430,'1',NULL,0,'','0'),
(4905,NULL,'Витрикуш Ірина',NULL,'2020-03-11',NULL,380678506109,NULL,1242622768,'1',NULL,0,'','0'),
(4906,NULL,'Ненчин Оксана',NULL,'2020-03-12',NULL,380991387047,NULL,1774652084,'1',NULL,0,'','0'),
(4907,NULL,'Грицей Олена',NULL,'2020-03-12',NULL,380679758077,NULL,1537587260,'1',NULL,0,'','0'),
(4908,NULL,'Козак Галина',NULL,'2020-03-12',NULL,380678594271,NULL,1730855952,'1',NULL,0,'','0'),
(4909,NULL,'Балик Галина',NULL,'2020-03-12',NULL,380960373863,NULL,1707045456,'1',NULL,0,'','0'),
(4910,NULL,'Красноштан Вікторія',NULL,'2020-03-12',NULL,380661051907,NULL,2064319918,'1',NULL,0,'','0'),
(4911,NULL,'Ципліцька Наталя',NULL,'2020-03-14',NULL,380951074117,NULL,2119805010,'1',NULL,0,'','0'),
(4912,NULL,'Чорній Юля',NULL,'2020-03-16',NULL,380500514683,NULL,1602895217,'1',26300,0,'','0'),
(4913,NULL,'деркач олеся',NULL,'2020-03-16',NULL,380967918912,NULL,2069595063,'1',NULL,0,'','0'),
(4914,NULL,'Безпалько Марія',NULL,'2020-03-16',NULL,380974524043,NULL,1475548460,'1',NULL,0,'','0'),
(4915,NULL,'Війтишин Оксана ',NULL,'2020-03-16',NULL,380986195042,NULL,1221731603,'1',NULL,0,'','0'),
(4916,NULL,'Війтишин Ірина',NULL,'2020-03-16',NULL,380977020922,NULL,1864244935,'1',NULL,0,'','0'),
(4917,NULL,'Пшик Марія',NULL,'2020-05-04',NULL,380680609198,NULL,1861875776,'1',NULL,0,'','0'),
(4918,NULL,'Огороднік Оксана',NULL,'2020-05-06',NULL,380680325988,NULL,1597484504,'1',NULL,0,'','0'),
(4919,NULL,'Кінаш Тетяна',NULL,'2020-05-06',NULL,380977898684,NULL,1452259890,'1',NULL,0,'','0'),
(4920,NULL,'Пиняк Мирослава',NULL,'2020-05-06',NULL,380984714066,NULL,1284591153,'1',NULL,0,'','0'),
(4921,NULL,'пандрак Інна',NULL,'2020-05-06',NULL,380979213345,NULL,1486973619,'1',NULL,0,'','0'),
(4922,NULL,'Галушка Ірина',NULL,'2020-05-06',NULL,380686812226,NULL,1121641968,'1',NULL,1,'','0'),
(4923,NULL,'Музика Олександра',NULL,NULL,'+/nQQdBmBfzC31tkOxGVOg==',NULL,NULL,1136814291,'0',42077,0,'','0'),
(4924,NULL,'Данилюк Наталія  ',NULL,'2020-05-07',NULL,380967722758,NULL,1310528684,'1',49379,0,'','0'),
(4925,NULL,'Винничин Леся',NULL,'2020-05-07',NULL,380633992671,NULL,1765150551,'1',24227,1,'','0'),
(4926,NULL,'матюніна оля',NULL,'2020-05-07',NULL,380964907324,NULL,1567299402,'1',NULL,0,'','0'),
(4927,NULL,'шлапак уляна ',NULL,'2020-05-07',NULL,NULL,NULL,1998340811,'1',NULL,0,'','0'),
(4928,NULL,'Музика Олександрааа',NULL,'2020-05-08',NULL,380975443475,NULL,1721898974,'1',NULL,0,'','0'),
(4929,NULL,'Жевенюк Діана',NULL,'2020-05-09',NULL,380674959177,NULL,1915094341,'1',NULL,0,'','0'),
(4930,NULL,'Побуринна Ірина',NULL,'2020-05-10',NULL,380675367171,NULL,1391405459,'1',NULL,1,'','0'),
(4931,NULL,'Бохняк Юліанна',NULL,'2020-05-11',NULL,380996673359,380676656312,1436966851,'1',NULL,0,'','0'),
(4932,NULL,'Тимчук Христина ',NULL,'2020-05-11',NULL,380961326432,NULL,1939753166,'1',NULL,0,'','0'),
(4933,NULL,'Горбань Наталя',NULL,'2020-05-12',NULL,380978435761,NULL,1506149729,'1',NULL,0,'','0'),
(4934,NULL,'Луйван Ірина',NULL,'2020-05-12',NULL,380955414900,NULL,1670947162,'1',NULL,2,'','0'),
(4935,NULL,'Соботяк Анастасія',NULL,'2020-05-12',NULL,380986610752,NULL,1778902512,'1',NULL,0,'','0'),
(4936,NULL,'Гуменюк Уляна',NULL,'2020-05-12',NULL,380975803255,NULL,2089114928,'1',NULL,0,'','0'),
(4937,NULL,'Магус Сніжана',NULL,'2020-05-13',NULL,380970528449,NULL,1613925680,'1',NULL,0,'','0'),
(4938,NULL,'Гнатківська Ольга',NULL,'2020-05-13',NULL,380980300138,NULL,1467101746,'1',NULL,0,'','0'),
(4939,NULL,'Крушельник Оксана',NULL,'2020-05-14',NULL,380677699220,NULL,1614049186,'1',NULL,0,'','0'),
(4940,NULL,'Зайчук Оля',NULL,'2020-05-14',NULL,380982561659,NULL,1512106869,'1',NULL,0,'','0'),
(4941,NULL,'Кричковська Оля',NULL,'2020-05-15',NULL,380678433795,NULL,1819843582,'1',NULL,2,'','0'),
(4942,NULL,'Пророк Віка',NULL,'2020-05-15',NULL,380685143119,NULL,2049902645,'1',NULL,0,'','0'),
(4943,NULL,'Дячок Ліля',NULL,'2020-05-15',NULL,380980187194,NULL,1256237554,'1',36321,0,'','0'),
(4944,NULL,'Гевко Іра',NULL,'2020-05-15',NULL,380971485497,NULL,1740656922,'1',NULL,0,'','0'),
(4945,NULL,'Гевко Христина',NULL,'2020-05-15',NULL,380668671433,NULL,1432121129,'1',NULL,0,'','0'),
(4946,NULL,'Фндитус Анастасія',NULL,'2020-05-16',NULL,380973697721,NULL,1897236281,'1',NULL,0,'','0'),
(4947,NULL,'Кулик Тетяна',NULL,'2020-05-16',NULL,380970885973,NULL,1798662813,'1',NULL,1,'','0'),
(4948,NULL,'Ципліцька Наталія ',NULL,'2020-05-16',NULL,380986270704,NULL,1669685682,'1',NULL,0,'','0'),
(4949,NULL,'Холоднюк Марія',NULL,'2020-05-16',NULL,380984759254,NULL,1496720949,'1',NULL,0,'','0'),
(4950,NULL,'Лавриновська Анна',NULL,'2020-05-16',NULL,380985046086,NULL,1480576068,'1',NULL,0,'','0'),
(4951,NULL,'Вуздеревич Інна',NULL,'2020-05-17',NULL,380988633842,NULL,1124317072,'1',NULL,0,'','0'),
(4952,NULL,'нагірна ліля',NULL,'2020-05-18',NULL,380965199290,NULL,1203076403,'1',NULL,0,'','0'),
(4953,NULL,'верещук вікторія',NULL,'2020-05-18',NULL,380967785863,NULL,1457880140,'1',NULL,1,'','0'),
(4954,NULL,'мальований михайло',NULL,'2020-05-18',NULL,380982071477,NULL,1288128803,'1',NULL,0,'','0'),
(4955,NULL,'руда уляна',NULL,'2020-05-18',NULL,380964953973,NULL,1194541439,'1',NULL,0,'','0'),
(4956,NULL,'римар анна',NULL,'2020-05-18',NULL,380971039856,NULL,1721564775,'1',NULL,0,'','0'),
(4957,NULL,'вівчар юлія',NULL,'2020-05-18',NULL,380970006452,NULL,1266679311,'1',53295,0,'','0'),
(4958,NULL,'Кумигіна Аліна',NULL,'2020-05-18',NULL,380985339871,NULL,2124808930,'1',NULL,0,'','0'),
(4959,NULL,'Янок Анна',NULL,'2020-05-19',NULL,380982361307,NULL,1906238925,'1',NULL,0,'','0'),
(4960,NULL,'Пігурська Іванна',NULL,'2020-05-19',NULL,380686260178,NULL,2022811495,'1',NULL,0,'','0'),
(4961,NULL,'Боровицька Леся',NULL,'2020-05-19',NULL,380686585956,NULL,1978372023,'1',NULL,0,'','0'),
(4962,NULL,'Яркова Тамара',NULL,'2020-05-19',NULL,380956710778,NULL,1493739740,'1',NULL,0,'','0'),
(4963,NULL,'Месарош оля',NULL,NULL,NULL,380671521396,NULL,1434702914,'1',NULL,0,'','0'),
(4964,NULL,'Вяткіна Катерина',NULL,'2020-05-19',NULL,380960767977,NULL,1744259684,'1',NULL,0,'','0'),
(4965,NULL,'Безпалко Христина ',NULL,'2020-05-19',NULL,380963702925,NULL,1533078108,'1',NULL,0,'','0'),
(4966,NULL,'данечко тетяна',NULL,'2020-05-20',NULL,380668339321,NULL,1963532969,'1',NULL,0,'','0'),
(4967,NULL,'Швигер Юлія',NULL,'2020-05-20',NULL,380632406947,NULL,1777833062,'1',NULL,0,'','0'),
(4968,NULL,'Лищишин Наталя',NULL,'2020-05-21',NULL,380666823506,NULL,1679729858,'1',NULL,0,'','0'),
(4969,NULL,'Стефанчишин Люда',NULL,'2020-05-21',NULL,380958516233,NULL,1177372445,'1',NULL,0,'','0'),
(4970,NULL,'Атаманчук Надія',NULL,'2020-05-21',NULL,380976415735,NULL,1596001728,'1',26662,0,'','0'),
(4971,NULL,'сторожук Аня',NULL,NULL,NULL,380982504627,NULL,1814573182,'1',NULL,0,'','0'),
(4972,NULL,'Венгер Ірина',NULL,'2020-05-21',NULL,380966772778,NULL,1972056402,'1',NULL,0,'','0'),
(4973,NULL,'Собків Лідія',NULL,'2020-05-22',NULL,380994711215,NULL,1782462837,'1',NULL,0,'','0'),
(4974,NULL,'Халупняк Вікторія',NULL,'2020-05-22',NULL,380689668436,NULL,1920952273,'1',NULL,0,'','0'),
(4975,NULL,'Савіцька Галина',NULL,'2020-05-23',NULL,380669901627,NULL,1410918134,'1',NULL,0,'','0'),
(4976,NULL,'Серединська Тетяна',NULL,'2020-05-23','uvNezZVxxM4LuZsvcHqvpQ==',380972056120,NULL,2039462716,'1',56746,0,'','0'),
(4977,NULL,'юрків уляна',NULL,'2020-05-25',NULL,380970554921,NULL,1503017882,'1',14706,0,'','0'),
(4978,NULL,'Гаврилюк світлана',NULL,'2020-05-26',NULL,380666603522,NULL,1416105316,'1',NULL,0,'','0'),
(4979,NULL,'Поліщук Галини',NULL,'2020-05-27',NULL,380979719589,NULL,1250653083,'1',NULL,0,'','0'),
(4980,NULL,'Кивяк Тетяна',NULL,'2020-05-27',NULL,380684587734,NULL,1674438380,'1',NULL,0,'','0'),
(4981,NULL,'Гошуляк Людмила',NULL,NULL,NULL,380988922389,NULL,2001050132,'1',NULL,0,'','0'),
(4982,NULL,'Слоньовську Юлія',NULL,'2020-05-28',NULL,380977740830,NULL,1858437688,'1',25767,0,'','0'),
(4983,NULL,'Хруняк Ірина ',NULL,'2020-05-28',NULL,380686262289,NULL,1609355043,'1',NULL,0,'','0'),
(4984,NULL,'Бойко Наталя',NULL,'2020-05-29',NULL,380632966186,NULL,1135882176,'1',NULL,0,'','0'),
(4985,NULL,'Савчук Алла',NULL,'2020-05-29',NULL,380683085749,NULL,1769009258,'1',NULL,0,'','0'),
(4986,NULL,'Сидорова Віка',NULL,'2020-05-29',NULL,380974588180,NULL,1473597545,'1',NULL,0,'','0'),
(4987,NULL,'Шпак Христина',NULL,'2020-05-30',NULL,380685889065,NULL,1608706830,'1',NULL,0,'','0'),
(4988,NULL,'Боднарчук Інна',NULL,'2020-05-30',NULL,380672644857,NULL,2015952941,'1',NULL,0,'','0'),
(4989,NULL,'Дячук Марія',NULL,'2020-05-30',NULL,380963472513,NULL,1285427382,'1',NULL,0,'','0'),
(4990,NULL,'Вікторія',NULL,'2020-05-30',NULL,380948862708,NULL,1378496005,'1',NULL,0,'','0'),
(4991,NULL,'Гриців Валентина',NULL,'2020-05-31',NULL,380685107824,NULL,1734246330,'1',NULL,0,'','0'),
(4992,NULL,'Грицак Таня',NULL,'2020-05-31',NULL,380667343712,NULL,1768056033,'1',NULL,0,'','0'),
(4993,NULL,'Шпак Вікторія',NULL,'2020-05-31',NULL,380978466882,NULL,2032892716,'1',NULL,0,'','0'),
(4994,NULL,'Мазуркевич Оля',NULL,'2020-06-01',NULL,380987650954,NULL,1751365244,'1',NULL,0,'','0'),
(4995,NULL,'Цвєткова Алла',NULL,'2020-06-01',NULL,380964041576,NULL,2057804984,'1',NULL,0,'','0'),
(4996,NULL,'Ткачик Христина',NULL,'2020-06-01','dS4JDWkk06MKKLTtOJ5bVQ==',380966775699,NULL,1842703716,'1',26992,0,'','0'),
(4997,NULL,'Юречко Оксана',NULL,'2020-06-02','PLoNi2xrrovm2SPpxReCjw==',380686248595,NULL,1641451126,'1',37042,1,'','0'),
(4998,NULL,'Швайчук Оксана',NULL,'2020-06-02',NULL,380988728015,NULL,1651719700,'1',NULL,0,'','0'),
(4999,NULL,'Сеньків Ірина',NULL,'2020-06-02',NULL,380960501282,NULL,1294704353,'1',NULL,0,'','0'),
(5000,NULL,'Задорожна Аліна',NULL,'2020-06-02',NULL,380679176624,NULL,1203429049,'1',NULL,0,'','0');

INSERT INTO `kontragentu` VALUES 
(5001,NULL,'Блашків Оксана',NULL,'2020-06-02',NULL,380971637822,NULL,1808881195,'1',NULL,0,'','0'),
(5002,NULL,'курбатова оля',NULL,'2020-06-03',NULL,380674969837,NULL,1165485098,'1',NULL,0,'','0'),
(5003,NULL,'Площук Богданка',NULL,'2020-06-03',NULL,380964726161,NULL,1896755201,'1',NULL,0,'','0'),
(5004,NULL,'Данчук Анастасія',NULL,'2020-06-04',NULL,380685479040,NULL,1510475325,'1',NULL,1,'','0'),
(5005,NULL,'закрита юлія',NULL,'2020-06-04',NULL,380688054480,NULL,1860592841,'1',NULL,0,'','0'),
(5006,NULL,'балла алла ',NULL,'2020-06-04',NULL,380987143140,NULL,1897653630,'1',NULL,0,'','0'),
(5007,NULL,'Троханяк Тетяна',NULL,'2020-06-04',NULL,380686885354,NULL,1822175927,'1',NULL,0,'','0'),
(5008,NULL,'Білик Андрій',NULL,'2020-06-04',NULL,380504341650,NULL,1501796258,'1',NULL,0,'','0'),
(5009,NULL,'Галина Зиноіївна',NULL,'2020-06-04',NULL,380689573815,NULL,1680572663,'1',NULL,0,'','0'),
(5010,NULL,'Равлів Настя',NULL,NULL,'baq/F17BHHnbL1T4c6rJBw==',380981011553,NULL,1949647205,'1',22192,1,'','0'),
(5011,NULL,'Римар Надія',NULL,'2020-06-05',NULL,380989964470,NULL,1851365503,'1',NULL,0,'','0'),
(5012,NULL,'вітрова ірина ',NULL,'2020-06-05',NULL,380996301179,NULL,1673671161,'1',NULL,2,'','0'),
(5013,NULL,'Вівчар Надя',NULL,'2020-06-05',NULL,380980541636,NULL,1961642257,'1',20949,0,'','0'),
(5014,NULL,'Бєга Оля',NULL,'2020-06-05',NULL,380992436962,NULL,1367039092,'1',NULL,0,'','0'),
(5015,NULL,'Горощук Орися',NULL,'2020-06-06',NULL,380676073753,NULL,1156310122,'1',NULL,0,'','0'),
(5016,NULL,'Воробець Марія',NULL,'2020-06-06',NULL,380978507298,NULL,2084279780,'1',NULL,0,'','0'),
(5017,NULL,'Ільницька Соломія',NULL,'2020-06-08',NULL,380971125292,NULL,2048238238,'1',NULL,0,'','0'),
(5018,NULL,'Касяненко Ірина',NULL,'2020-06-08',NULL,380505853416,NULL,2052147081,'1',NULL,0,'','0'),
(5019,NULL,'Чабан Ліля',NULL,'2020-06-09',NULL,380966665045,NULL,1509992071,'1',NULL,0,'','0'),
(5020,NULL,'Чечерлюк ',NULL,'2020-06-09',NULL,380968508481,NULL,1918095598,'1',NULL,0,'','0'),
(5021,NULL,'Городецька Марія',NULL,NULL,NULL,380674929952,NULL,1347528507,'1',NULL,0,'','0'),
(5022,NULL,'Пастух Юля',NULL,'2020-06-11',NULL,380978126858,NULL,1852296910,'1',NULL,0,'','0'),
(5023,NULL,'Ландяк Анна',NULL,NULL,NULL,380964407801,NULL,1528216649,'1',NULL,0,'','0'),
(5024,NULL,'Гладчук Юлія',NULL,'2020-06-11',NULL,380975039608,NULL,1924767908,'1',NULL,0,'','0'),
(5025,NULL,'Пришляк Зоряна',NULL,'2020-06-11',NULL,380966405014,NULL,1744318891,'1',NULL,0,'','0'),
(5026,NULL,'Поплавська Настя',NULL,'2020-06-12',NULL,380963572184,NULL,1297520452,'1',34784,0,'','0'),
(5027,NULL,'Романів Надія',NULL,'2020-06-13',NULL,380971610656,NULL,1400177995,'1',NULL,0,'','0'),
(5028,NULL,'Мушалюк Оля',NULL,'2020-06-13',NULL,380989668767,NULL,2140296723,'1',NULL,0,'','0'),
(5029,NULL,'Чернявська Марія',NULL,'2020-06-13',NULL,380968580904,NULL,1598762736,'1',NULL,0,'','0'),
(5030,NULL,'Гнатюк Юля',NULL,'2020-06-14',NULL,380668469443,NULL,1818710034,'1',NULL,0,'','0'),
(5031,NULL,'Дячук Люда',NULL,'2020-06-15',NULL,380681690625,NULL,1833518390,'1',NULL,0,'','0'),
(5032,NULL,'Павлюк Уляна',NULL,'2020-06-15',NULL,380681217589,NULL,1265363492,'1',NULL,0,'','0'),
(5033,NULL,'Боярчук Софія',NULL,'2020-06-15',NULL,380937210025,NULL,1844827123,'1',NULL,0,'','0'),
(5034,NULL,'Попелюх Тетяна',NULL,'2020-06-16',NULL,380978302350,380978302350,1143753091,'1',NULL,0,'','0'),
(5035,NULL,'Стаднів Наталя',NULL,'2020-06-16',NULL,380966420719,NULL,1259917107,'1',NULL,0,'','0'),
(5036,NULL,'Веретик Уляна',NULL,'2020-06-16',NULL,380961842584,NULL,2098417905,'1',NULL,0,'','0'),
(5037,NULL,'Романів Марія',NULL,'2020-06-16',NULL,380982234489,NULL,1483585929,'1',NULL,0,'','0'),
(5038,NULL,'Білусяк Раїса',NULL,'2020-06-16',NULL,380966372706,NULL,1684397521,'1',NULL,0,'','0'),
(5039,NULL,'Вець Катерина',NULL,'2020-06-17',NULL,380687136063,NULL,1452079960,'1',NULL,0,'','0'),
(5040,NULL,'Наконечна Оксана',NULL,'2020-06-17','s8UFS29opCj0bDmMz295Lg==',380686047283,NULL,1270552612,'1',44978,0,'','0'),
(5041,NULL,'Бунікевич Анна',NULL,'2020-06-17',NULL,380997860798,NULL,1253598599,'1',NULL,0,'','0'),
(5042,NULL,'Герасимяк Тетяна',NULL,'2020-06-17',NULL,380678830855,NULL,1806639153,'1',NULL,0,'','0'),
(5043,NULL,'Данилюк Христина',NULL,'2020-06-17',NULL,380684218767,NULL,1126214365,'1',50921,0,'','0'),
(5044,NULL,'Гаєвська Оля',NULL,'2020-06-17',NULL,380974416773,NULL,2046834651,'1',NULL,0,'','0'),
(5045,NULL,'Гоменюк Вікторія',NULL,'2020-06-17',NULL,380682441082,NULL,1781210205,'1',NULL,1,'','0'),
(5046,NULL,'Мельник Інна',NULL,'2020-06-17',NULL,380684407430,NULL,1837008783,'1',NULL,0,'','0'),
(5047,NULL,'Будий Оксана ',NULL,'2020-06-17',NULL,380967248157,NULL,1868514228,'1',NULL,0,'','0'),
(5048,NULL,'Попадюк Ольга',NULL,'2020-06-18',NULL,380980592043,NULL,1502718113,'1',NULL,0,'','0'),
(5049,NULL,'Гомова Галя',NULL,'2020-06-18',NULL,380686474140,NULL,1279299338,'1',NULL,0,'','0'),
(5050,NULL,'Черниш Оля',NULL,'2020-06-18',NULL,380638128115,NULL,1681554347,'1',NULL,0,'','0'),
(5051,NULL,'Ковбасюк Іванка',NULL,'2020-06-18',NULL,380980945817,NULL,1628455995,'1',NULL,1,'','0'),
(5052,NULL,'Бердецька Ірина',NULL,'2020-06-18',NULL,380967334266,NULL,1239220386,'1',NULL,0,'','0'),
(5053,NULL,'Садикова Тетяна',NULL,'2020-06-18',NULL,380665680484,NULL,1625983186,'1',NULL,0,'','0'),
(5054,NULL,'Плішка Людмила',NULL,'2020-06-19',NULL,380983506274,NULL,1975037320,'1',NULL,0,'','0'),
(5055,NULL,'Трембовецька Світлана',NULL,'2020-06-19',NULL,380505081920,NULL,1502377866,'1',NULL,0,'','0'),
(5056,NULL,'Шпак Оля',NULL,'2020-06-19',NULL,380972182603,NULL,1118637882,'1',NULL,0,'','0'),
(5057,NULL,'Приборович Анджела',NULL,NULL,'zgpoX3r4zqZCrsYPQ3S6tQ==',380970567049,NULL,1883388968,'1',56699,0,'','0'),
(5058,NULL,'Войтович Христина',NULL,'2020-06-19',NULL,380934416623,NULL,1849647396,'1',NULL,0,'','0'),
(5059,NULL,'Мала Наталя',NULL,'2020-06-19',NULL,380979010865,NULL,1914301285,'1',36286,1,'','0'),
(5060,NULL,'Волощук Наталя',NULL,'2020-06-19',NULL,380989291449,NULL,1984981489,'1',NULL,0,'','0'),
(5061,NULL,'парасимчук світлана ',NULL,'2020-06-22',NULL,380681157310,NULL,1457462358,'1',NULL,0,'','0'),
(5062,NULL,'джага вадим ',NULL,'2020-06-22',NULL,380986163678,NULL,1409029371,'1',NULL,0,'','0'),
(5063,NULL,'Басіста Юля ',NULL,'2020-06-22',NULL,380961616467,NULL,2002160122,'1',NULL,0,'','0'),
(5064,NULL,'Лебідь Софія',NULL,'2020-06-22',NULL,380505363097,NULL,1319271917,'1',NULL,0,'','0'),
(5065,NULL,'Микитюк Христя',NULL,'2020-06-23',NULL,380975943851,NULL,1171240819,'1',NULL,0,'','0'),
(5066,NULL,'Савіцька Надія',NULL,'2020-06-24',NULL,380990160509,NULL,2095098430,'1',NULL,0,'','0'),
(5067,NULL,'Осадса Юля',NULL,'2020-06-24',NULL,380667442363,NULL,1673476901,'1',NULL,0,'','0'),
(5068,NULL,'Корняк Надія',NULL,'2020-06-24',NULL,380504371757,NULL,1176606348,'1',NULL,0,'','0'),
(5069,NULL,'Ольшаковська Оля',NULL,'2020-06-24',NULL,380673191902,NULL,1878188756,'1',NULL,0,'','0'),
(5070,NULL,'Нога Галина',NULL,'2020-06-25',NULL,380684743896,NULL,1801012763,'1',NULL,0,'','0'),
(5071,NULL,'Репетовська Іванка',NULL,'2020-06-25',NULL,380977772792,NULL,2034085797,'1',NULL,0,'','0'),
(5072,NULL,'Потикевич Маряна',NULL,'2020-06-25',NULL,380672893092,NULL,1166860722,'1',NULL,0,'','0'),
(5073,NULL,'Добриднєва Жанна',NULL,'2020-06-25',NULL,380976993436,NULL,1990696651,'1',NULL,0,'','0'),
(5074,NULL,'Госович Ірина',NULL,'2020-06-25',NULL,380987928896,NULL,1278978980,'1',NULL,0,'','0'),
(5075,NULL,'Сороківська Маряна',NULL,'2020-06-25',NULL,380684210158,NULL,1304923328,'1',43273,0,'','0'),
(5076,NULL,'Біланик Василь',NULL,'2020-06-26',NULL,380978126362,NULL,1363828509,'1',NULL,0,'','0'),
(5077,NULL,'Мазуркевич Соломія',NULL,'2020-06-26',NULL,380962763015,NULL,1909244234,'1',NULL,0,'','0'),
(5078,NULL,'САдигова Галина',NULL,'2020-06-26',NULL,380965899665,NULL,1929132329,'1',NULL,0,'','0'),
(5079,NULL,'Яник Настя ',NULL,'2020-06-26',NULL,380674944228,NULL,2057116760,'1',NULL,0,'','0'),
(5080,NULL,'Денис Анастасія',NULL,'2020-06-26',NULL,380989298004,NULL,2145072690,'1',NULL,0,'','0'),
(5081,NULL,'Мазуркевич Ліля',NULL,'2020-06-26',NULL,380971354227,NULL,1379208414,'1',NULL,1,'','0'),
(5082,NULL,'Лазорик Христина',NULL,'2020-06-27',NULL,380680205169,NULL,1891658858,'1',NULL,0,'','0'),
(5083,NULL,'Мостович Наталя ',NULL,'2020-06-27',NULL,380968804815,NULL,1535730413,'1',50216,0,'','0'),
(5084,NULL,'Гордієнко Лілія',NULL,'2020-06-27',NULL,380980646112,NULL,1530634267,'1',NULL,0,'','0'),
(5085,NULL,'Картофель Оксана ',NULL,'2020-06-29',NULL,380969883589,NULL,1805128897,'1',NULL,0,'','0'),
(5086,NULL,'Гевко Христина',NULL,'2020-06-30',NULL,380976613435,NULL,1179800084,'1',NULL,0,'','0'),
(5087,NULL,'Яцків Андрій',NULL,'2020-06-30',NULL,380985208875,NULL,1826029724,'1',NULL,0,'','0'),
(5088,NULL,'Савіцька олександра',NULL,'2020-06-30',NULL,380682315597,NULL,1929699912,'1',NULL,0,'','0'),
(5089,NULL,'Савіцька Юля ',NULL,'2020-06-30',NULL,380979277055,NULL,1253649649,'1',NULL,0,'','0'),
(5090,NULL,'Шереме Ірина',NULL,'2020-06-30',NULL,380678007925,NULL,1786065690,'1',NULL,0,'','0'),
(5091,NULL,'Сойма Віта',NULL,'2020-07-01',NULL,380965240530,NULL,2052987503,'1',NULL,0,'','0'),
(5092,NULL,'Ничко Христина',NULL,'2020-07-01',NULL,380682913870,NULL,1970401205,'1',NULL,0,'','0'),
(5093,NULL,'Грабовий Богдан',NULL,'2020-07-01',NULL,380501892166,NULL,1339090588,'1',NULL,0,'','0'),
(5094,NULL,'Марія Андрухів',NULL,NULL,NULL,380962928634,NULL,1736657273,'1',NULL,0,'','0'),
(5095,NULL,'Гутор Оля',NULL,'2020-07-01',NULL,380686257629,NULL,1475747453,'1',46045,0,'','0'),
(5096,NULL,'Нашкольна Іванна',NULL,'2020-07-01',NULL,380680268736,NULL,2118766266,'1',53610,0,'','0'),
(5097,NULL,'Лазарська Аліна',NULL,NULL,NULL,380979971385,NULL,1912913918,'1',24532,1,'','0'),
(5098,NULL,'Кобко Іванна',NULL,'2020-07-02',NULL,380974014154,NULL,2054904639,'1',NULL,0,'','0'),
(5099,NULL,'Дутка Христина',NULL,'2020-07-02',NULL,380976116821,NULL,1196360425,'1',NULL,0,'','0'),
(5100,NULL,'Скалій Наталя',NULL,'2020-07-02',NULL,380963577033,NULL,1940075674,'1',NULL,0,'','0'),
(5101,NULL,'ірха ольга',NULL,'2020-07-02',NULL,380969456217,NULL,1155101488,'1',NULL,0,'','0'),
(5102,NULL,'Мельник Марія',NULL,'2020-07-03',NULL,380680264633,NULL,1270097209,'1',NULL,0,'','0'),
(5103,NULL,'Кінах Надія',NULL,'2020-07-03',NULL,380969553655,NULL,1336978061,'1',22096,0,'','0'),
(5104,NULL,'Капаць Анастасія',NULL,'2020-07-03',NULL,380961681029,NULL,1669503618,'1',NULL,1,'','0'),
(5105,NULL,'Гукалюк Маряна',NULL,'2020-07-03','XzKD6eQwrR3ObZn41O3qHw==',380668816079,NULL,1769116367,'1',NULL,0,'','0'),
(5106,NULL,'Кірківська Яна ',NULL,'2020-07-03',NULL,380983958027,NULL,1383799652,'1',NULL,0,'','0'),
(5107,NULL,'Красовський Вікторія ',NULL,'2020-07-03',NULL,380506216137,NULL,1978628418,'1',53999,0,'','0'),
(5108,NULL,'Кінаш Ліля',NULL,'2020-07-04',NULL,380975393218,NULL,1627531114,'1',49456,0,'','0'),
(5109,NULL,'денчик надія',NULL,'2020-07-04',NULL,380982901139,NULL,1795877430,'1',NULL,0,'','0'),
(5110,NULL,'Клапків уляна',NULL,'2020-07-04',NULL,380968910272,NULL,1900206251,'1',NULL,0,'','0'),
(5111,NULL,'мархивка катерина',NULL,'2020-07-04',NULL,380987768450,NULL,1900273927,'1',NULL,0,'','0'),
(5112,NULL,'Роман Мар’яна ',NULL,'2020-07-04',NULL,380986600513,NULL,1694154711,'1',NULL,0,'','0'),
(5113,NULL,'Остапчук Оксана ',NULL,'2020-07-05',NULL,380978045532,NULL,1975895778,'1',NULL,0,'','0'),
(5114,NULL,'Дребіт Оля',NULL,'2020-07-06',NULL,380986687970,NULL,1483800001,'1',NULL,1,'','0'),
(5115,NULL,'тоніцька наталя',NULL,'2020-07-06',NULL,380663401044,NULL,1145710930,'1',NULL,0,'','0'),
(5116,NULL,'осьмак аліна',NULL,'2020-07-06',NULL,380979182526,NULL,1226686466,'1',NULL,0,'','0'),
(5117,NULL,'петрів світлана',NULL,'2020-07-06',NULL,380987493981,NULL,1358598382,'1',NULL,0,'','0'),
(5118,NULL,'вівчар богдана',NULL,'2020-07-08',NULL,380672686416,NULL,1774538911,'1',NULL,0,'','0'),
(5119,NULL,'бодьо ольга',NULL,'2020-07-08',NULL,380979153929,NULL,1285011035,'1',NULL,0,'','0'),
(5120,NULL,'ботуленко володимира',NULL,'2020-07-08',NULL,380986268330,NULL,1493411191,'1',NULL,0,'','0'),
(5121,NULL,'будзінська світлана',NULL,'2020-07-08',NULL,380964212482,NULL,1503863954,'1',NULL,0,'','0'),
(5122,NULL,'головата вікторія',NULL,'2020-07-09','8OPQ1TmJIExNpOSZ6Onkkg==',380683425559,NULL,1679850582,'1',47569,0,'','0'),
(5123,NULL,'спасюк оксана',NULL,'2020-07-09',NULL,380680016589,NULL,2044204895,'1',NULL,0,'','0'),
(5124,NULL,'хруняк оля',NULL,'2020-07-09',NULL,380962943297,NULL,1625856840,'1',NULL,0,'','0'),
(5125,NULL,'опацька світлана',NULL,'2020-07-09',NULL,380687714129,NULL,1841414387,'1',NULL,0,'','0'),
(5126,NULL,'бичковська вероніка',NULL,'2020-07-10',NULL,380963469800,NULL,1331524140,'1',NULL,0,'','0'),
(5127,NULL,'шпунярська Наталя',NULL,'2020-07-10',NULL,380963642939,NULL,1894409662,'1',NULL,0,'','0'),
(5128,NULL,'дячок маряна',NULL,'2020-07-10',NULL,380972614737,NULL,1866476665,'1',NULL,0,'','0'),
(5129,NULL,'кільчицька марія іванівна',NULL,'2020-07-10',NULL,380963975142,NULL,1710176263,'1',NULL,0,'','0'),
(5130,NULL,'іванська марія',NULL,'2020-07-11','RuIZplU4n7t9Oc90DiUTtA==',380960659836,NULL,1239922731,'1',14793,0,'','0'),
(5131,NULL,'савчиньська люба',NULL,'2020-07-11',NULL,380964345973,NULL,1261831799,'1',NULL,0,'','0'),
(5132,NULL,'Єднораз Анастасія',NULL,'2020-07-11',NULL,380688631627,NULL,1520221955,'1',NULL,1,'','0'),
(5133,NULL,'Сазикіна Галина ',NULL,'2020-07-11',NULL,380993600208,NULL,1175744805,'1',NULL,0,'','0'),
(5134,NULL,'Дребіт Галина ',NULL,'2020-07-11',NULL,380972462028,NULL,1969072563,'1',NULL,0,'','0'),
(5135,NULL,'Яблонь Ольга ',NULL,'2020-07-11',NULL,380980189081,NULL,1257653604,'1',NULL,0,'','0'),
(5136,NULL,'Голуб Ольга',NULL,'2020-07-12',NULL,380972918224,NULL,1245714774,'1',NULL,0,'','0'),
(5137,NULL,'Лейбак Марія ',NULL,'2020-07-12',NULL,380688424920,NULL,1401897654,'1',NULL,1,'','0'),
(5138,NULL,'Штурма Тетяна',NULL,'2020-07-13','uRmOG7hlD22ju6oRAwUezQ==',380686499302,NULL,1372574640,'1',60279,0,'','0'),
(5139,NULL,'Марко Людмила',NULL,'2020-07-13',NULL,380960505955,NULL,1922140226,'1',NULL,0,'','0'),
(5140,NULL,'швагла наталія',NULL,'2020-07-13',NULL,380975985540,NULL,1186653160,'1',NULL,0,'','0'),
(5141,NULL,'Цьванько Христина',NULL,'2020-07-13',NULL,380634159067,NULL,1416390519,'1',NULL,0,'','0'),
(5142,NULL,'Гладчук Галина',NULL,'2020-07-13',NULL,380979470900,NULL,1231526324,'1',NULL,0,'','0'),
(5143,NULL,'Місюрак Оксана',NULL,'2020-07-13',NULL,380971410302,NULL,1530788481,'1',NULL,0,'','0'),
(5144,NULL,'совяк юлія',NULL,'2020-07-13','T2L06KBCHwJgZOi0/DAu9g==',380732045705,NULL,1618683056,'1',21078,0,'','0'),
(5145,NULL,'боднар Юлія',NULL,'2020-07-13',NULL,380953991689,NULL,1263143337,'1',NULL,0,'','0'),
(5146,NULL,'Штурма Вікторія ',NULL,'2020-07-13',NULL,380960720069,NULL,1477880961,'1',52966,0,'','0'),
(5147,NULL,'Нейко Юлія ',NULL,'2020-07-13',NULL,380971775747,NULL,1584406315,'1',NULL,0,'','0'),
(5148,NULL,'юнта олеся',NULL,'2020-07-14',NULL,380099118609,NULL,1788920674,'1',NULL,0,'','0'),
(5149,NULL,'типусяк марія',NULL,'2020-07-14',NULL,380953753338,NULL,1377346178,'1',NULL,0,'','0'),
(5150,NULL,'школьницька івана',NULL,'2020-07-14',NULL,380672887136,NULL,1509130347,'1',NULL,0,'','0'),
(5151,NULL,'лавринчук людмила',NULL,'2020-07-14',NULL,380663265542,NULL,2062301831,'1',NULL,0,'','0'),
(5152,NULL,'посіпов іра',NULL,'2020-07-15',NULL,380976169132,NULL,1130833899,'1',NULL,0,'','0'),
(5153,NULL,'климко юля',NULL,'2020-07-15',NULL,380983909005,NULL,2077702981,'1',57438,0,'','0'),
(5154,NULL,'Пукало Ольга',NULL,NULL,NULL,380956652360,NULL,1878867186,'1',NULL,1,'','0'),
(5155,NULL,'ляхоцька Іванка',NULL,'2020-07-15',NULL,380972050810,NULL,1936668308,'1',NULL,0,'','0'),
(5156,NULL,'Мисюра Марія',NULL,'2020-07-15',NULL,380098061261,NULL,1197662905,'1',NULL,0,'','0'),
(5157,NULL,'Шпунярська Дарія',NULL,'2020-07-16',NULL,380967293748,NULL,1538485238,'1',NULL,0,'','0'),
(5158,NULL,'Лісова Оксана',NULL,'2020-07-16',NULL,380982763211,NULL,1713023299,'1',NULL,0,'','0'),
(5159,NULL,'Карпинська Леся',NULL,'2020-07-16',NULL,380678642198,NULL,1429613229,'1',NULL,0,'','0'),
(5160,NULL,'Пелікан Оксана',NULL,'2020-07-16','gMybselW7TYywlpYQFCI5Q==',380986657152,NULL,2134358060,'1',61513,0,'','0'),
(5161,NULL,'Войтко Марія ',NULL,'2020-07-16',NULL,380960105373,NULL,2138640027,'1',NULL,0,'','0'),
(5162,NULL,'Шишко Коля',NULL,'2020-07-16',NULL,380684212179,NULL,2077825843,'1',NULL,0,'','0'),
(5163,NULL,'Слота Галина',NULL,'2020-07-17',NULL,380975781272,NULL,1356520275,'1',NULL,0,'','0'),
(5164,NULL,'Геравс зоряна',NULL,'2020-07-18',NULL,380972051101,NULL,1405781275,'1',NULL,0,'','0'),
(5165,NULL,'малиновська христина',NULL,'2020-07-20',NULL,380971235443,NULL,1367815914,'1',NULL,0,'','0'),
(5166,NULL,'Федорович Христина ',NULL,'2020-07-20',NULL,380968895499,NULL,2145504631,'1',NULL,1,'','0'),
(5167,NULL,'Вибодовська Ангеліна ',NULL,'2020-07-20',NULL,380687528006,NULL,1368158992,'1',16097,0,'','0'),
(5168,NULL,'качур оксана',NULL,'2020-07-20',NULL,380987464086,NULL,2075264946,'1',NULL,0,'','0'),
(5169,NULL,'Кавчук Світлана ',NULL,'2020-07-20',NULL,380502488012,NULL,1555005398,'1',NULL,0,'','0'),
(5170,NULL,'калинович галя',NULL,'2020-07-21',NULL,380684566383,NULL,2066152832,'1',NULL,0,'','0'),
(5171,NULL,'Адамович Оля',NULL,'2020-07-21',NULL,380976907631,NULL,1893066650,'1',NULL,0,'','0'),
(5172,NULL,'Снігур Каріна',NULL,'2020-07-21',NULL,380682549105,NULL,1985095310,'1',NULL,0,'','0'),
(5173,NULL,'заєць оля',NULL,'2020-07-21',NULL,380985746968,NULL,2133304122,'1',NULL,0,'','0'),
(5174,NULL,'Штурма Оля',NULL,'2020-07-21',NULL,380686466886,NULL,2037343521,'1',49438,0,'','0'),
(5175,NULL,'Філяк Світлана',NULL,'2020-07-21',NULL,380980525670,NULL,1432689239,'1',NULL,0,'','0'),
(5176,NULL,'Шлінк Тетяна',NULL,'2020-07-21',NULL,380989235058,NULL,1263104663,'1',NULL,0,'','0'),
(5177,NULL,'Полоз Тетяна',NULL,'2020-07-21',NULL,380671249878,NULL,1658004942,'1',NULL,0,'','0'),
(5178,NULL,'скочеляс галина',NULL,NULL,'KdOHx1nqwp1rV++QIIorDw==',380680877865,380680877865,1204280518,'1',NULL,0,'','0'),
(5179,NULL,'дідик христина',NULL,'2020-07-22',NULL,380680880446,NULL,1706369873,'1',NULL,0,'','0'),
(5180,NULL,'Стефанюк Вікторія',NULL,'2020-07-22',NULL,380973299800,NULL,1465917918,'1',NULL,0,'','0'),
(5181,NULL,'Гулька Надія',NULL,'2020-07-22',NULL,380685011326,NULL,1205032936,'1',NULL,0,'','0'),
(5182,NULL,'Кушнір Ірина',NULL,'2020-07-22',NULL,380680017072,NULL,1534651893,'1',NULL,0,'','0'),
(5183,NULL,'Арич Лілія',NULL,'2020-07-22',NULL,380961249512,NULL,1385948217,'1',NULL,0,'','0'),
(5184,NULL,'Терещенко Вікторія',NULL,'2020-07-22',NULL,380683160676,NULL,1278593022,'1',NULL,0,'','0'),
(5185,NULL,'Заяць Соломія',NULL,'2020-07-23',NULL,380974652957,NULL,1266163202,'1',NULL,0,'','0'),
(5186,NULL,'Юскевич Галина',NULL,'2020-07-23',NULL,380668143236,NULL,1257848389,'1',NULL,0,'','0'),
(5187,NULL,'Борщ Ольга',NULL,'2020-07-23',NULL,380989021810,NULL,1526265163,'1',NULL,0,'','0'),
(5188,NULL,'Гира Наталя',NULL,'2020-07-23',NULL,380970058378,NULL,1747702435,'1',NULL,0,'','0'),
(5189,NULL,'Коник Тетяна',NULL,'2020-07-23',NULL,380671524836,NULL,1775056416,'1',NULL,0,'','0'),
(5190,NULL,'Розлуцька Уляна',NULL,'2020-07-23',NULL,380961088685,NULL,1622799371,'1',NULL,1,'','0'),
(5191,NULL,'Мосанюк Ольга',NULL,'2020-07-23',NULL,380956869052,NULL,1706215641,'1',NULL,0,'','0'),
(5192,NULL,'черемшинська люба',NULL,'2020-07-24',NULL,380976117280,NULL,1492172750,'1',NULL,0,'','0'),
(5193,NULL,'Пласкіна Оксана',NULL,'2020-07-24',NULL,380680463294,NULL,1241726087,'1',NULL,0,'','0'),
(5194,NULL,'малічевська любов',NULL,'2020-07-24',NULL,380680245591,NULL,1344772487,'1',NULL,0,'','0'),
(5195,NULL,'Стельмащук Ольга',NULL,'2020-07-25',NULL,380675790317,NULL,1623631308,'1',NULL,0,'','0'),
(5196,NULL,'Гулевич Марія ',NULL,'2020-07-25',NULL,380967656977,NULL,1415454616,'1',NULL,0,'','0'),
(5197,NULL,'Бойко наталя ',NULL,'2020-07-25',NULL,380685934962,NULL,1646303366,'1',NULL,0,'','0'),
(5198,NULL,'Телепач Світлана ',NULL,'2020-07-26',NULL,380967850073,NULL,1253123717,'1',NULL,0,'','0'),
(5199,NULL,'Мацібурка Христина ',NULL,'2020-07-26',NULL,380983863870,NULL,1512464642,'1',NULL,0,'','0'),
(5200,NULL,'Мамуляк Христина',NULL,'2020-07-27',NULL,380977236278,NULL,1425040190,'1',NULL,0,'','0'),
(5201,NULL,'Присяжна Христина',NULL,'2020-07-27','8FZOkaWxVLLyScCS+0ypZQ==',380978723622,NULL,1801060928,'1',NULL,0,'','0'),
(5202,NULL,'Ландяк христина',NULL,'2020-07-27',NULL,380967671000,NULL,2085995548,'1',NULL,0,'','0'),
(5203,NULL,'Білень Христина',NULL,'2020-07-27',NULL,380730788859,NULL,1585818725,'1',NULL,0,'','0'),
(5204,NULL,'Козак Роксолана',NULL,'2020-07-27',NULL,380689829193,NULL,1443728120,'1',25326,2,'','0'),
(5205,NULL,'Семенчук Івана Василівна',NULL,'2020-07-27',NULL,380685365935,NULL,1747888465,'1',NULL,0,'','0'),
(5206,NULL,'гургач Галина',NULL,'2020-07-27',NULL,380666977461,NULL,2012669329,'1',NULL,0,'','0'),
(5207,NULL,'Демидась Олена',NULL,'2020-07-27',NULL,380680462454,NULL,2115430768,'1',NULL,0,'','0'),
(5208,NULL,'Золота Маряна',NULL,'2020-07-27',NULL,380677542102,NULL,1294634785,'1',NULL,0,'','0'),
(5209,NULL,'Василик леся',NULL,'2020-07-27',NULL,380685038601,NULL,1213050937,'1',NULL,0,'','0'),
(5210,NULL,'Чопик Тетяна',NULL,'2020-07-27',NULL,380961467088,NULL,1820581760,'1',NULL,0,'','0'),
(5211,NULL,'Росовська Олена',NULL,'2020-07-27',NULL,380960172845,NULL,1695515293,'1',NULL,0,'','0'),
(5212,NULL,'Саламах Аліна',NULL,'2020-07-27',NULL,380977167862,NULL,2022644976,'1',NULL,0,'','0'),
(5213,NULL,'Сердинська Анастасія',NULL,'2020-07-28',NULL,380980897932,NULL,1506594121,'1',NULL,0,'','0'),
(5214,NULL,'Шмайдей Наталя',NULL,'2020-07-28',NULL,380686271792,NULL,1207657164,'1',NULL,0,'','0'),
(5215,NULL,'Чухрій Ольга',NULL,'2020-07-28',NULL,380686495900,NULL,1826004205,'1',NULL,0,'','0'),
(5216,NULL,'Джулінська Світлана',NULL,'2020-07-28',NULL,380991937904,NULL,1340925212,'1',NULL,0,'','0'),
(5217,NULL,'гановська Ярослава',NULL,'2020-07-28',NULL,380678048234,NULL,2098833220,'1',NULL,0,'','0'),
(5218,NULL,'Мельничук Оксана',NULL,'2020-07-28',NULL,380686051044,NULL,1263745579,'1',NULL,0,'','0'),
(5219,NULL,'Осадча Оля',NULL,'2020-07-28',NULL,380681550307,NULL,1770191517,'1',NULL,0,'','0'),
(5220,NULL,'Галатюк Христина ',NULL,'2020-07-28',NULL,380976011270,NULL,1780134886,'1',NULL,0,'','0'),
(5221,NULL,'Марцинкевич Світлана',NULL,'2020-07-29',NULL,380953950571,NULL,1199047211,'1',NULL,0,'','0'),
(5222,NULL,'Василів Олена',NULL,'2020-07-29',NULL,380966294591,NULL,1483823998,'1',NULL,0,'','0'),
(5223,NULL,'Москалик Люда',NULL,'2020-07-30',NULL,380687355703,NULL,2137426589,'1',NULL,0,'','0'),
(5224,NULL,'Деренюк Марія',NULL,'2020-07-30',NULL,380968934286,NULL,1122917591,'1',NULL,0,'','0'),
(5225,NULL,'Тимусь ',NULL,'2020-07-30',NULL,380989045134,NULL,1557198214,'1',NULL,0,'','0'),
(5226,NULL,'Семанюк Євгенія',NULL,'2020-07-30',NULL,380977622370,NULL,1971259183,'1',NULL,1,'','0'),
(5227,NULL,'Магас Олена',NULL,'2020-07-30',NULL,380986231424,NULL,1483348729,'1',NULL,0,'','0'),
(5228,NULL,'Яхван Діана',NULL,'2020-07-30','sqlM+GxUX3Yg4dPXQJRq9Q==',380986459198,NULL,1666774228,'1',18351,0,'','0'),
(5229,NULL,'Побежна Тетяна',NULL,'2020-07-30',NULL,380966576525,NULL,1851094148,'1',NULL,0,'','0'),
(5230,NULL,'Холодюк Ірина',NULL,'2020-07-31',NULL,380668425433,NULL,1706513359,'1',NULL,0,'','0'),
(5231,NULL,'Буць Аліна',NULL,'2020-07-31',NULL,380964070666,NULL,1531688023,'1',53243,0,'','0'),
(5232,NULL,'лозінська тетяна',NULL,'2020-07-31',NULL,380988651353,NULL,1371390943,'1',NULL,0,'','0'),
(5233,NULL,'Гевко Христина',NULL,'2020-07-31',NULL,380985883223,NULL,1864353776,'1',NULL,1,'','0'),
(5234,NULL,'Мостова Катерина',NULL,'2020-07-31',NULL,380979864007,NULL,1633213533,'1',NULL,0,'','0'),
(5235,NULL,'Носова ыра',NULL,'2020-08-01',NULL,380976553611,NULL,1120546894,'1',NULL,0,'','0'),
(5236,NULL,'Амісель Галя',NULL,'2020-08-01',NULL,380677808088,NULL,1501656136,'1',NULL,0,'','0'),
(5237,NULL,'Аня наша бухгалтер',NULL,'2020-08-01','ebASfVA8KDywet3U7/JWbg==',380979095535,NULL,1921177863,'1',NULL,0,'','0'),
(5238,NULL,'Стасів Марія',NULL,'2020-08-01',NULL,380685124859,NULL,1990161629,'1',NULL,0,'','0'),
(5239,NULL,'шевчук іванна',NULL,'2020-08-01',NULL,380965374847,NULL,1118601138,'1',NULL,0,'','0'),
(5240,NULL,'Буйнікевич Оля',NULL,'2020-08-03',NULL,380979021963,NULL,1265357045,'1',NULL,0,'','0'),
(5241,NULL,'Совяк Світлана',NULL,'2020-08-03','0brbV/MbYbIFQegiTYh4WQ==',380963703068,NULL,1676507308,'1',NULL,0,'','0'),
(5242,NULL,'Гігійчук ',NULL,'2020-08-03',NULL,380961099770,NULL,1503619738,'1',NULL,0,'','0'),
(5243,NULL,'Мельник Юля',NULL,'2020-08-03',NULL,380966207252,NULL,1357703389,'1',NULL,0,'','0'),
(5244,NULL,'Заверуха Марія',NULL,'2020-08-03',NULL,380970523904,NULL,1875558826,'1',NULL,0,'','0'),
(5245,NULL,'Строцень Юля',NULL,'2020-08-03',NULL,380986797998,NULL,1870223417,'1',NULL,0,'','0'),
(5246,NULL,'Гуска Оксана ',NULL,'2020-08-03',NULL,380963683855,NULL,1491166529,'1',NULL,0,'','0'),
(5247,NULL,'Нога Оксана',NULL,'2020-08-04',NULL,380966902985,NULL,1479606852,'1',NULL,0,'','0'),
(5248,NULL,'Матвійчук Марія',NULL,'2020-08-04',NULL,380965021344,NULL,1824073394,'1',NULL,0,'','0'),
(5249,NULL,'Морпак Марія',NULL,'2020-08-04',NULL,380686695077,NULL,2078972685,'1',NULL,0,'','0'),
(5250,NULL,'Ваньчук Ірина',NULL,'2020-08-04',NULL,380969930916,NULL,1855735932,'1',NULL,0,'','0'),
(5251,NULL,'Кузьмович Оля',NULL,'2020-08-04',NULL,380964880280,NULL,1770194843,'1',NULL,0,'','0'),
(5252,NULL,'Змієва Ліля ',NULL,'2020-08-04',NULL,380974078069,NULL,1766688728,'1',NULL,0,'','0'),
(5253,NULL,'Гнидиашин Іванка',NULL,'2020-08-04',NULL,380976607104,NULL,1331532042,'1',NULL,0,'','0'),
(5254,NULL,'Полоз Надія',NULL,'2020-08-05',NULL,380976780308,NULL,1255188470,'1',NULL,0,'','0'),
(5255,NULL,'Тетерів Оксана ',NULL,'2020-08-05',NULL,380684869308,NULL,1174488786,'1',NULL,0,'','0'),
(5256,NULL,'Андрухів Марія',NULL,'2020-08-05',NULL,380988629438,NULL,1891406591,'1',NULL,0,'','0'),
(5257,NULL,'Андрухів Ольга',NULL,'2020-08-05',NULL,380686469108,NULL,1312080608,'1',NULL,0,'','0'),
(5258,NULL,'Слободян Марія',NULL,'2020-08-05',NULL,380986157826,NULL,1300080958,'1',NULL,0,'','0'),
(5259,NULL,'Базів Уяяна',NULL,'2020-08-05','nL7GrWVvywAaSeM0ZMAwTg==',380989104804,NULL,1294698710,'1',NULL,0,'','0'),
(5260,NULL,'Ландяк Таня',NULL,NULL,NULL,380689619418,NULL,1393125705,'1',29165,0,'','0'),
(5261,NULL,'Юркевич Оксана',NULL,'2020-08-05',NULL,380967542609,NULL,1865505247,'1',NULL,0,'','0'),
(5262,NULL,'Плецан Христина',NULL,'2020-08-05',NULL,380969022903,NULL,1798005170,'1',NULL,1,'','0'),
(5263,NULL,'стадник аня',NULL,'2020-08-05',NULL,380977201363,NULL,1414878594,'1',NULL,1,'','0'),
(5264,NULL,'Казьмірів Іванна',NULL,'2020-08-05',NULL,380961267925,NULL,2101489249,'1',22100,0,'','0'),
(5265,NULL,'Кнобель Оля',NULL,'2020-08-06',NULL,380681120275,NULL,2021612852,'1',NULL,0,'','0'),
(5266,NULL,'Бойко Галина ',NULL,'2020-08-06',NULL,380982505153,NULL,1531631071,'1',NULL,0,'','0'),
(5267,NULL,'Боднарук Люба',NULL,'2020-08-07',NULL,380979704747,NULL,1581226563,'1',NULL,0,'','0'),
(5268,NULL,'Пава Віолета',NULL,'2020-08-07',NULL,380689782284,NULL,1973633057,'1',NULL,0,'','0'),
(5269,NULL,'Левенко Мирослава',NULL,'2020-08-07',NULL,380977747952,NULL,1629731570,'1',NULL,0,'','0'),
(5270,NULL,'Чигрик Оля',NULL,'2020-08-08',NULL,380963996198,NULL,1202227479,'1',NULL,0,'','0'),
(5271,NULL,'півторак галя',NULL,'2020-08-08',NULL,380974686853,NULL,1117031120,'1',NULL,0,'','0'),
(5272,NULL,'ільченко Галина',NULL,'2020-08-08',NULL,380966568859,NULL,1568782044,'1',50036,0,'','0'),
(5273,NULL,'Атаманчук Олександра',NULL,'2020-08-08',NULL,380687451664,NULL,1675405471,'1',NULL,0,'','0'),
(5274,NULL,'гермак людмила',NULL,'2020-08-08',NULL,380987522947,NULL,1455354077,'1',NULL,0,'','0'),
(5275,NULL,'Кардинал Ірина ',NULL,'2020-08-08',NULL,380967974893,NULL,1176887952,'1',NULL,0,'','0'),
(5276,NULL,'Євчин Діана',NULL,'2020-08-08',NULL,380976302980,NULL,1223657075,'1',NULL,0,'','0'),
(5277,NULL,'Величко Івана ',NULL,'2020-08-09',NULL,380987258455,NULL,1456136563,'1',NULL,1,'','0'),
(5278,NULL,'Полупан Світлана',NULL,'2020-08-10',NULL,380980405688,NULL,1190005247,'1',NULL,0,'','0'),
(5279,NULL,'Гуль світлана',NULL,'2020-08-10',NULL,380984652596,NULL,1492858062,'1',NULL,0,'','0'),
(5280,NULL,'Совяк Тетяна',NULL,'2020-08-10',NULL,380988020990,NULL,1282333084,'1',53853,0,'','0'),
(5281,NULL,'Цибульська Наталя ',NULL,'2020-08-10',NULL,380989997305,NULL,2013612399,'1',NULL,1,'','0'),
(5282,NULL,'макар женя',NULL,'2020-08-10',NULL,380975846322,NULL,1974073406,'1',NULL,0,'','0'),
(5283,NULL,'Навроцька Діана',NULL,'2020-08-10',NULL,380686044727,NULL,1346243363,'1',NULL,0,'','0'),
(5284,NULL,'лебедь ірина',NULL,'2020-08-10',NULL,380958170971,NULL,1598089015,'1',NULL,0,'','0'),
(5285,NULL,'Балабух Олена',NULL,'2020-08-10','gGAB42Szcpk7dGyIhFizZg==',380977831622,NULL,1667314638,'1',26804,0,'','0'),
(5286,NULL,'Лопушняк Галя ',NULL,'2020-08-10',NULL,380681521446,NULL,1252728605,'1',NULL,2,'','0'),
(5287,NULL,'монастирська галина',NULL,'2020-08-11',NULL,380988119231,NULL,2123488281,'1',NULL,0,'','0'),
(5288,NULL,'Маньовська Наталя',NULL,'2020-08-11','nxoEL6gEuQvZsrK/4CGYIw==',380961314245,NULL,1123378158,'1',57639,0,'','0'),
(5289,NULL,'любера івана',NULL,'2020-08-11',NULL,380974115294,NULL,2145934666,'1',NULL,0,'','0'),
(5290,NULL,'лабендовіч тетяна',NULL,'2020-08-11',NULL,380966929943,NULL,1708390040,'1',NULL,0,'','0'),
(5291,NULL,'Окіпна Олена',NULL,'2020-08-12',NULL,380961905959,NULL,1447946625,'1',NULL,0,'','0'),
(5292,NULL,'Карпінська Ірина',NULL,'2020-08-12',NULL,380678524880,NULL,1758511944,'1',NULL,0,'','0'),
(5293,NULL,'Казьмірів Світлана',NULL,'2020-08-13',NULL,380969680874,NULL,1825912896,'1',NULL,0,'','0'),
(5294,NULL,'котова леся',NULL,'2020-08-13',NULL,380685121081,NULL,1379884992,'1',NULL,0,'','0'),
(5295,NULL,'Галабіцька Іванка',NULL,'2020-08-13',NULL,380677435383,NULL,1798521809,'1',NULL,0,'','0'),
(5296,NULL,'мельник надія',NULL,'2020-08-13',NULL,380980937933,NULL,1831360060,'1',NULL,0,'','0'),
(5297,NULL,'Лекар Надія',NULL,'2020-08-13',NULL,380987783926,NULL,1325854982,'1',NULL,0,'','0'),
(5298,NULL,'гук лариса',NULL,'2020-08-13',NULL,380975800618,NULL,2143547276,'1',NULL,0,'','0'),
(5299,NULL,'Яблонська Ольга',NULL,'2020-08-13',NULL,380662978261,NULL,1931955432,'1',NULL,0,'','0'),
(5300,NULL,'сопотницька маряна іванівна',NULL,'2020-08-13',NULL,380673862317,NULL,2031103574,'1',NULL,1,'','0'),
(5301,NULL,'навроцька катерина',NULL,'2020-08-14',NULL,380684631489,NULL,1990318839,'1',NULL,0,'','0'),
(5302,NULL,'коваль галина',NULL,'2020-08-14',NULL,380979323210,NULL,1912973039,'1',NULL,0,'','0'),
(5303,NULL,'безпалько наталія',NULL,'2020-08-15',NULL,380983034042,NULL,2070690292,'1',NULL,0,'','0'),
(5304,NULL,'Смоляк Маряна',NULL,'2020-08-15',NULL,380965612663,NULL,1209932780,'1',NULL,0,'','0'),
(5305,NULL,'Юрків Родіка',NULL,'2020-08-15',NULL,380987702844,NULL,1360790756,'1',NULL,0,'','0'),
(5306,NULL,'кейван ліля',NULL,'2020-08-15',NULL,380980823909,NULL,1305363239,'1',NULL,0,'','0'),
(5307,NULL,'Міщенко валерія',NULL,'2020-08-15',NULL,380686637882,NULL,2112911226,'1',NULL,0,'','0'),
(5308,NULL,'Ткач Леся ',NULL,'2020-08-16',NULL,380668742692,NULL,1841382058,'1',NULL,0,'','0'),
(5309,NULL,'сеник катерина',NULL,'2020-08-17',NULL,380967865443,NULL,1273064358,'1',NULL,0,'','0'),
(5310,NULL,'марчишин оксана',NULL,'2020-08-17',NULL,380978736540,NULL,1923041240,'1',NULL,1,'','0'),
(5311,NULL,'Грай Галина',NULL,'2020-08-17',NULL,380987140126,NULL,1877913129,'1',NULL,0,'','0'),
(5312,NULL,'шумило світлана',NULL,'2020-08-17',NULL,380501695264,NULL,1324202642,'1',NULL,0,'','0'),
(5313,NULL,'ладан марія',NULL,'2020-08-17',NULL,380680409633,NULL,1723489071,'1',NULL,0,'','0'),
(5314,NULL,'Вакула Наталя',NULL,'2020-08-17',NULL,380983285355,NULL,1993795358,'1',NULL,0,'','0'),
(5315,NULL,'Галат Наталя',NULL,'2020-08-17',NULL,380967828056,NULL,1929444230,'1',NULL,0,'','0'),
(5316,NULL,'Когут Надія',NULL,'2020-08-17',NULL,380671160703,NULL,1307633300,'1',NULL,0,'','0'),
(5317,NULL,'Дозоренко Івана',NULL,'2020-08-17',NULL,380672989283,NULL,1371992035,'1',NULL,0,'','0'),
(5318,NULL,'Мазепа Наталія ',NULL,'2020-08-17',NULL,380953457081,NULL,1261314498,'1',NULL,0,'','0'),
(5319,NULL,'Танасюк Надя ',NULL,'2020-08-17',NULL,380686218377,NULL,1269811795,'1',NULL,0,'','0'),
(5320,NULL,'Голець леся',NULL,NULL,'mIFXDBsfGCSAklNAWXDJ5A==',380961908761,NULL,1565424583,'1',NULL,0,'','0'),
(5321,NULL,'білас галина',NULL,'2020-08-18',NULL,380970632327,NULL,1576868929,'1',NULL,0,'','0'),
(5322,NULL,'Стасюк Оксана',NULL,'2020-08-18',NULL,380980028050,NULL,1673492700,'1',NULL,0,'','0'),
(5323,NULL,'Кишкан Надія',NULL,'2020-08-18',NULL,380987523027,NULL,1283386848,'1',NULL,0,'','0'),
(5324,NULL,'Нідеркаль Оксана',NULL,'2020-08-19',NULL,380969296220,NULL,1132619076,'1',NULL,2,'','0'),
(5325,NULL,'осадча выка',NULL,'2020-08-19',NULL,380688359796,NULL,1797046822,'1',NULL,0,'','0'),
(5326,NULL,'Кралько Оля ',NULL,'2020-08-19',NULL,380980826294,NULL,1948450751,'1',NULL,0,'','0'),
(5327,NULL,'Осипян Аліна ',NULL,'2020-08-19',NULL,380969733448,NULL,1348528658,'1',NULL,0,'','0'),
(5328,NULL,'Кушик Ірина ',NULL,'2020-08-19',NULL,380984489011,NULL,1648099830,'1',NULL,0,'','0'),
(5329,NULL,'бігусяк марія',NULL,'2020-08-20',NULL,380975390083,NULL,1300199188,'1',NULL,0,'','0'),
(5330,NULL,'Двикалюк Домініка',NULL,'2020-08-20',NULL,380679052744,NULL,1222043128,'1',NULL,1,'','0'),
(5331,NULL,'Кардинал Клавдія',NULL,'2020-08-20',NULL,380963231356,NULL,1327034322,'1',NULL,1,'','0'),
(5332,NULL,'поліщук діана',NULL,'2020-08-20','unM53jMLOK9zTj7+pUsMzA==',380501730420,NULL,2039994841,'1',NULL,0,'','0'),
(5333,NULL,'Василевська Альона ',NULL,'2020-08-20',NULL,380969854671,NULL,1691873071,'1',NULL,0,'','0'),
(5334,NULL,'Хованець Любомира',NULL,'2020-08-21',NULL,380681162573,NULL,2101724188,'1',NULL,6,'','0'),
(5335,NULL,'Решетнік Наталя',NULL,'2020-08-21',NULL,380950132937,NULL,1868922163,'1',NULL,0,'','0'),
(5336,NULL,'Василькевич оксана',NULL,'2020-08-21',NULL,380682420660,NULL,1175104193,'1',NULL,0,'','0'),
(5337,NULL,'Осадчук Наталя ',NULL,'2020-08-21',NULL,380975579984,NULL,1835550000,'1',NULL,0,'','0'),
(5338,NULL,'Осьмак Тетяна',NULL,'2020-08-21',NULL,380989244075,NULL,1277976548,'1',NULL,0,'','0'),
(5339,NULL,'Клапків Оксана',NULL,'2020-08-21',NULL,380961018060,NULL,2126925601,'1',NULL,0,'','0'),
(5340,NULL,'Готвальд Галина',NULL,'2020-08-21',NULL,380680245510,NULL,1594794980,'1',NULL,0,'','0'),
(5341,NULL,'николин оксана',NULL,'2020-08-21',NULL,380687870863,NULL,1616150410,'1',NULL,2,'','0'),
(5342,NULL,'Багрій Оксана',NULL,'2020-08-22',NULL,380973364479,NULL,1387291805,'1',49729,0,'','0'),
(5343,NULL,'Бочко Галина',NULL,'2020-08-22',NULL,380989107031,NULL,1456627498,'1',NULL,0,'','0'),
(5344,NULL,'Крамарчук Юлія ',NULL,'2020-08-22',NULL,380672015192,NULL,1759666189,'1',62443,0,'','0'),
(5345,NULL,'Битковська Ольга',NULL,'2020-08-24',NULL,380957041792,NULL,1350296818,'1',NULL,0,'','0'),
(5346,NULL,'романчук зоряна',NULL,'2020-08-24',NULL,380981146107,NULL,1559569302,'1',NULL,0,'','0'),
(5347,NULL,'лещишин вероніка',NULL,'2020-08-24',NULL,380969774930,NULL,1692026372,'1',NULL,0,'','0'),
(5348,NULL,'Козачок Ірина',NULL,'2020-08-24',NULL,380984005081,NULL,2049985089,'1',NULL,0,'','0'),
(5349,NULL,'шішка ірина',NULL,'2020-08-24',NULL,380971212061,NULL,1637338929,'1',NULL,0,'','0'),
(5350,NULL,'Валечна Марія Володимірівна',NULL,'2020-08-24',NULL,380976415707,NULL,1317248423,'1',NULL,0,'','0'),
(5351,NULL,'Глуховська Христина ',NULL,'2020-08-24',NULL,380966976704,NULL,1615903673,'1',NULL,0,'','0'),
(5352,NULL,'Чорній Ірина',NULL,'2020-08-25',NULL,380660446317,NULL,1354946209,'1',NULL,0,'','0'),
(5353,NULL,'Дячок Світлана',NULL,'2020-08-25',NULL,380684296477,NULL,1901464549,'1',NULL,0,'','0'),
(5354,NULL,'гевко галя',NULL,'2020-08-25',NULL,380977285512,NULL,1532600398,'1',NULL,0,'','0'),
(5355,NULL,'конет Гана',NULL,NULL,NULL,NULL,NULL,1208667909,'1',NULL,0,'','0'),
(5356,NULL,'Міхалкевич світлана',NULL,'2020-08-25',NULL,380966531948,NULL,1628449291,'1',NULL,6,'','0'),
(5357,NULL,'корнак таня',NULL,'2020-08-25',NULL,380683044159,NULL,1369259957,'1',NULL,0,'','0'),
(5358,NULL,'українець галина',NULL,'2020-08-25',NULL,380680864397,NULL,1767992911,'1',NULL,0,'','0'),
(5359,NULL,'Кривчук Марта',NULL,'2020-08-25',NULL,380680915556,NULL,1992662897,'1',NULL,0,'','0'),
(5360,NULL,'посіда іра',NULL,'2020-08-26',NULL,380993250686,NULL,1369430770,'1',NULL,0,'','0'),
(5361,NULL,'атаманець наталія',NULL,'2020-08-26',NULL,380977761010,NULL,2032712538,'1',NULL,0,'','0'),
(5362,NULL,'Павлюк Орися',NULL,'2020-08-26',NULL,380970005852,NULL,1552986080,'1',NULL,0,'','0'),
(5363,NULL,'Малуна Таня',NULL,'2020-08-26',NULL,380980218989,NULL,1487484976,'1',NULL,0,'','0'),
(5364,NULL,'попадюк марія',NULL,'2020-08-26',NULL,380978549979,NULL,1255367063,'1',NULL,0,'','0'),
(5365,NULL,'куруч ларіса',NULL,'2020-08-26',NULL,380979181205,NULL,1682782789,'1',NULL,0,'','0'),
(5366,NULL,'навлоцька ліля',NULL,'2020-08-26',NULL,380932129277,NULL,1351314054,'1',NULL,1,'','0'),
(5367,NULL,'ландяк оксана',NULL,'2020-08-27',NULL,380978385424,NULL,1121705990,'1',NULL,0,'','0'),
(5368,NULL,'пилипів ана',NULL,'2020-08-27',NULL,380987324621,NULL,1397450199,'1',NULL,0,'','0'),
(5369,NULL,'Винничук  христина',NULL,NULL,NULL,380684213864,NULL,1882047280,'1',11291,0,'','0'),
(5370,NULL,'свідніцька надія',NULL,'2020-08-28',NULL,380978846482,NULL,1745507063,'1',34914,0,'','0'),
(5371,NULL,'ореховська олена',NULL,'2020-08-28',NULL,380673502618,NULL,1471001686,'1',NULL,0,'','0'),
(5372,NULL,'калакайло анастасія',NULL,'2020-08-28',NULL,380687072249,NULL,1445100426,'1',NULL,0,'','0'),
(5373,NULL,'сенчук люба',NULL,'2020-08-28',NULL,380678283132,NULL,1709158562,'1',NULL,0,'','0'),
(5374,NULL,'Пошріщук Оля ',NULL,'2020-08-29',NULL,380966753850,NULL,1720756073,'1',NULL,0,'','0'),
(5375,NULL,'колос уляна',NULL,'2020-08-29','ZcF6XDa+aM5i01EjwJ0YKA==',380680463254,NULL,1315047636,'1',NULL,1,'','0'),
(5376,NULL,'мельник аліна',NULL,'2020-08-29',NULL,380977037665,NULL,1634064225,'1',NULL,0,'','0'),
(5377,NULL,'казьмір наталя',NULL,'2020-08-29','rES8JHqqEiUFwICR8p707Q==',380680176179,NULL,1322947297,'1',38348,0,'','0'),
(5378,NULL,'Бойко маша',NULL,'2020-08-29',NULL,380664488412,NULL,2092871544,'1',NULL,0,'','0'),
(5379,NULL,'пелипець наталя',NULL,'2020-08-29',NULL,380971610547,NULL,1338669079,'1',NULL,0,'','0'),
(5380,NULL,'слободян катерина',NULL,'2020-08-29',NULL,380688829262,NULL,1898321047,'1',NULL,0,'','0'),
(5381,NULL,'чарнош оля',NULL,'2020-08-31',NULL,380968981535,NULL,1284285721,'1',NULL,0,'','0'),
(5382,NULL,'водавчук оксана',NULL,'2020-08-31','QjOth1LRm7jX+5UDjXtq+g==',380979198701,NULL,2009723402,'1',51878,0,'','0'),
(5383,NULL,'Хворост Аліна ',NULL,'2020-08-31',NULL,380635591951,NULL,1346474759,'1',NULL,0,'','0'),
(5384,NULL,'Губіш Галина ',NULL,'2020-09-01',NULL,380931697001,NULL,1768198485,'1',NULL,0,'','0'),
(5385,NULL,'Южда Олеся ',NULL,'2020-09-01',NULL,380991186096,NULL,1153083608,'1',61284,0,'','0'),
(5386,NULL,'Слободян марина',NULL,'2020-09-02',NULL,380953425447,NULL,2135497400,'1',NULL,0,'','0'),
(5387,NULL,'наконечна катерина',NULL,'2020-09-02',NULL,380985488355,NULL,1640333166,'1',NULL,0,'','0'),
(5388,NULL,'дідик руслана',NULL,'2020-09-03',NULL,380978610561,NULL,1462059977,'1',NULL,0,'','0'),
(5389,NULL,'чихарівська ларіса',NULL,'2020-09-03',NULL,380976974281,NULL,2085686457,'1',NULL,1,'','0'),
(5390,NULL,'Франків Іван',NULL,'2020-09-03',NULL,380687724944,NULL,1525568043,'1',NULL,0,'','0'),
(5391,NULL,'лукянець галя',NULL,'2020-09-03',NULL,380969570858,NULL,1362658304,'1',NULL,0,'','0'),
(5392,NULL,'галанчак іна',NULL,'2020-09-04',NULL,380953183240,NULL,2087819127,'1',NULL,0,'','0'),
(5393,NULL,'чернявська оксана',NULL,'2020-09-04',NULL,380950132742,NULL,1307074052,'1',NULL,0,'','0'),
(5394,NULL,'Осьмак галя ',NULL,'2020-09-04','iGy+rwxM0D2KjbYsl+Oabg==',380679351101,NULL,2015998410,'1',56759,0,'','0'),
(5395,NULL,'бойчук тетяна',NULL,'2020-09-05','uJtPg64EMvHLnlIZVdVXQQ==',380689829176,NULL,1942541382,'1',NULL,0,'','0'),
(5396,NULL,'войтович вікторія',NULL,'2020-09-07',NULL,380966976152,NULL,1802549397,'1',NULL,0,'','0'),
(5397,NULL,'туткалюк юля',NULL,'2020-09-07',NULL,380961944578,NULL,1959467057,'1',23053,0,'','0'),
(5398,NULL,'матвійчук христина',NULL,'2020-09-07',NULL,380964368695,NULL,1802661831,'1',NULL,0,'','0'),
(5399,NULL,'семенюк світлана',NULL,'2020-09-07',NULL,380964454508,NULL,1608358062,'1',NULL,0,'','0'),
(5400,NULL,'алєксєєвва єлизавета',NULL,'2020-09-07',NULL,380978590020,NULL,2129142994,'1',32009,0,'','0'),
(5401,NULL,'скрипка галина',NULL,'2020-09-07',NULL,380687701531,NULL,1123844453,'1',NULL,0,'','0'),
(5402,NULL,'похила руслана',NULL,'2020-09-08',NULL,380671220025,NULL,1982474321,'1',NULL,0,'','0'),
(5403,NULL,'денисюк галя',NULL,'2020-09-08',NULL,380966181582,NULL,1203776578,'1',NULL,0,'','0'),
(5404,NULL,'батиська оксана',NULL,'2020-09-08',NULL,380983121396,NULL,1927726991,'1',NULL,0,'','0'),
(5405,NULL,'хмелик ліля',NULL,'2020-09-08',NULL,380975830098,NULL,1389703408,'1',46380,0,'','0'),
(5406,NULL,'Ружицька марія',NULL,'2020-09-08',NULL,380961490201,NULL,1418691563,'1',12025,0,'','0'),
(5407,NULL,'Слободецька христина',NULL,'2020-09-08','4lTFHckllEaLn4h2kIzmrg==',380974082450,NULL,1518375455,'1',49035,0,'','0'),
(5408,NULL,'дутковська мирослава',NULL,'2020-09-09',NULL,380983082246,NULL,1744198921,'1',NULL,0,'','0'),
(5409,NULL,'дикун',NULL,'2020-09-09',NULL,380665015248,NULL,1737917908,'1',NULL,0,'','0'),
(5410,NULL,'балабух марія',NULL,'2020-09-10',NULL,380967252453,NULL,2076633664,'1',54107,0,'','0'),
(5411,NULL,'Южда оксана',NULL,'2020-09-10',NULL,380663085914,NULL,1467126424,'1',NULL,0,'','0'),
(5412,NULL,'стадник аня',NULL,'2020-09-10',NULL,380684231655,NULL,1568644630,'1',NULL,0,'','0'),
(5413,NULL,'зіник оля',NULL,'2020-09-10',NULL,380981091062,NULL,1267037168,'1',NULL,0,'','0'),
(5414,NULL,'Гвоздецька Світлана',NULL,'2020-09-10',NULL,380988029260,NULL,1948261451,'1',NULL,0,'','0'),
(5415,NULL,'петрик вадим',NULL,'2020-09-10',NULL,380977163738,NULL,1201569831,'1',NULL,0,'','0'),
(5416,NULL,'безпалько тетяна',NULL,'2020-09-10',NULL,380986451174,NULL,1408804402,'1',NULL,0,'','0'),
(5417,NULL,'дідюк анжела',NULL,'2020-09-11',NULL,380963095969,NULL,1207040745,'1',NULL,0,'','0'),
(5418,NULL,'козак оксана',NULL,'2020-09-11',NULL,380966775749,NULL,1219023374,'1',43853,0,'','0'),
(5419,NULL,'андрусик надя',NULL,'2020-09-12',NULL,380963194627,NULL,1615550119,'1',NULL,0,'','0'),
(5420,NULL,'луцька юля',NULL,'2020-09-14',NULL,380964913079,NULL,2043417134,'1',NULL,0,'','0'),
(5421,NULL,'косінська наталя',NULL,'2020-09-14',NULL,380966008185,NULL,2096885081,'1',NULL,0,'','0'),
(5422,NULL,'зіник оля',NULL,'2020-09-14',NULL,380981091962,NULL,2017836528,'1',NULL,0,'','0'),
(5423,NULL,'Савчук Настя ',NULL,'2020-09-14',NULL,380980863403,NULL,1688021507,'1',NULL,0,'','0'),
(5424,NULL,'Мороз надія',NULL,'2020-09-14',NULL,380988145728,NULL,1167371807,'1',NULL,0,'','0'),
(5425,NULL,'Цимбаляк Юлія',NULL,'2020-09-14',NULL,380686261217,NULL,1368664263,'1',NULL,0,'','0'),
(5426,NULL,'Цапяк Марія',NULL,'2020-09-14',NULL,380678953142,NULL,1806323956,'1',NULL,0,'','0'),
(5427,NULL,'Цапяк Вікторія',NULL,'2020-09-14',NULL,380977764868,NULL,2082052626,'1',NULL,0,'','0'),
(5428,NULL,'Старик Ольга',NULL,NULL,NULL,380506023722,NULL,1863204930,'1',NULL,0,'','0'),
(5429,NULL,'возьна марія ',NULL,'2020-09-15',NULL,380686064228,NULL,1268531125,'1',44078,0,'','0'),
(5430,NULL,'стратій ',NULL,'2020-09-15',NULL,380968591837,NULL,2124956003,'1',NULL,0,'','0'),
(5431,NULL,'Хомяк ліля',NULL,'2020-09-15',NULL,380987370997,NULL,1562226374,'1',NULL,0,'','0'),
(5432,NULL,'Колісник Христина ',NULL,'2020-09-15',NULL,380989171387,NULL,1966136208,'1',NULL,0,'','0'),
(5433,NULL,'губяк яна',NULL,'2020-09-15',NULL,380966309331,NULL,1617512631,'1',NULL,0,'','0'),
(5434,NULL,'червінська марта',NULL,'2020-09-15',NULL,380969962777,NULL,1416354190,'1',NULL,0,'','0'),
(5435,NULL,'польова оксана',NULL,'2020-09-16',NULL,380986669125,NULL,1125617639,'1',NULL,0,'','0'),
(5436,NULL,'гриненко оля',NULL,'2020-09-16',NULL,380684244685,NULL,1247541307,'1',NULL,0,'','0'),
(5437,NULL,'Ярема МАша',NULL,'2020-09-16',NULL,380974150939,NULL,2072532082,'1',NULL,0,'','0'),
(5438,NULL,'голобінська люба',NULL,'2020-09-17','5Bu7o6mzOVnwN+MNoxF3Cw==',380672663290,NULL,2130610938,'1',NULL,0,'','0'),
(5439,NULL,'Навізівська марія',NULL,'2020-09-17',NULL,380685417256,NULL,1552826859,'1',NULL,0,'','0'),
(5440,NULL,'березюк наталя',NULL,'2020-09-17',NULL,380963447386,NULL,1636141282,'1',NULL,0,'','0'),
(5441,NULL,'Систун Леся',NULL,'2020-09-18',NULL,380685196198,NULL,1518308610,'1',NULL,1,'','0'),
(5442,NULL,'козловська філомена',NULL,'2020-09-18',NULL,380983036858,NULL,1565635592,'1',NULL,0,'','0'),
(5443,NULL,'Шмулик Ліля',NULL,'2020-09-19',NULL,380684195962,NULL,1377531413,'1',NULL,0,'','0'),
(5444,NULL,'Грошко Оля',NULL,'2020-09-20',NULL,380681365679,NULL,1653939901,'1',NULL,0,'','0'),
(5445,NULL,'Гуцал Оля ',NULL,'2020-09-21',NULL,380631614835,NULL,1888015406,'1',NULL,0,'','0'),
(5446,NULL,'Хруставка Руслана',NULL,'2020-09-22',NULL,380955619986,NULL,1367054001,'1',NULL,0,'','0'),
(5447,NULL,'Журавіньська Жанна',NULL,'2020-09-22',NULL,380982903877,NULL,1981912496,'1',NULL,0,'','0'),
(5448,NULL,'Малихіна Маряна',NULL,'2020-09-22',NULL,380976838606,NULL,1727031720,'1',22622,0,'','0'),
(5449,NULL,'Сосновська Христина',NULL,'2020-09-22',NULL,380688180823,NULL,1940618525,'1',NULL,0,'','0'),
(5450,NULL,'Гаджала ольга',NULL,'2020-09-22',NULL,380684297422,NULL,1605420193,'1',NULL,0,'','0'),
(5451,NULL,'гаджала тетяна',NULL,'2020-09-23',NULL,380963921564,NULL,1864628543,'1',NULL,0,'','0'),
(5452,NULL,'Строцень Людмила',NULL,'2020-09-23',NULL,380686495963,NULL,1978506662,'1',NULL,0,'','0'),
(5453,NULL,'Деревянко Івана',NULL,'2020-09-23',NULL,380982405104,NULL,1384912015,'1',26789,0,'','0'),
(5454,NULL,'Кош Марія ',NULL,'2020-09-23',NULL,380680821372,NULL,1990250876,'1',NULL,1,'','0'),
(5455,NULL,'Люба Таня',NULL,'2020-09-24',NULL,380507232212,NULL,1918994418,'1',NULL,0,'','0'),
(5456,NULL,'Хандій Галина ',NULL,'2020-09-24',NULL,380965612172,NULL,2059833184,'1',NULL,0,'','0'),
(5457,NULL,'Наконечна Таня',NULL,'2020-09-26',NULL,380993451474,NULL,1934718942,'1',NULL,0,'','0'),
(5458,NULL,'Добощук Настя',NULL,'2020-09-28',NULL,380986173430,NULL,1308349432,'1',NULL,0,'','0'),
(5459,NULL,'Багрій Таня',NULL,'2020-09-28',NULL,380972947447,NULL,1847255761,'1',NULL,0,'','0'),
(5460,NULL,'Кукула каріна',NULL,'2020-09-28',NULL,380687870490,NULL,2074500800,'1',NULL,0,'','0'),
(5461,NULL,'Стефанець Олеся',NULL,'2020-09-28',NULL,380963656218,NULL,1833884700,'1',NULL,0,'','0'),
(5462,NULL,'Сиротюк ілона',NULL,'2020-09-28',NULL,380967881820,NULL,1395543937,'1',NULL,0,'','0'),
(5463,NULL,'Процькіа Наталя ',NULL,'2020-09-29',NULL,380978738176,NULL,1947441761,'1',17657,0,'','0'),
(5464,NULL,'Сизоненко Сюзана',NULL,'2020-09-29',NULL,380968304907,NULL,1394072052,'1',NULL,0,'','0'),
(5465,NULL,'Зозуляк Олеся',NULL,'2020-09-29',NULL,380985530963,NULL,2025162862,'1',NULL,0,'','0'),
(5466,NULL,'Івануць Оксана ',NULL,'2020-09-29',NULL,380984280801,NULL,1964648049,'1',NULL,0,'','0'),
(5467,NULL,'Андрусяк Надія',NULL,'2020-09-30',NULL,380685826930,NULL,1779614079,'1',NULL,0,'','0'),
(5468,NULL,'Рибак Марія',NULL,'2020-09-30',NULL,380972289265,NULL,1646795512,'1',NULL,0,'','0'),
(5469,NULL,'Базів Наталя ',NULL,'2020-09-30',NULL,380983433383,NULL,1403194872,'1',NULL,0,'','0'),
(5470,NULL,'Плішка Наталя',NULL,'2020-10-01','kUEjs50eqqfGXzyCZXkc6A==',380981291881,NULL,1566455235,'1',NULL,0,'','0'),
(5471,NULL,'Сапіщук надя',NULL,'2020-10-01',NULL,380969852605,NULL,1969133981,'1',NULL,0,'','0'),
(5472,NULL,'Миськів Юля',NULL,'2020-10-02',NULL,380966644566,NULL,1896189768,'1',NULL,0,'','0'),
(5473,NULL,'Пісяк Марія',NULL,'2020-10-02',NULL,380962077927,NULL,1729836314,'1',NULL,0,'','0'),
(5474,NULL,'Клачко Віуторія',NULL,'2020-10-03',NULL,380675957274,NULL,1715725897,'1',NULL,0,'','0'),
(5475,NULL,'Царук наиаля',NULL,'2020-10-03',NULL,380978507297,NULL,2128217798,'1',NULL,0,'','0'),
(5476,NULL,'Гевко Таня',NULL,'2020-10-05',NULL,380960279985,NULL,2139691333,'1',21132,0,'','0'),
(5477,NULL,'Окіпна Софія ',NULL,'2020-10-05',NULL,380683377514,NULL,2051250412,'1',13229,0,'','0'),
(5478,NULL,'Било Людмила',NULL,'2020-10-06',NULL,380973848678,NULL,1445794073,'1',NULL,0,'','0'),
(5479,NULL,'Величко Аліна',NULL,'2020-10-06',NULL,380669847756,NULL,1310839742,'1',NULL,0,'','0'),
(5480,NULL,'Ковач Ростислав',NULL,'2020-10-06',NULL,380970369661,NULL,1929567795,'1',NULL,0,'','0'),
(5481,NULL,'Юхим Ірина',NULL,'2020-10-06',NULL,380675288860,NULL,1820791498,'1',NULL,1,'','0'),
(5482,NULL,'Семерез Іра',NULL,'2020-10-06',NULL,380688741217,NULL,1839209717,'1',NULL,0,'','0'),
(5483,NULL,'Грубенюк Карина',NULL,'2020-10-06',NULL,380986595595,NULL,1630029125,'1',NULL,0,'','0'),
(5484,NULL,'Білик Юля',NULL,'2020-10-07',NULL,380964123407,NULL,1762643063,'1',NULL,0,'','0'),
(5485,NULL,'Юречко Оксана',NULL,'2020-10-07',NULL,380963927350,NULL,1564458458,'1',NULL,0,'','0'),
(5486,NULL,'Бамбурак Людмила',NULL,'2020-10-07',NULL,380983105247,NULL,1453559343,'1',NULL,0,'','0'),
(5487,NULL,'Дробенко Аліна',NULL,'2020-10-07',NULL,380961333907,NULL,1976642593,'1',NULL,0,'','0'),
(5488,NULL,'Назарок Оксана',NULL,'2020-10-07',NULL,380979735793,NULL,2117286001,'1',NULL,0,'','0'),
(5489,NULL,'Рогатинська Таня',NULL,'2020-10-07',NULL,380967918141,NULL,1364420637,'1',NULL,0,'','0'),
(5490,NULL,'Вередюк Таня',NULL,'2020-10-07',NULL,380672807592,NULL,1272268028,'1',NULL,0,'','0'),
(5491,NULL,'Босяк іра',NULL,'2020-10-07',NULL,380984626061,NULL,1144071150,'1',NULL,0,'','0'),
(5492,NULL,'Чубата Галина',NULL,'2020-10-07','y2cWIjwiEI8XFmBB/xFc+Q==',380961895966,NULL,1916863050,'1',11979,0,'','0'),
(5493,NULL,'Процишин Марія',NULL,'2020-10-08',NULL,380976071985,NULL,2146914755,'1',NULL,0,'','0'),
(5494,NULL,'Степанова Таня',NULL,'2020-10-08',NULL,380977358254,NULL,2053674903,'1',NULL,0,'','0'),
(5495,NULL,'Качмар Люба',NULL,'2020-10-08',NULL,380681683608,NULL,1943994136,'1',NULL,0,'','0'),
(5496,NULL,'Данчишин Іра',NULL,'2020-10-08',NULL,380964495955,NULL,1277867012,'1',16994,0,'','0'),
(5497,NULL,'кухар марія',NULL,'2020-10-09',NULL,380986792280,NULL,1179066774,'1',NULL,0,'','0'),
(5498,NULL,'Наконечна Віка',NULL,'2020-10-10',NULL,380980863833,NULL,1764914638,'1',NULL,0,'','0'),
(5499,NULL,'Савіцька Оксана',NULL,'2020-10-10',NULL,380988228350,NULL,1687263650,'1',NULL,0,'','0'),
(5500,NULL,'Кирилишин Оксана',NULL,'2020-10-12',NULL,380968121831,NULL,1716230050,'1',NULL,1,'','0');

INSERT INTO `kontragentu` VALUES 
(5501,NULL,'Грушицький Анатолій',NULL,'2020-10-12',NULL,380676021453,NULL,1276479904,'1',NULL,0,'','0'),
(5502,NULL,'Волосінко Леся',NULL,'2020-10-12',NULL,380967845609,NULL,1788672658,'1',NULL,0,'','0'),
(5503,NULL,'Сенько Марія',NULL,'2020-10-12',NULL,380980945812,NULL,1739402297,'1',16669,0,'','0'),
(5504,NULL,'Ядчишин Діана',NULL,'2020-10-12',NULL,380678379844,NULL,1187938075,'1',61233,0,'','0'),
(5505,NULL,'Галушка Вікторія',NULL,'2020-10-13',NULL,380981109840,NULL,1112062916,'1',NULL,0,'','0'),
(5506,NULL,'Дашевська Віра',NULL,'2020-10-13',NULL,380981298503,NULL,1319785034,'1',NULL,0,'','0'),
(5507,NULL,'Пастух Марія ',NULL,'2020-10-13',NULL,380969187806,NULL,1381559887,'1',NULL,0,'','0'),
(5508,NULL,'Мудра Оля',NULL,'2020-10-13',NULL,380682348692,NULL,1997686115,'1',NULL,0,'','0'),
(5509,NULL,'Ільків Анастасія',NULL,'2020-10-13',NULL,380970488865,NULL,1130930827,'1',NULL,0,'','0'),
(5510,NULL,'Триш Наталія ',NULL,'2020-10-13',NULL,380961593647,NULL,1780182644,'1',NULL,0,'','0'),
(5511,NULL,'Барчук Юля',NULL,'2020-10-15',NULL,380980794462,NULL,1413086033,'1',NULL,0,'','0'),
(5512,NULL,'Атаманчук Уляна ',NULL,'2020-10-15',NULL,380675235844,NULL,1880799536,'1',NULL,0,'','0'),
(5513,NULL,'Слюсаренко Ліля',NULL,'2020-10-16',NULL,380979996737,NULL,1316997712,'1',NULL,0,'','0'),
(5514,NULL,'Юркевич Антоніна',NULL,'2020-10-16',NULL,380976250377,NULL,2013115064,'1',NULL,0,'','0'),
(5515,NULL,'Тарасенко Галина',NULL,'2020-10-17',NULL,380997658774,NULL,1547044720,'1',NULL,0,'','0'),
(5516,NULL,'Вістовська Галина',NULL,'2020-10-19',NULL,380969877080,NULL,1616256210,'1',NULL,0,'','0'),
(5517,NULL,'Андрейчук Андріана ',NULL,'2020-10-20',NULL,380673468172,NULL,1316094753,'1',NULL,0,'','0'),
(5518,NULL,'Манорик Марія',NULL,'2020-10-20',NULL,380988286129,NULL,2002651729,'1',23672,1,'','0'),
(5519,NULL,'Миронюк Тетяна ',NULL,'2020-10-20',NULL,380979857529,NULL,1614095387,'1',48834,0,'','0'),
(5520,NULL,'Вархол Вероніка',NULL,'2020-10-20',NULL,380965216609,NULL,1980571216,'1',NULL,0,'','0'),
(5521,NULL,'Тютюник Галина',NULL,'2020-10-21',NULL,380986307668,NULL,2116314576,'1',NULL,0,'','0'),
(5522,NULL,'гайдук марія',NULL,'2020-10-21',NULL,380977022421,NULL,1514977239,'1',NULL,1,'','0'),
(5523,NULL,'Білик Тамара',NULL,'2020-10-21',NULL,380671004098,NULL,1133804597,'1',NULL,0,'','0'),
(5524,NULL,'Білик Марія ',NULL,'2020-10-21',NULL,380689691782,NULL,1333149519,'1',25602,0,'','0'),
(5525,NULL,'Железняк Наталя',NULL,'2020-10-22',NULL,380961623407,NULL,2114021787,'1',NULL,0,'','0'),
(5526,NULL,'приймаченко вікторія',NULL,'2020-10-22',NULL,380981798967,NULL,1837854760,'1',NULL,0,'','0'),
(5527,NULL,'бугель наталія',NULL,'2020-10-22',NULL,380978042414,NULL,1680922515,'1',NULL,0,'','0'),
(5528,NULL,'Смаль Галина',NULL,'2020-10-23',NULL,380686636372,NULL,2129231138,'1',NULL,0,'','0'),
(5529,NULL,'Удуд Андріана',NULL,'2020-10-23',NULL,380986481501,NULL,1827039746,'1',46495,0,'','0'),
(5530,NULL,'Романенко Мадона',NULL,'2020-10-23',NULL,380937810153,NULL,2110018752,'1',NULL,0,'','0'),
(5531,NULL,'Роман Світлана',NULL,'2020-10-24','VuarAZKhpq+j5Ds8JUSOjQ==',380967952994,NULL,1870145899,'1',45577,0,'','0'),
(5532,NULL,'Луцик Анастасія ',NULL,'2020-10-25',NULL,380683267179,NULL,1770152676,'1',NULL,0,'','0'),
(5533,NULL,'Дюк Світлана',NULL,'2020-10-26',NULL,380683577964,NULL,1497255179,'1',NULL,0,'','0'),
(5534,NULL,'Лазарська Оксана',NULL,'2020-10-26',NULL,380978540792,NULL,2032477052,'1',NULL,0,'','0'),
(5535,NULL,'Юрків Віра',NULL,'2020-10-26',NULL,380971599731,NULL,2067577772,'1',NULL,0,'','0'),
(5536,NULL,'Сташинська Наталя ',NULL,'2020-10-26',NULL,380937113591,NULL,1702510327,'1',NULL,0,'','0'),
(5537,NULL,'Трач Юля',NULL,'2020-10-27',NULL,380684231665,NULL,1506373496,'1',11154,0,'','0'),
(5538,NULL,'Осадчук Соломія ',NULL,'2020-10-27','/bB5wd8RExJDcrnwWVlxIw==',380982575026,NULL,1810450889,'1',NULL,0,'','0'),
(5539,NULL,'Бойчук Оксана',NULL,'2020-10-28',NULL,380680753108,NULL,1314335235,'1',NULL,0,'','0'),
(5540,NULL,'Бабій Настя ',NULL,'2020-10-28',NULL,380936488763,NULL,1814588338,'1',NULL,0,'','0'),
(5541,NULL,'Домінська Леся',NULL,'2020-10-29','6Stnk3hd/sfWT2DkIWMz/A==',380687032640,NULL,1631395705,'1',59324,0,'','0'),
(5542,NULL,'Кулій Люда',NULL,'2020-10-29',NULL,380989387208,NULL,1915759352,'1',NULL,0,'','0'),
(5543,NULL,'Сойма Христина',NULL,'2020-10-29',NULL,380687677289,NULL,1574318444,'1',NULL,0,'','0'),
(5544,NULL,'Гайдук Емлія',NULL,'2020-10-31',NULL,380689130035,NULL,1466981758,'1',64594,0,'','0'),
(5545,NULL,'Стецюк Марія',NULL,'2020-10-31',NULL,380964318677,NULL,1305339579,'1',46542,7,'','0'),
(5546,NULL,'Атаманчук Тоня ',NULL,'2020-11-02',NULL,380958735776,NULL,1135082629,'1',NULL,0,'','0'),
(5547,NULL,'Суха Наталя',NULL,'2020-11-02',NULL,380969590846,NULL,1255828185,'1',NULL,0,'','0'),
(5548,NULL,'Кутрик Оксана',NULL,'2020-11-02',NULL,380689574340,NULL,1320888540,'1',NULL,0,'','0'),
(5549,NULL,'Чижик Ірина',NULL,'2020-11-03',NULL,380989442635,NULL,1275124731,'1',NULL,0,'','0'),
(5550,NULL,'Мальована Надія ',NULL,'2020-11-03','p6Y3jmts+qjuPOV4T+ASdg==',380971590977,NULL,1928791391,'1',56558,0,'','0'),
(5551,NULL,'Сойма Оксана',NULL,'2020-11-03',NULL,380987100286,NULL,1545532103,'1',NULL,0,'','0'),
(5552,NULL,'Доскоч Світлана',NULL,'2020-11-04',NULL,380971608498,NULL,1573362699,'1',NULL,0,'','0'),
(5553,NULL,'Рудик Марія',NULL,'2020-11-04',NULL,380686329178,NULL,1564929702,'1',NULL,0,'','0'),
(5554,NULL,'Витрикуш Василина',NULL,'2020-11-05',NULL,380680753858,NULL,1797330858,'1',NULL,2,'','0'),
(5555,NULL,'Барчук Оксана',NULL,'2020-11-06',NULL,380976685935,NULL,2115590969,'1',NULL,0,'','0'),
(5556,NULL,'Швед Христина',NULL,'2020-11-06',NULL,380685919953,NULL,1246836289,'1',NULL,0,'','0'),
(5557,NULL,'Кондратенкова Анастасія ',NULL,'2020-11-06',NULL,380992547579,NULL,1971581653,'1',NULL,0,'','0'),
(5558,NULL,'Гикава Люба',NULL,'2020-11-07',NULL,380976007495,NULL,1352740605,'1',NULL,0,'','0'),
(5559,NULL,'Дзьоник Людмила',NULL,'2020-11-09',NULL,380983593088,NULL,1950984955,'1',NULL,0,'','0'),
(5560,NULL,'Ревега Ірина',NULL,'2020-11-09','yvg+I0/xJSBJARNnAi7dHQ==',380961556022,NULL,1470062656,'1',NULL,1,'','0'),
(5561,NULL,'Кузик Діана',NULL,'2020-11-10',NULL,380686970250,NULL,1450550573,'1',NULL,0,'','0'),
(5562,NULL,'Гуменчук Таня',NULL,'2020-11-10',NULL,380668007094,NULL,1920975232,'1',NULL,0,'','0'),
(5563,NULL,'Драбик Марія ',NULL,'2020-11-10',NULL,380686958489,NULL,1959409170,'1',NULL,0,'','0'),
(5564,NULL,'Кучмій  Сніжана ',NULL,'2020-11-11',NULL,380966229177,NULL,1695879251,'1',NULL,0,'','0'),
(5565,NULL,'Коцюба Ольга ',NULL,'2020-11-11',NULL,380678446583,NULL,1626001357,'1',NULL,0,'','0'),
(5566,NULL,'Дмитрик Вікторія ',NULL,'2020-11-12',NULL,380978982103,NULL,1868084390,'1',NULL,0,'','0'),
(5567,NULL,'туркіць зоряна',NULL,'2020-11-12',NULL,380987057134,NULL,1984042743,'1',NULL,0,'','0'),
(5568,NULL,'Міщанчук Іра',NULL,'2020-11-12',NULL,380680496963,NULL,2082992679,'1',NULL,0,'','0'),
(5569,NULL,'Гриців Тетяна',NULL,'2020-11-12',NULL,380986173174,NULL,1416364294,'1',62668,0,'','0'),
(5570,NULL,'Дехтяренко Лільон',NULL,'2020-11-12','zngiIkA2SAFyVfIvvbPdoA==',380684767095,NULL,1416593857,'1',31320,0,'','0'),
(5571,NULL,'Кушнір Ліля',NULL,'2020-11-13',NULL,380980160678,NULL,1698669600,'1',NULL,0,'','0'),
(5572,NULL,'Кобзар Дзвіна',NULL,'2020-11-13',NULL,380683113788,NULL,1418090834,'1',NULL,0,'','0'),
(5573,NULL,'Сивак Маряна',NULL,'2020-11-14',NULL,380985054363,NULL,1765841248,'1',NULL,0,'','0'),
(5574,NULL,'Бабій Анастасія',NULL,'2020-11-14',NULL,380989465126,NULL,1190902434,'1',18285,0,'','0'),
(5575,NULL,'Ганусяк Михайло',NULL,'2020-11-14',NULL,380961313929,NULL,2124147893,'1',45796,0,'','0'),
(5576,NULL,'Родинюк Світлана',NULL,'2020-11-16',NULL,380968609035,NULL,1645567686,'1',NULL,0,'','0'),
(5577,NULL,'Шалева Оксана',NULL,'2020-11-16',NULL,380688177020,NULL,2072953992,'1',NULL,0,'','0'),
(5578,NULL,'Ануфрієва Ірина',NULL,'2020-11-16',NULL,380989062552,NULL,1393358410,'1',NULL,0,'','0'),
(5579,NULL,'Ковальчук Таня',NULL,'2020-11-16',NULL,380688422708,NULL,1468102056,'1',NULL,0,'','0'),
(5580,NULL,'Гаворчак Оксана',NULL,'2020-11-17',NULL,380662477585,NULL,1521733601,'1',NULL,0,'','0'),
(5581,NULL,'Лукіянець Ліля',NULL,'2020-11-17',NULL,380680171927,NULL,1635898907,'1',18628,0,'','0'),
(5582,NULL,'Димид Христина',NULL,'2020-11-17',NULL,380979728232,NULL,1261963748,'1',NULL,0,'','0'),
(5583,NULL,'Баліцька Марія',NULL,'2020-11-18',NULL,380667330120,NULL,1752459684,'1',NULL,0,'','0'),
(5584,NULL,'Михайлюк Ліля',NULL,'2020-11-18',NULL,380964576529,NULL,1429267395,'1',NULL,2,'','0'),
(5585,NULL,'Казюк Надія',NULL,'2020-11-18',NULL,380661147107,NULL,1710405645,'1',NULL,0,'','0'),
(5586,NULL,'Моткалюк Іра',NULL,'2020-11-19',NULL,380984229024,NULL,1441617128,'1',NULL,0,'','0'),
(5587,NULL,'Тронт Христина',NULL,'2020-11-20',NULL,380981295982,NULL,1729836307,'1',12012,0,'','0'),
(5588,NULL,'Федотова Діана',NULL,'2020-11-20',NULL,380675957705,NULL,2116465681,'1',NULL,0,'','0'),
(5589,NULL,'Підручна Наталя ',NULL,'2020-11-22',NULL,380980169072,NULL,1246403695,'1',15437,0,'','0'),
(5590,NULL,'Лапановська Марія ',NULL,'2020-11-22',NULL,380989230310,NULL,1771431007,'1',NULL,0,'','0'),
(5591,NULL,'Тешляр Ольга',NULL,'2020-11-24',NULL,380961644056,NULL,1132669410,'1',NULL,0,'','0'),
(5592,NULL,'Глюта Ірина',NULL,'2020-11-24',NULL,380671839477,NULL,1582843315,'1',NULL,0,'','0'),
(5593,NULL,'Осадчук люба',NULL,'2020-11-24',NULL,380975393174,NULL,1902615648,'1',56308,0,'','0'),
(5594,NULL,'Фірманюк Леся ',NULL,'2020-11-24',NULL,380984906894,NULL,1662534882,'1',NULL,0,'','0'),
(5595,NULL,'Єдинак Світлана ',NULL,'2020-11-24',NULL,380970532701,NULL,1541681639,'1',NULL,0,'','0'),
(5596,NULL,'Кісіль Галя',NULL,'2020-11-25',NULL,380985479180,NULL,1254347930,'1',NULL,0,'','0'),
(5597,NULL,'Ксенич Тетяна',NULL,'2020-11-26','KatbFL1w7bkfGPl2YMTf8Q==',380680955266,NULL,1964532880,'1',27585,0,'','0'),
(5598,NULL,'Скрипка Оксана',NULL,'2020-11-26',NULL,380979015941,NULL,1321946999,'1',NULL,0,'','0'),
(5599,NULL,'Дячок Юлія',NULL,'2020-11-26',NULL,380979384381,NULL,1203471330,'1',NULL,0,'','0'),
(5600,NULL,'Затварніцька Юлія',NULL,'2020-11-27',NULL,380687031636,NULL,1767325134,'1',NULL,0,'','0'),
(5601,NULL,'Тофан Лілія',NULL,'2020-11-27',NULL,380674999043,NULL,1513501099,'1',NULL,0,'','0'),
(5602,NULL,'степан',NULL,'2020-11-30',NULL,380678617452,NULL,1966356825,'1',NULL,0,'','0'),
(5603,NULL,'Матюніна Ольга',NULL,'2020-11-30',NULL,380686369598,NULL,2129502148,'1',NULL,0,'','0'),
(5604,NULL,'Козачок Ліля',NULL,'2020-11-30','gAfj8/hm4ryvuyT/uakjLA==',380973403309,NULL,1115336789,'1',33531,0,'','0'),
(5605,NULL,'Дерій Вікторія',NULL,'2020-11-30',NULL,380986756349,NULL,1313650193,'1',NULL,0,'','0'),
(5606,NULL,'Дерій Світлана',NULL,'2020-11-30',NULL,380501831583,NULL,1457844453,'1',NULL,2,'','0'),
(5607,NULL,'Левенець Люба',NULL,'2020-11-30',NULL,380987658876,NULL,1809134874,'1',NULL,0,'','0'),
(5608,NULL,'Блаженко Надія',NULL,'2020-11-30',NULL,380984794078,NULL,1585866253,'1',NULL,0,'','0'),
(5609,NULL,'Хорощак Іна ',NULL,'2020-11-30',NULL,380677382980,NULL,2118995872,'1',NULL,0,'','0'),
(5610,NULL,'Окіпна Ольга',NULL,'2020-12-01',NULL,380987641690,NULL,1738301902,'1',58917,0,'','0'),
(5611,NULL,'Констянтинова Оля',NULL,'2020-12-01',NULL,380976463412,NULL,1132173077,'1',NULL,0,'','0'),
(5612,NULL,'Лоренсон Валентина',NULL,'2020-12-01',NULL,380666657010,NULL,1364989717,'1',NULL,0,'','0'),
(5613,NULL,'Самборська Ірина',NULL,'2020-12-01',NULL,380964955653,NULL,1543014268,'1',56662,0,'','0'),
(5614,NULL,'Струтинська Марія',NULL,'2020-12-02',NULL,380965502850,NULL,2046543355,'1',NULL,0,'','0'),
(5615,NULL,'Дяковська Ірина',NULL,'2020-12-02',NULL,380970171152,NULL,2066327739,'1',NULL,0,'','0'),
(5616,NULL,'МиколаЇнко Людмила',NULL,'2020-12-02',NULL,380981717575,NULL,1763045119,'1',NULL,0,'','0'),
(5617,NULL,'Фарбота Уляна',NULL,'2020-12-02',NULL,380965018477,NULL,2065429501,'1',NULL,0,'','0'),
(5618,NULL,'Глек Оксана',NULL,'2020-12-03',NULL,380673173827,NULL,1819443663,'1',NULL,0,'','0'),
(5619,NULL,'Козак Марія',NULL,'2020-12-03',NULL,380966396158,NULL,1179958956,'1',NULL,1,'','0'),
(5620,NULL,'Лисак Оксана',NULL,'2020-12-03',NULL,380979770558,NULL,1485926253,'1',NULL,0,'','0'),
(5621,NULL,'Салій Аня',NULL,'2020-12-03',NULL,380683350582,NULL,1695092663,'1',NULL,0,'','0'),
(5622,NULL,'Патола Люда ',NULL,'2020-12-04',NULL,380987104515,NULL,2136102525,'1',NULL,0,'','0'),
(5623,NULL,'Теслюк Іна',NULL,'2020-12-07',NULL,380986005258,NULL,2081036327,'1',NULL,0,'','0'),
(5624,NULL,'Галат Марія',NULL,'2020-12-07',NULL,380679037047,NULL,1183580597,'1',NULL,0,'','0'),
(5625,NULL,'Буковська Іванка ',NULL,'2020-12-07',NULL,380964196576,NULL,1939651122,'1',NULL,0,'','0'),
(5626,NULL,'Батрин Олена',NULL,'2020-12-08',NULL,380983682986,NULL,1632136358,'1',NULL,0,'','0'),
(5627,NULL,'Гачкевич Валентина',NULL,'2020-12-08',NULL,380982843550,NULL,1359858898,'1',NULL,0,'','0'),
(5628,NULL,'Демкович Марія ',NULL,'2020-12-08',NULL,380990265536,NULL,1200712682,'1',NULL,0,'','0'),
(5629,NULL,'Підгірна Валентина',NULL,'2020-12-10',NULL,380980142023,NULL,1153014969,'1',NULL,1,'','0'),
(5630,NULL,'Мандибурка Іванка',NULL,'2020-12-10',NULL,380968255283,NULL,1459468944,'1',NULL,0,'','0'),
(5631,NULL,'Німець Галя',NULL,'2020-12-10','l3AzptVHZE86iQNW1rzoGQ==',380934426732,NULL,2145584007,'1',NULL,0,'','0'),
(5632,NULL,'Строцень Василина',NULL,'2020-12-12',NULL,380678971169,NULL,1796042588,'1',NULL,0,'','0'),
(5633,NULL,'Лемпарт Мар’яна ',NULL,'2020-12-12',NULL,380688510630,NULL,2038397412,'1',NULL,0,'','0'),
(5634,NULL,'Стасюк Оксана',NULL,'2020-12-13',NULL,380989442274,NULL,1782759688,'1',NULL,0,'','0'),
(5635,NULL,'Штира Рокся',NULL,'2020-12-14',NULL,380971489908,NULL,1385745744,'1',25476,0,'','0'),
(5636,NULL,'Любая Наталія ',NULL,'2020-12-14',NULL,380662010435,NULL,1160739550,'1',NULL,0,'','0'),
(5637,NULL,'Джмелик Василина',NULL,'2020-12-15','L0C0ggL5M+DC6avqpcR2fA==',380680063400,NULL,1363631179,'1',NULL,0,'','0'),
(5638,NULL,'Стахів Анна',NULL,'2020-12-15',NULL,380672573026,NULL,1111669456,'1',NULL,0,'','0'),
(5639,NULL,'Наконечна Оксана',NULL,'2020-12-15',NULL,380686547665,NULL,1286120487,'1',NULL,0,'','0'),
(5640,NULL,'Стасів Аліна',NULL,'2020-12-16',NULL,380968273377,NULL,1220576015,'1',NULL,0,'','0'),
(5641,NULL,'Божик Ілона ',NULL,'2020-12-16',NULL,380680985727,NULL,2015726446,'1',NULL,0,'','0'),
(5642,NULL,'Ковальчук Леся ',NULL,'2020-12-17',NULL,380987176393,NULL,1915395079,'1',31644,0,'','0'),
(5643,NULL,'Яроцька Оксана',NULL,'2020-12-17',NULL,380969457801,NULL,1189769369,'1',NULL,0,'','0'),
(5644,NULL,'Данилишин Наталія',NULL,'2020-12-18',NULL,380689639170,NULL,1427877917,'1',NULL,0,'','0'),
(5645,NULL,'Німець Валентина',NULL,'2020-12-18',NULL,380672678527,NULL,1680624927,'1',NULL,0,'','0'),
(5646,NULL,'Ксенич люба',NULL,'2020-12-18',NULL,380972290065,NULL,1857914680,'1',42413,0,'','0'),
(5647,NULL,'Дикун Лєна',NULL,'2020-12-19',NULL,NULL,NULL,1422025965,'1',NULL,0,'','0'),
(5648,NULL,'Параніч Христина',NULL,'2020-12-20',NULL,380686637282,NULL,1823685821,'1',NULL,0,'','0'),
(5649,NULL,'ганишин зоряна',NULL,'2020-12-20',NULL,380980090953,NULL,1356613487,'1',NULL,0,'','0'),
(5650,NULL,'Вівчаренко Вікторія ',NULL,'2020-12-21',NULL,380975709337,NULL,2126431878,'1',NULL,0,'','0'),
(5651,NULL,'Олійник Аліна',NULL,'2020-12-21',NULL,380974238970,NULL,2074413978,'1',NULL,0,'','0'),
(5652,NULL,'Бадло Оксана ',NULL,'2020-12-21',NULL,380992790489,NULL,1322111897,'1',NULL,0,'','0'),
(5653,NULL,'Січова Валерія',NULL,'2020-12-21',NULL,380973321459,NULL,1537484524,'1',NULL,0,'','0'),
(5654,NULL,'Щипчик Юрій',NULL,'2020-12-22',NULL,380979975415,NULL,1357834616,'1',NULL,0,'','0'),
(5655,NULL,'Недостойна Катерина',NULL,'2020-12-22',NULL,380506816824,NULL,1376747148,'1',NULL,0,'','0'),
(5656,NULL,'Недостойна Світлана',NULL,'2020-12-22',NULL,380669724233,NULL,1255770088,'1',NULL,0,'','0'),
(5657,NULL,'наталя наша',NULL,'2020-12-23',NULL,1,NULL,1345309775,'1',58036,0,'','0'),
(5658,NULL,'Левицька Іра',NULL,'2020-12-23',NULL,380683285585,NULL,1366919342,'1',NULL,0,'','0'),
(5659,NULL,'Галянт Оксана ',NULL,'2020-12-24',NULL,380660872826,NULL,1863607237,'1',NULL,0,'','0'),
(5660,NULL,'Поліщук Тетяна',NULL,'2020-12-24','GdbxFRvz2TxlkvStOx3MvQ==',380969855262,NULL,2062996182,'1',NULL,0,'','0'),
(5661,NULL,'Думич Анастасія',NULL,'2020-12-24',NULL,380682385473,NULL,2076204377,'1',NULL,0,'','0'),
(5662,NULL,'Кардинал Галя',NULL,'2020-12-24',NULL,380977111500,NULL,1938046289,'1',NULL,0,'','0'),
(5663,NULL,'Стасюк Ірина',NULL,'2020-12-25',NULL,380955988525,NULL,1752593218,'1',NULL,0,'','0'),
(5664,NULL,'Танцуренко Діана',NULL,'2020-12-25',NULL,380980440145,NULL,2056053723,'1',NULL,0,'','0'),
(5665,NULL,'Грицан Надія',NULL,'2020-12-25',NULL,380980994924,NULL,1851323451,'1',NULL,1,'','0'),
(5666,NULL,'Гром Марія',NULL,'2020-12-26',NULL,380976250635,NULL,1628590957,'1',NULL,0,'','0'),
(5667,NULL,'Андрійчук Наталя',NULL,'2020-12-26',NULL,380968375686,NULL,1515839238,'1',NULL,0,'','0'),
(5668,NULL,'наталя наша',NULL,'2020-12-26',NULL,NULL,NULL,1902793782,'1',NULL,0,'','0'),
(5669,NULL,'Гукалюк Оксана',NULL,'2020-12-26',NULL,380961159379,NULL,1386689767,'1',NULL,0,'','0'),
(5670,NULL,'Головата Вікторія',NULL,'2020-12-27',NULL,380986355084,NULL,1482700990,'1',42088,0,'','0'),
(5671,NULL,'Матвіїв Галя',NULL,'2020-12-27',NULL,380672935675,NULL,1126637015,'1',NULL,0,'','0'),
(5672,NULL,'Лушней Поліна',NULL,'2020-12-28',NULL,380969005363,NULL,1368902548,'1',54383,0,'','0'),
(5673,NULL,'Шафранська Таня',NULL,'2020-12-28',NULL,380679679913,NULL,1484662046,'1',NULL,0,'','0'),
(5674,NULL,'Кравчук Олександра',NULL,'2020-12-29','XAKH2UEI/otCvhp1NSYUUQ==',380671330298,NULL,1374163631,'1',25295,0,'','0'),
(5675,NULL,'Малютик Інна',NULL,'2020-12-29',NULL,380688248010,NULL,1909444946,'1',NULL,0,'','0'),
(5676,NULL,'Чорній юля',NULL,'2020-12-30',NULL,380987719497,NULL,1142245168,'1',NULL,0,'','0'),
(5677,NULL,'Олещук Вадим ',NULL,'2020-12-30',NULL,380959469596,NULL,2129934356,'1',NULL,0,'','0'),
(5678,NULL,'Сусь Оксана',NULL,'2020-12-31',NULL,380962356125,NULL,1311932126,'1',NULL,0,'','0'),
(5679,NULL,'Вівчарик Іванка',NULL,'2021-01-02',NULL,380983594557,NULL,1488655990,'1',NULL,0,'','0'),
(5680,NULL,'Ставнича Роксолана',NULL,'2021-01-02',NULL,380686380133,NULL,2032036835,'1',NULL,0,'','0'),
(5681,NULL,'Мазуркова Ірина',NULL,'2021-01-04',NULL,380975149134,NULL,1583982255,'1',NULL,0,'','0'),
(5682,NULL,'Пригар Таня',NULL,'2021-01-04','WWaCtEnn+vwzY69iJwkZGw==',380966051303,NULL,1706517335,'1',NULL,0,'','0'),
(5683,NULL,'Різник Діана',NULL,'2021-01-04',NULL,380971394159,NULL,1796175541,'1',NULL,0,'','0'),
(5684,NULL,'Борейко Надя',NULL,'2021-01-05',NULL,380633950414,NULL,1843230491,'1',NULL,0,'','0'),
(5685,NULL,'Осипян Оксана',NULL,'2021-01-05',NULL,380971967074,NULL,1664879466,'1',NULL,0,'','0'),
(5686,NULL,'Юзвенко Оля',NULL,'2021-01-11',NULL,380970761084,NULL,1737849968,'1',NULL,0,'','0'),
(5687,NULL,'Головацька Софія',NULL,'2021-01-11',NULL,380688219737,NULL,2077103221,'1',NULL,0,'','0'),
(5688,NULL,'Осьмак Аліна',NULL,'2021-01-11',NULL,380980994885,NULL,1869831047,'1',NULL,0,'','0'),
(5689,NULL,'Прийдун Оксана',NULL,'2021-01-11',NULL,380978767225,NULL,1769635651,'1',NULL,0,'','0'),
(5690,NULL,'Мельник Інна',NULL,'2021-01-11',NULL,380688177895,NULL,2089885815,'1',NULL,0,'','0'),
(5691,NULL,'Григоришин Ангеліна',NULL,'2021-01-13','BaoCWywUN3RIE9Lnyc1Ipw==',380970383770,NULL,1542571054,'1',28074,0,'','0'),
(5692,NULL,'Заяц Анастасія',NULL,'2021-01-13',NULL,380971272075,NULL,1535150552,'1',NULL,0,'','0'),
(5693,NULL,'Чайка Христина ',NULL,'2021-01-14',NULL,380984327201,NULL,1429218328,'1',NULL,0,'','0'),
(5694,NULL,'Бойчук Інна',NULL,'2021-01-14',NULL,380984490600,NULL,2032417874,'1',51558,0,'','0'),
(5695,NULL,'Мушалюк Діана',NULL,'2021-01-15',NULL,380990251666,NULL,1622907432,'1',NULL,0,'','0'),
(5696,NULL,'Багрій Христина',NULL,'2021-01-15',NULL,380960808933,NULL,2086372952,'1',NULL,0,'','0'),
(5697,NULL,'Сасанчин Надія ',NULL,'2021-01-15',NULL,380986396484,NULL,1125950999,'1',NULL,0,'','0'),
(5698,NULL,'Шпуляк Людмила',NULL,'2021-01-15',NULL,380631586299,NULL,1406935207,'1',NULL,0,'','0'),
(5699,NULL,'Стухляк Марія',NULL,'2021-01-15',NULL,380683061596,NULL,1409997191,'1',60488,0,'','0'),
(5700,NULL,'Пустельник Маша',NULL,'2021-01-15',NULL,380983899485,NULL,1787820562,'1',17428,0,'','0'),
(5701,NULL,'Куц Марія',NULL,'2021-01-15',NULL,380674954562,NULL,1485669153,'1',NULL,0,'','0'),
(5702,NULL,'Кривінська Наталія ',NULL,'2021-01-16',NULL,380979835527,NULL,1898723546,'1',NULL,0,'','0'),
(5703,NULL,'Козак Надія',NULL,'2021-01-16',NULL,380978953439,NULL,1465947975,'1',NULL,0,'','0'),
(5704,NULL,'клим аліна',NULL,'2021-01-16',NULL,380989315011,NULL,2043735931,'1',52096,0,'','0'),
(5705,NULL,'Мельник Юля',NULL,'2021-01-16',NULL,380682587513,NULL,1156446933,'1',62998,0,'','0'),
(5706,NULL,'Говдан Іра',NULL,'2021-01-16',NULL,380507299785,NULL,1303145853,'1',NULL,0,'','0'),
(5707,NULL,'Мисьо Марія',NULL,'2021-01-18',NULL,380975998215,NULL,1208642550,'1',NULL,0,'','0'),
(5708,NULL,'Павлюк Ірина',NULL,'2021-01-18',NULL,380989674552,NULL,1604763801,'1',NULL,0,'','0'),
(5709,NULL,'Танцуренко Оксана ',NULL,'2021-01-19',NULL,380680931614,NULL,1672564547,'1',NULL,0,'','0'),
(5710,NULL,'Антошків Ірина',NULL,NULL,'Mk9awiYqnb4ngYnS3p/0lg==',380681717858,NULL,1740027665,'1',44808,0,'','0'),
(5711,NULL,'Феник Галина',NULL,'2021-01-20',NULL,380978723550,NULL,1929926952,'1',NULL,2,'','0'),
(5712,NULL,'Юрчишин Оксана',NULL,'2021-01-20','6NbZqvJDLLc+E6SzXjg4VQ==',380966454838,NULL,1929764470,'1',NULL,0,'','0'),
(5713,NULL,'Вахоніна Марія',NULL,'2021-01-20',NULL,380975410359,NULL,1938460200,'1',NULL,0,'','0'),
(5714,NULL,'Юзва Надія',NULL,'2021-01-20',NULL,380980806249,NULL,2125576087,'1',38329,1,'','0'),
(5715,NULL,'Головацька Марія',NULL,'2021-01-21',NULL,380964007419,NULL,1812138501,'1',NULL,0,'','0'),
(5716,NULL,'Мороз Іра',NULL,'2021-01-21',NULL,380966454658,NULL,1513366461,'1',39459,0,'','0'),
(5717,NULL,'Курилюк Юрій',NULL,'2021-01-22',NULL,380971752556,NULL,1545023325,'1',NULL,0,'','0'),
(5718,NULL,'Окіпна Люба',NULL,'2021-01-22',NULL,380994914808,NULL,2091389252,'1',NULL,0,'','0'),
(5719,NULL,'Перепелиця ААндрій',NULL,'2021-01-22',NULL,380679183599,NULL,1670381840,'1',55864,0,'','0'),
(5720,NULL,'Попик Христина ',NULL,'2021-01-22',NULL,380689747419,NULL,1449730914,'1',NULL,0,'','0'),
(5721,NULL,'Ситник Наталія',NULL,'2021-01-23',NULL,380501574139,NULL,1728617146,'1',NULL,0,'','0'),
(5722,NULL,'Войцехівська Вікторія',NULL,'2021-01-23',NULL,380980551090,NULL,1650959590,'1',NULL,0,'','0'),
(5723,NULL,'Журба Христина',NULL,'2021-01-25','saP8xmJB3StdlEgzG93EmA==',380968284621,NULL,1787569910,'1',NULL,0,'','0'),
(5724,NULL,'Гой Діана',NULL,'2021-01-25',NULL,380662966864,NULL,1630568392,'1',NULL,0,'','0'),
(5725,NULL,'Маляк Марта ',NULL,'2021-01-25',NULL,380631579556,NULL,1943903211,'1',NULL,0,'','0'),
(5726,NULL,'Макара Марія ',NULL,'2021-01-25',NULL,380968282817,NULL,1127949456,'1',NULL,0,'','0'),
(5727,NULL,'Крива Марія ',NULL,'2021-01-26',NULL,380967233462,NULL,2147349857,'1',NULL,0,'','0'),
(5728,NULL,'Захарова Ірина',NULL,'2021-01-27',NULL,380932119456,NULL,1493132405,'1',NULL,0,'','0'),
(5729,NULL,'Шпак Уляна',NULL,'2021-01-27',NULL,380986462707,NULL,1602470715,'1',NULL,0,'','0'),
(5730,NULL,'Кузь Ірина ',NULL,'2021-01-27',NULL,380973939939,NULL,1910109309,'1',NULL,0,'','0'),
(5731,NULL,'Котляр Діма',NULL,'2021-01-28',NULL,380983171378,NULL,1526976043,'1',NULL,0,'','0'),
(5732,NULL,'Кремців Тарас',NULL,'2021-01-28','zy9vpYQ7gWLEA1aFYOo1RQ==',380681421572,NULL,1737143643,'1',49643,0,'','0'),
(5733,NULL,'Слюсар Юля',NULL,'2021-01-29','GyWHU/t0wG5qBsNlep6Ciw==',380976169892,NULL,1968197254,'1',NULL,0,'','0'),
(5734,NULL,'Солтис Наталя',NULL,'2021-01-29',NULL,380978410374,NULL,2045755195,'1',NULL,0,'','0'),
(5735,NULL,'Слоїк Марія',NULL,'2021-01-29',NULL,380988810935,NULL,1500243837,'1',NULL,0,'','0'),
(5736,NULL,'Прийдун Марія',NULL,'2021-01-29',NULL,380680797383,NULL,1735150315,'1',NULL,0,'','0'),
(5737,NULL,'Чабанова Наталя',NULL,'2021-01-30',NULL,306888211480,NULL,1402572288,'1',NULL,0,'','0'),
(5738,NULL,'Касадкін Наталя',NULL,'2021-02-01',NULL,380506484389,NULL,1537371998,'1',NULL,0,'','0'),
(5739,NULL,'Ядчишин Наталя',NULL,'2021-02-03',NULL,380987975859,NULL,1497235588,'1',37217,0,'','0'),
(5740,NULL,'Посіда Христина',NULL,'2021-02-03','xbu+E9fSgBQWTAD57bpgLQ==',380961772749,NULL,1949915832,'1',61551,0,'','0'),
(5741,NULL,'Чомко Дмитро',NULL,'2021-02-03',NULL,380686466407,NULL,1522345186,'1',NULL,0,'','0'),
(5742,NULL,'Шевченко Антоніна',NULL,'2021-02-04',NULL,380979312343,NULL,1670131808,'1',NULL,0,'','0'),
(5743,NULL,'Микецей Марта',NULL,'2021-02-04','sfsJEBanlmPcpbLQpz9hxw==',380685862715,NULL,1391328606,'1',NULL,0,'','0'),
(5744,NULL,'Довганюк  Оля',NULL,'2021-02-04',NULL,380967555109,NULL,2063435230,'1',NULL,0,'','0'),
(5745,NULL,'Волощук Олександра',NULL,'2021-02-04',NULL,380960394349,NULL,1871453258,'1',NULL,0,'','0'),
(5746,NULL,'Бала Світлана',NULL,'2021-02-05',NULL,380683334738,NULL,2009873326,'1',NULL,0,'','0'),
(5747,NULL,'Мару адмін',NULL,NULL,'ssxajvJFoBYc7ZbHIO62fQ==',380963753012,NULL,2069524395,'',16378,0,'','0'),
(5748,NULL,'Безкоровайна Марія ',NULL,'2021-02-07','MxX0rF1qN9/UMw6IIrZkXA==',380967546725,NULL,1434163143,'1',45905,1,'','0'),
(5749,NULL,'Халупняк Надя',NULL,'2021-02-08','v3w3EQDcCza8NzooutZkrg==',380979309785,NULL,1388131870,'1',NULL,0,'','0'),
(5750,NULL,'Матвієшин Оксана',NULL,'2021-02-08',NULL,380987941401,NULL,1951242969,'1',NULL,0,'','0'),
(5751,NULL,'Павюк Тетяна',NULL,'2021-02-08',NULL,380680703822,NULL,1727493833,'1',NULL,0,'','0'),
(5752,NULL,'Опацька Надія',NULL,'2021-02-08',NULL,380977740806,NULL,1505186545,'1',NULL,0,'','0'),
(5753,NULL,'Васіна Оксана',NULL,'2021-02-08',NULL,380973321170,NULL,1217901391,'1',NULL,0,'','0'),
(5754,NULL,'Соляр Іна',NULL,'2021-02-08',NULL,380681775098,NULL,1566235529,'1',NULL,0,'','0'),
(5755,NULL,'Рибак Ілона',NULL,'2021-02-08',NULL,380985717297,NULL,1120418400,'1',NULL,0,'','0'),
(5756,NULL,'Калиній Софія',NULL,'2021-02-09',NULL,380963528245,NULL,1741078950,'1',NULL,0,'','0'),
(5757,NULL,'Гевко Івана',NULL,'2021-02-09',NULL,380961472257,NULL,1439459051,'1',44189,1,'','0'),
(5969,NULL,'Заплатінська Марія ',NULL,'2021-04-20',NULL,380686292383,NULL,1152116817,'1',NULL,0,'','0'),
(6898,NULL,'Луговсьой Олександр',NULL,'2021-11-18',NULL,380665905156,NULL,1296922744,'1',NULL,0,'','0'),
(5758,NULL,'Шмід Олеся',NULL,'2021-02-10',NULL,380674590827,NULL,1265439065,'1',20248,0,'','0'),
(5759,NULL,'Харук Оксана',NULL,'2021-02-10','MWVJcxt7xTwuHSVWj9w1Kg==',380973093700,NULL,1168020471,'1',NULL,0,'','0'),
(6420,NULL,'Мельничук Оксана ',NULL,'2021-07-21',NULL,380675805921,NULL,2111733466,'1',NULL,0,'','0'),
(5760,NULL,'Ткач Наталія','1992-12-14','2021-02-10',NULL,380680960188,NULL,1197492076,'1',NULL,0,'','0'),
(5761,NULL,'Лукинів Уляна',NULL,'2021-02-10',NULL,380984311084,NULL,1470063006,'1',NULL,0,'','0'),
(5762,NULL,'Балакунець Валентина',NULL,'2021-02-11','l/+A+Gnx9F+UqWspjjJZuw==',380681759241,NULL,1287202809,'1',NULL,0,'','0'),
(5763,NULL,'Орлик Софія ',NULL,'2021-02-11',NULL,380689640269,NULL,1251365176,'1',NULL,0,'','0'),
(5764,NULL,'Строцень Аліна',NULL,'2021-02-12','omP/PyRfbdqYi3hhTdcMRQ==',380680966374,NULL,1111851787,'1',23384,0,'','0'),
(5765,NULL,'Греськів Христина',NULL,'2021-02-12',NULL,380686615616,NULL,2070687518,'1',43229,0,'','0'),
(5766,NULL,'Івасишин Оксана',NULL,'2021-02-12',NULL,380680463308,NULL,1812265089,'1',NULL,0,'','0'),
(5767,NULL,'Нейко Оля',NULL,'2021-02-13',NULL,380962927838,NULL,1712545797,'1',NULL,0,'','0'),
(5923,NULL,'Лілякевич Марина',NULL,'2021-04-08',NULL,380680463315,NULL,1814278112,'1',NULL,0,'','0'),
(5768,NULL,'Микитюк Наталія',NULL,'2021-02-13',NULL,380978456931,NULL,1971564490,'1',NULL,0,'','0'),
(5769,NULL,'Петришин Уляна',NULL,'2021-02-15',NULL,380502851561,NULL,2070883850,'1',NULL,0,'','0'),
(5770,NULL,'Коростіль Аліна',NULL,'2021-02-15','eVTV+eGFi7AHIBCUxrpYXQ==',380680723815,NULL,1228956849,'1',NULL,0,'','0'),
(5771,NULL,'Шуткова Олена',NULL,NULL,NULL,380673532927,NULL,1891428576,'1',NULL,0,'','0'),
(5772,NULL,'Карлічук Олена',NULL,'2021-02-15',NULL,380977969946,NULL,1144664875,'1',36236,0,'','0'),
(5773,NULL,'Пюревич Валентина',NULL,'2021-02-16',NULL,380502432780,NULL,1904293601,'1',NULL,0,'','0'),
(5774,NULL,'Савінкіна Оля',NULL,'2021-02-16',NULL,380958819849,NULL,1222267010,'1',NULL,0,'','0'),
(5775,NULL,'Плішка Марія',NULL,'2021-02-17',NULL,380985075152,NULL,1616778652,'1',24597,1,'','0'),
(5776,NULL,'Загайко Оксана',NULL,'2021-02-17',NULL,380507556603,NULL,1792568362,'1',NULL,1,'','0'),
(5777,NULL,'Хворост Аліна',NULL,'2021-02-17',NULL,380689317252,NULL,1114059650,'1',NULL,0,'','0'),
(5778,NULL,'Піць Аліна',NULL,'2021-02-17','PnunEPiqFfyhAmUcrO3A2w==',380950358338,NULL,1219338418,'1',NULL,0,'','0'),
(5779,NULL,'Бережна Маряна',NULL,'2021-02-17','Nc7+Vz0OJPrNZJPBjYn1ow==',380972675514,NULL,1579537179,'1',NULL,0,'','0'),
(5922,NULL,'канюк людмила',NULL,'2021-04-08',NULL,380634789979,NULL,2126580668,'1',20630,0,'','0'),
(5780,NULL,'Букалюк Христя ',NULL,'2021-02-17','6ogD5aSWmDkMadZ211c1xw==',380974929233,NULL,1719882776,'1',NULL,0,'','0'),
(5781,NULL,'Тришак Галина',NULL,'2021-02-18',NULL,380685768672,NULL,1254219820,'1',NULL,0,'','0'),
(5782,NULL,'Семанишин Христина',NULL,'2021-02-18',NULL,380505680816,NULL,2041357534,'1',NULL,0,'','0'),
(6724,NULL,'Макух Наталія ',NULL,'2021-09-16',NULL,380982897223,NULL,1723806391,'1',NULL,0,'','0'),
(5783,NULL,'Домінюк Люда',NULL,'2021-02-18',NULL,380687626805,NULL,2006790784,'1',NULL,0,'','0'),
(5784,NULL,'Данильчук Наталія',NULL,'2021-02-18',NULL,380962487603,NULL,1542319484,'1',NULL,0,'','0'),
(5785,NULL,'Франків Леся',NULL,'2021-02-18',NULL,380980952857,NULL,1734472546,'1',NULL,0,'','0'),
(5786,NULL,'каральова раїса',NULL,'2021-02-19',NULL,380688863054,380965552853,1896350373,'1',NULL,0,'','0'),
(5787,NULL,'Сенів Гана',NULL,'2021-02-19',NULL,380977387697,NULL,1435119279,'1',NULL,0,'','0'),
(5788,NULL,'Душенко Надія',NULL,'2021-02-19',NULL,380974529003,NULL,1506891274,'1',NULL,0,'','0'),
(5830,NULL,'Тронт Христина',NULL,'2021-03-04',NULL,380985747264,NULL,1540862139,'1',NULL,0,'','0'),
(6610,NULL,'Окіпна Люба',NULL,'2021-08-23',NULL,380985547388,NULL,1838077668,'1',NULL,0,'','0'),
(5789,NULL,'Гульчак Марія',NULL,'2021-02-20','e03yqNOyZSD4O/Z5smtQMg==',380686764090,NULL,1916186282,'1',NULL,0,'','0'),
(5790,NULL,'Поцентайло Олена',NULL,'2021-02-20',NULL,380967529311,NULL,1732116302,'1',NULL,0,'','0'),
(5791,NULL,'Дуда Катерина','1996-11-12','2021-02-20',NULL,380970541929,NULL,1632222231,'1',NULL,0,'','0'),
(5792,NULL,'Сміхун Тетяна ','1979-04-27','2021-02-20','r6ICW3sk1iKyvnoXni8k6Q==',380683327094,NULL,1534120701,'1',60677,0,'','0'),
(5793,NULL,'Оля Доскочинська','1993-08-21','2021-02-20',NULL,380976466587,NULL,1993717389,'1',NULL,0,'
\n
\n','0'),
(5794,NULL,'Остапова Марія ','2004-08-15','2021-02-20',NULL,380680548488,NULL,1494567115,'1',NULL,0,'
\n
\n','0'),
(5795,NULL,'Скадовська Ірина','1990-09-12','2021-02-20',NULL,380502917344,NULL,1631735214,'1',NULL,0,'','0'),
(5796,NULL,'Алла макар ','1990-12-13','2021-02-20',NULL,380507895379,NULL,1483866958,'1',NULL,0,'','0'),
(5797,NULL,'Юркевич Людмила','2004-07-16','2021-02-20',NULL,380979272109,NULL,2054472183,'1',43246,0,'','0'),
(5798,NULL,'Галина Петренко','2000-08-08','2021-02-21',NULL,380983526452,NULL,1847574773,'1',NULL,0,'','0'),
(5799,NULL,'Коваль Ірина','1980-04-22','2021-02-21',NULL,380987686858,NULL,1697492039,'1',NULL,0,'','0'),
(5800,NULL,'Пасічник Маша',NULL,'2021-02-21',NULL,380681130799,NULL,1302137273,'1',NULL,0,'','0'),
(5801,NULL,'Остапюк Андріана ',NULL,'2021-02-21',NULL,380988339576,NULL,1569553406,'1',NULL,0,'','0'),
(5802,NULL,'Юськів Анастасія','2004-03-04','2021-02-22',NULL,380986178480,NULL,1911996799,'1',NULL,0,'','0'),
(5803,NULL,'Провальна Катя ','2000-02-03','2021-02-22','Ob5aRtP9H18+ssJymEAqQw==',380680245519,NULL,2044492790,'1',21883,0,'','0'),
(5804,NULL,'Пасечка Інна ','2003-07-19','2021-02-22','iIeJRX5tVxTCv05dJNZfKg==',380686848096,NULL,1726895904,'1',64759,1,'','0'),
(5966,NULL,'Рожелюк Таня',NULL,'2021-04-20',NULL,380961303093,NULL,1649702908,'1',NULL,0,'','0'),
(5805,NULL,'Патера Світлана',NULL,'2021-02-22',NULL,380971610573,NULL,1664542221,'1',NULL,0,'','0'),
(6231,NULL,'Христина Дем\'янчук','2001-09-27','2021-06-20',NULL,380962199210,NULL,1650107226,'1',NULL,0,'','0'),
(5806,NULL,'Слободян Вікторія ',NULL,'2021-02-22',NULL,380689389015,NULL,1936231839,'1',NULL,0,'','0'),
(5807,NULL,'Чупрій Марія',NULL,'2021-02-23',NULL,380687625470,NULL,1520179473,'1',42029,1,'','0'),
(6660,NULL,'Ломацька Людмила',NULL,'2021-09-02',NULL,380964917016,NULL,1154938502,'1',NULL,0,'','0'),
(5808,NULL,'Ушко Наталія ',NULL,'2021-02-23','gDpITZemYlaWCNuLjKsdCQ==',380974895978,NULL,1561398457,'1',NULL,1,'','0'),
(5809,NULL,'Поліщук Каміла',NULL,'2021-02-23','7GoR1XNXlP4DliLyW8rxFA==',380689339316,NULL,1424685351,'1',16442,0,'','0'),
(5810,NULL,'Кутрик Галина',NULL,'2021-02-24',NULL,380680548512,NULL,1691618578,'1',NULL,0,'','0'),
(6635,NULL,'Онуфрієва Маргарита ',NULL,'2021-08-28',NULL,380677867664,NULL,1982645002,'1',NULL,0,'','0'),
(5811,NULL,'Фурега Катерина','2006-09-04','2021-02-24',NULL,380681421584,380681421584,2039544308,'1',56277,0,'','0'),
(6370,NULL,'Храпко Вікторія',NULL,'2021-07-14',NULL,380974027885,NULL,2101046013,'1',NULL,0,'','0'),
(5812,NULL,'Гурмус Наталя',NULL,'2021-02-25',NULL,380984931919,NULL,1864747812,'1',12423,0,'','0'),
(5813,NULL,'Стукало Надія',NULL,'2021-02-25',NULL,380684195978,NULL,1395616200,'1',NULL,0,'','0'),
(6754,NULL,'Провальна Юля ',NULL,'2021-09-28',NULL,380682421453,NULL,1281851766,'1',NULL,0,'','0'),
(5814,NULL,'Антошків Руслан',NULL,'2021-02-25',NULL,380963169406,NULL,1344431364,'1',NULL,0,'','0'),
(5815,NULL,'Винничук Мар\'яна ','1995-03-31','2021-02-25',NULL,380984038195,NULL,1821511151,'1',26017,1,'
\n','0'),
(5816,NULL,'Золотоцька христина',NULL,'2021-02-26',NULL,380683334106,NULL,1987698840,'1',NULL,0,'','0'),
(5817,NULL,'Заболотна Каріна',NULL,'2021-02-26',NULL,380966703510,NULL,2034567202,'1',NULL,0,'','0'),
(5818,NULL,'Єдинак Любов',NULL,'2021-02-26',NULL,380981293050,NULL,1941738817,'1',NULL,0,'','0'),
(6295,NULL,'Дідюк Марія',NULL,'2021-07-02',NULL,380973217161,NULL,1219432611,'1',NULL,0,'','0'),
(5819,NULL,'Безушко Анастасія',NULL,'2021-02-27',NULL,380984090186,NULL,1621879954,'1',NULL,0,'','0'),
(5820,NULL,'Рожок Іра',NULL,'2021-02-27',NULL,380638870721,NULL,1631677848,'1',NULL,0,'','0'),
(5821,NULL,'Гречка Наталія',NULL,'2021-02-27','unfK5PF3LXl4HmCyLZknlw==',380979240993,NULL,1170096210,'1',NULL,0,'','0'),
(5822,NULL,'Ванджура Оксана','1994-08-22','2021-02-28',NULL,380967936258,NULL,1569115097,'1',NULL,0,'','0'),
(5823,NULL,'Сігумбаєва Ольга ',NULL,'2021-02-28',NULL,380678366042,NULL,1797922882,'1',NULL,0,'','0'),
(5824,NULL,'Гук Христя',NULL,'2021-03-01',NULL,380507645167,NULL,1320964762,'1',NULL,0,'','0'),
(5825,NULL,'Черкасова Маряна',NULL,'2021-03-01',NULL,380985396403,NULL,1169828605,'1',NULL,0,'','0'),
(5826,NULL,'Ванат Зоряна',NULL,NULL,NULL,380988651455,NULL,1283152429,'',NULL,0,'','0'),
(5827,NULL,'Славіна Альона',NULL,'2021-03-02',NULL,380666925924,NULL,1175961747,'1',35526,0,'','0'),
(6480,NULL,'Сосновська Аліна','2000-06-14','2021-07-30',NULL,380986486852,380933543092,2004205960,'1',NULL,0,'','0'),
(6221,NULL,'Іваннa Гайдамаха','2000-07-10','2021-06-16',NULL,380961265738,380661638669,1960446199,'1',NULL,0,'','0'),
(5828,NULL,'Семчишин Оля',NULL,'2021-03-03',NULL,380987308487,NULL,2013258911,'1',NULL,0,'','0'),
(5829,NULL,'Гикавчук Світлана',NULL,'2021-03-03',NULL,380681476826,NULL,1134405678,'1',NULL,0,'','0'),
(5831,NULL,'Радіон Марія',NULL,'2021-03-04',NULL,380687134206,NULL,1370298020,'1',NULL,0,'','0'),
(5832,NULL,'Калинюк Діана',NULL,'2021-03-04',NULL,380989400700,NULL,1299502914,'1',NULL,0,'','0'),
(5833,NULL,'Слободян Марія',NULL,'2021-03-04',NULL,380988202548,NULL,1149300428,'1',NULL,0,'','0'),
(5834,NULL,'Гаця Соломія',NULL,'2021-03-04',NULL,380689617872,NULL,2109553226,'1',NULL,0,'','0'),
(5835,NULL,'Слободян Ольга',NULL,'2021-03-04',NULL,380676653811,NULL,1636382548,'1',NULL,0,'','0'),
(5836,NULL,'Касіян Оксана Володимирівна',NULL,'2021-03-05',NULL,380979919663,NULL,1703044429,'1',NULL,0,'','0'),
(5837,NULL,'Цюпак Уляна ',NULL,'2021-03-05',NULL,380970664693,NULL,2096983538,'1',NULL,0,'','0'),
(5838,NULL,'Якрвець Катя',NULL,'2021-03-05',NULL,380957457614,NULL,1417674438,'1',NULL,0,'','0'),
(5839,NULL,'Галюсько Юля',NULL,'2021-03-05',NULL,380686257493,NULL,1173044139,'1',NULL,0,'','0'),
(5840,NULL,'Світлана Миколаївна','1965-03-26',NULL,NULL,380967245003,NULL,1762519569,'',NULL,0,'','0'),
(5841,NULL,'Ганушевська Людмила',NULL,NULL,NULL,380507081538,NULL,2091626589,'',NULL,0,'','0'),
(5842,NULL,'Мальована Тетяна Олегівна ','1995-12-25','2021-03-05',NULL,380962707694,380962707694,1824791932,'1',NULL,0,'','0'),
(5843,NULL,'Микитин Тетяна',NULL,'2021-03-05',NULL,380969075151,NULL,1877659556,'1',NULL,0,'','0'),
(5844,NULL,'Аліна Гриців','2001-04-11','2021-03-05',NULL,380662090282,NULL,1766773663,'1',39705,0,'','0'),
(5845,NULL,'Ксенія Коваль','2003-10-30','2021-03-05',NULL,380686890179,NULL,2101047843,'1',NULL,0,'','0'),
(5846,NULL,'Худзік Юлія','2000-01-22','2021-03-06',NULL,380964007731,NULL,2095941397,'1',22749,0,'','0'),
(6387,NULL,'Безпалько Наталія',NULL,'2021-07-16',NULL,380671987858,NULL,1227573416,'1',NULL,0,'','0'),
(5847,NULL,'Березовсбка Любав',NULL,'2021-03-08',NULL,380688617952,NULL,1198431477,'1',NULL,0,'','0'),
(5848,NULL,'кузій зоряна',NULL,'2021-03-08',NULL,380686134011,NULL,1664197374,'1',NULL,0,'','0'),
(5849,NULL,'Фірман Яна',NULL,'2021-03-09',NULL,380674785574,NULL,2139385424,'1',NULL,0,'','0'),
(5850,NULL,'Піць Ольга',NULL,'2021-03-09',NULL,380661277327,NULL,1757717178,'1',NULL,0,'','0'),
(5851,NULL,'Лопушняк Ліля',NULL,'2021-03-09',NULL,380978755634,NULL,1676621120,'1',14295,0,'','0'),
(5852,NULL,'Ензовіт Оля',NULL,'2021-03-09',NULL,380971291794,NULL,1987830880,'1',55210,0,'','0'),
(5853,NULL,'Захарчук Оксана',NULL,'2021-03-10',NULL,380989206718,NULL,1804942844,'1',NULL,0,'','0'),
(5854,NULL,'Піхут Ольга','1990-01-18','2021-03-11',NULL,380976068969,NULL,1308921366,'1',NULL,0,'','0'),
(5855,NULL,'Куфель Софія ',NULL,'2021-03-11','xCVSHdwVtjzNIsZYvEiFsA==',380984784877,NULL,1168586248,'1',NULL,0,'','0'),
(5856,NULL,'Коваль Софія','2007-02-27','2021-03-11',NULL,380962233748,380987686855,1127599421,'1',19633,0,'','0'),
(5857,NULL,'Ярема Тетяна','2006-10-22','2021-03-11',NULL,380978580132,380978580132,1838218947,'1',NULL,0,'','0'),
(5858,NULL,'Танцуренко Оксана',NULL,'2021-03-12',NULL,380979357839,NULL,1341578937,'1',NULL,0,'','0'),
(5859,NULL,'Мукоєд Настя ',NULL,'2021-03-14',NULL,380982518533,NULL,1599039525,'1',25127,0,'','0'),
(5860,NULL,'Остроголова Ірина',NULL,NULL,NULL,380688078056,NULL,1724393317,'0',NULL,0,'','1'),
(5861,NULL,'Остроголова Іра',NULL,'2021-03-15',NULL,380680780565,NULL,1963873719,'1',NULL,0,'','0'),
(5862,NULL,'Олексишин Віка ',NULL,'2021-03-16',NULL,380988461900,NULL,1272262771,'1',NULL,0,'','0'),
(5863,NULL,'Іванців Лєна ',NULL,'2021-03-16',NULL,380983615959,NULL,1687225613,'1',NULL,0,'','0'),
(5864,NULL,'Братус Світлана',NULL,'2021-03-17',NULL,380989059088,NULL,2068910495,'1',NULL,1,'','0'),
(5865,NULL,'Леськів Наталя',NULL,'2021-03-17',NULL,380988780069,NULL,1301013193,'1',NULL,0,'','0'),
(5866,NULL,'Клачко Леся',NULL,'2021-03-17',NULL,380983425559,NULL,1633403572,'1',NULL,0,'','0'),
(5867,NULL,'Чабанова Наталя ',NULL,'2021-03-17',NULL,380688821480,NULL,1663934376,'1',NULL,0,'','0'),
(5868,NULL,'Слонь Зоряна ',NULL,'2021-03-18',NULL,380675235799,NULL,1472961826,'1',NULL,0,'','0'),
(5869,NULL,'нога галина',NULL,'2021-03-19',NULL,380984834240,NULL,2144408798,'1',NULL,0,'','0'),
(5870,NULL,'Греськів Христина',NULL,'2021-03-19',NULL,380502488905,NULL,1356958652,'1',NULL,0,'','0'),
(5871,NULL,'Бабійчук Марія ',NULL,'2021-03-19',NULL,380966023982,NULL,1330640674,'1',NULL,0,'','0'),
(5872,NULL,'Ластівка Анастасія','2003-01-10','2021-03-20','UtAX9b26Tmj4ScfF68f/Pw==',380977167204,NULL,1997038380,'1',43206,0,'','0'),
(5873,NULL,'Гриненко Анастасія',NULL,'2021-03-21',NULL,380997289897,NULL,1600223628,'1',NULL,0,'','0'),
(5874,NULL,'Бабій Таня',NULL,'2021-03-22',NULL,380979060071,NULL,1617731410,'1',NULL,0,'','0'),
(5875,NULL,'Кметик Оксана','1987-10-19','2021-03-22',NULL,380967895070,NULL,1723847847,'1',59707,0,'','0'),
(5876,NULL,'Скрипник Оксана',NULL,'2021-03-22',NULL,380964848040,NULL,1200527491,'1',NULL,0,'','0'),
(5877,NULL,'Затильна Мар\'яна','1995-08-28','2021-03-22',NULL,380685373350,NULL,1661219227,'1',29526,0,'','0'),
(5878,NULL,'Когут Марія ',NULL,'2021-03-22',NULL,380989833372,NULL,1375760044,'1',NULL,1,'','0'),
(5879,NULL,'Березовська Оксана ',NULL,'2021-03-22',NULL,380965191899,NULL,1820312888,'1',NULL,0,'','0'),
(5880,NULL,'Кічан Аліна','1995-04-28','2021-03-22',NULL,380968366831,NULL,1316429251,'1',52175,0,'','0'),
(5881,NULL,'Драбеняста Оля',NULL,'2021-03-23',NULL,380967252463,NULL,2048475831,'1',46484,0,'','0'),
(5882,NULL,'Козловська Наталія ',NULL,'2021-03-23',NULL,380978989221,NULL,1707678919,'1',NULL,0,'','0'),
(5883,NULL,'Завадовська Алла',NULL,'2021-03-23',NULL,380673265198,NULL,1890481654,'1',NULL,0,'','0'),
(5884,NULL,'Довбуш Іра',NULL,'2021-03-24',NULL,380971056975,NULL,1940351533,'1',NULL,0,'','0'),
(5885,NULL,'Сеничко Валентина',NULL,'2021-03-24',NULL,380988764212,NULL,1865020810,'1',NULL,0,'','0'),
(5886,NULL,'Федоришин Тетяна ',NULL,'2021-03-26',NULL,380665257765,NULL,1517229007,'1',NULL,0,'','0'),
(5887,NULL,'Качмарська Марія',NULL,'2021-03-26',NULL,380961311770,NULL,2049650626,'1',NULL,0,'','0'),
(5888,NULL,'Маціборко Аліна','2003-04-26','2021-03-26',NULL,380984169812,380984169812,1170649291,'1',19119,0,'','0'),
(5889,NULL,'Кінах Сергій',NULL,'2021-03-27',NULL,380673098557,NULL,1996860049,'1',61260,0,'','0'),
(5890,NULL,'Панчишин Діана',NULL,'2021-03-28',NULL,380980584337,NULL,1697712444,'1',NULL,0,'','0'),
(5891,NULL,'тьотя леся',NULL,'2021-03-29',NULL,380973226094,NULL,1537428825,'1',NULL,0,'','0'),
(5892,NULL,'Гавянець Софія',NULL,'2021-03-29',NULL,380681256114,NULL,1134344183,'1',NULL,0,'','0'),
(5893,NULL,'Сасанчин Зоряна',NULL,'2021-03-29','ueU7rYHV/K2B2DmT8vx+bA==',380984889285,NULL,1748308002,'1',48318,0,'','0'),
(5894,NULL,'прокопенко тетяна',NULL,'2021-03-29',NULL,380671967229,NULL,2136096330,'1',NULL,0,'','0'),
(6867,NULL,'Веремчук Надіія',NULL,'2021-11-05',NULL,380988408191,NULL,1315558339,'1',NULL,0,'','0'),
(5895,NULL,'Бурта Мар’яна ',NULL,'2021-03-29',NULL,380673463964,NULL,1506280054,'1',NULL,0,'','0'),
(5896,NULL,'Забіяка Ліза',NULL,'2021-03-30',NULL,380973044012,NULL,1331255974,'1',NULL,0,'','0'),
(5897,NULL,'Мазур Вікторія',NULL,'2021-03-30','Y2NQd4+xZgIM2bCn1d17Eg==',380683200960,NULL,2087498201,'1',20691,0,'','0'),
(5898,NULL,'Савка  Аня',NULL,'2021-03-30',NULL,380989009990,NULL,1708337868,'1',NULL,0,'','0'),
(5899,NULL,'Пилат Іра',NULL,'2021-03-31',NULL,380673518126,NULL,1340830579,'1',NULL,0,'','0'),
(5900,NULL,'Провальна Наталія',NULL,'2021-03-31',NULL,380974542257,NULL,1258327353,'1',NULL,0,'','0'),
(5901,NULL,'Самотяга Марія',NULL,'2021-03-31',NULL,380969893916,NULL,1944821161,'1',NULL,0,'','0'),
(5902,NULL,'Горачко Оля',NULL,'2021-04-01',NULL,380969562713,NULL,1179976667,'1',NULL,0,'','0'),
(5903,NULL,'Нагаєвська Ганна',NULL,'2021-04-02',NULL,380987310768,NULL,1967725616,'1',NULL,0,'','0'),
(5904,NULL,'Олещук Оксана',NULL,'2021-04-03',NULL,380959099329,NULL,1439398454,'1',NULL,0,'','0'),
(5905,NULL,'Маціборко Уляна','2005-02-01','2021-04-03',NULL,380680325996,NULL,1166944783,'1',58109,0,'
\n','0'),
(5906,NULL,'Тришак Соломія','2004-03-15','2021-04-03',NULL,380960753219,380960753219,1606684345,'1',26955,0,'','0'),
(5907,NULL,'Чайка Марія ',NULL,'2021-04-04',NULL,380951426663,NULL,1428308823,'1',NULL,0,'','0'),
(6661,NULL,'Врублевська Наталія',NULL,'2021-09-03',NULL,380688345645,NULL,1313919456,'1',NULL,1,'','0'),
(5908,NULL,'Нагірна Марія ',NULL,'2021-04-05',NULL,380681277246,NULL,1247435190,'1',NULL,0,'','0'),
(5909,NULL,'Недільська Лариса',NULL,'2021-04-05',NULL,380982384291,NULL,1904473898,'1',47937,0,'','0'),
(5910,NULL,'Зинов‘їв Христина','1997-10-09','2021-04-05',NULL,380677195270,NULL,1156268683,'1',NULL,0,'','0'),
(5911,NULL,'яник марія',NULL,'2021-04-05',NULL,380967421046,NULL,2055573222,'1',NULL,0,'','0'),
(5912,NULL,'Красноштан Вікторія','0204-03-21','2021-04-06',NULL,380974150518,NULL,1318648851,'1',23895,0,'','0'),
(5913,NULL,'Стасів Сніжана',NULL,'2021-04-06',NULL,380961114214,NULL,2024752948,'1',NULL,0,'','0'),
(5914,NULL,'Мовчан Валентина',NULL,'2021-04-06',NULL,380684373671,NULL,1927352295,'1',NULL,0,'','0'),
(5915,NULL,'Слободян Світлана',NULL,'2021-04-06',NULL,380985365272,NULL,1760256734,'1',NULL,0,'','0'),
(5916,NULL,'Слободян Галина',NULL,'2021-04-06',NULL,380969316849,NULL,1736766266,'1',NULL,0,'','0'),
(5917,NULL,'Ільчишин галина',NULL,'2021-04-06',NULL,380955204823,NULL,1385300386,'1',NULL,0,'','0'),
(5918,NULL,'Доскочинська Марія','1996-09-22','2021-04-07',NULL,380969218758,380985703709,1342704509,'1',NULL,0,'
\n
\n','0'),
(5919,NULL,'Іванова Галина',NULL,'2021-04-08',NULL,380973576051,NULL,1284400769,'1',NULL,0,'','0'),
(5920,NULL,'Анонійчук Люба',NULL,'2021-04-08',NULL,380665082346,NULL,1286929543,'1',NULL,2,'','0'),
(5921,NULL,'Марків Люба',NULL,'2021-04-08',NULL,380673507529,NULL,1510439375,'1',NULL,0,'','0'),
(5924,NULL,'Петрівська Світлана',NULL,'2021-04-09',NULL,380978006779,NULL,1160256634,'1',NULL,0,'','0'),
(5925,NULL,'стасюк надія',NULL,'2021-04-09',NULL,380977479866,NULL,1295545003,'1',NULL,0,'','0'),
(5926,NULL,'Марак Теттяна',NULL,'2021-04-10',NULL,380680114812,NULL,1251643644,'1',NULL,0,'','0'),
(5927,NULL,'Кирилишин Діана',NULL,'2021-04-10',NULL,380683848925,NULL,1502083620,'1',NULL,0,'','0'),
(5928,NULL,'Ярік ',NULL,'2021-04-10',NULL,380978979418,NULL,1224719692,'1',NULL,0,'','0'),
(5929,NULL,'Гаврилюк Юля ','2002-05-20','2021-04-12','1iw658BTRMchQxhhJyRigQ==',380689465009,NULL,1608135964,'1',58784,0,'','0'),
(5930,NULL,'Семерез Назар',NULL,'2021-04-12',NULL,380730755231,NULL,1954435602,'1',NULL,0,'','0'),
(5931,NULL,'Дуреш Таня',NULL,'2021-04-12',NULL,380988327509,NULL,1997780001,'1',NULL,0,'','0'),
(5932,NULL,'Федорчук Людмила ',NULL,'2021-04-12',NULL,380978829408,NULL,1988941611,'1',NULL,0,'','0'),
(5933,NULL,'Христинич Ліля',NULL,'2021-04-12',NULL,380965660679,NULL,1850703476,'1',NULL,0,'','0'),
(5934,NULL,'Ричко Лілія',NULL,'2021-04-13',NULL,380502338741,NULL,1291844443,'1',NULL,0,'','0'),
(5935,NULL,'Вадовська Іна ',NULL,'2021-04-13',NULL,380966795325,NULL,1891737331,'1',NULL,0,'','0'),
(5936,NULL,'музичка леся',NULL,'2021-04-14',NULL,380966852456,NULL,2133091476,'1',NULL,0,'','0'),
(5937,NULL,'Ружило Лэна',NULL,'2021-04-14',NULL,380954828337,NULL,1838142333,'1',NULL,0,'','0'),
(5938,NULL,'Ружило Марія',NULL,'2021-04-14',NULL,380067299513,NULL,1179200763,'1',NULL,0,'','0'),
(5939,NULL,'Ружило Марія',NULL,'2021-04-14',NULL,380672995131,NULL,1958644025,'1',NULL,0,'','0'),
(5940,NULL,'Пилипів Марія ','2000-04-07','2021-04-14',NULL,380675810430,NULL,1190059924,'1',17161,0,'','0'),
(5941,NULL,'Пушкар Марія',NULL,'2021-04-14',NULL,380986301099,NULL,1951304218,'1',NULL,0,'','0'),
(5942,NULL,'Дрогомирецька Олеся ',NULL,'2021-04-14',NULL,380673267198,NULL,1560795697,'1',NULL,0,'','0'),
(5943,NULL,'Дрогомирецька Світлана ',NULL,'2021-04-14',NULL,380673267386,NULL,1990034915,'1',NULL,0,'','0'),
(5944,NULL,'Мерлавська Ірина',NULL,'2021-04-15',NULL,380977291091,NULL,1760596247,'1',NULL,0,'','0'),
(5945,NULL,'Варгатюк Ірина',NULL,'2021-04-15',NULL,380968712491,NULL,2064456441,'1',NULL,0,'','0'),
(5946,NULL,'Синюк Юля ','1993-12-13','2021-04-15',NULL,380976494696,NULL,2017964494,'1',12595,0,'','0'),
(5947,NULL,'Совяк Оксана',NULL,'2021-04-15',NULL,380688180829,NULL,1794676234,'1',NULL,0,'','0'),
(5948,NULL,'Вензель юля',NULL,'2021-04-15',NULL,380989725235,NULL,1364454526,'1',NULL,0,'','0'),
(5949,NULL,'маша машп','1995-03-05','2021-04-15',NULL,380505055055,NULL,2039760108,'1',NULL,0,'','0'),
(5950,NULL,'Бута Каріна',NULL,'2021-04-15',NULL,380689809906,NULL,1696944059,'1',NULL,0,'','0'),
(5951,NULL,'Мацевко Настя',NULL,'2021-04-15',NULL,380967525585,NULL,2044392433,'1',NULL,0,'','0'),
(5952,NULL,'Борисівна Руслана',NULL,'2021-04-16',NULL,380662319314,NULL,1770659262,'1',NULL,0,'','0'),
(5953,NULL,'Романенко Оля ',NULL,'2021-04-17',NULL,380993965379,NULL,1914541153,'1',NULL,0,'','0'),
(5954,NULL,'Гродзіцька Юлія',NULL,'2021-04-17',NULL,380685299107,NULL,2039748279,'1',NULL,0,'','0'),
(5955,NULL,'Пастушенко Людмила',NULL,'2021-04-17',NULL,380965163846,NULL,1677094845,'1',NULL,0,'','0'),
(5956,NULL,'Беризюк Наталя ',NULL,'2021-04-17',NULL,380990131098,NULL,1123649421,'1',NULL,0,'','0'),
(5957,NULL,'гринюка юлыя',NULL,'2021-04-18',NULL,380990742469,NULL,2097387504,'1',NULL,0,'','0'),
(5958,NULL,'Балюк галя','1998-03-13','2021-04-18','JuypG3Oxov+kvW9xHzFraQ==',380965367121,380681411957,1862709813,'1',63996,0,'Люблю зміни
\n','0'),
(5959,NULL,'Василів Наталія ',NULL,'2021-04-18',NULL,380506165983,NULL,1346155883,'1',NULL,0,'','0'),
(5960,NULL,'Шульга Стела ',NULL,'2021-04-19',NULL,380970362909,NULL,1458759188,'1',NULL,1,'','0'),
(5961,NULL,'Ямняк галина',NULL,'2021-04-19',NULL,380968412067,NULL,1390781211,'1',NULL,0,'','0'),
(5962,NULL,'Товпига Ольга',NULL,'2021-04-19',NULL,380973993071,NULL,1750030143,'1',NULL,0,'','0'),
(5963,NULL,'Лаврик Олена',NULL,'2021-04-19',NULL,380979480023,NULL,2000386556,'1',NULL,0,'','0'),
(5964,NULL,'Алєксандре',NULL,'2021-04-19',NULL,380666155249,NULL,1322160058,'1',NULL,0,'','0'),
(5965,NULL,'Огородник Юля',NULL,'2021-04-19',NULL,380685927282,NULL,1431944138,'1',NULL,0,'','0'),
(5967,NULL,'Гаврилюк Надія',NULL,'2021-04-20',NULL,380672769036,NULL,1846261252,'1',NULL,0,'','0'),
(5968,NULL,'Дпеьіт Софія',NULL,'2021-04-20','fvQt5yCautN/iDjVCnOSow==',380683391548,NULL,1548845935,'1',NULL,0,'','0'),
(5970,NULL,'Шикульська Наталія ',NULL,'2021-04-20',NULL,380680264618,NULL,1978617774,'1',NULL,0,'','0'),
(5971,NULL,'Кушнір Таня',NULL,'2021-04-21',NULL,380963381153,NULL,2028965995,'1',NULL,0,'','0'),
(5972,NULL,'Кушеір Наталя ',NULL,'2021-04-21',NULL,380969904481,NULL,1615584213,'1',NULL,0,'','0'),
(5973,NULL,'Марущан Надія',NULL,'2021-04-21',NULL,380967653813,NULL,1567064161,'1',NULL,0,'','0'),
(5974,NULL,'Ласківська Наталя ',NULL,'2021-04-21',NULL,380678708748,NULL,1370453610,'1',NULL,0,'','0'),
(5975,NULL,'Тришак Іра ',NULL,'2021-04-21',NULL,380980587731,NULL,1924011185,'1',NULL,0,'','0'),
(5976,NULL,'Рембоха Марія ',NULL,'2021-04-22',NULL,380688448108,NULL,1175705646,'1',NULL,0,'','0'),
(5977,NULL,'Жиромська Таня ',NULL,'2021-04-22',NULL,380979244251,NULL,1118316919,'1',NULL,0,'','0'),
(5978,NULL,'продаж товару',NULL,'2021-04-22',NULL,380900000000,NULL,1824477138,'1',NULL,0,'','0'),
(5979,NULL,'Крашівська Марія',NULL,'2021-04-22',NULL,380977010406,NULL,1238239963,'1',NULL,0,'','0'),
(5980,NULL,'Дюк Юля',NULL,'2021-04-22',NULL,380677494625,NULL,1718663355,'1',NULL,1,'','0'),
(5981,NULL,'Семанюк Наталя ',NULL,'2021-04-23',NULL,380977622335,NULL,1568764386,'1',NULL,0,'','0'),
(5982,NULL,'Стефанюк Вікторія',NULL,'2021-04-23',NULL,380962542757,NULL,1321379699,'1',37389,0,'','0'),
(5983,NULL,'Талац Галина ',NULL,'2021-04-23',NULL,380971723542,NULL,1255678505,'1',NULL,0,'','0'),
(5984,NULL,'Федорчук Таня ',NULL,'2021-04-23',NULL,380964902996,NULL,1959319909,'1',NULL,0,'','0'),
(5985,NULL,'Ванжура Маряна',NULL,'2021-04-23',NULL,380963026337,NULL,1837539191,'1',NULL,1,'','0');

INSERT INTO `kontragentu` VALUES 
(5986,NULL,'Головата Діана',NULL,'2021-04-23',NULL,380686261093,NULL,1540240275,'1',NULL,0,'','0'),
(5987,NULL,'Ленчишин Анна',NULL,'2021-04-23',NULL,380988651161,NULL,1843248686,'1',NULL,0,'','0'),
(5988,NULL,'Підліпська Світлана',NULL,'2021-04-24',NULL,380685667916,NULL,1818423926,'1',NULL,0,'','0'),
(5989,NULL,'Ткаченко Оксана',NULL,'2021-04-24',NULL,380682062604,NULL,1612013333,'1',NULL,0,'','0'),
(6261,NULL,'Скочиляз Галина',NULL,'2021-06-26',NULL,380978435736,NULL,1138886258,'1',NULL,0,'','0'),
(5990,NULL,'Ковбель Інна','2000-12-03','2021-04-25',NULL,380993007037,NULL,1399710553,'1',28581,0,'','0'),
(5991,NULL,'Галат Василини',NULL,'2021-04-26',NULL,380982123430,NULL,1174368976,'1',NULL,0,'','0'),
(5992,NULL,'Заболотна Іра',NULL,'2021-04-26',NULL,380961394453,NULL,1777503323,'1',25798,0,'','0'),
(5993,NULL,'Сидор Галина ',NULL,'2021-04-26',NULL,380960677689,NULL,1637195884,'1',NULL,0,'','0'),
(5994,NULL,'Дворецька Лілія ',NULL,'2021-04-27',NULL,380993893948,NULL,1304722319,'1',NULL,0,'','0'),
(5995,NULL,'Ганущак Юля ',NULL,'2021-04-27',NULL,380990551044,NULL,1918363690,'1',NULL,0,'','0'),
(5996,NULL,'Черкас Любомира',NULL,'2021-04-27',NULL,380965506679,NULL,1878365728,'1',NULL,0,'','0'),
(5997,NULL,'тарас риж',NULL,'2021-04-27',NULL,380969598631,NULL,2071596685,'1',NULL,0,'','0'),
(5998,NULL,'Лещишин Тетяна ',NULL,'2021-04-27',NULL,380982665295,NULL,1400290402,'1',NULL,0,'','0'),
(5999,NULL,'Маленич Альона',NULL,'2021-04-28',NULL,380978192564,NULL,2010046263,'1',NULL,0,'','0'),
(6000,NULL,'Васильчук Альона',NULL,'2021-04-28',NULL,380961949413,NULL,1695408818,'1',NULL,0,'','0'),
(6001,NULL,'Зубик Микола ','1999-04-27','2021-04-28',NULL,380980158948,NULL,2063282906,'1',NULL,0,'','0'),
(6002,NULL,'Гарвасюк Олександра',NULL,'2021-04-29',NULL,380978606849,NULL,1198946128,'1',NULL,0,'','0'),
(6003,NULL,'Домінська Тетяна',NULL,'2021-04-29','8DeYpbODjLnUdFhBn2xxag==',380689041779,NULL,1144923206,'1',35270,0,'','0'),
(6004,NULL,'Стецько Галина',NULL,'2021-04-29',NULL,380970434235,NULL,1834825581,'1',NULL,0,'','0'),
(6005,NULL,'Копистинська Наталя',NULL,'2021-04-29',NULL,380966858374,NULL,1649083022,'1',NULL,0,'','0'),
(6006,NULL,'Буряковська Софія ','2005-05-21','2021-05-02',NULL,380686017443,NULL,1740965060,'1',NULL,0,'','0'),
(6007,NULL,'Наконечна Марія ',NULL,'2021-05-05',NULL,380967350578,NULL,1749620588,'1',NULL,0,'','0'),
(6008,NULL,'Ружило Тетяна',NULL,'2021-05-05',NULL,380686495970,NULL,1510520258,'1',NULL,0,'','0'),
(6009,NULL,'Васильчик Надія ',NULL,'2021-05-05',NULL,380675264347,NULL,2004268746,'1',NULL,0,'','0'),
(6010,NULL,'Храпа Ілона',NULL,'2021-05-05',NULL,380688496362,NULL,1255357598,'1',NULL,0,'','0'),
(6011,NULL,'Глущак Юля ',NULL,'2021-05-05',NULL,380681842355,NULL,1589832190,'1',NULL,0,'','0'),
(6012,NULL,'Павлина Марія',NULL,'2021-05-05',NULL,380995135443,NULL,1409117697,'1',NULL,0,'','0'),
(6013,NULL,'Котик Вікторія ',NULL,'2021-05-05',NULL,380979897401,NULL,1719458263,'1',NULL,0,'','0'),
(6014,NULL,'Котик Юля',NULL,'2021-05-05',NULL,380734178020,NULL,1352104609,'1',NULL,0,'','0'),
(6015,NULL,'Котик Зиновія ',NULL,'2021-05-05',NULL,380667448523,NULL,1218823851,'1',NULL,0,'','0'),
(6016,NULL,'Олійник Андріана','2006-11-22','2021-05-05',NULL,380968521331,NULL,1560754225,'1',NULL,0,'','0'),
(6017,NULL,'Цабан Юля',NULL,'2021-05-06',NULL,309690904108,NULL,1877375918,'1',NULL,0,'','0'),
(6018,NULL,'Катинська Любов',NULL,'2021-05-06',NULL,380966427044,NULL,1129848682,'1',NULL,0,'','0'),
(6019,NULL,'Мелимука Олеся',NULL,'2021-05-06',NULL,380682079479,NULL,1991945229,'1',NULL,1,'','0'),
(6020,NULL,'Черешньовська Марта ',NULL,'2021-05-06',NULL,380664386155,NULL,1165506700,'1',NULL,0,'','0'),
(6021,NULL,'Грицак Оля',NULL,'2021-05-06',NULL,380980625380,NULL,1828514471,'1',NULL,0,'','0'),
(6022,NULL,'Мандзюк Ірина ',NULL,'2021-05-06',NULL,380686568305,NULL,1422716483,'1',NULL,0,'','0'),
(6023,NULL,'Дячок Оксана',NULL,'2021-05-07',NULL,380967435051,NULL,1857093752,'1',NULL,0,'','0'),
(6024,NULL,'Лукаш Марія',NULL,'2021-05-07',NULL,380985477507,NULL,1712244157,'1',NULL,0,'','0'),
(6025,NULL,'Плингеу Галина',NULL,'2021-05-07',NULL,380968338283,NULL,2107467812,'1',NULL,0,'','0'),
(6026,NULL,'Іванців Олександра ',NULL,'2021-05-07',NULL,380666002533,NULL,1449994105,'1',NULL,0,'','0'),
(6027,NULL,'Рапіта Світлана',NULL,'2021-05-07',NULL,380967716680,NULL,1207041349,'1',NULL,0,'','0'),
(6028,NULL,'Олійник Оксана',NULL,'2021-05-07',NULL,380969282243,NULL,1200883600,'1',NULL,0,'','0'),
(6029,NULL,'Сорока Тетяна','2003-06-05','2021-05-08',NULL,380983866625,380983866654,1812482066,'1',24401,0,'','0'),
(6030,NULL,'Захарова Наталія','2006-09-08','2021-05-08',NULL,380975361591,380960402535,1989034312,'1',64947,0,'','0'),
(6031,NULL,'Маланюк Інна',NULL,'2021-05-10',NULL,380685126512,NULL,1261487672,'1',NULL,0,'','0'),
(6032,NULL,'Паславська Гана',NULL,'2021-05-10',NULL,380686260108,NULL,1902123237,'1',NULL,0,'','0'),
(6033,NULL,'Кузь Таня',NULL,'2021-05-10',NULL,380680987021,NULL,2009688693,'1',NULL,0,'','0'),
(6034,NULL,'Цибульська Марія ',NULL,'2021-05-10',NULL,380965764497,NULL,1666616964,'1',NULL,0,'','0'),
(6035,NULL,'Величко Галина',NULL,'2021-05-10',NULL,380673242982,NULL,1491895140,'1',NULL,0,'','0'),
(6036,NULL,'Демянів Івана ',NULL,'2021-05-11',NULL,380983373223,NULL,1453033093,'1',NULL,0,'','0'),
(6037,NULL,'Пастущак Наталія',NULL,'2021-05-11',NULL,380670097969,NULL,2116933608,'1',NULL,0,'','0'),
(6038,NULL,'Вербна Ліля',NULL,'2021-05-11',NULL,380965341242,NULL,1417287015,'1',NULL,0,'','0'),
(6039,NULL,'Ципліцька Марина',NULL,'2021-05-11',NULL,380989059938,NULL,1126645391,'1',NULL,0,'','0'),
(6040,NULL,'Гладьо Юлія',NULL,'2021-05-11',NULL,380676709626,NULL,2026484753,'1',NULL,0,'','0'),
(6041,NULL,'Багрій Марія',NULL,'2021-05-11',NULL,380671290910,NULL,1694971030,'1',NULL,0,'','0'),
(6042,NULL,'Лейбик Ліля',NULL,'2021-05-11',NULL,380683320784,NULL,1242013645,'1',NULL,0,'','0'),
(6043,NULL,'кушнерик таня',NULL,'2021-05-11',NULL,380689355051,NULL,1465174877,'1',NULL,0,'','0'),
(6044,NULL,'Садовяк ',NULL,'2021-05-11',NULL,380680927201,NULL,1404627451,'1',NULL,0,'','0'),
(6045,NULL,'Оріх Уляна',NULL,'2021-05-11',NULL,380689703285,NULL,1352900525,'1',NULL,0,'','0'),
(6046,NULL,'Чопик Ольга',NULL,'2021-05-11',NULL,380686077345,NULL,1948778995,'1',NULL,0,'','0'),
(6047,NULL,'Мерлавська Люба',NULL,'2021-05-11',NULL,380962866838,NULL,1846810244,'1',NULL,0,'','0'),
(6048,NULL,'Балик Олександра',NULL,'2021-05-12',NULL,380679042668,NULL,1835940100,'1',37440,0,'','0'),
(6049,NULL,'Ольшинецька Олеся',NULL,'2021-05-12',NULL,380961377230,NULL,1210263692,'1',NULL,0,'','0'),
(6050,NULL,'Конет Анна',NULL,'2021-05-12',NULL,380981003821,NULL,1410069713,'1',NULL,0,'','0'),
(6051,NULL,'Симоненко Віра',NULL,'2021-05-13',NULL,380500119552,NULL,1710391602,'1',NULL,0,'','0'),
(6052,NULL,'Федорків Анжела',NULL,'2021-05-13',NULL,380678869453,NULL,1380119562,'1',NULL,0,'','0'),
(6053,NULL,'Бабин Степан',NULL,'2021-05-13',NULL,380987363494,NULL,1136909987,'1',NULL,1,'','0'),
(6054,NULL,'Савчак Зоряна',NULL,'2021-05-13',NULL,380961331705,NULL,1985045433,'1',NULL,0,'','0'),
(6055,NULL,'Запотічна Христина ',NULL,'2021-05-13',NULL,380988373976,NULL,1753712099,'1',NULL,0,'','0'),
(6056,NULL,'Сушко Вікторія ',NULL,'2021-05-13',NULL,380983534552,NULL,1226414011,'1',NULL,3,'','0'),
(6057,NULL,'Смрляк Наталія',NULL,'2021-05-14',NULL,380988145508,NULL,2078350763,'1',NULL,0,'','0'),
(6058,NULL,'Погорецька Маряна',NULL,'2021-05-14',NULL,380684248225,NULL,1401253680,'1',NULL,0,'','0'),
(6059,NULL,'Дубчак Ірина ',NULL,'2021-05-14',NULL,380978094839,NULL,1527014982,'1',NULL,0,'','0'),
(6060,NULL,'Файчук Марина',NULL,'2021-05-14',NULL,380988100065,NULL,1227858593,'1',NULL,0,'','0'),
(6061,NULL,'Слоїк Зоряна',NULL,'2021-05-14',NULL,380686956781,NULL,1250662190,'1',NULL,0,'','0'),
(6062,NULL,'Кульчицька Надія','1974-03-07','2021-05-15',NULL,380671418439,NULL,1990048646,'1',38713,0,'','0'),
(6063,NULL,'Басіста Оксана ','1995-08-09','2021-05-16',NULL,380976145873,NULL,1396434539,'1',NULL,0,'','0'),
(6064,NULL,'Сорока Мар’яна ',NULL,'2021-05-16',NULL,380979971314,NULL,1249613875,'1',NULL,0,'','0'),
(6065,NULL,'Мала Наталія','1997-06-13','2021-05-16',NULL,380685895535,NULL,1591139115,'1',58160,0,'','0'),
(6066,NULL,'Федорович Таня ',NULL,'2021-05-17',NULL,380683238859,NULL,1908695115,'1',NULL,0,'','0'),
(6067,NULL,'Коваль Аня ',NULL,'2021-05-17',NULL,380679454719,NULL,2076239153,'1',NULL,0,'','0'),
(6068,NULL,'Оксана Грибок','1996-06-25','2021-05-17',NULL,380969917301,NULL,1919734835,'1',13151,0,'','0'),
(6069,NULL,'Гаврилюк Ірина',NULL,'2021-05-17',NULL,380965012379,NULL,1370868270,'1',NULL,0,'','0'),
(6070,NULL,'Яремій Роксолана ',NULL,'2021-05-17',NULL,380965583677,NULL,1279183672,'1',NULL,1,'','0'),
(6071,NULL,'Дідюк Вікторія ',NULL,'2021-05-17',NULL,380501493220,NULL,1614358239,'1',13473,0,'','0'),
(6072,NULL,'Тарнавська Діана ','2004-06-28','2021-05-17',NULL,380682216619,NULL,2105139560,'1',NULL,0,'','0'),
(6073,NULL,'Тарнавська Яна',NULL,'2021-05-18',NULL,380979280224,NULL,1357587152,'1',NULL,0,'','0'),
(6074,NULL,'Трофименко Руслана','1990-02-07','2021-05-18',NULL,380983886933,NULL,1501496083,'1',NULL,0,'','0'),
(6075,NULL,'Плішка Ірина',NULL,'2021-05-18',NULL,380684213590,NULL,1659770432,'1',NULL,0,'','0'),
(6076,NULL,'Мануляк Люба',NULL,'2021-05-19',NULL,380969413182,NULL,1873551535,'1',NULL,0,'','0'),
(6077,NULL,'Волощук Ольга ',NULL,'2021-05-19',NULL,380977835970,NULL,1625613662,'1',NULL,0,'','0'),
(6078,NULL,'Семанчук Вікторія','1996-02-07','2021-05-19',NULL,380969816840,NULL,1536435291,'1',NULL,0,'','0'),
(6079,NULL,'Правецька Лілія ',NULL,'2021-05-19',NULL,380966749562,NULL,1669727368,'1',NULL,0,'','0'),
(6080,NULL,'Суботіна Регіна ',NULL,'2021-05-20',NULL,380681477501,NULL,1191137940,'1',NULL,0,'','0'),
(6081,NULL,'Некребяк Валя',NULL,'2021-05-20',NULL,380685388612,NULL,2086164557,'1',NULL,0,'','0'),
(6082,NULL,'Ватраль Наталія',NULL,'2021-05-20',NULL,380962003716,NULL,1244603370,'1',NULL,0,'','0'),
(6083,NULL,'Присяжна Сніжана',NULL,'2021-05-20',NULL,380964708015,NULL,1261992877,'1',NULL,0,'','0'),
(6084,NULL,'Гаманюк Людмила',NULL,'2021-05-20',NULL,380686766961,NULL,1402155901,'1',26086,0,'','0'),
(6085,NULL,'Парасимчук Світлана ','1996-10-06','2021-05-20',NULL,380970107089,NULL,2125735683,'1',NULL,0,'','0'),
(6086,NULL,'Волочій Вікторія',NULL,'2021-05-21',NULL,380681977327,NULL,1184629868,'1',NULL,0,'','0'),
(6087,NULL,'Буряк Людмила',NULL,'2021-05-21',NULL,380968114850,NULL,1777531497,'1',NULL,0,'','0'),
(6088,NULL,'Качур Ірина',NULL,'2021-05-21',NULL,380685836338,NULL,2141433849,'1',NULL,0,'','0'),
(6089,NULL,'Слоньовська Галина',NULL,'2021-05-21',NULL,380683340164,NULL,1384013006,'1',NULL,0,'','0'),
(6090,NULL,'Бердецька Оксана',NULL,'2021-05-21',NULL,380971355405,NULL,1399521910,'1',NULL,0,'','0'),
(6091,NULL,'Лыпська Ана',NULL,'2021-05-22',NULL,380685122493,NULL,2028596201,'1',NULL,1,'','0'),
(6092,NULL,'попіль ілона',NULL,'2021-05-22',NULL,380988120687,NULL,1781524824,'1',NULL,0,'','0'),
(6093,NULL,'Низяк Аня ',NULL,'2021-05-22',NULL,380684614063,NULL,1735566385,'1',NULL,0,'','0'),
(6094,NULL,'Микуляк Оксана ',NULL,'2021-05-22',NULL,380687675493,NULL,1766276859,'1',NULL,0,'','0'),
(6095,NULL,'Безпалько Софія',NULL,'2021-05-22',NULL,380988708140,NULL,1917574103,'1',NULL,0,'','0'),
(6096,NULL,'Дюк Анастасія ',NULL,'2021-05-23',NULL,380962753488,NULL,1525323403,'1',NULL,0,'','0'),
(6097,NULL,'Долыба Валентина',NULL,'2021-05-24',NULL,380980385757,NULL,1236530497,'1',NULL,0,'','0'),
(6098,NULL,'Тракало Анастасія',NULL,'2021-05-24',NULL,380508856730,NULL,1384092930,'1',NULL,0,'','0'),
(6099,NULL,'Орловська Ліля ',NULL,'2021-05-24',NULL,380675287172,NULL,1443119394,'1',NULL,0,'','0'),
(6100,NULL,'Орішко Оля',NULL,'2021-05-24',NULL,380973080635,NULL,1962046404,'1',NULL,0,'','0'),
(6101,NULL,'Довгань Світлана',NULL,'2021-05-24',NULL,380973153944,NULL,1830507566,'1',NULL,1,'','0'),
(6726,NULL,'Гловань Наталя',NULL,'2021-09-17',NULL,380977862605,NULL,1455941110,'1',NULL,0,'','0'),
(6102,NULL,'Серединська Таня ',NULL,'2021-05-24',NULL,380977301424,NULL,1885481886,'1',NULL,0,'','0'),
(6103,NULL,'Смук Надія','1979-07-11','2021-05-24',NULL,380982432810,380682384483,1671911856,'1',NULL,0,'','0'),
(6104,NULL,'Танчик Надія ',NULL,'2021-05-25',NULL,380966584917,NULL,1263688337,'1',NULL,0,'','0'),
(6105,NULL,'Леснічук Христина',NULL,'2021-05-25',NULL,380687709640,NULL,1205183300,'1',NULL,0,'','0'),
(6777,NULL,'Зоряна Сасанчин','1972-01-01','2021-10-04','ueU7rYHV/K2B2DmT8vx+bA==',380985889275,NULL,1718720578,'1',NULL,0,'','0'),
(6106,NULL,'іра андрія кондиціонер донька',NULL,'2021-05-25',NULL,380986395382,NULL,1702982465,'1',NULL,0,'','0'),
(6107,NULL,'Василик Христина ',NULL,'2021-05-25',NULL,380983993348,NULL,1986964644,'1',NULL,0,'','0'),
(6108,NULL,'Дудар Вікторія',NULL,'2021-05-25',NULL,380984069216,NULL,1791026995,'1',NULL,0,'','0'),
(6109,NULL,'Равлів Наталя ',NULL,'2021-05-25',NULL,380687290812,NULL,1286315094,'1',NULL,0,'','0'),
(6110,NULL,'Дзьоник Ольга','1999-11-18','2021-05-25','wWZkcUgmUsqlG+vklsO9zA==',380661161784,NULL,1115337636,'1',47481,0,'','0'),
(6111,NULL,'Нікіфорова Софія',NULL,'2021-05-25',NULL,380987868309,NULL,1751874586,'1',41080,0,'','0'),
(6112,NULL,'Христіян Ірина',NULL,'2021-05-26',NULL,380960907659,NULL,1754820616,'1',NULL,0,'','0'),
(6113,NULL,'Гриненко Ольга',NULL,'2021-05-26',NULL,380988262850,NULL,1903309600,'1',NULL,0,'','0'),
(6114,NULL,'Ваньо Аліна',NULL,'2021-05-26',NULL,380971313874,NULL,1775147799,'1',NULL,0,'','0'),
(6115,NULL,'Паньків Світлана',NULL,'2021-05-26',NULL,380959479506,NULL,2038445165,'1',NULL,0,'','0'),
(6116,NULL,'Бабій Альбіна',NULL,'2021-05-26',NULL,380962732265,NULL,1634247251,'1',NULL,1,'','0'),
(6117,NULL,'Лещишин Ольга',NULL,'2021-05-26',NULL,380975677260,NULL,1403771123,'1',NULL,0,'','0'),
(6118,NULL,'Казимірко Маряна',NULL,'2021-05-26',NULL,380970722386,NULL,1187996243,'1',NULL,0,'','0'),
(6119,NULL,'Госович Ірина','1981-07-14','2021-05-27',NULL,380980034625,NULL,1511442504,'1',NULL,0,'','0'),
(6120,NULL,'Фкедорович Наталія',NULL,'2021-05-27',NULL,380973324044,NULL,1609806957,'1',NULL,0,'','0'),
(6121,NULL,'Слизяк наталя ',NULL,'2021-05-27',NULL,380683545086,NULL,1268192956,'1',NULL,0,'','0'),
(6122,NULL,'Ivanna Novotna','1990-01-08','2021-05-27',NULL,380504357739,NULL,1794897853,'1',NULL,0,'','0'),
(6123,NULL,'Яцишин Вероніка','2003-08-17','2021-05-28','c85a3KSeUM4kVRTMyBXQRg==',380686099357,NULL,1368865376,'1',NULL,0,'','0'),
(6124,NULL,'Присяжнюк Оксана',NULL,'2021-05-28',NULL,380976608501,NULL,1213195507,'1',NULL,0,'','0'),
(6125,NULL,'Задушиньська Ольга',NULL,'2021-05-28',NULL,380663868090,NULL,1749188702,'1',NULL,0,'','0'),
(6126,NULL,'Надія Курець','2002-07-04','2021-05-28',NULL,380962199661,NULL,1184045702,'1',28505,0,'','0'),
(6127,NULL,'Ківчак Аня',NULL,'2021-05-28',NULL,380987359468,NULL,1632685608,'1',62883,0,'','0'),
(6128,NULL,'Лаврик Христина','1998-12-01','2021-05-28',NULL,380989617506,NULL,1480108182,'1',65225,0,'','0'),
(6129,NULL,'Касюк Юля ',NULL,'2021-05-29',NULL,380678487413,NULL,1119004919,'1',NULL,0,'','0'),
(6130,NULL,'Леськів Тетяна','2005-11-25','2021-05-29','5/wodVhW9lOURDBiTQZKmg==',380986473809,NULL,1808150429,'1',NULL,0,'','0'),
(6131,NULL,'Нейко Руслана',NULL,'2021-05-29',NULL,380966848455,NULL,1201010657,'1',NULL,0,'','0'),
(6132,NULL,'Юзак Надія',NULL,'2021-05-29',NULL,380676076126,NULL,1463970932,'1',NULL,0,'','0'),
(6133,NULL,'Христя Оринчак ','2004-08-29','2021-05-30',NULL,380995232113,380995232113,1757228650,'1',NULL,0,'','0'),
(6134,NULL,'Скрипник Олена','2003-01-16','2021-05-30',NULL,380687248050,NULL,2131619574,'1',NULL,1,'','0'),
(6135,NULL,'Дмитрюк Тетяна',NULL,'2021-05-31',NULL,380965438409,NULL,1427165323,'1',NULL,0,'','0'),
(6136,NULL,'Федуха Наталя ',NULL,'2021-05-31',NULL,380980224906,NULL,1872398384,'1',NULL,0,'','0'),
(6137,NULL,'Філінчук Людмила',NULL,'2021-06-01',NULL,380988487742,NULL,1928466631,'1',NULL,0,'','0'),
(6138,NULL,'Костишин Марта',NULL,'2021-06-01',NULL,380986182665,NULL,1875473918,'1',NULL,0,'','0'),
(6139,NULL,'Семенюк Ольга ',NULL,'2021-06-01',NULL,380972970830,NULL,1196265126,'1',NULL,0,'','0'),
(6140,NULL,'Ілишин Наталія',NULL,'2021-06-01','o6jQctmYz89q5y8r6DqeKA==',380981085382,NULL,1287645041,'1',19549,0,'','0'),
(6141,NULL,'Кушнір Роксолана',NULL,'2021-06-02',NULL,380683354258,NULL,1603438191,'1',NULL,0,'','0'),
(6142,NULL,'Сторожук Вікторія',NULL,'2021-06-02',NULL,380660422419,NULL,1343261640,'1',NULL,0,'','0'),
(6143,NULL,'Дзиндра Оксана',NULL,'2021-06-02',NULL,380983251216,NULL,1686937343,'1',NULL,0,'','0'),
(6144,NULL,'Чупак Люда',NULL,'2021-06-02',NULL,380966928985,NULL,1311405127,'1',NULL,0,'','0'),
(6145,NULL,'Владика Тетяна','1999-08-14','2021-06-02',NULL,380960890933,NULL,1154424153,'1',57186,0,'','0'),
(6146,NULL,'Михайлишин Яна',NULL,'2021-06-02',NULL,380983657905,NULL,1439888996,'1',NULL,0,'','0'),
(6147,NULL,'Михайлишин Яна',NULL,'2021-06-02',NULL,380983651905,NULL,1141675159,'1',NULL,0,'','0'),
(6148,NULL,'Свинарчук Галина',NULL,'2021-06-02',NULL,380685090860,NULL,1593578618,'1',NULL,0,'','0'),
(6149,NULL,'Рогатин наталя',NULL,'2021-06-02',NULL,380686471605,NULL,1803716187,'1',NULL,0,'','0'),
(6150,NULL,'Королівська Галина',NULL,'2021-06-02',NULL,380987036165,NULL,1730675056,'1',NULL,0,'','0'),
(6151,NULL,'Слободян Руслана',NULL,'2021-06-02',NULL,380971495967,NULL,1155701498,'1',NULL,0,'','0'),
(6152,NULL,'Юрків Марія',NULL,'2021-06-02',NULL,380965361501,NULL,1682113265,'1',NULL,0,'','0'),
(6153,NULL,'Головчинська Людмила ',NULL,'2021-06-02',NULL,380973342764,NULL,2079599684,'1',NULL,0,'','0'),
(6154,NULL,'Петрусяк Ірина',NULL,'2021-06-03',NULL,380680027450,NULL,1336335040,'1',NULL,0,'','0'),
(6155,NULL,'Семчишин Ліда',NULL,'2021-06-03',NULL,380979466808,NULL,1593115057,'1',NULL,0,'','0'),
(6156,NULL,'Голик Юля ',NULL,'2021-06-03',NULL,380683941889,NULL,1638139819,'1',NULL,0,'','0'),
(6157,NULL,'Бучинська Марія',NULL,'2021-06-03',NULL,380969139945,NULL,1960628999,'1',NULL,0,'','0'),
(6158,NULL,'міщанчук Оксана',NULL,'2021-06-03',NULL,380685142514,NULL,1938938142,'1',NULL,1,'','0'),
(6159,NULL,'Копирка Аліна',NULL,'2021-06-03',NULL,380985380889,NULL,1674848823,'1',NULL,0,'','0'),
(6160,NULL,'Шепітко Наталя ',NULL,'2021-06-04',NULL,380960639907,NULL,1946567224,'1',NULL,0,'','0'),
(6161,NULL,'Дідик Марія',NULL,'2021-06-04',NULL,380685533975,NULL,1503086390,'1',NULL,1,'','0'),
(6162,NULL,'Медівський Віталій',NULL,'2021-06-04',NULL,380503588095,NULL,1471562700,'1',NULL,0,'','0'),
(6163,NULL,'Жиромська Іванка',NULL,'2021-06-04',NULL,380983655987,NULL,1306979781,'1',22257,0,'','0'),
(6164,NULL,'Богуш Тетяна',NULL,'2021-06-04',NULL,380976916983,NULL,2110191709,'1',NULL,0,'','0'),
(6165,NULL,'Стешин Марія ',NULL,NULL,NULL,380969678828,NULL,1172470184,'1',NULL,1,'','1'),
(6192,NULL,'Лопатинська Інна',NULL,'2021-06-12',NULL,380960786622,NULL,1774017931,'1',NULL,0,'','0'),
(6166,NULL,'Томчук Тоня','2006-08-04','2021-06-06',NULL,380954441614,NULL,1974218074,'1',NULL,0,'','0'),
(6167,NULL,'Касіян Таня','2000-04-16','2021-06-07',NULL,380958736881,380689041779,1722328409,'1',28960,0,'','0'),
(6168,NULL,'Беззубяк Дарія',NULL,'2021-06-07',NULL,380506050554,NULL,1336602585,'1',NULL,0,'','0'),
(6169,NULL,'Лиха Ірина','2021-04-29','2021-06-07',NULL,380684210426,380684210426,1132718577,'1',NULL,0,'','0'),
(6170,NULL,'Сеньків Світлана',NULL,'2021-06-07',NULL,380981035610,NULL,1697979355,'1',NULL,0,'','0'),
(6171,NULL,'Гуменюк Олена',NULL,'2021-06-07',NULL,380961096186,NULL,1923680546,'1',NULL,0,'','0'),
(6172,NULL,'Мосанюк Світлана',NULL,'2021-06-07',NULL,380961134488,NULL,1726428104,'1',NULL,0,'','0'),
(6173,NULL,'Маряна Слободян','1997-04-03','2021-06-07',NULL,380689689035,NULL,1466603511,'1',60573,0,'','0'),
(6174,NULL,'Вербицька Надія',NULL,'2021-06-07',NULL,380685523115,NULL,1506498055,'1',NULL,0,'','0'),
(6175,NULL,'Білик Олеся',NULL,'2021-06-07',NULL,380938927524,NULL,1399840089,'1',14800,0,'','0'),
(6176,NULL,'Дінко Христина ','1995-07-03','2021-06-07',NULL,380636004630,NULL,1126762659,'1',NULL,0,'','0'),
(6177,NULL,'Карбовська Лілія',NULL,'2021-06-08',NULL,380667449981,NULL,2067097026,'1',NULL,0,'','0'),
(6178,NULL,'Тетяна',NULL,'2021-06-08',NULL,380631778217,NULL,2087472914,'1',NULL,0,'','0'),
(6179,NULL,'Грещук Ала',NULL,'2021-06-08',NULL,380969877024,NULL,1591178778,'1',NULL,0,'','0'),
(6180,NULL,'Кузняк Мар’яна ',NULL,'2021-06-08',NULL,380672844385,NULL,1208752514,'1',NULL,0,'','0'),
(6181,NULL,'Гринишин Андріана','2003-12-09','2021-06-08',NULL,380680438696,380680438696,1823374282,'1',NULL,0,'м.Чортків','0'),
(6182,NULL,'Галина Зиновіївна',NULL,'2021-06-09',NULL,380689473815,NULL,1730654881,'1',NULL,0,'','0'),
(6183,NULL,'Пшик Юля',NULL,'2021-06-09',NULL,380686814014,NULL,1960575094,'1',NULL,0,'','0'),
(6185,NULL,'Майданик Аня ','1994-02-22','2021-06-09',NULL,380979682482,380986625975,1742685561,'1',NULL,0,'Добрий 
\n
\nТллорр ол дж
\n
\n','0'),
(6184,NULL,'Антошків Христина','1997-01-27','2021-06-09',NULL,380985396416,NULL,1378048047,'1',40426,0,'','0'),
(6186,NULL,'Толубяк Марія ',NULL,'2021-06-09',NULL,380972998154,NULL,1290050849,'1',NULL,0,'','0'),
(6187,NULL,'Трошин Оксана','1993-03-06','2021-06-10',NULL,380683238894,NULL,1384825162,'1',NULL,0,'','0'),
(6188,NULL,'Вітів Інна ',NULL,'2021-06-10',NULL,380961561639,NULL,1499233582,'1',NULL,0,'','0'),
(6189,NULL,'Щесняк Олена ',NULL,'2021-06-11',NULL,380978772949,NULL,1222206362,'1',NULL,0,'','0'),
(6190,NULL,'Бунікеич Оля',NULL,'2021-06-11',NULL,380990367730,NULL,1671470763,'1',NULL,0,'','0'),
(6191,NULL,'войтович наталя',NULL,'2021-06-11',NULL,380969404640,NULL,1302098463,'1',NULL,0,'','0'),
(6193,NULL,'Тьотя Оля ',NULL,'2021-06-12',NULL,380962832727,NULL,1857341542,'1',NULL,0,'','0'),
(6194,NULL,'Хандій Мар‘яна','1991-01-02','2021-06-12','eS6LHxDBCrpcWwlu2oh3cw==',380965705772,NULL,2119805106,'1',NULL,0,'','0'),
(6195,NULL,'Маланюк Діана',NULL,'2021-06-12',NULL,380989870030,NULL,1260634379,'1',NULL,0,'','0'),
(6196,NULL,'Сорока Люба',NULL,'2021-06-13',NULL,380678415616,NULL,1589369620,'1',NULL,0,'','0'),
(6197,NULL,'Завісляк Оксана','2007-07-27','2021-06-13',NULL,380685480162,NULL,1459927158,'1',60081,0,'','0'),
(6198,NULL,'Вівчарик Таня ',NULL,'2021-06-13',NULL,380671091449,NULL,1722529999,'1',NULL,0,'','0'),
(6199,NULL,'Король Юля',NULL,'2021-06-14','xORYkgHNvaGA8aZO33BQiw==',380684134644,NULL,1508655892,'1',60130,0,'','0'),
(6200,NULL,'Лавренчук ірина',NULL,'2021-06-14',NULL,380972652067,NULL,1278214696,'1',NULL,0,'','0'),
(6201,NULL,'Лис Василина',NULL,'2021-06-14',NULL,380677324185,NULL,1193240788,'1',NULL,0,'','0'),
(6202,NULL,'Пандрак Аліна',NULL,'2021-06-14',NULL,380987374763,NULL,1893691437,'1',NULL,0,'','0'),
(6203,NULL,'Гафин Івана',NULL,'2021-06-14',NULL,380686758744,NULL,2021356858,'1',NULL,0,'','0'),
(6204,NULL,'гафин Андрівна',NULL,'2021-06-14',NULL,380984589250,NULL,1771232543,'1',NULL,0,'','0'),
(6205,NULL,'Дутка Віра',NULL,'2021-06-15',NULL,380985474916,NULL,1435455514,'1',NULL,0,'','0'),
(6206,NULL,'Буїв Марія ',NULL,'2021-06-15',NULL,380678506129,NULL,1761883144,'1',NULL,0,'','0'),
(6207,NULL,'Франків катерина',NULL,'2021-06-15',NULL,380972056143,NULL,1580743560,'1',NULL,0,'','0'),
(6208,NULL,'Срібна Іра',NULL,'2021-06-15',NULL,380965624991,NULL,1851895893,'1',NULL,0,'','0'),
(6209,NULL,'Котузяк Таня',NULL,'2021-06-15',NULL,380986626359,NULL,1511781231,'1',NULL,0,'','0'),
(6210,NULL,'Воробець Яна',NULL,'2021-06-15',NULL,380973381903,NULL,2106311607,'1',NULL,0,'','0'),
(6211,NULL,'Петришин Юля ',NULL,'2021-06-15',NULL,380975839189,NULL,1733731396,'1',NULL,0,'','0'),
(6212,NULL,'Тетенькіна Аліна','1993-05-01','2021-06-15',NULL,380734979174,NULL,1202840879,'1',NULL,0,'Доброго дня. Я тут проїздом, в батька стався інсульт повторний, тому потрібно в першій половині дня ','0'),
(6213,NULL,'Ліда ',NULL,'2021-06-16',NULL,380663030231,NULL,1217081357,'1',NULL,0,'','0'),
(6214,NULL,'Кручак Надія',NULL,'2021-06-16',NULL,380680018047,NULL,1562962399,'1',NULL,0,'','0'),
(6215,NULL,'Митник Таня',NULL,'2021-06-16',NULL,380980272683,NULL,1712352264,'1',NULL,0,'','0'),
(6216,NULL,'Маланюк Ірина',NULL,'2021-06-16',NULL,380686125864,NULL,1965821187,'1',NULL,0,'','0'),
(6217,NULL,'Федорків Аніта ',NULL,'2021-06-16',NULL,380985817998,NULL,2108222525,'1',NULL,0,'','0'),
(6218,NULL,'Борис Оксана ',NULL,'2021-06-16',NULL,380970111456,NULL,1803324289,'1',NULL,0,'','0'),
(6219,NULL,'Шмакова Тетяна',NULL,'2021-06-16',NULL,380660887782,NULL,2107947544,'1',NULL,0,'','0'),
(6220,NULL,'Іванців Анастасія',NULL,'2021-06-16',NULL,380953996755,NULL,1322220557,'1',NULL,0,'','0'),
(6222,NULL,'Козловська Філомена ',NULL,'2021-06-17',NULL,380675534799,NULL,1815208696,'1',NULL,0,'','0'),
(6223,NULL,'Ангел Марія',NULL,'2021-06-17',NULL,380682384537,NULL,2052997122,'1',NULL,0,'','0'),
(6224,NULL,'Габяк ',NULL,'2021-06-17',NULL,380678469733,NULL,2018908181,'1',NULL,0,'','0'),
(6225,NULL,'Двоєглазова Ельвіра ','2000-09-20','2021-06-17',NULL,380689041513,NULL,1474735163,'1',NULL,0,'','0'),
(6226,NULL,'Хреник Леся','1993-08-13','2021-06-18',NULL,380680325877,NULL,2006914650,'1',NULL,0,'','0'),
(6227,NULL,'Басіста Івана',NULL,'2021-06-18',NULL,380984133611,NULL,2028232347,'1',NULL,0,'','0'),
(6228,NULL,'Недільський Віталій',NULL,'2021-06-18',NULL,380980770422,NULL,1829236606,'1',NULL,0,'','0'),
(6229,NULL,'Чепига Ірина ',NULL,'2021-06-18',NULL,380987266048,NULL,1350720295,'1',NULL,0,'','0'),
(6230,NULL,'Сандецька Аліна',NULL,'2021-06-18',NULL,380969854679,NULL,1992593821,'1',NULL,0,'','0'),
(6427,NULL,'Оксана Коцюк','1991-06-02','2021-07-23',NULL,380961902515,NULL,1487442004,'1',27365,0,'','0'),
(6232,NULL,'Гейна Оксана ','2006-07-15','2021-06-21',NULL,380980999796,NULL,1421289900,'1',28999,0,'','0'),
(6233,NULL,'Дражньовська Тетяна ',NULL,'2021-06-21',NULL,380975449180,NULL,1533520542,'1',NULL,0,'','0'),
(6234,NULL,'Цьомик Оля ',NULL,'2021-06-22',NULL,380960808924,NULL,1965391091,'1',NULL,0,'','0'),
(6235,NULL,'Цьомик Оксана',NULL,'2021-06-22',NULL,380674823154,NULL,1361022174,'1',NULL,0,'','0'),
(6236,NULL,'Слозанська Юля ',NULL,'2021-06-22',NULL,380979892423,NULL,1887260431,'1',NULL,0,'','0'),
(6237,NULL,'прадивус Таня ',NULL,'2021-06-22',NULL,380680733959,NULL,1211494187,'1',NULL,0,'','0'),
(6238,NULL,'Гусак Людмила',NULL,'2021-06-22',NULL,380988029251,NULL,1973161167,'1',NULL,0,'','0'),
(6239,NULL,'Музика Оля',NULL,'2021-06-22',NULL,380968577519,NULL,1427803048,'1',42257,0,'','0'),
(6240,NULL,'Музичка Уляна',NULL,'2021-06-23',NULL,380978106796,NULL,1328259578,'1',NULL,0,'','0'),
(6241,NULL,'Синовіцька Івана',NULL,'2021-06-23',NULL,380674752627,NULL,1754854119,'1',NULL,0,'','0'),
(6242,NULL,'Роман Олександра',NULL,'2021-06-23',NULL,380673076483,NULL,1116589958,'1',NULL,0,'','0'),
(6243,NULL,'Стефанків Таня ',NULL,'2021-06-23',NULL,380684596701,NULL,1172640450,'1',NULL,0,'','0'),
(6244,NULL,'Ємчук Юлія',NULL,'2021-06-23',NULL,380980862187,NULL,1255006414,'1',NULL,0,'','0'),
(6245,NULL,'Голояд Тетяна',NULL,'2021-06-23',NULL,380989701275,NULL,1740355033,'1',NULL,0,'','0'),
(6246,NULL,'Mariana Pratsovyta','1989-06-15','2021-06-23','Cczsw0hEYkdzq6VOOHpzBQ==',380969028375,NULL,1351250493,'1',43944,0,'','0'),
(6247,NULL,'Коник Люба',NULL,'2021-06-24',NULL,380668829077,NULL,2014990946,'1',NULL,0,'','0'),
(6248,NULL,'Дякун Леся',NULL,'2021-06-24',NULL,380687664952,NULL,1128631420,'1',NULL,0,'','0'),
(6249,NULL,'Бадлюк Марія ',NULL,'2021-06-24',NULL,380971938633,NULL,1346235081,'1',60043,0,'','0'),
(6250,NULL,'Ноклей Маряна',NULL,'2021-06-24',NULL,380676535095,NULL,1576248276,'1',NULL,0,'','0'),
(6251,NULL,'Березовська ірина',NULL,'2021-06-24',NULL,380967755944,NULL,2072543280,'1',NULL,0,'','0'),
(6252,NULL,'Кушнір Ліля',NULL,'2021-06-24',NULL,380666560381,NULL,1293078913,'1',NULL,0,'','0'),
(6253,NULL,'Бойчук Віка',NULL,'2021-06-24',NULL,380985170938,NULL,1640475686,'1',NULL,1,'','0'),
(6254,NULL,'Коріньовська Олеся',NULL,'2021-06-24',NULL,380678342980,NULL,1231468242,'1',NULL,0,'','0'),
(6276,NULL,'Степанчук Мая',NULL,'2021-06-29',NULL,380984688623,NULL,1251949146,'1',NULL,0,'','0'),
(6255,NULL,'Лесик Софія',NULL,'2021-06-24',NULL,380979508717,NULL,2063456919,'1',NULL,0,'','0'),
(6256,NULL,'Бітківська Оксана ',NULL,'2021-06-24',NULL,380993126444,NULL,1881086857,'1',NULL,0,'','0'),
(6257,NULL,'ЗАХАРЧУК ЛЫДА',NULL,'2021-06-24',NULL,380989206719,NULL,1815054509,'1',NULL,0,'','0'),
(6258,NULL,'Гайовська Тетяна ',NULL,'2021-06-24',NULL,380687967640,NULL,1258326738,'1',NULL,0,'','0'),
(6259,NULL,'Таня Вільгард','1984-03-13','2021-06-25',NULL,380966833805,380966822805,2082541790,'1',NULL,0,'','0'),
(6260,NULL,'Слома Олена ',NULL,'2021-06-25',NULL,380981287072,NULL,1132076342,'1',22301,0,'','0'),
(6262,NULL,'Налвайко Оксана',NULL,'2021-06-26','TV5cVBX66QNkHRcQtTejug==',380970041065,NULL,1481223142,'1',NULL,0,'','0'),
(6263,NULL,'Кльоб надія ',NULL,'2021-06-26',NULL,380983946399,NULL,1192457397,'1',NULL,0,'','0'),
(6264,NULL,'Мутка Наталія ',NULL,'2021-06-26',NULL,380997670734,NULL,2103474592,'1',NULL,0,'','0'),
(6265,NULL,'Мандар Олеся','1998-09-20','2021-06-27',NULL,380970624251,NULL,1592331032,'1',46999,0,'','0'),
(6266,NULL,'Долик Христина','2000-07-06','2021-06-27',NULL,380686743229,NULL,1484297146,'1',NULL,0,'
\n
\n
\n
\n
\n','0'),
(6267,NULL,'Karolina Slavina','1999-04-23','2021-06-28',NULL,380687033124,NULL,1765954528,'1',62538,2,'','0'),
(6268,NULL,'Рудик Марія ',NULL,'2021-06-28',NULL,380987289574,NULL,1338284292,'1',NULL,1,'','0'),
(6269,NULL,'Дозорців Олена',NULL,'2021-06-28',NULL,380970810368,NULL,1538043198,'1',NULL,0,'','0'),
(6270,NULL,'Діана ','1997-01-03','2021-06-28',NULL,380631304822,NULL,1682724532,'1',16389,0,'','0'),
(6271,NULL,'Савчук Анастасія',NULL,'2021-06-28',NULL,380993017387,NULL,1621803380,'1',NULL,0,'','0'),
(6272,NULL,'Свергун Юлія',NULL,'2021-06-28',NULL,380987363969,NULL,1153490613,'1',NULL,0,'','0'),
(6273,NULL,'Корол Надія ',NULL,'2021-06-28',NULL,380966012165,NULL,1777946569,'1',NULL,0,'','0'),
(6274,NULL,'Танасів Тетяна',NULL,'2021-06-28',NULL,380964973521,NULL,1517942466,'1',NULL,0,'','0'),
(6275,NULL,'Бадлюк Марія',NULL,'2021-06-28',NULL,380685338786,NULL,2052786863,'1',NULL,0,'','0'),
(6277,NULL,'Сташків Олена ','2000-06-22','2021-06-29',NULL,380986475586,NULL,1398057186,'1',NULL,0,'','0'),
(6278,NULL,'Жиркова Тетяна ',NULL,'2021-06-29',NULL,380980896858,NULL,1465222823,'1',NULL,0,'','0'),
(6279,NULL,'Гусак Людмила',NULL,'2021-06-29',NULL,380686027500,NULL,1891254240,'1',NULL,0,'','0'),
(6280,NULL,'Савків Наталія ',NULL,'2021-06-29',NULL,380988902377,NULL,1656418622,'1',NULL,0,'','0'),
(6510,NULL,'Хабінець Вікторія ','2000-07-08','2021-08-05',NULL,380981012685,NULL,1788572049,'1',NULL,0,'','0'),
(6664,NULL,'Тарасенко Олеся',NULL,'2021-09-04',NULL,380662798457,NULL,1582690830,'1',NULL,0,'','0'),
(6281,NULL,'Токальська Ірина',NULL,'2021-06-29',NULL,380683334153,NULL,1462440265,'1',NULL,0,'','0'),
(6282,NULL,'Гащиць Маряна',NULL,'2021-06-30',NULL,380686498042,NULL,1434343887,'1',NULL,0,'','0'),
(6283,NULL,'Штокал христина','1992-05-21','2021-06-30',NULL,380992720324,NULL,1850833058,'1',NULL,0,'','0'),
(6284,NULL,'Стрембіцька Євгенія',NULL,'2021-06-30',NULL,380966450397,NULL,1988564784,'1',NULL,0,'','0'),
(6285,NULL,'Хомяк Яна',NULL,'2021-06-30',NULL,380683675322,NULL,1439608740,'1',NULL,0,'','0'),
(6286,NULL,'Гадиняк Марія ',NULL,'2021-06-30',NULL,380977887897,NULL,1570140453,'1',NULL,0,'','0'),
(6287,NULL,'Івасів Надія ',NULL,'2021-07-01',NULL,380973715975,NULL,1689056302,'1',NULL,0,'','0'),
(6288,NULL,'Горлач Катерина',NULL,'2021-07-01',NULL,380688504492,NULL,1627293875,'1',NULL,0,'','0'),
(6289,NULL,'Тракало Галина',NULL,'2021-07-01',NULL,380680411183,NULL,1782990264,'1',NULL,0,'','0'),
(6290,NULL,'Макух Ліля ',NULL,'2021-07-01',NULL,380684563201,NULL,1691967206,'1',NULL,0,'','0'),
(6291,NULL,'Батрин Наталя ',NULL,'2021-07-02',NULL,380680547693,NULL,1213088315,'1',NULL,0,'','0'),
(6292,NULL,'Бодьо іІрина',NULL,'2021-07-02',NULL,380671289160,NULL,1980299379,'1',NULL,0,'','0'),
(6293,NULL,'Збудовська Ольга',NULL,'2021-07-02',NULL,380969060045,NULL,1623421846,'1',NULL,0,'','0'),
(6294,NULL,'Вархол Ірина',NULL,'2021-07-02',NULL,380684212173,NULL,1520612888,'1',NULL,0,'','0'),
(6296,NULL,'Тібекіна Настя ',NULL,'2021-07-03',NULL,380973136212,NULL,1754247313,'1',NULL,0,'','0'),
(6297,NULL,'Янчук Любов',NULL,'2021-07-03',NULL,380984244695,NULL,1785465277,'1',NULL,0,'','0'),
(6298,NULL,'Василенька Наталя',NULL,'2021-07-03',NULL,380966823633,NULL,2084320323,'1',NULL,0,'','0'),
(6299,NULL,'Марунька Юлія',NULL,'2021-07-03',NULL,380502013008,NULL,1547562837,'1',NULL,0,'','0'),
(6300,NULL,'Концограда Світлана ',NULL,'2021-07-03',NULL,380978171998,NULL,1467926312,'1',NULL,0,'','0'),
(6301,NULL,'Конет Оксана',NULL,'2021-07-03',NULL,380970808246,NULL,1221134970,'1',NULL,0,'','0'),
(6302,NULL,'Гнатишин Анастасія','1998-02-21','2021-07-04',NULL,380983424670,NULL,1753491472,'1',NULL,0,'','0'),
(6303,NULL,'Мельник Діяна',NULL,'2021-07-04',NULL,380683230112,NULL,1549519099,'1',NULL,1,'','0'),
(6304,NULL,'Войчишин Ірина ',NULL,'2021-07-05',NULL,380502018348,NULL,1851549384,'1',NULL,0,'','0'),
(6305,NULL,'Совяк Марія',NULL,'2021-07-05',NULL,380935336521,NULL,1729536668,'1',NULL,0,'','0'),
(6562,NULL,'Нога Наталія ',NULL,'2021-08-16',NULL,380682441094,NULL,1761046954,'1',NULL,0,'','0'),
(6306,NULL,'Харів Юля',NULL,'2021-07-05',NULL,380689489508,NULL,1700394811,'1',NULL,0,'','0'),
(6307,NULL,'Храпко Діана',NULL,'2021-07-05',NULL,380988902274,NULL,2079872841,'1',NULL,0,'','0'),
(6308,NULL,'Івахів Оксана',NULL,'2021-07-05',NULL,380679958411,NULL,1465126449,'1',NULL,0,'','0'),
(6309,NULL,'Касприк Галина',NULL,'2021-07-05',NULL,380970190327,NULL,1622774302,'1',NULL,0,'','0'),
(6310,NULL,'Пирч Христина',NULL,'2021-07-05',NULL,380988057783,NULL,1744840230,'1',NULL,0,'','0'),
(6311,NULL,'Гермак Любов',NULL,'2021-07-05',NULL,380984512552,NULL,1149358081,'1',NULL,0,'','0'),
(6312,NULL,'Томіцький Степан',NULL,'2021-07-05',NULL,380505646718,NULL,1868009534,'1',NULL,0,'','0'),
(6313,NULL,'Николишин Марія',NULL,'2021-07-05',NULL,380986687200,NULL,2137662889,'1',NULL,0,'','0'),
(6314,NULL,'Дитиняк Мая ',NULL,'2021-07-05',NULL,380680549466,NULL,2125336925,'1',NULL,0,'','0'),
(6315,NULL,'Цибульський Сергіій',NULL,'2021-07-05',NULL,380960287097,NULL,1706227529,'1',NULL,0,'','0'),
(6316,NULL,'Мерлавська Наталя',NULL,'2021-07-05',NULL,380684242161,NULL,1497313903,'1',NULL,0,'','0'),
(6317,NULL,'Бикалюк Маряна',NULL,'2021-07-05',NULL,380685731095,NULL,1334406812,'1',NULL,0,'','0'),
(6318,NULL,'Римар Оля',NULL,'2021-07-05',NULL,380976220484,NULL,1361440384,'1',NULL,0,'','0'),
(6319,NULL,'Леськів Оля',NULL,'2021-07-05',NULL,380968367819,NULL,1657528273,'1',NULL,0,'','0'),
(6320,NULL,'Говіка Оксана','1995-04-01','2021-07-05',NULL,380978248051,NULL,1341991693,'1',NULL,0,'','0'),
(6321,NULL,'Доскочинська Олександра',NULL,'2021-07-06',NULL,380976592790,NULL,1452834024,'1',NULL,0,'','0'),
(6322,NULL,'Остафійчук Уляна','1992-08-21','2021-07-06',NULL,380986359449,NULL,1988051847,'1',NULL,0,'','0'),
(6323,NULL,'Нагайовська Юля',NULL,'2021-07-06',NULL,380677679014,NULL,1433002272,'1',NULL,0,'','0'),
(6324,NULL,'Котик Аліна',NULL,'2021-07-06',NULL,380679843362,NULL,1844629545,'1',NULL,0,'','0'),
(6325,NULL,'Янік Тетяна',NULL,'2021-07-06',NULL,380977654609,NULL,1195358211,'1',NULL,0,'','0'),
(6326,NULL,'Гащиць Софія',NULL,'2021-07-06',NULL,380636817583,NULL,1349920505,'1',NULL,0,'','0'),
(6327,NULL,'Шабатівська Теттяна',NULL,'2021-07-06',NULL,380968659252,NULL,1119892635,'1',NULL,0,'','0'),
(6328,NULL,'Дутчак Людмила',NULL,'2021-07-06',NULL,380982520750,NULL,1931578277,'1',NULL,0,'','0'),
(6329,NULL,'Костик Люда',NULL,'2021-07-06',NULL,380983163039,NULL,1594715088,'1',NULL,0,'','0'),
(6330,NULL,'Солодяк Зоряна',NULL,'2021-07-06',NULL,380958511620,NULL,2135336698,'1',NULL,0,'','0'),
(6331,NULL,'Чулик Оксана',NULL,'2021-07-06',NULL,380970208425,NULL,2142342155,'1',NULL,0,'','0'),
(6332,NULL,'Николайчук Ангеліна',NULL,'2021-07-06',NULL,380678822285,NULL,2004135518,'1',NULL,0,'','0'),
(6333,NULL,'Смагула Наталя',NULL,'2021-07-06',NULL,380979039538,NULL,1770275699,'1',NULL,0,'','0'),
(6334,NULL,'Процанін Христина','2002-04-16','2021-07-06','VpR1ZjfjQSwMPrrjo7+0aQ==',380675856706,NULL,1185828178,'1',44906,0,'','0'),
(6335,NULL,'Кушнір Валентина',NULL,'2021-07-06',NULL,380689056693,NULL,1181412610,'1',NULL,0,'','0'),
(6336,NULL,'Сливчук Оксана','1977-10-03','2021-07-07',NULL,380687968210,NULL,1698552595,'1',14418,0,'','0'),
(6337,NULL,'Тарковська Олеся ','1999-04-07','2021-07-08',NULL,380974150771,NULL,1885831260,'1',NULL,0,'','0'),
(6338,NULL,'Сливчук Оксана',NULL,'2021-07-08',NULL,380685221027,NULL,1704797508,'1',NULL,0,'','0'),
(6339,NULL,'Гнатишин Михайло',NULL,'2021-07-08',NULL,380969814235,NULL,1498566783,'1',NULL,0,'','0'),
(6340,NULL,'Шаманська надія',NULL,'2021-07-08',NULL,380988488166,NULL,1332641170,'1',NULL,0,'','0'),
(6341,NULL,'Яковлюк Людмила',NULL,'2021-07-08',NULL,380688425004,NULL,1450747489,'1',NULL,0,'','0'),
(6342,NULL,'Чайковська Ірина',NULL,'2021-07-08',NULL,380668719056,NULL,1873359381,'1',NULL,0,'','0'),
(6343,NULL,'Лебедєва Маряна',NULL,'2021-07-08',NULL,380683149083,NULL,1703378990,'1',NULL,0,'','0'),
(6344,NULL,'Мельник Юлія',NULL,'2021-07-08',NULL,380970749759,NULL,1123198145,'1',NULL,0,'','0'),
(6345,NULL,'Марія Осьмак','1998-03-08','2021-07-09',NULL,380980445615,380687173420,1797028740,'1',31546,0,'','0'),
(6346,NULL,'Цимбалюк Надія',NULL,'2021-07-09',NULL,380987245669,NULL,1316147930,'1',NULL,0,'','0'),
(6347,NULL,'Іскра Оксана',NULL,'2021-07-09',NULL,380965526119,NULL,2094580090,'1',NULL,0,'','0'),
(6348,NULL,'Ковпак Кляна',NULL,'2021-07-09',NULL,380989524895,NULL,1458956257,'1',NULL,0,'','0'),
(6349,NULL,'Гінда Леся',NULL,'2021-07-09',NULL,380976565584,NULL,1895646465,'1',NULL,0,'','0'),
(6350,NULL,'Заплацінська Таня',NULL,'2021-07-09',NULL,380689376142,NULL,1929759944,'1',NULL,0,'','0'),
(6351,NULL,'Николишин Тетяна',NULL,'2021-07-09',NULL,380986687202,NULL,1384192754,'1',NULL,0,'','0'),
(6352,NULL,'Плішка Оля','2000-04-05','2021-07-09',NULL,380961928652,NULL,1575516660,'1',NULL,0,'','0'),
(6353,NULL,'Опіхана Олнксандра',NULL,'2021-07-09',NULL,380986354758,NULL,1780191955,'1',NULL,0,'','0'),
(6354,NULL,'Гавриляк Діана',NULL,'2021-07-09',NULL,380976044112,NULL,1581671154,'1',NULL,0,'','0'),
(6355,NULL,'Яницька Галина',NULL,'2021-07-09',NULL,380974318904,NULL,1477434044,'1',NULL,0,'','0'),
(6356,NULL,'Яницька Юля',NULL,'2021-07-09',NULL,380979505870,NULL,2066489968,'1',NULL,0,'','0'),
(6357,NULL,'Гоменчук Людмила ','2001-12-16','2021-07-09',NULL,380680208009,380680208009,1236393168,'1',59997,0,'','0'),
(6358,NULL,'Пшик Марія ',NULL,'2021-07-09',NULL,380989917800,NULL,2133408836,'1',NULL,0,'','0'),
(6359,NULL,'Москалюк Катерина',NULL,'2021-07-10',NULL,380970803686,NULL,1468232107,'1',NULL,0,'','0'),
(6360,NULL,'Голик Максим',NULL,'2021-07-10',NULL,380970041088,NULL,1566716893,'1',NULL,0,'','0'),
(6361,NULL,'Марія Білецька ','2002-10-12','2021-07-10',NULL,380680360106,NULL,1856689901,'1',NULL,0,'','0'),
(6362,NULL,'Ваврушко Анастасія',NULL,'2021-07-10',NULL,380988818629,NULL,2061294138,'1',26098,0,'','0'),
(6363,NULL,'Говдан Ірина','1995-04-22','2021-07-12',NULL,380508299785,NULL,1590974699,'1',NULL,0,'','0'),
(6364,NULL,'Гавриляк Аліна ',NULL,'2021-07-13',NULL,380682792235,NULL,1694925538,'1',NULL,0,'','0'),
(6365,NULL,'Гаврилюк надія ',NULL,'2021-07-13',NULL,380672680405,NULL,1364435623,'1',NULL,0,'','0'),
(6366,NULL,'Гашок Надія',NULL,'2021-07-13',NULL,380980522482,NULL,1271451929,'1',NULL,0,'','0'),
(6367,NULL,'Слозанська Юлія',NULL,'2021-07-13',NULL,380971939359,NULL,1681947437,'1',NULL,0,'','0'),
(6368,NULL,'Цимбала Наталя ',NULL,'2021-07-13',NULL,380989243394,NULL,1120042123,'1',NULL,0,'','0'),
(6369,NULL,'МЕНДИК ТЕТТЯНА',NULL,'2021-07-13',NULL,380985774972,NULL,1916258282,'1',NULL,0,'','0'),
(6371,NULL,'Босяк Надія',NULL,'2021-07-14',NULL,380982447926,NULL,2018469585,'1',NULL,0,'','0'),
(6372,NULL,'Огородник Віра ',NULL,'2021-07-14',NULL,380961394978,NULL,1599504174,'1',NULL,0,'','0'),
(6373,NULL,'Дкргачова Зоряна',NULL,'2021-07-14',NULL,380933703164,NULL,1410698933,'1',NULL,0,'','0'),
(6374,NULL,'Дідюк Сніжана',NULL,'2021-07-14',NULL,380962127706,NULL,1620537945,'1',NULL,0,'','0'),
(6375,NULL,'Гніданик Леся ',NULL,'2021-07-14',NULL,380686497547,NULL,1732062641,'1',NULL,0,'','0'),
(6376,NULL,'Савка Тетяна ',NULL,'2021-07-14',NULL,380685049399,NULL,1629669295,'1',NULL,0,'','0'),
(6377,NULL,'Савка Світлана ',NULL,'2021-07-14',NULL,380963532128,NULL,1936763517,'1',NULL,0,'','0'),
(6378,NULL,'Матяш Ірина',NULL,'2021-07-15',NULL,380684289011,NULL,2060474553,'1',NULL,0,'','0'),
(6379,NULL,'Градова Яна',NULL,'2021-07-15',NULL,380664390293,NULL,2117849379,'1',NULL,0,'','0'),
(6380,NULL,'Кирилів Софія','2007-09-23','2021-07-15',NULL,380965131659,NULL,1498017518,'1',31878,0,'','0'),
(6381,NULL,'Андрівш Ірина',NULL,'2021-07-15',NULL,380971335059,NULL,1768843916,'1',NULL,0,'','0'),
(6382,NULL,'Прокопів Марія',NULL,'2021-07-15',NULL,380967875718,NULL,1957073586,'1',NULL,0,'','0'),
(6383,NULL,'Іванців Анастасія',NULL,'2021-07-15',NULL,380954047598,NULL,1866669549,'1',NULL,0,'','0'),
(6384,NULL,'Оксана Сегін','1985-10-23','2021-07-16',NULL,380979907047,NULL,1906269445,'1',NULL,0,'
\n','0'),
(6385,NULL,'Лапій Ірина',NULL,'2021-07-16',NULL,380632770940,NULL,2056400360,'1',NULL,0,'','0'),
(6386,NULL,'Посіда Христина','2002-08-27','2021-07-16',NULL,380971772749,NULL,1801295062,'1',NULL,0,'','0'),
(6388,NULL,'Семенюк  Олександра',NULL,'2021-07-16',NULL,380687290816,NULL,1809658926,'1',NULL,0,'','0'),
(6389,NULL,'Пшенична Катя',NULL,'2021-07-17',NULL,380505316709,NULL,1249374350,'1',NULL,0,'','0'),
(6390,NULL,'Глух Надія',NULL,'2021-07-17',NULL,380963998815,NULL,1131118818,'1',NULL,1,'','0'),
(6391,NULL,'Березовська Євгенія',NULL,'2021-07-17',NULL,380997289807,NULL,1347858598,'1',NULL,0,'','0'),
(6392,NULL,'Мандар Галина ',NULL,'2021-07-17',NULL,380676392231,NULL,2112931813,'1',NULL,0,'','0'),
(6393,NULL,'Корнак Марія',NULL,'2021-07-17',NULL,380967102489,NULL,1549307436,'1',NULL,0,'','0'),
(6394,NULL,'Свирида Тетяна ',NULL,'2021-07-17',NULL,380980910694,NULL,2010379045,'1',NULL,0,'','0'),
(6395,NULL,'Ливинюк Юлія',NULL,'2021-07-17',NULL,380500849569,NULL,1674599538,'1',NULL,0,'','0'),
(6396,NULL,'Козак Руслана',NULL,'2021-07-17',NULL,380672784831,NULL,1734670489,'1',NULL,0,'','0'),
(6397,NULL,'Гурдова Людмила',NULL,'2021-07-19',NULL,380979669154,NULL,1643704233,'1',NULL,0,'','0'),
(6398,NULL,'Слота Оля',NULL,'2021-07-19',NULL,380967276968,NULL,2135133102,'1',NULL,0,'','0'),
(6399,NULL,'Бучняк ',NULL,'2021-07-19',NULL,380987245795,NULL,1276074091,'1',NULL,0,'','0'),
(6400,NULL,'Холоднюк Ірина',NULL,'2021-07-19',NULL,380982784941,NULL,2003182738,'1',NULL,0,'','0'),
(6401,NULL,'Кагадій Галя',NULL,'2021-07-19',NULL,380987023520,NULL,2019394719,'1',NULL,0,'','0'),
(6402,NULL,'Мацевко Настя',NULL,'2021-07-20',NULL,380967438863,NULL,1285713219,'1',NULL,0,'','0'),
(6403,NULL,'Іюльська Оля',NULL,'2021-07-20',NULL,380668751507,NULL,1685999381,'1',NULL,0,'','0'),
(6404,NULL,'Ірха Марія',NULL,'2021-07-20',NULL,380964525589,NULL,1592267742,'1',NULL,0,'','0'),
(6405,NULL,'Доланська Надія',NULL,'2021-07-20',NULL,380962745445,NULL,1974073406,'1',NULL,0,'','0'),
(6406,NULL,'Градова Яна',NULL,'2021-07-20',NULL,380964542934,NULL,1278330738,'1',NULL,0,'','0'),
(6407,NULL,'Величко Вероніка',NULL,'2021-07-20',NULL,380660759894,NULL,2005084306,'1',NULL,0,'','0'),
(6408,NULL,'Мантіковська Ліна',NULL,'2021-07-20',NULL,380971938237,NULL,1609075798,'1',NULL,0,'','0'),
(6409,NULL,'Калакайло Тетяна',NULL,'2021-07-20',NULL,380971846306,NULL,1517975907,'1',NULL,0,'','0'),
(6410,NULL,'Квітка Ольга',NULL,'2021-07-20',NULL,380957855573,NULL,1402347861,'1',NULL,0,'','0'),
(6411,NULL,'Гикава Вікторія',NULL,'2021-07-20',NULL,380990442788,NULL,1231458576,'1',NULL,0,'','0'),
(6412,NULL,'Цурганова Валеріа',NULL,'2021-07-20',NULL,380666938528,NULL,1218326259,'1',13091,0,'','0'),
(6413,NULL,'Гладій Анастасія',NULL,'2021-07-20',NULL,380981005774,NULL,1613515292,'1',NULL,0,'','0'),
(6414,NULL,'Ставінська Каріна',NULL,'2021-07-20',NULL,380688441980,NULL,2032761180,'1',NULL,0,'','0'),
(6415,NULL,'Музика Софія',NULL,'2021-07-20',NULL,380681762597,NULL,2015970170,'1',NULL,0,'','0'),
(6416,NULL,'Марина Слободян','1982-02-18','2021-07-21','2zg7ju5+36yhNp/kqfxhWw==',380978851897,380978851897,1543298887,'1',46447,0,'','0'),
(6417,NULL,'Ларін Іванка',NULL,'2021-07-21',NULL,380982434824,NULL,1598884504,'1',NULL,0,'','0'),
(6418,NULL,'Павлюк Марія ',NULL,'2021-07-21',NULL,380688254327,NULL,1893221351,'1',NULL,0,'','0'),
(6419,NULL,'Березовська Еліна ',NULL,'2021-07-21','QX/cqFNef4KqvKZlBth4aQ==',380507483949,NULL,1355537876,'1',34911,0,'','0'),
(6421,NULL,'Лещишин Марія ','1995-08-05','2021-07-22',NULL,380989297247,NULL,1315311040,'1',NULL,0,'','0'),
(6422,NULL,'Юзвенко Марія ',NULL,'2021-07-22',NULL,380960214852,NULL,1978791283,'1',NULL,0,'','0'),
(6423,NULL,'Мялковська Ольга',NULL,'2021-07-22',NULL,380989914681,NULL,2019844279,'1',NULL,0,'','0'),
(6424,NULL,'Кумигіна Аліна',NULL,'2021-07-22',NULL,380976617834,NULL,2042383147,'1',NULL,0,'','0'),
(6425,NULL,'Човник Ольга',NULL,'2021-07-22',NULL,380982158035,NULL,1912830538,'1',NULL,0,'','0'),
(6426,NULL,'Роговська Теттяна',NULL,'2021-07-22',NULL,380636778597,NULL,2128156607,'1',NULL,0,'','0'),
(6428,NULL,'Шахинер Марина',NULL,'2021-07-23','Q1RnATwf8eUFi+led0ttYQ==',380987203936,NULL,1461603877,'1',58406,0,'','0'),
(6429,NULL,'Антонюк Олеся ',NULL,'2021-07-23',NULL,380678766151,NULL,2121001035,'1',NULL,0,'','0'),
(6430,NULL,'Мороз Христя ',NULL,'2021-07-23',NULL,380961532064,NULL,2114932024,'1',NULL,0,'','0'),
(6431,NULL,'Ванджура Надія',NULL,'2021-07-23',NULL,380686257478,NULL,2053844938,'1',NULL,0,'','0'),
(6432,NULL,'Губіцька Яна','2001-01-26','2021-07-24',NULL,380962785805,NULL,2032592636,'1',NULL,0,'','0'),
(6433,NULL,'Лисак Теттяна',NULL,'2021-07-24',NULL,380961633154,NULL,1669689944,'1',NULL,0,'','0'),
(6434,NULL,'Тарабалка Наталія',NULL,'2021-07-24',NULL,380972317261,NULL,1299013480,'1',NULL,0,'','0'),
(6435,NULL,'Караїм Любов',NULL,'2021-07-24',NULL,380975552504,NULL,1338756958,'1',NULL,0,'','0'),
(6436,NULL,'Рудянин Оксана',NULL,'2021-07-26',NULL,380686409333,NULL,1785674565,'1',NULL,1,'','0'),
(6437,NULL,'Олексишин Сергій',NULL,'2021-07-26',NULL,380956170138,NULL,1548868266,'1',NULL,0,'','0'),
(6438,NULL,'Казьмін Діана',NULL,'2021-07-26',NULL,380688754645,NULL,1821938491,'1',NULL,0,'','0'),
(6439,NULL,'Стець Марія',NULL,'2021-07-26',NULL,380688301552,NULL,1330553826,'1',NULL,0,'','0'),
(6440,NULL,'Вибодовська Оксана','1989-02-07','2021-07-26','VNA+pmSUA/nB4NVeMrQHoA==',380688177909,NULL,1884376170,'1',12659,0,'','0'),
(6441,NULL,'Міщанчук Віра',NULL,'2021-07-26',NULL,380975109859,NULL,1860140029,'1',NULL,0,'','0'),
(6442,NULL,'Хомишин Анастасія',NULL,'2021-07-26',NULL,380686521355,NULL,1178322117,'1',NULL,0,'','0'),
(6443,NULL,'Ільчишин Діана',NULL,'2021-07-26',NULL,380663130636,NULL,1166848585,'1',NULL,0,'','0'),
(6444,NULL,'Лялик Оля',NULL,'2021-07-26','1/4n5Xm0yQ8q7buTljI4Lg==',380979196622,NULL,1172334652,'1',15142,0,'','0'),
(6445,NULL,'Лучка Аліна',NULL,'2021-07-26',NULL,380979728997,NULL,1722610353,'1',40765,1,'','0'),
(6446,NULL,'Пасечка Інна ','2003-07-19','2021-07-26',NULL,380386848096,380686848096,1541733033,'1',NULL,0,'','0'),
(6447,NULL,'Oksana Polishchuk','1990-09-10','2021-07-26',NULL,380506562127,380506562127,2098204000,'1',NULL,0,'','0'),
(6448,NULL,'Бегма Олеся',NULL,'2021-07-27',NULL,380964974563,NULL,1190377412,'1',NULL,0,'','0'),
(6449,NULL,'Савок Марія',NULL,'2021-07-27',NULL,380980329108,NULL,1390877099,'1',NULL,0,'','0'),
(6450,NULL,'Бабин Ольга',NULL,'2021-07-27',NULL,380988092125,NULL,1283834334,'1',NULL,0,'','0'),
(6451,NULL,'Пасічна Анастасія',NULL,'2021-07-27',NULL,380971329637,NULL,2086330488,'1',NULL,0,'','0'),
(6452,NULL,'Ільніцька Марія',NULL,'2021-07-27',NULL,380686499333,NULL,1434407668,'1',NULL,0,'','0'),
(6453,NULL,'Гащиць Оксана','1993-02-06','2021-07-27',NULL,380931270218,NULL,1219281585,'1',NULL,0,'','0'),
(6454,NULL,'тичковський Ярослав',NULL,'2021-07-27',NULL,380980000171,NULL,1350060294,'1',NULL,0,'','0'),
(6455,NULL,'Солодка Наталя',NULL,'2021-07-27',NULL,380684166269,NULL,2051563703,'1',NULL,1,'','0'),
(6456,NULL,'Лотовська Ілона','2002-06-26','2021-07-27',NULL,380971318467,NULL,1989722480,'1',NULL,0,'','0'),
(6457,NULL,'Цимбалюк Аліна',NULL,'2021-07-27',NULL,380957590038,NULL,1223241265,'1',NULL,0,'','0'),
(6458,NULL,'Ковальчук Оксана',NULL,'2021-07-27',NULL,380969579482,NULL,1958445421,'1',NULL,0,'','0'),
(6459,NULL,'Кремарчук Аліна ',NULL,'2021-07-27',NULL,380678763152,NULL,1882091240,'1',NULL,0,'','0'),
(6460,NULL,'Докучай Соломія',NULL,'2021-07-27',NULL,380673952035,NULL,1400580665,'1',NULL,0,'','0'),
(6461,NULL,'Олексишин Івана',NULL,'2021-07-28',NULL,380996236980,NULL,1326504813,'1',NULL,0,'','0'),
(6462,NULL,'Пельвецька наталя',NULL,'2021-07-28',NULL,380681759266,NULL,1298420288,'1',NULL,0,'','0'),
(6463,NULL,'Цепла Наталя ',NULL,'2021-07-28',NULL,380970597231,NULL,1674477688,'1',NULL,0,'','0'),
(6464,NULL,' Грушевська Ольга','1981-07-28','2021-07-28',NULL,380988964929,NULL,1505090868,'1',NULL,0,'
\n','0'),
(6465,NULL,'Магега Теттяна',NULL,'2021-07-29',NULL,380680549657,NULL,1374986773,'1',NULL,0,'','0'),
(6466,NULL,'Попова Галина',NULL,'2021-07-29',NULL,380994745870,NULL,2018923681,'1',NULL,0,'','0'),
(6467,NULL,'Франків Івана',NULL,'2021-07-29',NULL,380966675473,NULL,1732404153,'1',NULL,0,'','0'),
(6468,NULL,'Тракало Надія',NULL,'2021-07-29',NULL,380660457501,NULL,1236204866,'1',NULL,0,'','0'),
(6469,NULL,'Фуштей Ольга','2002-10-28','2021-07-29',NULL,380986119524,NULL,1243382777,'1',NULL,0,'','0'),
(6470,NULL,'Семанишин Івана',NULL,'2021-07-29',NULL,380967833799,NULL,1806645018,'1',NULL,0,'','0'),
(6471,NULL,'Бригідир Олена','2003-11-18','2021-07-29',NULL,380681697926,NULL,1643008031,'1',23226,0,'','0'),
(6472,NULL,'Петрик Соломія','1992-03-06','2021-07-30',NULL,380966812980,NULL,1672256704,'1',64339,0,'','0'),
(6473,NULL,'Байра Оля',NULL,'2021-07-30',NULL,380954364617,NULL,1252563010,'1',NULL,0,'','0'),
(6474,NULL,'Дідух Іванка',NULL,'2021-07-30',NULL,380976368446,NULL,1224415226,'1',NULL,0,'','0'),
(6475,NULL,'Бобилюк Леся',NULL,'2021-07-30',NULL,380978557241,NULL,1213587045,'1',NULL,0,'','0'),
(6476,NULL,'Осадчук Наталія',NULL,'2021-07-30',NULL,380982402047,NULL,1847527902,'1',NULL,0,'','0'),
(6477,NULL,'Поліщук Оксана',NULL,'2021-07-30',NULL,447365621270,NULL,2068504025,'1',NULL,0,'','0'),
(6478,NULL,'Полька Ірина',NULL,'2021-07-30',NULL,380971370653,NULL,1850159374,'1',NULL,0,'','0'),
(6479,NULL,'Закревська Вікторія',NULL,'2021-07-30',NULL,380964058595,NULL,2044708677,'1',NULL,0,'','0'),
(6481,NULL,'Надія Мельник','2001-06-12','2021-07-30',NULL,380985301662,NULL,1249531317,'1',NULL,0,'','0'),
(6482,NULL,'Жулківська Наталя','1993-10-11','2021-07-31',NULL,380980066525,380964179492,1972887493,'1',NULL,0,'
\n','0'),
(6483,NULL,'Тетяна Болюбаш','1996-04-08','2021-07-31',NULL,380667849013,NULL,1307980340,'1',NULL,0,'','0'),
(6484,NULL,'Зеленяк Світлана',NULL,'2021-07-31',NULL,380969137026,NULL,1984036066,'1',NULL,0,'','0'),
(6485,NULL,'Ланова Ала',NULL,'2021-08-01',NULL,380967472010,NULL,2134848425,'1',NULL,0,'','0'),
(6486,NULL,'Хом&#039;як Яна','2000-07-08','2021-08-01',NULL,380683645322,NULL,1926257356,'1',NULL,0,'','0'),
(6487,NULL,'Корнєєва Анастасія','2000-08-11','2021-08-01',NULL,380676905820,NULL,1199806749,'1',NULL,0,'','0');

INSERT INTO `kontragentu` VALUES 
(6488,NULL,'Данко Оксана',NULL,'2021-08-02',NULL,380983708359,NULL,1978136102,'1',NULL,0,'','0'),
(6489,NULL,'Камінська Олена',NULL,'2021-08-02',NULL,380979457816,NULL,1518517633,'1',NULL,0,'','0'),
(6490,NULL,'Михайлюк Лілія',NULL,'2021-08-02',NULL,380674521438,NULL,1280815195,'1',NULL,0,'','0'),
(6491,NULL,'Рибачок Галина',NULL,'2021-08-02',NULL,380987987799,NULL,1258555745,'1',NULL,0,'','0'),
(6492,NULL,'Рибачок Галина',NULL,'2021-08-02',NULL,380987987748,NULL,1150734396,'1',NULL,0,'','0'),
(6493,NULL,'Чопик Валентина',NULL,'2021-08-02',NULL,380685668939,NULL,1560037586,'1',NULL,0,'','0'),
(6494,NULL,'Подолянська Марія',NULL,'2021-08-03',NULL,380680063240,NULL,1478958485,'1',NULL,0,'','0'),
(6495,NULL,'Садляк Олеся',NULL,'2021-08-03',NULL,380972810570,NULL,1877926296,'1',NULL,0,'','0'),
(6496,NULL,'Герилюк Надія ',NULL,'2021-08-03',NULL,380972325557,NULL,1727096993,'1',NULL,0,'','0'),
(6497,NULL,'Бодьо Марія ','1997-09-16','2021-08-03',NULL,380671224097,NULL,1388601445,'1',12555,0,'Молода матуся 
\n','0'),
(6498,NULL,'П&#039;єнтак Жанна ','2003-11-20','2021-08-04',NULL,380982784385,NULL,1151070315,'1',NULL,0,'????','0'),
(6499,NULL,'Дудка Уляна',NULL,'2021-08-04',NULL,380987727537,NULL,1664142650,'1',NULL,0,'','0'),
(6500,NULL,'Винник Леся',NULL,'2021-08-04',NULL,380663912154,NULL,1177352142,'1',NULL,0,'','0'),
(6501,NULL,'Федик Тетяна',NULL,'2021-08-04',NULL,380986386047,NULL,1337060696,'1',NULL,0,'','0'),
(6502,NULL,'Гриців Маряна',NULL,'2021-08-04',NULL,380979082328,NULL,1792376808,'1',NULL,1,'','0'),
(6503,NULL,'Манфреді Діана','2001-11-27','2021-08-04',NULL,380680719748,NULL,1884251737,'1',65475,0,'','0'),
(6504,NULL,'Срібна Віра',NULL,NULL,NULL,380964982866,NULL,1932832195,'1',NULL,0,'','0'),
(6505,NULL,'Зарівна Зоряна',NULL,'2021-08-05',NULL,380976610123,NULL,1832321242,'1',NULL,0,'','0'),
(6506,NULL,'Лещишин Сніжана ','2002-04-17','2021-08-05',NULL,380984337823,NULL,1784870503,'1',NULL,0,'','0'),
(6507,NULL,'Мисюра Наталя',NULL,'2021-08-05',NULL,380957593557,NULL,1869312576,'1',NULL,0,'','0'),
(6508,NULL,'Карлін Ірина ','1999-04-04','2021-08-05',NULL,380987570985,NULL,1446968072,'1',26579,0,'','0'),
(6509,NULL,'Копичинська Тетяна',NULL,'2021-08-05',NULL,380630375470,NULL,1249442564,'1',NULL,0,'','0'),
(6511,NULL,'Кіт Оксана',NULL,'2021-08-06',NULL,380978725156,NULL,1707262191,'1',NULL,0,'','0'),
(6512,NULL,'Колісник Наталія ',NULL,'2021-08-06',NULL,380960968383,NULL,1334404133,'1',NULL,0,'','0'),
(6513,NULL,'Осадца Надія',NULL,'2021-08-06',NULL,380668654970,NULL,1198536474,'1',NULL,0,'','0'),
(6514,NULL,'Пелехата Юлія','1998-08-08','2021-08-07',NULL,380664484604,NULL,1367855854,'1',NULL,0,'','0'),
(6515,NULL,'Качан Світлана',NULL,'2021-08-07',NULL,380685297162,NULL,1670779839,'1',NULL,0,'','0'),
(6516,NULL,'Мельник Олена','2003-05-02','2021-08-07','plOcUF28F3NgeqP26oUGDA==',380630205828,NULL,1810945486,'1',54865,0,'','0'),
(6517,NULL,'Гургач Наталія Богданівна ','1980-03-03','2021-08-07',NULL,380988139775,380988139667,1969053198,'1',NULL,0,'','0'),
(6518,NULL,'Шквчук Уляна',NULL,'2021-08-07',NULL,380672268528,NULL,1652239655,'1',NULL,0,'','0'),
(6519,NULL,'Samanta Zhulkivska','2006-02-07','2021-08-08',NULL,380970041202,383382762094,1800822003,'1',NULL,0,'','0'),
(6520,NULL,'Кернога Анастасія ','2007-07-22','2021-08-09',NULL,380988112699,NULL,1606324993,'1',19460,1,'','0'),
(6521,NULL,'Сякалюк Тетяна',NULL,'2021-08-09',NULL,380673010799,NULL,1953704888,'1',NULL,0,'','0'),
(6522,NULL,'Гира Наталія ',NULL,'2021-08-09',NULL,380968810230,NULL,1377765134,'1',45334,0,'','0'),
(6523,NULL,'Лопушняк Галя',NULL,'2021-08-09',NULL,380966820977,NULL,1477598638,'1',NULL,0,'','0'),
(6524,NULL,'Шевчук Віра',NULL,'2021-08-09',NULL,380671177555,NULL,1669283853,'1',NULL,0,'','0'),
(6525,NULL,'Кардинал Ірина',NULL,'2021-08-09',NULL,380980488616,NULL,1766698334,'1',NULL,0,'','0'),
(6526,NULL,'Чабан Наталія',NULL,'2021-08-09',NULL,380970754350,NULL,1417722335,'1',NULL,0,'','0'),
(6527,NULL,'Кавюк Людмила','1973-08-16','2021-08-09',NULL,380984489894,NULL,1525923853,'1',NULL,0,'','0'),
(6528,NULL,'Вязанкіна наталія','1986-08-13','2021-08-09',NULL,380689869183,NULL,1597392427,'1',NULL,0,'','0'),
(6529,NULL,'Городинська Діана','1998-07-22','2021-08-09',NULL,380931339571,NULL,2130445832,'1',NULL,0,'','0'),
(6530,NULL,'Яцишин Наталія','1990-04-20','2021-08-09',NULL,380502654376,NULL,2055968975,'1',NULL,0,'','0'),
(6531,NULL,'Грошко Оля',NULL,'2021-08-10',NULL,380974045300,NULL,1975092561,'1',NULL,0,'','0'),
(6532,NULL,'Перців Гана',NULL,'2021-08-10',NULL,380962498909,NULL,1869753892,'1',NULL,0,'','0'),
(6533,NULL,'Навізівська Ольга',NULL,'2021-08-10',NULL,380978157628,NULL,1635456228,'1',NULL,0,'','0'),
(6534,NULL,'Мальована Надія',NULL,'2021-08-10',NULL,380971410316,NULL,1524993270,'1',NULL,0,'','0'),
(6535,NULL,'Лиса Анастасія','2005-07-12','2021-08-11',NULL,380961524327,NULL,1391512311,'1',NULL,0,'','0'),
(6536,NULL,'Бурдак Настя',NULL,'2021-08-11',NULL,380685862663,NULL,1173841946,'1',NULL,0,'','0'),
(6537,NULL,'Цебрій Тетяна ',NULL,'2021-08-11',NULL,380972993925,NULL,1203034011,'1',NULL,0,'','0'),
(6538,NULL,'Нагірна Ольга',NULL,'2021-08-11',NULL,380977387079,NULL,1756579256,'1',NULL,0,'','0'),
(6539,NULL,'Серенецька Ольга',NULL,'2021-08-11',NULL,380980915995,NULL,1356770150,'1',NULL,0,'','0'),
(6540,NULL,'Романюк Софія',NULL,'2021-08-11',NULL,380972316394,NULL,1228730721,'1',NULL,0,'','0'),
(6541,NULL,'Gomencuk Kristina','1999-09-28','2021-08-11',NULL,380977116577,380977116577,1545486950,'1',NULL,0,'','0'),
(6542,NULL,'Будняк Оксана',NULL,'2021-08-11',NULL,380689549375,NULL,1258427763,'1',NULL,1,'','0'),
(6543,NULL,'Лучків валентина',NULL,'2021-08-11',NULL,380979923355,NULL,1310491239,'1',NULL,0,'','0'),
(6544,NULL,'Нагірна Оксана ',NULL,'2021-08-11',NULL,380970324830,NULL,1568759518,'1',NULL,0,'','0'),
(6545,NULL,'Джупіна Світлана',NULL,'2021-08-11',NULL,380969136312,NULL,1144227842,'1',NULL,1,'','0'),
(6546,NULL,'Ковальська Лілія',NULL,'2021-08-11',NULL,380635943703,NULL,1736362302,'1',NULL,0,'','0'),
(6547,NULL,'Христина Білецька ','1995-01-19','2021-08-11',NULL,380686140067,NULL,1243279374,'1',NULL,1,'','0'),
(6548,NULL,'Нагірна Інна',NULL,'2021-08-12',NULL,380684921682,NULL,1929516222,'1',NULL,0,'','0'),
(6549,NULL,'Балабух Оксана',NULL,'2021-08-12',NULL,380950980995,NULL,1624787965,'1',NULL,0,'','0'),
(6550,NULL,'Сокотович Марія',NULL,'2021-08-12',NULL,380979664162,NULL,1443137994,'1',NULL,0,'','0'),
(6551,NULL,'Вербіцька Ірина',NULL,'2021-08-12',NULL,380688570889,NULL,1797168016,'1',NULL,0,'','0'),
(6552,NULL,'Пиняк Олена',NULL,'2021-08-12',NULL,380972332433,NULL,1245463167,'1',NULL,1,'','0'),
(6553,NULL,'Пиняк Ілона',NULL,'2021-08-12',NULL,380987064145,NULL,1466197319,'1',NULL,1,'','0'),
(6554,NULL,'Скочко Маргарита ',NULL,'2021-08-13',NULL,380978715403,NULL,1484386272,'1',NULL,0,'','0'),
(6555,NULL,'Безкоровайна Таня','1992-08-05','2021-08-13',NULL,380664370412,NULL,1260462763,'1',45439,0,'','0'),
(6556,NULL,'Рижевська Оксана',NULL,'2021-08-13',NULL,380986357080,NULL,1339872901,'1',NULL,0,'','0'),
(6557,NULL,'Попик Христина',NULL,'2021-08-13',NULL,380974955457,NULL,1247747734,'1',NULL,0,'','0'),
(6558,NULL,'Брода Олексанндра',NULL,'2021-08-13',NULL,380965191930,NULL,1359301872,'1',NULL,0,'','0'),
(6559,NULL,'Бкнікевич Оля',NULL,'2021-08-14',NULL,380990357730,NULL,1647846756,'1',NULL,0,'','0'),
(6560,NULL,'Малиновська Людмила',NULL,'2021-08-14',NULL,380970558403,NULL,1449070934,'1',NULL,0,'','0'),
(6561,NULL,'Дячок Галина',NULL,'2021-08-14',NULL,380951881399,NULL,1552579393,'1',NULL,0,'','0'),
(6563,NULL,'Нога Марія',NULL,'2021-08-16',NULL,380971405994,NULL,1772154901,'1',NULL,0,'','0'),
(6564,NULL,'Чубать Мілена',NULL,'2021-08-16',NULL,380685540292,NULL,1133491173,'1',NULL,0,'','0'),
(6565,NULL,'Бойко Марія',NULL,'2021-08-16',NULL,380684913778,NULL,1916773057,'1',NULL,0,'','0'),
(6566,NULL,'Сторожук Христина',NULL,'2021-08-16',NULL,380985842927,NULL,1850882196,'1',NULL,0,'','0'),
(6567,NULL,'Сторожук Юля',NULL,'2021-08-16',NULL,380678684361,NULL,1486917851,'1',NULL,0,'','0'),
(6568,NULL,'Ландяк Івана',NULL,'2021-08-16',NULL,380097999296,NULL,2025236316,'1',NULL,0,'','0'),
(6569,NULL,'Гладчук Уляна',NULL,'2021-08-16',NULL,380961306926,NULL,2101312586,'1',NULL,0,'','0'),
(6570,NULL,'Слупська Надія',NULL,'2021-08-16',NULL,380990160501,NULL,1963184613,'1',NULL,0,'','0'),
(6571,NULL,'Кардинал Марія',NULL,'2021-08-16',NULL,380967720288,NULL,2089315282,'1',NULL,0,'','0'),
(6572,NULL,'Бабій Антоніна',NULL,'2021-08-16',NULL,380970415156,NULL,1534101995,'1',NULL,0,'','0'),
(6573,NULL,'Ришетнік Мішель',NULL,'2021-08-16',NULL,380509720956,NULL,1184938771,'1',NULL,0,'','0'),
(6574,NULL,'Кожемяка Іра',NULL,'2021-08-16',NULL,380979200825,NULL,1245058237,'1',NULL,0,'','0'),
(6575,NULL,'Козак Світлана',NULL,'2021-08-16',NULL,380986765877,NULL,1843236057,'1',NULL,0,'','0'),
(6576,NULL,'Томик Марія',NULL,'2021-08-16',NULL,380680754074,NULL,1479407202,'1',NULL,0,'','0'),
(6577,NULL,'Ленчишин Надія','2002-04-29','2021-08-16',NULL,380983196766,NULL,1133367361,'1',NULL,0,'','0'),
(6578,NULL,'Сорочка оксана',NULL,'2021-08-16',NULL,380973711545,NULL,1365627371,'1',NULL,0,'','0'),
(6579,NULL,'Дарина Панова','1993-06-28','2021-08-16',NULL,380953202440,380953202440,1845560782,'1',NULL,0,'','0'),
(6580,NULL,'Бідяк Вікторія','1992-06-15','2021-08-17',NULL,380507301889,NULL,1679188451,'1',NULL,0,'','0'),
(6581,NULL,'Мазур Надія',NULL,'2021-08-17',NULL,380507131846,NULL,1551217001,'1',NULL,0,'','0'),
(6582,NULL,'Гевко Юля ',NULL,'2021-08-18',NULL,380963391387,NULL,1235778698,'1',NULL,0,'','0'),
(6583,NULL,'Зявін Теттяна',NULL,'2021-08-18',NULL,380680549203,NULL,1121055019,'1',NULL,0,'','0'),
(6584,NULL,'Ландяк Івана',NULL,'2021-08-18',NULL,380979992960,NULL,2118845362,'1',NULL,0,'','0'),
(6585,NULL,'Антошків Оля',NULL,'2021-08-18',NULL,380680472900,NULL,1531116083,'1',NULL,0,'','0'),
(6586,NULL,'Балик Таня ',NULL,'2021-08-18',NULL,380973552119,NULL,1790749225,'1',NULL,0,'','0'),
(6587,NULL,'Гурська Діана',NULL,'2021-08-18',NULL,380989633784,NULL,1131395966,'1',NULL,0,'','0'),
(6588,NULL,'Солонинка Наталія Ярославівна','1994-04-01','2021-08-19',NULL,380986182881,380986182881,1156096356,'1',NULL,0,'','0'),
(6589,NULL,'Сокальська Яна','2004-07-07','2021-08-19',NULL,380680969487,NULL,1934870013,'1',NULL,0,'','0'),
(6590,NULL,'Провіцька Оксана',NULL,'2021-08-19',NULL,380979884738,NULL,1907460990,'1',NULL,0,'','0'),
(6591,NULL,'Котик Галина',NULL,'2021-08-20',NULL,380731020998,NULL,1885442190,'1',NULL,0,'','0'),
(6592,NULL,'Кіпер Таня',NULL,'2021-08-20',NULL,380971247657,NULL,1221281668,'1',NULL,0,'','0'),
(6593,NULL,'Андрусевич Світлана',NULL,'2021-08-20',NULL,380967303122,NULL,1988604614,'1',NULL,0,'','0'),
(6594,NULL,'Черниш Наталія ',NULL,'2021-08-20',NULL,380987801477,NULL,1389070937,'1',NULL,0,'','0'),
(6595,NULL,'Анастасія ','2000-05-15','2021-08-20',NULL,380672605032,NULL,1366786068,'1',NULL,0,'','0'),
(6596,NULL,'Сакундяк Надія',NULL,'2021-08-20',NULL,380683238839,NULL,2027641300,'1',NULL,0,'','0'),
(6597,NULL,'Семанишин Іванна',NULL,'2021-08-20',NULL,380980482963,NULL,1643497186,'1',NULL,0,'','0'),
(6598,NULL,'Леська Ольга',NULL,'2021-08-21',NULL,380979176894,NULL,1990738720,'1',NULL,0,'','0'),
(6599,NULL,'Кульба Яна',NULL,'2021-08-21',NULL,380982480499,NULL,2101618633,'1',NULL,0,'','0'),
(6600,NULL,'Кульба Яна',NULL,'2021-08-21',NULL,380982480494,NULL,1156776436,'1',NULL,0,'','0'),
(6601,NULL,'Волошина Маряна',NULL,'2021-08-21',NULL,380674385313,NULL,1381042793,'1',NULL,0,'','0'),
(6602,NULL,'Король Ірина',NULL,'2021-08-21',NULL,380683079289,NULL,1748055635,'1',22735,0,'','0'),
(6603,NULL,'Дячишин Люба',NULL,NULL,NULL,380979477929,NULL,1489782621,'0',NULL,0,'','0'),
(6604,NULL,'Кумигіна Аліна',NULL,'2021-08-21',NULL,380980490445,NULL,1517213462,'1',NULL,0,'','0'),
(6605,NULL,'Ліщій Ольга',NULL,'2021-08-21',NULL,380671376829,NULL,1428844867,'1',39537,0,'','0'),
(6606,NULL,'Погорецька Марія','1992-08-14','2021-08-21',NULL,380988057736,NULL,1687262551,'1',NULL,0,'
\n????????????','0'),
(6607,NULL,'Волощук Віталіна ',NULL,'2021-08-21',NULL,380687869270,NULL,1127350807,'1',NULL,0,'','0'),
(6608,NULL,'Матвійчук Христина ',NULL,'2021-08-22',NULL,380976079152,NULL,1197725399,'1',NULL,0,'','0'),
(6609,NULL,'Кухтяк Анжела ',NULL,'2021-08-22',NULL,380681515621,NULL,1737888276,'1',NULL,0,'','0'),
(6611,NULL,'Кардинал Клавдія',NULL,'2021-08-23',NULL,380967976172,NULL,1299502012,'1',NULL,0,'','0'),
(6612,NULL,'Пилипів Марія ',NULL,'2021-08-23',NULL,380677813166,NULL,1534323339,'1',NULL,0,'','0'),
(6613,NULL,'Рябкова Віталіна','2000-08-26','2021-08-23',NULL,380950810745,NULL,2117430124,'1',NULL,0,'','0'),
(6614,NULL,'Школьницька Євгенія',NULL,'2021-08-23',NULL,380688212538,NULL,1604617802,'1',NULL,0,'','0'),
(6615,NULL,'Маслянка Галя ',NULL,'2021-08-23',NULL,380983751904,NULL,1986843865,'1',NULL,0,'','0'),
(6616,NULL,'Антків Оксана',NULL,'2021-08-24',NULL,380978723673,NULL,1168668925,'1',NULL,0,'','0'),
(6617,NULL,'Новак Ольга',NULL,'2021-08-24',NULL,380979904091,NULL,1824452880,'1',NULL,0,'','0'),
(6618,NULL,'Созанська Таня',NULL,'2021-08-24',NULL,380964047599,NULL,2105315723,'1',NULL,0,'','0'),
(6619,NULL,'Миськів Леся',NULL,'2021-08-24',NULL,380974955051,NULL,1405657030,'1',NULL,0,'','0'),
(6620,NULL,'Забарило Іванна',NULL,'2021-08-24',NULL,380968547851,NULL,1590798738,'1',NULL,0,'','0'),
(6621,NULL,'Колужняк Олена ','2002-07-16','2021-08-24',NULL,380971449710,NULL,1622815686,'1',NULL,0,'','0'),
(6622,NULL,'Міліневич Оля ',NULL,'2021-08-25',NULL,380978626528,NULL,1573865481,'1',NULL,0,'','0'),
(6623,NULL,'Нагаєвська Світлана',NULL,'2021-08-25',NULL,380950975394,NULL,1941011861,'1',NULL,0,'','0'),
(6624,NULL,'Байталюк Зоряна','1980-09-20','2021-08-26',NULL,380956074442,NULL,2095561304,'1',NULL,0,'','0'),
(6625,NULL,'Костів Світлана',NULL,'2021-08-26',NULL,380966378220,NULL,1142065974,'1',NULL,0,'','0'),
(6626,NULL,'Кравченко Надія','2001-03-16','2021-08-26',NULL,380965932860,NULL,1946910315,'1',44149,0,'','0'),
(6627,NULL,'Караван Івана',NULL,'2021-08-27',NULL,380963766422,NULL,1570037078,'1',NULL,0,'','0'),
(6628,NULL,'Савченко Христина',NULL,'2021-08-27',NULL,380981076508,NULL,1252855182,'1',NULL,0,'','0'),
(6629,NULL,'Винничук Оксана',NULL,'2021-08-27',NULL,380989646332,NULL,1831607207,'1',NULL,0,'','0'),
(6630,NULL,'Білошицька Юля ',NULL,'2021-08-27',NULL,380509653619,NULL,1292637118,'1',NULL,0,'','0'),
(6631,NULL,'Нога Оксана',NULL,'2021-08-27',NULL,380674093379,NULL,1291768355,'1',NULL,0,'','0'),
(6632,NULL,'Окіпна Олена ',NULL,'2021-08-27',NULL,380980916778,NULL,2052706722,'1',NULL,0,'','0'),
(6633,NULL,'Сернецька Наталія',NULL,'2021-08-27',NULL,380684913014,NULL,1982306758,'1',NULL,0,'','0'),
(6634,NULL,'Балаба Аліса','1984-01-01','2021-08-28','KuMy4aOSqZshjW1gWqfBAg==',380975273519,380981917151,1931197389,'1',19527,0,'','0'),
(6636,NULL,'Швець Яна',NULL,'2021-08-28',NULL,380997441783,NULL,1152944116,'1',NULL,0,'','0'),
(6637,NULL,'Стецько слава ',NULL,'2021-08-28',NULL,380979321477,NULL,1385344207,'1',NULL,0,'','0'),
(6638,NULL,'Навроцька Тетяна ',NULL,'2021-08-29',NULL,380976939555,NULL,1815002912,'1',NULL,0,'','0'),
(6639,NULL,'Романюк Світлана ',NULL,'2021-08-29',NULL,380976124221,NULL,1987384774,'1',NULL,0,'','0'),
(6640,NULL,'Івашків Таїса',NULL,'2021-08-30',NULL,380969214198,NULL,1889217845,'1',NULL,0,'','0'),
(6641,NULL,'Рощук Оксана',NULL,'2021-08-30',NULL,380961159792,NULL,1922623721,'1',NULL,0,'','0'),
(6642,NULL,'Черник Катерина',NULL,'2021-08-30',NULL,380669927531,NULL,1491419294,'1',NULL,0,'','0'),
(6643,NULL,'Танчук Тетяна',NULL,'2021-08-30',NULL,380685968628,NULL,1525652837,'1',NULL,0,'','0'),
(6644,NULL,'Дмитровська Наталія',NULL,'2021-08-30',NULL,380677878724,NULL,1999524703,'1',NULL,0,'','0'),
(6645,NULL,'Краєвська Зоряна',NULL,'2021-08-30',NULL,380680649861,NULL,2140623421,'1',NULL,0,'','0'),
(6646,NULL,'Пивовар Ольга',NULL,'2021-08-31',NULL,380978677426,NULL,1426085424,'1',NULL,0,'','0'),
(6647,NULL,'Балик Світлана',NULL,'2021-08-31',NULL,380683277953,NULL,1580677704,'1',NULL,0,'','0'),
(6648,NULL,'Бабій Христина',NULL,'2021-08-31',NULL,380670774569,NULL,2089975567,'1',NULL,0,'','0'),
(6649,NULL,'Василишин Ала',NULL,'2021-08-31',NULL,380971208269,NULL,1983142658,'1',NULL,0,'','0'),
(6650,NULL,'Грубенюк Каріна','2005-09-11','2021-08-31',NULL,380970600874,380970600874,1672038573,'1',NULL,0,'','0'),
(6651,NULL,'Павловська Наталія',NULL,'2021-08-31',NULL,380969813016,NULL,1599910876,'1',NULL,0,'','0'),
(6652,NULL,'Луник Христина ',NULL,'2021-08-31',NULL,380981016413,NULL,1815870307,'1',NULL,0,'','0'),
(6653,NULL,'Мялковська Юля',NULL,'2021-08-31',NULL,380976033969,NULL,1448323680,'1',NULL,0,'','0'),
(6654,NULL,'Бариська Люба',NULL,'2021-09-01',NULL,380984701149,NULL,2104252861,'1',NULL,0,'','0'),
(6655,NULL,'Тур Надія',NULL,'2021-09-01',NULL,380964079364,NULL,1819582510,'1',NULL,0,'','0'),
(6656,NULL,'Ірина Войтко','1995-04-24','2021-09-01',NULL,380670115413,NULL,1716541180,'1',NULL,0,'','0'),
(6657,NULL,'Мороз Ліля',NULL,'2021-09-01',NULL,380989588104,NULL,1877798262,'1',NULL,0,'','0'),
(6658,NULL,'Анастасія Болібрух','1998-06-04','2021-09-01',NULL,380976652463,NULL,1538584423,'1',50217,0,'','0'),
(6659,NULL,'Вікторія Лопатинська ','1996-10-29','2021-09-01',NULL,380630789778,NULL,1150674854,'1',21319,0,'','0'),
(6662,NULL,'Лихо Оксана',NULL,'2021-09-03',NULL,380683351687,NULL,1786307695,'1',NULL,0,'','0'),
(6663,NULL,'Лотоцька Наталя','1985-10-19','2021-09-03',NULL,380687355702,NULL,1927168171,'1',NULL,0,'','0'),
(6665,NULL,'Захаркова Анжеліка',NULL,'2021-09-04',NULL,380987491337,NULL,1663607043,'1',NULL,0,'','0'),
(6666,NULL,'Бардецька ірина',NULL,'2021-09-04',NULL,380969539432,NULL,1961189919,'1',NULL,0,'','0'),
(6667,NULL,'Федоришин Марія','1998-05-28','2021-09-05',NULL,380678845951,NULL,1830542991,'1',NULL,0,'','0'),
(6668,NULL,'Олійнич галина ',NULL,'2021-09-06',NULL,380661120061,NULL,2113864275,'1',NULL,0,'','0'),
(6669,NULL,'Поважна Сніжана',NULL,'2021-09-06',NULL,380680577525,NULL,1116172368,'1',NULL,0,'','0'),
(6670,NULL,'Ільницька Галина ',NULL,'2021-09-06',NULL,380978426660,NULL,1869645664,'1',58023,0,'','0'),
(6671,NULL,'Гольба Наталія ',NULL,'2021-09-06',NULL,380973160727,NULL,1334469746,'1',NULL,0,'','0'),
(6672,NULL,'Конюшкіна Вікторія',NULL,'2021-09-06',NULL,380976363887,NULL,2145199171,'1',NULL,0,'','0'),
(6673,NULL,'Бесага Надія',NULL,'2021-09-07',NULL,380987891428,NULL,1430680577,'1',NULL,0,'','0'),
(6674,NULL,'Маланюк Інна ',NULL,'2021-09-07',NULL,380983440397,NULL,1513085495,'1',NULL,0,'','0'),
(6675,NULL,'Бойко Марія',NULL,'2021-09-07',NULL,380987372458,NULL,1636844582,'1',NULL,0,'','0'),
(6676,NULL,'Біла Аліна',NULL,'2021-09-07',NULL,380686116439,NULL,1929546389,'1',NULL,0,'','0'),
(6677,NULL,'Баран Анастасія',NULL,'2021-09-08',NULL,380963512683,NULL,1544401064,'1',NULL,0,'','0'),
(6678,NULL,'Перебиковська Світлана',NULL,'2021-09-09',NULL,380968392712,NULL,2008260292,'1',NULL,0,'','0'),
(6679,NULL,'Дюк Уляна',NULL,'2021-09-09',NULL,380970035859,NULL,1514683262,'1',NULL,0,'','0'),
(6680,NULL,'Дорожинська Олена',NULL,'2021-09-09',NULL,380986791868,NULL,1153562925,'1',NULL,0,'','0'),
(6681,NULL,'Віка Бала',NULL,'2021-09-10',NULL,380976720248,NULL,1299654301,'1',NULL,0,'','0'),
(6682,NULL,'Гановська Ольга','2006-09-20','2021-09-10',NULL,380681343387,NULL,1884624595,'1',38972,1,'','0'),
(6683,NULL,'Гаджала Віра',NULL,'2021-09-10',NULL,380975437960,NULL,1918661697,'1',NULL,0,'','0'),
(6684,NULL,'Оля Плішка','2000-04-05','2021-09-10',NULL,380684920188,NULL,1861953051,'1',41959,0,'','0'),
(6685,NULL,'Тетяна Богуш','1993-10-28','2021-09-10','Dyi/fr+khN9leY699w6lXQ==',380969565282,NULL,1961775901,'1',63508,0,'
\n
\n
\n
\n','0'),
(6686,NULL,'Драпак Тетяна ',NULL,'2021-09-10',NULL,380685500496,NULL,1452177517,'1',NULL,0,'','0'),
(6687,NULL,'Мисевич Христина ',NULL,'2021-09-10',NULL,380098802082,NULL,1581298460,'1',NULL,0,'','0'),
(6688,NULL,'Кушко Вікторія',NULL,'2021-09-11',NULL,380673501159,NULL,1888222987,'1',NULL,0,'','0'),
(6689,NULL,'Ковальчук Надія',NULL,'2021-09-11',NULL,380961096922,NULL,1171184412,'1',NULL,0,'','0'),
(6690,NULL,'Максимович Катерина',NULL,'2021-09-11',NULL,380960284685,NULL,1651270469,'1',NULL,0,'','0'),
(6691,NULL,'Гнатюк Аліна','2005-02-25','2021-09-11',NULL,380988956968,NULL,2099205768,'1',24376,0,'','0'),
(6692,NULL,'Стельмащук Зореслава',NULL,'2021-09-11',NULL,380994820325,NULL,1470139892,'1',NULL,1,'','0'),
(6693,NULL,'Сваричевська Ольга',NULL,'2021-09-13',NULL,380685080637,NULL,1299440937,'1',NULL,0,'','0'),
(6694,NULL,'Король Оксана ',NULL,'2021-09-13',NULL,380972967749,NULL,2127533921,'1',NULL,0,'','0'),
(6695,NULL,'Юля Сенюк','1993-12-13','2021-09-13',NULL,380979364696,NULL,1673677782,'1',NULL,0,'','0'),
(6696,NULL,'Боднарчук Каріна',NULL,'2021-09-13',NULL,380688096178,NULL,2142587934,'1',NULL,0,'','0'),
(6697,NULL,'Тетяна Козьміна ','1996-01-10','2021-09-14','OjCgFD0DieLC8lX91Xe/MA==',380680966465,NULL,1685509938,'1',25611,0,'','0'),
(6698,NULL,'Фарин Софія',NULL,'2021-09-14',NULL,380507728744,NULL,1313482678,'1',NULL,0,'','0'),
(6699,NULL,'Гайдук Романа ','2006-03-25','2021-09-15',NULL,380980590671,NULL,1614260542,'1',18863,0,'','0'),
(6700,NULL,'Добровольська Юля',NULL,'2021-09-15',NULL,380964116644,NULL,1293496349,'1',NULL,0,'','0'),
(6701,NULL,'Запотычна Галина',NULL,'2021-09-15',NULL,380974757451,NULL,1562597760,'1',NULL,0,'','0'),
(6702,NULL,'Пешилов Андрій',NULL,'2021-09-15',NULL,380668846473,NULL,1346479060,'1',NULL,0,'','0'),
(6703,NULL,'Юрків Анастасія',NULL,'2021-09-15',NULL,380966845582,NULL,1216882862,'1',NULL,0,'','0'),
(6704,NULL,'Ландяк Оксана',NULL,'2021-09-15',NULL,380673352180,NULL,1855537347,'1',NULL,0,'','0'),
(6705,NULL,'Лукасеич Вікторія',NULL,'2021-09-15',NULL,380689561951,NULL,1829959182,'1',NULL,0,'','0'),
(6706,NULL,'Гоменчук Люда','2001-12-16','2021-09-15',NULL,380966570356,380680208009,1435028599,'1',40853,0,'','0'),
(6707,NULL,'Гудзь  Анастасія',NULL,'2021-09-16',NULL,380685530691,NULL,1861763000,'1',NULL,0,'','0'),
(6708,NULL,'Мазур Аня',NULL,'2021-09-16',NULL,380684250405,NULL,1821830919,'1',NULL,0,'','0'),
(6709,NULL,'Вяткіна женя',NULL,'2021-09-16',NULL,380979234907,NULL,1926205472,'1',NULL,0,'','0'),
(6710,NULL,'Кожекіна Яна',NULL,'2021-09-16',NULL,380936598364,NULL,2048652701,'1',NULL,0,'','0'),
(6711,NULL,'Малик Яна',NULL,'2021-09-16',NULL,380682556755,NULL,1251794016,'1',NULL,0,'','0'),
(6712,NULL,'Бабенко Альона',NULL,'2021-09-16',NULL,380637012617,NULL,1253918996,'1',NULL,0,'','0'),
(6713,NULL,'Кирилюк Оля ',NULL,'2021-09-16',NULL,380674456321,NULL,2011416511,'1',NULL,0,'','0'),
(6714,NULL,'Розмаріца Марина ',NULL,'2021-09-16',NULL,380936063680,NULL,1551320760,'1',NULL,0,'','0'),
(6715,NULL,'Замора Каріна ',NULL,'2021-09-16',NULL,380957943092,NULL,1422447608,'1',NULL,0,'','0'),
(6716,NULL,'Коваль Станіслава',NULL,'2021-09-16',NULL,380734202160,NULL,1183740081,'1',NULL,0,'','0'),
(6717,NULL,'Чепрасова Анастасія',NULL,'2021-09-16',NULL,380674387155,NULL,1699009669,'1',NULL,0,'','0'),
(6718,NULL,'Висоцька Ірина',NULL,'2021-09-16',NULL,380632282969,NULL,1419479621,'1',NULL,0,'','0'),
(6719,NULL,'Туранська Вікторія',NULL,'2021-09-16',NULL,380976002431,NULL,1350614010,'1',NULL,0,'','0'),
(6720,NULL,'Біла Діана',NULL,'2021-09-16',NULL,380932290446,NULL,1807211923,'1',NULL,0,'','0'),
(6721,NULL,'Вяткіна Юля ',NULL,'2021-09-16',NULL,380688728993,NULL,1482048614,'1',NULL,0,'','0'),
(6722,NULL,'Тахірова Аліна',NULL,'2021-09-16',NULL,380937013718,NULL,1680248784,'1',NULL,0,'','0'),
(6723,NULL,'Папінко Ліля',NULL,'2021-09-16',NULL,380972233400,NULL,1494335782,'1',NULL,0,'','0'),
(6725,NULL,'Чемирис Олена','2002-09-01','2021-09-16',NULL,380977074875,NULL,1254495514,'1',NULL,0,'','0'),
(6727,NULL,'Ласка Тетяна','1995-06-30','2021-09-17',NULL,380687561834,NULL,2106155130,'1',NULL,0,'','0'),
(6728,NULL,'Калинчук Наталія',NULL,'2021-09-17',NULL,380689586089,NULL,1586512576,'1',NULL,0,'','0'),
(6729,NULL,'Комар Наталія ',NULL,'2021-09-17',NULL,380960499883,NULL,1616601818,'1',NULL,0,'','0'),
(6730,NULL,'Ободяк Софія',NULL,'2021-09-18',NULL,380962036204,NULL,1163786969,'1',NULL,0,'','0'),
(6731,NULL,'Яковець Оксана ',NULL,'2021-09-20',NULL,380663297546,NULL,1473442587,'1',NULL,0,'','0'),
(6732,NULL,'Білик Уляна','2004-01-30','2021-09-20',NULL,380680904718,NULL,1333957122,'1',58474,0,'','0'),
(6733,NULL,'Вівсяник Маряна',NULL,'2021-09-20',NULL,380985298094,NULL,1890907819,'1',NULL,0,'','0'),
(6734,NULL,'Вівсяник Надія',NULL,'2021-09-20',NULL,380501669579,NULL,1908039995,'1',NULL,0,'','0'),
(6735,NULL,'Григоришин Ірина',NULL,'2021-09-20',NULL,380686201701,NULL,1870809212,'1',NULL,0,'','0'),
(6736,NULL,'Оля Прокопик ','2003-04-15','2021-09-21',NULL,380973454673,NULL,1555839357,'1',NULL,0,'','0'),
(6737,NULL,'Борсук Михайлина',NULL,'2021-09-22',NULL,380671226869,NULL,1214796091,'1',NULL,0,'','0'),
(6738,NULL,'Южда Людмила',NULL,'2021-09-22',NULL,380976199799,NULL,1322169975,'1',NULL,0,'','0'),
(6739,NULL,'Шульська Мар’яна ',NULL,'2021-09-22',NULL,380971731807,NULL,1809700386,'1',NULL,0,'','0'),
(6740,NULL,'Михальчук Уляна ',NULL,'2021-09-22',NULL,380983434354,NULL,1958000674,'1',NULL,0,'','0'),
(6741,NULL,'Щербанюк Христина ',NULL,'2021-09-23',NULL,380508472256,NULL,1542537352,'1',NULL,0,'','0'),
(6742,NULL,'Янік Зоряна ',NULL,'2021-09-23',NULL,380980619909,NULL,1288064137,'1',NULL,0,'','0'),
(6743,NULL,'Мендик Христина',NULL,'2021-09-24',NULL,380992433634,NULL,1879132214,'1',NULL,0,'','0'),
(6744,NULL,'Ребрина Діана',NULL,'2021-09-24',NULL,380964496750,NULL,1396351319,'1',NULL,2,'','0'),
(6745,NULL,'Новак Юля ',NULL,'2021-09-24',NULL,380961233798,NULL,1267614738,'1',NULL,0,'','0'),
(6746,NULL,'Кожемякіна Яна ',NULL,'2021-09-24',NULL,380970599534,NULL,1780417421,'1',NULL,0,'','0'),
(6747,NULL,'Козак Аліна ',NULL,'2021-09-24',NULL,380983849042,NULL,1701382851,'1',NULL,0,'','0'),
(6748,NULL,'Мотуз Галина',NULL,'2021-09-25',NULL,380686466469,NULL,1126946677,'1',NULL,0,'','0'),
(6749,NULL,'Олійник Оксана',NULL,'2021-09-25',NULL,380971450767,NULL,1847647198,'1',NULL,0,'','0'),
(6750,NULL,'Мусат Надія',NULL,'2021-09-25',NULL,380994916740,NULL,1913621699,'1',NULL,0,'','0'),
(6751,NULL,'Драбінкевич Ліля',NULL,'2021-09-25',NULL,380964911799,NULL,1328499224,'1',NULL,1,'','0'),
(6752,NULL,'Котик Іра',NULL,'2021-09-27',NULL,380976073088,NULL,1217006807,'1',NULL,0,'','0'),
(6753,NULL,'Сороківська Мар&#039;яна','1999-09-21','2021-09-27',NULL,380978409026,NULL,2069998862,'1',NULL,0,'','0'),
(6755,NULL,'Стахів Світлана',NULL,'2021-09-28',NULL,380980755805,NULL,1255063410,'1',NULL,0,'','0'),
(6756,NULL,'Жилава Оксана',NULL,'2021-09-28',NULL,380667136877,NULL,1371755041,'1',NULL,0,'','0'),
(6757,NULL,'Вознюк Тетяна','2004-01-06','2021-09-28',NULL,380985619001,NULL,1170441670,'1',NULL,0,'','0'),
(6758,NULL,'Тарасенко Віталіна',NULL,'2021-09-28',NULL,380662798462,NULL,1797857483,'1',NULL,0,'','0'),
(6759,NULL,'Наконечна Тетяна','1997-10-18','2021-09-28',NULL,380984096671,NULL,1491502285,'1',NULL,0,'','0'),
(6760,NULL,'Волоська Марія ',NULL,'2021-09-30',NULL,380683802171,NULL,1163111517,'1',NULL,0,'','0'),
(6761,NULL,'Храплива Анастасія',NULL,'2021-09-30',NULL,380988781006,NULL,2040109041,'1',NULL,0,'','0'),
(6762,NULL,'Бережна Галина',NULL,'2021-09-30',NULL,380977514626,NULL,1185943274,'1',NULL,0,'','0'),
(6763,NULL,'Гепак Христина ',NULL,'2021-09-30',NULL,380982268676,NULL,1270562404,'1',NULL,0,'','0'),
(6764,NULL,'Шкрамко Тетяна ',NULL,'2021-10-01',NULL,380997992143,NULL,1227252430,'1',NULL,0,'','0'),
(6765,NULL,'Голяш Марія',NULL,'2021-10-01',NULL,380970884528,NULL,1977161830,'1',NULL,0,'','0'),
(6766,NULL,'Андрійчук Андріана',NULL,'2021-10-01',NULL,380686974329,NULL,1269053477,'1',NULL,0,'','0'),
(6767,NULL,'Винниченко Марія',NULL,'2021-10-01',NULL,380973445117,NULL,1842071216,'1',NULL,0,'','0'),
(6768,NULL,'Дикун Діана',NULL,'2021-10-01',NULL,380671150179,NULL,1559026987,'1',NULL,0,'','0'),
(6769,NULL,'Волощук Марія',NULL,'2021-10-01',NULL,380964318005,NULL,1877679954,'1',NULL,0,'','0'),
(6770,NULL,'Шмигельська Анастасія','2003-11-09','2021-10-01',NULL,380983587136,NULL,1483842094,'1',NULL,0,'','0'),
(6771,NULL,'Тарасенко Марія ','1990-07-12','2021-10-01',NULL,380966288288,380355220818,1116977034,'1',NULL,0,'
\n','0'),
(6772,NULL,'Середин Леся',NULL,'2021-10-02',NULL,380968072180,NULL,1638923955,'1',NULL,0,'','0'),
(6773,NULL,'',NULL,NULL,'Oo1N2VOkRTgpEk4OzrGHww==',NULL,NULL,1527672233,'1',45276,0,'','0'),
(6774,NULL,'Говда Марія',NULL,'2021-10-04',NULL,380934289864,NULL,1681795522,'1',NULL,0,'','0'),
(6775,NULL,'Ожда Софія',NULL,'2021-10-04',NULL,380637130212,NULL,1195728285,'1',NULL,0,'','0'),
(6776,NULL,'Тузик Марія ',NULL,'2021-10-04',NULL,380983757470,NULL,1630510952,'1',50882,0,'','0'),
(6778,NULL,'Мельник Наталя',NULL,'2021-10-05',NULL,380974893404,NULL,1556099503,'1',NULL,0,'','0'),
(6779,NULL,'Нетребяк Віталіна ',NULL,'2021-10-05',NULL,380988043429,NULL,1614381659,'1',NULL,0,'','0'),
(6780,NULL,'Кінаш Людмила ',NULL,'2021-10-05',NULL,380965407427,NULL,2013400234,'1',NULL,2,'','0'),
(6781,NULL,'ТимкІв Іванна',NULL,'2021-10-05',NULL,380974082554,NULL,1986456828,'1',NULL,0,'','0'),
(6782,NULL,'Матвіїв Галя',NULL,'2021-10-05',NULL,380962129719,NULL,1584477384,'1',NULL,0,'','0'),
(6783,NULL,'Ревуцьк Олександра',NULL,'2021-10-05',NULL,380686242970,NULL,1780209338,'1',NULL,0,'','0'),
(6784,NULL,'Кука Людмила ',NULL,'2021-10-05',NULL,380686951973,NULL,1615966079,'1',NULL,0,'','0'),
(6785,NULL,'Яцентюк Віолета',NULL,'2021-10-05',NULL,380660378230,NULL,2035216236,'1',NULL,0,'','0'),
(6786,NULL,'Кірілеска Олександра ',NULL,'2021-10-05',NULL,380988793301,NULL,1756544395,'1',NULL,0,'','0'),
(6787,NULL,'Повшик Юлія ',NULL,'2021-10-05',NULL,380683287536,NULL,1515039036,'1',NULL,0,'','0'),
(6788,NULL,'Туткалюк Юлія','1999-02-06','2021-10-05',NULL,380961944577,NULL,1631127959,'1',58509,0,'','0'),
(6789,NULL,'Демкович Катерина',NULL,'2021-10-06',NULL,380988889302,NULL,1833800303,'1',NULL,0,'','0'),
(6790,NULL,'Оробчук Наталя ',NULL,'2021-10-06',NULL,380686482882,NULL,1146163449,'1',NULL,0,'','0'),
(6791,NULL,'Дзевер Олександра ','1990-04-08','2021-10-06',NULL,380684230712,NULL,2029243157,'1',NULL,0,'','0'),
(6792,NULL,'Карпець Олена',NULL,'2021-10-06',NULL,380680549220,NULL,1350668825,'1',NULL,0,'','0'),
(6793,NULL,'Марцинків Єлизавета ',NULL,'2021-10-06',NULL,380965673114,NULL,1353119049,'1',NULL,0,'','0'),
(6794,NULL,'Бурдаківська Наталія',NULL,'2021-10-06',NULL,380674895986,NULL,1392189600,'1',NULL,0,'','0'),
(6795,NULL,'Махно Зеновія',NULL,'2021-10-06',NULL,380989267431,NULL,1338850463,'1',NULL,0,'','0'),
(6796,NULL,'мальована марія',NULL,'2021-10-06',NULL,380986193178,NULL,2073802724,'1',NULL,0,'','0'),
(6797,NULL,'Бобола Тетяна',NULL,'2021-10-07',NULL,380682466006,NULL,1190965218,'1',NULL,0,'','0'),
(6798,NULL,'Ковалик Аліна',NULL,'2021-10-07',NULL,380682469037,NULL,1240803447,'1',NULL,0,'','0'),
(6799,NULL,'Соколюк Ірина',NULL,'2021-10-07','bJbGt47ViG/0sEBR0qfBdw==',380984635231,NULL,1740696026,'1',58371,0,'','0'),
(6800,NULL,'Климко Ірина ','1996-05-24','2021-10-07',NULL,380969299080,NULL,1136601481,'1',53842,0,'','0'),
(6801,NULL,'Ніврик Юля',NULL,'2021-10-08',NULL,380977551508,NULL,1863522557,'1',NULL,0,'','0'),
(6802,NULL,'Ніврик Люба',NULL,'2021-10-08',NULL,380976052253,NULL,1791239926,'1',NULL,0,'','0'),
(6803,NULL,'Карбовська Любомира',NULL,'2021-10-08',NULL,380995100706,NULL,1252591436,'1',NULL,0,'','0'),
(6804,NULL,'Забчук Ольга ',NULL,'2021-10-08',NULL,380964914968,NULL,1203813552,'1',NULL,0,'','0'),
(6805,NULL,'Кучарська Ірина ',NULL,'2021-10-08',NULL,380986070095,NULL,1804869987,'1',NULL,0,'','0'),
(6806,NULL,'Василів Марія',NULL,'2021-10-09',NULL,380976516693,NULL,1565708320,'1',NULL,0,'','0'),
(6807,NULL,'Дмитрук Христина',NULL,'2021-10-09',NULL,380689674690,NULL,1118487897,'1',NULL,0,'','0'),
(6808,NULL,'Остапів Христина ',NULL,'2021-10-10',NULL,380979106914,NULL,2022687234,'1',NULL,0,'','0'),
(6809,NULL,'Возняк Віта ',NULL,'2021-10-10',NULL,380680881320,NULL,1262951273,'1',NULL,0,'','0'),
(6810,NULL,'Шута Ольга ',NULL,'2021-10-11',NULL,380953981573,NULL,1936010348,'1',NULL,0,'','0'),
(6811,NULL,'Цибульська Марія',NULL,'2021-10-11',NULL,380980748300,NULL,2103629445,'1',NULL,0,'','0'),
(6812,NULL,'Поливко Єлизавета ',NULL,'2021-10-11',NULL,380676789622,NULL,1570395970,'1',NULL,0,'','0'),
(6813,NULL,'Приступа Зоряна','1996-05-24','2021-10-11',NULL,380684404975,NULL,1291481982,'1',NULL,0,'','0'),
(6814,NULL,'Луців Вікторія',NULL,'2021-10-11',NULL,380967043477,NULL,1774930635,'1',NULL,0,'','0'),
(6815,NULL,'Стельмащук Ірина ',NULL,'2021-10-11',NULL,380501415345,NULL,1461157316,'1',NULL,0,'','0'),
(6816,NULL,'Косменко Христина ','1991-12-31','2021-10-11',NULL,380987456701,NULL,1493965874,'1',NULL,0,'','0'),
(6817,NULL,'Гураль Марія ',NULL,'2021-10-12',NULL,380685823218,NULL,1508615746,'1',NULL,0,'','0'),
(6818,NULL,'Онищак Надія',NULL,'2021-10-12',NULL,380678562646,NULL,1354092036,'1',NULL,0,'','0'),
(6819,NULL,'Шевчук Віра ',NULL,'2021-10-12',NULL,380672537653,NULL,1491354468,'1',NULL,0,'','0'),
(6820,NULL,'Стецик Ірина ',NULL,'2021-10-12',NULL,380689065259,NULL,2002698069,'1',NULL,0,'','0'),
(6821,NULL,'Кузь Оксана ',NULL,'2021-10-12',NULL,380987100266,NULL,1275779835,'1',NULL,0,'','0'),
(6822,NULL,'Карпіш Марта',NULL,'2021-10-13',NULL,380673510655,NULL,1729937535,'1',NULL,0,'','0'),
(6823,NULL,'Мостович Вікторія',NULL,'2021-10-13',NULL,380687708391,NULL,1183228706,'1',NULL,0,'','0'),
(6824,NULL,'Karolina Slavina','1999-04-23','2021-10-13',NULL,380506324790,NULL,1645886518,'1',NULL,1,'','0'),
(6825,NULL,'Рената Звір',NULL,'2021-10-14',NULL,380965559602,NULL,1998768582,'1',NULL,0,'','0'),
(6826,NULL,'Гордієнко Іра',NULL,'2021-10-15',NULL,380678964446,NULL,1666557204,'1',NULL,0,'','0'),
(6827,NULL,'Градова Світлана',NULL,'2021-10-15',NULL,380975757700,NULL,1777548627,'1',NULL,0,'','0'),
(6828,NULL,'Зайшла Оксана',NULL,'2021-10-15',NULL,380681547665,NULL,1595416743,'1',NULL,0,'','0'),
(6829,NULL,'Осадча Ірина',NULL,'2021-10-15',NULL,380681762554,NULL,1311776774,'1',NULL,0,'','0'),
(6830,NULL,'Янчук Ірина',NULL,'2021-10-15',NULL,380933823440,NULL,1478487932,'1',NULL,0,'','0'),
(6831,NULL,'Нербишев Ігор ',NULL,'2021-10-15',NULL,380680930574,NULL,1452954982,'1',NULL,0,'','0'),
(6832,NULL,'Дідик Анастасія','1996-01-14','2021-10-16',NULL,380983471161,NULL,1836887075,'1',NULL,0,'','0'),
(6833,NULL,'жегарські уляна',NULL,'2021-10-18',NULL,380684637058,NULL,1441074645,'1',NULL,0,'','0'),
(6834,NULL,'Полянська Іра',NULL,'2021-10-18',NULL,380662813626,NULL,1909588641,'1',NULL,0,'','0'),
(6835,NULL,'Комар Наталія ',NULL,'2021-10-19',NULL,380960599883,NULL,1803074183,'1',NULL,0,'','0'),
(6836,NULL,'Мацієшин Тетяна ',NULL,'2021-10-20',NULL,380982920910,NULL,1439474375,'1',NULL,0,'','0'),
(6837,NULL,'Кузь Надія',NULL,'2021-10-21',NULL,380686722025,NULL,1436618572,'1',NULL,0,'','0'),
(6838,NULL,'Джубаба Крістіна','1998-04-17','2021-10-22',NULL,380971448247,NULL,1288768676,'1',34923,0,'','0'),
(6839,NULL,'Фарбота Уляна',NULL,'2021-10-23',NULL,380965017477,NULL,1487978581,'1',NULL,0,'','0'),
(6840,NULL,'Величко Світлана',NULL,'2021-10-23',NULL,380674972466,NULL,1266518658,'1',NULL,0,'','0'),
(6841,NULL,'Батрин Оксана',NULL,'2021-10-23',NULL,380980098361,NULL,1482228318,'1',NULL,0,'','0'),
(6842,NULL,'Кирилів Наталя',NULL,'2021-10-23',NULL,380984510495,NULL,1713835154,'1',NULL,0,'','0'),
(6843,NULL,'Слома Лілія','1999-07-13','2021-10-23',NULL,380971473338,380971473338,1151648933,'1',NULL,0,'','0'),
(6844,NULL,'Попадюк Вікторія ',NULL,'2021-10-24',NULL,380977700909,NULL,1281785868,'1',NULL,0,'','0'),
(6845,NULL,'Мелимука Марія',NULL,'2021-10-25',NULL,380979070593,NULL,1944879773,'1',NULL,0,'','0'),
(6846,NULL,'Підгуречна Ольга',NULL,'2021-10-25',NULL,380986157905,NULL,1754804817,'1',NULL,0,'','0'),
(6847,NULL,'Ігор Джубаба','1973-01-25','2021-10-25',NULL,380970403934,NULL,1796008630,'1',NULL,0,'','0'),
(6848,NULL,'Наталія Погорецька','2002-12-20','2021-10-26',NULL,380678881568,380678881568,2019818395,'1',NULL,0,'','0'),
(6849,NULL,'Коліщинська Оксана',NULL,'2021-10-26',NULL,380967658424,NULL,1867104043,'1',NULL,0,'','0'),
(6850,NULL,'Сандуляк Степанія',NULL,'2021-10-28',NULL,380962124347,NULL,2024595074,'1',NULL,0,'','0'),
(6851,NULL,'Григорків Оксанаа',NULL,'2021-10-28',NULL,380677522727,NULL,1202355808,'1',NULL,0,'','0'),
(6852,NULL,'Деркач Людмила',NULL,'2021-10-28',NULL,380675374106,NULL,1226937751,'1',NULL,0,'','0'),
(6869,NULL,'Кухарчук Карінв',NULL,'2021-11-05','OhwNzxN1TV/5C5Lk2Gp9qw==',380686724030,NULL,1774279504,'1',NULL,0,'','0'),
(6853,NULL,'Фанок Марія ',NULL,'2021-10-28',NULL,380960510215,NULL,1510003937,'1',NULL,0,'','0'),
(6854,NULL,'Жедік Наталя',NULL,'2021-10-29',NULL,380687099848,NULL,1717673758,'1',NULL,1,'','0'),
(6855,NULL,'Катя Івушин','2000-12-11','2021-10-30',NULL,380502034234,NULL,1953387090,'1',NULL,0,'','0'),
(6856,NULL,'Сорочук Наталія',NULL,'2021-11-01',NULL,380680649240,NULL,1734001229,'1',NULL,0,'','0'),
(6857,NULL,'Костинський Володимир',NULL,'2021-11-01',NULL,380972423288,NULL,2013272174,'1',NULL,0,'','0'),
(6858,NULL,'богальюля',NULL,'2021-11-01',NULL,380938925922,NULL,1779875523,'1',NULL,0,'','0'),
(6859,NULL,'Урбанська Оксана ',NULL,'2021-11-02',NULL,380678105502,NULL,2003548232,'1',NULL,0,'','0'),
(6860,NULL,'Братак Ірина',NULL,'2021-11-02',NULL,380988421379,NULL,1704246176,'1',NULL,0,'','0'),
(6861,NULL,'Катеренюк Любов',NULL,'2021-11-02',NULL,380962460834,NULL,2011686598,'1',NULL,0,'','0'),
(6862,NULL,'Стадник Надія',NULL,'2021-11-03',NULL,380971740231,NULL,1126536679,'1',NULL,0,'','0'),
(6863,NULL,'Івахів Оксана',NULL,'2021-11-03',NULL,380933721780,NULL,1119394068,'1',NULL,0,'','0'),
(6864,NULL,'Мандзяк Гаталя',NULL,'2021-11-04',NULL,380976263813,NULL,1582161466,'1',NULL,0,'','0'),
(6865,NULL,'Гігійчук Наталія',NULL,'2021-11-04',NULL,380685639928,NULL,1600135910,'1',NULL,0,'','0'),
(6866,NULL,'Солодка Анастасія ',NULL,'2021-11-04',NULL,380988035938,NULL,2136040323,'1',NULL,0,'','0'),
(6868,NULL,'Скоромна Юлія',NULL,'2021-11-05',NULL,380688422434,NULL,1665380709,'1',NULL,0,'','0'),
(6870,NULL,'Калакайло Анастасія ','1998-04-04','2021-11-06',NULL,380932127670,NULL,1211527194,'1',NULL,0,'','0'),
(6871,NULL,'Лапій Ірина','2004-01-08','2021-11-07',NULL,380932742967,380632770948,1719122804,'1',NULL,0,'','0'),
(6872,NULL,'Стадник Анастасія ',NULL,'2021-11-07',NULL,380689885093,NULL,2085624084,'1',NULL,0,'','0'),
(6873,NULL,'Євгенія ',NULL,'2021-11-08',NULL,380673677817,NULL,1664327544,'1',NULL,0,'','0'),
(6874,NULL,'Романюк Зіна',NULL,'2021-11-08',NULL,380685885863,NULL,1583750666,'1',NULL,2,'','0'),
(6875,NULL,'Наталія Крючко','1990-05-19','2021-11-08',NULL,380683512129,NULL,2016821539,'1',NULL,0,'','0'),
(6876,NULL,'Коцюк Тетяна',NULL,'2021-11-08',NULL,380980954759,NULL,1441445465,'1',NULL,0,'','0'),
(6877,NULL,'Кітура Катерина',NULL,'2021-11-08',NULL,380988776511,NULL,2138397915,'1',NULL,0,'','0'),
(6878,NULL,'Попадюк Іванна ','1996-07-31','2021-11-08',NULL,380689829192,NULL,1111544553,'1',NULL,0,'
\n
\n
\n','0'),
(6879,NULL,'Крушельницька Богдана',NULL,'2021-11-09',NULL,380982339036,NULL,1705192647,'1',NULL,1,'','0'),
(6880,NULL,'Молодан Оксана',NULL,'2021-11-09',NULL,380987323429,NULL,1297119548,'1',NULL,0,'','0'),
(6881,NULL,'Марія Андрухів','3003-09-03','2021-11-09','QXeiO8AtNCW/h1tlpjeK+Q==',380978622415,NULL,1450331390,'1',53772,0,'','0'),
(6882,NULL,'Ганушевська Анастасія ','2004-06-17','2021-11-10',NULL,380668655090,NULL,1121100167,'1',NULL,0,'','0'),
(6883,NULL,'Панасик діана',NULL,'2021-11-10',NULL,380984631585,NULL,1189824203,'1',NULL,0,'','0'),
(6884,NULL,'Корнієнко Аміна',NULL,'2021-11-10',NULL,380689847515,NULL,1355765729,'1',NULL,0,'','0'),
(6885,NULL,'Кавулич Івана ',NULL,'2021-11-10',NULL,380974237977,NULL,1817025139,'1',NULL,0,'','0'),
(6886,NULL,'Павлюк Ліля',NULL,'2021-11-11',NULL,380976064213,NULL,1486147653,'1',NULL,0,'','0'),
(6887,NULL,'Ковалишин Андріана',NULL,'2021-11-11',NULL,380971355720,NULL,1955843656,'1',NULL,0,'','0'),
(6888,NULL,'Луцишин Галина',NULL,'2021-11-12',NULL,380677519039,NULL,1290016150,'1',NULL,0,'','0'),
(6889,NULL,'Боклащук Іра',NULL,'2021-11-12',NULL,380987676348,NULL,1603842224,'1',NULL,0,'','0'),
(6890,NULL,'Огороднік Ірочка',NULL,'2021-11-13',NULL,380988777306,NULL,1380549632,'1',NULL,0,'','0'),
(6891,NULL,'Повшок Світлана ',NULL,'2021-11-13',NULL,380971306700,NULL,1722640317,'1',NULL,0,'','0'),
(6892,NULL,'Янковська-Приплесь Ольга','1996-07-29','2021-11-15',NULL,380976226329,NULL,1932924998,'1',NULL,0,'','0'),
(6893,NULL,'Осадчук Наталя',NULL,'2021-11-15',NULL,380982348102,NULL,2104088977,'1',NULL,0,'','0'),
(6894,NULL,'Магаляс Аня',NULL,'2021-11-15',NULL,380680760864,NULL,1630661226,'1',47806,0,'','0'),
(6895,NULL,'Басіста Надія',NULL,'2021-11-15',NULL,380682464548,NULL,1636013496,'1',NULL,0,'','0'),
(6896,NULL,'Писанюк Наталія',NULL,'2021-11-16',NULL,380686499373,NULL,1214231524,'1',NULL,0,'','0'),
(6897,NULL,'Бендик Ірина',NULL,'2021-11-16',NULL,380686082691,NULL,1180444919,'1',NULL,0,'','0'),
(6899,NULL,'Туркіць Ольга ',NULL,'2021-11-18',NULL,380983698735,NULL,1406981586,'1',NULL,0,'','0'),
(6900,NULL,'Сидор Руслана',NULL,'2021-11-18',NULL,380961091492,NULL,1866941775,'1',NULL,0,'','0'),
(6901,NULL,'Данилевич Маряна',NULL,'2021-11-19',NULL,380988117743,NULL,1957011643,'1',NULL,0,'','0'),
(6902,NULL,'Легка Наталія',NULL,NULL,NULL,380686088162,NULL,1789157090,'',NULL,0,'','0'),
(6903,NULL,'Смеречинська Маша',NULL,NULL,NULL,380685871794,NULL,1891581703,'',NULL,0,'','0'),
(6912,NULL,'настя наша',NULL,NULL,NULL,380969787401,NULL,1444521172,'',NULL,0,'','0'),
(6904,NULL,'Надія Ружицька','2009-10-01','2021-11-19',NULL,380678379819,380678379819,2121399750,'1',NULL,0,'','0'),
(6905,NULL,'Левандовська Ліза','2004-08-25','2021-11-21',NULL,380672560799,380672560779,1281950980,'1',NULL,0,'','0'),
(6906,NULL,'Татарин Івана ',NULL,'2021-11-22',NULL,380988031567,NULL,1908658653,'1',NULL,0,'','0'),
(6907,NULL,'Діана Боднар','2004-11-24','2021-11-22',NULL,380662794651,NULL,1953112385,'1',NULL,0,'','0'),
(6908,NULL,'Греськів Олена ','2006-02-25','2021-11-22',NULL,380501757116,380501757116,1544247517,'1',NULL,0,'','0'),
(6909,NULL,'Шлінк Тетяна ',NULL,'2021-11-22',NULL,380965141480,NULL,1859926125,'1',NULL,0,'','0'),
(6910,NULL,'Греськів Христя',NULL,'2021-11-22',NULL,380978695390,NULL,1697575088,'1',NULL,0,'','0'),
(6911,NULL,'Лопушняк Ірина з товстого',NULL,'2021-11-22',NULL,380968398654,NULL,1544128856,'1',NULL,0,'','0'),
(6913,NULL,'Вонсович Вікторія',NULL,'2021-11-23',NULL,380973132862,NULL,1732962422,'1',NULL,0,'','0'),
(6914,NULL,'Іванців Христина',NULL,'2021-11-23',NULL,380688424987,NULL,2124388715,'1',NULL,0,'','0'),
(6915,NULL,'Бельма таня',NULL,'2021-11-23',NULL,380982903404,NULL,1814260444,'1',NULL,0,'','0'),
(6916,NULL,'Боровська Віта',NULL,'2021-11-23',NULL,380989595349,NULL,1283520901,'1',NULL,0,'','0'),
(6917,NULL,'Ангел Ірина',NULL,'2021-11-23',NULL,380988629190,NULL,1947736143,'1',NULL,0,'','0'),
(6918,NULL,'Соловій Марта',NULL,'2021-11-23',NULL,380680946662,NULL,1779291326,'1',NULL,0,'','0'),
(6919,NULL,'Наріжняк Ярина',NULL,'2021-11-23','CBaSZL0lfQGcDozfkc6AvQ==',380961886746,NULL,1365841325,'1',NULL,0,'','0'),
(6920,NULL,'Стефанів Ореста',NULL,'2021-11-23',NULL,380985938537,NULL,1526554307,'1',NULL,0,'','0'),
(6921,NULL,'андрій',NULL,'2021-11-23',NULL,380680722954,NULL,1487436839,'1',NULL,0,'','0'),
(6922,NULL,'Веськера Зоряна',NULL,'2021-11-23',NULL,380977961123,NULL,1804920033,'1',NULL,0,'','0'),
(6923,NULL,'Соляр Інна',NULL,'2021-11-24',NULL,380978475648,NULL,1432207299,'1',NULL,0,'','0'),
(6924,NULL,'Ландяк Олеся',NULL,'2021-11-24',NULL,380968742335,NULL,1843570597,'1',NULL,0,'','0'),
(6925,NULL,'Цимбаліста Уляна ',NULL,'2021-11-24',NULL,380987450951,NULL,1140086002,'1',NULL,0,'','0'),
(6926,NULL,'Кирилів андріана',NULL,'2021-11-25',NULL,380961894708,NULL,1851857818,'1',NULL,0,'','0'),
(6927,NULL,'Середа Оксана',NULL,'2021-11-25',NULL,380971198320,NULL,2089506711,'1',NULL,0,'','0'),
(6928,NULL,'Паскевич Марія',NULL,'2021-11-25',NULL,380664417044,NULL,2029690014,'1',NULL,0,'','0'),
(6929,NULL,'Ричаківська Оксана','1997-02-14','2021-11-26',NULL,380961624094,NULL,1263929076,'1',NULL,0,'
\n','0'),
(6930,NULL,'Глова Юля',NULL,'2021-11-26',NULL,380978971882,NULL,1371008595,'1',NULL,0,'','0'),
(6931,NULL,'Цапяк Сніжана ',NULL,'2021-11-28',NULL,380970119031,NULL,1728335988,'1',NULL,0,'','0'),
(6993,NULL,'Панчук Марина',NULL,'2021-12-20',NULL,380683242029,NULL,1468137562,'1',NULL,0,'','0'),
(6932,NULL,'Білас Христина','1996-10-26','2021-11-29',NULL,380988038669,NULL,1289668927,'1',NULL,0,'','0'),
(6933,NULL,'Кіско Юля',NULL,'2021-11-29',NULL,380977390169,NULL,1175100692,'1',NULL,0,'','0'),
(6934,NULL,'Шумська Тетяна','2001-02-07','2021-11-29',NULL,380971198307,NULL,1203925258,'1',NULL,0,'','0'),
(6935,NULL,'Полева Інна',NULL,'2021-11-29',NULL,380971183052,NULL,1624599063,'1',NULL,0,'','0'),
(6936,NULL,'Хомин Тетяна ',NULL,'2021-11-29',NULL,380978529332,NULL,1992856084,'1',NULL,0,'','0'),
(6937,NULL,'Біланик Наталя ',NULL,'2021-11-30',NULL,380961103568,NULL,1740238320,'1',NULL,0,'','0'),
(6938,NULL,'Капчук Надія',NULL,'2021-11-30',NULL,300966197726,NULL,1138885791,'1',NULL,0,'','0'),
(6939,NULL,'Голуб Галина',NULL,'2021-11-30',NULL,380971724435,NULL,1579698550,'1',NULL,0,'','0'),
(6940,NULL,'Мальована Катерина',NULL,'2021-11-30',NULL,380684941168,NULL,1783067258,'1',NULL,0,'','0'),
(6941,NULL,'Ковальчук Маряна ',NULL,'2021-11-30',NULL,380973420798,NULL,1306720909,'1',NULL,0,'','0'),
(6942,NULL,'Безпалько Надія',NULL,'2021-11-30',NULL,380988144979,NULL,2122357148,'1',NULL,0,'','0'),
(6943,NULL,'Шурка Вікторія',NULL,'2021-12-01',NULL,380682441811,NULL,1620648521,'1',NULL,0,'','0'),
(6944,NULL,'Ониськів Любов',NULL,'2021-12-01',NULL,380685936779,NULL,1514581256,'1',NULL,0,'','0'),
(6945,NULL,'Велиган Марія',NULL,'2021-12-01',NULL,380501784424,NULL,1309861863,'1',NULL,0,'','0'),
(6946,NULL,'Оксинюк Надія',NULL,'2021-12-01',NULL,380684248259,NULL,1539038854,'1',NULL,0,'','0'),
(6947,NULL,'Мартинчк Ольга',NULL,'2021-12-02',NULL,380959222711,NULL,1744913743,'1',NULL,0,'','0'),
(6948,NULL,'Шевчук Оксана',NULL,'2021-12-02',NULL,380666307589,NULL,1934495210,'1',NULL,0,'','0'),
(6949,NULL,'Ярема Марія',NULL,'2021-12-02',NULL,380976710813,NULL,2085467124,'1',NULL,0,'','0'),
(6950,NULL,'Бабяк Руслана',NULL,'2021-12-02','+BKsoj1el47TZv0ABVQAtQ==',380687036908,NULL,1634650842,'1',NULL,0,'','0'),
(6951,NULL,'Кокітко Леоніда',NULL,'2021-12-03',NULL,380987580994,NULL,1557108380,'1',NULL,0,'','0'),
(6952,NULL,'Пригар Таня',NULL,'2021-12-03',NULL,380969827678,NULL,1526910479,'1',NULL,0,'','0'),
(6953,NULL,'Левінська Юля',NULL,'2021-12-04',NULL,380977958883,NULL,1589023061,'1',NULL,0,'','0'),
(6954,NULL,'Гладиш Наталя ',NULL,'2021-12-05',NULL,380687171348,NULL,1379447259,'1',NULL,0,'','0'),
(6955,NULL,'Плаксюк віка',NULL,'2021-12-05',NULL,380685045372,NULL,1285097437,'1',NULL,0,'','0'),
(6956,NULL,'Шуфліста Ольга',NULL,'2021-12-06',NULL,380687605048,NULL,1844142408,'1',NULL,0,'','0'),
(6957,NULL,'Палагнюк ольга ',NULL,'2021-12-06',NULL,380681696506,NULL,1632252855,'1',NULL,0,'','0'),
(6958,NULL,'Друк Вікторія',NULL,'2021-12-06',NULL,380983548123,NULL,1524679626,'1',NULL,0,'','0'),
(6959,NULL,'Лялік Галина',NULL,'2021-12-07',NULL,380963297595,NULL,1388957279,'1',NULL,0,'','0'),
(6960,NULL,'Турчак Ніна',NULL,'2021-12-07',NULL,380966708732,NULL,1502619104,'1',NULL,0,'','0'),
(6961,NULL,'Мельничук Галя',NULL,'2021-12-08',NULL,380989944973,NULL,1598590616,'1',NULL,0,'','0'),
(6962,NULL,'Рудик Ліана',NULL,'2021-12-08',NULL,380987741778,NULL,1916970224,'1',NULL,0,'','0'),
(6963,NULL,'Салайчук Лілія ',NULL,'2021-12-08',NULL,380678595480,NULL,1138342757,'1',NULL,0,'','0'),
(6964,NULL,'Гуйван Галина',NULL,'2021-12-09',NULL,380682469038,NULL,1389611621,'1',NULL,0,'','0'),
(6965,NULL,'Гуйван Христина',NULL,'2021-12-09',NULL,390971974470,NULL,1734013081,'1',NULL,0,'','0'),
(6966,NULL,'Галат Вікторія ',NULL,'2021-12-09',NULL,380687158580,NULL,1719538986,'1',NULL,0,'','0'),
(6971,NULL,'Хруставка Юля ',NULL,'2021-12-12',NULL,380686088148,NULL,2043000113,'1',NULL,0,'','0'),
(6967,NULL,'Крепич Марія',NULL,'2021-12-11',NULL,380663225730,NULL,1682246862,'1',NULL,0,'','0'),
(6968,NULL,'Берик Вікторія',NULL,'2021-12-11',NULL,380964283497,NULL,1178955444,'1',NULL,0,'','0'),
(6969,NULL,'Кушнір Інна',NULL,'2021-12-11',NULL,380975979233,NULL,1885884651,'1',NULL,0,'','0'),
(6970,NULL,'Леснічук Ірина ',NULL,'2021-12-11',NULL,380674585883,NULL,2108992017,'1',NULL,0,'','0'),
(6972,NULL,'Боднар Юля',NULL,'2021-12-12',NULL,380683635307,NULL,1884361509,'1',NULL,0,'','0'),
(6973,NULL,'Сливяк Христина ',NULL,'2021-12-13',NULL,380686955158,NULL,1438878469,'1',NULL,0,'','0'),
(6974,NULL,'МиколаЇнко Тетяна',NULL,'2021-12-13',NULL,380974085121,NULL,1522608166,'1',NULL,0,'','0'),
(6975,NULL,'Грабовська Ірина',NULL,'2021-12-14',NULL,380992029391,NULL,1976817967,'1',NULL,0,'','0'),
(6976,NULL,'Доскочинська Ірина',NULL,'2021-12-14',NULL,380672725590,NULL,1826095254,'1',NULL,0,'','0'),
(6977,NULL,'Король маряна ',NULL,'2021-12-14',NULL,380984622401,NULL,1569411885,'1',NULL,0,'','0'),
(6978,NULL,'Бойчук Сніжана ',NULL,'2021-12-15',NULL,380970452845,NULL,1955845944,'1',NULL,0,'','0'),
(6979,NULL,'Кириченко Алла',NULL,'2021-12-15',NULL,380956396226,NULL,1403145259,'1',NULL,0,'','0'),
(6980,NULL,'Захарова Ольга',NULL,'2021-12-15',NULL,380984761983,NULL,1206498141,'1',NULL,0,'','0'),
(6981,NULL,'Наконечна Олександра',NULL,'2021-12-15',NULL,380988779545,NULL,1718418282,'1',NULL,0,'','0'),
(6982,NULL,'Драчова Марія ',NULL,'2021-12-16',NULL,380966755806,NULL,1748925816,'1',NULL,0,'','0'),
(6983,NULL,'Сова Олеся ',NULL,'2021-12-16',NULL,380971684097,NULL,2051653437,'1',NULL,0,'','0'),
(6984,NULL,'Куфета Чвітлана',NULL,'2021-12-16',NULL,380962865662,NULL,1780730182,'1',NULL,0,'','0'),
(6985,NULL,'Полутренко Марія',NULL,'2021-12-16',NULL,380952488300,NULL,1269617188,'1',NULL,0,'','0'),
(6986,NULL,' Полутренко Марія',NULL,'2021-12-16',NULL,380502488300,NULL,2000027301,'1',NULL,0,'','0'),
(6987,NULL,'Іванців Анастасія ',NULL,'2021-12-16',NULL,380509554177,NULL,1285733863,'1',NULL,0,'','0'),
(6988,NULL,'Басіста Надія ',NULL,'2021-12-16',NULL,380685211094,NULL,1263018243,'1',NULL,0,'','0'),
(6989,NULL,'Мельник Юля',NULL,'2021-12-17',NULL,380979559190,NULL,1451460341,'1',NULL,0,'','0'),
(6990,NULL,'Мельник Таня',NULL,'2021-12-17',NULL,380982295492,NULL,1745906451,'1',NULL,0,'','0'),
(6991,NULL,'Франценс Світлана',NULL,'2021-12-17',NULL,380975477553,NULL,1687157955,'1',NULL,0,'','0'),
(6992,NULL,'ГУдь Аліна',NULL,'2021-12-17',NULL,380962776127,NULL,1764617086,'1',NULL,0,'','0'),
(6994,NULL,'Плішка Анастасія',NULL,'2021-12-20',NULL,380962462507,NULL,1334867156,'1',NULL,0,'','0'),
(6995,NULL,'Лихо марія',NULL,'2021-12-20',NULL,380672842320,NULL,1313628491,'1',NULL,0,'','0'),
(6996,NULL,'Гранична Анна',NULL,'2021-12-20',NULL,380974468112,NULL,1379790329,'1',NULL,0,'','0'),
(6997,NULL,'Юрків Оксана Йосипівна',NULL,'2021-12-20',NULL,380955644595,NULL,1993983802,'1',NULL,0,'','0'),
(6998,NULL,'Рембоха Ольга ',NULL,'2021-12-20',NULL,380687968237,NULL,1860145402,'1',NULL,0,'','0'),
(6999,NULL,'Дунь Ірина ',NULL,'2021-12-21',NULL,380989038417,NULL,1608967597,'1',NULL,0,'','0'),
(7000,NULL,'Лісова Вікторія ',NULL,'2021-12-21',NULL,380982663029,NULL,1978364701,'1',NULL,0,'','0');

INSERT INTO `kontragentu` VALUES 
(7001,NULL,'Демянів Леся ',NULL,'2021-12-21',NULL,380966203436,NULL,1503089881,'1',NULL,0,'','0'),
(7002,NULL,'Войцехівська Тетяна ',NULL,'2021-12-21',NULL,380985071465,NULL,1782596597,'1',NULL,0,'','0'),
(7003,NULL,'Гуль Таня ',NULL,'2021-12-23',NULL,380961789630,NULL,1302017134,'1',NULL,0,'','0'),
(7004,NULL,'Шпак Галина ',NULL,'2021-12-23',NULL,390992979742,NULL,1757296094,'1',NULL,0,'','0'),
(7005,NULL,'Старостіна Галя',NULL,'2021-12-23',NULL,380688310746,NULL,1301894715,'1',NULL,0,'','0'),
(7006,NULL,'Юхим Марія',NULL,'2021-12-24',NULL,380968236777,NULL,1163880317,'1',NULL,0,'','0'),
(7007,NULL,'Аврамишин Вікторія',NULL,'2021-12-26',NULL,380502168013,NULL,1450701289,'1',NULL,0,'','0'),
(7008,NULL,'Шкільнюк Світлана',NULL,'2021-12-27',NULL,380686751635,NULL,1711347733,'1',NULL,0,'','0'),
(7009,NULL,'Кінах Марія ',NULL,'2021-12-27',NULL,380674276182,NULL,2022341910,'1',NULL,0,'','0'),
(7010,NULL,'Смикальна Анастасія',NULL,'2021-12-27',NULL,380990292113,NULL,1276060077,'1',NULL,0,'','0'),
(7011,NULL,'Кватирук Юля',NULL,'2021-12-27',NULL,380675236415,NULL,1737834090,'1',NULL,0,'','0'),
(7012,NULL,'Кравчук Анастасія ',NULL,'2021-12-27',NULL,380934761486,NULL,2110356109,'1',NULL,0,'','0'),
(7013,NULL,'Гутман Вікторія ',NULL,'2021-12-28',NULL,380969299031,NULL,1665209290,'1',NULL,0,'','0'),
(7014,NULL,'Зубкевич Олена',NULL,'2021-12-30',NULL,380677951482,NULL,1432099850,'1',NULL,0,'','0'),
(7015,NULL,'Заєць Ольга',NULL,'2021-12-30',NULL,380974797226,NULL,1749280383,'1',NULL,0,'','0'),
(7016,NULL,'Шлапак Сергій',NULL,'2021-12-30',NULL,380968703012,NULL,1935975675,'1',NULL,0,'','0');

DROP TABLE IF EXISTS `lang_articles`;

CREATE TABLE `lang_articles` (
  `id` smallint(4) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `type` smallint(4) NOT NULL DEFAULT 0,
  `pidtype` smallint(4) NOT NULL DEFAULT 0,
  `script_verh` text NOT NULL,
  `script_nuz` text NOT NULL,
  `menu_derevo` mediumint(5) NOT NULL DEFAULT 0,
  `comentari` smallint(1) NOT NULL DEFAULT 1,
  `title_uk` varchar(255) NOT NULL,
  `keywords_uk` text NOT NULL,
  `description_uk` text NOT NULL,
  `korotko_uk` text NOT NULL,
  `text_uk` text NOT NULL,
  `title_ru` varchar(255) NOT NULL,
  `keywords_ru` text NOT NULL,
  `description_ru` text NOT NULL,
  `korotko_ru` text NOT NULL,
  `text_ru` text NOT NULL,
  `title_en` varchar(255) NOT NULL,
  `keywords_en` text NOT NULL,
  `description_en` text NOT NULL,
  `korotko_en` text NOT NULL,
  `text_en` text NOT NULL,
  `time` int(10) NOT NULL DEFAULT 0,
  `reklama` enum('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci PACK_KEYS=0;

DROP TABLE IF EXISTS `lang_menu_derevo`;

CREATE TABLE `lang_menu_derevo` (
  `id` mediumint(5) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL DEFAULT '/',
  `fathercode` mediumint(6) NOT NULL DEFAULT 0,
  `name_uk` varchar(120) NOT NULL,
  `name_ru` varchar(120) NOT NULL,
  `name_en` varchar(120) NOT NULL,
  `sort` smallint(4) NOT NULL DEFAULT 0,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

DROP TABLE IF EXISTS `lang_pidtypes`;

CREATE TABLE `lang_pidtypes` (
  `id` smallint(4) NOT NULL AUTO_INCREMENT,
  `type_id` smallint(4) NOT NULL DEFAULT 0,
  `uk` varchar(60) NOT NULL,
  `ru` varchar(60) NOT NULL,
  `en` varchar(60) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Підтипи до табл lang_articles (стовпчик pidtype)';

DROP TABLE IF EXISTS `lang_types`;

CREATE TABLE `lang_types` (
  `id` smallint(4) NOT NULL AUTO_INCREMENT,
  `uk` varchar(60) NOT NULL,
  `ru` varchar(60) NOT NULL,
  `en` varchar(60) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='типи для таблиці lang_articles (стовпчик type)';

DROP TABLE IF EXISTS `langs`;

CREATE TABLE `langs` (
  `id` smallint(4) NOT NULL AUTO_INCREMENT,
  `sections` enum('1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30','31','32','33','34','35','36','37','38','39','40','41','42','43','44','45','46','47','48','49','50','51','52','53','54','55','56','57','58','59','60','61','62','63','64') DEFAULT NULL,
  `key` varchar(30) NOT NULL,
  `support` enum('0','1') NOT NULL DEFAULT '1' COMMENT '0-компонент знято з підтримки, 1- компонент на підтримці і буде оновлюватись з бази розробника ',
  `name_uk` varchar(2000) NOT NULL,
  `name_ru` varchar(2000) NOT NULL,
  `name_en` varchar(2000) NOT NULL,
  `remark` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=MyISAM AUTO_INCREMENT=437 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci PACK_KEYS=0;

INSERT INTO `langs` VALUES 
(1,NULL,'login_vhid','1','Увійти','','',''),
(2,NULL,'login_nikname','1','Нік(піб)','','',''),
(3,NULL,'login_nick_zaniat','1','Нік(піб) вже зайнятий, виберіть інший','','',''),
(4,NULL,'login_incorect_email','1','Поле email не коректне','','',''),
(5,NULL,'login_zapov_ren_email','1','Введіть дійсний email для відновлення доступу до сайту','','',''),
(6,NULL,'login_tel_zaniat','1','Номер телефону вже зареєстрований в системі, спробуйте <span onclick=\\\"loginforma_renew();\\\" style=\\\"text-decoration:underline; cursor:pointer;\\\">відновити свій обліковий запис</span>.','','',''),
(7,NULL,'login_incorect_tel','1','Номер телефону не коректний','','',''),
(8,NULL,'login_email_zaniat','1','Email вже зареєстрований в системі, спробуйте відновити свій обліковий запис, за цим email','','',''),
(9,NULL,'login_nekid','1','Був введений не коректний телефон або email','','',''),
(10,NULL,'login_nepr_lp','1','Не правильна комбінація логіна і пароля','','',''),
(11,NULL,'login_nouser','1','Не знайдено користувача із таким обліковим записом','','',''),
(12,NULL,'login_incorect','1','Не заповнено поле логін або пароль, або вони не коректні','','',''),
(13,NULL,'login_user','1','nik/email/telephone','','',''),
(14,NULL,'login_remember_me','1','Запам\\\"ятати мене','','',''),
(15,NULL,'login_reg','1','Реєстрація','','',''),
(16,NULL,'login_renewal','1','Відновити пароль','','',''),
(17,NULL,'login_zareg','1','Зареєструватись','','',''),
(18,NULL,'login_m_tel','1','Моб.&nbsp;Телефон','','',''),
(19,NULL,'login','1','Логін','','',''),
(20,NULL,'Password','1','Пароль','','',''),
(21,NULL,'login_new_password','1','Новий пароль','','',''),
(22,NULL,'login_zabulu','1','Відновити пароль','','',''),
(23,NULL,'login_uvijtu','1','Увійти','','',''),
(24,NULL,'login_empty_nikname','1','Заповніть поле Нік(піб)','','',''),
(25,NULL,'login_korotkuy_nik','1','Поле Нік занадто коротке, або незаповнене','','',''),
(26,NULL,'login_empty_email','1','Заповніть поле email','','',''),
(27,NULL,'login_empty_m_tel','1','Заповніть поле мобільний телефон','','',''),
(28,NULL,'login_incorect_m_tel','1','Не коректно заповнено поле мобільний телефон','','',''),
(29,NULL,'login_empty_password','1','Заповніть поле Пароль','','',''),
(30,NULL,'login_korotkuy_password','1','Поле пароль занадто коротке','','',''),
(31,NULL,'login_reg_projshla','1','Реєстрація пройшла успішно.','','',''),
(32,NULL,'email','1','Електронна пошта','','',''),
(33,NULL,'vernytus','1','Вернутись','','',''),
(34,NULL,'login_fio','1','П.І.Б.','','',''),
(35,NULL,'login_empty_fio','1','Заповніть поле П.І.Б.','','',''),
(36,NULL,'login_korotke_fio','1','Поле П.І.Б. занадато коротке','','',''),
(37,NULL,'login_vidn_pass','1','Відновлення паролю','','',''),
(38,NULL,'login_renew_text','1','Будь ласка, введіть Вашу адресу електронної пошти, на яку ми вишлемо лист для відновлення паролю.','','',''),
(39,NULL,'login_vidnovutu','1','Відновити','','',''),
(40,NULL,'login_zgadav','1','Згадав','','',''),
(41,NULL,'login_uspishnuy_vhid','1','Ви успішно увійшли, для продовження ','','',''),
(42,NULL,'login_uspishna_reg','1','Ви успішно зареєструвались, для продовження ','','',''),
(43,NULL,'login_click_here','1','натисніть тут','','',''),
(44,NULL,'login_email_nosearch','1','Користувача із такою одресою не зареєстровано','','',''),
(45,NULL,'login_ren_subject','1','Відновлення доступу до сайту dvigok.com.ua','','',''),
(46,NULL,'login_em_p1','1','<p>Доброго дня.</p> <p>Хтось - можливо, Ви - намагалися і не змогли увійти у свій профіль на dvigok.com.ua і спробували відновити пароль. Для того щоб задати новий пароль, перейдіть за посиланням: ','','',''),
(47,NULL,'login_em_p2','1','</p> <p>Якщо ви не запитували цю інформацію, не хвилюйтесь - просто ігноруйте цей лист.</p> <p>&nbsp;</p><p>Команда <a href=\\\"http://dvigok.com.ua\\\">dvigok.com.ua</a>.</p>','','',''),
(48,NULL,'login_mail_send_1','1','Електронний лист надіслано, перейдіть в свою поштову скриньку на сайті ','','',''),
(49,NULL,'login_mail_send_2','1',', щоб отримати новий пароль','','',''),
(50,NULL,'zv_uvagu','1','Зверніть увагу','','',''),
(51,NULL,'login_vs_n_pass','1','Встановлення нового паролю','','',''),
(52,NULL,'login_vstanovutu','1','Встановити','','',''),
(53,NULL,'login_zn_n_passw','1','Введіть новий пароль','','',''),
(54,NULL,'login_error_no_n_p','1','Ви не ввели новий пароль, або ввели занадто короткий пароль, поверніться на попередню сторінку і заповніть поле \\\"Новий пароль\\\"','','',''),
(55,NULL,'login_p_vstanovleno','1','Пароль встановлено, натисніть кнопку \\\"Увійти\\\", щоб автоматично авторизуватись на сайті','','',''),
(56,NULL,'login_settings','1','Налаштування облікового запису','','',''),
(57,NULL,'login_rozlog_othpc','1','Вийти зі свого облікового запису на інших пристроях','','',''),
(58,NULL,'login_oth_pc_vukunuto','1','Ви успішно вийшли зі свого облікового запису на інших пристроях','','',''),
(59,NULL,'login_oth_pc_nevuk','1','Сталася помилка під час виходу з облікового запису на інших пристроях','','',''),
(60,NULL,'login_empty_name_admina','1','Не заповнено поле \\\"логін адміністратора\\\"','','',''),
(61,NULL,'login_incorect_pass','1','Не вірний пароль','','',''),
(62,NULL,'admins','1','Адміністратори','','',''),
(63,NULL,'status','1','Статус','','',''),
(64,NULL,'tel','1','Телефон','','',''),
(65,NULL,'stadmin','1','Старший Адміністратор','','',''),
(66,NULL,'admin','1','Адміністратор','','',''),
(67,NULL,'stvorutu','1','Створити','','',''),
(68,NULL,'ker_ob_zap','1','Керування обліковим записом адміністратора ','','',''),
(69,NULL,'zag_info_adm','1','Загальне','','',''),
(70,NULL,'stat_ob_zap','1','Статус облікового запису','','',''),
(71,NULL,'ob_zap_del','1','Обліковий запис видалено','','',''),
(72,NULL,'ob_dost_po_ip','1','Обмеження доступу по IP','','',''),
(73,NULL,'ob_dost_po_cookie','1','Обмеження доступу по Cookie','','',''),
(74,NULL,'on','1','Ввімкнено','','',''),
(75,NULL,'vudalutu','1','Видалити','','',''),
(76,NULL,'mess_tmp_pass','1','Адміністратору призначено пароль: ','','',''),
(77,NULL,'pyst_obl_zapus','1','Пустий обліковий запис вже було створено, відредагуйте <a href=\\\"?select=admins\\\">його</a>','','',''),
(78,NULL,'New','1','Новий','','',''),
(79,NULL,'ponujennia','1','Не можливо вносити такі зміни у свій обліковий запис','','',''),
(80,NULL,'ne_kor_ip','1','Не коректний IP адміністратора','','',''),
(81,NULL,'ne_diysnuy_ip','1','З цієї IP-адреси Вам не дозволено заходити на сайт, попросіть Старшого Адміністратора добавити ваш ір 127.0.0.1 в \\\"список довірених\\\"','','',''),
(82,NULL,'informer','1','Інформер','','',''),
(83,NULL,'date','1','Дата','','',''),
(84,NULL,'text','1','Текст','','',''),
(85,NULL,'adminka_title','1','Центр краси ','','',''),
(86,NULL,'od_vumiry','1','Одиниці виміру','','',''),
(87,NULL,'undelete','1','Відновити','','',''),
(88,NULL,'q_undelete','1','Ви впевнені що хочете відновити цей елемент?','','',''),
(89,NULL,'q_delete','1','Ви впевнені що хочете видалити цей елемент?','','',''),
(90,NULL,'najmenuvannia','1','Найменування','','',''),
(91,NULL,'specifications','1','Характеристики','','',''),
(92,NULL,'sp_tovariv','1','Характеристики товарів','','',''),
(93,NULL,'products','1','Товари','','',''),
(94,NULL,'rekvizut','1','Реквізит','','',''),
(95,NULL,'value','1','Значення','','',''),
(96,NULL,'nazva','1','Назва','','',''),
(97,NULL,'opus','1','Опис','','',''),
(98,NULL,'price','1','Ціна','','',''),
(99,NULL,'old_price','1','Стара ціна','','',''),
(100,NULL,'stocks','1','Залишок','','',''),
(101,NULL,'status_stoks','1','Статус залишку','','',''),
(102,NULL,'status_stoks_0','1','Закінчився','','',''),
(103,NULL,'status_stoks_1','1','Закінчується','','',''),
(104,NULL,'status_stoks_2','1','В наявності','','',''),
(105,NULL,'new_product','1','Новий продукт','','',''),
(106,NULL,'action','1','Акція','','',''),
(107,NULL,'deletest','1','Видалений','','',''),
(108,NULL,'pictures','1','Картинки','','',''),
(109,NULL,'add_pictures','1','Додати картинки','','',''),
(110,NULL,'edit_pictures','1','Редагувати картинки','','',''),
(111,NULL,'stvoreno_tovar','1','Товар створено','','',''),
(112,NULL,'st_tov_pereytu','1','Перейти до щойно створеного товару','','',''),
(113,NULL,'file_est','1','Такий файл вже є на сервері, поміняйте імя файлу','','',''),
(114,NULL,'upl_insite','1','Завантаження картинок на сервер','','',''),
(115,NULL,'files','1','Файли','','',''),
(116,NULL,'http_pict','1','HTTP картинка','','',''),
(117,NULL,'z_in_site','1','(з іншого сайту)','','',''),
(118,NULL,'opus_pict','1','Опис картинки <i>(alt)</i>','','',''),
(119,NULL,'new_pict_name','1','Нове ім`я<br /><small style=\\\"color:#666;\\\">(тільки англійська)</small>','995','',''),
(120,NULL,'upload','1','Завантажити','','',''),
(121,NULL,'delete_file','1','Видалити файл','','',''),
(122,NULL,'zagalne','1','Загальне','','',''),
(123,NULL,'log_mess','1','Лог повідомлень','','',''),
(124,NULL,'ups_pictures_sk','1','Завант. картинок','','',''),
(125,NULL,'comments','1','Коментарі','','',''),
(126,NULL,'cookie_editor','1','Cookie редактор','','',''),
(127,NULL,'pidpuska','1','Підписка -@-','','',''),
(128,NULL,'my_ekaunt','1','Мій аккаунт','','',''),
(129,NULL,'bacup_bd','1','Бекап Бази Даних','','',''),
(130,NULL,'mysql_editor','1','MySQL редактор','','',''),
(131,NULL,'help','1','Допомога','','',''),
(132,NULL,'articles','1','Статті','','',''),
(133,NULL,'add_article','1','Створити статтю','','',''),
(134,NULL,'articles_derevo','1','Меню дерево статей','','',''),
(135,NULL,'editor_types','1','Редактор типів','','',''),
(136,NULL,'int_magazin','1','Інт. магазин','','',''),
(137,NULL,'katalog','1','Каталог','','',''),
(138,NULL,'exit_admin','1','Закінчити роботу','','',''),
(139,NULL,'backup_zrobleno','1','Бекап зроблено','','',''),
(140,NULL,'download_arhiv','1','Завантажити архів','','',''),
(141,NULL,'pok_komm_zar_kl','1','Показувати коментарі зареєстрованих клієнтів','','',''),
(142,NULL,'no_valid','1','Не перевірений','','',''),
(143,NULL,'valid','1','Перевірений','','',''),
(144,NULL,'vudalennia','1','Видалення','','',''),
(145,NULL,'zast_zminu','1','Застосувати зміни','','',''),
(146,NULL,'site_email','1','Сайт, email','','',''),
(147,NULL,'comm_text','1','Текст Коментаря','','',''),
(148,NULL,'provaliduvatu','1','Провалідувати','','',''),
(149,NULL,'unvalidation','1','Вімінити валідацію','','',''),
(150,NULL,'email_pidpuska','1','Підписка на email','','',''),
(151,NULL,'pidpuska_help','1','тут можна переглянути cписок<br /> email адрес, що підписались на розсилку','','',''),
(152,NULL,'clear_log','1','Очистити лог','','',''),
(153,NULL,'vub_type_st','1','Виберіть тип статті','','',''),
(154,NULL,'vub_pidtype_st','1','Виберіть підтип статті','','',''),
(155,NULL,'type_st','1','Тип статті','','',''),
(156,NULL,'pidtype_st','1','Підтип статті','','',''),
(157,NULL,'adds_article','1','Менеджер створнення статті','','',''),
(158,NULL,'dali','1','Далі','','',''),
(159,NULL,'editor_statey','1','Редактор статей','','',''),
(160,NULL,'dod_settings','1','Додаткові налаштування','','',''),
(161,NULL,'reklama','1','Реклама','','',''),
(162,NULL,'polazuvatu','1','Показувати','','',''),
(163,NULL,'nepolazuvatu','1','Не показувати','','',''),
(164,NULL,'delete_art','1','Видалення статті','','',''),
(165,NULL,'delete_article','1','Видалити статтю','','',''),
(166,NULL,'dell_q1','1','Ви впевнені що хочете без зворотньо видалити цей запис?','','',''),
(167,NULL,'dell_q2','1','Ці зміни будуть не зворотні, продовжуєм?','','',''),
(168,NULL,'zap_zmanu','1','Спершу запишіть зміни, щоб видалити цю статтю','','',''),
(169,NULL,'script_verh','1','Скрипт \\\"Верх\\\"','','',''),
(170,NULL,'script_nuz','1','Скрипт \\\"Низ\\\"','','',''),
(171,NULL,'all_cats','1',' всі категорії','','',''),
(172,NULL,'rozgornytu','1','Розгорнути','','',''),
(173,NULL,'zgornytu','1','Згорнути','','',''),
(174,NULL,'root','1','Корінь','','',''),
(175,NULL,'art_dell','1','Стаття видалена з бази','','',''),
(176,NULL,'go_glavna','1','перейти на головну','','',''),
(177,NULL,'art_zajniato','1','Створення статті не здійснено, можливо такий url вже існує','','',''),
(178,NULL,'url_obovazkove','1','Поле url обовязкове для заповнення','','',''),
(179,NULL,'nevkazanuy_id','1','Не вказаний id статті','','',''),
(180,NULL,'perekl_vizual','1','Переключити візуалізатор?','','',''),
(181,NULL,'no_save','1','В цьому режимі Збереження працює через іконку зберегти в вікні редагування тексту статті (іконка дискети)','','',''),
(182,NULL,'save','1','Зберегти','','',''),
(183,NULL,'komentuvannia','1','коментування','','',''),
(184,NULL,'menu','1','Меню','','',''),
(185,NULL,'struktura','1','Структура','','',''),
(186,NULL,'red_pidkat','1','Редактор підкатегорій','','',''),
(187,NULL,'add','1','Додати','','',''),
(188,NULL,'onovutu','1','Оновити','','',''),
(189,NULL,'sp_har_zam','1','Список характеристик по замовчуванню для цієї категорії','','',''),
(190,NULL,'sp_tovs','1','Список товарів для цієї категорії','','',''),
(191,NULL,'slideshow','1','Слайд шоу','','',''),
(192,NULL,'zagolovok','1','Заголовок','','',''),
(193,NULL,'dod_text','1','Додатковий текст','','',''),
(194,NULL,'batkivska_dur','1','Змінити батьківську директорію','','',''),
(195,NULL,'valuty','1','Грошові одиниці','','',''),
(196,NULL,'valyta','1','Грошова одиниця','','',''),
(197,NULL,'nazad_title','1','Назад','','',''),
(198,NULL,'nazad','1','Назад','','',''),
(199,NULL,'glv','1','Головна','','',''),
(200,NULL,'groups_tsin','1','Групи цін','','',''),
(201,NULL,'cart','1','Корзина','','',''),
(202,NULL,'empty_cart','1','Ваша корзина пуста.','','',''),
(203,NULL,'product','1','Продукт','','',''),
(204,NULL,'kilkist','1','Кількість','','',''),
(205,NULL,'suma','1','Сума','','',''),
(206,NULL,'delete_tovar','1','Видалити цю позицію','','',''),
(207,NULL,'comentar_zamovl','1','Коментар до замовлення','','',''),
(208,NULL,'end_zakaza','1','Замовлення підтверджую','','',''),
(209,NULL,'kataloga_nema','1','Каталогаа не знайдено','','',''),
(210,NULL,'print_zakaz','1','Роздрукувати замовлення','','',''),
(211,NULL,'kod_tovara','1','Код товару','','',''),
(212,NULL,'grn','1','грн.','','',''),
(213,NULL,'zamovlennia','1','Замовлення','','',''),
(214,NULL,'vid','1','від','','',''),
(215,NULL,'data_z','1','Дата з','','',''),
(216,NULL,'data_do','1','Дата до','','',''),
(239,NULL,'pidbur_tovs_0','1','Розпочате','','',''),
(218,NULL,'pay_method','1','Спосіб оплати','','',''),
(245,NULL,'sposib_op_0','1','Готівка при отриманні','','',''),
(220,NULL,'edit','1','редагувати','','',''),
(221,NULL,'vlasnuk','1','Власник','','',''),
(222,NULL,'in_cart','1','В корзині ','','',''),
(223,NULL,'tovar','1','покупка','','',''),
(224,NULL,'tovariv','1','покупки','','',''),
(225,NULL,'tovariv_big','1','покупок','','',''),
(226,NULL,'link','1','Посилання','','',''),
(227,NULL,'pereglianytu','1','Переглянути','','',''),
(228,NULL,'recommended','1','Рекомендований','','',''),
(229,NULL,'discount','1','Знижка','','',''),
(230,NULL,'ne_vuk_umovu_ajax','1','Не виконані всі необхідні умови для виконання ajax-запиту','','',''),
(231,NULL,'langs','1','Мови','','',''),
(232,NULL,'error_internet','1','Помилка: Відсутній доступ до мережі Інтернет, перевірте з\\\'єднання і повторіть спробу','','',''),
(233,NULL,'name','1','Ім\\\'я','','',''),
(234,NULL,'login_ch_komp','1','Чужий комп\\\'ютер','','',''),
(235,NULL,'search','1','Пошук','Поиск','',''),
(240,NULL,'pidbur_tovs_1','1','Оформлене','','',''),
(241,NULL,'pidbur_tovs_2','1','Опрацьоване','','',''),
(242,NULL,'pidbur_tovs_3','1','Скасоване','','',''),
(243,NULL,'pidbur_tovs_4','1','Передане в 1С','','',''),
(244,NULL,'pidbur_tovs_5','1','Завершене','','',''),
(246,NULL,'sposib_op_1','1','Передоплата на картку Приватбанку','','',''),
(247,NULL,'empty_komirku','1','Підсвітити незаповнені комірки','','',''),
(248,NULL,'code','1','Код','','',''),
(249,NULL,'save_all','1','Зберегти всі','','',''),
(250,NULL,'cron','1','Плановані завдання','','',''),
(251,NULL,'date_start','1','Дата початку','','',''),
(252,NULL,'date_end','1','Дата закінчення','','',''),
(253,NULL,'days','1','Дні','','',''),
(254,NULL,'time_start','1','Час початку','','',''),
(255,NULL,'periodicity','1','Періодичність','','',''),
(256,NULL,'d1','1','Пн.','','',''),
(257,NULL,'d2','1','Вт.','','',''),
(258,NULL,'d3','1','Ср.','','',''),
(259,NULL,'d4','1','Чт.','','',''),
(260,NULL,'d5','1','Пт.','','',''),
(261,NULL,'d6','1','Сб.','','',''),
(262,NULL,'d7','1','Нд.','','',''),
(263,NULL,'warning','1','Увага','','',''),
(264,NULL,'optumizator','1','Оптимізатор','','',''),
(265,NULL,'klients','1','Клієнти','','',''),
(266,NULL,'poslygu','1','Послуги','','',''),
(267,NULL,'pratsivnuku','1','Працівники','','',''),
(268,NULL,'L_nastupna','1','Наступна','','',''),
(269,NULL,'L_porepedn','1','Попередня','','',''),
(270,NULL,'L_pokazano','1','Показано','','',''),
(271,NULL,'nazva_poslygu','1','Назва послуги','','',''),
(272,NULL,'prava','1','Права','','',''),
(273,NULL,'rozrobnuk','1','Програміст','','',''),
(274,NULL,'director','1','Директор','','',''),
(275,NULL,'admin_salony','1','Адміністратор салону','','',''),
(276,NULL,'pratsivnuk_salony','1','Працівник салону','','',''),
(277,NULL,'korustuvachi','1','Користувачі','','',''),
(278,NULL,'tvukposl','1','Час вик. послуг','','',''),
(279,NULL,'timevukposl','1','Час виконання послуг працівниками','','',''),
(280,NULL,'schedule','1','Розклад','','',''),
(281,NULL,'groups','1','Групи','','',''),
(282,NULL,'group','1','Група','','',''),
(283,NULL,'bezgroup','1','Без групи','','',''),
(284,NULL,'all','1','Всі','','',''),
(285,NULL,'poslyga','1','Послуга','','',''),
(286,NULL,'vub_poslygy','1','Виберіть послугу','','',''),
(287,NULL,'no_time_posl','1','В цього майстра не проставленгий час виконання його послуг, спершу <a href=\\\"?select=time_vuk_poslug\\\">тут заповніть</a> час виконання ним послуг','','',''),
(288,NULL,'master','1','Майстер','','',''),
(289,NULL,'time','1','Час','','',''),
(290,NULL,'klient','1','Клієнт','','',''),
(291,NULL,'kartka','1','Картка','','',''),
(292,NULL,'pib','1','ПІБ','','',''),
(293,NULL,'tel2','1','Тел.2','','',''),
(294,NULL,'tel_korotko','1','Тел.','','',''),
(295,NULL,'truvalist','1','Тривалість','','',''),
(296,NULL,'zakinn','1','Закінчення','','',''),
(297,NULL,'mysql_console','1','MSQL консоль','','',''),
(298,NULL,'vunevubkonr','1','Ви не вибрали клієнта, або не заповнили інформацію про нового клієнта','','',''),
(299,NULL,'oj','1','Ой...','','',''),
(300,NULL,'comment','1','Коментар','','',''),
(301,NULL,'delete_event','1','Видалити запис','','',''),
(302,NULL,'create_payment','1','Створити оплату','','',''),
(303,NULL,'no_prav','1','Не достатньо прав для здійснення цієї операції','','',''),
(304,NULL,'del_record_conf','1','Ви впевнені що бажаєте видалити запис?','','',''),
(305,NULL,'materialu','1','Матеріали','','',''),
(306,NULL,'oplata','1','Оплата послуг','','',''),
(307,NULL,'vsiogo','1','Всього','','',''),
(308,NULL,'zajniato','1','Зайнято','','',''),
(309,NULL,'oplatcheno','1','Оплачено','','',''),
(310,NULL,'sms_service','1','СМС сервіс','','',''),
(311,NULL,'malonarah','1','У Вас на смс-рахунку мала кількість коштів. <a href=\\\"?select=sms_service\\\">Поповніть свій рахунок</a>','','',''),
(312,NULL,'kasa_zvit','1','Фінансовий звіт','','',''),
(313,NULL,'vn_oplatu','1','Внести кошти','','',''),
(314,NULL,'ob_klienta','1','Виберіть клієнта','','',''),
(315,NULL,'m01','1','січня','','',''),
(316,NULL,'m02','1','лютого','','',''),
(317,NULL,'m03','1','березня','','',''),
(318,NULL,'m04','1','квітня','','',''),
(319,NULL,'m05','1','травня','','',''),
(320,NULL,'m06','1','червня','','',''),
(321,NULL,'m07','1','липня','','',''),
(322,NULL,'m08','1','серпня','','',''),
(323,NULL,'m09','1','вересня','','',''),
(324,NULL,'m10','1','жовтня','','',''),
(325,NULL,'m11','1','листопада','','',''),
(326,NULL,'m12','1','грудня','','',''),
(327,NULL,'sms_poperedj','1','Зачекайте! Надсилаються смс. Не виконуйте ніяких дій у браузері.','','',''),
(328,NULL,'stat_1','1','Розробник','','',''),
(329,NULL,'stat_2','1','Директор','','',''),
(330,NULL,'stat_3','1','Адміністратор салону','','',''),
(331,NULL,'stat_4','1','Майстер','','',''),
(332,NULL,'vid_rank_god','1','Відображати ранкові години','','',''),
(333,NULL,'new_pib','1','ПІБ нового клієнта','','',''),
(334,NULL,'pro_kor_tel_format','1','Поле телефон повинно бути у форматі 380хххххххххх','','',''),
(335,NULL,'pay_docs','1','Касові документи','','',''),
(336,NULL,'vart_mat','1','Вартість матеріалів','','',''),
(337,NULL,'vart_posl','1','Вартість послуг','','',''),
(338,NULL,'zavd','1','№ Завдання','','',''),
(339,NULL,'dd0','1','неділя','','',''),
(340,NULL,'dd1','1','понеділок','','',''),
(341,NULL,'dd2','1','вівторок','','',''),
(342,NULL,'dd3','1','середа','','',''),
(343,NULL,'dd4','1','четвер','','',''),
(344,NULL,'dd5','1','п\\\'ятниця','','',''),
(345,NULL,'dd6','1','субота','','',''),
(346,NULL,'add_vacation','1','Створити відпустку','','',''),
(347,NULL,'zabronuv','1','Забронювати час','','',''),
(348,NULL,'err_prom_vajniat','1','В даному проміжку дат вже є створені завдання, внести вихідні дні неможливо. Спочатку видаліть існуючі забронювані клієнтами місця','','',''),
(349,NULL,'err_nev_dates','1','Не вірні значення в дати, виправіть дату','','',''),
(350,NULL,'dell_holiday','1','Видалити вихідний день','','',''),
(351,NULL,'inp_pass','1','Введіть пароль','','',''),
(352,NULL,'vud_zarplatu','1','Видати зарплату','','',''),
(353,NULL,'vut_koshtiv','1','Витрати коштів','','',''),
(354,NULL,'sum_groshey','1','Сума грошей','','',''),
(355,NULL,'st_doc_vt_kosh','1','Створення документу витрата коштів','','',''),
(356,NULL,'st_doc_vud_zp','1','Створення документу видача зарплати','','',''),
(357,NULL,'pole_pr_ne_zap','1','Вкажіть працівника','','',''),
(358,NULL,'zap_date','1','Заповніть поле \\\"Дата\\\"','','',''),
(359,NULL,'zap_cash','1','Заповніть поле \\\"Сума грошей\\\"','','',''),
(360,NULL,'zap_note','1','Заповніть поле \\\"Коментар\\\"','','',''),
(361,NULL,'oth_vutr','1','Інші витрати','','',''),
(362,NULL,'author','1','Автор','','',''),
(363,NULL,'dr0','1','неділю','','',''),
(364,NULL,'dr1','1','понеділок','','',''),
(365,NULL,'dr2','1','вівторок','','',''),
(366,NULL,'dr3','1','середу','','',''),
(367,NULL,'dr4','1','червер','','',''),
(368,NULL,'dr5','1','п\\\'ятницю','','',''),
(369,NULL,'dr6','1','суботу','','',''),
(370,NULL,'history','1','Історія','','',''),
(371,NULL,'zvit_shedules','1','Звіт \\\"Розклад\\\"','','',''),
(372,NULL,'zap_pr','1','Просто запишись на прийом','','',''),
(373,NULL,'zap_online','1','Ви можете записатись на прийом онлайн','','',''),
(374,NULL,'settings','1','Налаштування','','',''),
(375,NULL,'kl_ne_pruyshov','1','Клієнт не з\\\'явився','','',''),
(376,NULL,'ne_zyav','1','Не з\\\'явився','','',''),
(377,NULL,'poslygu_folders','1','Групи послуг','','',''),
(378,NULL,'folder','1','Папка','','',''),
(379,NULL,'ne_vkazano','1','Не вказано','','',''),
(380,NULL,'perepahunok_propuskiv','1','Перерахунок пропусків','','',''),
(381,NULL,'mn1','1','Січень','','',''),
(382,NULL,'mn2','1','Лютий','','',''),
(383,NULL,'mn3','1','Березень','','',''),
(384,NULL,'mn4','1','Квітень','','',''),
(385,NULL,'mn5','1','Травень','','',''),
(386,NULL,'mn6','1','Червень','','',''),
(387,NULL,'mn7','1','Липень','','',''),
(388,NULL,'mn8','1','Серпень','','',''),
(389,NULL,'mn9','1','Вересень','','',''),
(390,NULL,'mn10','1','Жовтень','','',''),
(391,NULL,'mn11','1','Листопад','','',''),
(392,NULL,'mn12','1','Грудень','','',''),
(393,NULL,'history_shedules','1','Історія розкладу','','',''),
(394,NULL,'history_payments','1','Історія оплат','','',''),
(395,NULL,'history_types','1','Типи подій історії','','',''),
(396,NULL,'zvitu','1','Звіти','','',''),
(397,NULL,'finan','1','Фінанси','','',''),
(398,NULL,'vtkkl','1','Відтік клієнтів','','',''),
(399,NULL,'zappole','1','Заповніть поле ','Заполните поле ','',''),
(400,NULL,'zmpass','1','Для зміни паролю, введіть новий пароль','Для изменения пароля введите пароль','',''),
(401,NULL,'role','1','Роль','Роль','',''),
(402,NULL,'delete_status_0','1','Працює','','',''),
(403,NULL,'delete_status_1','1','Звільнений','','',''),
(404,NULL,'adm_stat_1','1','Розробник','','',''),
(405,NULL,'adm_stat_2','1','Директор','','',''),
(406,NULL,'adm_stat_3','1','Адміністратор салону','','',''),
(407,NULL,'adm_stat_4','1','Майстер','','',''),
(408,NULL,'sname','1','Салон краси LIKE','','',''),
(409,NULL,'picture','1','Картинка','','',''),
(410,NULL,'remark','1','Примітка','','',''),
(411,NULL,'bookingUrl','','https://like-beauty.com.ua/booking/','','','ссилка на бронювання, для кожної бази своя'),
(412,NULL,'Like_tel1','1','0672929804','','',''),
(413,NULL,'Like_tel2','1','0936329533','','',''),
(414,NULL,'Swipe_tel1','1','0987992123','','',''),
(415,NULL,'Swipe_tel2','1','','','','Покищо порожньо'),
(416,NULL,'active','1','Активний','','',''),
(417,NULL,'booadr','1','вул. Шевченка 16а','','',''),
(418,NULL,'stitle','1','Like - салон краси, м. Чортків','','',''),
(419,NULL,'sh1','1','LIKE - салон краси','','',''),
(420,NULL,'botname','1','like-beauty','','',''),
(421,NULL,'cnst','1','м. Чортків, вул. Шевченка 16а','','',''),
(422,NULL,'tlink','1','<a href=\"tel:0672929804\">тел. +38 (067) 292-98-04</a>','','',''),
(423,NULL,'period','1','Період','','',''),
(424,NULL,'yes','1','Так','','',''),
(425,NULL,'vbms','1','Оберіть майстра','','',''),
(426,NULL,'matrix','1','Матриця','','',''),
(427,NULL,'colorb','1','Колір фону','','',''),
(428,NULL,'matrs','1','Матеріали','','',''),
(429,NULL,'filt','1','Фільтр','','',''),
(430,NULL,'munts','1','Одиниці виміру матеріалів','','',''),
(431,NULL,'odvum','1','Одиниця виміру','','',''),
(432,NULL,'prsp','1','Приходи списання','','',''),
(433,NULL,'zvvmat','1','Звіт з використання матеріалів','','',''),
(434,NULL,'minQuty','1','Мінімальна кількість на залишку','','',''),
(435,NULL,'minStock','1','Тільки мінімальні залишки','','',''),
(436,NULL,'crReport','1','Сформувати звіт','','','');

DROP TABLE IF EXISTS `langs_sections`;

CREATE TABLE `langs_sections` (
  `id` tinyint(2) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `sort` tinyint(2) unsigned NOT NULL DEFAULT 0,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci PACK_KEYS=0 COMMENT='Розділи для таблиці langs';

DROP TABLE IF EXISTS `materials`;

CREATE TABLE `materials` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `fathercode` tinyint(3) unsigned DEFAULT NULL COMMENT 'Із тбл. poslygu_folders',
  `name_uk` varchar(50) NOT NULL,
  `name_ru` varchar(50) NOT NULL,
  `price` decimal(8,2) NOT NULL DEFAULT 0.00 COMMENT 'Ціна за одиницю матеріала',
  `materials_units_id` tinyint(3) unsigned DEFAULT NULL COMMENT 'ОДиниця виміру',
  `minQuantity` smallint(5) unsigned NOT NULL DEFAULT 1 COMMENT 'Мінімальна кількість одиниць матеріалу, після якої звіт відображає її червоним ',
  `sort` smallint(5) unsigned NOT NULL DEFAULT 0,
  `comment` varchar(255) NOT NULL,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=331 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Довідник Матеріали';

INSERT INTO `materials` VALUES 
(1,7,'кайколор12/26сіра','',3.33,1,10,1,'','0'),
(2,7,'кайколор12/62','',3.33,1,10,2,'','0'),
(3,7,'кайколор8/13','',3.33,1,10,3,'','0'),
(4,7,'кайколор4/0','',3.33,1,10,4,'','0'),
(5,7,'кайколор12/26','',3.33,1,10,5,'','0'),
(6,7,'кайколор7/1','',3.33,1,10,6,'','0'),
(7,7,'кайколор7/64сіра','',3.33,1,10,7,'','0'),
(8,7,'кайколор9/22','',3.33,1,10,8,'','0'),
(9,7,'кайколор7/32','',3.33,1,10,9,'','0'),
(10,7,'кайколор7/0','',3.33,1,10,10,'','0'),
(11,7,'кайколор8/32','',3.33,1,10,11,'','0'),
(12,7,'кайколор7/66','',3.33,1,10,12,'','0'),
(13,7,'кайколор9/32','',3.33,1,10,13,'','0'),
(14,7,'кайколор7/003','',3.33,1,10,14,'','0'),
(15,7,'кайколор8/1','',3.33,1,10,15,'','0'),
(16,7,'кайколор7/18','',3.33,1,10,16,'','0'),
(17,7,'кайколор7/34','',3.33,1,10,17,'','0'),
(18,7,'кайколор6/18','',3.33,1,10,18,'','0'),
(19,7,'кайколор7/13','',3.33,1,10,19,'','0'),
(20,7,'кайколор7/44','',3.33,1,10,20,'','0'),
(21,7,'кайколор5/6','',3.33,1,10,21,'','0'),
(22,7,'кайколор5/22','',3.33,1,10,22,'','0'),
(23,7,'кайколор5/0','',3.33,1,10,23,'','0'),
(24,7,'кайколор6/1','',3.33,1,10,24,'','0'),
(25,7,'кайколор6/0','',3.33,1,10,25,'','0'),
(26,7,'кайколор8/0','',3.33,1,10,26,'','0'),
(27,7,'кайколор12/21','',3.33,1,10,27,'','0'),
(28,7,'кайколор9/00','',3.33,1,10,28,'','0'),
(29,7,'кайколор8/003','',3.33,1,10,29,'','0'),
(30,7,'кайколор5/18','',3.33,1,10,30,'','0'),
(31,7,'кайколор7/4','',3.33,1,10,31,'','0'),
(32,7,'кайколор7/62','',3.33,1,10,32,'','0'),
(33,7,'кайколор6/003','',3.33,1,10,33,'','0'),
(34,7,'кайколор7/00','',3.33,1,10,34,'','0'),
(35,7,'кайколор9/0','',3.33,1,10,35,'','0'),
(36,7,'кайколор9/13','',3.33,1,10,36,'','0'),
(37,7,'кайколор1/0','',3.33,1,10,37,'','0'),
(38,7,'кайколор5/66','',3.33,1,10,38,'','0'),
(39,7,'кайколор4/4','',3.33,1,10,39,'','0'),
(40,7,'кайколор7/46','',3.33,1,10,40,'','0'),
(41,7,'кайколор9/003','',3.33,1,10,41,'','0'),
(42,7,'коректорсиній','',3.33,1,10,42,'','0'),
(43,7,'лонда6/77','',6.54,1,10,43,'','0'),
(44,7,'лонда8/71','',6.54,1,10,44,'','0'),
(45,7,'лонда7/75','',6.54,1,10,45,'','0'),
(46,7,'лонда6/75','',6.54,1,10,46,'','0'),
(47,7,'лонда8/38','',6.54,1,10,47,'','0'),
(48,7,'лонда7/74','',6.54,1,10,48,'','0'),
(49,7,'лонда8/3','',6.54,1,10,49,'','0'),
(50,7,'лонда8/44','',6.54,1,10,50,'','0'),
(51,7,'лонда8/41','',6.54,1,10,51,'','0'),
(52,7,'лонда7/38','',6.54,1,10,52,'','0'),
(53,7,'лонда10/96','',6.54,1,10,53,'','0'),
(54,7,'лонда10/38','',6.54,1,10,54,'','0'),
(55,7,'лонда8/65','',6.54,1,10,55,'','0'),
(56,7,'лонда9/36','',6.54,1,10,56,'','0'),
(57,7,'лонда9/16','',6.54,1,10,57,'','0'),
(58,7,'лонда12/81','',6.54,1,10,58,'','0'),
(59,7,'лонда8/73','',6.54,1,10,59,'','0'),
(60,7,'лонда12/61','',6.54,1,10,60,'','0'),
(61,7,'лонда10/6','',6.54,1,10,61,'','0'),
(62,7,'лонда9/17','',6.54,1,10,62,'','0'),
(63,7,'лонда7/4','',6.54,1,10,63,'','0'),
(64,7,'лонда12/1','',6.54,1,10,64,'','0'),
(65,7,'лонда8/','',6.54,1,10,65,'','0'),
(66,7,'лонда9/1','',6.54,1,10,66,'','0'),
(67,7,'лонда7/77','',6.54,1,10,67,'','0'),
(68,7,'лонда7/7','',6.54,1,10,68,'','0'),
(69,7,'лонда12/7','',6.54,1,10,69,'','0'),
(70,7,'лонда9/38','',6.54,1,10,70,'','0'),
(71,7,'лонда8/7','',6.54,1,10,71,'','0'),
(72,7,'лонда12/89','',6.54,1,10,72,'','0'),
(73,7,'лонда6/0','',6.54,1,10,73,'','0'),
(74,7,'лонда9/7','',6.54,1,10,74,'','0'),
(75,7,'лонда9/','',6.54,1,10,75,'','0'),
(76,7,'лонда10/73','',6.54,1,10,76,'','0'),
(77,7,'лонда7/07','',6.54,1,10,77,'','0'),
(78,7,'лондакоректор065','',6.54,1,10,78,'','0'),
(79,7,'лондакоректор056','',6.54,1,10,79,'','0'),
(80,7,'лондакоректор068','',6.54,1,10,80,'','0'),
(81,7,'лонда10/8','',6.54,1,10,81,'','0'),
(82,7,'вела8/35','',12.15,1,10,82,'','0'),
(83,7,'вела6/37','',12.15,1,10,83,'','0'),
(84,7,'велакоректор065','',12.15,1,10,84,'','0'),
(85,7,'велакоректор6/97','',12.15,1,10,85,'','0'),
(86,7,'вела10/','',12.15,1,10,86,'','0'),
(87,7,'вела10/36','',12.15,1,10,87,'','0'),
(88,7,'вела9/43','',12.15,1,10,88,'','0'),
(89,7,'вела9/60','',12.15,1,10,89,'','0'),
(90,7,'вела5/81','',12.15,1,10,90,'','0'),
(91,7,'вела10/93','',12.15,1,10,91,'','0'),
(92,7,'вела6/16','',12.15,1,10,92,'','0'),
(93,7,'вела8/13','',12.15,1,10,93,'','0'),
(94,7,'вела9/7','',12.15,1,10,94,'','0'),
(95,7,'вела10/69','',12.15,1,10,95,'','0'),
(96,7,'вела8/05','',12.15,1,10,96,'','0'),
(97,7,'вела7/81','',12.15,1,10,97,'','0'),
(98,7,'сенс6/43','',2.61,1,10,98,'','0'),
(99,7,'сенс7/44','',2.61,1,10,99,'','0'),
(100,7,'сенс7/40','',2.61,1,10,100,'','0'),
(101,7,'сенс7/3','',2.61,1,10,101,'','0'),
(102,7,'сенс5/3','',2.61,1,10,102,'','0'),
(103,7,'сенс4/5','',2.61,1,10,103,'','0'),
(104,7,'сенс5/4','',2.61,1,10,104,'','0'),
(105,7,'сенс5/62','',2.61,1,10,105,'','0'),
(106,7,'сенс6/4','',2.61,1,10,106,'','0'),
(107,7,'сенс6/35','',2.61,1,10,107,'','0'),
(108,7,'сенс6/56','',2.61,1,10,108,'','0'),
(109,7,'сенс8/3','',2.61,1,10,109,'','0'),
(110,7,'сенс11/30','',2.61,1,10,110,'','0'),
(111,7,'сенс12/21','',2.61,1,10,111,'','0'),
(112,7,'сенс06тро','',2.61,1,10,112,'','0'),
(113,7,'сенскопері','',2.61,1,10,113,'','0'),
(114,7,'бако5/52','',3.78,1,10,114,'','0'),
(115,7,'бако00','',3.78,1,10,115,'','0'),
(116,7,'бако7/12','',3.78,1,10,116,'','0'),
(117,7,'бако7/10','',3.78,1,10,117,'','0'),
(118,7,'бако1/0','',3.78,1,10,118,'','0'),
(119,7,'бако3/0','',3.78,1,10,119,'','0'),
(120,7,'бако4/60','',3.78,1,10,120,'','0'),
(121,7,'бако4/85','',3.78,1,10,121,'','0'),
(122,7,'бакоа11','',3.78,1,10,122,'','0'),
(123,7,'бако6/10','',3.78,1,10,123,'','0'),
(124,7,'бако5/0','',3.78,1,10,124,'','0'),
(125,7,'бако4/0','',3.78,1,10,125,'','0'),
(126,7,'бако5/01','',3.78,1,10,126,'','0'),
(127,7,'бако5/30','',3.78,1,10,127,'','0'),
(128,7,'бако5/54','',3.78,1,10,128,'','0'),
(129,7,'бако6/01','',3.78,1,10,129,'','0'),
(130,7,'бако6/18','',3.78,1,10,130,'','0'),
(131,7,'бако7/01','',3.78,1,10,131,'','0'),
(132,7,'бако6/38','',3.78,1,10,132,'','0'),
(133,7,'бако7/0','',3.78,1,10,133,'','0'),
(134,7,'бако7/30','',3.78,1,10,134,'','0'),
(135,7,'бако7/35','',3.78,1,10,135,'','0'),
(136,7,'бако7/43','',3.78,1,10,136,'','0'),
(137,7,'бако8/01','',3.78,1,10,137,'','0'),
(138,7,'бако8/32','',3.78,1,10,138,'','0'),
(139,7,'бако7/10','',3.78,1,10,139,'','0'),
(140,7,'бако7/32','',3.78,1,10,140,'','0'),
(141,7,'бако8/44','',3.78,1,10,141,'','0'),
(142,7,'бако8/84','',3.78,1,10,142,'','0'),
(143,7,'бако9/02','',3.78,1,10,143,'','0'),
(144,7,'бако9/10','',3.78,1,10,144,'','0'),
(145,7,'бако9/30','',3.78,1,10,145,'','0'),
(146,7,'бако9/32','',3.78,1,10,146,'','0'),
(147,7,'бако10/0','',3.78,1,10,147,'','0'),
(148,7,'бако10/10','',3.78,1,10,148,'','0'),
(149,7,'бако7/44','',3.78,1,10,149,'','0'),
(150,7,'бакоhl11/10','',3.78,1,10,150,'','0'),
(151,7,'бако12|10','',3.78,1,10,151,'','0'),
(152,7,'бакоhl11/0','',3.78,1,10,152,'','0'),
(153,7,'бакоsl12/20','',3.78,1,10,153,'','0'),
(154,7,'бакоsl12/32','',3.78,1,10,154,'','0'),
(155,7,'бакоr1','',3.78,1,10,155,'','0'),
(156,7,'басос1','',3.78,1,10,156,'','0'),
(157,7,'бакоV1','',3.78,1,10,157,'','0'),
(158,7,'бакоRED','',3.78,1,10,158,'','0'),
(159,7,'суперкай5/1','',3.33,1,10,159,'','0'),
(160,7,'суперкай11/1','',3.33,1,10,160,'','0'),
(161,7,'суперкай11/11','',3.33,1,10,161,'','0'),
(162,7,'порошок','',2.73,1,0,162,'','0'),
(163,7,'лонда9/79','',6.54,1,10,163,'','0'),
(164,10,'001 БОТОКУР МІНІ 100мл','',250.00,3,0,2,'','0'),
(165,10,'МАКАДАМІЯ МІНІ100мл','',250.00,3,0,3,'','0'),
(166,10,'СУБТІЛ шампунь 300мл','',350.00,3,0,5,'','0'),
(167,10,'ЛАДОР ФІЛАП філер13мл','',90.00,3,0,6,'','0'),
(168,10,'ФІЛЕР ПУРЕФІ ампула 10мл','',80.00,3,0,7,'','0'),
(169,10,'КЕРАТІН ампула 10мл','',50.00,3,0,8,'','0'),
(170,10,'НУК ампула 7мл','',80.00,3,0,4,'','0'),
(171,10,'КАРАЛ РЕАЛЕ ампула 10мл','',65.00,3,0,9,'','0'),
(172,10,'СПЕЦІАЛ КАРЕ ампула10 мл','',70.00,3,0,10,'','0'),
(173,10,'ЛІС шампунь 350мл','',220.00,3,0,11,'','0'),
(174,10,'ДЖОК КАРЕ БАРЕКС маска 50мл','',1000.00,3,0,12,'','0'),
(175,10,'ЛІС маска 500мл','',240.00,3,0,13,'','0'),
(176,10,'КЛЕАН ФРЕШ 15мл','',60.00,3,0,14,'','0'),
(177,10,'ПОВЕР РІНГЕР маска 23мл','',65.00,3,0,15,'','0'),
(178,10,'ЛАДОР кондиціонер 530мл','',550.00,3,0,16,'','0'),
(179,10,'О.Р.І. 30мл','',200.00,3,0,17,'','0'),
(180,10,'GOLD PROTEKT 200мл','',200.00,3,0,18,'','0'),
(181,10,'PH шампунь 200мл','',365.00,3,0,19,'','0'),
(182,10,'сировотка свинка 50мл','',235.00,3,0,20,'','0'),
(183,10,'сировотка набір міша міні ','',270.00,3,1,21,'','0'),
(184,10,'BAKING POWDER скраб 200мл','',330.00,3,0,22,'','0'),
(185,10,'очишчуючий гельскраб ','',320.00,3,0,23,'','0'),
(186,10,'тонік для шкіри 150мл','',240.00,3,0,24,'','0'),
(187,10,'004NOOK ОЛІЙКА 30 МЛ','',220.00,3,0,25,'','0'),
(188,10,'actibarrier 5 мл','',80.00,3,0,26,'','0'),
(189,10,'ewg 5грам','',120.00,3,0,27,'','0'),
(190,10,'karal MARAES 200МЛ','',400.00,3,0,28,'','0'),
(191,10,'ANTIYELLOW кондиціонер 350мл','',365.00,3,0,29,'','0'),
(192,10,'CONCEPT STYLIST спрей200мл','',180.00,3,0,30,'','0'),
(193,10,'JOC BAREX КРЕМ 250МЛ','',300.00,3,0,31,'','0'),
(194,10,'помада еден 8 мл','',120.00,3,0,33,'','0'),
(195,10,'олівець еден ','',80.00,3,0,32,'','0'),
(196,10,'linege бальзам для губ 3мл','',135.00,3,0,34,'','0'),
(197,10,'3 шампунь 8мл','',25.00,3,0,35,'','0'),
(198,10,'антисептик ','',65.00,3,0,36,'','0'),
(199,10,'CONTEMPORA олійка 75мл','',375.00,3,0,37,'','0'),
(200,10,'005ARGAN OIL 100мл','',370.00,3,0,38,'','0'),
(201,10,'BOTU CURE  шампунь 350мл','',220.00,3,0,39,'','1'),
(202,10,'BOTUCURE маска 1000 мл ','',350.00,3,0,40,'','0'),
(203,10,'GLOSS креми для рук  30мл','',90.00,3,0,41,'','0'),
(204,10,'COLAGEN  тоналка №13','',240.00,3,0,42,'','0'),
(205,10,'COLAGEN  тоналка №21','',240.00,3,0,43,'','0'),
(206,10,'MISHA  тоналка №21','',220.00,3,0,44,'','0'),
(207,10,'MISHA  тоналка №23','',220.00,3,0,45,'','0'),
(208,10,'скраби трикутнички маленькі ','',18.00,3,0,46,'','0'),
(209,10,'ботокур маска 350 мл','',225.00,3,0,47,'','0'),
(210,10,'003крем кератиновий білий 100мл','',240.00,3,0,48,'','0'),
(211,7,'бако 12/21','',3.78,1,0,164,'','0'),
(212,7,'бако10/22','',3.78,1,0,166,'','0'),
(213,7,'бако9/12','',3.78,1,0,167,'','0'),
(214,10,'щітка для волосся olivia garden','',420.00,3,0,49,'','0'),
(215,10,'сухий шампунь batist200 мл','',220.00,1,0,50,'','0'),
(216,7,'кайколор3/0','',3.33,NULL,0,165,'','0'),
(217,7,'кайколор6/00','',3.33,1,0,168,'','0'),
(218,10,'newtone тонуюча фарба 10/6','',85.00,3,0,52,'','0'),
(219,10,'newtone тонуюча фарба 8/61','',85.00,3,0,51,'','0'),
(220,10,'набір  schwarzkopf ph4/5color','',700.00,3,0,53,'','0'),
(221,10,'набір  schwarzkopf peptide','',700.00,3,0,54,'','0'),
(222,10,'набір  schwarzkopf hyaluronic','',700.00,3,0,55,'','0'),
(223,10,'staleks шпателі до пилочки ','',4.00,3,0,56,'','0'),
(224,10,'Zola мило для брів 25г','',175.00,3,0,57,'','0'),
(225,10,'zola фіксатор спрей для макіяжу 30мл','',160.00,3,0,58,'','0'),
(226,10,'zola зволожуючий бальзам для губ 20г','',180.00,3,0,59,'','0'),
(227,10,'zola спонжик','',190.00,3,0,60,'','0'),
(228,10,'017мф тонік суха 150мл','',310.00,3,0,61,'','0'),
(229,10,'035мф пінка жирна та комбінована  160м.(для ','',320.00,3,1,62,'','0'),
(230,10,'038 тонік  жирна шкіра 160м (для ','',310.00,3,0,63,'','0'),
(231,10,'018крем.комбін.та жирна 30мл(комбін.та жирна)','',430.00,3,0,64,'','0'),
(232,10,'034мф пінка проблемна  problem skin( д','',330.00,3,0,65,'','0'),
(233,10,'019мф тонік.для.пробл.шкір.150мл','',320.00,3,0,66,'','0'),
(234,10,'020мф.крем.флюЇд.пробл.шкіра.30г','',460.00,3,0,67,'','0'),
(235,10,'037мф сировотка проблемна anti akne 30 мл(','',490.00,3,0,68,'','0'),
(236,10,'МАРІ ФРЕШ протизапальна маска green clay mask(для ','',650.00,3,0,69,'','0'),
(237,10,'МАРІ ФРЕШ точковий засіб проти висипань anti acne ','',290.00,3,0,70,'','0'),
(238,10,'017крем ден30мл (проти зморшок)','',460.00,3,0,71,'','0'),
(239,10,'021мф.крем.нічн.30м.(проти зморшок)','',490.00,3,0,72,'','0'),
(240,10,'022крем.нічний.30мл(противік.ліфтинг)','',490.00,3,0,73,'','0'),
(241,10,'023мф.крем.дений.30мл(противік.ліфтинг)','',490.00,3,0,74,'','0'),
(242,10,'024мф.сировотка зволоження та відновлення','',490.00,3,0,75,'','0'),
(243,10,'039 маска пілінг 50 мл (спеціальний догляд з','',650.00,3,0,76,'','0'),
(244,10,'040 мф ферментний пілінг для всіх типів шкіри (сп','',500.00,3,0,77,'','0'),
(245,10,'041мф ферментний пілінг для чутливоі шкіри (спец','',500.00,3,0,78,'','0'),
(246,10,'МАРІ ФРЕШ травел сет для жирної та комбінованої шк','',450.00,3,0,79,'','0'),
(247,10,'МАРІ ФРЕШ травел сет для проблемної шкіри ','',500.00,3,0,80,'','0'),
(248,10,'МАРІ ФРЕШ травел сет для сухої та нормальної шкіри','',450.00,3,0,81,'','0'),
(249,10,'036 пінка (для сухої та нормальної шкіри )','',320.00,3,0,82,'','0'),
(250,10,'скраб baking powred пірамідка','',20.00,3,0,83,'','0'),
(251,10,'кармекс бальзам для губ','',90.00,3,0,84,'','0'),
(252,10,'олівчик для губкаскаде №301','',90.00,3,0,85,'','0'),
(253,10,'олівчик для губ каскаде №308','',90.00,3,0,86,'','0'),
(254,10,'олівчик для губ каскаде №313','',90.00,3,0,87,'','0'),
(255,10,'олівчик для губ каскаде №320','',90.00,3,0,88,'','0'),
(256,10,'олівчик для губ каскаде №321','',90.00,3,0,89,'','0'),
(257,10,'олівчик для губ каскаде №300','',90.00,3,0,90,'','0'),
(258,10,'олівчик для губ каскаде№319','',90.00,3,0,91,'','0'),
(259,10,'хайлайтер сердечко','',230.00,3,0,92,'','0'),
(260,10,'бронзер паєс','',260.00,3,0,94,'','0'),
(261,10,'помада edan №02','',210.00,3,0,95,'','0'),
(262,10,'помада еден №05','',210.00,3,0,96,'','0'),
(263,10,'помада еден №06','',210.00,3,0,97,'','0'),
(264,10,'помада еден №07','',210.00,3,0,98,'','0'),
(265,10,'помада еден №08','',210.00,3,0,93,'','0'),
(266,10,'001шварскоф крем peptide repair 75мл','',435.00,3,0,1,'','0'),
(267,10,'002ботокур шампунь літровий 1000мл','',355.00,3,0,99,'','0'),
(268,10,'006спрей превіа 200 мл','',475.00,3,0,100,'','0'),
(269,10,'007кавяршампунь 350мл','',240.00,3,0,101,'','0'),
(270,10,'008кавяр кондиціонер 500м','',225.00,3,0,102,'','0'),
(271,10,'009шампунь макадамія 350мл','',240.00,3,0,103,'','0'),
(272,10,'010кондиціонер макадамія 350мл','',210.00,3,0,104,'','0'),
(273,10,'011помада еден №04','',210.00,3,0,105,'','0'),
(274,10,'012масло для кутикули вишня','',30.00,3,0,106,'','0'),
(275,10,'013масло для кутикули кавун','',30.00,3,0,107,'','0'),
(276,10,'014масло для кутикулиполуниця','',30.00,3,0,108,'','0'),
(277,10,'015масло для кутикули лайм','',30.00,3,0,109,'','0'),
(278,10,'016масло для кутикули яблуко','',30.00,3,0,110,'','0'),
(279,7,'кайколор12/11','',3.33,1,10,169,'','0'),
(280,7,'кайколор4/18','',3.33,1,10,170,'','0'),
(281,7,'кайколор4/37','',3.33,1,10,171,'','0'),
(282,7,'лонда12/16','',6.54,1,10,172,'','0'),
(283,7,'лонда10/16','',6.54,1,10,173,'','0'),
(284,7,'лонда9/73','',6.54,1,10,174,'','0'),
(285,7,'лонда9/96','',6.54,1,10,175,'','0'),
(286,7,'вела7/7','',12.15,1,10,176,'','0'),
(287,7,'вела10/60','',12.15,1,10,177,'','0'),
(288,7,'ct deep9/75 (вела)','',12.15,3,0,178,'','0'),
(289,7,'кр ме0/33(вела)','',12.15,1,0,179,'','0'),
(290,7,'кр ме0/43 (вела)','',12.15,1,0,180,'','0'),
(291,7,'кр ме6/75','',12.15,1,0,181,'','0'),
(292,7,'кр ме6/71(вела)','',12.15,1,0,182,'','0'),
(293,10,'025крем.суха та норм.шкіра 30мл(суха та норм)','',430.00,3,0,111,'','0'),
(294,10,'026крем суха та норм шк 5 мл (суха та норм)','',125.00,3,0,112,'','0'),
(295,10,'027крем комбі.жирна ш.5мл(комбі жирна шкір)','',125.00,3,0,113,'','0'),
(296,10,'028крем дений протизморшок 5 мл(проти зморш)','',125.00,3,0,114,'','0'),
(297,10,'029крем дений против.ліфтинг5мл(прот.ліфтинг)','',125.00,3,0,115,'','0'),
(298,10,'030крем ніч.проти зморш 5 мл (проти зморшок)','',125.00,3,0,116,'','0'),
(299,10,'031крем ніч 5 мл(противік ліфтинг)','',125.00,3,0,117,'','0'),
(300,10,'032крем пробл.шкіра 5 мл(проблемна шкіра )','',125.00,3,0,118,'','0'),
(301,10,'033сировотка звол.відн.5 мл (зволоження відновленя','',125.00,3,0,119,'','0'),
(302,7,'екре90/02','',3.78,1,0,183,'','0'),
(303,7,'екре10/76','',3.78,1,0,184,'','0'),
(304,7,'екре902','',3.78,1,0,185,'','0'),
(305,7,'екре7/72','',3.78,1,0,186,'','0'),
(306,7,'екре6/7','',3.78,1,0,187,'','0'),
(307,7,'екре5/77','',3.78,1,0,188,'','0'),
(308,10,'тонуюча фарба естель 8/76','',85.00,3,0,120,'','0'),
(309,10,'тонуюча фарба9/65','',85.00,3,0,121,'','0'),
(310,10,'тонуюча фарба 7/75','',85.00,3,0,122,'','0'),
(311,10,'тонуюча фарба 7/44','',85.00,3,0,123,'','0'),
(312,10,'тонуюча маска естель10/76','',85.00,3,0,124,'','0'),
(313,7,'бако9/0','',3.78,1,0,189,'','0'),
(314,7,'бако10/0','',3.78,1,0,190,'','0'),
(315,7,'кайколор9/1','',3.33,1,0,191,'','0'),
(316,10,'ельсев крем бальзам 180мл','',160.00,3,0,125,'','0'),
(317,7,'бако8/10','',3.78,1,0,192,'','0'),
(318,10,'мінеральна ампула 10мл','',50.00,3,0,126,'','0'),
(319,NULL,'тонуюча фарба естель7/56','',85.00,1,0,319,'','0'),
(320,10,'ботокур шампунь 350мл','',220.00,3,0,127,'','0'),
(321,10,'нук шампунь 250мл','',300.00,3,0,128,'','0'),
(322,10,'нук маска 250мл','',330.00,3,0,129,'','0'),
(323,7,'кайколор10/0','',3.33,1,0,193,'','0'),
(324,10,'крем для рук гарніер100мл','',100.00,3,0,130,'','0'),
(325,7,'екре8/1','',3.78,1,0,194,'','0'),
(326,7,'екре9/1','',3.78,1,0,195,'','0'),
(327,7,'екре088','',3.78,1,0,196,'','0'),
(328,7,'екре8/37','',3.78,1,0,197,'','0'),
(329,7,'екре12/01','',3.78,1,0,198,'','0'),
(330,7,'екре10/31','',3.78,1,0,199,'','0');

DROP TABLE IF EXISTS `materials_documents`;

CREATE TABLE `materials_documents` (
  `id` mediumint(5) unsigned NOT NULL AUTO_INCREMENT,
  `DateTime` datetime NOT NULL,
  `type` enum('pruhid','spusannia') NOT NULL DEFAULT 'pruhid' COMMENT 'Тип документу: Прихід або списання',
  `sort` mediumint(5) unsigned NOT NULL DEFAULT 0,
  `comment` varchar(255) NOT NULL,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `materials_documents` VALUES 
(1,'2021-11-09 17:28:21','pruhid',1,'','0'),
(2,'2021-11-15 16:02:23','pruhid',2,'','0'),
(3,'2021-11-19 10:41:22','pruhid',3,'','0'),
(4,'2021-11-19 11:00:59','pruhid',4,'','0'),
(5,'2021-11-19 13:19:57','pruhid',5,'','0'),
(6,'2021-11-22 10:18:24','pruhid',6,'','0'),
(7,'2021-11-22 15:47:34','pruhid',7,'','0'),
(8,'2021-11-26 11:40:52','pruhid',8,'','0'),
(9,'2021-11-27 11:08:22','pruhid',9,'','0'),
(10,'2021-11-27 12:57:35','pruhid',10,'','0'),
(11,'2021-11-30 11:09:46','pruhid',11,'','0'),
(12,'2021-12-03 10:00:19','spusannia',12,'','0'),
(13,'2021-12-03 10:13:56','pruhid',13,'','0'),
(14,'2021-12-03 11:47:00','pruhid',14,'','0'),
(15,'2021-12-06 14:58:24','pruhid',15,'','0'),
(16,'2021-12-08 12:51:24','pruhid',16,'','0'),
(17,'2021-12-08 14:54:14','pruhid',17,'','0'),
(18,'2021-12-11 14:40:22','pruhid',18,'','0'),
(19,'2021-12-13 11:43:11','pruhid',19,'','0'),
(20,'2021-12-16 17:31:33','pruhid',20,'','0'),
(21,'2021-12-17 12:49:27','pruhid',21,'','0'),
(22,'2021-12-22 17:07:56','pruhid',22,'','0'),
(23,'2021-12-22 17:09:52','pruhid',23,'','0'),
(24,'2021-12-24 12:47:48','pruhid',24,'','0'),
(25,'2021-12-27 09:22:20','pruhid',25,'','0');

DROP TABLE IF EXISTS `materials_registr`;

CREATE TABLE `materials_registr` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `DateTime` datetime NOT NULL,
  `materials_id` smallint(5) unsigned NOT NULL,
  `quantity` smallint(6) NOT NULL COMMENT 'З мінусом або плюсом ',
  `schedule_id` mediumint(8) unsigned DEFAULT NULL COMMENT 'Якщо це завдання з розкладу, то його ID',
  `materials_documents_id` mediumint(8) unsigned DEFAULT NULL COMMENT 'Посилання на документ прихід або списання',
  `comment` varchar(255) NOT NULL,
  `delete` enum('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `materials_id` (`materials_id`,`schedule_id`),
  UNIQUE KEY `materials_id_2` (`materials_id`,`materials_documents_id`),
  KEY `delete` (`delete`,`materials_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2199 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci COMMENT='Регістр накопичення обліку матеріалів';

INSERT INTO `materials_registr` VALUES 
(527,'2021-11-09 11:00:00',58,-11,86851,NULL,'','0'),
(528,'2021-11-09 11:00:00',61,-15,86851,NULL,'','0'),
(529,'2021-11-09 11:00:00',66,-6,86851,NULL,'','0'),
(530,'2021-11-09 11:00:00',81,-9,86851,NULL,'','0'),
(531,'2021-11-09 11:00:00',143,-5,86851,NULL,'','0'),
(532,'2021-11-09 11:00:00',162,-113,86851,NULL,'','0'),
(533,'2021-11-09 14:00:00',59,-10,86853,NULL,'','0'),
(534,'2021-11-09 14:00:00',70,-12,86853,NULL,'','0'),
(535,'2021-11-09 14:00:00',74,-10,86853,NULL,'','0'),
(536,'2021-11-09 14:00:00',162,-95,86853,NULL,'','0'),
(700,'2021-11-10 10:00:00',24,-32,87020,NULL,'','0'),
(701,'2021-11-10 10:00:00',25,-67,87020,NULL,'','0'),
(702,'2021-11-10 09:00:00',2,-16,87334,NULL,'','0'),
(703,'2021-11-10 09:00:00',143,-15,87334,NULL,'','0'),
(704,'2021-11-10 09:00:00',152,-16,87334,NULL,'','0'),
(705,'2021-11-10 09:00:00',154,-15,87334,NULL,'','0'),
(914,'2021-11-10 12:00:00',58,-18,86890,NULL,'','0'),
(915,'2021-11-10 12:00:00',61,-26,86890,NULL,'','0'),
(916,'2021-11-10 12:00:00',72,-13,86890,NULL,'','0'),
(917,'2021-11-10 12:00:00',115,-12,86890,NULL,'','0'),
(918,'2021-11-10 12:00:00',162,-70,86890,NULL,'','0'),
(919,'2021-11-09 17:28:21',1,17,NULL,1,'','0'),
(920,'2021-11-09 17:28:21',2,74,NULL,1,'','0'),
(921,'2021-11-09 17:28:21',3,34,NULL,1,'','0'),
(922,'2021-11-09 17:28:21',4,96,NULL,1,'','0'),
(923,'2021-11-09 17:28:21',5,20,NULL,1,'','0'),
(924,'2021-11-09 17:28:21',6,412,NULL,1,'','0'),
(925,'2021-11-09 17:28:21',7,28,NULL,1,'','0'),
(926,'2021-11-09 17:28:21',8,67,NULL,1,'','0'),
(927,'2021-11-09 17:28:21',9,18,NULL,1,'','0'),
(928,'2021-11-09 17:28:21',10,171,NULL,1,'','0'),
(929,'2021-11-09 17:28:21',11,76,NULL,1,'','0'),
(930,'2021-11-09 17:28:21',12,73,NULL,1,'','0'),
(931,'2021-11-09 17:28:21',13,98,NULL,1,'','0'),
(932,'2021-11-09 17:28:21',14,34,NULL,1,'','0'),
(933,'2021-11-09 17:28:21',15,336,NULL,1,'','0'),
(934,'2021-11-09 17:28:21',16,61,NULL,1,'','0'),
(935,'2021-11-09 17:28:21',17,53,NULL,1,'','0'),
(936,'2021-11-09 17:28:21',18,26,NULL,1,'','0'),
(937,'2021-11-09 17:28:21',19,95,NULL,1,'','0'),
(938,'2021-11-09 17:28:21',20,176,NULL,1,'','0'),
(939,'2021-11-09 17:28:21',21,94,NULL,1,'','0'),
(940,'2021-11-09 17:28:21',22,60,NULL,1,'','0'),
(941,'2021-11-09 17:28:21',23,94,NULL,1,'','0'),
(942,'2021-11-09 17:28:21',24,206,NULL,1,'','0'),
(943,'2021-11-09 17:28:21',25,255,NULL,1,'','0'),
(944,'2021-11-09 17:28:21',26,267,NULL,1,'','0'),
(945,'2021-11-09 17:28:21',27,24,NULL,1,'','0'),
(946,'2021-11-09 17:28:21',28,44,NULL,1,'','0'),
(947,'2021-11-09 17:28:21',29,54,NULL,1,'','0'),
(948,'2021-11-09 17:28:21',30,5,NULL,1,'','0'),
(949,'2021-11-09 17:28:21',31,25,NULL,1,'','0'),
(950,'2021-11-09 17:28:21',32,44,NULL,1,'','0'),
(951,'2021-11-09 17:28:21',33,93,NULL,1,'','0'),
(952,'2021-11-09 17:28:21',34,30,NULL,1,'','0'),
(953,'2021-11-09 17:28:21',35,95,NULL,1,'','0'),
(954,'2021-11-09 17:28:21',36,95,NULL,1,'','0'),
(955,'2021-11-09 17:28:21',37,102,NULL,1,'','0'),
(956,'2021-11-09 17:28:21',38,77,NULL,1,'','0'),
(957,'2021-11-09 17:28:21',39,31,NULL,1,'','0'),
(958,'2021-11-09 17:28:21',40,94,NULL,1,'','0'),
(959,'2021-11-09 17:28:21',41,31,NULL,1,'','0'),
(960,'2021-11-09 17:28:21',42,82,NULL,1,'','0'),
(961,'2021-11-09 17:28:21',43,81,NULL,1,'','0'),
(962,'2021-11-09 17:28:21',44,71,NULL,1,'','0'),
(963,'2021-11-09 17:28:21',45,119,NULL,1,'','0'),
(964,'2021-11-09 17:28:21',46,118,NULL,1,'','0'),
(965,'2021-11-09 17:28:21',47,112,NULL,1,'','0'),
(966,'2021-11-09 17:28:21',48,119,NULL,1,'','0'),
(967,'2021-11-09 17:28:21',49,34,NULL,1,'','0'),
(968,'2021-11-09 17:28:21',50,22,NULL,1,'','0'),
(969,'2021-11-09 17:28:21',51,81,NULL,1,'','0'),
(970,'2021-11-09 17:28:21',52,44,NULL,1,'','0'),
(971,'2021-11-09 17:28:21',53,42,NULL,1,'','0'),
(972,'2021-11-09 17:28:21',54,26,NULL,1,'','0'),
(973,'2021-11-09 17:28:21',55,58,NULL,1,'','0'),
(974,'2021-11-09 17:28:21',56,19,NULL,1,'','0'),
(975,'2021-11-09 17:28:21',57,39,NULL,1,'','0'),
(976,'2021-11-09 17:28:21',58,30,NULL,1,'','0'),
(977,'2021-11-09 17:28:21',59,10,NULL,1,'','0'),
(978,'2021-11-09 17:28:21',60,117,NULL,1,'','0'),
(979,'2021-11-09 17:28:21',61,43,NULL,1,'','0'),
(980,'2021-11-09 17:28:21',62,95,NULL,1,'','0'),
(981,'2021-11-09 17:28:21',63,37,NULL,1,'','0'),
(982,'2021-11-09 17:28:21',64,49,NULL,1,'','0'),
(983,'2021-11-09 17:28:21',65,34,NULL,1,'','0'),
(984,'2021-11-09 17:28:21',66,58,NULL,1,'','0'),
(985,'2021-11-09 17:28:21',67,5,NULL,1,'','0'),
(986,'2021-11-09 17:28:21',68,58,NULL,1,'','0'),
(987,'2021-11-09 17:28:21',69,57,NULL,1,'','0'),
(988,'2021-11-09 17:28:21',70,24,NULL,1,'','0'),
(989,'2021-11-09 17:28:21',71,47,NULL,1,'','0'),
(990,'2021-11-09 17:28:21',72,33,NULL,1,'','0'),
(991,'2021-11-09 17:28:21',73,11,NULL,1,'','0'),
(992,'2021-11-09 17:28:21',74,45,NULL,1,'','0'),
(993,'2021-11-09 17:28:21',75,27,NULL,1,'','0'),
(994,'2021-11-09 17:28:21',76,26,NULL,1,'','0'),
(995,'2021-11-09 17:28:21',77,35,NULL,1,'','0'),
(996,'2021-11-09 17:28:21',78,61,NULL,1,'','0'),
(997,'2021-11-09 17:28:21',79,111,NULL,1,'','0'),
(998,'2021-11-09 17:28:21',80,47,NULL,1,'','0'),
(999,'2021-11-09 17:28:21',81,9,NULL,1,'','0'),
(1000,'2021-11-09 17:28:21',82,52,NULL,1,'','0'),
(1001,'2021-11-09 17:28:21',83,119,NULL,1,'','0'),
(1002,'2021-11-09 17:28:21',84,17,NULL,1,'','0'),
(1003,'2021-11-09 17:28:21',85,5,NULL,1,'','0'),
(1004,'2021-11-09 17:28:21',86,74,NULL,1,'','0'),
(1005,'2021-11-09 17:28:21',87,59,NULL,1,'','0'),
(1006,'2021-11-09 17:28:21',88,59,NULL,1,'','0'),
(1007,'2021-11-09 17:28:21',89,68,NULL,1,'','0'),
(1008,'2021-11-09 17:28:21',90,46,NULL,1,'','0'),
(1009,'2021-11-09 17:28:21',91,59,NULL,1,'','0'),
(1010,'2021-11-09 17:28:21',92,97,NULL,1,'','0'),
(1011,'2021-11-09 17:28:21',93,115,NULL,1,'','0'),
(1012,'2021-11-09 17:28:21',94,46,NULL,1,'','0'),
(1013,'2021-11-09 17:28:21',95,25,NULL,1,'','0'),
(1014,'2021-11-09 17:28:21',96,41,NULL,1,'','0'),
(1015,'2021-11-09 17:28:21',97,70,NULL,1,'','0'),
(1016,'2021-11-09 17:28:21',98,21,NULL,1,'','0'),
(1017,'2021-11-09 17:28:21',99,118,NULL,1,'','0'),
(1018,'2021-11-09 17:28:21',100,116,NULL,1,'','0'),
(1019,'2021-11-09 17:28:21',101,78,NULL,1,'','0'),
(1020,'2021-11-09 17:28:21',102,22,NULL,1,'','0'),
(1021,'2021-11-09 17:28:21',103,183,NULL,1,'','0'),
(1022,'2021-11-09 17:28:21',104,87,NULL,1,'','0'),
(1023,'2021-11-09 17:28:21',105,36,NULL,1,'','0'),
(1024,'2021-11-09 17:28:21',106,85,NULL,1,'','0'),
(1025,'2021-11-09 17:28:21',107,66,NULL,1,'','0'),
(1026,'2021-11-09 17:28:21',108,57,NULL,1,'','0'),
(1027,'2021-11-09 17:28:21',109,95,NULL,1,'','0'),
(1028,'2021-11-09 17:28:21',110,453,NULL,1,'','0'),
(1029,'2021-11-09 17:28:21',111,26,NULL,1,'','0'),
(1030,'2021-11-09 17:28:21',112,50,NULL,1,'','0'),
(1031,'2021-11-09 17:28:21',113,96,NULL,1,'','0'),
(1032,'2021-11-09 17:28:21',114,6,NULL,1,'','0'),
(1033,'2021-11-09 17:28:21',115,109,NULL,1,'','0'),
(1034,'2021-11-09 17:28:21',116,77,NULL,1,'','0'),
(1035,'2021-11-09 17:28:21',117,65,NULL,1,'','0'),
(1036,'2021-11-09 17:28:21',118,121,NULL,1,'','0'),
(1037,'2021-11-09 17:28:21',119,72,NULL,1,'','0'),
(1038,'2021-11-09 17:28:21',120,31,NULL,1,'','0'),
(1039,'2021-11-09 17:28:21',121,73,NULL,1,'','0'),
(1040,'2021-11-09 17:28:21',122,67,NULL,1,'','0'),
(1041,'2021-11-09 17:28:21',123,14,NULL,1,'','0'),
(1042,'2021-11-09 17:28:21',124,67,NULL,1,'','0'),
(1043,'2021-11-09 17:28:21',125,93,NULL,1,'','0'),
(1044,'2021-11-09 17:28:21',126,94,NULL,1,'','0'),
(1045,'2021-11-09 17:28:21',127,175,NULL,1,'','0'),
(1046,'2021-11-09 17:28:21',128,66,NULL,1,'','0'),
(1047,'2021-11-09 17:28:21',129,31,NULL,1,'','0'),
(1048,'2021-11-09 17:28:21',130,88,NULL,1,'','0'),
(1049,'2021-11-09 17:28:21',131,63,NULL,1,'','0'),
(1050,'2021-11-09 17:28:21',132,78,NULL,1,'','0'),
(1051,'2021-11-09 17:28:21',133,67,NULL,1,'','0'),
(1052,'2021-11-09 17:28:21',134,64,NULL,1,'','0'),
(1053,'2021-11-09 17:28:21',135,28,NULL,1,'','0'),
(1054,'2021-11-09 17:28:21',136,95,NULL,1,'','0'),
(1055,'2021-11-09 17:28:21',137,142,NULL,1,'','0'),
(1056,'2021-11-09 17:28:21',138,201,NULL,1,'','0'),
(1057,'2021-11-09 17:28:21',139,83,NULL,1,'','0'),
(1058,'2021-11-09 17:28:21',140,18,NULL,1,'','0'),
(1059,'2021-11-09 17:28:21',141,51,NULL,1,'','0'),
(1060,'2021-11-09 17:28:21',142,65,NULL,1,'','0'),
(1061,'2021-11-09 17:28:21',143,49,NULL,1,'','0'),
(1062,'2021-11-09 17:28:21',144,105,NULL,1,'','0'),
(1063,'2021-11-09 17:28:21',145,93,NULL,1,'','0'),
(1064,'2021-11-09 17:28:21',146,199,NULL,1,'','0'),
(1065,'2021-11-09 17:28:21',147,75,NULL,1,'','0'),
(1066,'2021-11-09 17:28:21',148,95,NULL,1,'','0'),
(1067,'2021-11-09 17:28:21',149,14,NULL,1,'','0'),
(1068,'2021-11-09 17:28:21',150,94,NULL,1,'','0'),
(1069,'2021-11-09 17:28:21',151,82,NULL,1,'','0'),
(1070,'2021-11-09 17:28:21',152,26,NULL,1,'','0'),
(1071,'2021-11-09 17:28:21',153,169,NULL,1,'','0'),
(1072,'2021-11-09 17:28:21',154,179,NULL,1,'','0'),
(1073,'2021-11-09 17:28:21',155,35,NULL,1,'','0'),
(1074,'2021-11-09 17:28:21',156,72,NULL,1,'','0'),
(1075,'2021-11-09 17:28:21',157,169,NULL,1,'','0'),
(1076,'2021-11-09 17:28:21',158,31,NULL,1,'','0'),
(1077,'2021-11-09 17:28:21',159,156,NULL,1,'','0'),
(1078,'2021-11-09 17:28:21',160,60,NULL,1,'','0'),
(1079,'2021-11-09 17:28:21',161,126,NULL,1,'','0'),
(1080,'2021-11-09 17:28:21',162,1618,NULL,1,'','0'),
(1081,'2021-11-09 17:28:21',163,57,NULL,1,'','0'),
(1082,'2021-11-09 17:28:21',164,1,NULL,1,'','0'),
(1083,'2021-11-09 17:28:21',165,1,NULL,1,'','0'),
(1084,'2021-11-09 17:28:21',166,8,NULL,1,'','0'),
(1085,'2021-11-09 17:28:21',167,7,NULL,1,'','0'),
(1086,'2021-11-09 17:28:21',168,4,NULL,1,'','0'),
(1087,'2021-11-09 17:28:21',169,1,NULL,1,'','0'),
(1088,'2021-11-09 17:28:21',170,3,NULL,1,'','0'),
(1089,'2021-11-09 17:28:21',171,2,NULL,1,'','0'),
(1090,'2021-11-09 17:28:21',172,6,NULL,1,'','0'),
(1091,'2021-11-09 17:28:21',173,3,NULL,1,'','0'),
(1092,'2021-11-09 17:28:21',174,1,NULL,1,'','0'),
(1093,'2021-11-09 17:28:21',175,1,NULL,1,'','0'),
(1094,'2021-11-09 17:28:21',176,1,NULL,1,'','0'),
(1095,'2021-11-09 17:28:21',177,1,NULL,1,'','0'),
(1096,'2021-11-09 17:28:21',178,3,NULL,1,'','0'),
(1097,'2021-11-09 17:28:21',179,1,NULL,1,'','0'),
(1098,'2021-11-09 17:28:21',180,1,NULL,1,'','0'),
(1099,'2021-11-09 17:28:21',181,1,NULL,1,'','0'),
(1100,'2021-11-09 17:28:21',182,1,NULL,1,'','0'),
(1101,'2021-11-09 17:28:21',183,2,NULL,1,'','0'),
(1102,'2021-11-09 17:28:21',184,1,NULL,1,'','0'),
(1103,'2021-11-09 17:28:21',185,1,NULL,1,'','0'),
(1104,'2021-11-09 17:28:21',186,1,NULL,1,'','0'),
(1105,'2021-11-09 17:28:21',187,1,NULL,1,'','0'),
(1106,'2021-11-09 17:28:21',188,2,NULL,1,'','0'),
(1107,'2021-11-09 17:28:21',189,3,NULL,1,'','0'),
(1108,'2021-11-09 17:28:21',190,1,NULL,1,'','0'),
(1109,'2021-11-09 17:28:21',191,1,NULL,1,'','0'),
(1110,'2021-11-09 17:28:21',192,1,NULL,1,'','0'),
(1111,'2021-11-09 17:28:21',193,1,NULL,1,'','0'),
(1112,'2021-11-09 17:28:21',194,2,NULL,1,'','0'),
(1113,'2021-11-09 17:28:21',195,2,NULL,1,'','0'),
(1114,'2021-11-09 17:28:21',196,6,NULL,1,'','0'),
(1115,'2021-11-09 17:28:21',197,3,NULL,1,'','0'),
(1116,'2021-11-09 17:28:21',198,2,NULL,1,'','0'),
(1117,'2021-11-09 17:28:21',199,1,NULL,1,'','0'),
(1118,'2021-11-09 17:28:21',200,1,NULL,1,'','0'),
(1119,'2021-11-09 17:28:21',201,1,NULL,1,'','0'),
(1120,'2021-11-09 17:28:21',202,1,NULL,1,'','0'),
(1121,'2021-11-09 17:28:21',203,5,NULL,1,'','0'),
(1122,'2021-11-09 17:28:21',204,17,NULL,1,'','0'),
(1123,'2021-11-09 17:28:21',205,7,NULL,1,'','0'),
(1124,'2021-11-09 17:28:21',206,4,NULL,1,'','0'),
(1125,'2021-11-09 17:28:21',207,5,NULL,1,'','0'),
(1126,'2021-11-09 17:28:21',208,37,NULL,1,'','0'),
(1127,'2021-11-11 09:00:00',28,-23,86812,NULL,'','0'),
(1128,'2021-11-11 09:00:00',57,-10,86812,NULL,'','0'),
(1129,'2021-11-11 09:00:00',66,-10,86812,NULL,'','0'),
(1130,'2021-11-11 09:00:00',117,-16,86812,NULL,'','0'),
(1131,'2021-11-11 09:00:00',122,-8,86812,NULL,'','0'),
(1132,'2021-11-11 09:00:00',144,-20,86812,NULL,'','0'),
(1133,'2021-11-11 09:00:00',162,-161,86812,NULL,'','0'),
(1134,'2021-11-11 13:00:00',60,-14,87128,NULL,'','0'),
(1135,'2021-11-11 13:00:00',66,-14,87128,NULL,'','0'),
(1136,'2021-11-11 13:00:00',72,-11,87128,NULL,'','0'),
(1137,'2021-11-11 13:00:00',162,-103,87128,NULL,'','0'),
(1138,'2021-11-11 18:00:00',64,-5,87382,NULL,'','0'),
(1139,'2021-11-11 18:00:00',69,-3,87382,NULL,'','0'),
(1140,'2021-11-11 18:00:00',72,-9,87382,NULL,'','0'),
(1141,'2021-11-12 10:00:00',162,-56,87170,NULL,'','0'),
(1142,'2021-11-12 12:00:00',45,-15,87417,NULL,'','0'),
(1143,'2021-11-12 12:00:00',68,-16,87417,NULL,'','0'),
(1144,'2021-11-12 12:00:00',77,-16,87417,NULL,'','0'),
(1145,'2021-11-12 12:00:00',138,-30,87417,NULL,'','0'),
(1146,'2021-11-12 12:00:00',162,-70,87417,NULL,'','0'),
(1147,'2021-11-13 09:00:00',168,-1,87668,NULL,'','0'),
(1148,'2021-11-15 09:00:00',25,-21,87309,NULL,'','0'),
(1149,'2021-11-15 09:00:00',48,-35,87309,NULL,'','0'),
(1150,'2021-11-15 09:00:00',63,-15,87309,NULL,'','0'),
(1151,'2021-11-15 09:00:00',106,-16,87309,NULL,'','0'),
(1152,'2021-11-15 09:00:00',162,-130,87309,NULL,'','0'),
(1153,'2021-11-15 13:30:00',25,-71,87623,NULL,'','0'),
(1154,'2021-11-15 16:02:23',162,1000,NULL,2,'','0'),
(1155,'2021-11-15 16:02:23',209,1,NULL,2,'','0'),
(1156,'2021-11-15 16:02:23',210,1,NULL,2,'','0'),
(1157,'2021-11-15 09:00:00',201,-1,87768,NULL,'','0'),
(1158,'2021-11-15 09:00:00',209,-1,87768,NULL,'','0'),
(1159,'2021-11-16 12:00:00',5,-10,87601,NULL,'','0'),
(1160,'2021-11-16 12:00:00',27,-12,87601,NULL,'','0'),
(1161,'2021-11-16 12:00:00',122,-15,87601,NULL,'','0'),
(1162,'2021-11-16 11:00:00',53,-10,87663,NULL,'','0'),
(1163,'2021-11-16 11:00:00',86,-10,87663,NULL,'','0'),
(1164,'2021-11-16 11:00:00',92,-6,87663,NULL,'','0'),
(1165,'2021-11-16 11:00:00',95,-8,87663,NULL,'','0'),
(1166,'2021-11-16 11:00:00',97,-19,87663,NULL,'','0'),
(1167,'2021-11-16 11:00:00',162,-120,87663,NULL,'','0'),
(1168,'2021-11-16 11:00:00',163,-5,87663,NULL,'','0'),
(1169,'2021-11-16 16:00:00',2,-40,85940,NULL,'','0'),
(1170,'2021-11-16 16:00:00',154,-33,85940,NULL,'','0'),
(1171,'2021-11-16 16:00:00',162,-68,85940,NULL,'','0'),
(1172,'2021-11-17 09:00:00',53,-14,87453,NULL,'','0'),
(1173,'2021-11-17 09:00:00',57,-13,87453,NULL,'','0'),
(1174,'2021-11-17 09:00:00',69,-11,87453,NULL,'','0'),
(1175,'2021-11-17 09:00:00',162,-95,87453,NULL,'','0'),
(1176,'2021-11-18 12:00:00',65,-8,87702,NULL,'','0'),
(1177,'2021-11-18 12:00:00',80,-1,87702,NULL,'','0'),
(1178,'2021-11-18 12:00:00',89,-10,87702,NULL,'','0'),
(1179,'2021-11-18 12:00:00',96,-9,87702,NULL,'','0'),
(1180,'2021-11-18 12:00:00',162,-85,87702,NULL,'','0'),
(1181,'2021-11-18 12:00:00',163,-9,87702,NULL,'','0'),
(1182,'2021-11-19 10:41:22',212,85,NULL,3,'','0'),
(1183,'2021-11-19 11:00:59',2,93,NULL,4,'','0'),
(1184,'2021-11-19 11:00:59',6,93,NULL,4,'','0'),
(1185,'2021-11-19 11:00:59',20,93,NULL,4,'','0'),
(1186,'2021-11-19 11:00:59',214,3,NULL,4,'','0'),
(1187,'2021-11-19 11:00:59',215,3,NULL,4,'','0'),
(1188,'2021-11-19 11:00:59',216,93,NULL,4,'','0'),
(1189,'2021-11-19 11:00:59',217,93,NULL,4,'','0'),
(1190,'2021-11-18 09:00:00',57,-16,87455,NULL,'','0'),
(1191,'2021-11-18 09:00:00',60,-11,87455,NULL,'','0'),
(1192,'2021-11-18 09:00:00',89,-8,87455,NULL,'','0'),
(1193,'2021-11-18 09:00:00',162,-104,87455,NULL,'','0'),
(1194,'2021-11-19 13:19:57',218,3,NULL,5,'','0'),
(1195,'2021-11-19 13:19:57',219,3,NULL,5,'','0'),
(1196,'2021-11-19 13:19:57',220,1,NULL,5,'','0'),
(1197,'2021-11-19 13:19:57',221,1,NULL,5,'','0'),
(1198,'2021-11-19 13:19:57',222,1,NULL,5,'','0'),
(1199,'2021-11-19 13:19:57',223,100,NULL,5,'','0'),
(1200,'2021-11-19 13:19:57',224,5,NULL,5,'','0'),
(1201,'2021-11-19 13:19:57',225,10,NULL,5,'','0'),
(1202,'2021-11-19 13:19:57',226,10,NULL,5,'','0'),
(1203,'2021-11-19 13:19:57',227,30,NULL,5,'','0'),
(1204,'2021-11-19 13:19:57',228,1,NULL,5,'','0'),
(1205,'2021-11-19 13:19:57',229,1,NULL,5,'','0'),
(1206,'2021-11-19 13:19:57',230,1,NULL,5,'','0'),
(1207,'2021-11-19 13:19:57',231,1,NULL,5,'','0'),
(1208,'2021-11-19 13:19:57',232,3,NULL,5,'','0'),
(1209,'2021-11-19 13:19:57',233,4,NULL,5,'','0'),
(1210,'2021-11-19 13:19:57',234,3,NULL,5,'','0'),
(1211,'2021-11-19 13:19:57',235,3,NULL,5,'','0'),
(1212,'2021-11-19 13:19:57',236,2,NULL,5,'','0'),
(1213,'2021-11-19 13:19:57',237,1,NULL,5,'','0'),
(1214,'2021-11-19 13:19:57',238,1,NULL,5,'','0'),
(1215,'2021-11-19 13:19:57',239,1,NULL,5,'','0'),
(1216,'2021-11-19 13:19:57',240,1,NULL,5,'','0'),
(1217,'2021-11-19 13:19:57',241,1,NULL,5,'','0'),
(1218,'2021-11-19 13:19:57',242,1,NULL,5,'','0'),
(1219,'2021-11-19 13:19:57',243,1,NULL,5,'','0'),
(1220,'2021-11-19 13:19:57',244,1,NULL,5,'','0'),
(1221,'2021-11-19 13:19:57',245,1,NULL,5,'','0'),
(1222,'2021-11-19 13:19:57',246,3,NULL,5,'','0'),
(1223,'2021-11-19 13:19:57',247,4,NULL,5,'','0'),
(1224,'2021-11-19 13:19:57',248,2,NULL,5,'','0'),
(1225,'2021-11-19 13:19:57',249,1,NULL,5,'','0'),
(1226,'2021-11-18 16:00:00',24,-44,87738,NULL,'','0'),
(1227,'2021-11-18 16:00:00',25,-40,87738,NULL,'','0'),
(1228,'2021-11-19 09:00:00',53,-10,87025,NULL,'','0'),
(1229,'2021-11-19 09:00:00',60,-17,87025,NULL,'','0'),
(1230,'2021-11-19 09:00:00',64,-9,87025,NULL,'','0'),
(1231,'2021-11-19 09:00:00',69,-10,87025,NULL,'','0'),
(1232,'2021-11-19 09:00:00',162,-133,87025,NULL,'','0'),
(1233,'2021-11-19 12:30:00',164,-1,88018,NULL,'','0'),
(1234,'2021-11-19 09:30:00',2,-19,87810,NULL,'','0'),
(1235,'2021-11-19 09:30:00',25,-20,87810,NULL,'','0'),
(1236,'2021-11-19 09:30:00',53,-10,87810,NULL,'','0'),
(1237,'2021-11-19 09:30:00',74,-10,87810,NULL,'','0'),
(1238,'2021-11-19 09:30:00',75,-9,87810,NULL,'','0'),
(1239,'2021-11-19 09:30:00',96,-13,87810,NULL,'','0'),
(1240,'2021-11-19 09:30:00',97,-11,87810,NULL,'','0'),
(1241,'2021-11-19 09:30:00',162,-130,87810,NULL,'','0'),
(1242,'2021-11-20 09:00:00',2,-15,87845,NULL,'','0'),
(1243,'2021-11-20 09:00:00',65,-11,87845,NULL,'','0'),
(1244,'2021-11-20 09:00:00',80,-1,87845,NULL,'','0'),
(1245,'2021-11-20 09:00:00',95,-8,87845,NULL,'','0'),
(1246,'2021-11-20 09:00:00',111,-10,87845,NULL,'','0'),
(1247,'2021-11-20 09:00:00',147,-15,87845,NULL,'','0'),
(1248,'2021-11-20 09:00:00',162,-70,87845,NULL,'','0'),
(1249,'2021-11-20 09:00:00',222,-1,88117,NULL,'','0'),
(1250,'2021-11-22 10:18:24',250,10,NULL,6,'','0'),
(1251,'2021-11-22 10:18:24',251,5,NULL,6,'','0'),
(1252,'2021-11-22 10:18:24',252,1,NULL,6,'','0'),
(1253,'2021-11-22 10:18:24',253,1,NULL,6,'','0'),
(1254,'2021-11-22 10:18:24',254,2,NULL,6,'','0'),
(1255,'2021-11-22 10:18:24',255,1,NULL,6,'','0'),
(1256,'2021-11-22 10:18:24',256,1,NULL,6,'','0'),
(1257,'2021-11-22 10:18:24',257,1,NULL,6,'','0'),
(1258,'2021-11-22 10:18:24',258,3,NULL,6,'','0'),
(1259,'2021-11-22 10:18:24',259,3,NULL,6,'','0'),
(1260,'2021-11-22 10:18:24',260,3,NULL,6,'','0'),
(1261,'2021-11-22 10:18:24',261,1,NULL,6,'','0'),
(1262,'2021-11-22 10:18:24',262,1,NULL,6,'','0'),
(1263,'2021-11-22 10:18:24',263,1,NULL,6,'','0'),
(1264,'2021-11-22 10:18:24',264,1,NULL,6,'','0'),
(1265,'2021-11-22 10:18:24',265,1,NULL,6,'','0'),
(1266,'2021-11-22 09:00:00',144,-26,84925,NULL,'','0'),
(1267,'2021-11-22 09:00:00',162,-213,84925,NULL,'','0'),
(1268,'2021-11-22 09:00:00',212,-26,84925,NULL,'','0'),
(1269,'2021-11-22 09:00:00',213,-29,84925,NULL,'','0'),
(1270,'2021-11-22 10:00:00',218,-1,88146,NULL,'','0'),
(1271,'2021-11-22 10:00:00',251,-1,88146,NULL,'','0'),
(1272,'2021-11-22 13:00:00',23,-41,86326,NULL,'','0'),
(1273,'2021-11-19 15:45:00',86,-6,88043,NULL,'','0'),
(1274,'2021-11-19 15:45:00',89,-2,88043,NULL,'','0'),
(1275,'2021-11-22 15:47:34',182,4,NULL,7,'','0'),
(1276,'2021-11-22 15:30:00',210,-1,88183,NULL,'','0'),
(1277,'2021-11-22 14:30:00',173,-1,88184,NULL,'','0'),
(1278,'2021-11-18 16:00:00',45,-5,88186,NULL,'','0'),
(1279,'2021-11-18 16:00:00',76,-8,88186,NULL,'','0'),
(1280,'2021-11-18 16:00:00',86,-7,88186,NULL,'','0'),
(1281,'2021-11-18 16:00:00',89,-10,88186,NULL,'','0'),
(1282,'2021-11-18 16:00:00',95,-10,88186,NULL,'','0'),
(1283,'2021-11-22 16:00:00',54,-14,86197,NULL,'','0'),
(1284,'2021-11-22 16:00:00',69,-6,86197,NULL,'','0'),
(1285,'2021-11-22 16:00:00',75,-11,86197,NULL,'','0'),
(1286,'2021-11-22 16:00:00',76,-18,86197,NULL,'','0'),
(1287,'2021-11-23 15:00:00',200,-1,88275,NULL,'','0'),
(1288,'2021-11-23 16:00:00',219,-1,88276,NULL,'','0'),
(1289,'2021-11-23 12:30:00',117,-29,86990,NULL,'','0'),
(1290,'2021-11-23 12:30:00',122,-13,86990,NULL,'','0'),
(1291,'2021-11-23 12:30:00',162,-90,86990,NULL,'','0'),
(1292,'2021-11-23 12:30:00',212,-22,86990,NULL,'','0'),
(1293,'2021-11-23 12:30:00',213,-8,86990,NULL,'','0'),
(1294,'2021-11-24 09:00:00',219,-1,88375,NULL,'','0'),
(1295,'2021-11-24 09:00:00',23,-30,88185,NULL,'','0'),
(1296,'2021-11-24 09:00:00',47,-12,88185,NULL,'','0'),
(1297,'2021-11-24 09:00:00',65,-10,88185,NULL,'','0'),
(1298,'2021-11-24 09:00:00',82,-7,88185,NULL,'','0'),
(1299,'2021-11-24 09:00:00',147,-11,88185,NULL,'','0'),
(1300,'2021-11-24 09:00:00',163,-10,88185,NULL,'','0'),
(1301,'2021-11-24 13:00:00',23,-21,88262,NULL,'','0'),
(1302,'2021-11-24 13:00:00',45,-15,88262,NULL,'','0'),
(1303,'2021-11-24 13:00:00',48,-12,88262,NULL,'','0'),
(1304,'2021-11-24 13:00:00',106,-20,88262,NULL,'','0'),
(1305,'2021-11-24 13:00:00',124,-10,88262,NULL,'','0'),
(1306,'2021-11-24 13:30:00',45,-6,87566,NULL,'','0'),
(1307,'2021-11-24 13:30:00',47,-17,87566,NULL,'','0'),
(1308,'2021-11-24 13:30:00',82,-4,87566,NULL,'','0'),
(1309,'2021-11-24 13:30:00',138,-29,87566,NULL,'','0'),
(1310,'2021-11-24 13:30:00',162,-139,87566,NULL,'','0'),
(1311,'2021-11-24 13:30:00',163,-10,87566,NULL,'','0'),
(1312,'2021-11-25 09:00:00',2,-15,88264,NULL,'','0'),
(1313,'2021-11-25 09:00:00',47,-7,88264,NULL,'','0'),
(1314,'2021-11-25 09:00:00',65,-6,88264,NULL,'','0'),
(1315,'2021-11-25 09:00:00',74,-11,88264,NULL,'','0'),
(1316,'2021-11-25 09:00:00',162,-30,88264,NULL,'','0'),
(1317,'2021-11-25 10:00:00',2,-65,86298,NULL,'','0'),
(1318,'2021-11-25 10:00:00',5,-20,86298,NULL,'','0'),
(1319,'2021-11-25 10:00:00',152,-25,86298,NULL,'','0'),
(1320,'2021-11-25 10:00:00',153,-26,86298,NULL,'','0'),
(1321,'2021-11-25 10:00:00',162,-56,86298,NULL,'','0'),
(1322,'2021-11-25 16:00:00',241,-1,88457,NULL,'','0'),
(1323,'2021-11-25 16:00:00',242,-1,88457,NULL,'','0'),
(1324,'2021-11-26 09:00:00',266,-1,88482,NULL,'','0'),
(1325,'2021-11-25 15:00:00',25,-21,88361,NULL,'','0'),
(1326,'2021-11-25 15:00:00',82,-15,88361,NULL,'','0'),
(1327,'2021-11-25 15:00:00',88,-9,88361,NULL,'','0'),
(1328,'2021-11-25 15:00:00',96,-5,88361,NULL,'','0'),
(1329,'2021-11-25 15:00:00',163,-15,88361,NULL,'','0'),
(1330,'2021-11-26 11:40:52',187,5,NULL,8,'','0'),
(1331,'2021-11-26 11:40:52',200,1,NULL,8,'','0'),
(1332,'2021-11-26 11:40:52',210,5,NULL,8,'','0'),
(1333,'2021-11-26 11:40:52',267,1,NULL,8,'','0'),
(1334,'2021-11-26 11:40:52',268,4,NULL,8,'','0'),
(1335,'2021-11-26 11:40:52',269,2,NULL,8,'','0'),
(1336,'2021-11-26 11:40:52',270,2,NULL,8,'','0'),
(1337,'2021-11-26 11:40:52',271,1,NULL,8,'','0'),
(1338,'2021-11-26 11:40:52',272,1,NULL,8,'','0'),
(1339,'2021-11-26 09:00:00',122,-9,87380,NULL,'','0'),
(1340,'2021-11-26 09:00:00',144,-14,87380,NULL,'','0'),
(1341,'2021-11-26 09:00:00',162,-152,87380,NULL,'','0'),
(1342,'2021-11-26 09:00:00',212,-18,87380,NULL,'','0'),
(1343,'2021-11-26 09:00:00',213,-12,87380,NULL,'','0'),
(1344,'2021-11-26 10:00:00',218,-1,88508,NULL,'','0'),
(1345,'2021-11-26 14:00:00',6,-16,87444,NULL,'','0'),
(1346,'2021-11-26 14:00:00',10,-16,87444,NULL,'','0'),
(1347,'2021-11-26 14:00:00',44,-8,87444,NULL,'','0'),
(1348,'2021-11-26 14:00:00',52,-10,87444,NULL,'','0'),
(1349,'2021-11-26 14:00:00',71,-5,87444,NULL,'','0'),
(1350,'2021-11-26 14:00:00',92,-5,87444,NULL,'','0'),
(1351,'2021-11-26 14:00:00',97,-11,87444,NULL,'','0'),
(1352,'2021-11-26 11:00:00',166,-1,88541,NULL,'','0'),
(1353,'2021-11-27 11:08:22',273,1,NULL,9,'','0'),
(1354,'2021-11-27 11:08:22',274,2,NULL,9,'','0'),
(1355,'2021-11-27 11:08:22',275,2,NULL,9,'','0'),
(1356,'2021-11-27 11:08:22',276,2,NULL,9,'','0'),
(1357,'2021-11-27 11:08:22',277,2,NULL,9,'','0'),
(1358,'2021-11-27 11:08:22',278,2,NULL,9,'','0'),
(1359,'2021-11-27 12:00:00',204,-1,88578,NULL,'','0'),
(1360,'2021-11-27 12:57:35',2,87,NULL,10,'','0'),
(1361,'2021-11-27 12:57:35',23,261,NULL,10,'','0'),
(1362,'2021-11-27 12:57:35',25,174,NULL,10,'','0'),
(1363,'2021-11-27 12:57:35',28,87,NULL,10,'','0'),
(1364,'2021-11-27 12:57:35',162,1000,NULL,10,'','0'),
(1365,'2021-11-27 12:57:35',279,87,NULL,10,'','0'),
(1366,'2021-11-27 12:57:35',280,87,NULL,10,'','0'),
(1367,'2021-11-27 12:57:35',281,87,NULL,10,'','0'),
(1368,'2021-11-27 13:15:00',238,-1,88587,NULL,'','0'),
(1369,'2021-11-27 09:00:00',2,-16,87751,NULL,'','0'),
(1370,'2021-11-27 09:00:00',25,-41,87751,NULL,'','0'),
(1371,'2021-11-27 09:00:00',71,-10,87751,NULL,'','0'),
(1372,'2021-11-27 09:00:00',92,-3,87751,NULL,'','0'),
(1373,'2021-11-27 09:00:00',96,-5,87751,NULL,'','0'),
(1374,'2021-11-27 09:00:00',97,-14,87751,NULL,'','0'),
(1375,'2021-11-27 09:00:00',147,-14,87751,NULL,'','0'),
(1376,'2021-11-27 09:00:00',162,-120,87751,NULL,'','0'),
(1377,'2021-11-27 13:00:00',54,-10,88590,NULL,'','0'),
(1378,'2021-11-27 12:00:00',47,-13,87799,NULL,'','0'),
(1379,'2021-11-27 12:00:00',74,-6,87799,NULL,'','0'),
(1380,'2021-11-27 12:00:00',97,-5,87799,NULL,'','0'),
(1381,'2021-11-27 12:00:00',162,-93,87799,NULL,'','0'),
(1382,'2021-11-27 12:00:00',163,-8,87799,NULL,'','0'),
(1383,'2021-11-27 15:00:00',219,-1,88615,NULL,'','0'),
(1384,'2021-11-27 17:00:00',248,-1,88618,NULL,'','0'),
(1385,'2021-11-27 16:00:00',2,-11,88420,NULL,'','0'),
(1386,'2021-11-27 16:00:00',66,-10,88420,NULL,'','0'),
(1387,'2021-11-27 16:00:00',91,-10,88420,NULL,'','0'),
(1388,'2021-11-27 16:00:00',147,-10,88420,NULL,'','0'),
(1389,'2021-11-27 16:00:00',6,-51,87929,NULL,'','0'),
(1390,'2021-11-27 16:00:00',217,-30,87929,NULL,'','0'),
(1391,'2021-11-29 09:15:00',210,-1,88665,NULL,'','0'),
(1392,'2021-11-29 12:00:00',28,-20,88149,NULL,'','0'),
(1393,'2021-11-29 12:00:00',57,-9,88149,NULL,'','0'),
(1394,'2021-11-29 12:00:00',162,-68,88149,NULL,'','0'),
(1395,'2021-11-29 12:00:00',212,-28,88149,NULL,'','0'),
(1396,'2021-11-29 12:00:00',213,-9,88149,NULL,'','0'),
(1397,'2021-11-29 12:00:00',285,-10,88149,NULL,'','0');

INSERT INTO `materials_registr` VALUES 
(1398,'2021-11-29 13:00:00',238,-1,88701,NULL,'','0'),
(1399,'2021-11-29 14:00:00',228,-1,88702,NULL,'','0'),
(1400,'2021-11-29 15:00:00',187,-1,88730,NULL,'','0'),
(1401,'2021-11-30 11:09:46',44,50,NULL,11,'','0'),
(1402,'2021-11-30 11:09:46',45,100,NULL,11,'','0'),
(1403,'2021-11-30 11:09:46',46,50,NULL,11,'','0'),
(1404,'2021-11-30 11:09:46',47,100,NULL,11,'','0'),
(1405,'2021-11-30 11:09:46',48,50,NULL,11,'','0'),
(1406,'2021-11-30 11:09:46',52,50,NULL,11,'','0'),
(1407,'2021-11-30 11:09:46',53,100,NULL,11,'','0'),
(1408,'2021-11-30 11:09:46',54,50,NULL,11,'','0'),
(1409,'2021-11-30 11:09:46',57,50,NULL,11,'','0'),
(1410,'2021-11-30 11:09:46',58,50,NULL,11,'','0'),
(1411,'2021-11-30 11:09:46',59,50,NULL,11,'','0'),
(1412,'2021-11-30 11:09:46',61,50,NULL,11,'','0'),
(1413,'2021-11-30 11:09:46',63,50,NULL,11,'','0'),
(1414,'2021-11-30 11:09:46',65,50,NULL,11,'','0'),
(1415,'2021-11-30 11:09:46',68,50,NULL,11,'','0'),
(1416,'2021-11-30 11:09:46',69,50,NULL,11,'','0'),
(1417,'2021-11-30 11:09:46',70,50,NULL,11,'','0'),
(1418,'2021-11-30 11:09:46',71,50,NULL,11,'','0'),
(1419,'2021-11-30 11:09:46',72,50,NULL,11,'','0'),
(1420,'2021-11-30 11:09:46',74,50,NULL,11,'','0'),
(1421,'2021-11-30 11:09:46',75,50,NULL,11,'','0'),
(1422,'2021-11-30 11:09:46',76,100,NULL,11,'','0'),
(1423,'2021-11-30 11:09:46',77,50,NULL,11,'','0'),
(1424,'2021-11-30 11:09:46',81,50,NULL,11,'','0'),
(1425,'2021-11-30 11:09:46',82,50,NULL,11,'','0'),
(1426,'2021-11-30 11:09:46',89,100,NULL,11,'','0'),
(1427,'2021-11-30 11:09:46',91,50,NULL,11,'','0'),
(1428,'2021-11-30 11:09:46',92,50,NULL,11,'','0'),
(1429,'2021-11-30 11:09:46',95,50,NULL,11,'','0'),
(1430,'2021-11-30 11:09:46',96,50,NULL,11,'','0'),
(1431,'2021-11-30 11:09:46',97,100,NULL,11,'','0'),
(1432,'2021-11-30 11:09:46',163,50,NULL,11,'','0'),
(1433,'2021-11-30 11:09:46',282,50,NULL,11,'','0'),
(1434,'2021-11-30 11:09:46',283,50,NULL,11,'','0'),
(1435,'2021-11-30 11:09:46',284,50,NULL,11,'','0'),
(1436,'2021-11-30 11:09:46',285,50,NULL,11,'','0'),
(1437,'2021-11-30 11:09:46',286,50,NULL,11,'','0'),
(1438,'2021-11-30 11:09:46',287,50,NULL,11,'','0'),
(1439,'2021-11-30 11:09:46',288,50,NULL,11,'','0'),
(1440,'2021-11-30 11:09:46',289,50,NULL,11,'','0'),
(1441,'2021-11-30 11:09:46',290,50,NULL,11,'','0'),
(1442,'2021-11-30 11:09:46',291,50,NULL,11,'','0'),
(1443,'2021-11-30 11:09:46',292,50,NULL,11,'','0'),
(1444,'2021-11-30 13:15:00',268,-1,88881,NULL,'','0'),
(1445,'2021-11-30 10:00:00',162,-83,88051,NULL,'','0'),
(1446,'2021-12-01 19:00:00',118,-35,88915,NULL,'','0'),
(1447,'2021-12-01 09:00:00',57,-8,88880,NULL,'','0'),
(1448,'2021-12-01 09:00:00',147,-20,88880,NULL,'','0'),
(1449,'2021-12-01 09:00:00',285,-11,88880,NULL,'','0'),
(1450,'2021-12-01 11:00:00',118,-50,87226,NULL,'','0'),
(1451,'2021-12-01 13:00:00',23,-41,88405,NULL,'','0'),
(1452,'2021-12-01 13:00:00',25,-41,88405,NULL,'','0'),
(1453,'2021-12-01 11:00:00',60,-10,88731,NULL,'','0'),
(1454,'2021-12-01 11:00:00',70,-7,88731,NULL,'','0'),
(1455,'2021-12-01 11:00:00',111,-11,88731,NULL,'','0'),
(1456,'2021-12-01 11:00:00',147,-6,88731,NULL,'','0'),
(1457,'2021-12-01 11:00:00',162,-72,88731,NULL,'','0'),
(1458,'2021-12-01 11:00:00',213,-5,88731,NULL,'','0'),
(1459,'2021-12-01 15:00:00',2,-12,88884,NULL,'','0'),
(1460,'2021-12-01 15:00:00',72,-11,88884,NULL,'','0'),
(1461,'2021-12-01 15:00:00',95,-6,88884,NULL,'','0'),
(1462,'2021-12-01 15:00:00',162,-90,88884,NULL,'','0'),
(1463,'2021-12-01 15:00:00',285,-9,88884,NULL,'','0'),
(1464,'2021-12-01 15:00:00',99,-17,87394,NULL,'','0'),
(1465,'2021-12-01 15:00:00',106,-21,87394,NULL,'','0'),
(1466,'2021-12-02 13:00:00',4,-35,88872,NULL,'','0'),
(1467,'2021-12-02 13:00:00',23,-35,88872,NULL,'','0'),
(1468,'2021-12-02 13:00:00',280,-20,88872,NULL,'','0'),
(1469,'2021-12-02 17:00:00',23,-25,88609,NULL,'','0'),
(1470,'2021-12-02 17:00:00',24,-30,88609,NULL,'','0'),
(1471,'2021-12-02 17:00:00',52,-13,88609,NULL,'','0'),
(1472,'2021-12-02 17:00:00',71,-12,88609,NULL,'','0'),
(1473,'2021-12-02 17:00:00',92,-8,88609,NULL,'','0'),
(1474,'2021-12-02 17:00:00',97,-16,88609,NULL,'','0'),
(1475,'2021-12-02 13:00:00',2,-27,88539,NULL,'','0'),
(1476,'2021-12-02 13:00:00',5,-7,88539,NULL,'','0'),
(1477,'2021-12-02 13:00:00',27,-8,88539,NULL,'','0'),
(1478,'2021-12-02 13:00:00',28,-19,88539,NULL,'','0'),
(1479,'2021-12-02 13:00:00',162,-58,88539,NULL,'','0'),
(1480,'2021-12-02 13:00:00',279,-23,88539,NULL,'','0'),
(1481,'2021-12-02 09:00:00',210,-1,89074,NULL,'','0'),
(1482,'2021-12-03 10:00:19',1,-17,NULL,12,'','0'),
(1483,'2021-12-03 10:00:19',225,-4,NULL,12,'','0'),
(1484,'2021-12-03 10:00:19',226,-4,NULL,12,'','0'),
(1485,'2021-12-03 10:00:19',227,-10,NULL,12,'','0'),
(1486,'2021-12-03 10:00:19',239,-1,NULL,12,'','0'),
(1487,'2021-12-03 10:13:56',220,1,NULL,13,'','0'),
(1488,'2021-12-03 10:13:56',222,2,NULL,13,'','0'),
(1489,'2021-12-03 10:13:56',231,3,NULL,13,'','0'),
(1490,'2021-12-03 10:13:56',238,3,NULL,13,'','0'),
(1491,'2021-12-03 10:13:56',239,2,NULL,13,'','0'),
(1492,'2021-12-03 10:13:56',241,2,NULL,13,'','0'),
(1493,'2021-12-03 10:13:56',242,3,NULL,13,'','0'),
(1494,'2021-12-03 10:13:56',293,3,NULL,13,'','0'),
(1495,'2021-12-03 10:13:56',294,4,NULL,13,'','0'),
(1496,'2021-12-03 10:13:56',295,4,NULL,13,'','0'),
(1497,'2021-12-03 10:13:56',296,4,NULL,13,'','0'),
(1498,'2021-12-03 10:13:56',297,4,NULL,13,'','0'),
(1499,'2021-12-03 10:13:56',298,4,NULL,13,'','0'),
(1500,'2021-12-03 10:13:56',299,4,NULL,13,'','0'),
(1501,'2021-12-03 10:13:56',300,3,NULL,13,'','0'),
(1502,'2021-12-03 10:13:56',301,3,NULL,13,'','0'),
(1503,'2021-12-03 09:00:00',221,-1,89083,NULL,'','0'),
(1504,'2021-12-03 11:47:00',162,1000,NULL,14,'','0'),
(1505,'2021-12-03 11:47:00',212,85,NULL,14,'','0'),
(1506,'2021-12-03 11:47:00',213,85,NULL,14,'','0'),
(1507,'2021-12-03 10:00:00',167,-1,89116,NULL,'','0'),
(1508,'2021-12-03 10:00:00',218,-1,89116,NULL,'','0'),
(1509,'2021-12-03 09:00:00',53,-10,88254,NULL,'','0'),
(1510,'2021-12-03 09:00:00',58,-7,88254,NULL,'','0'),
(1511,'2021-12-03 09:00:00',72,-9,88254,NULL,'','0'),
(1512,'2021-12-03 09:00:00',162,-100,88254,NULL,'','0'),
(1513,'2021-12-03 09:00:00',212,-19,88254,NULL,'','0'),
(1514,'2021-12-03 09:00:00',213,-8,88254,NULL,'','0'),
(1515,'2021-12-03 12:00:00',45,-22,88873,NULL,'','0'),
(1516,'2021-12-03 12:00:00',132,-30,88873,NULL,'','0'),
(1517,'2021-12-03 08:30:00',69,-14,88965,NULL,'','0'),
(1518,'2021-12-03 08:30:00',91,-11,88965,NULL,'','0'),
(1519,'2021-12-03 08:30:00',96,-2,88965,NULL,'','0'),
(1520,'2021-12-03 08:30:00',97,-10,88965,NULL,'','0'),
(1521,'2021-12-03 08:30:00',162,-30,88965,NULL,'','0'),
(1522,'2021-12-03 08:30:00',285,-13,88965,NULL,'','0'),
(1523,'2021-12-03 16:15:00',28,-21,88584,NULL,'','0'),
(1524,'2021-12-03 16:15:00',66,-9,88584,NULL,'','0'),
(1525,'2021-12-03 16:15:00',144,-22,88584,NULL,'','0'),
(1526,'2021-12-03 16:15:00',213,-23,88584,NULL,'','0'),
(1527,'2021-12-04 09:00:00',58,-11,88381,NULL,'','0'),
(1528,'2021-12-04 09:00:00',72,-11,88381,NULL,'','0'),
(1529,'2021-12-04 09:00:00',162,-90,88381,NULL,'','0'),
(1530,'2021-12-04 09:00:00',282,-10,88381,NULL,'','0'),
(1531,'2021-12-04 11:00:00',268,-1,89155,NULL,'','0'),
(1532,'2021-12-04 09:00:00',18,-13,88948,NULL,'','0'),
(1533,'2021-12-04 09:00:00',25,-16,88948,NULL,'','0'),
(1534,'2021-12-04 09:00:00',111,-5,88948,NULL,'','0'),
(1535,'2021-12-04 09:00:00',150,-10,88948,NULL,'','0'),
(1536,'2021-12-04 09:00:00',153,-17,88948,NULL,'','0'),
(1537,'2021-12-04 09:00:00',162,-70,88948,NULL,'','0'),
(1538,'2021-12-04 09:00:00',285,-8,88948,NULL,'','0'),
(1539,'2021-12-04 13:00:00',42,-27,87817,NULL,'','0'),
(1540,'2021-12-04 13:00:00',144,-16,87817,NULL,'','0'),
(1541,'2021-12-04 13:00:00',162,-60,87817,NULL,'','0'),
(1542,'2021-12-04 13:00:00',166,-1,89211,NULL,'','0'),
(1543,'2021-12-06 09:00:00',53,-14,88495,NULL,'','0'),
(1544,'2021-12-06 09:00:00',57,-11,88495,NULL,'','0'),
(1545,'2021-12-06 09:00:00',162,-70,88495,NULL,'','0'),
(1546,'2021-12-06 09:00:00',163,-12,88495,NULL,'','0'),
(1547,'2021-12-06 14:58:24',302,84,NULL,15,'','0'),
(1548,'2021-12-06 14:58:24',303,84,NULL,15,'','0'),
(1549,'2021-12-06 14:58:24',304,84,NULL,15,'','0'),
(1550,'2021-12-06 14:58:24',305,84,NULL,15,'','0'),
(1551,'2021-12-06 14:58:24',306,84,NULL,15,'','0'),
(1552,'2021-12-06 14:58:24',307,84,NULL,15,'','0'),
(1553,'2021-12-06 15:15:00',300,-1,89265,NULL,'','0'),
(1554,'2021-12-06 16:15:00',262,-1,89268,NULL,'','0'),
(1555,'2021-12-07 10:00:00',2,-15,88928,NULL,'','0'),
(1556,'2021-12-07 10:00:00',35,-16,88928,NULL,'','0'),
(1557,'2021-12-07 10:00:00',53,-11,88928,NULL,'','0'),
(1558,'2021-12-07 10:00:00',162,-52,88928,NULL,'','0'),
(1559,'2021-12-07 10:00:00',213,-9,88928,NULL,'','0'),
(1560,'2021-12-07 10:00:00',302,-25,88928,NULL,'','0'),
(1561,'2021-12-07 17:00:00',196,-1,89346,NULL,'','0'),
(1562,'2021-12-07 18:00:00',300,-1,89347,NULL,'','0'),
(1563,'2021-12-07 18:00:00',301,-1,89347,NULL,'','0'),
(1564,'2021-12-07 19:00:00',300,-1,89348,NULL,'','0'),
(1565,'2021-12-07 19:00:00',301,-1,89348,NULL,'','0'),
(1566,'2021-12-08 11:00:00',218,-1,89372,NULL,'','0'),
(1567,'2021-12-08 12:00:00',294,-1,89378,NULL,'','0'),
(1568,'2021-12-08 12:00:00',301,-1,89378,NULL,'','0'),
(1569,'2021-12-08 11:00:00',37,-50,87989,NULL,'','0'),
(1570,'2021-12-08 13:00:00',205,-1,89381,NULL,'','0'),
(1571,'2021-12-08 12:51:24',266,2,NULL,16,'','0'),
(1572,'2021-12-08 14:00:00',192,-1,89390,NULL,'','0'),
(1573,'2021-12-08 14:54:14',218,1,NULL,17,'','0'),
(1574,'2021-12-08 14:54:14',308,2,NULL,17,'','0'),
(1575,'2021-12-08 14:54:14',309,1,NULL,17,'','0'),
(1576,'2021-12-08 14:54:14',310,2,NULL,17,'','0'),
(1577,'2021-12-08 14:54:14',311,1,NULL,17,'','0'),
(1578,'2021-12-08 14:54:14',312,3,NULL,17,'','0'),
(1579,'2021-12-08 15:00:00',308,-1,89399,NULL,'','0'),
(1580,'2021-12-08 10:00:00',23,-15,88939,NULL,'','0'),
(1581,'2021-12-08 10:00:00',44,-13,88939,NULL,'','0'),
(1582,'2021-12-08 10:00:00',71,-11,88939,NULL,'','0'),
(1583,'2021-12-08 10:00:00',80,-1,88939,NULL,'','0'),
(1584,'2021-12-08 10:00:00',138,-13,88939,NULL,'','0'),
(1585,'2021-12-08 10:00:00',162,-125,88939,NULL,'','0'),
(1586,'2021-12-08 10:00:00',163,-10,88939,NULL,'','0'),
(1587,'2021-12-08 10:00:00',306,-17,88939,NULL,'','0'),
(1588,'2021-12-08 16:00:00',269,-1,89418,NULL,'','0'),
(1589,'2021-12-08 16:00:00',270,-1,89418,NULL,'','0'),
(1590,'2021-12-08 14:00:00',66,-8,89187,NULL,'','0'),
(1591,'2021-12-08 14:00:00',89,-8,89187,NULL,'','0'),
(1592,'2021-12-08 14:00:00',96,-7,89187,NULL,'','0'),
(1593,'2021-12-08 14:00:00',162,-80,89187,NULL,'','0'),
(1594,'2021-12-08 14:00:00',302,-7,89187,NULL,'','0'),
(1595,'2021-12-08 14:00:00',303,-10,89187,NULL,'','0'),
(1596,'2021-12-08 14:00:00',306,-15,89187,NULL,'','0'),
(1597,'2021-12-08 17:00:00',227,-1,89421,NULL,'','0'),
(1598,'2021-12-08 15:00:00',6,-15,89204,NULL,'','0'),
(1599,'2021-12-08 15:00:00',16,-7,89204,NULL,'','0'),
(1600,'2021-12-08 15:00:00',25,-30,89204,NULL,'','0'),
(1601,'2021-12-08 15:00:00',28,-9,89204,NULL,'','0'),
(1602,'2021-12-08 15:00:00',44,-9,89204,NULL,'','0'),
(1603,'2021-12-08 15:00:00',93,-7,89204,NULL,'','0'),
(1604,'2021-12-08 15:00:00',162,-110,89204,NULL,'','0'),
(1605,'2021-12-08 15:00:00',213,-8,89204,NULL,'','0'),
(1606,'2021-12-09 17:00:00',28,-21,89203,NULL,'','0'),
(1607,'2021-12-09 17:00:00',53,-3,89203,NULL,'','0'),
(1608,'2021-12-09 17:00:00',61,-9,89203,NULL,'','0'),
(1609,'2021-12-09 17:00:00',66,-5,89203,NULL,'','0'),
(1610,'2021-12-09 17:00:00',81,-10,89203,NULL,'','0'),
(1611,'2021-12-09 17:00:00',162,-119,89203,NULL,'','0'),
(1612,'2021-12-09 17:00:00',285,-4,89203,NULL,'','0'),
(1613,'2021-12-09 11:00:00',24,-19,88727,NULL,'','0'),
(1614,'2021-12-09 11:00:00',44,-13,88727,NULL,'','0'),
(1615,'2021-12-09 11:00:00',45,-10,88727,NULL,'','0'),
(1616,'2021-12-09 11:00:00',52,-10,88727,NULL,'','0'),
(1617,'2021-12-09 11:00:00',67,-3,88727,NULL,'','0'),
(1618,'2021-12-09 11:00:00',71,-8,88727,NULL,'','0'),
(1619,'2021-12-09 11:00:00',162,-107,88727,NULL,'','0'),
(1620,'2021-12-09 11:00:00',217,-19,88727,NULL,'','0'),
(1621,'2021-12-09 09:00:00',25,-16,89371,NULL,'','0'),
(1622,'2021-12-09 09:00:00',74,-5,89371,NULL,'','0'),
(1623,'2021-12-09 09:00:00',163,-15,89371,NULL,'','0'),
(1624,'2021-12-09 09:00:00',284,-20,89371,NULL,'','0'),
(1625,'2021-12-09 09:00:00',306,-23,89371,NULL,'','0'),
(1626,'2021-12-09 12:00:00',47,-10,89394,NULL,'','0'),
(1627,'2021-12-09 12:00:00',82,-15,89394,NULL,'','0'),
(1628,'2021-12-09 12:00:00',163,-15,89394,NULL,'','0'),
(1629,'2021-12-09 12:00:00',284,-28,89394,NULL,'','0'),
(1630,'2021-12-09 10:00:00',196,-1,89481,NULL,'','0'),
(1631,'2021-12-09 10:00:00',210,-2,89481,NULL,'','0'),
(1632,'2021-12-09 10:00:00',214,-1,89481,NULL,'','0'),
(1633,'2021-12-09 10:00:00',310,-1,89481,NULL,'','0'),
(1634,'2021-12-10 09:00:00',45,-9,88302,NULL,'','0'),
(1635,'2021-12-10 09:00:00',67,-2,88302,NULL,'','0'),
(1636,'2021-12-10 09:00:00',68,-12,88302,NULL,'','0'),
(1637,'2021-12-10 09:00:00',284,-12,88302,NULL,'','0'),
(1638,'2021-12-10 09:00:00',305,-20,88302,NULL,'','0'),
(1639,'2021-12-10 14:00:00',23,-18,89435,NULL,'','0'),
(1640,'2021-12-10 14:00:00',162,-125,89435,NULL,'','0'),
(1641,'2021-12-10 14:00:00',280,-18,89435,NULL,'','0'),
(1642,'2021-12-10 15:30:00',60,-17,89190,NULL,'','0'),
(1643,'2021-12-10 15:30:00',61,-14,89190,NULL,'','0'),
(1644,'2021-12-10 15:30:00',81,-15,89190,NULL,'','0'),
(1645,'2021-12-10 15:30:00',162,-137,89190,NULL,'','0'),
(1646,'2021-12-11 09:00:00',263,-1,89532,NULL,'','0'),
(1647,'2021-12-11 09:00:00',58,-14,85246,NULL,'','0'),
(1648,'2021-12-11 09:00:00',60,-8,85246,NULL,'','0'),
(1649,'2021-12-11 09:00:00',61,-12,85246,NULL,'','0'),
(1650,'2021-12-11 09:00:00',81,-9,85246,NULL,'','0'),
(1651,'2021-12-11 09:00:00',162,-100,85246,NULL,'','0'),
(1652,'2021-12-11 14:40:22',2,86,NULL,18,'','0'),
(1653,'2021-12-11 14:40:22',5,86,NULL,18,'','0'),
(1654,'2021-12-11 14:40:22',24,86,NULL,18,'','0'),
(1655,'2021-12-11 14:40:22',25,86,NULL,18,'','0'),
(1656,'2021-12-11 14:40:22',28,86,NULL,18,'','0'),
(1657,'2021-12-11 14:40:22',37,86,NULL,18,'','0'),
(1658,'2021-12-11 14:40:22',162,2000,NULL,18,'','0'),
(1659,'2021-12-11 14:40:22',313,86,NULL,18,'','0'),
(1660,'2021-12-11 14:40:22',314,86,NULL,18,'','0'),
(1661,'2021-12-11 14:40:22',315,86,NULL,18,'','0'),
(1662,'2021-12-11 11:00:00',2,-15,89242,NULL,'','0'),
(1663,'2021-12-11 11:00:00',25,-15,89242,NULL,'','0'),
(1664,'2021-12-11 11:00:00',303,-20,89242,NULL,'','0'),
(1665,'2021-12-11 11:00:00',306,-16,89242,NULL,'','0'),
(1666,'2021-12-11 11:00:00',313,-22,89242,NULL,'','0'),
(1667,'2021-12-11 13:00:00',2,-10,89404,NULL,'','0'),
(1668,'2021-12-11 13:00:00',23,-15,89404,NULL,'','0'),
(1669,'2021-12-11 13:00:00',53,-8,89404,NULL,'','0'),
(1670,'2021-12-11 13:00:00',57,-8,89404,NULL,'','0'),
(1671,'2021-12-11 13:00:00',74,-10,89404,NULL,'','0'),
(1672,'2021-12-11 13:00:00',96,-8,89404,NULL,'','0'),
(1673,'2021-12-11 13:00:00',162,-80,89404,NULL,'','0'),
(1674,'2021-12-11 13:00:00',313,-11,89404,NULL,'','0'),
(1675,'2021-12-11 13:00:00',72,-7,86107,NULL,'','0'),
(1676,'2021-12-11 13:00:00',162,-50,86107,NULL,'','0'),
(1677,'2021-12-11 13:00:00',283,-14,86107,NULL,'','0'),
(1678,'2021-12-13 11:43:11',316,12,NULL,19,'','0'),
(1679,'2021-12-13 09:00:00',53,-14,87593,NULL,'','0'),
(1680,'2021-12-13 09:00:00',86,-7,87593,NULL,'','0'),
(1681,'2021-12-13 09:00:00',162,-48,87593,NULL,'','0'),
(1682,'2021-12-13 11:00:00',316,-1,89584,NULL,'','0'),
(1683,'2021-12-13 14:00:00',23,-31,87330,NULL,'','0'),
(1684,'2021-12-13 14:00:00',24,-32,87330,NULL,'','0'),
(1685,'2021-12-13 14:00:00',32,-44,87330,NULL,'','0'),
(1686,'2021-12-13 14:00:00',38,-41,87330,NULL,'','0'),
(1687,'2021-12-13 14:00:00',158,-11,87330,NULL,'','0'),
(1688,'2021-12-13 12:00:00',316,-4,89608,NULL,'','0'),
(1689,'2021-12-13 13:00:00',316,-1,89612,NULL,'','0'),
(1690,'2021-12-14 09:00:00',210,-1,89615,NULL,'','0'),
(1691,'2021-12-14 09:00:00',271,-1,89615,NULL,'','0'),
(1692,'2021-12-14 09:00:00',4,-19,88679,NULL,'','0'),
(1693,'2021-12-14 09:00:00',14,-11,88679,NULL,'','0'),
(1694,'2021-12-14 09:00:00',23,-24,88679,NULL,'','0'),
(1695,'2021-12-14 09:00:00',217,-23,88679,NULL,'','0'),
(1696,'2021-12-14 10:00:00',316,-1,89628,NULL,'','0'),
(1697,'2021-12-14 11:00:00',166,-1,89631,NULL,'','0'),
(1698,'2021-12-14 11:00:00',272,-1,89631,NULL,'','0'),
(1699,'2021-12-14 09:00:00',47,-6,89610,NULL,'','0'),
(1700,'2021-12-14 09:00:00',89,-9,89610,NULL,'','0'),
(1701,'2021-12-14 09:00:00',97,-6,89610,NULL,'','0'),
(1702,'2021-12-14 09:00:00',162,-80,89610,NULL,'','0'),
(1703,'2021-12-14 09:00:00',302,-13,89610,NULL,'','0'),
(1704,'2021-12-14 14:00:00',74,-11,89525,NULL,'','0'),
(1705,'2021-12-14 14:00:00',76,-15,89525,NULL,'','0'),
(1706,'2021-12-14 14:00:00',162,-55,89525,NULL,'','0'),
(1707,'2021-12-14 14:00:00',303,-12,89525,NULL,'','0'),
(1708,'2021-12-14 14:00:00',313,-15,89525,NULL,'','0'),
(1709,'2021-12-14 11:00:00',58,-8,87200,NULL,'','0'),
(1710,'2021-12-14 11:00:00',72,-5,87200,NULL,'','0'),
(1711,'2021-12-14 11:00:00',151,-25,87200,NULL,'','0'),
(1712,'2021-12-14 11:00:00',153,-25,87200,NULL,'','0'),
(1713,'2021-12-14 11:00:00',162,-210,87200,NULL,'','0'),
(1714,'2021-12-14 11:00:00',282,-9,87200,NULL,'','0'),
(1715,'2021-12-14 16:00:00',23,-50,88145,NULL,'','0'),
(1716,'2021-12-14 18:00:00',47,-19,89332,NULL,'','0'),
(1717,'2021-12-14 18:00:00',55,-9,89332,NULL,'','0'),
(1718,'2021-12-14 18:00:00',79,-2,89332,NULL,'','0'),
(1719,'2021-12-14 18:00:00',82,-6,89332,NULL,'','0'),
(1720,'2021-12-14 18:00:00',163,-6,89332,NULL,'','0'),
(1721,'2021-12-14 12:00:00',204,-1,89664,NULL,'','0'),
(1722,'2021-12-14 12:00:00',267,-1,89664,NULL,'','0'),
(1723,'2021-12-14 13:00:00',316,-1,89669,NULL,'','0'),
(1724,'2021-12-15 09:00:00',2,-25,89544,NULL,'','0'),
(1725,'2021-12-15 09:00:00',35,-30,89544,NULL,'','0'),
(1726,'2021-12-15 09:00:00',74,-12,89544,NULL,'','0'),
(1727,'2021-12-15 09:00:00',76,-11,89544,NULL,'','0'),
(1728,'2021-12-15 09:00:00',153,-9,89544,NULL,'','0'),
(1729,'2021-12-15 09:00:00',162,-65,89544,NULL,'','0'),
(1730,'2021-12-15 09:00:00',213,-9,89544,NULL,'','0'),
(1731,'2021-12-15 09:00:00',303,-10,89544,NULL,'','0'),
(1732,'2021-12-15 10:00:00',54,-19,87621,NULL,'','0'),
(1733,'2021-12-15 10:00:00',60,-15,87621,NULL,'','0'),
(1734,'2021-12-15 10:00:00',153,-32,87621,NULL,'','0'),
(1735,'2021-12-15 10:00:00',162,-158,87621,NULL,'','0'),
(1736,'2021-12-15 13:00:00',37,-10,89556,NULL,'','0'),
(1737,'2021-12-15 13:00:00',216,-60,89556,NULL,'','0'),
(1738,'2021-12-15 17:00:00',25,-14,87100,NULL,'','0'),
(1739,'2021-12-15 17:00:00',59,-13,87100,NULL,'','0'),
(1740,'2021-12-15 17:00:00',79,-1,87100,NULL,'','0'),
(1741,'2021-12-15 17:00:00',288,-15,87100,NULL,'','0'),
(1742,'2021-12-15 17:00:00',306,-12,87100,NULL,'','0'),
(1743,'2021-12-15 15:45:00',53,-8,89253,NULL,'','0'),
(1744,'2021-12-15 15:45:00',60,-8,89253,NULL,'','0'),
(1745,'2021-12-15 15:45:00',69,-7,89253,NULL,'','0'),
(1746,'2021-12-15 15:45:00',72,-11,89253,NULL,'','0'),
(1747,'2021-12-15 15:45:00',162,-150,89253,NULL,'','0'),
(1748,'2021-12-15 15:45:00',283,-11,89253,NULL,'','0'),
(1749,'2021-12-15 09:00:00',316,-1,89726,NULL,'','0'),
(1750,'2021-12-15 10:00:00',268,-1,89727,NULL,'','0'),
(1751,'2021-12-16 09:00:00',312,-1,89739,NULL,'','0'),
(1752,'2021-12-16 10:00:00',316,-1,89740,NULL,'','0'),
(1753,'2021-12-16 11:00:00',205,-1,89742,NULL,'','0'),
(1754,'2021-12-16 12:00:00',277,-1,89756,NULL,'','0'),
(1755,'2021-12-16 13:00:00',269,-1,89760,NULL,'','0'),
(1756,'2021-12-16 13:00:00',270,-1,89760,NULL,'','0'),
(1757,'2021-12-16 11:00:00',2,-18,89646,NULL,'','0'),
(1758,'2021-12-16 11:00:00',25,-20,89646,NULL,'','0'),
(1759,'2021-12-16 11:00:00',35,-13,89646,NULL,'','0'),
(1760,'2021-12-16 11:00:00',53,-8,89646,NULL,'','0'),
(1761,'2021-12-16 11:00:00',76,-12,89646,NULL,'','0'),
(1762,'2021-12-16 11:00:00',97,-9,89646,NULL,'','0'),
(1763,'2021-12-16 11:00:00',162,-125,89646,NULL,'','0'),
(1764,'2021-12-16 11:00:00',302,-15,89646,NULL,'','0'),
(1765,'2021-12-16 13:00:00',28,-21,87778,NULL,'','0'),
(1766,'2021-12-16 13:00:00',47,-7,87778,NULL,'','0'),
(1767,'2021-12-16 13:00:00',53,-10,87778,NULL,'','0'),
(1768,'2021-12-16 13:00:00',57,-8,87778,NULL,'','0'),
(1769,'2021-12-16 13:00:00',74,-6,87778,NULL,'','0'),
(1770,'2021-12-16 13:00:00',95,-6,87778,NULL,'','0'),
(1771,'2021-12-16 13:00:00',96,-2,87778,NULL,'','0'),
(1772,'2021-12-16 13:00:00',162,-152,87778,NULL,'','0'),
(1773,'2021-12-16 17:31:33',143,87,NULL,20,'','0'),
(1774,'2021-12-16 17:31:33',144,87,NULL,20,'','0'),
(1775,'2021-12-16 17:31:33',218,4,NULL,20,'','0'),
(1776,'2021-12-16 17:31:33',219,4,NULL,20,'','0'),
(1777,'2021-12-16 17:31:33',302,87,NULL,20,'','0'),
(1778,'2021-12-16 17:31:33',317,87,NULL,20,'','0'),
(1779,'2021-12-16 17:31:33',318,10,NULL,20,'','0'),
(1780,'2021-12-16 17:31:33',319,1,NULL,20,'','0'),
(1781,'2021-12-16 15:00:00',25,-16,89701,NULL,'','0'),
(1782,'2021-12-16 15:00:00',45,-6,89701,NULL,'','0'),
(1783,'2021-12-16 15:00:00',59,-8,89701,NULL,'','0'),
(1784,'2021-12-16 15:00:00',71,-7,89701,NULL,'','0'),
(1785,'2021-12-16 15:00:00',138,-10,89701,NULL,'','0'),
(1786,'2021-12-16 15:00:00',162,-120,89701,NULL,'','0'),
(1787,'2021-12-16 15:00:00',288,-6,89701,NULL,'','0'),
(1788,'2021-12-16 15:00:00',302,-10,89701,NULL,'','0'),
(1789,'2021-12-16 18:00:00',61,-11,89522,NULL,'','0'),
(1790,'2021-12-16 18:00:00',81,-10,89522,NULL,'','0'),
(1791,'2021-12-16 18:00:00',89,-10,89522,NULL,'','0'),
(1792,'2021-12-16 18:00:00',162,-50,89522,NULL,'','0'),
(1793,'2021-12-17 09:00:00',173,-1,89800,NULL,'','0'),
(1794,'2021-12-17 10:00:00',175,-1,89801,NULL,'','0'),
(1795,'2021-12-17 11:00:00',244,-1,89803,NULL,'','0'),
(1796,'2021-12-17 12:00:00',239,-1,89804,NULL,'','0'),
(1797,'2021-12-17 13:00:00',318,-4,89809,NULL,'','0'),
(1798,'2021-12-17 12:49:27',23,87,NULL,21,'','0'),
(1799,'2021-12-17 12:49:27',24,87,NULL,21,'','0'),
(1800,'2021-12-17 12:49:27',25,87,NULL,21,'','0'),
(1801,'2021-12-17 12:49:27',209,2,NULL,21,'','0'),
(1802,'2021-12-17 12:49:27',210,5,NULL,21,'','0'),
(1803,'2021-12-17 12:49:27',216,87,NULL,21,'','0'),
(1804,'2021-12-17 12:49:27',217,87,NULL,21,'','0'),
(1805,'2021-12-17 12:49:27',269,2,NULL,21,'','0'),
(1806,'2021-12-17 12:49:27',270,2,NULL,21,'','0'),
(1807,'2021-12-17 12:49:27',271,2,NULL,21,'','0'),
(1808,'2021-12-17 12:49:27',272,2,NULL,21,'','0'),
(1809,'2021-12-17 12:49:27',320,2,NULL,21,'','0'),
(1810,'2021-12-17 12:49:27',321,2,NULL,21,'','0'),
(1811,'2021-12-17 12:49:27',322,2,NULL,21,'','0'),
(1812,'2021-12-17 12:49:27',323,87,NULL,21,'','0'),
(1813,'2021-12-17 14:00:00',210,-1,89819,NULL,'','0'),
(1814,'2021-12-17 15:00:00',224,-1,89821,NULL,'','0'),
(1815,'2021-12-17 15:00:00',227,-1,89821,NULL,'','0'),
(1816,'2021-12-17 11:00:00',54,-12,89280,NULL,'','0'),
(1818,'2021-12-17 11:00:00',151,-26,89280,NULL,'','0'),
(1819,'2021-12-17 11:00:00',154,-22,89280,NULL,'','0'),
(1821,'2021-12-17 11:00:00',162,-55,89280,NULL,'','0'),
(1822,'2021-12-17 16:45:00',23,-31,89797,NULL,'','0'),
(1823,'2021-12-17 16:45:00',24,-21,89797,NULL,'','0'),
(1824,'2021-12-17 16:45:00',81,-6,89797,NULL,'','0'),
(1825,'2021-12-17 16:45:00',92,-11,89797,NULL,'','0'),
(1826,'2021-12-17 16:45:00',97,-10,89797,NULL,'','0'),
(1827,'2021-12-17 16:45:00',117,-20,89797,NULL,'','0'),
(1828,'2021-12-17 16:45:00',122,-13,89797,NULL,'','0'),
(1829,'2021-12-17 16:45:00',162,-133,89797,NULL,'','0'),
(1830,'2021-12-17 16:00:00',219,-1,89842,NULL,'','0'),
(1831,'2021-12-18 09:00:00',173,-1,89847,NULL,'','0'),
(1832,'2021-12-18 10:00:00',210,-1,89848,NULL,'','0'),
(1833,'2021-12-18 11:00:00',219,-2,89860,NULL,'','0'),
(1834,'2021-12-18 09:00:00',25,-32,89150,NULL,'','0'),
(1835,'2021-12-18 09:00:00',42,-1,89150,NULL,'','0'),
(1836,'2021-12-18 09:00:00',46,-21,89150,NULL,'','0'),
(1837,'2021-12-18 09:00:00',157,-1,89150,NULL,'','0'),
(1838,'2021-12-18 09:00:00',162,-165,89150,NULL,'','0'),
(1839,'2021-12-18 09:00:00',306,-5,89150,NULL,'','0'),
(1840,'2021-12-18 09:00:00',307,-41,89150,NULL,'','0'),
(1841,'2021-12-18 13:00:00',23,-40,89189,NULL,'','0'),
(1842,'2021-12-18 13:00:00',307,-10,89189,NULL,'','0'),
(1843,'2021-12-18 12:00:00',266,-1,89866,NULL,'','0'),
(1844,'2021-12-18 10:00:00',4,-40,89778,NULL,'','0'),
(1845,'2021-12-18 10:00:00',46,-10,89778,NULL,'','0'),
(1846,'2021-12-18 10:00:00',68,-11,89778,NULL,'','0'),
(1847,'2021-12-18 10:00:00',97,-7,89778,NULL,'','0'),
(1848,'2021-12-18 10:00:00',131,-38,89778,NULL,'','0'),
(1849,'2021-12-18 13:00:00',251,-1,89868,NULL,'','0'),
(1850,'2021-12-18 12:00:00',6,-20,87108,NULL,'','0'),
(1851,'2021-12-18 12:00:00',10,-18,87108,NULL,'','0'),
(1852,'2021-12-18 12:00:00',26,-16,87108,NULL,'','0'),
(1853,'2021-12-18 12:00:00',28,-14,87108,NULL,'','0'),
(1854,'2021-12-18 12:00:00',44,-10,87108,NULL,'','0'),
(1855,'2021-12-18 12:00:00',52,-10,87108,NULL,'','0'),
(1856,'2021-12-18 12:00:00',79,-1,87108,NULL,'','0'),
(1857,'2021-12-18 12:00:00',162,-85,87108,NULL,'','0'),
(1858,'2021-12-18 14:00:00',296,-1,89874,NULL,'','0'),
(1859,'2021-12-18 14:00:00',298,-1,89874,NULL,'','0'),
(1860,'2021-12-20 09:00:00',227,-1,89902,NULL,'','0'),
(1861,'2021-12-20 09:00:00',232,-1,89902,NULL,'','0'),
(1862,'2021-12-20 09:00:00',233,-1,89902,NULL,'','0'),
(1863,'2021-12-20 09:00:00',235,-1,89902,NULL,'','0'),
(1864,'2021-12-20 09:00:00',251,-1,89902,NULL,'','0'),
(1865,'2021-12-20 09:00:00',260,-1,89902,NULL,'','0'),
(1866,'2021-12-20 11:00:00',44,-15,87539,NULL,'','0'),
(1867,'2021-12-20 11:00:00',47,-11,87539,NULL,'','0'),
(1868,'2021-12-20 11:00:00',53,-10,87539,NULL,'','0'),
(1869,'2021-12-20 11:00:00',74,-17,87539,NULL,'','0'),
(1870,'2021-12-20 11:00:00',162,-156,87539,NULL,'','0'),
(1871,'2021-12-20 11:00:00',288,-9,87539,NULL,'','0'),
(1872,'2021-12-20 09:00:00',24,-32,88525,NULL,'','0'),
(1873,'2021-12-20 09:00:00',25,-32,88525,NULL,'','0'),
(1874,'2021-12-20 09:00:00',33,-31,88525,NULL,'','0'),
(1875,'2021-12-20 09:00:00',217,-40,88525,NULL,'','0'),
(1876,'2021-12-20 10:00:00',232,-1,89920,NULL,'','0'),
(1877,'2021-12-20 10:00:00',233,-1,89920,NULL,'','0'),
(1878,'2021-12-20 10:00:00',235,-1,89920,NULL,'','0'),
(1879,'2021-12-20 10:00:00',245,-1,89920,NULL,'','0'),
(1880,'2021-12-20 10:00:00',269,-1,89920,NULL,'','0'),
(1881,'2021-12-20 16:00:00',2,-38,88349,NULL,'','0'),
(1882,'2021-12-20 16:00:00',152,-13,88349,NULL,'','0'),
(1883,'2021-12-20 16:00:00',153,-25,88349,NULL,'','0'),
(1884,'2021-12-20 15:00:00',25,-15,89843,NULL,'','0'),
(1885,'2021-12-20 15:00:00',53,-7,89843,NULL,'','0'),
(1886,'2021-12-20 15:00:00',76,-10,89843,NULL,'','0'),
(1887,'2021-12-20 15:00:00',81,-6,89843,NULL,'','0'),
(1888,'2021-12-20 15:00:00',95,-11,89843,NULL,'','0'),
(1889,'2021-12-20 15:00:00',96,-10,89843,NULL,'','0'),
(1890,'2021-12-20 15:00:00',97,-9,89843,NULL,'','0'),
(1891,'2021-12-20 15:00:00',162,-75,89843,NULL,'','0'),
(1892,'2021-12-20 17:00:00',60,-7,89925,NULL,'','0'),
(1893,'2021-12-20 18:00:00',6,-15,89424,NULL,'','0'),
(1894,'2021-12-20 18:00:00',25,-15,89424,NULL,'','0'),
(1895,'2021-12-20 18:00:00',28,-13,89424,NULL,'','0'),
(1896,'2021-12-20 18:00:00',60,-3,89424,NULL,'','0'),
(1897,'2021-12-20 18:00:00',61,-8,89424,NULL,'','0'),
(1898,'2021-12-20 18:00:00',89,-7,89424,NULL,'','0'),
(1899,'2021-12-20 18:00:00',162,-110,89424,NULL,'','0');

INSERT INTO `materials_registr` VALUES 
(1900,'2021-12-20 18:00:00',283,-15,89424,NULL,'','0'),
(1901,'2021-12-20 20:00:00',122,-12,89930,NULL,'','0'),
(1902,'2021-12-21 09:00:00',266,-1,89945,NULL,'','0'),
(1903,'2021-12-21 11:00:00',23,-14,89779,NULL,'','0'),
(1904,'2021-12-21 11:00:00',26,-9,89779,NULL,'','0'),
(1905,'2021-12-21 11:00:00',34,-11,89779,NULL,'','0'),
(1906,'2021-12-21 11:00:00',125,-16,89779,NULL,'','0'),
(1907,'2021-12-21 11:00:00',139,-14,89779,NULL,'','0'),
(1908,'2021-12-21 11:00:00',140,-13,89779,NULL,'','0'),
(1909,'2021-12-21 10:00:00',218,-1,89946,NULL,'','0'),
(1910,'2021-12-21 11:00:00',268,-1,89947,NULL,'','0'),
(1911,'2021-12-21 12:00:00',268,-1,89951,NULL,'','0'),
(1912,'2021-12-21 13:00:00',69,-13,89955,NULL,'','0'),
(1913,'2021-12-21 13:00:00',70,-20,89955,NULL,'','0'),
(1914,'2021-12-21 13:00:00',75,-13,89955,NULL,'','0'),
(1915,'2021-12-21 13:00:00',76,-19,89955,NULL,'','0'),
(1916,'2021-12-21 14:30:00',46,-17,89875,NULL,'','0'),
(1917,'2021-12-21 14:30:00',217,-36,89875,NULL,'','0'),
(1918,'2021-12-21 14:30:00',305,-16,89875,NULL,'','0'),
(1919,'2021-12-21 15:00:00',279,-40,89926,NULL,'','0'),
(1920,'2021-12-21 13:00:00',182,-1,89970,NULL,'','0'),
(1921,'2021-12-21 13:00:00',318,-1,89970,NULL,'','0'),
(1922,'2021-12-21 16:30:00',124,-53,89883,NULL,'','0'),
(1923,'2021-12-21 16:30:00',132,-19,89883,NULL,'','0'),
(1924,'2021-12-21 16:30:00',307,-26,89883,NULL,'','0'),
(1925,'2021-12-20 11:00:00',219,-1,89972,NULL,'','0'),
(1926,'2021-12-21 16:00:00',44,-10,88900,NULL,'','0'),
(1927,'2021-12-21 16:00:00',70,-10,88900,NULL,'','0'),
(1928,'2021-12-21 16:00:00',75,-6,88900,NULL,'','0'),
(1929,'2021-12-21 16:00:00',89,-7,88900,NULL,'','0'),
(1930,'2021-12-21 16:00:00',162,-58,88900,NULL,'','0'),
(1931,'2021-12-22 09:00:00',312,-1,89987,NULL,'','0'),
(1932,'2021-12-22 10:00:00',218,-1,90003,NULL,'','0'),
(1933,'2021-12-22 09:30:00',69,-6,87836,NULL,'','0'),
(1934,'2021-12-22 09:30:00',78,-1,87836,NULL,'','0'),
(1935,'2021-12-22 09:30:00',80,-1,87836,NULL,'','0'),
(1936,'2021-12-22 09:30:00',89,-5,87836,NULL,'','0'),
(1937,'2021-12-22 09:30:00',144,-17,87836,NULL,'','0'),
(1938,'2021-12-22 09:30:00',162,-104,87836,NULL,'','0'),
(1939,'2021-12-22 09:30:00',282,-9,87836,NULL,'','0'),
(1940,'2021-12-22 09:00:00',47,-8,89296,NULL,'','0'),
(1941,'2021-12-22 09:00:00',89,-6,89296,NULL,'','0'),
(1942,'2021-12-22 09:00:00',97,-14,89296,NULL,'','0'),
(1943,'2021-12-22 09:00:00',162,-70,89296,NULL,'','0'),
(1944,'2021-12-22 09:00:00',283,-11,89296,NULL,'','0'),
(1945,'2021-12-22 09:00:00',302,-11,89296,NULL,'','0'),
(1946,'2021-12-22 13:30:00',45,-5,89783,NULL,'','0'),
(1947,'2021-12-22 13:30:00',62,-9,89783,NULL,'','0'),
(1948,'2021-12-22 13:30:00',75,-13,89783,NULL,'','0'),
(1949,'2021-12-22 13:30:00',96,-8,89783,NULL,'','0'),
(1950,'2021-12-22 13:30:00',162,-120,89783,NULL,'','0'),
(1951,'2021-12-22 13:30:00',288,-5,89783,NULL,'','0'),
(1952,'2021-12-22 17:07:56',214,2,NULL,22,'','0'),
(1953,'2021-12-22 17:07:56',302,87,NULL,22,'','0'),
(1954,'2021-12-22 17:07:56',306,87,NULL,22,'','0'),
(1955,'2021-12-22 17:07:56',324,10,NULL,22,'','0'),
(1956,'2021-12-22 17:07:56',325,87,NULL,22,'','0'),
(1957,'2021-12-22 17:07:56',326,87,NULL,22,'','0'),
(1958,'2021-12-22 17:07:56',327,87,NULL,22,'','0'),
(1959,'2021-12-22 17:07:56',328,87,NULL,22,'','0'),
(1960,'2021-12-22 17:07:56',329,87,NULL,22,'','0'),
(1961,'2021-12-22 17:09:52',330,87,NULL,23,'','0'),
(1962,'2021-12-22 13:30:00',44,-10,87806,NULL,'','0'),
(1963,'2021-12-22 13:30:00',58,-15,87806,NULL,'','0'),
(1964,'2021-12-22 13:30:00',69,-10,87806,NULL,'','0'),
(1965,'2021-12-22 13:30:00',162,-90,87806,NULL,'','0'),
(1966,'2021-12-22 13:30:00',302,-24,87806,NULL,'','0'),
(1967,'2021-12-22 13:30:00',326,-17,87806,NULL,'','0'),
(1968,'2021-12-22 19:30:00',37,-38,90017,NULL,'','0'),
(1969,'2021-12-22 17:30:00',7,-28,89355,NULL,'','0'),
(1970,'2021-12-22 17:30:00',20,-31,89355,NULL,'','0'),
(1971,'2021-12-22 17:30:00',141,-51,89355,NULL,'','0'),
(1972,'2021-12-22 17:30:00',155,-11,89355,NULL,'','0'),
(1973,'2021-12-22 17:30:00',156,-11,89355,NULL,'','0'),
(1974,'2021-12-22 17:00:00',86,-25,88440,NULL,'','0'),
(1975,'2021-12-22 17:00:00',89,-9,88440,NULL,'','0'),
(1976,'2021-12-22 17:00:00',92,-13,88440,NULL,'','0'),
(1977,'2021-12-22 07:00:00',25,-15,90018,NULL,'','0'),
(1978,'2021-12-22 07:00:00',59,-15,90018,NULL,'','0'),
(1979,'2021-12-22 07:00:00',79,-2,90018,NULL,'','0'),
(1980,'2021-12-22 07:00:00',288,-14,90018,NULL,'','0'),
(1981,'2021-12-23 09:00:00',125,-45,87174,NULL,'','0'),
(1982,'2021-12-23 09:00:00',281,-45,87174,NULL,'','0'),
(1983,'2021-12-23 09:00:00',218,-2,90025,NULL,'','0'),
(1984,'2021-12-23 10:00:00',243,-1,90030,NULL,'','0'),
(1985,'2021-12-23 11:00:00',59,-8,88686,NULL,'','0'),
(1986,'2021-12-23 11:00:00',68,-12,88686,NULL,'','0'),
(1987,'2021-12-23 11:00:00',79,-1,88686,NULL,'','0'),
(1988,'2021-12-23 11:00:00',288,-8,88686,NULL,'','0'),
(1989,'2021-12-23 10:30:00',43,-16,90041,NULL,'','0'),
(1990,'2021-12-23 10:30:00',45,-16,90041,NULL,'','0'),
(1991,'2021-12-23 11:00:00',250,-2,90042,NULL,'','0'),
(1992,'2021-12-23 13:15:00',143,-16,89898,NULL,'','0'),
(1993,'2021-12-23 13:15:00',144,-10,89898,NULL,'','0'),
(1994,'2021-12-23 13:15:00',153,-8,89898,NULL,'','0'),
(1995,'2021-12-23 13:15:00',162,-35,89898,NULL,'','0'),
(1996,'2021-12-23 13:15:00',283,-6,89898,NULL,'','0'),
(1997,'2021-12-23 13:15:00',314,-10,89898,NULL,'','0'),
(1998,'2021-12-23 12:00:00',44,-11,88078,NULL,'','0'),
(1999,'2021-12-23 12:00:00',76,-12,88078,NULL,'','0'),
(2000,'2021-12-23 12:00:00',92,-10,88078,NULL,'','0'),
(2001,'2021-12-23 12:00:00',162,-98,88078,NULL,'','0'),
(2002,'2021-12-23 12:00:00',317,-11,88078,NULL,'','0'),
(2003,'2021-12-23 12:00:00',325,-9,88078,NULL,'','0'),
(2004,'2021-12-23 16:00:00',25,-11,88961,NULL,'','0'),
(2005,'2021-12-23 16:00:00',45,-15,88961,NULL,'','0'),
(2006,'2021-12-23 16:00:00',47,-7,88961,NULL,'','0'),
(2007,'2021-12-23 16:00:00',48,-12,88961,NULL,'','0'),
(2008,'2021-12-23 16:00:00',80,-1,88961,NULL,'','0'),
(2009,'2021-12-23 16:00:00',82,-9,88961,NULL,'','0'),
(2010,'2021-12-23 16:00:00',162,-130,88961,NULL,'','0'),
(2011,'2021-12-23 16:00:00',217,-19,88961,NULL,'','0'),
(2012,'2021-12-23 16:00:00',162,-94,89084,NULL,'','0'),
(2013,'2021-12-23 16:00:00',303,-25,89084,NULL,'','0'),
(2014,'2021-12-23 16:00:00',328,-17,89084,NULL,'','0'),
(2015,'2021-12-24 09:00:00',276,-1,90071,NULL,'','0'),
(2016,'2021-12-24 10:00:00',269,-1,90073,NULL,'','0'),
(2017,'2021-12-24 11:00:00',268,-1,90098,NULL,'','0'),
(2018,'2021-12-24 12:47:48',218,5,NULL,24,'','0'),
(2019,'2021-12-24 12:47:48',219,5,NULL,24,'','0'),
(2020,'2021-12-24 12:47:48',309,1,NULL,24,'','0'),
(2021,'2021-12-24 12:47:48',310,1,NULL,24,'','0'),
(2022,'2021-12-24 12:47:48',312,2,NULL,24,'','0'),
(2023,'2021-12-24 12:47:48',319,2,NULL,24,'','0'),
(2024,'2021-12-24 12:00:00',219,-1,90099,NULL,'','0'),
(2025,'2021-12-24 13:00:00',23,-19,87700,NULL,'','0'),
(2026,'2021-12-24 13:00:00',125,-16,87700,NULL,'','0'),
(2027,'2021-12-24 13:00:00',307,-17,87700,NULL,'','0'),
(2028,'2021-12-24 13:00:00',219,-1,90113,NULL,'','0'),
(2029,'2021-12-24 11:00:00',24,-31,86999,NULL,'','0'),
(2030,'2021-12-24 11:00:00',25,-26,86999,NULL,'','0'),
(2031,'2021-12-24 11:00:00',28,-18,86999,NULL,'','0'),
(2032,'2021-12-24 11:00:00',44,-28,86999,NULL,'','0'),
(2033,'2021-12-24 11:00:00',162,-210,86999,NULL,'','0'),
(2034,'2021-12-24 11:00:00',212,-8,86999,NULL,'','0'),
(2035,'2021-12-24 11:00:00',302,-18,86999,NULL,'','0'),
(2036,'2021-12-24 11:00:00',317,-27,86999,NULL,'','0'),
(2037,'2021-12-24 14:00:00',294,-1,90118,NULL,'','0'),
(2038,'2021-12-25 09:00:00',45,-4,88597,NULL,'','0'),
(2039,'2021-12-25 09:00:00',59,-6,88597,NULL,'','0'),
(2040,'2021-12-25 09:00:00',91,-10,88597,NULL,'','0'),
(2041,'2021-12-25 09:00:00',96,-7,88597,NULL,'','0'),
(2042,'2021-12-25 09:00:00',97,-11,88597,NULL,'','0'),
(2043,'2021-12-25 09:00:00',162,-95,88597,NULL,'','0'),
(2044,'2021-12-25 09:00:00',302,-16,88597,NULL,'','0'),
(2045,'2021-12-25 09:00:00',232,-1,90130,NULL,'','0'),
(2046,'2021-12-25 09:00:00',233,-1,90130,NULL,'','0'),
(2047,'2021-12-25 09:00:00',235,-1,90130,NULL,'','0'),
(2048,'2021-12-27 09:00:00',187,-1,90135,NULL,'','0'),
(2049,'2021-12-27 09:22:20',2,88,NULL,25,'','0'),
(2050,'2021-12-27 09:22:20',4,88,NULL,25,'','0'),
(2051,'2021-12-27 09:22:20',23,88,NULL,25,'','0'),
(2052,'2021-12-27 09:22:20',27,88,NULL,25,'','0'),
(2053,'2021-12-27 09:22:20',34,88,NULL,25,'','0'),
(2054,'2021-12-27 09:22:20',162,1000,NULL,25,'','0'),
(2055,'2021-12-27 09:22:20',323,88,NULL,25,'','0'),
(2056,'2021-12-27 11:00:00',324,-1,90153,NULL,'','0'),
(2057,'2021-12-27 09:30:00',23,-17,89542,NULL,'','0'),
(2058,'2021-12-27 09:30:00',25,-14,89542,NULL,'','0'),
(2059,'2021-12-27 09:30:00',46,-18,89542,NULL,'','0'),
(2060,'2021-12-27 09:30:00',68,-20,89542,NULL,'','0'),
(2061,'2021-12-27 09:30:00',79,-1,89542,NULL,'','0'),
(2062,'2021-12-27 09:30:00',80,-1,89542,NULL,'','0'),
(2063,'2021-12-27 09:30:00',305,-12,89542,NULL,'','0'),
(2064,'2021-12-27 12:00:00',219,-1,90167,NULL,'','0'),
(2065,'2021-12-27 13:00:00',229,-1,90170,NULL,'','0'),
(2066,'2021-12-27 13:00:00',233,-1,90170,NULL,'','0'),
(2067,'2021-12-27 13:00:00',234,-1,90170,NULL,'','0'),
(2068,'2021-12-27 13:00:00',237,-1,90170,NULL,'','0'),
(2069,'2021-12-27 10:00:00',162,-68,85623,NULL,'','0'),
(2070,'2021-12-27 10:00:00',282,-18,85623,NULL,'','0'),
(2071,'2021-12-27 10:00:00',329,-26,85623,NULL,'','0'),
(2072,'2021-12-27 11:30:00',130,-27,88474,NULL,'','0'),
(2073,'2021-12-27 11:30:00',132,-22,88474,NULL,'','0'),
(2074,'2021-12-27 11:30:00',305,-27,88474,NULL,'','0'),
(2075,'2021-12-27 14:00:00',318,-2,90182,NULL,'','0'),
(2076,'2021-12-27 15:00:00',296,-1,90189,NULL,'','0'),
(2077,'2021-12-27 15:00:00',298,-1,90189,NULL,'','0'),
(2078,'2021-12-27 13:30:00',47,-10,88631,NULL,'','0'),
(2079,'2021-12-27 13:30:00',89,-9,88631,NULL,'','0'),
(2080,'2021-12-27 13:30:00',92,-14,88631,NULL,'','0'),
(2081,'2021-12-27 13:30:00',97,-10,88631,NULL,'','0'),
(2082,'2021-12-27 13:30:00',162,-70,88631,NULL,'','0'),
(2083,'2021-12-27 13:30:00',302,-17,88631,NULL,'','0'),
(2084,'2021-12-27 13:30:00',323,-12,88631,NULL,'','0'),
(2085,'2021-12-27 14:00:00',54,-3,86742,NULL,'','0'),
(2086,'2021-12-27 14:00:00',69,-15,86742,NULL,'','0'),
(2087,'2021-12-27 14:00:00',70,-11,86742,NULL,'','0'),
(2088,'2021-12-27 14:00:00',80,-1,86742,NULL,'','0'),
(2089,'2021-12-27 14:00:00',89,-7,86742,NULL,'','0'),
(2090,'2021-12-27 14:00:00',115,-21,86742,NULL,'','0'),
(2091,'2021-12-27 14:00:00',162,-55,86742,NULL,'','0'),
(2092,'2021-12-27 14:00:00',329,-18,86742,NULL,'','0'),
(2093,'2021-12-27 18:00:00',45,-25,90181,NULL,'','0'),
(2094,'2021-12-27 18:00:00',68,-20,90181,NULL,'','0'),
(2095,'2021-12-27 18:00:00',77,-18,90181,NULL,'','0'),
(2096,'2021-12-27 18:00:00',146,-24,90181,NULL,'','0'),
(2097,'2021-12-28 09:00:00',276,-1,90231,NULL,'','0'),
(2098,'2021-12-28 10:00:00',2,-20,87851,NULL,'','0'),
(2099,'2021-12-28 10:00:00',25,-30,87851,NULL,'','0'),
(2100,'2021-12-28 10:00:00',71,-18,87851,NULL,'','0'),
(2101,'2021-12-28 10:00:00',162,-220,87851,NULL,'','0'),
(2102,'2021-12-28 10:00:00',302,-15,87851,NULL,'','0'),
(2103,'2021-12-28 10:00:00',303,-20,87851,NULL,'','0'),
(2104,'2021-12-28 10:00:00',306,-20,87851,NULL,'','0'),
(2105,'2021-12-28 10:00:00',323,-20,87851,NULL,'','0'),
(2106,'2021-12-28 14:00:00',33,-21,88955,NULL,'','0'),
(2107,'2021-12-28 14:00:00',125,-12,88955,NULL,'','0'),
(2108,'2021-12-28 14:00:00',130,-46,88955,NULL,'','0'),
(2109,'2021-12-28 10:00:00',209,-1,90242,NULL,'','0'),
(2110,'2021-12-28 10:00:00',218,-1,90242,NULL,'','0'),
(2111,'2021-12-28 10:00:00',320,-1,90242,NULL,'','0'),
(2112,'2021-12-28 11:00:00',205,-1,90243,NULL,'','0'),
(2113,'2021-12-28 09:00:00',5,-28,86952,NULL,'','0'),
(2114,'2021-12-28 09:00:00',80,-5,86952,NULL,'','0'),
(2115,'2021-12-28 09:00:00',162,-188,86952,NULL,'','0'),
(2116,'2021-12-28 09:00:00',302,-14,86952,NULL,'','0'),
(2117,'2021-12-28 09:00:00',326,-24,86952,NULL,'','0'),
(2118,'2021-12-28 09:00:00',329,-19,86952,NULL,'','0'),
(2119,'2021-12-28 14:00:00',4,-13,86159,NULL,'','0'),
(2120,'2021-12-28 14:00:00',18,-17,86159,NULL,'','0'),
(2121,'2021-12-28 14:00:00',23,-84,86159,NULL,'','0'),
(2122,'2021-12-28 14:00:00',25,-33,86159,NULL,'','0'),
(2123,'2021-12-28 14:00:00',28,-23,86159,NULL,'','0'),
(2124,'2021-12-28 14:00:00',97,-5,86159,NULL,'','0'),
(2125,'2021-12-28 14:00:00',162,-80,86159,NULL,'','0'),
(2126,'2021-12-28 14:00:00',326,-9,86159,NULL,'','0'),
(2127,'2021-12-28 16:00:00',4,-28,89383,NULL,'','0'),
(2128,'2021-12-28 16:00:00',18,-12,89383,NULL,'','0'),
(2129,'2021-12-28 16:00:00',126,-36,89383,NULL,'','0'),
(2130,'2021-12-